/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: events.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// STD/EVENTS.C -- standard event modul
//
// Holger@Wunderland 4/99
// 
// $Revision: 1.1.1.1 $
//
// $Log: events.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//

#include <events.h>

static varargs int listen_event(string type, int prio, mixed callback) {
  if(!callback)
    callback="receive_event";
  if(stringp(callback))
    callback=symbol_function(callback, this_object());
  if(!closurep(callback))
    return 0;
  return EVENTD->listen(type, prio, callback);
}

static int unlisten_event(string type, int prio, mixed callback) {
  if(!callback)
    callback="receive_event";
  if(stringp(callback))
    callback=symbol_function(callback, this_object());
  if(!closurep(callback))
    return 0;
  return EVENTD->unlisten(type, prio, callback);
}

static varargs void set_global_listener(string type, status listening) {
  return EVENTD->set_global(type, listening);
}

static varargs mixed *send_event(string type, mapping data, mixed dest, mixed flag) {
  if(!pointerp(dest)) {
    if (objectp(dest))
      dest = ({ dest });
    else
      dest = ({});
  }
  return EVENTD->send(type, data, dest, flag);
}

static varargs void cancel_event(mixed info) {
  EVENTD->cancel(info);
}

