/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: food.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
//
// STD/FOOD.C -- 
//   Standardessen. Ist sofort clonbar. Setzt fuer nahezu alles 
//   Standardwerte. Dokumentationen sind per man-Befehl erreichbar.
//   Man pages: food, P_PIECES, P_FILL, P_ROTT, P_EAT, P_TASTE, P_HEAL
//
// Autor: Holger@Wunderland
// Datum: 27.08.1997
//
// $Revision: 1.1.1.1 $
//
// $Log: food.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/04 23:47:27  Largo
// Initial revision
//

inherit "std/thing";

#include <defines.h>
#include <properties.h>

#define NEED_PROTOTYPES

#include <food.h>

#define LOG(x) log_file("food.log", x)

#pragma strong_types

private int initiated, is_adj, orig_teile, orig_heil;
private string extrainfo;

void create() {
    ::create();
    SetProp( P_LONG,"Ein Standardessen ohne jegliche Beschreibung.");
    SetProp( P_NAME, "Essen");
    SetProp( P_PLURAL, "Essen");
    SetProp( P_GENDER, NEUTER);
    SetProp( P_VALUE, 5);
    SetProp( P_WEIGHT, 100);
    SetProp( P_HEAL, 15);
    SetProp( P_PIECES, 3);
    SetProp( P_FILL, 20);
    SetProp( P_ROTT, 3600);
    SetProp( P_DC_NAME1, "Ungeniessbares Essen");
    SetProp( P_EAT,({
          "Du isst das Essen restlos auf.",
          "&&WER&& isst etwas restlos auf.",
          "Du beisst ein Stueck von dem Essen ab.",
          "&&WER&& beisst ein Stueck von etwas ab."}) );
    SetProp( P_TASTE, "Es schmeckt ganz normal." );
    AddId("essen","essen");

    AddDetail(({"geruch","duft","gestank"}), 
        "Du musst schon daran riechen!\n");
    AddDetail(({"geschmack"}), 
        "Da musst Du schonmal kosten!\n");
    AddDetail(({"geraeusch"}), 
        "Da musst Du schonmal dran lauschen!\n");

    initiated=0;
    is_adj=0;
    orig_teile=0;
    orig_heil=0;

    AddCmd(({"esse","iss"}),"essen");
    AddCmd(({"beisse","beiss"}), "beissen");
    AddCmd(({"koste","kost"}), "kosten");
}

// Im init() werden beim ersten Aufruf wichtige Variablen gesetzt:
// initiated  - enthaelt die Zeit des ersten init() Aufrufs
// orig_heil  - enthaelt den Wert von P_HEAL des Objekts
// orig_teile - enthaelt die Anzahl der Teile beim Clonen
// is_adj     - ist 1, wenn ein P_NAME_ADJ gesetzt wurde
// Weiterhin wird geprueft, ob P_PIECES mindestens 1 ist und
// P_ROTT>-1 ist!.
void init() {
    ::init();
    if (!initiated) {
        initiated=time();
        orig_heil=QueryProp(P_HEAL);
        if (sizeof(QueryProp(P_NAME_ADJ))>0) is_adj=1;
        orig_teile=QueryProp(P_PIECES);
        if (QueryProp(P_PIECES)<1) {
            LOG((string)ME+": P_PIECES < 1 -> removed!\n");
            if (environment(ME)) {
              tell_object(environment(ME), "P_PIECES darf nicht < 1 sein!\n"
                  "Object wird removed!\n");
            }
            remove();
        }
        else if (QueryProp(P_ROTT)<0) {
            LOG((string)ME+": P_ROTT < 0 -> removed!\n");
            if (environment(ME)) {
                tell_object(environment(ME), "P_ROTT darf nicht < 0 sein!\n"
                    "Object wird removed!\n");
            }
            remove();
        }
    }
}

// eat_all() wird aufgerufen, wenn entweder nurnoch ein Teil da ist, oder
// alles auf einmal gegessen wird.
void eat_all() {
    string *eat, out;
    int health;
    object raum;

    raum=environment(PL);
    eat=QueryProp(P_EAT);
    health=PL->QueryProp(P_HP);

    if (PL->eat_food(QueryProp(P_FILL))) {
        if (sizeof(eat)>0) out=mess(eat[0],2);
        else out="Du isst "+name(WEN,2)+" restlos auf.";
        if(strlen(QueryProp(P_TASTE))>0)
          out+=" "+mess(QueryProp(P_TASTE),2);
        tell_object(PL,break_string(out));

        if (sizeof(eat)>1) out=mess(eat[1],2);
        else out=capitalize(PL->name(WER,1))+" isst "+
                   name(WEN,2)+" restlos auf.";
        if (raum) tell_room(raum, break_string(out), ({PL}));

        if (QueryProp(P_HEAL)>0) PL->heal_self(QueryProp(P_HEAL));
        else PL->do_damage(abs(QueryProp(P_HEAL)), ME);

        if (PL && !PL->QueryProp(P_GHOST)) {
            if (PL->QueryProp(P_HP)>health) 
                out="Du fuehlst Dich gleich etwas besser.";
            if (PL->QueryProp(P_HP)<health) 
                out="Du fuehlst Dich auf einmal nicht mehr so gut.";
            if (PL->QueryProp(P_HP)==health) 
                out="Du fuehlst Dich nicht besser als vorher.";
            tell_object(PL,break_string(out));
        }
    
        remove();
    }
    else {
        out=capitalize(PL->name(WER,1))+" versucht "+
                   name(WEN,2)+" zu essen, schafft es aber nicht mehr.";
        if (raum) tell_room(raum, break_string(out), ({PL}));
    }
    return;
}

// eat_piece() wird aufgerufen, wenn ein einzelnes Stueck abgebissen wird.
void eat_piece() {
    string *eat, out;
    int teile, p_heal, heal, p_fill, fill;
    int health;
    object raum;

    raum=environment(PL);
    teile=QueryProp(P_PIECES);
    health=PL->QueryProp(P_HP);
    fill=QueryProp(P_FILL);
    heal=QueryProp(P_HEAL);
    p_fill=fill/teile;
    p_heal=heal/teile;
    eat=QueryProp(P_EAT);

    if (PL->eat_food(p_fill)) {
        if (sizeof(eat)>2) out=mess(eat[2],2);
        else out="Du beisst ein Stueck von "+name(WEM,2)+" ab.";
        if(strlen(QueryProp(P_TASTE))>0) out+=" "+mess(QueryProp(P_TASTE),2);
        tell_object(PL,break_string(out));

        if (sizeof(eat)>3) out=mess(eat[3],2);
        else out=capitalize(PL->name(WER,1))+" beisst ein Stueck von "+
                   name(WEM,2)+" ab.";
        if (raum) tell_room(raum, break_string(out), ({ PL }));

        if (p_heal>0) PL->heal_self(p_heal);
        else PL->do_damage(abs(p_heal), ME);

        SetProp(P_HEAL, heal-p_heal);
        SetProp(P_FILL, fill-p_fill);
        SetProp(P_PIECES, teile-1);

        if (PL && !PL->QueryProp(P_GHOST)) {
            if (PL->QueryProp(P_HP)>health) 
                out="Du fuehlst Dich gleich etwas besser.";
            if (PL->QueryProp(P_HP)<health) 
                out="Du fuehlst Dich auf einmal nicht mehr so gut.";
            if (PL->QueryProp(P_HP)==health) 
                out="Du fuehlst Dich nicht besser als vorher.";
            tell_object(PL,break_string(out));
        }
    
    }
    else {
        out=capitalize(PL->name(WER,1))+" versucht ein Stueck von "+
              name(WEM,2)+" abzubeissen, schafft es aber nicht mehr.";
        if (raum) tell_room(raum, break_string(out), ({PL}));
    }
    return;
}

// essen() wird aufgerufen durch "esse" oder "iss". Es wird das Aussehen
// des Objekts gesetzt ueber set_look() und dann wird eat_all() aufgerufen.
int essen(string str) {
    notify_fail("Was willst Du essen?\n");
    if ((!str) || (!id(str))) return 0;
    set_look();
    eat_all();
    return 1;
}

// beissenn() wird aufgerufen durch "beiss" oder "beisse". Es wird das 
// Aussehen des Objekts gesetzt ueber set_look() und dann wird eat_piece()
// aufgerufen. Wenn nur noch ein einzelnes Teil da ist, wird eat_all()
// aufgerufen
int beissen(string str) {
    string was;
    notify_fail("In was willst Du beissen?\n");
    if (!str) return 0;
    if (sscanf(str,"in %s",was)!=1) {
        if (sscanf(str,"von %s ab",was)!=1) was=str;
    }
    if (!id(was)) return 0;
    set_look();
    if (QueryProp(P_PIECES)==1) eat_all();
    else eat_piece();
    return 1;
}

// kosten() wird durch "kost" oder "koste" aufgerufen. Es wird dann
// set_look() aufgerufen und dann der entsprechende text ausgegeben.
int kosten(string str) {
    string out, was;
    object raum;
    notify_fail("Was willst Du kosten?\n");
    if (!str) return 0;
    if (sscanf(str,"an %s",was)!=1) was=str;
    if (!id(was)) return 0;

    set_look();

    raum=environment(PL);

    out="Du knabberst vorsichtig an "+name(WEM,2)+". ";
    if (strlen(QueryProp(P_TASTE))>0) out+=mess(QueryProp(P_TASTE),2);
    tell_object(PL,break_string(out));

    out=capitalize(PL->name(WER,1))+" knabbert vorsichtig an "+
       name(WEM,0)+" herum.";
    if (raum) tell_room(raum, break_string(out), ({PL}));

    return 1;
}

// zustand() gibt je nach Prozentangabe eine Wortgruppe zurueck.
static string zustand(int prozent) {
    switch(prozent) {
        case 0 .. 14: 
            return " und es ist nur noch ein kleiner Happen da.";
        case 15 .. 29: 
            return " und es ist nicht mehr sehr viel uebrig.";
        case 30 .. 44: 
            return " und etwas mehr als die Haelfte fehlt schon.";
        case 45 .. 55: 
            return " und etwa die Haelfte ist gegessen worden.";
        case 56 .. 68: 
            return " und es fehlt ein groesseres Stueck.";
        case 69 .. 84: 
            return " und es fehlt ein Stueck davon.";
        case 85 .. 99: 
         return " und es ist erst ein kleines Stueckchen abgebissen worden.";
        case 100: 
            return ".";
    }
    return " und man kann nicht sagen, wieviel schon fehlt.";
}

// frische() gibt je nach Prozentangabe eine Wortgruppe zurueck.
static string frische(int prozent) {
    string was;
    was=" "+capitalize(QueryPronoun(WER));
    switch(prozent) {
        case 0..9: 
            return was+" ist total vermodert";
        case 10..19: 
            return was+" sieht widerlich aus";
        case 20..29: 
            return was+" ist teilweise verschimmelt";
        case 30..39: 
            return was+" ist etwas angegammelt";
        case 40..49: 
            return was+" sieht nicht sehr appetitlich aus";
        case 50..59: 
            return was+" sieht nicht mehr ganz so gut aus";
        case 60..69: 
            return was+" ist nicht mehr ganz so frisch";
        case 70..79: 
            return was+" wirkt noch einigermassen frisch";
        case 80..89: 
            return was+" sieht noch ganz gut aus";
        case 90..95: 
            return was+" ist noch ziemlich frisch";
        case 96..100: 
            return was+" ist noch ganz frisch";
    }
    return was+" sieht irgendwie komisch aus";
}

// geruch() gibt je nach Prozentangabe eine Wortgruppe zurueck.
static string geruch(int prozent) {
    string was;
    was=capitalize(QueryPronoun(WER));
    switch(prozent) {
        case 0..19: 
            return was+" riecht abscheulich. Es hebt Dich fast!";
        case 20..39: 
            return was+" riecht ziemlich muffig.";
        case 40..59: 
            return was+" riecht nicht mehr so gut.";
    }
    return QueryProp(P_SMELL);
}

// geschmack() gibt je nach Prozentangabe eine Wortgruppe zurueck.
static string geschmack(int prozent) {
    string was;
    was=capitalize(QueryPronoun(WER));
    switch(prozent) {
        case 0..19: 
            return was+" schmeckt absolut eklig! Du uebergibst Dich fast!";
        case 20..39: 
            return was+" schmeckt irgendwie muffig.";
        case 40..59: 
            return was+" schmeckt nicht besonders gut.";
    }
    return QueryProp(P_TASTE);
}

// geraeusch() gibt je nach Prozentangabe eine Wortgruppe zurueck.
static string geraeusch(int prozent) {
    switch(prozent) {
        case 0..19: 
            return "Du hoerst ganz deutlich die kleinen fetten Maden darin "
            "kriechen.";
    }
    return QueryProp(P_SOUND);
}

// adjektiv() gibt je nach Prozentangabe ein Adjektiv zurueck.
static string adjektiv(int prozent) {
    switch(prozent) {
        case 0..29: return "eklig";
        case 30..49: return "unappetitlich";
        case 50..69: return "lecker";
        case 70..100: return "frisch";
    }
    return "merkwuerdig";
}

// heile() gibt je nach Prozentangabe den Heilwert zurueck.
static int heile(int prozent) {
    switch(prozent) {
        case 0 .. 9: return -15;
        case 10 .. 19: return -10;
        case 20 .. 30: return 0;
    }
    return QueryProp(P_HEAL);
}

// set_look() ist die Kernfunktion des food.c. Hier wird je nach dem Zustand
// und dem Alter des Essens, das Aussehen, der Geruch, der Geschmack und
// wenns ganz eklig wird, auch das Geraeusch gesetzt! ;)) Wenn das Alter
// des Objekts groesser als P_ROTT ist, wird das Objekt zerstoert. Die
// relevanten Properties werden gesetzt:
// P_SMELL, P_SOUND, P_TASTE, P_HEAL
// Die globale Variable extrainfo erhaelt den Teil, der an P_LONG
// angehaengt wird beim untersuchen.
// Wenn kein P_NAME_ADJ gesetzt ist, wird P_NAME_ADJ auch gesetzt!
static void set_look() {
    string lang, str1, str2, name_adj;
    int heal, alter, verfall, zeit, zust, fri;

    if (!initiated) return;

    lang=QueryProp(P_LONG);
    heal=QueryProp(P_HEAL);

    alter=time()-initiated;
    // Wenn P_ROTT==0 dann altere niemals!
    if (!QueryProp(P_ROTT)) alter=0;

    verfall=QueryProp(P_ROTT);
    if (verfall<1) verfall=1; // <1 gesetzt - Archon
    zeit=verfall-alter;

    if (zeit<1) fri=0;
    else fri=(zeit*100)/verfall;

    // veraendern gemaess Frische
    SetProp(P_SMELL,geruch(fri));
    SetProp(P_SOUND,geraeusch(fri));
    SetProp(P_HEAL,heile(fri));
    SetProp(P_TASTE,geschmack(fri));

    zust=(QueryProp(P_PIECES)*100)/orig_teile;
    extrainfo=break_string(frische(fri)+zustand(zust));

    if (!is_adj) SetProp(P_NAME_ADJ,adjektiv(fri));

    if (fri==0) call_out( "throw", 1);

    return;
}

// Beim untersuchen wird set_look() aufgerufen und die extrainfo ueber den
// Zustand wird angehaengt.
string long() {
    set_look();
    return ::long()+extrainfo;
}

// Beim bewegen wird set_look() aufgerufen.
int move(object dest, int method) {
    set_look();
    return ::move(dest, method);
}

void throw() {
    object env, raum;
    env=environment(ME);
    if (env) raum=environment(env);
    if (living(env)) {
        tell_object(env,break_string("Du nimmst "+name(WEN,2)+
          " angewidert aus Deiner Tasche und wirfst "+
          QueryPronoun(WEN)+" weit weg. Du "
            "aergerst Dich, dass Du "+QueryPronoun(WEN)+" hast "
            "verschimmeln lassen!"));
        if (raum) 
        tell_room(env,break_string(PL->name(WER,2)+" nimmt "+name(WEN,0)+
            " aus der Tasche und wirft "+QueryPronoun(WEN)+" grummelnd "
            " weg."), ({PL}));
    }
    else {
        if (env) tell_object(env,break_string("Insekten machen sich ueber "+
            name(WEN,2)+" her und schon nach wenigen Augenblicken ist "+
            QueryPronoun(WEN)+" verschwunden."));
    }
    remove();
    return;
}

// mess() geklaut aus player.c (Danke dem Autor). Meiner Meinung nach
// durch regreplace optinmiert oder zumindest uebersichtlicher. ;)
// Ersetzt die Schluesselworte im string. Flag gibt die Moeglichkeit, 
// die Pronomensetzung zu beeinflussen.
private string mess(string str,int flag) {
  if (!stringp(str) || str=="" || strstr(str,"&",0)==-1) return str;
  str=regreplace(str,"&&WER&&",PL->name(WER,flag),1);
  str=regreplace(str,"&&WESSEN&&",PL->name(WESSEN,flag),1);
  str=regreplace(str,"&&WEM&&",PL->name(WEM,flag),1);
  str=regreplace(str,"&&WEN&&",PL->name(WEN,flag),1);
  str=regreplace(str,"&&",PL->name(WER,flag),1);
  str=regreplace(str,"&!WER!&",PL->QueryPronoun(WER),1);
  str=regreplace(str,"&!WESSEN!&",PL->QueryPronoun(WESSEN),1);
  str=regreplace(str,"&!WEM!&",PL->QueryPronoun(WEM),1);
  str=regreplace(str,"&!WEN!&",PL->QueryPronoun(WEN),1);
  str=regreplace(str,"&!",PL->QueryPronoun(WER),1);
  str=regreplace(str,"&%WER%&",PL->QueryPossPronoun(MALE,WER),1);
  str=regreplace(str,"&%WESSEN%&",PL->QueryPossPronoun(MALE,WESSEN),1);
  str=regreplace(str,"&%WEM%&",PL->QueryPossPronoun(MALE,WEM),1);
  str=regreplace(str,"&%WEN%&",PL->QueryPossPronoun(MALE,WEN),1);
  str=regreplace(str,"&%FWER%&",PL->QueryPossPronoun(FEMALE,WER),1);
  str=regreplace(str,"&%FWESSEN%&",PL->QueryPossPronoun(FEMALE,WESSEN),1);
  str=regreplace(str,"&%FWEM%&",PL->QueryPossPronoun(FEMALE,WEM),1);
  str=regreplace(str,"&%FWEN%&",PL->QueryPossPronoun(FEMALE,WEN),1);
  str=regreplace(str,"&%NWER%&",PL->QueryPossPronoun(NEUTER,WER),1);
  str=regreplace(str,"&%NWESSEN%&",PL->QueryPossPronoun(NEUTER,WESSEN),1);
  str=regreplace(str,"&%NWEM%&",PL->QueryPossPronoun(NEUTER,WEM),1);
  str=regreplace(str,"&%NWEN%&",PL->QueryPossPronoun(NEUTER,WEN),1);
  str=regreplace(str,"&%",PL->QueryPossPronoun(MALE,WER),1);
  return capitalize(str);
}

// Beim lauschen wird set_look() aufgerufen.
static mapping _query_sound_details() {
    set_look();
    return ::_query_sound_details();
}

// Beim riechen wird set_look() aufgerufen.
static mapping _query_smell_details() {
    set_look();
    return ::_query_smell_details();
}
