/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: guild.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
//
// basierend auf der Wunderland MUDlib
//
// STD/GUILD.C -- Standard-Gilde
//
// Autoren: Andara & Arachna, 1994
//
// Credits to kirk@morgengrauen
//
// $Log: guild.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.3  1999/09/07 11:49:39  Largo
// BS_STDLEN weg
//
// Revision 1.2  1999/08/10 12:24:53  Largo
// Zeitungsautomaten ausgebaut
//
// Revision 1.1  1999/08/01 18:51:59  Largo
// Initial revision
//
 
inherit "std/room";
 
#include <properties.h>
#include <wizlevels.h>
#include <guildmaster.h>
#include <defines.h>

#define NEED_PROTOTYPES

#include <guilds.h>    

#pragma strong_types

string zeige_reboot();

void create() {
  ::create();
  SetProp( P_LIGHT, 1 );
  SetProp( P_INDOORS, 1 );
  SetProp( P_INT_SHORT, "Standardgilde");
  SetProp( P_INT_LONG,
	  "Du befindest Dich in der Standardgilde.\n"
	  "Der Magier, der diese Gile schuf, war wohl zu faul, "
	  "sich eine eigene Raumbeschreibung auszudenken...\n"
	  "An der Wand siehst Du eine grosse Uhr.\n"
	  "Moegliche Befehle sind:\n"
	  "             erhoehe (stufe|intelligenz|kraft|\n"
	  "                      geschicklichlkeit|ausdauer)\n"
	  "             kosten\n"
	  "             liste(abenteuer|gilden|gildenabenteuer|\n"
          "                  zaubersprueche|faehigkeiten|\n"
	  "                  aufnahmebedingungen|\n"
	  "                  eigenschaften|austritt|erhoehen)\n"
          "            zauberei name\n"
	  "            beitreten\n"
          "            verlasse\n");
 
  AddDetail("uhr",#'zeige_reboot);

  AddCmd(({"beitreten", "eintreten"}), "join");
  AddCmd(({"verlasse","verlassen"}),"leave");
  AddCmd("zauberei", "ShowDescription");
  AddCmd("kosten","_kosten_");
  AddCmd("liste","show_all");
  AddCmd("erhoehe","_advance_");
  AddCmd("lerne", "learn");

  AddItem("/obj/kalender",REFRESH_REMOVE);
 
  // Name der Gilde
  SetProp(P_GUILD_NAME, "/std/guild");
 
  // Eintritt ab Level 1
  SetProp(P_MIN_LEVEL, 1);
 
  // Mindest Stats
  SetProp(P_MIN_STATS, ({1,1,1,1}));
 
  // Maximal Stats
  SetProp(P_GUILD_STATMODS, ([A_INT : 0, A_DEX : 0, A_STR : 0, A_CON : 0,
				A_CHA : 0]));

  // Gilden Skills/Spells
  SetProp(P_GUILD_SKILLS, ({}));
 
  // Relativierung der Stat-Steigerungen im Normalfall nicht vorhanden,
  // (normaler Wert = 10, besser steigern > 10, schlechter steigern < 10,
  // doppelte Steigerung = 20, etc
  SetProp(P_GUILD_FACTOR, ({10,10,10,10,10}));
 
  // Titel der Gilde ({ ({maennlich}), ({weiblich}) })
  SetProp(P_GUILD_TITLES, ({
   ({ "der Tollpatsch",
      "der Streuner",
      "der Pilger",
      "der Tollkuehne",
      "der Vagabund",
      "der Recke",
      "der Faehrtensucher",
      "der Buerger",
      "der Bannloeser",
      "der Reisende",
      "der Kaempfer",
      "der Husar",
      "der Kleriker",
      "der Druide",
      "der Edelmann",
      "der Illusionist",
      "der Zauberkundige",
      "der Paladin",
      "der Priester",
      "der Seher" }),
   ({ "die Anfaengerin",
      "die Streunerin",
      "die Pilgerin",
      "die Tollkuehne",
      "die Vagabundin",
      "die Abenteurerin",
      "die Faehrtensucherin",
      "die Buergerin",
      "die Bannloeserin",
      "die Reisende",
      "die Kaempferin",
      "die Husarin",
      "die Heilerin",
      "die Druidin",
      "das Edelfraeulein",
      "die Illusionistin",
      "die Zauberkundige",
      "die Hexe",
      "die Fee",
      "die Heilige" }) }) );
 
  // Notige Erfahrungspunkte zum erhoehen
  SetProp(P_GUILD_EXP,
    ({0,1014, 1522, 2283, 3425,
      5138, 7707, 11561, 17341, 26012,
      39018, 58527, 77791, 97791, 131687,
      197530, 296296, 444444, 666666, 1000000,
      1500000, 2250000, 3375000, 5062500, 7600000,
      11400000, 17100000, 25600000, 38500000, 57500000,
      86250000, 129375000, 194062500, 291093750, 436640625}));
 
  // Gilden-Quests (Noetige Quests zum Erreichen einer bestimmten Stufe)
  SetProp(P_GUILD_QUESTS, ({}));
  SetProp(P_JOIN_COST, 0);
}
 
string zeige_reboot() {
  string str;
  int t;

  t=time()-last_reboot_time();
  str="Seit dem letzten Shutdown sind "+t+" Sekunden vergangen.\n";
  if (t<60) return str;
  str+="Das sind "+uptime()+".\n";
  return str;
}

/*	querytitle()
 *	funtkion:	liefert den titel zu dem jeweiligen level und geschlecht
 *	argumente:	level - level des spielers (0<level<31)
 *			gender - geschlecht des spielers, (saechlich(0)==weiblich(2), maennlich(1))
 *	rueckgabe:	"", wenn falscher level oder falschen geschlecht
 *			titel anhand der property P_GUILD_TITLES sonst
 */ 
string QueryTitle(int level,int gender) {
    int size;
 
    if (level<QueryProp(P_MIN_LEVEL))
	level = QueryProp(P_MIN_LEVEL);
    if (gender < 0 || gender > 2) return "";
    if (gender==0) gender = 2;
    gender--;
    size = sizeof(QueryProp(P_GUILD_TITLES)[gender]);
    if (level>size + QueryProp(P_MIN_LEVEL) - 1)
	level = size + QueryProp(P_MIN_LEVEL) - 1;
    return QueryProp(P_GUILD_TITLES)[gender][level-QueryProp(P_MIN_LEVEL)];
}
 
/*	queryExp()
 *	funktion:	liefert die zahl der erfahrungspunkte, um ein level zu erreichen
 *	argumente:	lev - level dessen erfahrungspunktzahl gesucht wird
 *	rueckgabe:	-1, wenn ungueltiges level
 *			anzahl der erfahrungspunkte sonst
 */
int QueryExp(int lev) {
  int size, diff, xp;
 
  diff = 0;
  if (lev < QueryProp(P_MIN_LEVEL))
    lev = QueryProp(P_MIN_LEVEL);
  size = sizeof(QueryProp(P_GUILD_EXP));
  if (lev>size +  QueryProp(P_MIN_LEVEL) - 1)
  {
    diff = lev-(size+QueryProp(P_MIN_LEVEL)-1);
    lev = size + QueryProp(P_MIN_LEVEL) - 1;
  }
  xp = QueryProp(P_GUILD_EXP)[lev-QueryProp(P_MIN_LEVEL)];
  for (size=0; size<diff; size++)
    xp = (int) (((xp << 1) + xp) >> 1);
  return xp;
}
 
static int compare( mixed *i, mixed *j ) {
  return ((i[2] == j[2]) ? (i[1] > j[1]) : (i[2] > j[2]));
}
 
/*	liste()
 *	funktion:	listet alle quest auf, die aktiv und keine gildenquests sind
 *			sowie die anzahl der ap, ob geloest oder nicht, die beschreibung
 *			und den magier
 *			zusaetzlich werden die benoetigten ap ausgegeben, um magier zu werden
 *	argumente:	keine
 *	rueckgabe:	0, wenn irgendein fehler auftritt
 *			1 sonst
 */
int liste() {
  mixed *index, *quests, *opt_quests;
  int i,j;
  string str;
 
  /* hole alle namen beim questmaster */
  index = QM->QueryAllKeys();
  quests = ({});
  opt_quests = ({});
 
  /* quests sammelt alle quest mit: (name, ap, level, wizard) */
  for (i=0; i<sizeof(index); i++)
      if (QM->QueryActive(index[i]) && !QM->IsGuildQuest(index[i]))
        if (QM->QueryQuest(index[i])[5]!=2)
	  quests += ({  ({
			 index[i], QM->QueryQP(index[i]),
			 QM->QueryLevel(index[i]), QM->QueryWizard(index[i])
			}) });
        else
          opt_quests += ({  ({
                         index[i], QM->QueryQP(index[i]),
                         QM->QueryLevel(index[i]), QM->QueryWizard(index[i])
                        }) });
  /*Compare sortiert nach Level */
  quests = sort_array(quests, "compare", this_object() );
  opt_quests = sort_array(opt_quests, "compare", this_object() );
 
  /* Ausgabestring vorbereiten */
  str = "                        Liste der Abenteuer:\n\n";
  str += sprintf("    %40s  AP  Stufe  geloest  Magier\n","");
  for( i=0; i<76;i++,str+="-");
  str += "\n";
  for( i=0; i<sizeof(quests); i++ )
      str += sprintf("%2d. %-40s %3d   %2d    %4s     %s\n",i+1,quests[i][0],
		   quests[i][1], quests[i][2],
		   (this_player()->QueryQuest( quests[i][0] )?"ja":"nein"),
		   capitalize(quests[i][3]));
  if (sizeof(opt_quests))
  str += "\n\n";
  str += "                        Optionale Abenteuer:\n\n";
  str += sprintf("    %40s  AP  Stufe  geloest  Magier\n","");
  for( i=0; i<76;i++,str+="-");
  str += "\n";
  for( i=0; i<sizeof(opt_quests); i++ )
      str += sprintf("%2d. %-40s %3d   %2d    %4s     %s\n",i+1,opt_quests[i][0],
                   opt_quests[i][1], opt_quests[i][2],
                   (this_player()->QueryQuest( opt_quests[i][0] )?"ja":"nein"),
                   capitalize(opt_quests[i][3]));
  str += sprintf("\nEs werden %d(%d) Punkte benoetigt, um Magier/Seher zu werden.\n",
         QM->QueryNeededQP(),QM->QueryMaxQP());
  PL->More(str, 0);
  return 1;
}
 
 
/*
 * GetGuildSpells()
 *   Funktion: 
 *     Gibt ein Array mit den Namen der Skills oder Spells der jeweiligen Gilde
 *     zurueck
 *   Argument:
 *     Art - Es werden alle Fertigkeiten ihrer Art zurueckgegeben
 *           (0,1,3,4) <sys/living.h>
 *   Rueckgabe: 
 *     Ein Array aus Strings mit den Namen der Fertigkeiten
 */
mixed GetGuildSpells(int Art) {
  int i; 
  mixed ret, index;

  ret = ({});
  index = QueryProp(P_GUILD_SKILLS);
 
  for(i=0; i<sizeof(index); i++) {
    if(Art == SM->Valid(index[i]))
      ret += ({index[i]});
  }
  return ret;
}
 
/*	show()
 *	Funktion:	zeigt alle moeglichen Informationen ueber die Gilde(n) an
 *	Argument:	str - String der Kommandozeile
 *			= "gilden" :		Alle moeglichen zur Zeit offenen Gilden
 *			= "zaubersprueche":	Alle Zaubersprueche, die man in dieser Gilde
 *                                              lernen kann
 *			= "faehigkeiten" :	Alle Faehigkeiten, die man in dieser Gilde
 *                                              lernen kann
 *			= "eigenschaften":	Minimale und Maximale Eigenschaften dieser Gilde
 *			= "aufnahme...":	Bedingungen an die Aufnahme (Level, Stats, Kosten,
 *                                              Quests)
 *			= "erhoehen":		Anzahl der Erfahrungspunkte um Level oder
 *                                              Eigenschaft zu erhoehen
 *			= "austritt..":		Was passiert, wenn ein Mitglied die Gilde verlaesst
 *	Rueckgabe:	0 - irgendein Fehler
 *			1  - Funktion ausgefuehrt
 */
int show_all(string str) {
  string tempstr, moreliste;
  mixed index, values;
  mapping gilden;
  int i,level, join, gender, size;
  int pxp, gxp;
 
  if (!str || str=="abenteuer") 
    return liste();
 
  notify_fail(
    "Versuche eines der folgenden Argumente\n"
    "                abenteuer\n"
    "                gilden\n"
    "                gildenabenteuer\n"
    "                zaubersprueche\n"
    "                faehigkeiten\n"
    "                eigenschaften\n"
    "                aufnahmebedingungen\n"
    "                erhoehen\n"
    "                austritt\n"
    "                titel\n");
 
  if(!PL)
    return 0;
  if(PL->QueryProp(P_GHOST)) {
    write("Als Geist kannst Du diese Funktion nicht ausfuehren.\n");
    return 1;
  }
 
  join = 0;

  if(str=="gilden") {
    // Geoeffnete Gilden
    gilden = GM->QueryGuilds(GM_TYPE_VALID);
 
    if (!sizeof(gilden))
      write("Zur Zeit gibt es keine Gilden, denen Du beitreten kannst.\n");
    else {
      index = m_values(gilden);
      printf(" Gilden                                           Meister\n");
      printf("---------------------------------------------------------------\n");
      for(i=0; i<sizeof(index); i++) {
        if (m_indices(gilden)[i]!="/std/guild")
          printf(" %-49s%s\n",m_indices(gilden)[i], capitalize(index[i][1]));
      }
      printf("---------------------------------------------------------------\n\n");
    }
 
    // Geschlossene Gilden
    gilden = GM->QueryGuilds(GM_TYPE_INVALID);
 
    if (!sizeof(gilden))
      write("Zur Zeit gibt es keine geschlossenen Gilden.\n");
    else {
      index = m_values(gilden);
      printf(" geschlossene Gilden                              Meister\n");
      printf("---------------------------------------------------------------\n");
      for(i=0; i<sizeof(index); i++) {
        if(m_indices(gilden)[i]!="/std/guild")
          printf(" %-49s%s\n",m_indices(gilden)[i], capitalize(index[i][1]));
      }
      printf("---------------------------------------------------------------\n\n");
    }
    return 1;
  }
 
  if(str=="spells" || str=="zaubersprueche" || str=="sprueche") {
    if(!sizeof(QueryProp(P_GUILD_SKILLS))) {
      write ("In dieser Gilde sind keine Zaubersprueche verfuegbar.\n");
      return 1;
    }
 
    index = GetGuildSpells(SM_SPELL);
    if(!sizeof(index)) {
      write("In dieser Gilde sind keine Zaubersprueche verfuegbar.\n");
      return 1;
    }
    moreliste = "verfuegbare Zaubersprueche                                Level\n";
    moreliste += "---------------------------------------------------------------\n";
    for(i=0; i<sizeof(index); i++)
      moreliste += sprintf("%-60s %2d\n",index[i],SM->QueryProp(index[i],P_SM_LEVEL));
    moreliste += "---------------------------------------------------------------\n";
      
    PL->More(moreliste);
    return 1;
  }
 
  if(str=="skills" || str=="faehigkeiten") {
    if(!sizeof(QueryProp(P_GUILD_SKILLS))) {
      write("In dieser Gilde sind keine zusaetzlichen Faehigkeiten verfuegbar.\n");
      return 1;
    }
 
    index = GetGuildSpells(SM_SKILL)+
            GetGuildSpells(SM_ATTACK)+
            GetGuildSpells(SM_DEFEND);
    if(!sizeof(index)) {
	  write("In dieser Gilde sind keine zusaetzlichen Faehigkeiten verfuegbar.\n");
	  return 1;
    }
    moreliste = "verfuegbare Faehigkeiten                                  Level\n";
    moreliste += "---------------------------------------------------------------\n";
    for(i=0; i<sizeof(index); i++)
      moreliste += sprintf("%-60s %2d\n",index[i],SM->QueryProp(index[i],P_SM_LEVEL));
    moreliste += "---------------------------------------------------------------\n";

    PL->More(moreliste);
    return 1;
  }
 
  if(str=="eigenschaften" || str=="stats") {
    printf("Um dieser Gilde beitreten zu koennen, musst Du mindestens folgende \n"
           "Eigenschaften aufweisen:\n");
    printf("Intelligenz:      %d\n"
           "Geschicklichkeit: %d\n"
           "Staerke:          %d\n"
           "Ausdauer:         %d\n\n",
           QueryProp(P_MIN_STATS)[STAT_INT], QueryProp(P_MIN_STATS)[STAT_DEX],
           QueryProp(P_MIN_STATS)[STAT_STR], QueryProp(P_MIN_STATS)[STAT_CON]);
    return 1;
  }
 
  if(str=="aufnahmebedingungen" || str=="bedingungen" || str=="join") {
    if(PL->QueryProp(P_GUILD)==QueryProp(P_GUILD_NAME))
      printf("Du bist doch schon Mitglied dieser Gilde!\n"
             "Aber wir zeigen Dir nochmal was die Aufnahme kostet:\n\n");
    if(QueryProp(P_JOIN_COST))
      printf("Der Beitritt zu dieser Gilde kostet Dich:\n %s \n",
         PL->spec_cost_str(
        (PL->QueryProp(P_COINMASTER))->ExchangeValue(QueryProp(P_JOIN_COST)),
         PL->QueryProp(P_COINMASTER)));
    else
      printf("Der Beitritt zu dieser Gilde kostet Dich nichts!\n");
    str = "erhoehen"; join = 1;
  }

  if(str=="gildenquests" || str=="gildenabenteuer") {
    str = "erhoehen";
    join = 1;
  }
 
  if(str=="erhoehen") {
    if(sizeof(QueryProp(P_GUILD_QUESTS))) {
      // Ausgabe der GildenQuests (auch bei Aufruf von "beitritt")
      printf("Es wird zum Eintritt oder Erhoehen (je nach Level) verlangt,\n"
             "folgende Pruefungen abzulegen:\n");
      printf("    %35s   Stufe  geloest  verantw. Magier\n","");
      printf("-----------------------------------------------------------------------------\n");
      for(i=0; i<sizeof(QueryProp(P_GUILD_QUESTS)); i++) {
        tempstr = QueryProp(P_GUILD_QUESTS)[i][0];
        printf("%d. %-36s  %5d   %4s    %10s\n",i+1,tempstr, QueryProp(P_GUILD_QUESTS)[i][1],
        (PL->QueryQuest(tempstr)?"ja":"nein"),
        capitalize(QM->QueryWizard(tempstr)));
      }
      printf("\n");
    }
 
    if(!join)
      _kosten_();
    
    return 1;
  }
 
  if(str=="austrittsforderungen" || str=="forderung" || str=="leave" ||
      str== "austritt") {
    write("Wenn Du aus dieser Gilde austrittst, verlierst Du die \n"
      "Berechtigung, weiter das Wissen unserer Gilde anzuwenden.\n"
      "Du bist dann nicht mehr in der Lage, die besonderen Faehigkeiten\n"
      "unseres Berufes zu benutzen. Ueberlege es Dir also gut, wenn Du\n"
      "austreten willst!\n");
    return 1;
  }
 
  if(str=="titel") {
    gender = this_player()->QueryProp(P_GENDER);
    if(gender==0) gender = 2;  gender--;
    level = QueryProp(P_MIN_LEVEL);
    size = sizeof(QueryProp(P_GUILD_TITLES)[gender]); gender++;
    printf("% -10s%-30s%-20s\n", "Stufe", "Titel", "Erfahrungspunkte");
    printf("--------------------------------------------------------------------------------\n");
    for (i=0; i<size; i++)
      printf(" %-10d%-30s%-20i\n", i + level, QueryTitle(i+level, gender), QueryExp(i+level));
    printf("--------------------------------------------------------------------------------\n");
    return 1;
  }
 
  return 0;
}
 
int ShowDescription(string name) {
  string desc;
 
  if (!stringp(name)) {
    write("Wovon willst Du denn eine genauere Beschreibung? Mit\n"
 	+"  'liste zaubersprueche' und\n"
	+"  'liste faehigkeiten'\n"
        +"kannst Du Dir die verfuegbaren Sprueche und Faehigkeiten\n"
	+"anzeigen lassen.\n");
    return 1;
  }
  if ((member(QueryProp(P_GUILD_SKILLS), name)==-1) ||
      (!strlen(desc=SM->QueryProp(name, P_SM_DESCRIPTION))))
  {
    write("Dazu existiert keine Beschreibung. Mit\n"
        +"  'liste zaubersprueche' und\n"
        +"  'liste faehigkeiten\n"
        +"kannst Du Dir die verfuegbaren Sprueche und Faehigkeiten\n"
        +"anzeigen lassen.\n");
    return 1;
  }
  write("Beschreibung zu " + name + ": \n " + break_string(desc));
  if (this_player()->QueryProp(P_GUILD) == QueryProp(P_GUILD_NAME))
    if (this_player()->QueryProp(P_SKILLS)[name])
      write("Du hast bereits "+ (float) this_player()->GetProbability(name)/10 +
            " Prozent gelernt.\n");
    else 
      write("Du hast dies noch nicht gelernt.\n");
  return 1;
}
 
/*
 * leave()
 *  Funktion: 
 *    Spieler kann ueber diese Funktion die Gilde verlassen
 *    Es werden ihm alle Spells/Skills weggenommen,
 *    die Property P_GUILD wird auf die der Standard-Gilde gesetzt
 *  Parameter:
 *    string 'gilde' zur Sicherheit
 */
int leave(string argument) {
  mixed tempskills;
  int i;
 
  if(!PL)
    return 0;
  if(argument!="gilde") {
    write("Wenn Du aus dieser Gilde austrittst, verlierst Du die \n"
      "Berechtigung, weiter das Wissen unserer Gilde anzuwenden.\n"
      "Du bist dann nicht mehr in der Lage, die besonderen Faehigkeiten\n"
      "unseres Berufes zu benutzen. Ueberlege es Dir also gut, wenn Du\n"
      "austreten willst. Zum endgueltigen Austritt gib:\n"
      "   verlasse gilde\n"
      "ein.\n");
    return 1;
  }
  if(PL->QueryProp(P_GHOST)) {
    write("Als Geist darfst Du diese Aktion nicht ausfuehren.\n");
    return 1;
  }
  if(PL->QueryProp(P_GUILD) != QueryProp(P_GUILD_NAME)) {
    write("Aber Du bist doch gar nicht Mitglied dieser Gilde!\n");
    return 1;
  }
  PL->SetProp(P_GUILD, STDGUILD);
 
  tempskills = QueryProp(P_GUILD_SKILLS);
  if(sizeof(tempskills)) {
    tell_object(PL, break_string("Du verlierst ploetzlich all die Fertigkeiten, "
      "die Du hier einst muehsam gelernt hast."));
    for (i=sizeof(tempskills);i--;)
      PL->GiveAbility(tempskills[i], -1);
  }

  tell_object(PL, "Du bist jetzt nicht mehr Mitglied dieser Gilde.\n");
  say(capitalize(PL->name(WER,2))+" ist gerade aus der Gilde ausgetreten.\n");
  return 1;
}
 
/*
 * advance()
 *  Funktion:
 *    Erhoehen von 'Argument'
 *  Parameter:
 *    string=("stufe","intelligenz","geschicklichkeit", "staerke","ausdauer")
 */ 
int _advance_(string arg) {
  int cost,exp,level;
  int ret,i;
  object pl;
  string title, msg;
  mixed tempquests;
 
  notify_fail("Was willst Du denn erhoehen?\n");
 
  if(!arg) return 0;
  
  if(PL->QueryProp(P_GHOST)) {
    write("In Deinem immateriellen Zustand hast Du nichts, was Du erhoehen kannst.\n");
    return 1;
  }
  
  if(PL->QueryProp(P_GUILD)!=QueryProp(P_GUILD_NAME)) {
    write("Du kannst Dich oder Deine Attribute nur in Deiner Gilde erhoehen.\n");
    return 1;
  }
 
  level = PL->QueryProp(P_LEVEL);
  if (level>=20 && !IS_SEER(PL)) level=19;
  if (level < 0) level = 0;
 
  /* Erhoehen des Levels */
  if(!strstr("stufe",arg, 0)) {
    if(level>=MAX_LEVEL) {
      write("Du hast bereits die hoechste Stufe erreicht.\n");
      return 1;
    }
    if(PL->QueryProp(P_XP)<QueryExp(level+1)) {
      write("Du hast noch nicht genuegend Erfahrungspunkte, um Deine Stufe\n"
            "zu erhoehen. Komm doch spaeter wieder!\n");
      return 1;
    }
    /* Pruefungen fuer einen Aufstieg noch nicht erfuellt */
    tempquests = QueryProp(P_GUILD_QUESTS);
    if(tempquests)
      for(i=0;i<sizeof(tempquests);i++) {
        if(!(PL->QueryQuest(tempquests[i][0])) && tempquests[i][1]<=(level+1)) { 
          write("Du hast noch nicht alle Pruefungen erfuellt!\n");
          return  1;
        } 
    }
    /* Zu wenig Forschungspunkte fuer einen Aufstieg */
    if(PL->QueryProcentForSeerEP()<EM->QueryNeededEP(level+1)) {
      printf("%s\n", EP_Message(PL, "erhoehen"));
      return 1;
    } 
    if (level+1==20) { // Seherwerdung
      i=HURRIKAP->create_seer(PL);
      switch (i) {
        case   1: map_objects(users(), "Message",
                    "Hurrikap ruft: "+PL->name(WER)+" ist jetzt Seher!\n",
                    "hurrikap");
                  break;
        case   2: write("Du bist schon ein Seher?!?\n");
                  return 1;   
        default :
        case  -1: 
        case  -2: write("Unerwarteter Fehler trat auf!\n"
                    "Sag bitten einem Erzmagier bescheid!\n");
                  return 1;
        case -15: write("Unerwarteter Fehler: zuwenig XP\n"
                    "Sag bitten einem Erzmagier bescheid!\n");
                  return 1;
        case -16: write("Unerwarteter Fehler: zuwenig AP\n"
                    "Sag bitten einem Erzmagier bescheid!\n");
                  return 1;
        case -17: write("Unerwarteter Fehler: Pflichtquest fehlt\n"
                    "Sag bitten einem Erzmagier bescheid!\n");
                  return 1;
      }
    }
    say(sprintf("%s hat jetzt Stufe %d erreicht.\n",PL->QueryProp(P_NAME),level+1));
    PL->SetProp( P_LEVEL, level+1 );
    title = QueryTitle(level+1,PL->QueryProp(P_GENDER));
    if(level<20)
      PL->SetProp(P_TITLE, title);
    switch(level) {
      default:
      case 0..6:
        msg="Du bist jetzt %s %s (Level %d)\n";
        break;
      case 7..13:
        msg="Gut gemacht, %s %s (Level %d)\n";
        break;
      case 14..100:
        msg="Willkommen auf Deiner neuen Stufe.\n" +
            "Du bist jetzt %s %s (Level %d).\n";
        break;
    }
    write(sprintf(msg,PL->QueryProp(P_NAME),PL->QueryProp(P_TITLE),level+1));
    return 1;
  }
  /* Erhoehen der Eigenschaften */
  notify_fail("Diese Eigenschaft kannst Du nicht erhoehen.\n");
  switch(arg) {
    case "kraft" :
    case "staerke" :
      ErhoeheAttribute(PL, STAT_STR, A_STR, "Deine Staerke");
      break;
    case "int" :
    case "intelligenz" :
      ErhoeheAttribute(PL, STAT_INT, A_INT, "Deine Intelligenz");
      break;
    case "aus" :
    case "ausdauer" :
      ErhoeheAttribute(PL, STAT_CON, A_CON, "Deine Ausdauer");
      break;
    case "gesch" :
    case "geschicklichkeit" :
      ErhoeheAttribute(PL, STAT_DEX, A_DEX, "Deine Geschicklichkeit");
      break; 
    case "cha" :
    case "charisma" :
      ErhoeheAttribute(PL, STAT_CHA, A_CHA, "Dein Charisma");
    default :
      return 0;
  }
  return 1;
}

/*
 * learn():
 *  Funktion:
 *    Ermoeglicht den Spielern das 'Erlernen' von Gildenskills und -spells
 *  Parameter:
 *    String - Der Skill oder Spell, der gelernt werden soll
 */
int learn(string arg) {
  string *verben, tmp;
  int ret, i;
  
  notify_fail("WAS willst Du denn lernen?\n");  
  if(!arg || !strlen(arg))
    return 0;
  if(PL->QueryProp(P_GUILD)!=QueryProp(P_GUILD_NAME)) {
    tell_object(PL, "Um hier Zaubersprueche zu lernen, musst Du Mitglied dieser "
      "Gilde werden.\n");
    return 1;
  }
  if(member_array(arg,QueryProp(P_GUILD_SKILLS)) < 0) {
    tell_object(PL,
      "Dies kannst Du in dieser Gilde nicht lernen.\n");
    return 1;
  }
  if((ret=PL->GetProbability(arg))>-1) {
    tell_object(PL, "Das kannst Du doch schon!\n");
    PL->GiveAbility(arg, ret); // nochmal fuer die SKILL-ID
    return 1;
  }
  if(!IS_LEARNING(PL)) {
    if(PL->QueryProp(P_GHOST)) {
      tell_object(PL, "Du bist doch ein Geist, als solcher kannst Du Dir "
        "das gar nicht merken.\n");
      return 1;
    }
    if((PL->QueryProp(P_LEVEL)) < (SM->QueryProp(arg, P_SM_LEVEL))) {
      tell_object(PL, "Deine Stufe ist noch nicht hoch genug, komm doch "
        "spaeter wieder.\n");
      return 1;
    }
  }
  ret=PL->GiveAbility(arg, SM->QueryProp(arg, P_SM_BEGIN));
  if(ret>-1) {
    verben=PL->QuerySkillVerbs(arg);
    for(i=sizeof(verben);i--;)
      verben[i]="'"+verben[i]+"'";
    tmp=PL->CountUp(verben);
    tell_object(PL, break_string("Du konzentrierst Dich eine Weile und lernst "
      "'"+capitalize(arg)+"'. "+
      SM->QueryProp(arg, P_SM_DESCRIPTION)+
      ((stringp(tmp)&&strlen(tmp))?
      " Du kannst diese Fertigkeit mit "+tmp+" anwenden.":"")+
      "\nDie Erfolgswahrscheinlichkeit betraegt im Moment genau "+to_string(ret/10)+
      "%."));
    return 1;
  }
  tell_object(PL, "Hmm hier laeuft was schief. Sag einem Magier Bescheid!\n");
  return 1;
}

/* join()
 *   Funktion:  nimmt einen Spieler in die Gilde auf
 *   Parameter:	keine
 *   Rueckgabe: 0, wenn Fehler, 1 sonst
 */
int join() {
  mixed tempquests;
  int i, other, question;
 
  if ((!PL) || !objectp(PL))
    return 1;
  if (PL->QueryProp(P_GHOST))
    {
      printf("KEINEM Geist ist eine solche Aktion gestattet!\n");
      return 1;
    }
  if (!sizeof(GM->QueryGuild(QueryProp(P_GUILD_NAME), GM_TYPE_VALID))) 
    {
      printf("Die Gilde ist nicht angemeldet. Du kannst ihr nicht beitreten!\n");
      return 1;     
    }
  if (PL->QueryProp(P_GUILD)==QueryProp(P_GUILD_NAME))
    {
      printf("Du bist doch schon Mitglied dieser Gilde!\n");
      return 1;
    }
 
  if (PL->QueryProp(P_LEVEL) < QueryProp(P_MIN_LEVEL))
    {
      printf("Dein Level ist nicht gross genug. Komm spaeter wieder.\n");
      return 1;
    }
 
  /* Beitritt nur, wenn noch in keiner anderen Gilde, oder diese Gilde existiert nicht mehr */
  other = 0;
  if (PL->QueryProp(P_GUILD) != STDGUILD)
    if (sizeof(GM->QueryGuild(PL->QueryProp(P_GUILD), GM_TYPE_VALID)))
    {
      printf("Du bist doch schon Mitglied einer anderen Gilde! Trete dort erst aus.\n");
      return 1;
    }
/*    
    
    else 
      if (sizeof(GM->QueryGuild(PL->QueryProp(P_GUILD), GM_TYPE_INVALID)))
      {
        printf("Du bist schon Mitglied einer Gilde. Allerdings ist diese geschlossen.\n");
        printf("Wende Dich bitte an einen Magier.\n");
        return 1;
      }
*/
 
  /* Sind alle Pruefungen abgelegt?: */
  tempquests = QueryProp(P_GUILD_QUESTS);
  if (sizeof(tempquests))
    for (i=0;i<sizeof(tempquests);i++)
      if (!PL->QueryQuest(tempquests[i][0]) && tempquests[i][1]<=PL->QueryProp(P_LEVEL))
	{
	  printf("Du hast noch nicht alle Pruefungen erfuellt!\n");
	  return 1;
	}
 
  /* Testen der minimalen Stats: */
 
  if ((PL->QueryRealStat(A_INT)<QueryProp(P_MIN_STATS)[STAT_INT]) ||
      (PL->QueryRealStat(A_DEX)<QueryProp(P_MIN_STATS)[STAT_DEX]) ||
      (PL->QueryRealStat(A_STR)<QueryProp(P_MIN_STATS)[STAT_STR]) ||
      (PL->QueryRealStat(A_CON)<QueryProp(P_MIN_STATS)[STAT_CON]))
    {
      printf("Du hast leider nicht die geforderten Eigenschaften, um in\n"
	     +"diese Gilde eintreten zu koennen.\n");
      return 1;
    }
 
  if (QueryProp(P_JOIN_COST))
      if(!PL->CMAddMoney(PL->QueryProp(P_COINMASTER), (-1)*QueryProp(P_JOIN_COST)))
      {
	printf("Du hast leider zuwenig Geld bei Dir, um hier einzutreten.\n");
	return 1;
      }
 
  PL->SetProp(P_GUILD, QueryProp(P_GUILD_NAME));
 
  PL->SetProp(P_TITLE, QueryTitle(PL->QueryProp(P_LEVEL), PL->QueryProp(P_GENDER)));
  tell_object(PL, "Du bist jetzt Mitglied dieser Gilde.\n");
  say(PL->QueryProp(P_NAME)+" ist gerade der Gilde beigetreten.\n");
 
  return 1;
}
 
//  Kosten()
//
//  Zeigt die Erfahrungspunkte, die noetig sind, um
//  das Level oder eine der Eigenschaften zu erhoehen;
//
int _kosten_() {
  int level;
  int pexp, gexp, w, x, y, z;
  string tmp;
 
  if(!PL) return 0;
 
  if (PL->QueryProp(P_GHOST) && !IS_LEARNING(PL)) {
      write("Als Geist besitzt Du keine Attributswerte.\n");
      return 1;
  }

  if (PL->QueryProp(P_GUILD)!=QueryProp(P_GUILD_NAME) && !IS_LEARNING(PL)) {
      printf(break_string("Um mehr ueber die Kosten der Erhoehung zu erfahren, "
	     "musst Du in Deine eigene Gilde gehen."));
      return 1;
  }	
 
  level = PL->QueryProp(P_LEVEL);
  pexp = PL->QueryProp(P_XP);
  gexp = QueryExp(level + 1);
 
	printf("\nEigenschaft      | Max  | Wert | Gekauft | Erhoehungskosten in EPs");
	printf("\n-----------------+------+------+---------+------------------------");

	x = PL->QueryRealStat(A_INT);
	y = PL->QueryProp(P_MAX_STATS)[STAT_INT];
	z = PL->QueryProp(P_BOUGHT_STATS)[STAT_INT];
	if (x < y) tmp = sprintf("%d", QueryStatCost(A_INT, STAT_INT,PL));
	else tmp = "Maximum erreicht";

	printf("\nIntelligenz      | %|3d  | %|3d  |  %|4d   | %s", y, x, z, tmp);

	x = PL->QueryRealStat(A_DEX);
	y = PL->QueryProp(P_MAX_STATS)[STAT_DEX];
	z = PL->QueryProp(P_BOUGHT_STATS)[STAT_DEX];
	if (x < y) tmp = sprintf("%d", QueryStatCost(A_DEX, STAT_DEX,PL));
	else tmp = "Maximum erreicht";

	printf("\nGeschicklichkeit | %|3d  | %|3d  |  %|4d   | %s", y, x, z, tmp);

	x = PL->QueryRealStat(A_STR);
	y = PL->QueryProp(P_MAX_STATS)[STAT_STR];
	z = PL->QueryProp(P_BOUGHT_STATS)[STAT_STR];
	if (x < y) tmp = sprintf("%d", QueryStatCost(A_STR, STAT_STR,PL));
	else tmp = "Maximum erreicht";

	printf("\nKraft            | %|3d  | %|3d  |  %|4d   | %s", y, x, z, tmp);

	x = PL->QueryRealStat(A_CON);
	y = PL->QueryProp(P_MAX_STATS)[STAT_CON];
	z = PL->QueryProp(P_BOUGHT_STATS)[STAT_CON];
	if (x < y) tmp = sprintf("%d", QueryStatCost(A_CON, STAT_CON,PL));
	else tmp = "Maximum erreicht";

	printf("\nAusdauer         | %|3d  | %|3d  |  %|4d   | %s", y, x, z, tmp);
	printf("\n-----------------+------+------+---------+------------------------\n\n");

	if (level>=MAX_LEVEL) {
      write("Du hast die hoechste Stufe dieser Gilde erreicht.\n");
      return 1;
  }
  if (pexp>=gexp)
      write("Du hast genuegend Erfahrungspunkte fuer die naechste Stufe.\n");
  else {
      printf("Um Deine Stufe zu erhoehen, benoetigst Du %d Erfahrungspunkte.\n", 
          QueryExp(level + 1));
      printf("Du benoetigst noch %d Erfahrungspunkte.\n", gexp-pexp);
  }
  printf("%s\n\n", EP_Message(PL, "kosten"));
  return 1;
}

string EP_Message(object Player, string art) {
  int player_procent, needed_procent;
  player_procent=Player->QueryProcentForSeerEP();
  needed_procent=EM->QueryNeededEP(Player->QueryProp(P_LEVEL) + 1);
  if (player_procent>=needed_procent && art=="kosten")
    return "Du kennst das Wunderland fuer die naechste Stufe gut genug.";
  switch(needed_procent-player_procent)
  {
    case 1: 
      return "Fuer die naechste Stufe kennst Du das Wunderland fast gut genug.";
    case 2:
      return "Fuer die naechste Stufe solltest Du Dich im Wunderland noch ein wenig mehr\n"
      +"umschauen.";
    case 3..4:
      return "Du solltest Dich noch eine Weile im Wunderland umschauen, bevor Du Dich\n"
      +"erhoehst.";
    case 5..6:
      return "Fuer die naechste Stufe solltest Du das Wunderland erst noch weiter\nerforschen.";
    case 7..9: 
      return "Fuer die naechste Stufe kennst Du das Wunderland noch nicht genug.";
    case 10..14:
      return "Fuer die naechste Stufe kennst Du das Wunderland noch lange nicht genug.";
    case 15..20:
      return "Oje, Du kennst das Wunderland ja kaum.";
    default:
      return "Du kennst das Wunderland ja gar nicht. Erforsche es, bevor Du aufsteigst.";
  }
}

/*	QueryStatCost()
*
*	Funktion:	Ermittelt die Anzahl an Erfahrungspunkten, die benoetigt wird,
*			um die Eingeschaft astat um 1 zu erhoehen
*	Argumente:	astat  = A_INT, A_STR, A_DEX, A_CON
*			stat   = STAT_INT, STAT_STR ...
*			Player = der Player, der das wissen will;
*	Rueckgabe:	-1 bei irgendeinem Fehler
*			Anzahl an Erfahrungspunkten sonst
*
*	Spieler mit Level groesser 20 nur noch 3/5 der ep fuer 
*	naechsten Level, zwischen 10 und 20 nur noch 4/5 ep.
*	Zurueckgegeben wird dieser Wert auf den Gildenfaktor
*	angepasst.
*/
int QueryStatCost(string astat, int stat, object Player)
{
	float faktor, exp;
	int level, kosten;
	mixed lost_stats;

	lost_stats = Player->QueryProp(P_LOST_STATS); 
	exp        = (float)QueryExp(Player->QueryRealStat(astat) + 1);

	if ((level = Player->QueryProp(P_LEVEL)) >= 20)
		exp = (float)(3 * (exp / 5));
	else if (level > 10)
		exp = (float)(4 * (exp / 5));

	kosten = 101 * (int)(exp / (10 * QueryProp(P_GUILD_FACTOR)[stat]));
	kosten = 101 * (int)(exp / (10 * Player->QueryProp(P_STAT_FACTOR)[stat]));

	if(lost_stats[stat])
	{
		kosten = (int)(kosten / 4);

		if(kosten > 1000000) kosten = 1000000;
	}

	return kosten;
}

/*
*	ErhoeheAttribute()
*
*	Funktion:	Erhoeht die angegebene Eigenschaft um 1, wenn die noetigen
*			Erfahrungspunkte vorhanden sind
*	Parameter:	Player      - der Spieler um den es geht
*			stat        - STAT_INT, STAT_STR, ...
*			astat       - A_INT, A_STR, ...
*			description - Intelligenz, Staerke, ....
*	Rueckgabe:	keine;
*/

void ErhoeheAttribute(object Player, int stat, string astat, string description)
{
	int kosten;
	mixed newbuy, h_stats, lstats;

	lstats = Player->QueryProp(P_LOST_STATS);
	kosten = QueryStatCost(astat, stat, Player);

	if (Player->QueryRealStat(astat) >= Player->QueryProp(P_MAX_STATS)[stat])
	{
		tell_object(Player, break_string("Du bist an die Grenzen deiner Rasse gestossen."
			" Du kannst " + description + " nicht weiter erhoehen."));

		return;
	}

	if (Player->QueryProp(P_XP) < kosten)
	{
		tell_object(Player, break_string(sprintf("Du hast leider nicht genuegend Erfahrungspunkte,"
			" um " + description + " zu erhoehen. Noetig waeren %d"
			" Erfahrungspunkte.", kosten)));

		return ;
	}

	if (((Player->QueryProp(P_LEVEL) < 10) && (Player->QueryProp(P_LEVEL) <= Player->QueryRealStat(astat))) ||
		((Player->QueryProp(P_LEVEL) >= 10) && 4 * Player->QueryProp(P_LEVEL) <= (
		Player->QueryRealStat(A_INT) + Player->QueryRealStat(A_DEX) +
		Player->QueryRealStat(A_CON) + Player->QueryRealStat(A_STR))))
	{
		tell_object(Player, "Du musst erst Deine Stufe erhoehen. Komm spaeter wieder.");

		return;
	}

	newbuy = Player->QueryProp(P_BOUGHT_STATS);

	if (newbuy[stat] + 1 > PL->QueryProp(P_MAX_STATS)[stat])
	{
		tell_object(Player, break_string("Du kannst " + description + " nicht weiter erhoehen."));

		return;
	}

	Player->SetAttribute(astat, Player->QueryRealStat(astat) + 1);

	newbuy[stat] = newbuy[stat] + 1;

	Player->SetProp(P_BOUGHT_STATS, newbuy);
	Player->SetProp(P_XP,  Player->QueryProp(P_XP) - kosten);

	tell_object(Player, break_string(sprintf("Du hast " + description +
		" auf %d erhoeht.", Player->QueryRealStat(astat))));

	if(lstats[stat])
	{
		lstats[stat] = lstats[stat] - 1;

		SetProp(P_LOST_STATS, lstats);
	}

	Player->log_stats("buy");
}
