/*******************
** Eldarea MUDLib **
********************
**
** std/handler.c - standard event handler
**
** CVS DATA
** $Date$
** $Revision$
**
** CVS History
**
** $Log$
**
*/

#pragma strict_types

#include <events.h>
#include <moving.h>

mixed receive_event(mixed data, string type, int prio, int mode) 
{
  mixed snd;
  
#ifdef DEBUG
  if(this_player() && this_player()->QueryProp("debug_events"))
    printf("EVENT_HANDLER: %s <%s>\nMODE: %d\nDATA: %O\n",load_name() ,type, mode, data);
#endif

  if(load_name(previous_object())!=EVENTD)
    raise_error(
      sprintf("EVENT_HANDLER %s: illegal call from %s\n", 
        load_name(), load_name(previous_object())));

  if(!mappingp(data))
    raise_error(
      sprintf("EVENT_HANDLER %s: data mapping empty\n", load_name()));

  if(data[E_HANDLED]) 
    return; 

  if(!objectp(snd=data[E_SENDER]))
    raise_error(
      sprintf("EVENT_HANDLER %s: no event sender specified\n", load_name()));
}

void create() 
{
  if(clonep()) 
  { 
    destruct(this_object()); 
    return; 
  }

}
