/*******************
** Eldarea MUDLib **
********************
**
** std/humanoid/description.c - humanoid living description module
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.6 $
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.6  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.5  2000/12/04 10:36:53  elatar
** race defaults default humanoid description
**
** Revision 1.4  2000/02/02 09:45:30  elatar
** outer appearence in long() implemented
**
** Revision 1.3  2000/01/26 14:46:54  elatar
** diverse properties added
**
** Revision 1.2  2000/01/25 18:48:01  elatar
** P_STATUE implemented
**
** Revision 1.1  2000/01/25 16:42:52  elatar
** initial revision
**
**
**
*/

#include "/std/sys_debug.h"

inherit "/std/living/description";

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <living/attributes.h>
#include <humanoid/description.h>
#include <living/description.h>
#include <properties.h>
#include <lightsource.h>
#include <defines.h>
#include <combat.h>

#define RMASTER "/secure/rmaster"
					       
void create()
{ 
  ::create();
  Set(P_STATUE,-1,F_SET_METHOD);
  Set(P_EYE_COLOR,SAVE,F_MODE_AS);
  Set(P_SKIN_COLOR,SAVE,F_MODE_AS);
  Set(P_HAIR_COLOR,SAVE,F_MODE_AS);
  Set(P_HAIR_DESC,SAVE,F_MODE_AS);
  Set(P_HAIR_LENGTH,SAVE,F_MODE_AS);
  Set(P_HAIR_TEXTURE,SAVE,F_MODE_AS);
  Set(P_SPECIAL_DESC,SAVE,F_MODE_AS);
  Set(P_RACE_NAME,RMASTER->QueryOffset(P_RACE_NAME,QueryProp(P_RACE))[QueryProp(P_GENDER)]);
  AddId("Humanoid");
}

string size_desc()
{
  string str;

  switch (QueryProp(P_SIZE))
  {
    case 0..5:
      str="extrem winzig";
      break;
    case 6..25:
      str="sehr winzig";
      break;
    case 26..50:
      str="winzig";
      break;
    case 51..75:
      str="extrem klein";
      break;
    case 76..100:
      str="sehr klein";
      break;
    case 101..125:
      str="klein";
      break;
    case 126..150:
      str="fast mittelgross";
      break;
    case 151..175:
      str="mittelgross";
      break;
    case 176..200:
      str="grossgewachsen";
      break;
    case 201..225:
      str="sehr grossgewachsen";
      break;
    case 226..275:
      str="extrem gross";
      break;
    case 276..350:
      str="unglaublich gross";
      break;
    case 351..500:
      str="riesig";
      break;
    case 501..800:
      str="extrem riesig";
      break;
    default:
      str="titanisch";
      break;
  }  
  return str;
}

string length_to_hair()
{
  string str;

  switch(QueryProp(P_HAIR_LENGTH))
  {
    case 0..5:
      str="Glatze";
    case 6..25:
      str="extrem kurz";
      break;
    case 26..60:
      str="sehr kurz";
      break;
    case 61..100:
      str="kurz";
      break;  
    case 101..220:
      str="kinnlang";
      break;  
    case 221..400:
      str="schulterlang";
      break;
    case 401..1000:
      str="rueckenlang";
      break;  
    case 1001..1550:
      str="hueftlang";
      break;  
    case 1551..1750:
      str="knielang";
      break;  
    case 1751..2000:
      str="bodenlang";
      break;  
    default:
      str="mehr als bodenlang";
      break;  
  }
  return str;
}

string hair_desc()
{
  string str,pron,posspron;

  pron=capitalize(QueryPronoun());
  posspron=QueryPossPronoun(NEUTER,WEN,SINGULAR);
  if (QueryProp(P_HAIR_LENGTH)<6)
    str=sprintf("%s hat eine Glatze",pron);
  else 
    str=sprintf("%s traegt %s %ses, %ses, %ses Haar %s",
          pron,
          posspron,
          length_to_hair(),
          QueryProp(P_HAIR_COLOR)||"farblos",
          HAIR_TEXTURE_DESC[QueryProp(P_HAIR_TEXTURE)]||"glatt",
          HAIR_DESC_DESC[QueryProp(P_HAIR_DESC)]||"offen");
  return str;
}

string long()
{
  string str,e,art;
  
  str = "";
  art = (QueryProp(P_GENDER)==2)?"e":"er";
  e = (art=="e")?"e":"";
  str = funcall(ME->QueryProp(P_LONG));
  if (!stringp(str)||str=="") 
  {
    str = sprintf(
      "Das ist %s, ein%s %s %s von %ser Statur. %s hat %se Haut und %se Augen. %s."
      ,QueryProp(P_NAME)
      ,e
      ,size_desc()+art
      ,QueryProp(P_RACE_NAME)||"Formlos"+art
      ,QueryProp(P_STATUE)
      ,capitalize(QueryPronoun())
      ,QueryProp(P_SKIN_COLOR)||"farblos"
      ,QueryProp(P_EYE_COLOR)||"farblos"
      ,hair_desc()
      );
  }
  if (str[<1]!='\n') str+="\n";
  str+=::long();
  return str;
}

string _query_statue()
{
  mixed * data;

  data=RMASTER->QueryPropDefaults(P_STATUE,QueryProp(P_RACE));
  if (!pointerp(data))
    data=({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})});
     
  switch (QueryProp(P_ATTR_BONI)[A_ST]+QueryProp(P_ATTR_BONI)[A_CO])
  {
    case -500..-13:
      return data[(QueryProp(P_GENDER)==2)?1:0][0];
      break;
    case -12..-6:
      return data[(QueryProp(P_GENDER)==2?1:0)][1];
      break;
    case -5..-1:
      return data[(QueryProp(P_GENDER)==2?1:0)][2];
      break;
    case 0..12:
      return data[(QueryProp(P_GENDER)==2?1:0)][3];
      break;
    case 13..25:
      return data[(QueryProp(P_GENDER)==2?1:0)][4];
      break;
    case 26..40:
      return data[(QueryProp(P_GENDER)==2?1:0)][5];
      break;
    default:
      return data[(QueryProp(P_GENDER)==2?1:0)][6];
      break;
   }
}

int _set_hair_lenght(int length)
{
  if (!intp(length))
    return -1;
  if (length<0 || length>200)
    return -1;
  return Set(P_HAIR_LENGTH,length);
}

int _set_hair_desc(int desc)
{
  if (!intp(desc))
    return -1;
  if (desc<0 || desc>4)
    return -1;
  return Set(P_HAIR_DESC,desc); 
}

int _set_hair_texture(int tex)
{
  if (!intp(tex))
    return -1;
  if (0>tex || tex>5)
    return -1;
  return Set(P_HAIR_TEXTURE,tex);
}
