/*******************
** Eldarea MUDLib **
********************
**
** std/humanoid/restrictions.c - container and weight aspect of humanoids
**
** CVS DATA
** $Date: 2000/12/04 15:25:28 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: restrictions.c,v $
** Revision 1.1  2000/12/04 15:25:28  elatar
** initial release
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "/std/container/restrictions";

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/thing/properties.h"
#include <properties.h>
#include <wizlevels.h>
#include <container.h>
#include <attributes.h>
#include <defines.h>

static int _query_volume(int volume)
{
  float cost;
  
  switch(QueryProp(P_ATTR_BONI)[A_ST]+QueryProp(P_ATTR_BONI)[A_CO])
  {
    case -500..-21:
      cost=0.8;
      break;
    case 20..0:
      cost=(QueryProp(P_ATTR_BONI)[A_ST]+QueryProp(P_ATTR_BONI)[A_CO])/-100.0;
      break;
    case 1..50:
      cost=1.0+(QueryProp(P_ATTR_BONI)[A_ST]+QueryProp(P_ATTR_BONI)[A_CO])/250.0;
      break;
    default:
      cost=1.2;
      break;    
  }
  
  return to_int(QueryProp(P_SIZE)*
         QueryProp(P_SIZE)*
         QueryProp(P_SIZE)*
         0.014*
         QueryProp(P_SPECIFIC_WEIGHT)*
         cost*
         QueryProp(P_VOLUME_MULTIPLIER));
}

static int _query_weight(int weight)
{
  return to_int(QueryProp(P_VOLUME)*QueryProp(P_SPECIFIC_WEIGHT));  
}