/*******************
** Eldarea MUDLib **
********************
**
** std/inpc.c - intelligent non player characters
**
** CVS DATA
** $Date: 2000/12/04 15:19:33 $
** $Revision: 1.1 $
**
** NPC with extremely improved behaviour and interaction
**
** CVS History
**
** $Log: inpc.c,v $
** Revision 1.1  2000/12/04 15:19:33  elatar
** initial release
**
**
**
*/

#pragma strong_types

inherit "std/thing/properties";
inherit "std/living/description";
inherit "std/living/life";
inherit "std/living/attributes";
inherit "std/living/moving";
inherit "std/living/skills";
inherit "std/thing/hooks";

inherit "std/npc/combat";
inherit "std/npc/comm";
inherit "std/container/restrictions";
inherit "std/thing/commands";
inherit "std/thing/language";
inherit "std/npc/put_and_get";
inherit "std/npc/moneyhandler";
inherit "std/inpc/interaction";
inherit "std/inpc/schedules";

#include <config.h>
#include <properties.h>
#include <ansi.h>
#include <wizlevels.h>
#include <living.h>
#include <language.h>
#include <attributes.h>
#include <defines.h>
#include <health.h>

ENVCHECKPROC

void create()
{ 
  seteuid(getuid());
  ENVCHECK
  restrictions::create();
  properties::create();
  description::create();
  commands::create();
  attributes::create();
  life::create();
  enable_commands();
  comm::create();
  combat::create();
  put_and_get::add_put_and_get_commands();
  moneyhandler::create();
  skills::create();

  SetProp(P_NAME, "Niemand");
  SetProp(P_PLURAL, "Niemande");
  SetProp(P_MMSGIN, "&Name erscheint ploetzlich");
  SetProp(P_MMSGOUT, "&Name verschwindet");
  SetProp(P_ALIGN, 0);
  SetProp(P_GENDER, NEUTER );
  SetProp(P_WEIGHT, 75000);
  SetProp(P_MAX_WEIGHT, 50000);
  SetProp(P_RACE, "Npc");
  SetProp(P_MAX_HP, 250);
  SetProp(P_MAX_SP, 250);
  SetProp(P_HP,50);
  SetProp(P_SP,50);
  SetProp(P_ALCOHOL_DELAY, ALCOHOL_DELAY);
  SetProp(P_FOOD_DELAY, FOOD_DELAY);
  SetProp(P_DRINK_DELAY, DRINK_DELAY);
  SetProp(P_HEAL_DELAY, HEAL_DELAY);
  SetProp(P_POISON_DELAY, POISON_DELAY);
  SetProp(P_DRINK, 0);
  SetProp(P_FOOD, 0);
  SetProp(P_ALCOHOL, 0);
  SetProp(P_HANDS, ({ "mit blossen Haenden", 30 }) );
  SetProp(P_MAX_HANDS, 2);
  SetProp(P_NPC, 1);
  SetProp(P_BEHAVIOUR,([P_ALIGN:30,
                        P_CIVILISATION:50,
                        P_HONOR:20,
                        "city":30,
                        "greet":1]));
  AddId("wesen","wesen");
  set_heart_beat(1);
  heartbeat = 1;
}

void reset()
{

void heart_beat()
{
  if (!environment())
    return;
    
  life::heart_beat();
  if (!this_object())
    return;
  combat::heart_beat();
  if (!this_object())
    return;
  skills::heart_beat();
  interaction::heart_beat();
  schedules::heart_beat();
}

void give_notify(object ob)
{
  put_and_get::give_notify(ob);
}

int command_me(string cmd) 
{ 
  return command(cmd);
}

void init()
{
  combat::init();
  info::init();
  commands::init();
  interaction::init();
}

void catch_tell(string str)
{
  
}
