/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: laden.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
// Basierend auf Wunderland-Mudlib
//
// STD/LADEN.C --- Standardobjekt fuer einen Laden
//
// Autoren: Troy, Bongo
//
// $Revision: 1.1.1.1 $
//
// $Log: laden.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/09/07 12:02:37  Largo
// BS_STDLEN entfernt
//
// Revision 1.1  1999/07/31 21:56:26  Largo
// Initial revision
//

inherit "std/room";

#pragma strong_types

#include <properties.h>
#include <lightsource.h>
#include <moving.h>
#include <units.h>
#include <defines.h>
#include <bank.h>

#define NEED_PROTOTYPES
#include <laden.h>

#define DEF_MAX_CASH 1000   // Maximal 1000 Grundeinheiten werden gezahlt
#define DEF_MAX_STORE 5     // Max 5 Objekte einer Sorte im Laden
#define DEF_MAX_UNITS 1000  // Max 1000 von Unit-Objekten
#define DEF_BUY_FACT 3      // Objekte kosten BUY_FACT mal P_VALUE
#define COST_PER_SELL 64000 // Stimmt so ungefaehr

static int Money;

// Puffer fuer Name und Preis Strings je Objekt
private static mapping str_buf=([]);


void create() {
  ::create();
  SetProp( P_BUYFACTOR, DEF_BUY_FACT );
  SetProp( P_TRADER_GENDER, MALE );
  SetProp( P_TRADER_NEEDED, 0);
  SetProp( P_TRADER_WARNS, 1); 
  SetProp( P_MAX_CASH, DEF_MAX_CASH );
  SetProp( P_MAX_STORE, DEF_MAX_STORE );
  SetProp( P_MAX_UNITS, DEF_MAX_UNITS );
  SetProp( P_STORAGE,"/std/def_store");
  SetProp( P_COINMASTER, "/obj/coinmaster_WL");
  SetProp( P_INT_LONG, "Der Magier, der diesen Laden erschuf, fand keine Beschreibung dafuer.");
  SetProp( P_INT_SHORT, "Der Standard-Laden");
  SetProp( P_LIGHT, 1);
  SetProp(P_INDOORS,1);
  SetProp(P_USE_REAL_CASH, 0);

  AddCmd("zeige","list");
  AddCmd(({"kauf","kaufe","bestell","bestelle"}),"buy");
  AddCmd(({"verkauf","verkaufe","verk"}),"sell");
  AddCmd(({"schaetz","schaetze"}),"evaluate");
  AddCmd(({"test","teste"}),"check_weapon");

  Money = 0;
}

object FindTrader()
{
	mixed ids;

	if (QueryProp(P_TRADER_NEEDED) == 1) return present("\ntrader", this_object());

	ids     = QueryProp(P_TRADER_NEEDED);

	if (pointerp(ids) && sizeof(ids))
	{
		ids = map_array(ids, #'present, this_object());

		ids -= ({0});

		if (sizeof(ids)) return ids[0];
	}

	return 0;
}

mixed get_active_cm() {
  string cs;
  object cm;
  if(!stringp(cs=(string)QueryProp(P_COINMASTER)))
    return 0;
  if(!objectp(cm=load_object(cs)))
    return 0;
  return cm;
}

string charstr(string char, int times) 
{
  string s;
  s = "";
  if(strlen(char)!=1) return "";
  for(;times>0;times--) s += char;
  return s;
}

string radj(string str, int len)
 {
  return (charstr(" ",len)+str)[<len..];
}

string ladj(string str, int len)
 {
  return (str+charstr(" ",len))[0..len-1];
}

int list(string str) 
{
  notify_fail("Bitte 'zeige', 'zeige waffen', 'zeige ruestungen' oder\n"
    "'zeige verschiedenes' eingeben.\n");
  if(!str)
    return DoList(0);
  if(!stringp(str))
    return 0;
  if(strlen(str)<3)
    return 0;
  str=str[0..2];
  if(str=="waf")
    return DoList("IsWeapon");
  if(str=="ver")
    return DoList("NoWeaponNoArmour");
  if(str=="rue")
    return DoList("IsArmour");
}

int IsWeapon(object ob)
{
	return (member(inherit_list(ob), "std/weapon.c") != -1);
}

int IsArmour(object ob)
{
	return (member(inherit_list(ob), "std/armour.c") != -1);
}

int NoWeaponNoArmour(object ob)
{
	return (!IsArmour(ob) && !IsWeapon(ob));
}

string MakeValString(mapping vals)
 {
  int *mind;
  string ret;
  mapping currency;
  object cm;
  if(!(cm=get_active_cm()) || 
     !(currency=cm->query_coins()) ||
     !mappingp(currency) || 
     !sizeof(currency)) return "";
  ret = "";
  mind=(int*)m_indices(currency);
  for (mind = (int*)sort_array(mind, #'<); sizeof(mind); mind = mind[1..])
  {
    if (vals && vals[mind[0]]) ret += (" "+radj(vals[mind[0]][0], 5));
    else ret += "      ";
  }
  return ret;
}

mixed GetList() {
	object store, cm;
	int i, wert, max, bf;
	mixed *output, tmp, tmp2;
	string comp;
	mixed str;

	store = load_object(QueryProp(P_STORAGE));
	if (!store) return ({});
	if (!(cm = get_active_cm())) return ({});

	tmp    = all_inventory(store);
	tmp2   = ({({}),({})});
	output = ({});
	max    = cm->QueryMaxCoin();
	bf     = QueryProp(P_BUYFACTOR);

	for (i = sizeof(tmp); i--;) {

		str=str_buf[tmp[i]]; // String schon im Puffer?
		if (!str) {
			wert = tmp[i]->QueryProp(P_VALUE)*bf;
			if (wert > max) continue;
			str = ({({ sprintf("%:-40s%s\n", capitalize(
				tmp[i]->name(WER, NAME_INDEF|NAME_DESCR)),
		 		MakeValString(cm->ExchangeValue(wert))), tmp[i] })});
			str_buf+=([ tmp[i]: str ]);
		}

		// Gleiche Gegenstaende aussortieren
		comp = str[0][0][0..25];
		if (assoc(comp, tmp2, -1) == -1) {
			tmp2    = insert_alist(comp, 0, tmp2);
			output += str;
		}

	}
	// Nicht mehr benoetigte gepufferte Strings wegwerfen
	tmp=m_indices(str_buf)-tmp;
	for (i=sizeof(tmp); i--;)
		efun::m_delete(str_buf, tmp[i]);

	return output;
}

string HeadLine()
 {
  int *mind;
  string ret;
  object cm;
  mapping currency;
  if(!(cm=get_active_cm()) || !(currency=cm->query_coins()) ||

     !mappingp(currency) || !m_sizeof(currency)) return "";
  ret = "";
  mind=(int*)m_indices(currency);
  for(mind=(int*)sort_array(mind,#'<);sizeof(mind);mind=mind[1..])
    ret += radj(currency[mind[0]][4],6);
  return ret;
}

int DoList(string query_fun)
 {
  object ob;
  int i,j,indent;
  string *output,s;

  output=GetList();
  if (!sizeof(output))
    {
      write("Im Moment sind wir leider VOELLIG ausverkauft!\n");
      return 1;
    }
  s="LfdNr Bezeichnung                             "+HeadLine();
  s+=("\n"+charstr("-",strlen(s))+"\n");
  for (i=0;i<sizeof(output);i++)
    if (!query_fun || call_other(this_object(),query_fun,output[i][1]))
      s+=sprintf("%:4d. %s", i+1, output[i][0]);
  this_player()->More(s);
  return 1;
}

string spec_cost_str(mapping vals)
 {
  int *mind;
  string *ret;
  object cm;
  mapping currency;
  ret = ({});
  if(!(cm=get_active_cm()) || !(currency=cm->query_coins()) ||
     !mappingp(currency) || !m_sizeof(currency)) return "";
  mind=(int*)m_indices(currency);
  for (mind = (int*)sort_array(mind, #'<); sizeof(mind); mind = mind[1..])
    if (vals && vals[mind[0]])
      ret += ({ vals[mind[0]][0] + " " + (vals[mind[0]][0] > 1 ? currency[mind[0]][2] : currency[mind[0]][1]) });
  return "/std/player/soul"->CountUp(ret);
}

string cost_str(int wert)
 {
  object cm;
  if(!(cm=get_active_cm())) return "";
  return spec_cost_str(cm->ExchangeValue(wert));
}

int buy(string str)
 {
  int i, cost, feilscher;
  object ob, store, cm, trader;
  mapping c;
  mixed *zahl;
  string dummy, traderstr;

  string s1, s2;

  feilscher = 0;

  if (QueryProp(P_TRADER_NEEDED))
  {
    if (!(trader=FindTrader()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Hier ist keine Haendlerin, die Dir was verkaufen koennte.\n") :
      notify_fail("Hier ist kein Haendler, der Dir was verkaufen koennte.\n");
      return 0;
    }
    else if (this_player() && trader->IsEnemy(this_player()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Deine Feindin wird Dir kaum etwas verkaufen.\n") :
      notify_fail("Dein Feind wird Dir kaum etwas verkaufen.\n");
      return 0;
    }

    traderstr = capitalize(trader->name(WER, 2));
  }
  else if (QueryProp(P_TRADER_GENDER) == FEMALE) traderstr = "Die Haendlerin";
    else traderstr = "Der Haendler";

  notify_fail("WAS willst Du kaufen?\n");
  if (!str || !stringp(str)) return 0;
  sscanf(str, "%s %s", s1, s2);
  if (s1=="feilschend") 
  {
    str=s2;
    feilscher=1;
  }
  if (!str || !stringp(str) || (str=lower_case(str))=="") return 0;
  notify_fail(traderstr + " meint: Das kann ich im Lager nicht finden.\n");
  store=find_object(QueryProp(P_STORAGE));
  if (!store) return 0;
  if(!(cm=get_active_cm())) return 0;
  if (sscanf(str,"%d %s",i,dummy)==2) 
    {
      if((ob=present(dummy,store)) && ob->IsUnit())
	{
	  if(i>ob->QueryProp(P_AMOUNT) || i<1)
	    {
            write(traderstr + " meint: Soviel haben wir davon leider nicht da.\n");
	      return 1;
	    }
	  ob->SetProp(U_REQ,i);	
	}
      else
	ob=FindInStore(i);
    }
  else
    if(sscanf(str,"%d %s",i,dummy)>0 && i>0)
      {
	ob=FindInStore(i);
	if (!ob) return 0;
      }
    else
      {
	ob=present(str,store);
	if(ob && ob->IsUnit() && ob->id(str))
	  {
	    i=ob->QueryProp(P_AMOUNT);
	    ob->SetProp(U_REQ,i);
	  }
      }
  if(!ob) return 0;
  if (ob->QueryProp(P_NOSELL) || ob->QueryProp(P_NOBUY))
  {
   write(traderstr + " meint: Oh, das kann ich gar nicht verkaufen. Tut mir leid.\n");
    ob->remove();
    if (ob)
      ob->destruct();
    return 1;
  }
  cost=QueryProp(P_BUYFACTOR)*get_buy_value(ob);
  // wenn der spieler feilschen will, bitte...
  if(feilscher) 
  {  
    // der normale feilschen random
    cost = get_fcost(cost);
    // und der skillbonus
    cost = get_scost(cost);
  }  
  if (!(zahl=cm->PayCash(this_player(),cost)))
    {
      if (!cost)
      {
        write(break_string(capitalize(ob->QueryPronoun(WER))
         +" ist vollkommen wertlos. "
         +traderstr
         +" schenkt " + ob->QueryPronoun(WEN) + " Dir."));
        if (ob->move(this_player(), M_GET) <= 0)
        {
          write("Du kannst das nicht mehr tragen !\n");
          ob->move(this_object(), M_NOCHECK);
        }
      }
      else
        write(break_string(capitalize(ob->QueryPronoun(WER))+" wuerde"+
	    (ob->IsUnit() && i>1 ? "n" : "")+" "+cost_str(cost)+
	    " kosten, und Du hast"+
	    (cm->QueryMoney(this_player())<1 ? " leider garnix" :
	     " nur "+cost_str(cm->QueryMoney(this_player())))+".\n"));
      return 1;
    }
  cm->DoPurchase(zahl,this_player());
  if (QueryProp(P_USE_REAL_CASH)) Money += to_int(cost * 0.8);

  ZENTRALBANK->PutMoney(this_object(), cost);

  if (objectp(ob))
    if(!ob->IsUnit())
      log_file("LADEN_KAUF",sprintf("%s: %s fuer %d\n",
				 dtime(time()),file_name(ob),cost));
    else
      log_file("LADEN_KAUF",sprintf("%s: %d %s fuer %d\n",
				 dtime(time()),i,file_name(ob),cost));

  if(!zahl[1] || !mappingp(zahl[1]) || !m_sizeof(zahl[1]))
    write(break_string(
	  traderstr+
	  " nimmt Dir "+spec_cost_str(zahl[0])+" ab."));
  else
    write(break_string(
	  traderstr+
	  " nimmt Dir "+spec_cost_str(zahl[0])+
	  " ab und gibt Dir "+spec_cost_str(zahl[1])+" wieder."));
  if (ob->move(this_player(),M_GET)<=0)
    {
      write("Du kannst das nicht mehr tragen !\n");
      ob->move(this_object(),M_NOCHECK);
      /* Now the object he bought lies on the floor */
    }
  else
    write("Du kaufst "+ ob->name(WEN, 1) + ".\n");
  say(capitalize(this_player()->name(WER)) + " kauft " + ob->name(WEN) + ".\n");
  return 1;
}



int check_weapon(string str)
{
  int i;
  string dummy, traderstr;
  object trader,player,ob,store;

  if (QueryProp(P_TRADER_NEEDED))
  {
    if (!(trader=FindTrader()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Hier ist keine Haendlerin, die Dich beraten koennte.\n") :
      notify_fail("Hier ist kein Haendler, der Dich beraten koennte.\n");
      return 0;
    }
    else if (this_player() && trader->IsEnemy(this_player()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Deine Feindin wird Dich kaum ueber Waffen beraten.\n") :
      notify_fail("Dein Feind wird Dich kaum ueber Waffen beraten.\n");
      return 0;
    }

    traderstr = capitalize(trader->name(WER, 2));
  }
  else if (QueryProp(P_TRADER_GENDER) == FEMALE) traderstr = "Die Haendlerin";
    else traderstr = "Der Haendler";

  notify_fail("WAS willst Du testen?\n");
  if (!str || !stringp(str) || (str=lower_case(str))=="") return 0;
  notify_fail(traderstr + " meint: Das kann ich im Lager nicht finden.\n");
  store=find_object(QueryProp(P_STORAGE));
  if (!store) return 0;
  if(sscanf(str,"%d %s",i,dummy)>0 && i>0)
  {
    ob=FindInStore(i);
    if(!ob) return 0;
  }
  else if (!(ob=present(str,store))) return 0;

  notify_fail(traderstr + " meint: Das ist anscheinend keine Waffe.\n");
  if(!IsWeapon(ob)) return 0;
  player = this_player();
  if(((player->QueryAttribute(A_DEX)+8)*10)<(ob->QueryProp(P_WC)))
    write(break_string(traderstr + " sagt: "+capitalize(ob->name(WER, 1))
	+" waere keine gute Wahl fuer Dich. Du kannst sie "
      +"noch nicht benutzen."));
  else
    write(break_string(traderstr + " sagt: "+capitalize(ob->name(WER, 1))
	+" waere hervorragend fuer Dich geeignet. Damit solltest Du "
      +"keine Probleme haben."));

  tell_room(this_object(), sprintf("%s laesst sich beraten.\n", capitalize(player->name(WER))),
    ({player}));
  return 1;
}
    
mixed FindInStore(int number) {
  mixed list;

  list = GetList();
  if (number<1 || number>sizeof(list)) return 0;
  return list[number-1][1];
}

int CheckInStore(object ob, int value) {
  string fn;
  int count, maximum;
  object store,*inv;
  if(!objectp(store=load_object(QueryProp(P_STORAGE))))
    return value;
  if(!pointerp(inv=all_inventory(store)) || !sizeof(inv))
    return value;
  if(ob->IsUnit())
    maximum=QueryProp(P_MAX_UNITS);
  else
    maximum=QueryProp(P_MAX_STORE);
  fn = load_name(ob);
  for(count=0;sizeof(inv);inv=inv[1..]) {
    if(load_name(inv[0])==fn) {
      if(inv[0]->IsUnit()) count+=inv[0]->QueryProp(P_AMOUNT);
      else count++;
    }
  }
  if(count>=maximum)
    return 0; // will not be accepted.
  return (value - ((((count*100)/maximum)*(value/2))/100));
}

int evaluate(string str) {
  object ob,cm,trader;
  int am,val,ov;
  string dummy, traderstr;
  if (!str || !stringp(str) || (str=lower_case(str))=="") return 0;
  ob=present(str,this_object());
  if(!ob) ob=present(str,this_player());
  if(!(cm=get_active_cm())) return 0;
  if (!ob)
    {
      write("Hm? "+capitalize(str)+"? Wovon redest Du? \n");
      return 1;
    }
  notify_fail("Nanu, seit wann werden hier Lebewesen verkauft?\n");
  if(living(ob)) return 0;
  if (QueryProp(P_TRADER_NEEDED))
  {
    if (!(trader=FindTrader()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Hier ist keine Haendlerin, die das schaetzen koennte.\n") :
      notify_fail("Hier ist kein Haendler, der schaetzen koennte.\n");
      return 0;
    }
    else if (this_player() && trader->IsEnemy(this_player()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Deine Feindin wird Dir kaum etwas schaetzen.\n") :
      notify_fail("Dein Feind wird Dir kaum etwas schaetzen.\n");
      return 0;
    }
    traderstr = capitalize(trader->name(WER, 2));
  }
  else if (QueryProp(P_TRADER_GENDER) == FEMALE) traderstr = "Die Haendlerin";
    else traderstr = "Der Haendler";

  val=ob->QueryProp(P_VALUE);
  if(ob->IsUnit())
  am=ob->QueryProp(U_REQ);
  if(!val || !intp(val))
    {
      write(traderstr + " behauptet: Dafuer kann ich Dir nichts bieten.\n");
      return 1;
    }
  if(!(val = CheckInStore(ob,(ov=val))))
    {
      write(traderstr + " meint: Wir haben davon schon zuviel auf Lager. "+
	    "Dafuer kann ich Dir nichts bieten.\n");
      return 1;
    }

	dummy = "Naja, ich denke, " + cost_str(ov) + " waere" +
		(ob->IsUnit() && am > 1 ? "n" : "") + " " + (ob->QueryPronoun(WER)) +
		" schon wert.";

	if(ov > val && val < QueryProp(P_MAX_CASH))
		dummy += " Aber aufgrund erhoehten Lagerbestandes kann ich Dir dafuer nur " +
			cost_str(val) + " bieten.";

	if (val > QueryProp(P_MAX_CASH))
		dummy += " Aber ich bin nur " + (QueryProp(P_TRADER_GENDER) == FEMALE ?
			"eine arme, kleine Haendlerin" : "ein armer, kleiner Haendler") +
			" und kann maximal " + cost_str(QueryProp(P_MAX_CASH)) +
			" dafuer ausgeben. Geh darauf ein oder oder behalt " +
			(ob->QueryPronoun(WEN)) + ".";

	write(break_string((traderstr + " meint: " + dummy + "\n")));

	return 1;
}

int sell(string str) {
  object ob,cm,trader;
  mixed arg;
  int am;
  string s1, s2;
  int feilscher;
  
  if (!str || !stringp(str) || (str=lower_case(str))=="") return 0;
  if (QueryProp(P_TRADER_NEEDED))
  {
    if (!(trader=FindTrader()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Hier ist keine Haendlerin, der Du was verkaufen koenntest.\n") :
      notify_fail("Hier ist kein Haendler, dem Du was verkaufen koenntest.\n");
      return 0;
    }
    else if (this_player() && trader->IsEnemy(this_player()))
    {
      QueryProp(P_TRADER_GENDER) == FEMALE ?
      notify_fail("Deine Feindin wird Dir kaum etwas abkaufen.\n") :
      notify_fail("Dein Feind wird Dir kaum etwas abkaufen.\n");
      return 0;
    }
  }

  // will der spieler feilschen oder nich?
  sscanf(str, "%s %s", s1, s2);
  if (s1=="feilschend")
  {
    str=s2;
    feilscher=1;
  }

  arg = efun::explode(str, " ")-({""});
  if (arg[0]=="alles")
    {
      if ((sizeof(arg)>=3) && (arg[1]=="aus"))
      {
        ob = present(arg[2], this_player());
        if (!ob) 
        {
          write(capitalize(arg[2])+"? Woraus willst Du alles verkaufen?\n");
          return 1; 
        }
        if (ob->QueryProp(P_CNT_STATUS))
        {
          write(capitalize(ob->name(WER,1))+" ist geschlossen.\n");
          return 1;
        }
      }
      else 
        ob = this_player();
      new_sell_all(ob, feilscher);
      return 1;
    }
  /* Nur Items des Players werden verkauft!
   * ob=present(str,this_object());
   * if (!ob) ob=present(str,this_player()); */
  ob=present(str,this_player());
  if (!ob)
    {
      write(capitalize(str)+"? Sowas hast Du nicht bei Dir!\n");
      return 1;
    }
  if(ob->IsUnit() && ob->id(str)) am=ob->QueryProp(U_REQ);
  if(!(cm=get_active_cm())) return 0;
  do_sell(ob, am, feilscher);
  return 1;
}

int do_sell(object ob, int amount, int feilscher)
{
  int i, j, value, ret, ov, method; 
  string str,traderstr;
  object *inv,cm,trader;

  trader = FindTrader();

  if (QueryProp(P_TRADER_NEEDED)) traderstr = capitalize(trader->name(WER, 2));
  else if(QueryProp(P_TRADER_GENDER)==FEMALE) traderstr = "Die Haendlerin";
    else traderstr = "Der Haendler";

  if(!(cm=get_active_cm())) return 0;
  if (cm->IsCurrency(ob))
    {
      write(traderstr + " meint: Das waere ja wohl Unsinn, oder?\n");
      return 1;
    }
  if(ob->IsMoney())
    {
      write(traderstr + " meint: Wir kaufen keine fremden Waehrungen an.\n");
      return 1;
    }
  if (str=ob->QueryProp(P_NOSELL) || str=ob->QueryProp(P_NODROP))
    {
      if (!stringp(str))
	write(traderstr + " behauptet: Sowas kannst Du hier nicht verkaufen.\n");
      else
	write(str);
      return 1;
    }
  if (ob->QueryProp(P_VALUE)<=0)
    {
      write(traderstr + " meint: " +capitalize(ob->name(WER))+
	    " hat keinen materiellen Wert, tut mir leid.\n");
      return 1;
    }
  if (ob->QueryProp(P_LIGHTED))
    {
      write(traderstr + " meint: Du musst "+ob->name(WEN, 1)+" erst ausmachen.\n");
      return 1;
    }
  if (ob->QueryProp(P_UNSELLABLE)==geteuid(this_player()))
    {
    write(traderstr + " behauptet: Das wolltest Du doch behalten.\n");
    return 1;
    }
  if (ob->QueryProp(P_CURSED) && (ob->QueryProp(P_WIELDED) || ob->QueryProp(P_WORN)))
    {
    write(traderstr + " sagt: Verfluchte Gegenstaende kannst Du so auch nicht loswerden.\n");
    return 1;
    }
  if(ob->id("\nbehaelter"))
 {
    inv = deep_inventory(ob);
    if(sizeof(inv)>0 && QueryProp(P_TRADER_WARNS)) {
      write(traderstr + " meint: "+capitalize(ob->name(WER,1))+" ist nicht leer.\n");
      return 1; 
    }
    for(j=sizeof(inv);j--;) {
      if(inv[j]->QueryProp(P_UNSELLABLE)==geteuid(this_player()))
 {
        write(traderstr + " meint: In "+ob->name(WEM,1)+" ist etwas, was Du behalten wolltest.\n");
        return 1;
      }
    }
  }

  if(ob->IsUnit())
    {
      if(amount<=0)
	amount = ob->QueryProp(P_AMOUNT);
      ob->SetProp(U_REQ,amount);
      method = M_PUT;
    }
  else
    method = M_PUT | M_SILENT;

  // neu jetzt m einfacher ueberschreibbar fuer gildenboni, 
  // haendlerrabatte etc.
  value=get_sell_value(ob);
  
  if(!(value = CheckInStore(ob,(ov=value))))
    {
      write(traderstr + " meint: Wir haben davon schon zuviel auf Lager. Tut mir leid.\n");
      return 1;
    }
  ov=(ov>value && value<QueryProp(P_MAX_CASH))?1:0;  
  // naja ich hoffe das es nicht zuviel aerger macht hier was zu aendern ;)
  // ich habe die if-anweisung vorgezogen und die abfrage in den ov
  // dingsbums rausgenohmen
  if (value > QueryProp(P_MAX_CASH)) value = QueryProp(P_MAX_CASH);
  
  if (feilscher)
  {
    // der random
    value = get_fnocost(value);
    // der skill wird draufgeschlagen
    value = get_snocost(value);
  }
  
	if ((Money < value) && QueryProp(P_USE_REAL_CASH))
	{
		write("\n" + break_string("Tja, leider kann ich es mir nicht leisten, " +
			ob->name(WEN, 1) + " zu erwerben. Komm doch spaeter nochmal wieder,"
			" vielleicht habe ich bis dahin dann ja ein wenig Geld eingenommen.",
			0, (traderstr + " meint: ")));

		return 1;
	}

  // hier hab ich in der if anweisung das 'value<P_MAX_CASH' rausgenommen
  // das es a) oben abgeprueft wird und b) durch das feilschen durchaus
  // werte > P_MAX_CASH rauskommen (duerfen)
  if (ov)
  {
    write(break_string(traderstr + " sagt: Aufgrund erhoehten Lagerbestandes kann ich Dir dafuer nur "+
	  cost_str(value)+" geben."));
  }
  if (ob->QueryProp(P_NOBUY) || (ob->QueryProp(P_WC) > 150))
    {
      string was;
      was = ob->name(WEM, 1);
      if(ob->IsUnit() && (amount=ob->QueryProp(U_REQ))>1) was = "den "+was;
      if(!ob->QueryProp(P_NODROP) ||
          ob->QueryProp(P_NEVERDROP)||
	  ob->QueryProp(P_AUTOLOADOBJ))
	/* Sonst werden auch Sachen zerstoert, die man nicht weglegen kann */
	{
        write(break_string(traderstr +
	  " findet Gefallen an " + was + " und tut "+
	  ob->QueryPronoun(WEN)+" zu "+
        (QueryProp(P_TRADER_GENDER)==FEMALE?"ihren":"seinen")+" Privatsachen."));

	  give_money(value,ob,amount);
	  ob->remove(2);
	  if(ob && !ob->IsUnit()) destruct(ob);
	}
      else
	{
	  if ((str=ob->QueryProp(P_NODROP)) && stringp(str))
	    {
	      write(str);
	      return 1;
	    }
	  else
	    write("Du kannst "+ob->name(WEN,1)+" nicht verkaufen!\n");
	  return 1;
	}
    }
  else
    if (ob->move(QueryProp(P_STORAGE),method)>0)
      give_money(value,ob,amount);

  if (ob)
    say(capitalize(this_player()->name(WER)) + " verkauft " + ob->name(WEN) + ".\n");

  return 1;
}

void give_money(int value, object ob, int amount)
 {
  int *i, evc;
  mapping cash;
  object mon,cm, trader;
  if(!(cm=get_active_cm())) return;
  if (objectp(ob))
    if(!ob->IsUnit())
      log_file("LADEN_VERKAUF",sprintf("%s: %s fuer %d\n",
				 dtime(time()),file_name(ob),value));
    else
      log_file("LADEN_VERKAUF",sprintf("%s: %d %s fuer %d\n",
				 dtime(time()),amount,file_name(ob),value));
  cash=cm->ExchangeValue(value);

  if(QueryProp(P_USE_REAL_CASH))
    Money -= value;

  ZENTRALBANK->GetMoney(this_object(), value);
 
  if(QueryProp(P_TRADER_NEEDED) && (trader = FindTrader()))
    write(break_string(capitalize(trader->name(WER, 2)) + " zahlt Dir " +
      spec_cost_str(cash) + "."));
  else
    write(break_string((QueryProp(P_TRADER_GENDER) == FEMALE ? "Die Haendlerin zahlt Dir " :
      "Der Haendler zahlt Dir ") + spec_cost_str(cash) + "."));

  KwikAddCoins(cash);
}

void KwikAddCoins(mapping cash) {
	object coin, *inv;
	string* ids;
	int i, j, *mind, *gpu, flag, am;

	flag=0;
	mind=m_indices(cash);
	inv=filter_objects(all_inventory(this_player()), "IsMoney");
	ids=map_array(inv, #'load_name);
        ids=map_array(ids, #'+, ".c");
	for (i=sizeof(mind); i--;) {
		j=member_array(cash[mind[i]][1], ids);
		am=cash[mind[i]][0];
		if (j!=-1) {
			gpu=inv[j]->QueryProp(U_GPU);
			if (this_player()->MayAddWeight((inv[j]->QueryProp(P_AMOUNT)+
				am)*gpu[0]/gpu[1]-inv[j]->QueryProp(P_WEIGHT))<0) {
					j=-1;
			} else {
				inv[j]->AddAmount(am);
			}
		} 
		if (j==-1) { // hier geht kein else!
			coin=clone_object(cash[mind[i]][1]);
			coin->SetProp(P_AMOUNT, am);
			if (coin->move(this_player(), M_PUT|M_MOVE_ALL)!=1) {
				if (!flag++) write("Du kannst das Geld nicht mehr tragen !\n");
				coin->move(this_object(),M_MOVE_ALL|M_NOCHECK);
			}
		}
	}
}


int sell_all(object seller, int feilscher)
{
  object next,ob,cm;
  int flag;
  
  flag = 0;
  if(!(cm=get_active_cm())) return 0;
  ob = first_inventory(seller);
  while (ob)
    {
      next = next_inventory(ob);
      if (ob->name(WER) && (ob->short() || ob->QueryProp(P_PLURAL)) && ob->QueryProp(P_VALUE) && !ob->IsMoney())
	{
	  flag = 1;
	  write(ob->name(WER)+": ");
	  do_sell(ob, 0, feilscher);
	}
      ob = next;
    }
  if( !flag )
    write( "Hmmm, Du hast aber nicht besonders viel zu bieten...\n" );
  
  return 1;
}

int new_sell_all(mixed seller, int feilscher) {
	object* obs;
	object trader;
	string traderstr;
	int i, max;
	int cps; // cost-per-sell: dynamisches Bestimmen des Maximalwertes
	int cts; // cost-this-sell: Kosten dieses Verkaufsvorgangs

	trader = FindTrader();

	if (QueryProp(P_TRADER_NEEDED)) traderstr = capitalize(trader->name(WER, 2));
	else if(QueryProp(P_TRADER_GENDER)==FEMALE) traderstr = "Die Haendlerin";
		else traderstr = "Der Haendler";

	if (objectp(seller)) {
		obs=all_inventory(seller);
		obs=filter_objects(obs, "name");
		obs=filter_array(obs, lambda( ({'x}), ({
			#'?,	({ #'call_other, 'x, "IsMoney" }), 0,
				({ #'<, ({ #'call_other, 'x, "QueryProp", P_VALUE }), 1 }), 0,
				({ #'call_other, 'x, "QueryProp", P_NODROP }), 0,
				({ #'call_other, 'x, "QueryProp", P_NOSELL }), 0,
				({ #'call_other, 'x, "QueryProp", P_UNSELLABLE }), 0,
				({ #'call_other, 'x, "QueryProp", P_INVIS }), 0,
				({ #'!, ({ #'call_other, 'x, "QueryProp", P_PLURAL }) }), 0,
				1 }) ));
		if (sizeof(obs)==0) {
    		write(traderstr + " meint: Hmmm, Du hast aber nicht besonders viel zu bieten...\n" );
    		return 1;
		}
	} else {
		obs=seller;
	}
	max=sizeof(obs);
	for (i=0; i<max; i++) {
		cts=get_eval_cost();
		write(capitalize(obs[i]->name(WER))+":\n");
		do_sell(obs[i], 0, feilscher);
		if ((cts-=get_eval_cost()) > cps) cps=cts+1000; // 1000 als Sicherheit
		if (get_eval_cost()<cps && i<max-1) {
			call_out("new_sell_all", 0, obs[i+1..], feilscher);
			return 1;
		}
	}
	if (!objectp(seller)) write(
		traderstr+" wischt sich den Schweiss von der Stirn.\n");
	return 1;
}

// hier wird der Wert eines gegenstandes ermittelt, 
// zuerst beim kaufen
int get_buy_value(object ding)
{
  return ding->QueryProp(P_VALUE);
}

// und nun beim verkaufen
int get_sell_value(object ding)
{
  return ding->QueryProp(P_VALUE);
}

// in dieser funktion werden die kosten beim feilschen berechnet
// ohne skill, ueberschreiben wenn ihr mehr oder weniger % 
// mali/boni haben wollt oder spez. dem haendler z.b. vorteile
// gewaehren wollt oder best. gilden oder oder oder
int get_fcost(int cost)
{
  // ist der wert schon null? dann return cost
  if (cost != 0)
  {
    // hier wird berechnet was der spieler zahlt (ohne skill) 
    cost = to_int(((to_float(cost) * to_float(85+random(31)))/to_float(100))+0.5);
    if (!(cost > 0)) cost=1;
  }
  return cost;
}

// und hier wird der Skillbonus draufgehauen 
int get_scost(int cost)
{
  if (cost != 0)
  {
    "/secure/skillmaster"->Execute("feilsche", this_player(), 0);
    // die 100-x+100 konstruktion ist noetig, damit bei pos. skill
    // nat. die kosten beim kaufen _reduziert_ werden
    cost = to_int((QueryProp(P_FBONUS)!=0?to_float(cost*(100-QueryProp(P_FBONUS)+100))/100.0:cost)+0.5);
    SetProp(P_FBONUS,0);
    if (!(cost > 0)) cost=1;
  }  
  return cost;
}

// der verkaufe random
int get_fnocost(int nocost)
{
  if (nocost != 0)
  {
    // hier wird berechnet was der spieler bekommt
    nocost= to_int(((to_float(nocost)* to_float(85+random(31)))/100.0)+0.5);
    if (!(nocost > 0)) nocost =1;
  }
  return nocost;
}


// und nochmal der skillbonus diesmal zum verkaufen
int get_snocost(int nocost)
{
    if (nocost != 0)
    {
	// hier wird der skill draufgehauhen
	nocost = to_int((QueryProp(P_FBONUS)!=0?to_float(nocost*QueryProp(P_FBONUS))/100.0:nocost)+0.5);
	SetProp(P_FBONUS,0);
	if (!(nocost > 0)) nocost = 1;
     }	
     return nocost;
}

