/*******************
** Eldarea MUDLib **
********************
**
** /std/lightsource.c - std light source
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** CVS History
**
** $Log: lightsource.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/thing";

#include <properties.h>
#include <defines.h>
#include <lightsource.h> 
#include <clock.h> 


#pragma strong_types

#define WARNUNG_SEC_MIN 90
#define WARNUNG_SEC 60

static int was_lit;

ENVCHECKPROC

void create()
{
  if (!clonep()) return;
  ::create() ;

  // Eine Voreinstellung fuer die ganz vergesslichen unter uns :)
  SetProp( P_NAME, "Lichtquelle" );
  SetProp( P_PLURAL, "Lichtquellen" );
  SetProp( P_LONG, "Du siehst nichts besonderes.\n" );
  SetProp( P_GENDER, FEMALE );
  SetProp( P_MAX_FUEL, DFLT_FUEL );                   // standardmaessig voll gefuellt
  SetProp( P_FUEL, DFLT_FUEL );
  SetProp( P_LIGHTDESC, DFLT_LIGHTDESC );
  SetProp( P_DO_DESTRUCT, TRUE );
  SetProp( P_VALUE, 5 );

  AddId("lichtquelle", "lichtquellen");
  ENVCHECK
}

void init()
{
  ::init();
  add_action("light","zuende");
  add_action("extinguish","loesche"); 
  add_action("extinguish","loesch");

}

/*
 * Lichtquelle anzuenden
 */
int light(string str)
{
  int light, night, indoors;
  string tmp;

  notify_fail("Zuende was an ?\n");

  if (!str || (sscanf(str, "%s an", tmp) != 1) || !id(tmp)) return 0;
  if (environment(this_object()) != this_player()) // Player hat es nicht
  {
    notify_fail("Erstmal musst Du " + name(WEN, 0) + " haben.\n");
    return 0;
  }
  if (QueryProp(P_LIGHTED))
  {
    notify_fail(capitalize(name(WER, 1)) + " brennt schon.\n");
    return 0;
  }

  if (QueryProp(P_FUEL) <= 0)
  {
    notify_fail(capitalize(name(WER, 1)) + " ist abgebrannt.\n");
    return 0;
  }

  SetProp(P_LIGHTED, 1);

  night = UHR->IsNight();
  indoors = environment(this_player())->QueryProp(P_INDOORS);
  light = set_light(0); 
  if ((light==1 && (!night || indoors)) || (light==2 && night && !indoors))
    write("Du kannst wieder etwas sehen.\n");
  else
    write("Ok.\n");
  say(capitalize(TP->name(WER)) + " zuendet " + name(WEN, 0) + " an.\n");

  return 1;
}

int extinguish(string str)
{
  int time, light, night, indoors;

  notify_fail("Welche Lichtquelle moechtest Du loeschen ?\n");

  if (!str || !id(str)) return 0;

  if (!QueryProp(P_LIGHTED))
  {
    notify_fail(capitalize(name(WER, 1)) + " brennt gar nicht.\n");
    return 0;
  }

  if (environment() != this_player())
  {
    notify_fail("Erstmal musst Du " + name(WEN, 0) + " haben.\n");
    return 0;
  }

  SetProp(P_LIGHTED, 0);

  night = UHR->IsNight();
  light = set_light(0);
  indoors = environment(this_player())->QueryProp(P_INDOORS);
  if ((light==0 && (!night || indoors)) || (light==1 && night && !indoors)) {
    write("Es wird dunkel.\n");
    say(capitalize(this_player()->name(WER)) + " macht das Licht aus.\n");
  }
  else
  {
    write("Ok.\n");
    say(capitalize(this_player()->name(WER)) + " loescht " + name(WEN, 0) + " aus.\n");
  }

  return 1;
}

void out_of_fuel()
{
  int night, light, indoors;
  object pl, env;

  if (!QueryProp(P_LIGHTED)) return;
  env = environment();

  if (living(env)) {
    pl = env;
    env = environment(pl);
  } else if (!env) {
      remove();
      return;
  }
  night = UHR->IsNight();
  light = set_light(0);
  indoors = env->QueryProp(P_INDOORS);
  if ((light==0 && (!night | indoors)) || (light==1 && night && !indoors)) {
    if (pl) {
       tell_room(env, "Es wird dunkel, als "+
                   pl->name(WESSEN,1)+" "+name(RAW)+" verlischt.\n", ({pl}) );
       tell_object(pl,"Es wird dunkel, als Deine "+name(RAW)+" verlischt.\n");
    } else {
       tell_room(env,"Es wird dunkel, als "+name(WER,0)+" verlischt.\n");
    }
  } else {
    if (pl) {
       tell_room(env, pl->name(WESSEN,1)+" "+name(RAW)+" verlischt.\n", ({pl}) );
       tell_object(pl, "Deine "+name(RAW)+" verlischt.\n");
    } else {
       tell_room(env, capitalize(name(WER,0))+" verlischt.\n");
    }
  }
  SetProp(P_LIGHTED,0);
  SetProp(P_FUEL,0);
  while (remove_call_out("warnung")!=-1);
  while (remove_call_out("out_of_fuel")!=-1);
  if (QueryProp(P_DO_DESTRUCT)) remove();
}


void warnung() {
   object pl;
   if (!QueryProp(P_LIGHTED)) return;
   while (remove_call_out("warnung")!=-1);
   while (remove_call_out("out_of_fuel")!=-1);
   call_out("out_of_fuel", WARNUNG_SEC);
   pl = environment();
   if (living(pl))
      tell_object(pl, "Dein"+(QueryProp(P_GENDER)==FEMALE?"e":"")+ " "+
              name(RAW)+" wird gleich verloeschen.\n");
}

// Brennstoff nachfuellen
int AddFuel(int f)
{
  int diff;

  if (f <= 0) return -1;
  if (!(diff = QueryProp(P_MAX_FUEL)-QueryProp(P_FUEL))) return -2;
  if (diff > f)
  {
    SetProp(P_FUEL, QueryProp(P_FUEL) + f);
    return 0;
  }
  else
  {
    SetProp(P_FUEL, QueryProp(P_MAX_FUEL));
    return f-diff;
  }
}


void NetDeadEnvironmentReconnected() {
  ::NetDeadEnvironmentReconnected();
  if (was_lit) SetProp(P_LIGHTED,1);
}

void EnvironmentBecomesNetDead() {
  int i;
  i = QueryProp(P_LIGHTED);
  SetProp(P_LIGHTED,0);
  was_lit = i;
}

// Property - Funktionen
int _set_max_fuel(int f)
{
  if (f <= 0) f = DFLT_FUEL;
  Set(P_MAX_FUEL, f);
  if (f < Query(P_FUEL)) Set(P_FUEL, f);
  return Query(P_MAX_FUEL);
}

int _query_fuel() {
  int time;
  if (!QueryProp(P_LIGHTED)) return Query(P_FUEL);
  time = find_call_out("warnung");
  if (time != -1) time += WARNUNG_SEC;
  else if ((time=find_call_out("out_of_fuel"))==-1) time = 0;
  return time;
}

int _set_lighted(int i)
{ int fuel;
  i=!!i;
  if (Query(P_LIGHTED)==i) return i;
  if (!i) {
     fuel = Set(P_FUEL,QueryProp(P_FUEL));
     while (remove_call_out("warnung")!=-1);
     while (remove_call_out("out_of_fuel")!=-1);
     SetProp(P_LIGHT, 0);
     Set(P_LIGHTED,0);
     if (fuel<=0 && QueryProp(P_DO_DESTRUCT)) remove();
     was_lit = 0;
  }
  else {
     fuel = Query(P_FUEL);
     if (fuel > WARNUNG_SEC_MIN) call_out("warnung", fuel-WARNUNG_SEC);
     else call_out("out_of_fuel",fuel);
     SetProp(P_LIGHT, 1);
     Set(P_LIGHTED,1);
     was_lit = 1;
  }
  return i;
}

int _set_fuel(int f)
{ 
  int fuel;
  if (f>Query(P_MAX_FUEL)) f = Query(P_MAX_FUEL);
  if (f<0) {
    f = 0;
    SetProp(P_LIGHTED,0);
  }
  else if (QueryProp(P_LIGHTED)) {
    while (remove_call_out("warnung")!=-1);
    while (remove_call_out("out_of_fuel")!=-1);
    if (f>WARNUNG_SEC_MIN) call_out("warnung",f-WARNUNG_SEC);
    else call_out("out_of_fuel",f);
  }
  return Set(P_FUEL,f);
}


string query_fuel_text(int flag)
{
  int procent;

  procent = 100-(100*QueryProp(P_FUEL)/QueryProp(P_MAX_FUEL));

  if (!flag)
    switch(procent)
    {
      case 0..20:  return " wird noch lange Zeit Licht spenden.\n";
      case 21..40: return " brennt sicher noch eine Weile.\n";
      case 41..60: return " wird langsam dunkler.\n";
      case 61..80: return " wird wohl nicht mehr lange Licht spenden.\n";
      case 81..99: return " geht mit Sicherheit gleich aus.\n";
      case 100:    return " wird kein Licht mehr spenden.\n";
      default: return ::long();
    }
  
  switch(procent)
  {
    case 0:      return "neuwertig";
    case 1..20:  return "kaum abgebrannt";
    case 21..40: return "etwas abgebrannt";
    case 41..60: return "halb abgebrannt";
    case 61..80: return "weit abgebrannt";
    case 81..99: return "fast abgebrannt";
    case 100:    return "total abgebrannt";
    default: return "<unbestimmt>";
  }
}

static string _query_descr()
{
  string str;
  str=funcall(Query(P_DESCR));
  if (str) str+=" ";
  else str="";
  if (QueryProp(P_LIGHTED))
    return str+"("+QueryProp(P_LIGHTDESC) + " und " + query_fuel_text(1) + ")";
  return str+"(" + query_fuel_text(1) + ")";
}

string long()
{
  string pron;
  
  if (!stringp(pron=::long())) pron="";
  if (pron[<1]!='\n') pron+=" ";
  pron += capitalize(QueryPronoun());
  return pron += query_fuel_text(0);
}

