/*******************
** Eldarea MUDLib **
********************
**
** std/living/attributes.c - attributes for living objects
**
** CVS DATA
** $Date: 2000/12/04 10:58:19 $
** $Revision: 1.5 $
**
** attribute handling
**
** CVS History
**
** $Log: attributes.c,v $
** Revision 1.5  2000/12/04 10:58:19  elatar
** slight bugfixes
**
** Revision 1.4  2000/03/13 11:11:43  elatar
** extern methods implemented, first final
**
** Revision 1.2  1999/11/08 15:57:01  elatar
** prepared for new attribute system
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/


#pragma strong_types

#define NEED_PROTOTYPES

#include "/std/sys_debug.h"
#include "/sys/thing/properties.h"
#include <config.h>
#include <properties.h>
#include <attributes.h>
#include <defines.h>
#include <daemon.h>
#include "/sys/living/skills.h"
#include "/secure/rmaster.h"

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

/* Save variable */
mapping attributes;
mapping attr_use;
string last_att_raised,att_raised;

static void create() 
{ 
  mapping map,off;

  attr_use = attributes = ZEROATT;
  if (!off=call_other(RMASTER,"QueryOffset",0,ME->QueryProp(P_RACE)))
    off=([]);
  Set(P_ATTRIBUTES, ZEROATT);
  Set(P_ATTRIBUTES, #'_set_attributes, F_SET_METHOD);
  Set(P_ATTRIBUTES, PROTECTED, F_MODE);
  Set(P_ATTRIBUTES_USE,attr_use = ZEROATT);
  Set(P_ATTRIBUTES_USE, #'_query_attributes_use, F_QUERY_METHOD);
  Set(P_ATTRIBUTES_USE, NOSETMETHOD, F_MODE_AS);
  Set(P_ATTRIBUTES_USE, PROTECTED, F_MODE);
  map=ZEROBON;
  walk_mapping(map,#'AddVals,off);
  Set(P_ATTR_BONI,map);
  Set(P_ATTR_BONI,NOSETMETHOD,F_MODE_AS);
  Set(P_ATTR_BONI, PROTECTED, F_MODE);
  Set(P_ATTR_OFFSETS, ([]));
  Set(P_ATTR_OFFSETS, #'_query_attr_offsets,F_QUERY_METHOD);
  Set(P_ATTR_OFFSETS,NOSETMETHOD,F_MODE_AS);
  Set(P_ATTR_OFFSETS, PROTECTED, F_MODE);
  Set(P_ATTRIBUTES_MAGIC,ZEROATT);
  Set(P_ATTRIBUTES_MAGIC, PROTECTED, F_MODE);
  Set(P_ATTR_BONI_MAGIC,ZEROATT);
  Set(P_ATTR_BONI_MAGIC, PROTECTED, F_MODE);
  map=ZERORES;
  walk_mapping(map,#'AddVals,off);
  Set(P_RESISTANCES, map);
  Set(P_RESISTANCES, PROTECTED, F_MODE);
  Set(P_RESISTANCES_MAGIC,([RR_ESSENCE:0,
                            RR_CHANNELING:0,
                            RR_MENTALISM:0,
                            RR_DISEASE:0,
                            RR_POISON:0,
                            RR_PSIONS:0,
                            RR_FEAR:0,
                            RR_POWERDRAIN:0,
                            RR_ELEMENTAL:0]));
  Set(P_RESISTANCES_MAGIC, PROTECTED, F_MODE);
  Set(P_RESIST_OFFSETS, ([]));
  Set(P_RESIST_OFFSETS, #'_query_resist_offsets,F_QUERY_METHOD);
  Set(P_RESIST_OFFSETS,NOSETMETHOD,F_MODE_AS);
  Set(P_RESIST_OFFSETS, PROTECTED, F_MODE);
  //call_out("UpdateAttributes",0);
}

/*************************************************************************
** Die folgenden Funktionen sind fuer die Verwendung der Attribute und  **
** Widerstandwerte gedacht. NUR sie sollten verwendet werden, und NUR   **
** in der hier beschriebenen Art und Weise. Viele der Funktionen sind   **
** auch noch einmal andernorts in der Mudlib gekapselt, und sollten     **
** dort verwendet werden.                                               **
**                                                                      **
* *         BITTE DIE ENTSPRECHENDEN MANUAL PAGES BEACHTEN!!            **
*************************************************************************/

int AddMod(string prop, string key, int value)
{
  mapping map;
  
  map=copy_mapping(Query(prop));
  map[key]+=value;
  UpdateAll(prop,map);
  map=Query(prop+"_magic");
  return ++map[key];
}

int AddTempMod(string prop, string key, int value, int secs)
{
  call_out("DelMod",secs,prop,key,value);
  return AddMod(prop,key,value);  
}

int DelMod(string prop, string key, int value)
{
  mapping map;
 
  map=copy_mapping(Query(prop));
  map[key]-=value;
  UpdateAll(prop,map);
  map=Query(prop+"_magic");
  return --map[key];
}

int ModAtt(string key, int mod)
{
  if ( previous_object(1) 
    && this_object() 
    && query_once_interactive(this_object()))
    log_file("ARCH/attributes", 
      sprintf("%s: ModAtt(%s,%d) %O von %O (%O)\n",
                                     dtime(time())[5..],
                                     key,
                                     mod,
                                     this_object(), 
                                     previous_object(1),
                                     this_interactive()));

  attributes[key]+=mod;
  UpdateAttributes();
  return attributes[key];
}

int AttributeCheck(string key, int difficulty)
{
  OneUse(key);
  return QueryProp(P_ATTR_BONI)[key]+difficulty+d100()+QueryProp(P_GLOBAL_MOD);
}

int ResistanceCheck(string key, int difficulty)
{
  OneUse(RESATTR[key]);

  return QueryProp(P_RESISTANCES)[key]+difficulty+d100();
}

int UseAtt(string key)
{
  OneUse(key);
  return QueryProp(P_ATTRIBUTES)[key];
}

int UseAttBon(string key)
{
  OneUse(key);
  return QueryProp(P_ATTR_BONI)[key];
}

int UseResist(string key)
{
  OneUse(RESATTR[key]);
  return QueryProp(P_RESISTANCES)[key];

}

// This function will have to be real magic
string RaiseAtt()
{
  string * valid_raise, * ind, * uind;
  mapping chances;
  int i, allowed, level, * max;
  
  if ( previous_object(1) 
    && this_object() 
    && query_once_interactive(this_object()))
    log_file("ARCH/attributes", 
      sprintf("%s: RaiseAtt %O von %O (%O)\n",dtime(time())[5..],
                                     this_object(), 
                                     previous_object(1),
                                     this_interactive()));
                                    
  level=QueryProp(P_LEVEL);
  switch(level)
  {
    case 0..2:
      max=({101,101,100});
      break;      
    case 3..5:
      max=({102,102,100});
      break;      
    case 6..10:
      max=({103,102,100});
      break;      
    default:
      max=({103+(level-1)/10,102+(level+9)/20,101+(level-1)/20});
      break;      
  }
  
  ind=ALL_ATTRIBUTES;
     
  // erstmal sortieren...
  ind=sort_array(ind,
    lambda( ({'a,'b}),
            ({#'<, ({ #'[,attributes,'a }),
                   ({ #'[,attributes,'b }) }) ) );                                   

  valid_raise=ind;
  
  // maximalwerte sicherstellen *gruebel*
  if (attributes[ind[0]]>max[1])
  { 
    if (attributes[ind[0]]>=max[0])
      valid_raise-=({ind[0]});
    if (attributes[ind[1]]>=max[1])
    {
      valid_raise-=({ind[1]});
      for (i=2;i<sizeof(ind)&&attributes[ind[i]]>=max[2];i++)
        valid_raise-=({ind[i]});
    }
    else 
    {
    for (i=2;i<sizeof(ind)&&attributes[ind[i]]>=max[2];i++)
      valid_raise-=({ind[i]});     
    }
  }
  else if (attributes[ind[1]]>max[2])
  {
    for (i=2;i<sizeof(ind)&&attributes[ind[i]]>=max[2];i++)
      valid_raise-=({ind[i]});         
  }

  /*
  for (i=sizeof(ind);i-->0;)
  {
    DB(sprintf("if ( a[ind[%d]] %d >= %d\n",i,attributes[ind[i]],max[allowed]));
    if (attributes[ind[i]]>=max[allowed])
      valid_raise-=({ind[i]});
    else
      max[allowed]++;
    if (allowed<2)
        allowed++;
  }
  */
  
  // bitte nicht dreimal nacheinander, wenn noch andre da sind
  if (sizeof(valid_raise)>1)
    if (last_att_raised==att_raised)
      ind-=({att_raised});
  if (!sizeof(valid_raise))
    return 0;

  uind=valid_raise;    
  // auch die uses sortieren, die brauchen wir gleich
  uind=sort_array(uind,
    lambda( ({'a,'b}),
            ({#'<, ({ #'[,attr_use,'a }),
                   ({ #'[,attr_use,'b }) }) ) );                                   

  chances=([]);
  allowed=0;
  ind=PMASTER->QueryAttributes(QueryProp(P_PROFESSION));
  level=PMASTER->QueryType(QueryProp(P_PROFESSION));
  
  for (i=sizeof(valid_raise);i-->0;)
  {
    /* 
    // Methode A: Gestaffelte Wahrscheinlichkeit
    switch(attributes[valid_raise[i]])
    {
      default:
      case 0..50:
        chances+=([valid_raise[i]:120]);
        break;
      case 51..90:
        chances+=([valid_raise[i]:100]);
        break;
      case 91..95:
        chances+=([valid_raise[i]:80]);
        break;
      case 96..100:
        chances+=([valid_raise[i]:60]);
        break;
      case 101..105:
        chances+=([valid_raise[i]:50]);
        break;
      case 106..200:
        chances+=([valid_raise[i]:40]);
        break;
    }
    */
    
    // Methode B: Linear fallende Wahrscheinlichkeit
    if (attributes[valid_raise[i]]<110)
      chances+=([valid_raise[i]:150-attributes[valid_raise[i]]]);
    else
      chances+=([valid_raise[i]:40]);
    
    // Berufsmodifikator einrechnen
    if (member(ind,valid_raise[i])!=-1)
      chances[valid_raise[i]]=chances[valid_raise[i]]*1.2;
    else if ( level==PT_NONSPELL && member(PHYSICAL_ATTRIBUTES,valid_raise[i])!=-1 
           || level==PT_PURESPELL && member(MENTAL_ATTRIBUTES,valid_raise[i])!=-1 )
      chances[valid_raise[i]]=chances[valid_raise[i]]*1.1;
    
    // Zuletzt noch die Wahrscheinlichkeit nach der Haeufigkeit der 
    // Anwendung modifizieren
    if (attr_use[uind[0]]) // koennte 0 sein
      chances[valid_raise[i]]=chances[valid_raise[i]]*(1+(attr_use[uind[i]]/attr_use[uind[0]]*0.1));

    // wir brauchen wieder int
    chances[valid_raise[i]]=to_int(chances[valid_raise[i]]);
    // aufsummieren
    allowed+=chances[valid_raise[i]];
  }
  
  // Chancen ansehen
  //DB(sprintf("%O",chances));
  
  // tatsaechliche bestimmung
  level=random(allowed);
  
  last_att_raised=att_raised;
  att_raised="";

  for (i=0;i<sizeof(valid_raise)&&att_raised=="";i++)
  {
    if (level>chances[valid_raise[i]])
      level-=chances[valid_raise[i]];
    else
    {
      att_raised=valid_raise[i];
    }
  }  
  attributes[att_raised]++;
  UpdateAttributes();
  
  return att_raised;
}

void ClearUse()
{
  if ( previous_object(1) 
    && this_object() 
    && query_once_interactive(this_object()))
    log_file("ARCH/attributes", 
      sprintf("%s: ClearUse %O von %O (%O)\n",dtime(time())[5..],
                                     this_object(), 
                                     previous_object(1),
                                     this_interactive()));

  attr_use=ZEROATT;       
}

/*************************************************************************
** Alle folgenden Funktionen sind nur fuer den internen Gebrauch        **
** konzipiert und sollten NIE verwendet werden.                         **
*************************************************************************/

static void OneUse(string key)
{
  if (member(ALL_ATTRIBUTES,key)!=-1)
    attr_use[key]++;  
}

static void AddVals(string key,int value,mapping map)
{
  value=value+map[key];
  return;        
}

static int ValueToBonus(int value)
{
  /* switch attribute bonus evaluation */
  switch(value)
  {
    case -1000..0:
      value=(value-6)*5;
      break;
    case 1:
      value=-25;
      break;
    case 2:
      value=-23;
      break;
    case 3:
      value=-21;
      break;
    case 4:
      value=-19;
      break;
    case 5:
      value=-17;
      break;
    case 6:
      value=-15;
      break;
    case 7:
      value=-14;
      break;
    case 8:
      value=-13;
      break;
    case 9:
      value=-12;
      break;
    case 10:
      value=-11;
      break;
    case 11..12:
      value=-10;
      break;
    case 13..14:
      value=-9;
      break;
    case 15..16:
      value=-8;
      break;
    case 17..19:
      value=-7;
      break;
    case 20..22:
      value=-6;
      break;
    case 23..25:
      value=-5;
      break;
    case 26..28:
      value=-4;
      break;
    case 29..32:
      value=-3;
      break;
    case 33..36:
      value=-2;
      break;
    case 37..40:
      value=-1;
      break;
    case 60..63:
      value=1;
      break;
    case 64..67:
      value=2;
      break;
    case 68..71:
      value=3;
      break;
    case 72..74:
      value=4;
      break;
    case 75..77:
      value=5;
      break;
    case 78..80:
      value=6;
      break;
    case 81..83:
      value=7;
      break;
    case 84..86:
      value=8;
      break;
    case 87..89:
      value=9;
      break;
    case 90:
      value=10;
      break;
    case 91:
      value=11;
      break;
    case 92:
      value=12;
      break;
    case 93:
      value=13;
      break;
    case 94:
      value=14;
      break;
    case 95:
      value=15;
      break;
    case 96:
      value=17;
      break;
    case 97:
      value=19;
      break;
    case 98:
      value=21;
      break;
    case 99:
      value=23;
      break;
    case 100..1000:
      value=(value-95)*5;
      break;
    default:
      value=0;
      break;
  }
  return value;
}

static void UpAtt(string key, int value, mapping map)
{
  value=value-QueryProp(P_ATTRIBUTES)[key]+map[key];
}

varargs static void UpdateAttributes(mapping map)
{
  mapping oldattr;

  if (!mappingp(map))
    map=attributes;

  oldattr=copy_mapping(QueryProp(P_ATTRIBUTES));
  walk_mapping(QueryProp(P_ATTRIBUTES),#'UpAtt,map);

  UpdateAttributeBoni(oldattr);
  attributes=copy_mapping(map);
}

static void UpRes(string key,int value,mapping map)
{
  value=value-map[RESATTR[key]]+QueryProp(P_ATTR_BONI)[RESATTR[key]];

  return;
}


static void UpdateResistances(mapping oldboni)
{
  walk_mapping(QueryProp(P_RESISTANCES),#'UpRes,oldboni);
}

static void UpBon(string key,int value,mapping map)
{ 
  value=value-ValueToBonus(map[key])+ValueToBonus(QueryProp(P_ATTRIBUTES)[key]);

  return;
}

static void UpdateAttributeBoni(mapping oldattr)
{
  mapping oldboni;

  oldboni=copy_mapping(QueryProp(P_ATTR_BONI));
  walk_mapping(QueryProp(P_ATTR_BONI),#'UpBon,oldattr);
  ME->UpdatePoints();

  UpdateResistances(oldboni);
}


static mapping _set_attributes(mapping arr) 
{  
  if ( previous_object(1) 
    && this_object() 
    && query_once_interactive(this_object()))
    log_file("ARCH/ATTRIBUTES", 
      sprintf("%s: _set_attributes %O von %O (%O)\n",dtime(time())[5..],
                                     this_object(), 
                                     previous_object(1),
                                     this_interactive()));
  UpdateAttributes(arr);
  
  return arr;
}


int SetAttr(string attr, int val) 
{
  mapping map,oldmap;
  int oldval,xval;
  
  if(previous_object() && this_object() && query_once_interactive(this_object()))
    log_file("ARCH/ATTRIBUTES", 
      sprintf("%O: SetAttr %O von %O\n",ctime(), this_object(), previous_object()));

  oldval=attributes[attr];
  attributes[attr]=val;
  
  map=QueryProp(P_ATTRIBUTES);
  val=map[attr];
  map[attr]=map[attr]-oldval+attributes[attr];

  oldval=map[attr];
  map=Query(P_ATTR_BONI);
  oldmap=copy_mapping(map);
  
  map[attr]=map[attr]-ValueToBonus(val)+ValueToBonus(oldval);

  UpdateResistances(oldmap);
  ME->UpdatePoints();
 
  return attributes[attr];
}

int SetAttribute(string attr, int val) 
{ 
  return SetAttr(attr, val); 
}

static mapping _query_attributes_use()
{
  return copy_mapping(attr_use);
}

static mapping _query_attr_offsets()
{
  mapping map;

  map=call_other(RMASTER,"QueryOffset",0,lower_case(ME->QueryProp(P_RACE)));
  map=([A_ST:map[A_ST],
        A_AG:map[A_AG],
        A_QU:map[A_QU],
        A_CO:map[A_CO],
        A_SD:map[A_SD],
        A_RE:map[A_RE],
        A_IN:map[A_IN],
        A_EM:map[A_EM],
        A_PR:map[A_PR]]);

  return map;
}

static mapping _query_resist_offsets()
{
  mapping map;

  map=call_other(RMASTER,"QueryOffset",0,lower_case(ME->QueryProp(P_RACE)));
  map=([RR_ESSENCE      :map[RR_ESSENCE],
        RR_CHANNELING   :map[RR_CHANNELING],
        RR_MENTALISM    :map[RR_MENTALISM],
        RR_DISEASE      :map[RR_DISEASE],
        RR_POISON       :map[RR_POISON],
        RR_PSIONS       :map[RR_PSIONS],
        RR_FEAR         :map[RR_FEAR],
        RR_POWERDRAIN   :map[RR_POWERDRAIN],
        RR_ELEMENTAL    :map[RR_ELEMENTAL]]);

  return map;
}

int QueryAttribute(string attr) {
	return QueryProp(P_ATTRIBUTES)[attr];
}

static mapping _query_real_stats() {
    return copy_mapping(attributes); 
}

int QueryRealStat(string att) {
	return attributes[att];
}

static mapping _set_real_stats(mapping x) { return _set_attributes(x); }

static void UpdateAll(string prop, mapping map)
{
  mapping old;

  switch (prop)
  {
    case P_ATTRIBUTES:
      UpdateAttributes(map);
      break;
    case P_ATTR_BONI: 
      old=copy_mapping(Query(P_ATTR_BONI));
      Set(P_ATTR_BONI,map);
      ME->UpdatePoints();
      UpdateResistances(old);
      break;
    case P_RESISTANCES:
      Set(P_RESISTANCES,map);
      break;
  }
}

///////////////////////////////////////////////////////////////////////////
// Everything below this line is OBSOLET 
// it is just left for compatibility with other obsolet objects :)


public void RemoveStatMod(object ob) {}

//Obsolet!
static object* _query_statmods() {
	return 0;
}

//Obsolet
static void _set_statmods(object* x) {
}

// Filter

static int _filterattr_str(int val)
{
return 0;
}

static int _filterattr_dex(int val)
{
return 0;
}

static int _filterattr_int(int val)
{
return 0;
}

static int _filterattr_con(int val)
{
return 0;
}
