/*******************
** Eldarea MUDLib **
********************
**
** /std/living/combat.c - living combat module
**
** CVS DATA
** $Date: 2001/08/21 11:10:05 $
** $Revision: 1.5 $
**
** CVS History
**
** $Log: combat.c,v $
** Revision 1.5  2001/08/21 11:10:05  eldarea
** made var enemies private static due to inheritance problems
**
** Revision 1.4  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.3  2001/01/31 13:14:11  elatar
** first (big) changes to combat system
**
** Revision 1.2  2000/12/04 11:00:54  elatar
** completely new combat handling:
** adapted to new P_ARMOURS format
** initiative handling implemented
** pk restrictions implemented
** messages rewritten
** Attack() and attached functions completely rewritten
** Defend() completely rewritten
** HitMe() implemented
** obsolet functions removed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>

#include <config.h>
#include <properties.h>
#include <language.h>
#include <wizlevels.h>
#include <attributes.h>
#include <living.h>
#include <combat.h>
#include <defines.h>
#include <death.h>
#include <guilds.h>
#include <skills.h>
#include <rpgsys.h>
#include <room/exits.h>
#define NEED_DAMAGE_MESSAGES
#include <damage.h>

#include <living/skills.h>

#include "log.h"

#define HUNTTIME 300
#define WIMPY_SKILL "fluchtrichtung"

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n");

private static mixed enemies;
private static object pk_def;
private static int may_attack, unused_db;

// local properties prototypes
static int _query_total_ac();
static mixed _set_hands(mixed h);
static mixed _query_hands();
static int _set_wimpy(int i);
static mixed check_for_invincible();
static mixed _set_resistance(mixed res);
static mixed _set_vulnerability(mixed vul);

static void create()
{
  enemies=({({}),({})});
  Set(P_WIMPY, SAVE, F_MODE);
  Set(P_TOTAL_AC, PROTECTED, F_MODE);
//  Set(P_HANDS, SAVE, F_MODE);
  Set(P_RESISTANCE, ([]));
  Set(P_DAMAGE_RESISTANCES,([]));
  Set(P_VULNERABILITY, ([]));
  SetProp(P_INVINCIBLE, 0);
  SetProp(P_ARMOURS, ([CWL_HEAD:0;0;0;0,
                       CWL_BODY:0;0;0;0,
                       CWL_LEFT_ARM:0;0;0;0,
                       CWL_LEFT_HAND:0;0;0;0,
                       CWL_RIGHT_ARM:0;0;0;0,
                       CWL_RIGHT_HAND:0;0;0;0,
                       CWL_LEFT_LEG:0;0;0;0,
                       CWL_LEFT_FOOT:0;0;0;0,
                       CWL_RIGHT_LEG:0;0;0;0,
                       CWL_RIGHT_FOOT:0;0;0;0,
                       CWL_RINGS:({});0;0;0,
                       CWL_MISC:({});0;0;0]));
  SetProp(P_WEAPONS, ({}));
  Set(P_ATTACK_HOOKS,([]));
  Set(P_DEFEND_HOOKS,([]));
  Set(P_ATTACK_HOOKS,-1,F_SET_METHOD);
  Set(P_DEFEND_HOOKS,-1,F_SET_METHOD);
  Set(P_INITIATIVE,-1,F_SET_METHOD);
  Set(P_PK_LEVEL,SAVE,F_MODE_AS);
  Set(P_ATTACK_WEIGHT,SAVE,F_MODE_AS);
}

/* external methods */

varargs void SetAttackHook(object ob, string fun, int expire)
{
  if (!objectp(ob)||!stringp(fun))
    return;
  if (!intp(expire))
    expire=0;
  Set(P_ATTACK_HOOKS,Query(P_ATTACK_HOOKS)+([ob:fun;expire]));
}

varargs void SetDefendHook(object ob, string fun, int expire)
{
  if (!objectp(ob)||!stringp(fun))
    return;
  if (!intp(expire))
    expire=0;
  Set(P_DEFEND_HOOKS,Query(P_DEFEND_HOOKS)+([ob:fun;expire]));  
}

void DelAttackHook(object ob)
{
  Set(P_ATTACK_HOOKS,m_delete(Query(P_ATTACK_HOOKS),ob));
}

void DelDefendHook(object ob)
{
  Set(P_DEFEND_HOOKS,m_delete(Query(P_DEFEND_HOOKS),ob));
}

int UpdateInitiative(int oldval,int newval)
{
  return Set(P_INITIATIVE,QueryProp(P_INITIATIVE)-oldval+newval);  
}

int AddIniMod(int mod)
{
  return Set(P_INITIATIVE,QueryProp(P_INITIATIVE)+mod);
}

int DelIniMod(int mod)
{
  return Set(P_INITIATIVE,QueryProp(P_INITIATIVE)-mod);
}

int AddTempIniMod(int mod,int secs)
{
  call_out("DelIniMod",secs,mod);
  return AddIniMod(mod);
}

/* mudlib internals */

/*
 * kill - start combat
 * Sets the enemy thus starting combat
 */
int Kill(object ob)
{
  object defending, attacking;

  if (!objectp(ob)) return 0;

  if (ob->QueryProp(P_GHOST))
  {
    tell_object(ME,ob->name(WER)+" ist doch schon tot!\n");
    return 1;
  }

  if (query_once_interactive(this_object()) && query_once_interactive(ob))
  {
    attacking = this_interactive();
    if (attacking == ob)
      defending = this_object();
    else
      defending = ob;
    if (defending->QueryProp(P_PK_LEVEL)<attacking->QueryProp(P_LEVEL))
    {
      if (attacking->IsEnemy(defending))
        attacking->StopHuntFor(defending,1);
      if (defending->IsEnemy(attacking))
        defending->StopHuntFor(attacking,1);
      tell_object(attacking,"Sucht Euch einen wuerdigen Gegner!\n");
      return 1;
    }
    if (!IS_LEARNER(attacking))
    {
      attacking->did_pk(attacking, defending);
    }
    
  }
  if (!InsertEnemy(ob) && !QueryProp(P_NPC))
     tell_object(ME,"Ihr kaempft doch schon gegen "+ob->name(WEN)+".\n");
  return 1;
}

int InsertEnemy(object ob)
{
  int i;

  if (ob == ME)
    return 0;
  if (!objectp(ob) || ob->QueryProp(P_GHOST)) // gum: den living check erstmal wieder rausgenommen || !living(ob))
    return 0;
  if((i = member_array(ob, enemies[0]))>-1)
    return 0;
  if(i>0)
    {
      enemies[0]=enemies[0][0..i-1]+enemies[0][i+1..];
      enemies[1]=enemies[1][0..i-1]+enemies[1][i+1..];
    }
  enemies[0]=({ob})+enemies[0];
  enemies[1]=({HUNTTIME})+enemies[1];
  set_heart_beat(1);
  return 1;
}

void do_enemy_heart_beat(object enemy)
{
  if(ME->QueryProp(P_WIMPY) > ME->QueryProp(P_HP))
  {
    Flee();
    if (!enemy || !ME || environment(enemy) != environment(ME));
      return;   
  }
  Attack(enemy);      
}

/*
 * combat heart beat. This is called from the main heart_beat.
 * We call the Attack() function if there is a reason to attack
 * someone. There are several reasons:
 * - I'm currently attacked by someone.
 */
void heart_beat()
{
  int i, c,initiative;
  mixed *here;

  if (!this_object()) return;
  here=({});
  // WICHTIG, wird auch fuers defend gebraucht
  initiative=QueryProp(P_INITIATIVE)+d100()+UseActiveSkill(SK_QUICKFIGHT);
  if (initiative<151)
    may_attack=1;
  else
    may_attack=(initiative+50)/100;
  unused_db=QueryProp(P_DB)*may_attack;
  for(i=0;i<sizeof(enemies[0]);i++)
  {
    while (i<sizeof(enemies[0])&&(!objectp(enemies[0][i])||
           enemies[0][i]->QueryProp(P_GHOST)))
    {
      enemies[0]=enemies[0][0..i-1]+enemies[0][i+1..];
      enemies[1]=enemies[1][0..i-1]+enemies[1][i+1..];
    }
    if (i<sizeof(enemies[0]))
      if (environment()==environment(enemies[0][i]))
      {
        here+=({enemies[0][i]});
        enemies[1][i]=HUNTTIME;
      }
      else
      {
        enemies[1][i]--;
        if(!enemies[1][i]) StopHuntFor(i);
      }
    }
  c=(int)this_object()->QueryProp(P_DISABLE_ATTACK);
  if (c)
  {
    this_object()->SetProp(P_DISABLE_ATTACK, --c);
    return;
  }
  c=sizeof(here);
  if (c)
  {
    for (i=may_attack;i-->0;)
    {
      do_enemy_heart_beat(here[random(c)]);
    }
  }
}

int update_hunt_times(int beats)
{
  int i;

  for (i=0;i<sizeof(enemies[0]);i++)
    {
      while (i<sizeof(enemies[0])&&(!objectp(enemies[0][i])||
             enemies[0][i]->QueryProp(P_GHOST)))
	{
	  enemies[0]=enemies[0][0..i-1]+enemies[0][i+1..];
	  enemies[1]=enemies[1][0..i-1]+enemies[1][i+1..];
	}
      if (i<sizeof(enemies[0]))
	{
	  enemies[1][i]-=beats;
	  if(enemies[1][i]<=0)
	    {
	      enemies[0]=enemies[0][0..i-1]+enemies[0][i+1..];
	      enemies[1]=enemies[1][0..i-1]+enemies[1][i+1..];
	      i--;
	    }
	}
    }
}

int IsEnemy(object wer)
{
  return (member_array(wer, enemies[0])!=-1);
}

void StopHuntMessage(object enemy)
{
  if (!objectp(enemy)) return;
  tell_object(enemy, capitalize((string)ME->name(WER)) + " jagt Dich nun nicht mehr.\n");
  tell_object(ME, "Du jagst " + enemy->name(WEN) + " nicht mehr.\n");
}

varargs mixed StopHuntingMode(int silent)
{
  mixed *save_enemy;
  int i;

  save_enemy = enemies;
  // I think we dont need 'em
  //if (!silent) map_array(enemies[0], #'StopHuntMessage);
  enemies = ({({}), ({})});
  return save_enemy;
}

varargs int StopHuntFor(mixed arg, int silent)
{
  if (!objectp(arg) && !intp(arg))
    return 0;
  if (!intp(arg)) arg=member_array(arg, enemies[0]);
  if (arg<0 || arg>=sizeof(enemies[0]))
    return 0;
  /* I think we dont need this
  if (!silent && enemies[0][arg])
    {
      tell_object(enemies[0][arg],
		  capitalize(ME->name(WER))+" jagt Dich nicht mehr.\n");
      tell_object(ME,"Du jagst "+enemies[0][arg]->name(WEN)+" nicht mehr.\n");
    }*/
  enemies[0]=enemies[0][0..arg-1]+enemies[0][arg+1..];
  enemies[1]=enemies[1][0..arg-1]+enemies[1][arg+1..];
  return 1;
}

private void GetArmourDefend(object enemy, int damage, mixed damage_type, object *armours)
{
  int i;
  mixed arm_dam_type;

  if (!enemy || !armours || !(i = sizeof(armours))) return;
  while (i--)
  {
    if (armours[i] && objectp(armours[i]))
    {
      damage += (int)armours[i]->QueryArmourDamage(enemy);
      arm_dam_type = (mixed)armours[i]->QueryProp(P_DAM_TYPE);
      if (pointerp(arm_dam_type))  damage_type += arm_dam_type;
      else  damage_type += ({ arm_dam_type });
    }
  }
}

private int DoAttack(object enemy, string dam_msg, string dam_msg2, int damage, mixed damage_type,string attack_type, int roll)
{
  object *excludes;
  string how;

  if (!enemy || enemy->QueryProp(P_GHOST)) return 0;

  excludes = filter_objects(all_inventory(environment(ME)), "QueryProp", P_NO_FIGHT_TEXT);
  excludes += ({ ME, enemy });

  // TODO: blindness handling aendern
  if (ME->QueryProp(P_BLIND)) damage = random(damage / 2);

  switch(roll)
  {
    case 25..40:
      how=" sehr schwache";
      break;
    case 41..60:
      how=" schwache";
      break;
    case 61..80:
      how=" maessige";
      break;
    case 81..100:
      how=" leidliche";
      break;
    case 101..120:
      how=" gelungene";
      break;
    case 121..140:
      how=" geschickte";
      break;
    case 141..160:
      how=" sehr geschickte";
      break;
    case 161..180:      
      how=" vortreffliche";
      break;
    case 181..200:
      how=" aussergewoehnliche";
      break;
    case 201..220:
      how=" hervorragende";
      break;
    case 221..240:
      how=" ausgezeichnete";
      break;
    case 241..260:
      how=" glaenzende";
      break;
    case 261..280:
      how=" meisterliche";
      break;
    case 281..300:
      how=" exzellente";
      break;
    case 301..320:
      how=" brilliante";
      break;
    case 321..340:
      how=" fantastische";
      break;
    case 341..360:
      how=" unglaubliche";
      break;
    case 361..380:
      how=" perfekte";
      break;
    default:
      how=" vollendete";
      break;
  }

  if (!ME->QueryProp(P_NO_FIGHT_TEXT))
    tell_object(ME, sprintf("  Ihr fuehrt eine%s Attacke %s gegen %s.\n",  
                how,dam_msg2,enemy->name(WEN, 1)));
  if (!enemy->QueryProp(P_NO_FIGHT_TEXT))
    tell_object(enemy, sprintf("    %s fuehrt eine%s Attacke %s gegen Euch.\n",
                capitalize((string)ME->name(WER, 1)),how, dam_msg2));
  tell_room(environment(ME), sprintf("  %s fuehrt eine%s Attacke %s gegen %s.\n",
            capitalize((string)ME->name(WER, 2)), how, dam_msg, enemy->name(WEN, 1)), excludes);

  return (int)enemy->Defend(damage, damage_type, 0, ME, roll, attack_type);
}

private void AttackSkill(object enemy, int damage, mixed damage_type, int spell)
{
  int learn;
  mixed arr, at_sk;
  mapping map;
  string skillname, file;

  if (!enemy || enemy->QueryProp(P_GHOST)) return;

  if ((int)ME->QueryProp(P_COMBAT_SKILLS) & 1)
  {
    if (sizeof((map = ME->QueryProp(P_ACTIVE_SKILLS)[CS_ATTACK])))
    {
      arr = m_indices(map);
      // es wird nur ein combat-skill genommen (per zufall)
      skillname = arr[random(sizeof(arr))];
      at_sk = map[skillname];

      if ((file = SM->QueryProp(skillname, P_SM_FILE)) != "")
        damage += call_other(file, sprintf("_cast_%s", skillname), enemy, damage);
      else
      {
        if (random(1000) < ME->GetProbability(skillname))
        {
          damage += (int)(damage * ME->GetProbability(skillname) * ME->QueryAttribute(at_sk[P_ATT_STAT]) * at_sk[P_ATT_FACT] / 4000000);
          if (strlen(at_sk[P_ATT_MAGIC]))
          {
            damage_type += ({ at_sk[P_ATT_MAGIC] });
            spell = 1;
          }
        }
        else
          if (damage > 0)
          {
            switch (ME->QueryAttribute(A_INT) + ME->QueryAttribute(A_DEX) + damage / 20)
            {
              case 0..9   : learn=0; break;
              case 10..19 : learn=1; break;
              case 20..29 : learn=2; break;
              case 30..45 : learn=3; break;
              default     : learn=4;
            }
            ME->GiveAbility(skillname, GetProbability(skillname) + learn);
          }
        }
    }
  }
}

private void AttackWithHands(object enemy, object *armours)
{
  mixed hands;
  int damage, spell;
  mixed damage_type;
  string dam_msg;

  hands = ME->QueryProp(P_HANDS);
  damage = random(hands[1]+1);
  damage = (2*damage + 10*ME->QueryAttribute(A_STR)) / 3;
//  damage = damage / 2 + random(damage / 2);
  damage_type = hands[2];
  if (!damage_type) damage_type = ({ DT_BLUDGEON });
  if (!pointerp(damage_type)) damage_type = ({ damage_type });
  dam_msg = hands[0];
  spell = 0;

  AttackSkill(enemy, &damage, &damage_type, &spell);
  GetArmourDefend(enemy, &damage, &damage_type, armours);
  // msg1 und msg2 zwei sind gleich, deshalb wird hier nur eine variable benutzt
  //DoAttack(enemy, dam_msg, dam_msg, damage, damage_type, spell);
}

private void OneWeaponAttack(object enemy, object weapon, object *armours, int skill)
{
  int damage, spell;
  mixed damage_type;
  string dam_msg, dam_msg2;

  damage = weapon->QueryDamage(enemy);
  damage_type = weapon->QueryProp(P_DAM_TYPE);
  if (!damage_type) damage_type = ({ DT_BLUDGEON });
  if (!pointerp(damage_type)) damage_type = ({ damage_type });
  if(query_once_interactive(ME))
    COMBAT_MASTER->CheckWeaponDamage(weapon, ME, enemy, damage, damage_type);
  dam_msg = sprintf(" mit %s", weapon->name(WEM, 0));
  dam_msg2 = sprintf(" mit %s", weapon->name(WEM, 1));
  spell = 0;

  if (skill) AttackSkill(enemy, &damage, &damage_type, &spell);
  GetArmourDefend(enemy, &damage, &damage_type, armours);
  //damage=DoAttack(enemy, dam_msg, dam_msg2, damage, damage_type, spell);
  if(objectp(weapon)) weapon->DidDamage(damage, enemy);
}

private void FailAttack(object enemy)
{
  object *excludes;

  excludes = filter_objects(all_inventory(environment(ME)), "QueryProp", P_NO_FIGHT_TEXT);
  excludes += ({ ME, enemy });

  if (!ME->QueryProp(P_NO_FIGHT_TEXT))
    tell_object(ME, sprintf("  Eure Attacke gegen %s ist zu schlecht gefuehrt, um zu treffen.\n",enemy->name(WEN)));
  if (!enemy->QueryProp(P_NO_FIGHT_TEXT))
    tell_object(enemy, sprintf("    %s Attacke gegen Euch ist zu schlecht gefuehrt, um zu treffen.\n",
                capitalize((string)ME->name(WESSEN, 1)) ));
  tell_room(environment(ME), sprintf("  %s Attacke gegen %s ist zu schlecht gefuehrt, um zu treffen.\n",
            capitalize((string)ME->name(WESSEN, 2)),  enemy->name(WEN, 1)), excludes);

}

private varargs void WeaponAttack(object weapon, object enemy,int mod)
{
  int roll,damage;
  mixed att_type,dam_type;
  string dam_msg1,dam_msg2;

  if (!objectp(weapon))
    return;

  roll=random(100)+1;
  if (roll<=weapon->QueryProp(P_FUMBLE_RANGE)&&!random(100))
    return FumbleWeapon(weapon, enemy);
  if (roll<6)
    roll=_d100low(roll);
  else if (roll>95)
    roll=_d100high(roll);
  
  att_type=weapon->QueryProp(P_WEAPON_TYPE);
  roll+=to_int(  (ME->UseAttackSkill(att_type)+weapon->QueryProp(P_ATTACK_MOD))
                 *QueryProp(P_ATTACK_WEIGHT)/100)
                 +mod+QueryProp(P_GLOBAL_MOD);
  if (roll<25)
    return FailAttack(enemy);

  dam_type=weapon->QueryProp(P_DAM_TYPE);
  if (!dam_type)
    dam_type=({DT_BLUDGEON});
  else if (!pointerp(dam_type))
    dam_type=({dam_type});
  dam_msg1=sprintf(" mit %s",weapon->name(WEM,0));
  dam_msg2=sprintf(" mit %s",weapon->name(WEM,1));
  damage=weapon->QueryDamage();
  damage=DoAttack(enemy,dam_msg1,dam_msg2,damage,dam_type,att_type,roll);
  weapon->TakeDamage();
  weapon->DidDamage(damage,enemy);
}

private void HandAttack(object enemy)
{
  int roll,damage;
  mixed att_type,dam_type,hands;
  string dam_msg;

  roll=random(100)+1;

  if (roll<3&&!random(100))
    return FumbleHands(enemy);
  if (roll<6)
    roll=_d100low(roll);
  else if (roll>95)
    roll=_d100high(roll);
  roll=roll+ME->UseSkill(SK_MARTIAL_ARTS)+QueryProp(P_GLOBAL_MOD);
  if (roll<25)
    return FailAttack(enemy);
  
  hands=QueryProp(P_HANDS);
  if (!pointerp(hands)|| sizeof(hands)!=4)
    hands=SetProp(P_HANDS,({"mit blossen Haenden",30,({DT_BLUDGEON}),({WT_FIST})}));
  dam_msg=hands[0];
  damage=hands[1];
  dam_type=hands[2];
  att_type=hands[3];
  if (!dam_type)
    dam_type=({DT_BLUDGEON});
  else if (!pointerp(dam_type))
    dam_type=({dam_type});
  
  DoAttack(enemy,dam_msg,dam_msg,damage,dam_type,att_type,roll);
}

private void AllWeaponAttack(object enemy, object *weapons, object *armours)
{
  int i, j, damage, spell, weapon_number, armour_number, skill_attack;
  mixed damage_type;
  string dam_msg, dam_msg2;
  mapping armour_attack;

  weapon_number = sizeof(weapons);
  skill_attack = random(weapon_number);	 // bei welchem schlag soll ein skill ausgefuehrt werden

  armour_number = sizeof(armours);
  armour_attack = ([]);

  for (i = 0; i < armour_number; i++)
  {
    j = random(weapon_number);
    if (member(armour_attack, j)) armour_attack[j] += ({ armours[i] });
    else armour_attack += ([ j : ({ armours[i] }) ]);
  }

  for (i = 0; i < weapon_number; i++)
  {
    if (member(armour_attack, i))
      OneWeaponAttack(enemy, weapons[i], armour_attack[i], (i == skill_attack));
    else
      OneWeaponAttack(enemy, weapons[i], ({}), (i == skill_attack));
  }
}

void CheckTmpAttackHook(object enemy)
{
  mixed res;

  if (!enemy || !objectp(enemy)) return;
  if (res = QueryProp(P_TMP_ATTACK_HOOK))
  {
    if (pointerp(res) && sizeof(res) == 3 && intp(res[0]) &&
       time() < res[0] && objectp(res[1]) && stringp(res[2]))
    {
      if (!(res = call_other(res[1], res[2], enemy))) return;
    }
    else SetProp(P_TMP_ATTACK_HOOK, 0);
  }
}

void Attack(object enemy)
{
  object *weapons;
  mapping hooks;
  int i;

  if (!enemy || !objectp(enemy) || enemy->QueryProp(P_GHOST) 
    || this_object()->QueryProp(P_GHOST)) return;

  /* obsolet
  CheckTmpAttackHook(enemy);
  */
  if (!mappingp(hooks=QueryProp(P_ATTACK_HOOKS)))
    Set(P_ATTACK_HOOKS,([]));
  else
  {
    weapons=m_indices(hooks);
    for (i=sizeof(hooks);i-->0;)
    {
      if ( !objectp(weapons[i]) 
        || !stringp(hooks[weapons[i],1]) 
        || (hooks[weapons[i],2] && hooks[weapons[i],2]<time()) )
        hooks=m_delete(hooks,weapons[i]);
      else
        if (!call_other(weapons[i],hooks[weapons[i],1],ME,enemy))
          return;
    }
    Set(P_ATTACK_HOOKS,hooks);
  }

  weapons = ME->QueryProp(P_WEAPONS);

  if (!sizeof(weapons))
    return HandAttack(enemy);
  for (i=sizeof(weapons);i-->0;)
    WeaponAttack(weapons[i],enemy/* modifier fuer mehrere waffen */);
  return;

/* obsolet
  switch (sizeof(weapons))
  {
    case 0:
      AttackWithHands(enemy, armours);
      break;
    case 1:
      OneWeaponAttack(enemy, weapons[0], armours, 1);
      break;
    default:
      AllWeaponAttack(enemy, weapons, armours);
  }
*/
}

private int Summe(int *array)
{
  int sum, size;

  if (!array || !(size = sizeof(array))) return 0;
  sum = 0;
  while (size--) sum += array[size];

  return sum;
}

void CheckTmpDefendHook(object enemy, int dam, mixed dam_type, int spell)
{
  mixed res;

  if (res = QueryProp(P_TMP_DEFEND_HOOK))
  {
    if (pointerp(res) && sizeof(res) == 3 && intp(res[0]) &&
       time() < res[0] && objectp(res[1]) && stringp(res[2]))
    {
      if (res = call_other(res[1], res[2], dam, dam_type, spell, enemy))
      {
        if (pointerp(res) && sizeof(res) == 3 &&
           intp(res[0]) && pointerp(res[1]))
        {
          dam = res[0];
          dam_type = res[1];
          spell = res[2];
        }
      }
      else SetProp(P_TMP_DEFEND_HOOK, 0);
    }
  }
}

/*
 * Neue Reihenfolge fuer Defend()

 - parry
 - passive db
 - active db
 - apply to armour
 - apply to skin
 - hit
 *
*/
varargs int Defend(int dam, mixed dam_type, int spell, object enemy, int roll, string att_type)
{
  int cas, xp, s, j, i;
  string what, how, hit_location;
  object *excludes, *weapons, weapon;
  mixed invincible;
  mapping hooks, armours;

  if (!enemy) enemy = this_player();
  else if (query_once_interactive(enemy) 
        && query_once_interactive(ME) 
        && enemy->QueryProp(P_LEVEL)>ME->QueryProp(P_PK_LEVEL)
        && !IS_LEARNER(enemy) ) 
    enemy->did_pk(enemy, ME);

  if (!enemy || enemy->QueryProp(P_GHOST)) 
    return 0;

  if (invincible = check_for_invincible())
  {
    // noattack...brauchma des??
    if (invincible[0]) tell_object(enemy, break_string(invincible[0]));
    if (invincible[1]) tell_room(environment(), break_string(
                         invincible[1]), ({enemy}));
    enemy->StopHuntFor(ME, 1);
    ME->StopHuntFor(enemy, 1);
    return 0;
  }

  if (!pointerp(dam_type)) 
    dam_type = ({ dam_type });
  if (!IsEnemy(enemy)) 
    InsertEnemy(enemy);
  if (!roll) 
    roll=50;
  if (!stringp(att_type)) 
    att_type=WT_FIST;

  /* Obsolet
  CheckTmpDefendHook(enemy, dam, dam_type, spell);
  */

  if (!mappingp(hooks=QueryProp(P_DEFEND_HOOKS)))
    Set(P_DEFEND_HOOKS,([]));
  else
  {
    weapons=m_indices(hooks);
    for (i=sizeof(hooks);i-->0;)
    {
      if ( !objectp(weapons[i]) 
        || !stringp(hooks[weapons[i],1]) 
        || (hooks[weapons[i],2] && hooks[weapons[i],2]<time()) )
        hooks=m_delete(hooks,weapons[i]);
      else
        if (!call_other(weapons[i],hooks[weapons[i],1],ME,enemy))
          return 0;
    }
    Set(P_DEFEND_HOOKS,hooks);
  }

  /* Warum sollten Waffen und Ruestungen noch zusaetzlich abwehren ?? -> OBSOLET
  dam -= Summe(map_objects(ME->QueryProp(P_ARMOURS), "QueryDefend", dam, dam_type, spell, enemy));
  dam -= Summe(map_objects(ME->QueryProp(P_WEAPONS), "QueryWeaponDefend", dam, dam_type, spell, enemy));
  */
  /* Ich hab keine Idee, warum der Gegner bis hier nicht mehr da sein sollte
  if (!objectp(enemy)) 
    return 0;
  */
  /* koerperschutz bei nicht-spells. Hm.
  if (!spell)
    dam -= (random (ME->QueryProp(P_BODY) + ME->QueryAttribute(A_DEX)) - 1);
  dam /= 10;
  */
  /* Da wird der Schaden wohl auch linear beeinflusst. Kommt aber fruehestens im HitMe()
  dam = CheckResistance(dam_type, dam);
  */
  if (dam < 0) 
    dam = 0;
  /* combat skills. langsam denke ich, ich haette Defend() gleich ganz neu machen sollen :)
  if ((ME->QueryProp(P_COMBAT_SKILLS) & 2) && sizeof(ME->QueryProp(P_ACTIVE_SKILLS)[CS_DEFEND]))
  {
    int protect, i, j;
    mapping map;
    mixed arr, df_sk;
	string file;

    map = ME->QueryProp(P_ACTIVE_SKILLS)[CS_DEFEND];
    protect = 0;
    arr = m_indices(map);
    // Nur einen Spell je Kampfrunde (per zufall)
    i = random(sizeof(arr));

    df_sk = m_values(map)[i];

    if ((file = SM->QueryProp(arr[i], P_SM_FILE)) != "")
      protect += call_other(file, sprintf("_cast_%s", arr[i]), dam, dam_type, spell, enemy);
    else
    {
      if ((spell & (member_array(df_sk[P_DEF_MAGIC], dam_type)>-1)) || !spell)
      {
        if (random(1000) < ME->GetProbability(arr[i]))
          protect += (int) df_sk[P_DEF_STAT] * ME->GetProbability(arr[i]) * df_sk[P_DEF_FACT] / 200000;
        else
        {
           switch (ME->QueryAttribute(A_INT) + ME->QueryAttribute(A_DEX) + dam)
           {
             case 0..10  : j = 0; break;
             case 11..25 : j = 1; break;
             case 26..40 : j = 2; break;
             case 41..60 : j = 3; break;
             default : j = 4;
           }
           ME->GiveAbility(arr[i], GetProbability(arr[i]) + j);
        }
      }
    }
    
    dam -= random(protect/2) + protect/2;
    if (dam < 0 ) dam = 0;
  }
  */
  /* Neues blind handling. DB sollte sinken, das ist alles
  if (ME->QueryProp(P_BLIND)) dam += random(dam/3);
  */

  excludes = filter_array(all_inventory(environment()), lambda( ({ 'ob }),
    ({ #'==, 1, ({ #'call_other, 'ob, "QueryProp", P_NO_FIGHT_TEXT }) }) ));
  excludes += ({ ME, enemy });
  
  // Oki, dann man los mit den Neuerungen

  // Parry
  weapons=enemy->QueryProp(P_WEAPONS);
  if (may_attack && -1!=member(WEAPON_ATTACK_TYPES,att_type) && sizeof(weapons) && objectp(weapons[0]))
  {
    may_attack--;
    i=weapons[0]->QueryProp(P_GENDER);
    roll-=UseAttackSkill(weapons[0]->QueryProp(P_WEAPON_TYPE))*(100-QueryProp(P_ATTACK_WEIGHT))/100;
    if (roll<0)
    {
      if (QueryProp(P_NO_FIGHT_TEXT)!=1)
        tell_object(ME,sprintf("  Du parierst %s Angriff mit Dei%s %s.\n",enemy->name(WESSEN),({"em","em","er"})[i],weapons[0]->name(WEM)));
      if (enemy->QueryProp(P_NO_FIGHT_TEXT)!=1)  
        tell_object(enemy,sprintf("  %s pariert Deinen Angriff mit %s %s.\n",capitalize(ME->name(WER)),ME->QueryPossPronoun(i,WESSEN,SINGULAR),weapons[0]->name(WEM)));
      tell_room(environment(),sprintf("%s pariert %s Angriff mit %s %s.\n",capitalize(ME->name(WER)),enemy->name(WESSEN),ME->QueryPossPronoun(i,WESSEN,SINGULAR),weapons[0]->name(WEM)),excludes);
      weapons[0]->TakeDamage();
      return 0;
    }
  }

  // passive/inherent defense
 
  roll-=QueryProp(P_INHERENT_DB);
  if (roll<0)
    return EvadeAttack(enemy);

  // active db

  if (roll<unused_db)
  {
    unused_db-=roll;
    roll=0;
  }
  else
  {
    roll-=unused_db;
    unused_db=0;
  }
  if (roll<=0)
    return EvadeAttack(enemy);
  
  // schadensberechnung
  dam=to_int((dam*roll)/100.0);

  // hier muessen noch magische schutzvorkehrungen wirken (resistance mapping?)

  // random hit location
 
  switch(random(100))
  {
    case 0..7:
      hit_location=CWL_HEAD;
      break;
    case 8..27:
      hit_location=CWL_BODY;
      break;
    case 28..41:
      hit_location=CWL_RIGHT_ARM;
      break;
    case 42..46:
      hit_location=CWL_RIGHT_HAND;
      break;
    case 47..60:
      hit_location=CWL_LEFT_ARM;
      break;
    case 61..65:
      hit_location=CWL_LEFT_HAND;
      break;
    case 66..77:
      hit_location=CWL_RIGHT_LEG;
      break;
    case 78..82:
      hit_location=CWL_RIGHT_FOOT;
      break;
    case 83..94:
      hit_location=CWL_LEFT_LEG;
      break;
    case 95..99:
      hit_location=CWL_LEFT_FOOT;
      break;
    default:
      tell_room(environment(),break_string(
        "Fehler bei der Trefferzonenberechnung. Bitte benachrichtigt einen Avatar!"));
      StopHuntFor(enemy);
      enemy->StopHuntFor(ME);
      return 0;
  }

  armours=QueryProp(P_ARMOURS);
  // apply to first armour, return.
  if (!objectp(armours[hit_location,0]))
    dam = CombatHit(dam, dam_type, enemy, att_type, hit_location);
  else
    dam = armours[hit_location,0]->CombatHit(dam, dam_type, enemy, 
                                             att_type, hit_location, 0);
  return dam;
  
  // hier ist ende

  // TODO: Schaden an der Waffe
  if (j && (s = sizeof(weapons = enemy->QueryProp(P_WEAPONS))) && (weapon = weapons[random(s)]) && objectp(weapon))
    weapon->DoStructureDamage(j); // gum 5.10.98: von j/2 auf j geaendert (mal testen ;))
}

varargs int Hit(int damage, mixed dam_type, string hit_location)
{
  int i, dam;
  string *locs,how;
  mapping armours;

  if (!hit_location || !member(VALID_CWL,hit_location))
  {
    armours=QueryProp(P_ARMOURS);
    for (i=sizeof(locs=m_indices(VALID_CWL));i-->0;)
    {
      if (!objectp(armours[locs[i],0]))
        dam += armours[locs[i],0]->Hit(damage, dam_type, 
                                            locs[i], 0);
      else
        dam += damage;
    }
    dam = dam / sizeof(VALID_CWL);
  }

  // Resistances/Vulnerabilities einrechnen
  if (!pointerp(dam_type))
    dam_type=({dam_type});
  
  for (i=sizeof(dam_type);i-->0;)
    dam=to_int(dam*(QueryProp(P_DAMAGE_RESISTANCES)[dam_type[i]]+100.0)/100.0);

  dam-=QueryProp(P_BODY);
          
  return do_damage(dam, 0);
}

varargs int CombatHit(int damage, mixed dam_type, object enemy, string att_type, string hit_location, int depth)
{
  int i;
  mixed * fmoves,xmoves;
  object * weapons,* excludes;
  string *fmove,how;

  excludes = filter_array(all_inventory(environment()), lambda( ({ 'ob }),
    ({ #'==, 1, ({ #'call_other, 'ob, "QueryProp", P_NO_FIGHT_TEXT }) }) ));
  excludes += ({ ME, enemy });

  // Resistances/Vulnerabilities einrechnen
  if (!pointerp(dam_type))
    dam_type=({dam_type});
  
  for (i=sizeof(dam_type);i-->0;)
    damage=to_int(damage*(QueryProp(P_DAMAGE_RESISTANCES)[dam_type[i]]+100.0)/100.0);

  damage-=QueryProp(P_BODY);
  if (damage<1)
  {
      if (QueryProp(P_NO_FIGHT_TEXT)!=1)
        tell_object(enemy,sprintf("  Euer Angriff streift %s nur leicht.\n", ME->name(WEN) ));
      if (enemy->QueryProp(P_NO_FIGHT_TEXT)!=1)  
        tell_object(ME,sprintf("  %s Angriff streift Euch nur leicht.\n", enemy->Name(WESSEN)));
      tell_room(environment(),sprintf("%s Angriff streift %s nur leicht.\n", enemy->Name(WESSEN), ME->name(WEN)),excludes);    
      return 0;
  }

  if (damage > 30 && damage>QueryProp(P_HP) && pointerp(fmoves))
  {
    if (enemy->QueryProp(P_EXCLUSIVE_MOVES))
    {
      fmoves=enemy->QueryProp(P_FINISHING_MOVES);
    }
    else
    {
      if (sizeof(weapons=enemy->QueryProp(P_WEAPONS)) && weapons[0]->QueryProp(P_EXCLUSIVE_MOVES))
      {
        fmoves=weapons[0]->QueryProp(P_FINISHING_MOVES);
      }
      else
      {
        fmoves=FINISHING_MOVES[att_type];
        if (pointerp(xmoves=enemy->QueryProp(P_FINISHING_MOVES)))
          fmoves+=xmoves;
        if (sizeof(weapons) && pointerp(xmoves=weapons[0]->QueryProp(P_FINISHING_MOVES)))
          fmoves+=xmoves;
      }
    }
    
    fmove=fmoves[random(sizeof(fmoves))];
    // Gleich stirbt er, finishing move wenn vorhanden
    tell_object(enemy,break_string(fmove[0]));
    tell_object(ME,break_string(fmove[1]));
    tell_room(environment(),break_string(fmove[2]),excludes);
  }
  else
  {
    // Normale Schadensausgabe je nach Angriff....
    switch(damage)
    {
      case 1..10:
        how="sehr leicht";
        break;
      case 11..19:
        how="leicht";
        break;
      case 20..21:
        how="feste";
        break;
      case 22..30:
        how="hart";
        break;
      case 31..40:
        how="sehr hart";
        break;
      case 41..50:
        how="extrem hart";
        break;
      default:
        how="vernichtend";
        break;
    }
    fmoves=DAMAGE_MESSAGES[att_type];
    fmove=fmoves[random(sizeof(fmoves))];
    tell_object(enemy,break_string(sprintf(fmove[0],how)));
    tell_object(ME,break_string(sprintf(fmove[1],how)));
    tell_room(environment(),break_string(sprintf(fmove[2],how)),excludes);
  }

  return do_damage(damage,enemy);   
}

static int CheckResistance(string* dam_type, int damage)
{
  int i, dam_per_type, dam_num, res_val, vul_val;
  mapping res, vul;

  if (!pointerp(dam_type))
  {
    tell_room("room/mkz", sprintf("Fehler in CheckResistance in:\n\t%O\n\t%O\n", this_object(), dam_type));
    log_file("bad_damage", sprintf ("in %O\n\t%O\n", this_object(), dam_type));
    return damage;
  }

  res = QueryProp(P_RESISTANCE);
  vul = QueryProp(P_VULNERABILITY);

  if (!(dam_num = sizeof(dam_type))) return damage;

  dam_per_type = damage / dam_num;
  for (i = 0; i < dam_num; ++i)
  {
    if (res_val = res[dam_type[i]])
    {
      damage -= (res_val * dam_per_type / 100);
    }
    if (vul_val = vul[dam_type[i]])
    {
	  damage += (vul_val * dam_per_type / 100);
    }
  }

  return damage;
}

object QueryEnemy() /* Spellhandler needs it */
{
  int i;
  mixed *here;

  here=({});
  for (i=0;i<sizeof(enemies[0]);i++)
    {
      while (i<sizeof(enemies[0])&&(!objectp(enemies[0][i])||
				    enemies[0][i]->QueryProp(P_GHOST)))
	{
	  enemies[0]=enemies[0][0..i-1]+enemies[0][i+1..];
	  enemies[1]=enemies[1][0..i-1]+enemies[1][i+1..];
	}
      if (i<sizeof(enemies[0]))
	if (environment()==environment(enemies[0][i]))
	  here+=({enemies[0][i]});
    }
  if (sizeof(here)) return here[random(sizeof(here))];
  return 0;
}

mixed QueryEnemies() { return enemies; }

static void Flee() {
  string dir;
  mixed *exits;
  mapping tmp;
  int i, promil;
  object env;

  if (IS_LEARNING(this_object()) && query_once_interactive(this_object())) return;
  tell_object(ME,
	      "Die Angst ist staerker als Du .. Du willst nur noch weg hier.\n");
  env=environment();
  if (!env) return;
  exits=({});
  tmp=env->QueryProp(P_EXITS);
  exits = m_indices(tmp);
  //tmp=env->QueryProp(P_SPECIAL_EXITS);
  //exits += m_indices(tmp);

  if (!sizeof(exits))
    {
      tell_object(ME,"Du versuchst zu fliehen, schaffst es aber nicht.\n");
      return;
    }
  while (sizeof(exits) && environment()==env)
    {
      if ((promil=ME->GetProbability(WIMPY_SKILL)) &&
          (dir=ME->QueryProp(P_WIMPY_DIRECTION)) && stringp(dir) &&
          (member(exits,dir)!=-1))
      {
        if (random(1000)>promil)
        {
          if (promil<900)
          {
            promil += (int) random(((ME->QueryAttribute(SM->QueryProp(WIMPY_SKILL, P_SM_STAT)) *
                            SM->QueryProp(WIMPY_SKILL, P_SM_FACTOR))/40)+1);
            promil = (promil>900?900:promil);
            ME->GiveAbility(WIMPY_SKILL, promil);
          }

          dir = exits[random(sizeof(exits))];
        }
      }
      else
        dir = exits[random(sizeof(exits))];

      catch(command(dir));
      exits-=({dir});
    }
  if (environment()==env)
    tell_object(ME,"Dein Fluchtversuch ist gescheitert.\n");
}

mixed EnemyPresent()
{
  int i;

  for (i=0;i<sizeof(enemies[0]);i++)
    if (enemies[0][i] && environment()==environment(enemies[0][i]))
      return enemies[0][i];
  return 0;
}

mixed InFight() { return EnemyPresent(); }

int GetEnemy(object enemy, string enemy_id)
{
  return (objectp(enemy) && enemy->id(enemy_id));
}

varargs int StopHuntID(string str, int silent)
{
  object *obs;

  if (!stringp(str)) return 0;
  obs = filter_array(enemies[0], #'GetEnemy, str);
  map_array(obs, #'StopHuntFor, silent);

  return sizeof(obs);
}

mixed check_for_invincible()
{
  int i, j;
  string *mess, mess_help;
  mixed x;
  if (!(x=QueryProp(P_INVINCIBLE)))
    return 0;
  if (pointerp(x))
  {
    if ((j=sizeof(x))>2 || j<1)
      return 0;
  }
  else
  {
    x = ({ x , x });
    j = 2;
  }
  mess = ({});
  for (i=0;i<j;i++)
  {
    mess_help = funcall(x[i]);
    if (stringp(mess_help))
      mess_help = parse_mess(mess_help);
    if (intp(mess_help))
    {
      if (mess_help)
      {
        if (!i)
          mess_help = capitalize(this_object()->name(WER,1))+" weicht Deinem Angriff "
           +"muehelos aus.";
        else
          mess_help = capitalize(this_object()->name(WER,1))+" weicht "
           +this_player()->name(WESSEN,1)+" Angriff muehlos aus.";
      }
      else
        mess_help = 0;
    }
    mess += ({ mess_help });
  }
  if (j==1)
    mess += ({ mess[0] });
  return mess;
}

// Die Funktion wird aufgerufen, wenn ein PK begangen wurde, im Taeter
void did_pk(object attacking, object defending)
{
    string str;
    object* obs;
    if (!attacking || !defending || attacking==defending || attacking!=ME ||
        (previous_object()!=0 && previous_object()!=defending &&
        previous_object()!=ME)) {
        log_file("PLAYERKILLS", sprintf("WRONG did_pk(%O, %O) in %O, TI=%O, "
            "stack:%@O\n", attacking, defending, ME, this_interactive(),
            caller_stack()));
        return;
    }
    if (this_player()==attacking) str=sprintf(" Verb: %O",query_verb(), ({ " mit blossen Haenden", 30, DT_BLUDGEON }));
  return Query(P_HANDS);
}

static int _query_total_ac()
{
  int totac;

  //totac = Summe(map_objects(ME->QueryProp(P_ARMOURS), "QueryProp", P_AC));

  return totac + ME->QueryProp(P_BODY) + ME->QueryAttribute(A_DEX);
}

static object* _query_weapons()
{
  object *objs;
  objs = Query(P_WEAPONS);
  objs -= ({ 0 });
  return Set(P_WEAPONS, objs);
}

static object* _set_weapons(object *w)
{
  if(query_once_interactive(ME))
    map_array(w, "RegisterWeapon", COMBAT_MASTER);
  return Set(P_WEAPONS, w);
}

static mixed _set_resistance(mixed res)
{
  if (mappingp(res)) return Set(P_RESISTANCE, res);
  if (pointerp(res))
  {
    int s;
    mapping m;

    res -= ({ 0 });
    m = ([]);
    s = sizeof(res);
    while (s--)
    {
      m[res[s]] = 50;
    }
    return Set(P_RESISTANCE, m);
  }

  return 0;
}

static mixed _set_vulnerability(mixed vul)
{
  if (mappingp(vul)) return Set(P_VULNERABILITY, vul);
  if (pointerp(vul))
  {
    int s;
    mapping m;

    vul -= ({ 0 });
    m = ([]);
    s = sizeof(vul);
    while (s--)
    {
      m[vul[s]] = 50;
    }
    return Set(P_VULNERABILITY, m);
  }

  return 0;
}

static int _query_used_hands() 
{
  mixed* obs;
  int i;
  /*
  obs=QueryProp(P_WEAPONS)+QueryProp(P_ARMOURS);
  obs=map_objects(obs, "QueryProp", P_NR_HANDS);
  filter_array(obs, lambda( ({ 'nr, 'sum }), ({
    #'?, ({ #'>, 'nr, 0 }), ({ #'+=, 'sum, 'nr }) })), &i);
    */
  return i;
}

