/*******************
** Eldarea MUDLib **
********************
**
** std/living/comm.c - living communication
**
** CVS DATA
** $Date: 2000/12/04 15:20:23 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: comm.c,v $
** Revision 1.1  2000/12/04 15:20:23  elatar
** initial release
**
**
**
*/

#pragma strict_types

#include <living/comm.h>
#include <defines.h>

int message(int flags, mixed msg)
{
  if (!flags)
  {
    if (stringp(msg))
    {
      tell_object(ME,msg);
      return 1;
    }
    else if (pointerp(msg) && sizeof(msg) &&stringp(msg[0]))  
    {
      tell_object(ME,msg[0]);
      return 1;
    }  
    else 
      return 0;
  }
  else if (!ME->CanSee(1) && ME->CannotHear(1)) 
  {
    return -1;
  }
  else if (!ME->CanSee(1))
  {
    if (flags&MSG_OPTIC)
    {
      if ( flags&MSG_ACOUSTIC && pointerp(msg) 
        && sizeof(msg)>1 && stringp(msg[1]))
      {
        tell_object(ME,msg[1]);
        return 2;
      }
      else
        return -1;
    }
    else if (stringp(msg))
    {
      tell_object(ME,msg);
      return 1;
    }
    else if (pointerp(msg) && sizeof(msg) && stringp(msg[0]))
    {
      tell_object(ME,msg[0]);
      return 1;        
    }
    else
      return 0;
  }
  else if (ME->CannotHear(1))
  {
    if (flags&MSG_ACOUSTIC)
    {
      if ( flags&MSG_OPTIC && pointerp(msg) 
        && sizeof(msg)>2 && stringp(msg[2]))
      {
        tell_object(ME,msg[2]);
        return 2;
      }
      else if ( !flags&MSG_OPTIC && pointerp(msg)
             && sizeof(msg)>1 && stringp(msg[1]))
      {
        tell_object(ME,msg[1]);
        return 2;
      }
      else
        return -1;
    }
    else if (stringp(msg))
    {
      tell_object(ME,msg);
      return 1;
    }
    else if (pointerp(msg) && sizeof(msg) && stringp(msg[0]))
    {
      tell_object(ME,msg[0]);
      return 1;        
    }
    else
      return 0;
  }
  else if (stringp(msg)) 
  {
    tell_object(ME,msg);
    return 1;
  }
  else if (pointerp(msg) && sizeof(msg) && stringp(msg[0]))
  {
    tell_object(ME,msg[0]);
    return 1;        
  }
  else
    return 0;     
}
