/*******************
** Eldarea MUDLib **
********************
**
** std/living/description.c - living descriptions
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.3  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.2  2000/12/04 11:01:07  elatar
** worn descriptions changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#include "/std/sys_debug.h"

inherit "/std/container/description";

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <living/description.h>
#include <armour/description.h>
#include <properties.h>
#include <lightsource.h>
#include <defines.h>
#include <combat.h>
#include "/secure/rmaster.h"
					       
void create()
{ 
  ::create();
  Set(P_GENDER, SAVE, F_MODE);
  AddId("living");
}

private void select(object o, mixed weapon, mixed armour, mixed tools, mixed rest )
{
  if (member(ME->QueryProp(P_ARMOURS), o) != -1) {
    if (member(AT_IS_CLOTHING, o->QueryProp(P_ARMOUR_TYPE))!=-1)
      armour += ({ o });
    else tools += ({ o });
  }
  else if (member(ME->QueryProp(P_WEAPONS), o) != -1) weapon += ({ o });
  else if (o->QueryProp(P_LIGHT) || o->QueryProp(P_LIGHTED))
    tools += ({ o });
  else rest += ({ o });
}

static string andlist(object *arr)
{
  string *tmp;

  if (!arr || !sizeof(arr)) return "";
  if (sizeof(tmp = map_objects(arr, "name", WEN)) > 1)
    return implode(tmp[0..<2], ", ") + " und " + tmp[<1];
  return tmp[0];
}

string long()
{
  string str, cap_pronoun;
  string descr, invl, * ind, *tmp;
  int hpnt, max_hpnt, i;
  mixed filter;
  object *w, *a, *t, *r;
  mapping armours;
  
  descr = "";
  cap_pronoun = capitalize(ME->QueryPronoun());
  str = funcall(ME->QueryProp(P_LONG));
  if (!stringp(str)) str = "";
  else if (str!="" && str[<1]!='\n') str+="\n";
  hpnt = ME->QueryProp( P_HP );
  max_hpnt = ME->QueryProp( P_MAX_HP );
  if (hpnt < max_hpnt/10) 
    descr += cap_pronoun + " braucht dringend einen Arzt.\n";
  else if (hpnt < max_hpnt/5) 
    descr += cap_pronoun + " ist in keiner guten Verfassung.\n";
  else if (hpnt < max_hpnt/2) 
    descr += cap_pronoun + " macht einen mitgenommenen Eindruck.\n";
  else if (hpnt < max_hpnt - 20) 
    descr += cap_pronoun + " ist leicht angeschlagen.\n";
  else
    descr += cap_pronoun + " ist absolut fit.\n";
  str += descr;
  if(filter = ME->QueryProp(P_TRANSPARENT))
  {
    armours=QueryProp(P_ARMOURS);
    w=QueryProp(P_WEAPONS);
    tmp=({});
    a=({});
    for (i=0;i<sizeof(ind=m_indices(VALID_CWL));i++)
    {
      if (objectp(armours[ind[i],0]) && member(a,armours[ind[i],0])==-1)
      {
        tmp+=({armours[ind[i],0]->QueryProp(P_WORN_DESC)});
        a+=({armours[ind[i],0]});
        if ( armours[ind[i],0]->QueryProp(P_TRANSPARENT)
          && objectp(armours[ind[i],1]) 
          && member(a,armours[ind[i],1])==-1 )
        {
          tmp+=({"darunter "+armours[ind[i],1]->QueryProp(P_WORN_DESC)});
          a+=({armours[ind[i],1]});
        }
      }
    }
    if (!sizeof(tmp))
    {
      str+=break_string(cap_pronoun+" ist voellig nackt"+(sizeof(w)?" und hat "+
        list_words(map_array(w,lambda(
          ({'x}),
          ({#'call_other,'x,"QueryProp","P_NAME"})))
          +" gezueckt."):
        "."));
    }
    else
    {
      str+=break_string(cap_pronoun+" traegt "+list_words(tmp)+
        (sizeof(w)?" und hat "+
          list_words(map_array(w,lambda(
            ({'x}),
            ({#'call_other,'x,"QueryProp","P_NAME"}))))
            +" gezueckt.":
          ".") );
    }
    
    /* Die Livings sind nun nicht mehr durchsichtig
     // Invliste nun wie bei Spielern+Restinv (Holger - 17.10.97)
     w = ({}); a = ({}); t = ({}); r = ({});
     map_array(all_inventory(ME), #'select, &w, &a, &t, &r);
     if ((sizeof(w)||sizeof(a)||sizeof(t)) && ME->QueryProp(P_TRANSPARENT)) {
         string tmp;
         int i;
         tmp=capitalize(ME->QueryPronoun());
         if (sizeof(a)) {
             tmp+=" hat "+andlist(a)+" an";
             i=1;
         }
         if (sizeof(w)) {
             if (i) tmp+=" und ";
             else tmp+=" hat ";
             tmp+=andlist(w)+" gezueckt";
             i=1;
         }
         if (sizeof(t)) {
             if (i) tmp+=" und";
             tmp+=" traegt "+andlist(t);
         }
         tmp+=".";
         str+=break_string(tmp);
    }
    invl = make_invlist(PL, r);
    if(invl != "")
      str += capitalize(ME->QueryPronoun())+" besitzt:\n" + invl;
    */
  }
  return str;
}

string name(int casus, int demonst) {
  string s;
  mixed *f;
  
  if( ME->QueryProp( P_INVIS ) ) {
    if( casus == RAW ) return "Jemand";
    return ({"Jemand","Jemands","Jemandem","Jemanden"})[casus];
  }
  if ((f=ME->QueryProp(P_FROG)) && casus != RAW) {
    if (demonst&NAME_PLURAL) return 0; // Niemals Plural
    ME->SetProp(P_ARTICLE,1);
    s=ME->QueryArticle(casus,demonst)+
      (sizeof(f)>8 ? DeclAdj(f[FROG_ADJ],casus,demonst) : "")+
      f[FROG_NAME][casus];
    ME->SetProp(P_ARTICLE,0);
    return s;
  }
  return ::name( casus, demonst );
}

static int _query_gender()
{
  mixed *f;
  if(f=ME->QueryProp(P_FROG))
    if(pointerp(f)) return f[FROG_GENDER];
    else return 1;
  return Query(P_GENDER);
}

static mixed _set_name(mixed nm )
{
  string lvnam;
  lvnam = nm;
  if(pointerp(nm)) lvnam = nm[0];
  set_living_name(lower_case(lvnam));
  return Set(P_NAME, nm);
}

int _query_container()
{
  return 0;
}