/*******************
** Eldarea MUDLib **
********************
**
** std/living/life.c - life handling
**
** CVS DATA
** $Date: 2000/12/18 14:52:56 $
** $Revision: 1.6 $
**
** CVS History
**
** $Log: life.c,v $
** Revision 1.6  2000/12/18 14:52:56  elatar
** ET_DEATH event now provides death messages
** ET_EXHAUST event implemented
**
** Revision 1.5  2000/12/15 15:30:34  elatar
** revised death handling, now managed by ET_DEATH event
** implemted several die() options(flags)
**
** Revision 1.4  2000/12/04 11:01:42  elatar
** new P_HP handling
** exhaustion implemented
** hp and mp handling rewritten
** experience handling rewritten
**
** Revision 1.3  2000/01/26 14:48:11  elatar
** diverse properties added
**
** Revision 1.2  1999/11/19 10:20:01  elatar
** Adapted to new channeld
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

// living object life variables
//
//  P_ALIGN         -- alignment value
//  P_NPC           -- if living is an NPC
//  P_HP            -- HitPoints
//  P_SP            -- SpellPoints
//  P_ALCOHOL       -- value of intoxication
//  P_DRINK         -- value of soakness
//  P_FOOD          -- value of stuffness
//  P_AGE           -- Age
//  P_XP            -- experience
//  P_POISON        -- level of poison
//  P_CORPSE        -- corpse-object

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/thing/properties.h"
#include <properties.h>
#include <config.h>
#include <health.h>
#include <wizlevels.h>
#include <language.h>
#include <moving.h>
#include <defines.h>
#include <service.h>
#include <living/murder_msg.h>
#include <living/attributes.h>
#include <living/life.h>
#include <corpse.h>
#include "/secure/rmaster.h"
#include <events.h>

#include "log.h"

int age;		  // Number of heart beats of this character. 

static int delay_alcohol; // time until next alcohol effect 
static int delay_drink;	  // time until next drink effect 
static int delay_food;	  // time until next food effect 
static int delay_heal;	  // time until next heal effect 
static int delay_exp;     // exhaust delay
static int delay_psp;
static int delay_msp;
static int delay_csp;
static int delay_esp;	  // spell points delay
static int delay_poison;  // time until next poison effect 

void create() {
  Set(P_GHOST, SAVE, F_MODE);
  Set(P_FROG, SAVE, F_MODE);
  Set(P_ALIGN, SAVE, F_MODE);
  Set(P_ASPECT,SAVE,F_MODE_AS);
  Set(P_CIVILIZATION,SAVE,F_MODE_AS);
  Set(P_HONOR,SAVE,F_MODE_AS);
 
  Set(P_SP, SAVE, F_MODE);
  Set(P_XP, SAVE, F_MODE);
  Set(P_HP_MULTIPLIER, 5);
  Set(P_HP_MULTIPLIER, SAVE, F_MODE);
  Set(P_EXP_MULTIPLIER, 5);
  Set(P_EXP_MULTIPLIER, SAVE, F_MODE);
  Set(P_PSP_MULTIPLIER, 2);
  Set(P_PSP_MULTIPLIER, SAVE, F_MODE);
  Set(P_MSP_MULTIPLIER, 2);
  Set(P_MSP_MULTIPLIER, SAVE, F_MODE);
  Set(P_ESP_MULTIPLIER, 2);
  Set(P_ESP_MULTIPLIER, SAVE, F_MODE);
  Set(P_CSP_MULTIPLIER, 2);
  Set(P_CSP_MULTIPLIER, SAVE, F_MODE);
  Set(P_ALCOHOL, SAVE, F_MODE);
  Set(P_DRINK, SAVE, F_MODE);
  Set(P_FOOD, SAVE, F_MODE);
  Set(P_POISON, SAVE, F_MODE);

  Set(P_FROG,0,F_SET_METHOD);
  Set(P_AGE, -1, F_SET_METHOD);
  Set(P_AGE, PROTECTED, F_MODE);
  SetProp(P_CORPSE, "/std/corpse");
}

float sp_per_level(int att)
{
  switch (att)
  {
    case 0..49:
      return 0.0;
      break;
    case 50..59:
      return 0.5;
      break;
    case 60..69:
      return 1.0;
      break;
    case 70..79:
      return 1.5;
      break;
    case 80..89:
      return 2.0; 
      break;
    case 90..94:
      return 2.5;
      break;
    case 95..97:
      return 3.0;
      break;
    case 98..99:
      return 3.5;
      break;
    default:
      return (att-92)*0.5;
      break;
  }
}

void UpdatePoints()
{
  mapping offs,att;

  if (!query_once_interactive(this_object())) 
    return;

  offs=RMASTER->QueryOffset(0,QueryProp(P_RACE));
  att=QueryProp(P_ATTRIBUTES);

  SetProp(P_MAX_PSP,offs[P_PSP]+QueryProp(P_PSP_MOD)
          +to_int(sp_per_level(att[A_SD])
                  *QueryProp(P_LEVEL)
                  *QueryProp(P_PSP_MULTIPLIER) ));
  SetProp(P_MAX_ESP,offs[P_ESP]+QueryProp(P_ESP_MOD)
          +to_int(sp_per_level(att[A_EM])
                  *QueryProp(P_LEVEL)
                  *QueryProp(P_ESP_MULTIPLIER) ));
  SetProp(P_MAX_MSP,offs[P_MSP]+QueryProp(P_MSP_MOD)
          +to_int(sp_per_level(att[A_PR])
                  *QueryProp(P_LEVEL)
                  *QueryProp(P_MSP_MULTIPLIER) ));
  SetProp(P_MAX_CSP,offs[P_CSP]+QueryProp(P_CSP_MOD)
          +to_int(sp_per_level(att[A_IN])
                  *QueryProp(P_LEVEL)
                  *QueryProp(P_CSP_MULTIPLIER) ));
  SetProp(P_MAX_HP,
    to_int( ( offs[P_HP]+QueryProp(P_HP_MOD)+
    ( QueryProp(P_LEVEL)+ME->QuerySkillRanks(SK_BODY_DEVELOPMENT) )
    * QueryProp(P_HP_MULTIPLIER) )
    * (QueryProp(P_ATTR_BONI)[A_CO]/100.0+1.0)) );
  SetProp(P_MAX_EXP,
    to_int( offs[P_EXP]
            + QueryProp(P_EXP_MOD)
            + ME->QuerySkillRanks(SK_BODY_DEVELOPMENT)
              * QueryProp(P_HP_MULTIPLIER)
            + QueryAttribute(A_CO) ));
  return;
}

int CheckEnemy(object ob) {
  return (interactive(ob) && living(ob) && ob->IsEnemy(this_object()));
}

int do_exhaust(int ex)
{  
  mapping ret;
  
  if (ex<1)
    return 0;
    
  ret = send_event(ET_EXHAUST,
                   ([E_EXHAUST_EXHAUST:ex]),
                   environment(this_object()));
  if (!mappingp(ret))
    return 0;
  return ret[E_HANDLED];
}

/*
 * This function is called from other players when they want to make
 * damage to us. But it will only be called indirectly.
 * We return how much damage we received, which will
 * change the attackers score. This routine is probably called from
 * heart_beat() from another player.
 * Compare this function to reduce_hit_point(dam).
 */
int do_damage(int dam, mixed enemy) 
{
  int hit_point, total_wc, total_exp, i;
  object ob, *enemies;
  float h;

  if (ME->QueryProp(P_GHOST) || dam<=0) 
    return 0;
  if (objectp(enemy) && enemy->QueryProp(P_GHOST))
    return 0;
  hit_point = ME->QueryProp(P_HP)-dam;
  if(enemy && ME->QueryProp(P_XP))
    enemy->AddExp(dam*(int)ME->QueryProp(P_TOTAL_WC)/10);
  if (hit_point<0)
  {
    hit_point = -1;
    if (enemy)
	  {
      enemies = filter_array(all_inventory(environment(this_object())),
                             #'CheckEnemy);
      total_wc = 0;
      for (i = 0; i<sizeof(enemies); i++)
        total_wc += enemies[i]->QueryProp(P_TOTAL_WC) + 
                                            10*enemies[i]->QueryAttribute(A_STR);
      total_exp = this_object()->QueryProp(P_XP)/100;
      for (; sizeof(enemies); enemies = enemies[1..])
      {
        h = (float)(enemies[0]->QueryProp(P_TOTAL_WC)+
                    10*enemies[0]->QueryAttribute(A_STR))/(float)(total_wc);
        enemies[0]->AddExp((int)(h*total_exp));
        enemies[0]->StopHuntFor(ME,1);
      }
	    if (!query_once_interactive(ME))
	      log_file ("NPC_XP", file_name(ME) + ", XP: " +
		      (ME->QueryProp(P_XP)/100) + ", HP*WC: " +              
		      ME->QueryProp(P_TOTAL_WC)
		      *ME->QueryProp(P_MAX_HP)/10 
		      +", Killer: " + enemy->name() + "\n");  
	    enemy->SetProp(P_ALIGN, (9*enemy->QueryProp(P_ALIGN))/10 -
                               ME->QueryProp(P_ALIGN)/5);
    }
    ME->StopHuntingMode(1);
    ME->SetProp(P_HP, hit_point);
    ME->die();
    return dam;
  }
  ME->SetProp(P_HP, hit_point);
  return dam;
}

static void create_kill_log_entry(string killer)
{
  string tmp;
  int level,lost_exp;
  object me;

  me=ME;
  tmp=dtime(time());
  if ((level=me->QueryProp(P_LEVEL))<20)
    lost_exp = me->QueryProp(P_XP)/3;
  else
    lost_exp = me->QueryProp(P_XP)/(level-17);
  log_file("KILLS",
	   tmp[5..11]+" "+tmp[19..23]+" "+
	   capitalize(getuid(me))+
	   "("+level+","+(lost_exp/1000)+") "+
	   killer+"\n");
}

varargs void die(int flags, string rmsg, string pmsg)
{
  object killer;
  string corpse;
  int i;
    
  if(query_once_interactive(this_object()) && extern_call())
    flags!=DIE_DIRECT;
    
  if (previous_object() != this_object())
    killer = previous_object();
  if (!killer)
    killer = this_interactive();
  if (!killer)
    killer = this_player();
  if (!killer)
  {
    while(killer = previous_object(++i) && killer == this_object());
  }

  if (!(flags|DIE_SILENT))
  {
    mixed die_msg;

    if (!rmsg)
      die_msg = (mixed) this_object()->QueryProp(P_DIE_MSG);
    else
      die_msg = rmsg;
    if (!die_msg)
      die_msg = " faellt tot zu Boden.\n";
      
    if (die_msg == -1)
      flags &= DIE_SILENT;
    else
      rmsg = die_msg;
  }

  if (ME->QueryProp(P_NOCORPSE))
  {
    flags &= DIE_NOCORPSE;
  }
  else
  {
    corpse = ME->QueryProp(P_CORPSE);
  }

  if (!(flags&DIE_NOEVENT))
    send_event(ET_DEATH,
               ([E_DEATH_FLAGS:flags,
                 E_DEATH_KILLER:killer,
                 E_DEATH_VICTIM:this_object(),
                 E_DEATH_RMSG:rmsg,
                 E_DEATH_PMSG:pmsg,
                 E_DEATH_CORPSE:corpse]),
               environment()||this_object());
  else
    call_other("/global/handler/life","die",
               ([E_DEATH_FLAGS:flags,
                 E_DEATH_KILLER:killer,
                 E_DEATH_VICTIM:this_object(),
                 E_DEATH_RMSG:rmsg,
                 E_DEATH_PMSG:pmsg,
                 E_DEATH_CORPSE:corpse]));
}


void heal_self(int h) {
  if(h <= 0) return;
  ME->SetProp(P_HP, ME->QueryProp(P_HP)+h);
  ME->SetProp(P_SP, ME->QueryProp(P_SP)+h);
}

int restore_spell_points(int h) {
  int i;
  ME->SetProp(P_SP, (i=ME->QueryProp(P_SP))+h);
  return ME->QueryProp(P_SP)-i;
}

int reduce_hit_point(int dam) {
  object o;
  if(ME->SetProp(P_HP, ME->QueryProp(P_HP) - dam) <= 0)
    ME->SetProp(P_HP, 1);
  return ME->QueryProp(P_HP);
}

int drink_alcohol(int strength) {
  int alc;
  alc = ME->QueryProp(P_ALCOHOL)+ALCOHOL_VALUE(strength);
  if(alc >= ME->QueryProp(P_MAX_ALCOHOL)) {
      tell_object(ME, "So ein Pech, Du hast alles verschuettet.\n");
      return 0;
  }
  if(alc < 0) alc = 0;
  if(!alc)
    tell_object(ME, "Du bist stocknuechtern.\n");
  return (int)ME->SetProp(P_ALCOHOL, alc);
}

int drink_soft(int strength) {
  int soaked;
  soaked = ME->QueryProp(P_DRINK);
  if(soaked + strength > ME->QueryProp(P_MAX_DRINK)) {
      tell_object(ME, "Nee, so viel kannst Du momentan echt nicht trinken.\n" );
      return 0;
  }
  if((soaked += DRINK_VALUE(strength)) < 0) soaked = 0;
  if(!soaked)
    tell_object(ME, "Dir klebt die Zunge am Gaumen.\n");
  return (int)ME->SetProp(P_DRINK, soaked);
}

int eat_food(int strength) {
  int stuffed;
  stuffed = ME->QueryProp(P_FOOD);
  if(stuffed + strength > ME->QueryProp(P_MAX_FOOD)) {
    tell_object(ME, 
      "Das ist viel zu viel fuer Dich! Wie waers mit etwas leichterem?\n");
    return 0;
  }
  stuffed += FOOD_VALUE(strength);
  if(stuffed < 0) stuffed = 0;
  if(!stuffed)
    tell_object(ME, "Was rumpelt denn da in Deinem Bauch?\n");
  return (int)ME->SetProp(P_FOOD, stuffed);
}

static void heart_beat() 
{
  int hpoison;

  // AddStatMod(0); // Attribute aktualisieren obsolet
  hpoison=ME->QueryProp(P_POISON);
  age++;
  if(ME->QueryProp(P_ALCOHOL) && !random(40))
    {
      int n;
      switch(random(4))
	{
	case 0:
	  say(capitalize(ME->name(WER,1)) + " sagt: <Hick>!\n");
	  write("<Hick>! Oh, Tschuldigung.\n");
	  break;
	case 1:
	  say(capitalize(ME->name(WER,1)) + " stolpert ueber " +
	      ME->QueryPossPronoun(FEMALE,WEN) + " Fuesse.\n");
	  write("Du stolperst.\n");
	  break;
	case 2:
	  write("Du fuehlst Dich benommen.\n");
	  say(capitalize(ME->name(WER,1)) + " sieht betrunken aus.\n");
	  break;
	case 3:
	  say(capitalize(ME->name(WER,1)) + " ruelpst.\n");
	  write("Du ruelpst.\n");
	  break;
	}
    } 
  if(ME->QueryProp(P_ALCOHOL) && --delay_alcohol < 0)
    {
      ME->SetProp(P_ALCOHOL, ME->QueryProp(P_ALCOHOL)-1);
      if (!hpoison)
	{
	  ME->SetProp(P_HP, ME->QueryProp(P_HP)+1);
	  ME->SetProp(P_SP, ME->QueryProp(P_SP)+1);
	}
      delay_alcohol = ME->QueryProp(P_ALCOHOL_DELAY);
    }

  if(--delay_drink < 0)
  {
    delay_drink = ME->QueryProp(P_DRINK_DELAY);
    ME->SetProp(P_DRINK, ME->QueryProp(P_DRINK)-1);
  }

  if(--delay_food < 0)
  {
    delay_food = ME->QueryProp(P_FOOD_DELAY);
    ME->SetProp(P_FOOD, ME->QueryProp(P_FOOD)-1);
  }

  /* normal regeneration */
  if(--delay_heal < 0)
  {
    delay_heal = ME->QueryProp(P_HEAL_DELAY);
    ME->SetProp(P_HP, ME->QueryProp(P_HP)+1);
  }

  if(--delay_exp < 0)
  {
    delay_exp = ME->QueryProp(P_HEAL_DELAY);
    ME->SetProp(P_EXP, ME->QueryProp(P_EXP)+1);
  }

  if (--delay_psp < 0)
  {
    delay_psp = ME->QueryProp(P_PSP_DELAY);
    ME->SetProp(P_PSP, ME->QueryProp(P_PSP)+1);
  }

  if (--delay_esp < 0)
  {
    delay_esp = ME->QueryProp(P_ESP_DELAY);
    ME->SetProp(P_ESP, ME->QueryProp(P_ESP)+1);
  }

  if (--delay_msp < 0)
  {
    delay_msp = ME->QueryProp(P_MSP_DELAY);
    ME->SetProp(P_MSP, ME->QueryProp(P_MSP)+1);
  }

  if (--delay_csp < 0)
  {
    delay_csp = ME->QueryProp(P_CSP_DELAY);
    ME->SetProp(P_CSP, ME->QueryProp(P_CSP)+1);
  }
     
  if (hpoison)
    {
      int lhp;
      lhp=ME->QueryProp(P_HP);
      if (--delay_poison < 0)
	{
	  delay_poison = ME->QueryProp(P_POISON_DELAY) + random(POISON_MERCY_DELAY);
	  lhp-=hpoison;
	  if (lhp<0) lhp=-1;
	  ME->SetProp(P_HP, lhp);
	  if (lhp < 0)
	    {
	      tell_object(this_object(), "Oh weh - das Gift war zuviel fuer Dich!\n"
			  +"Du stirbst.\n");
	      if(query_once_interactive(ME))
		  create_kill_log_entry("Vergiftung");
	      this_object()->die(DIE_POISON);
	      return;
	    }
	}
      if (!random(15))
	switch (ME->QueryProp(P_HP)*100/ME->QueryProp(P_MAX_HP))
	  {
	  case 71..100 :
	    write("Du fuehlst Dich nicht gut.\n");
	    say(capitalize(ME->name(WER))+" sieht etwas benommen aus.\n", ({ME}));
	    break;
	  case 46..70 :
	    write("Dir ist schwindlig und Dein Magen revoltiert.\n");
	    say(capitalize(ME->name(WER))+" taumelt ein wenig.\n", ({ME}));
	    break;
	  case 26..45 :
	    write("Dir ist heiss. Du fuehlst Dich schwach. Kopfweh hast Du "
		  +"auch.\n");
	    say(capitalize(ME->name(WER))+" glueht direkt und scheint grosse "
		+"Schwierigkeiten zu haben.\n", ({ME}));
	    break;
	  case 11..25 :
	    write("Du fuehlst Dich beschissen. Alles tut weh, und Du siehst "
		  +"nur noch unscharf.\n");
	    say(capitalize(ME->name(WER))+" taumelt und stoehnt und kann gerade "
		+"noch vermeiden, hinzufallen.", ({ME}));
	    break;
	  case 0..10 :
	    write(break_string("Du siehst fast nichts mehr und kannst Dich nur "
	      "noch unter groessten Schmerzen bewegen. Aber bald tut nichts "
              "mehr weh..."));
	    say(break_string(capitalize(ME->name(WER))+" glueht wie im Fieber, "
              "kann sich kaum noch ruehren und hat ein schmerzverzerrtes "
              "Gesicht."), ({ME}));
	    break;
	  }
    }
}


void show_age() {
  int i,j;

  write("Alter:\t");
  i = ME->QueryProp(P_AGE);
  if ((j=i/43200))
    {
      write(j + " Tag"+(j==1?" ":"e "));
      i %= 43200;
    }
  if ((j=i/1800))
    {
      write(j + " Stunde"+(j==1?" ":"n "));
      i %= 1800;
    }
  if ((j=i/30))
    {
      write(j + " Minute"+(j==1?" ":"n "));
      i %= 30;
    }
  write(i*2 + " Sekunden.\n");
}

int AddExp(int e) 
{
  int experience;
  
  experience = ME->QueryProp(P_XP);
  
  if ((experience+=e) < 0) 
    experience = 0;
  return ME->SetProp(P_XP, experience);
}

int add_exp(int e) {
  return AddExp(e);
}

static int _set_align(int a) {
  if (a<-1000) a = -1000;
  if (a>1000) a = 1000;
  return Set(P_ALIGN, a);
}

static int _set_hp(int hp) {
  if(hp < 0) return Set(P_HP, 0);
  if(hp > ME->QueryProp(P_MAX_HP)) return Set(P_HP, ME->QueryProp(P_MAX_HP));
  return Set(P_HP, hp);
}

static int _set_sp(int sp)
{
  if(sp < 0) return Set(P_SP, 0);
  if(sp > ME->QueryProp(P_MAX_SP)) return Set(P_SP, ME->QueryProp(P_MAX_SP));
  return Set(P_SP, sp);
}

static int _set_psp(int psp)
{
  if(psp < 0) return Set(P_PSP, 0);
  if(psp > ME->QueryProp(P_MAX_PSP)) return Set(P_PSP, ME->QueryProp(P_MAX_PSP));
  return Set(P_PSP, psp);
}
 
static int _set_csp(int csp)
{
  if(csp < 0) return Set(P_CSP, 0);
  if(csp > ME->QueryProp(P_MAX_CSP)) return Set(P_CSP, ME->QueryProp(P_MAX_CSP));
  return Set(P_CSP, csp);
}
 
static int _set_msp(int msp)
{
  if(msp < 0) return Set(P_MSP, 0);
  if(msp > ME->QueryProp(P_MAX_MSP)) return Set(P_MSP, ME->QueryProp(P_MAX_MSP));
  return Set(P_MSP, msp);
}
 
static int _set_esp(int esp)
{
  if(esp < 0) return Set(P_ESP, 0);
  if(esp > ME->QueryProp(P_MAX_ESP)) return Set(P_ESP, ME->QueryProp(P_MAX_ESP));
  return Set(P_ESP, esp);
}

static int _set_exp(int exp)
{
  if(exp < 0) return Set(P_EXP, 0);
  if(exp > ME->QueryProp(P_MAX_EXP)) return Set(P_EXP, ME->QueryProp(P_MAX_EXP));
  return Set(P_EXP, exp);
}
 
static int _set_alcohol(int n) {
  int max;
  max=QueryProp(P_MAX_ALCOHOL);
  return Set(P_ALCOHOL, (n < 0 ? 0 : (n>max?max:n)));
}

static int _set_drink(int n) {
  int max;
  max=QueryProp(P_MAX_DRINK);
  return Set(P_DRINK, (n < 0 ? 0 : (n>max?max:n)));
}

static int _set_food(int n) {
  int max;
  max=QueryProp(P_MAX_FOOD);
  return Set(P_FOOD, (n < 0 ? 0 : (n>max?max:n)));
}

static int _set_poison(int n) {
  log_file("POISON",
    "Poisoned: "+(query_once_interactive(this_object()) ? capitalize(geteuid(this_object())) : ME->name(WER))
   +", Value: "+n
   +", Object: "+(previous_object(2) ? file_name(previous_object(2)) : file_name(previous_object(1)))
   +(this_player() ? ", Responsible: "+capitalize(geteuid(this_player())) : "")
   +", Time: "+dtime(time())+"\n");
  return Set(P_POISON, (n<0 ? 0 : (n>MAX_POISON ? MAX_POISON : n)));
}

static int _query_age() {
  return Set(P_AGE, age);
}

static int _set_xp(int xp) {
  return Set(P_XP, xp < 0 ? 0 : xp);
}

static int _set_frog(mixed f) {
  if(!f) return Set(P_FROG,0);
  if(intp(f)) {
    Set(P_FROG,({({"Frosch","Frosches","Frosch","Frosch"}),MALE,
	"huepft durchs "MUDNAME, 0,({"frosch"}),
	({"quakt","Quaaak, quaaaaaak, quuuuaaaaaaaaaaaaaaaaaaaak !!"}),
		"huepft herein","huepft","klein"}));
    return 1;
  }
  if(!pointerp(f) || sizeof(f)<8)
    return -1;
  Set(P_FROG,f);
  return 1;
}
