/*******************
** Eldarea MUDLib **
********************
**
** /std/living/moving.c - living movement
**
** CVS DATA
** $Date: 2001/02/01 09:14:55 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: moving.c,v $
** Revision 1.4  2001/02/01 09:14:55  elatar
** event handling slightly changed
** old hook methods removed
**
** Revision 1.3  2000/12/04 11:02:08  elatar
** new moving messages
** living/senses used
**
** Revision 1.2  2000/10/16 11:58:09  elatar
** new move() implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#define NEED_PROTOTYPES

#define DB(x) if(find_player("elatar")) tell_object(find_player("elatar"), x+"\n")

#include <thing/properties.h>

#include <config.h>
#include <properties.h>
#include <moving.h>
#include <language.h>
#include <wizlevels.h>
#include <defines.h>
#include <living.h>
#include <clock.h>
#include <living/senses.h>
#include <living/comm.h>
#include <events.h>
#include <rpgsys.h>

#pragma strong_types

private static int last_move_time;
string name(int casus,int demon);


// Funktion fuer Begruessungsschlag
int CheckEnemy(object ob) {
  return (living(ob) && (funcall(#'IsEnemy,ob) || ob->IsEnemy(ME)));
}

/* Der neue Prototyp von move() lautet
 * varargs int move(mixed dest, int meth, string * dir, string* msg)
 * der alte lautete:
 * varargs int move(mixed dest, int meth, str dir, str txtout, str txtin)
 */
varargs int move(mixed dest, int meth, string* msgs, string* verbs) 
{
  int i,is_light;
  object enem, *enemies, old_env;
  mixed *f;
  string text, hear_text;
  mapping ret;
  
  old_env=environment();
  if (!(meth & M_NOEVENT) && !(meth & M_NOCHECK))
  {
    ret=send_event(ET_GO, ([E_MOVE_OBJ:    this_object(),
                            E_MOVE_DEST:   dest,
                            E_MOVE_SOURCE: old_env,
                            E_MOVE_DIRS:   msgs,
                            E_MOVE_METHOD: meth|M_NOEVENT,
                            E_MOVE_EXHAUST:1,
                            E_MOVE_VERBS:  verbs ]),
                            objectp(old_env)?({old_env, dest}):({dest}) );
    if (!mappingp(ret))
      return 0;
    else 
      return ret[E_HANDLED];
  }
  if (!pointerp(msgs))
    msgs=({"&Name &verb.","&Name &verb herein.","Ihr &verb."});
  if (!(meth & (M_GO | M_NOCHECK | M_TPORT | M_SWIM 
                | M_FLOAT | M_FLY | M_CLIMB | M_DIVE)))
    return ME_PLAYER;
  if ((meth & M_TPORT) && !(meth & M_NOCHECK)) 
  {   
    if ( environment() 
      && (environment()->QueryProp(P_NO_TPORT) & (NO_TPORT_OUT | NO_TPORT)))
      return ME_CANT_TPORT_OUT;
    else
      if (dest->QueryProp(P_NO_TPORT) & (NO_TPORT_IN|NO_TPORT))
        return ME_CANT_TPORT_IN;
  }
  
  if (ME->QueryProp(P_INVIS) && IS_LEARNER(ME)) 
    meth|=M_SILENT;

  if (QueryProp(P_MSG_FORCE) && !(meth & M_MY_MSG))
    verbs=({"geh","geh","komm"}); //TODO: hier my_verbs setzen
  else
  {
    if (!pointerp(verbs) || sizeof(verbs)<3)
      verbs=({0,0,0});
    if (meth&M_TPORT)
    {
      if (!verbs[0])
        verbs[0]="verschwinde";  
      if (!verbs[1])
        verbs[1]="erschein";  
      if (!verbs[2])
        verbs[2]="teleportier";  
    }
    else if (meth&M_DIVE)
    {
      if (!verbs[0])
        verbs[0]="tauch";
      if (!verbs[1])
        verbs[1]="tauch";  
      if (!verbs[2])
        verbs[2]="tauch";
    }
    else if (meth&M_SWIM)
    {
      if (!verbs[0])
        verbs[0]="schwimm";
      if (!verbs[1])
        verbs[1]="schwimm";
      if (!verbs[2])
        verbs[2]="schwimm";
    }
    else if (meth&M_FLY)
    {
      if (!verbs[0])
        verbs[0]="flieg";
      if (!verbs[1])
        verbs[1]="flieg";
      if (!verbs[2])
        verbs[2]="flieg";
    }
    else if (meth&M_FLOAT)
    {
      if (!verbs[0])
        verbs[0]="schweb";
      if (!verbs[1])
        verbs[1]="schweb";
      if (!verbs[2])
        verbs[2]="schweb";
    }
    else if (meth&M_CLIMB)
    {
      if (!verbs[0])
        verbs[0]="kletter";
      if (!verbs[1])
        verbs[1]="kletter";
      if (!verbs[2])
        verbs[2]="kletter";
    }
    else if (meth&M_CRAWL)
    {
      if (!verbs[0])
        verbs[0]="kriech";
      if (!verbs[1])
        verbs[1]="kriech";
      if (!verbs[2])
        verbs[2]="kriech";
    }
    else
    {
      if (!verbs[0])
        verbs[0]="geh";
      if (!verbs[1])
        verbs[1]="komm";
      if (!verbs[2])
        verbs[2]="geh";
    }
  }
  
  // Wir schleichen
  if (meth&M_SNEAK)
  {
    verbs[0]+="t leise und unauffaellig";
    verbs[1]+="t leise und unauffaellig";
    verbs[2]+="t leise und unauffaellig";
  }
  else
  {
    verbs[0]+="t";
    verbs[1]+="t";
    verbs[2]+="t";
  }
  // Meldungen erzeugen, text ist hier Rausmeldung
  /*
  if (!old_env || meth&M_SILENT || (set_light(0)-(UHR->IsNight()*
    !old_env->QueryProp(P_INDOORS))<=0 && !(meth&M_MY_MSG && pointerp(msgs)))) 
  {
    text=0;
  } else if (!pointerp(msgs) || !(text=msgs[1])) {
    // alte Form oder automatische Erzeugung
    if (!stringp(msgs)) text=0;
    else text=(string)msgs;
    if (!text || (ME->QueryProp(P_MSG_FORCE) && dir)) {
      if (meth&M_TPORT) text=ME->QueryProp(P_MMSGOUT);
      if (!text) {
        if (f=ME->QueryProp(P_FROG)) text=f[FROG_MSGOUT];
        else text=ME->QueryProp(P_MSGOUT);
      }
    }
    if (!dir) dir="";
    else if (dir!="") dir=" "+dir;
    text=capitalize(ME->name(WER, NAME_AUTO))+" "+text+dir+".\n";
  }*/
  if (!(meth&M_SILENT) && old_env &&stringp(msgs[0]))
  {
    //TODO: auf message() umstellen
    text = implode(efun::explode(msgs[0], "&verb"), verbs[0]);

    hear_text = implode(efun::explode(text, "&Name"),"Jemand");
    text = implode(efun::explode(text, "&Name"),
      ME->Name(WER, NAME_AUTO));

    hear_text = implode(efun::explode(hear_text, "&name"),"jemand");
    text = implode(efun::explode(text, "&name"),
      ME->name(WER, NAME_AUTO));
    
    if (meth&M_SNEAK && QueryActiveSkill(SK_STEALTH))
    {
      int res;
      object * observers;
      
      res = SkillCheck(SK_STEALTH, (int)old_env->QueryProp(P_STEALTH_MOD));
      observers = filter_array(all_inventory(old_env),#'living);
      observers -= ({ME});
      observers = filter_array(observers,lambda(({}),
        ({#'!,
          ({#'EvalCheck,
            ({#'SkillCheck,SK_PERCEPTION,QueryProp(P_ACTIVE_SKILLS)[SK_STEALTH,ASI_SUCCESS]})})})));
      old_env->message(MSG_OPTIC|MSG_ACOUSTIC,
        ({break_string(text),break_string(hear_text),break_string(text)}),
        ({ME})+observers);
      
    }
    else
    {
      old_env->message(MSG_OPTIC|MSG_ACOUSTIC,
        ({break_string(text),break_string(hear_text),break_string(text)}),
        ({ME}));
    }
  }

  // Meldungen erzeugen, text ist hier Selbstmeldung
  /*
  if (!pointerp(msgs)) text="";
  else text=msgs[0]||"";
    
  if (old_env) {
    enem=first_inventory(old_env);
    while (enem) {
      if (living(enem) && StopHuntFor(enem,1)) {
        text+=capitalize(enem->name(WER, NAME_AUTO))+
          " ist jetzt hinter Dir her.\n";
        enem->InsertEnemy(ME);
      }
      enem=next_inventory(enem);
    }
    if (!(meth & M_NOCHECK)) old_env->exit();
  }
  */
  if (stringp(msgs[2]))
  {
    text=implode(efun::explode(msgs[2], "&verb"),
      verbs[2]);
  
    tell_object(ME, break_string(text));
  }

  move_object(dest);

  dest=environment();

  // Pursuer obsolete
  if (pointerp(Query(P_PURSUERS)) && sizeof(Query(P_PURSUERS)[1])) {
    while (remove_call_out("TakeFollowers")>=0);
    call_out("TakeFollowers",0);
  }

  // Meldungen erzeugen, text ist hier Reinmeldung
  /*
  is_light=set_light(0)-(UHR->IsNight()*!dest->QueryProp(P_INDOORS));
  if (meth&M_SILENT || (is_light<=0 && !(meth&M_MY_MSG && pointerp(msgs)))) {
    text=0;
  } else if (!pointerp(msgs) || (!text=msgs[2])) {
    text=dummy;
    if (!text || QueryProp(P_MSG_FORCE)) {
      if (meth&M_TPORT) text=ME->QueryProp(P_MMSGIN);
      if (!text) {
        if (f=ME->QueryProp(P_FROG)) text=f[FROG_MSGIN];
        else text=ME->QueryProp(P_MSGIN);
      }
    }
    text=capitalize(ME->name(WER, NAME_AUTO))+" "+text+".\n";
  }
  if (text) {
    if (member(text, '&')!=-1) {
      text=implode(efun::explode(text, "&Name"),
        capitalize(ME->name(WER, NAME_AUTO)));
      text=implode(efun::explode(text, "&name"),
        ME->name(WER, NAME_AUTO));
    }
    tell_room(dest, break_string(text), ({ ME }));
  }*/
  if (!(meth&M_SILENT) && stringp(msgs[1]))
  {
    //TODO: auf message() umstellen
    text=implode(efun::explode(msgs[1], "&Name"),
      ME->Name(WER, NAME_AUTO));
    text=implode(efun::explode(text, "&name"),
      ME->name(WER, NAME_AUTO));
    text=implode(efun::explode(text, "&verb"),
      verbs[1]);
    
    tell_room(dest,break_string(text),({ME}));    
  }

  // Ansicht des neuen Raumes erzeugen
  if (interactive(ME) && !(meth&M_NO_SHOW)) 
  {
    if (ME->QueryProp(P_BRIEF)==0 &&
      (time()<=last_move_time || find_call_out("delayed_long")!=-1)) 
    {
      while (remove_call_out("delayed_long")!=-1);
      call_out("delayed_long", 3);
    }
    if (ME->CanSee(1)) 
    {
      if (ME->QueryProp(P_BRIEF) || find_call_out("delayed_long")==-1)
        tell_object(ME, ""+ME->env_descr(1));
      else
        tell_object(ME, ""+ME->env_descr(1,1));
    }
    else if (ME->QueryProp(P_BRIEF)!=2) 
    {
      tell_object(ME, "Finsternis.\n");
    }
    last_move_time=time();
  }

  // Begruessungsschlag fuer die Gegener
  if (!(meth & M_NO_ATTACK)) {
    if( !present("death_mark", ME) ) { 
      enemies = filter_array( all_inventory(dest), #'CheckEnemy);
      filter_objects( enemies, "Attack", ME );
    }
  }

  return 1;
}

static void delayed_long() {
  while (remove_call_out("delayed_long")!=-1);
  if ((set_light(0)>!environment()->QueryProp(P_INDOORS)*UHR->IsNight()
     || ME->QueryProp(P_GHOST) || ME->QueryProp(P_NIGHTVISION)) &&
     !ME->QueryProp(P_BLIND)) {
    tell_object(ME,"Du schaust Dich erstmal etwas genauer um:\n"+
	ME->env_descr(1));
  }
}

varargs int remove() {
  destruct(ME);
  return 1;
}

void AddPursuer(object ob)
{
  mixed *pur;

  if (!objectp(ob))
    return;
  
  if (!pointerp(pur=Query(P_PURSUERS)))
    pur=({0,({})});
  else
    if (member(pur[1],ob)!=-1)
      return;
  SetProp(P_PURSUERS,({pur[0],pur[1]+({ob})}));
  ob->_SetPursued(ME);
}

void RemovePursuer(object ob)
{
  mixed *pur;
  
  if (pointerp(pur=Query(P_PURSUERS)) && member(pur[1],ob)!=-1)
  {
    pur[1]-=({ob});
    ob->_RemovePursued(ME);
    if (!pur[0]&&!sizeof(pur[1]))
      pur=0;
    SetProp(P_PURSUERS,pur);
  }
}

void _SetPursued(object ob)
{
  mixed *pur;
  
  if (!pointerp(pur=Query(P_PURSUERS)))
    pur=({0,({})});
  else
    if (objectp(pur[0]))
      pur[0]->RemovePursuer(ME);
  pur[0]=ob;
  Set(P_PURSUERS,pur);
}

void _RemovePursued(object ob)
{
  mixed *pur;
  
  if (!pointerp(pur=Query(P_PURSUERS)) || pur[0]!=ob)
    return;
  pur[0]=0;
  if (!sizeof(pur[1]))
    pur=0;
  Set(P_PURSUERS,pur);
}

void TakeFollowers() {
  mixed *f,env;
  int meth,i,r;
  
  f=Query(P_PURSUERS);
  if (!pointerp(f))
    return;
  env=environment();
  f=f[1]-({0});
  for (i=sizeof(f)-1;i>=0;i--)
    if (environment(f[i])!=env)
    {
      meth=M_NOCHECK;
      if (f[i]->Query(P_FOLLOW_SILENT))
        meth|=M_SILENT|M_NO_SHOW;
      catch(r=f[i]->PreventFollow(env));
      if (!r)
        f[i]->move(env,meth);
      else
        if (r==2)
          RemovePursuer(f[i]);
    }
}
