/*******************
** Eldarea MUDLib **
********************
**
** std/living/put_and_get.c -- living put and get handling
**
** CVS DATA
** $Date: 2000/12/04 11:02:21 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: put_and_get.c,v $
** Revision 1.2  2000/12/04 11:02:21  elatar
** messages rewritten
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types
#pragma save_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <container.h>
#include <properties.h>
#include <lightsource.h>
#include <moving.h>
#include <defines.h>
#include <units.h>
#include <events.h>

private static string num2str(int n)
{
  int e, z;
  string ret;

  if (n > 99) return "ganz viele";

  switch (n)
  {
    // unregelmaessige formen
    case 1:  return "eins";
    case 11: return "elf";
    case 12: return "zwoelf";
    case 16: return "sechzehn";
    case 17: return "siebzehn";

    // standardberechnung
    default:
      e = n % 10;
      z = n / 10;
      if (e)
      {
        ret = ({"ein","zwei","drei","vier","fuenf","sechs",
                "sieben","acht","neun"})[e-1];
        if (z > 1) ret += "und";
      }
      else ret = "";
      if (z)
        ret += ({"zehn","zwanzig","dreissig","vierzig","fuenfzig",
                 "sechzig","siebzig","achtzig","neunzig"})[z-1];
  }

  return ret;
}

private string output_string(object *o, int f)
{
  int i, j, *num;
  string *strs, *erg;

  i=sizeof(o);
  strs=allocate(i);
  erg=allocate(i);
  num=allocate(i);
  for (;i--;) {
    strs[i]=o[i]->name(WEN, f|NAME_PLURAL);
    if (!strs[i]) erg[i]=o[i]->name(WEN, f);
    else if (!strlen(strs[i])) { // !strlen heisst nicht zusammenfassen
      strs[i]=0;
      erg[i]=o[i]->name(WEN, f);
    }
  }
  i=sizeof(o);
  for (;i--;) {
    if (!strs[i]) continue;
    while ((j=member_array(strs[i], strs))!=i) {
      num[i]++;
      strs[j]=0;
    }
    if (!num[i]) { // nur 1 Exemplar
      erg[i]=o[i]->name(WEN, f);
      strs[i]=0;
      continue;
    }
    if (o[i]->QueryProp(P_ARTICLE)!=ART_NONE)
      erg[i]=num2str(num[i]+1)+" "+strs[i];
    else erg[i]=strs[i]; // Auch keine Zahlwoerter, wenn kein Artikel erlaubt
  }
  erg-=({ 0 });
  i=sizeof(erg);
  if (!i) return "?! Bug";
  if (i==1) return erg[0];
  return implode(erg[0..i-2], ", ")+" und "+erg[i-1];
}

string *parse_objects(string was)
{
  string *w1, *w2, *h, word, s;
  int stat, anzahl, komma;

  w2 = ({});
  w1 = efun::explode(was, ",");

  while (sizeof(w1))
  {
    w2 += efun::explode(w1[0], " und ");
    w1 = w1[1..];
  }

  while (sizeof(w2))
  {
    if (sizeof(h = efun::explode(w2[0], " ")) > 1)
      h -= ({ "", "ein", "eine", "einen", "die", "das", "den" });
    w1 += ({ implode(h, " ") });
    w2 = w2[1..];
  }
  return w1;
}

/*
 * switch (search)
 * { case 0: durchsuche nur environment(this_object());
 *   case 1: durchsuche nur this_object();
 *   case 2: durchsuche erst this_object(), dann environment(this_object())
 *   case 3: durchsuche erst environment(this_object()), dann this_object()
 * }
 */
varargs object *select_objects(string was, int info, int search)
{
  int i, j;
  string *obj;
  object *found_obs, *ob, env;

  obj = parse_objects(was);
  found_obs = ({});
  for (i = sizeof(obj); i;)
  {
    --i;
    switch (search)
    {
      case 1: case 2:
        ob = locate_objects(obj[i], info, found_obs);
        if (sizeof(ob) || (search == 1)) 
          break;
      case 0: case 3:
        if (environment(this_object()))
          ob = environment(this_object())->locate_objects(obj[i], info, found_obs);
        if (sizeof(ob) || (search == 2) || !search) 
          break;
        ob = locate_objects(obj[i], info, found_obs);
    }
    if (ob && sizeof(ob)) found_obs += ob; // ohne ({ .. }) !! ob ist ein array
    else if (info) switch (query_verb())
    {
      case "nimm":
      case "nehm":
      case "nehme":
        if (environment(this_object()) && member(environment(this_object())->QueryProp(P_DETAILS), obj[i]))
          tell_object(this_object(), "Das koennt Ihr nicht nehmen.\n");
        else
          tell_object(this_object(), "Das geht nicht.\n");
        break;
      case "gebe":
      case "geb":
      case "gib":
      case "schenke":
      case "schenk":
        break;
      default:
        tell_object(this_object(), sprintf("%s? So etwas besitzt Ihr nicht.\n", capitalize(obj[i])));
    }
  }
  return found_obs;
}

void add_put_and_get_commands()
{
  add_action("pick_things", "nimm");
  add_action("pick_things", "nehm", 1);
  add_action("drop_things", "werf", 1);
  add_action("drop_things", "wirf");
  add_action("drop_things", "lass", 1);
  add_action("drop_things", "leg", 1);  /* auch fuer put ! */
  add_action("drop_things", "stell", 1);
  add_action("put_things_into",  "steck", 1);
  add_action("give_things", "geb", 1);
  add_action("give_things", "gib");
  add_action("give_things", "schenke");
  add_action("give_things", "schenk");
}

/*
 * return 1, wenn move erfolgreich war
 * return 0, wenn fehlermeldung ausgegeben wurde
 * return -1, bei geschlossenem container
 * return -2, wenn keine fehlermeldung ausgegeben wurde
 */
int pick_obj(object ob)
{
  int ret;
  string str;
  object env;
  mapping data;

  if (!ob || !objectp(ob) || ob == this_object()) return -2;
  if (living(ob))
  { //TODO
    tell_object(this_object(), "Ihr koennt keine Lebewesen mit Euch herumtragen.\n");
    return 0;
  }
  if (!(env = environment(ob)) || (env == this_object()))
  {
    tell_object(this_object(), sprintf("%s habt Ihr doch bereits.\n", capitalize(ob->name(WEN, 1))));
    return 0;
  }

  if (env != environment(this_object()))
  {
    if (!env->QueryProp(P_CONTAINER) && !env->QueryProp(P_TRAY))
    {
      tell_object(this_object(), sprintf("Ihr koennt nichts von %s nehmen.\n", env->name(WEM, 1)));
      return 0;
    }
    else
    {
      if (env->QueryProp(P_CNT_STATUS) || env->is_closed())  // Container ist geschlossen
      {
        tell_object(this_object(), sprintf("Aber %s ist doch geschlossen.\n", env->name(WER, 1)));
        return -1;
      }
    }
  }

  data=EVENTD->send(ET_GET, ([ E_MOVE_OBJ:ob, E_MOVE_DEST:this_object()]),
    ({all_environment(this_object())[<1]}) );
  ret = (mappingp(data)?data[E_HANDLED]:0);

  if (ret > 0 && (environment(ob) == this_object() || ob->IsUnit())) return ret;

  if (ret == ME_TOO_HEAVY)
  {
    int iPluralMessage;

    iPluralMessage = (ob->IsUnit() && (ob->QueryProp(U_REQ) > 1));
    tell_object(this_object(), sprintf("%s %s zu schwer fuer Euch.\n", capitalize(ob->name(WER, 1)), (iPluralMessage ? "sind" : "ist")));
    return 0;
  }
  else if (ret == ME_TOO_BULKY)
  {
    tell_object(this_object(), sprintf("Ihr koennt %s nicht mehr tragen.\n", ob->name(WEN, 1)));
    return 0;
  }
  else if (ret == ME_CANT_BE_TAKEN)
  {
    if (str = ob->QueryProp(P_NOGET))
    {
      if (stringp(str)) tell_object(this_object(), break_string(str, BS_STDLEN, 0, 1));
      else tell_object(this_object(), sprintf("Ihr koennt %s nicht nehmen.\n", ob->name(WEN, 1)));
      return 0;
    }
  }

  return -2;
}

int pick_things(string str)
{
  object *found_obs, *o;
  string *complex_list;
  int i, bugmsg;

  if (this_object()->QueryProp(P_GHOST))
  {
    notify_fail("Als Geist koennt Ihr nichts nehmen.\n");
    return 0;
  }

  if (!str || str == "")
  {
    notify_fail("Was wollt Ihr nehmen?\n");
    return 0;
  }

  if (find_player(str) == this_object())
  {
    notify_fail("Ihr koennt Euch nicht selber nehmen.\n");
    return 0;
  }

  complex_list = efun::explode(str, " ")-({""});
  while ((i = member_array("aus", complex_list)) > 0)
    complex_list[i] = "in";
  while (((i = member_array("von", complex_list)) > 0) || ((i = member_array("vom", complex_list)) > 0))
    complex_list[i] = "auf";

  str = implode(complex_list, " ");

  if (!sizeof(found_obs = select_objects(str, 1, 3))) return 1;

  bugmsg = 1;
  o = ({});
  for (i = sizeof(found_obs); i;)
  {
    switch (pick_obj(found_obs[--i]))
    {
      case -1:       // geschlossener container
        i = 0;       // --> for beenden
      case  0:       // move fehlgeschlagen, fehlermeldung wurde bereits ausgegeben
        bugmsg = 0;  // keine message mehr noetig
      case -2:       // move fehlgeschlagen, aber noch keine fehlermeldung
        break;       // hier erstes break, vorher duerfen keine hin!!
      case MOVE_OK:  // moven war ok, erfolgsmeldungen erweitern
        o += ({ found_obs[i] });
      case MOVE_OK_SILENT:  // moven war ok, aber keine meldung ausgeben
        bugmsg = 0;
    }
  }

  if (sizeof(o))
  {
    tell_object(this_object(), break_string(sprintf("Ihr nehmt %s.\n", output_string(o, NAME_DEF)), BS_STDLEN));
    tell_room(environment(this_object()), break_string(sprintf("%s nimmt %s.\n", capitalize(this_object()->name(WER)), output_string(o, NAME_INDEF)), BS_STDLEN), ({ this_object() }) );
  }
  else if (bugmsg) tell_object(this_object(), "Nichts Nehmbares gefunden.\n");

  return 1;
}

// nur return 1; wenn moven erfolgreich war!!
int drop_obj(object ob)
{
  int ret;
  string str;
  mapping data;

  if (!ob || environment(ob) != this_object() || ob == this_object()) return 0;

  data=EVENTD->send(ET_DROP, ([ E_MOVE_OBJ:ob, 
    E_MOVE_DEST:environment(this_object())]),
    ({all_environment(this_object())[<1]}) );
  ret = (mappingp(data)?data[E_HANDLED]:0);

  if (ret > 0) return ret;
  if (ret == ME_CANT_BE_DROPPED)
  {
    if ((str = ob->QueryProp(P_NODROP)) && stringp(str))
      tell_object(this_object(), break_string(str, BS_STDLEN, 0, 1));
    else
      tell_object(this_object(), sprintf("Ihr koennt %s nicht wegwerfen.\n", ob->name(WEN, 1)));
  }

  return 0;
}

int main_drop(string str, string verb1, string verb2, string wie)
{
  object *found_obs, *o;
  int i;

  if (find_player(str) == this_object())
  {
    notify_fail("Ihr koennt Euch nicht selber wegwerfen.\n");
    return 0;
  }

  if (!sizeof(found_obs = select_objects(str, 1, 1))) return 1;

  o = ({});
  for (i = sizeof(found_obs); i;)
  {
    if (drop_obj(found_obs[--i]) == MOVE_OK)
    {
      o += ({ found_obs[i] });
    }
  }

  if (sizeof(o))
  {
    tell_object(this_object(), break_string(sprintf("Ihr %s %s %s.\n", verb1, output_string(o, NAME_DEF), wie), BS_STDLEN));
    tell_room(environment(this_object()), break_string(sprintf("%s %s %s %s.\n",
      capitalize(this_object()->name(WER)), verb2, output_string(o, NAME_INDEF), wie), BS_STDLEN), ({ this_object() }) );
  }

  return 1;
}

/*
 ******************************
 * Container handling
 ******************************
 */

// nur return 1; wenn moven erfolgreich war!!
int put_into(object ob, object where)
{
  int ret;
  object env;
  string str;
  mapping data;

  if (!ob) return 0;
  if (ob == this_object())
  {
    tell_object(this_object(), "Ihr koennt Euch nicht selber da reinstecken!\n");
    return 0;
  }

  if (ob == where)
  {
    tell_object(this_object(), sprintf("Ihr koennt %s nicht in sich selbst stecken!\n", ob->name(WEN, 1)));
    return 0;
  }

  if (living(ob))
  {
    //TODO: Livings gehen doch?
    tell_object(this_object(), "Ihr koennt keine Lebewesen in etwas stecken.\n");
    return 0;
  }

  /*
  //TODO: Container in Container geht wohl
  if (first_inventory(ob))
  {
    tell_object(this_object(), sprintf("%s ist nicht leer.\n", capitalize(ob->name(WER, 1))));
    return 0;
  }
  */
  if (str = ob->QueryProp(P_NOGET))
  {
    if (stringp(str)) tell_object(this_object(), break_string(str, BS_STDLEN));
    else tell_object(this_object(), sprintf("%s koennt Ihr nicht in %s hineinstecken.\n", capitalize(ob->name(WER, 1)), where->name(WEN, 1)));
    return 0;
  }
  if (ob->QueryProp(P_LIGHTED))
  {
    //TODO: brennen :)
    tell_object(this_object(), sprintf("Ihr musst %s erst ausmachen.\n", ob->name(WEN, 1)));
    return 0;
  }

  data=EVENTD->send(ET_PUT, ([ E_MOVE_OBJ:ob, E_MOVE_DEST:where]),
    ({all_environment(this_object())[<1]}) );
  ret = (mappingp(data)?data[E_HANDLED]:0);

  if (ret > 0) return ret;
  switch (ret)
  {
    case ME_CANT_BE_DROPPED:
      if ((str = ob->QueryProp(P_NODROP)) && stringp(str)) tell_object(this_object(), break_string(str, BS_STDLEN, 0, 1));
      else tell_object(this_object(), sprintf("So werdet Ihr %s nicht los.\n", ob->name(WEN, 1)));
      break;
    case ME_TOO_HEAVY:
    {
      int iPluralMessage;

      iPluralMessage = (ob->IsUnit() && (ob->QueryProp(U_REQ) > 1));
      tell_object(this_object(), sprintf("%s %s zu schwer fuer %s.\n", capitalize(ob->name(WER, 1)), (iPluralMessage ? "sind" : "ist"), where->name(WEN, 1)));
      break;
    }
    case ME_TOO_BULKY:
      tell_object(this_object(), sprintf("%s passt nicht mehr in %s hinein.\n", capitalize(ob->name(WER, 1)), where->name(WEN, 1)));
      break;
    case ME_CANT_BE_INSERTED:
      tell_object(this_object(), sprintf("%s koennt Ihr nicht in %s hineinstecken.\n", capitalize(ob->name(WEN, 1)), where->name(WEN, 1)));
  }

  return 0;
}

int IsContainer(object ob) { return ob->QueryProp(P_CONTAINER); }
int ContainerIsOpen(object ob) { return (!(ob->QueryProp(P_CNT_STATUS)) && ob->is_open()); }

object *ValidContainers(string *dest_list)
{
  object *dest_obs;

  // Ist ueberhaupt ein Container da, in den etwas hineingesteckt werden kann?
  dest_obs = select_objects(implode(dest_list, " "), 1, 2);
  dest_obs = filter_array(dest_obs, "IsContainer");
  if (!dest_obs || !sizeof(dest_obs))
  {
    tell_object(this_object(), "Nichts zum Hineinstecken oder Drauflegen gefunden.\n");
    return 0;
  }

  // ist ein geoeffneter Container da?
  dest_obs = filter_array(dest_obs, "ContainerIsOpen");
  if (!dest_obs || !sizeof(dest_obs))
  {
    tell_object(this_object(), "Keinen geoeffneten Behaelter gefunden.\n");
    return 0;
  }

  return dest_obs;
}

string *ValidPutIntoArguments(string str)
{
  string *complex_list;
  int i, j;

  notify_fail("Was wollt Ihr wohin stecken?\n");
  if (!str || str == "") return 0;

  j = sizeof(complex_list = efun::explode(str, " ")-({""})) - 1;
  i = member_array("in", complex_list);

  if ((i == -1) || (i == j))
  {
    notify_fail("Wo wollt Ihr das hineinstecken?\n");
    return 0;
  }

  if (!i)
  {
    notify_fail("Was wollt Ihr dort hineinstecken?\n");
    return 0;
  }

  if (find_player(complex_list[i-1]) == this_object())
  {
    notify_fail("Ihr koennt Euch nicht selber wegstecken.\n");
    return 0;
  }

  return complex_list;
}

int put_things_into(string str)
{
  object *src_obs, *dest_obs, *o;
  string *src_list, *dest_list, *complex_list;
  int i;

  complex_list = ValidPutIntoArguments(str);
  if (!(complex_list) || !(sizeof(complex_list))) return 0;

  i = member_array("in", complex_list);
  src_list = complex_list[0..i-1];
  dest_list = complex_list[i+1..];

  src_obs = select_objects(implode(src_list, " "), 1, 2);
  if (!src_obs || !sizeof(src_obs)) return 1;

  if (!(dest_obs = ValidContainers(dest_list))) return 1;

  o = ({});
  for (i = sizeof(src_obs); i;)
  {
    if (put_into(src_obs[--i], dest_obs[0]) == MOVE_OK)
    {
      o += ({ src_obs[i] });
    }
  }

  if (sizeof(o))
  {
    tell_object(this_object(), break_string(sprintf("Ihr steckt %s in %s.\n", output_string(o, NAME_DEF), dest_obs[0]->name(WEN, 1)), BS_STDLEN));
    tell_room(environment(this_object()), break_string(sprintf("%s steckt %s in %s.\n", capitalize(this_object()->name(WER)), output_string(o, NAME_INDEF), dest_obs[0]->name(WEN)), BS_STDLEN), ({ this_object() }) );
  }

  return 1;
}

/*
 ******************************
 * Tray handling
 ******************************
 */

//nur return 1; wenn moven erfolgreich !!
int put_of(object src, object dest)
{
  mixed str;
  int ret;
  mapping data;

  if (!src || !dest) return 0;
  if (src == this_object())
  {
    tell_object(this_object(), "Ihr koennt Euch nicht selber darauflegen.\n");
    return 0;
  }
  if (src == dest)
  {
    tell_object(this_object(), sprintf("Ihr koennt %s nicht auf sich selbst legen.\n", src->name(WEN, 1)));
    return 0;
  }
  if (str = src->QueryProp(P_NOGET))
  {
    if (stringp(str)) tell_object(this_object(), break_string(str, BS_STDLEN, 0, 1));
    else tell_object(this_object(), sprintf("Ihr koennt %s nicht auf %s legen.\n", src->name(WEN, 1), dest->name(WEN, 1)));
    return 0;
  }

// Abfrage auf P_LIGHTED?? warum sollte man keine brennende lampe auf einen
// tisch stellen koennen?

  data=EVENTD->send(ET_PUT, ([ E_MOVE_OBJ:src, E_MOVE_DEST:dest]),
    ({all_environment(this_object())[<1]}) );
  ret = (mappingp(data)?data[E_HANDLED]:0);

  if (ret > 0) return ret;

  switch (ret)
  {
    case ME_CANT_BE_DROPPED:
      if ((str = src->QueryProp(P_NODROP)) && stringp(str)) tell_object(this_object(), break_string(str, BS_STDLEN, 0, 1));
      else tell_object(this_object(), sprintf("So werdet Ihr %s nicht los.\n", src->name(WEN, 1)));
      break;
    case ME_TOO_HEAVY:
    {
      int iPluralMessage;

      iPluralMessage = (src->IsUnit() && (src->QueryProp(U_REQ) > 1));
      tell_object(this_object(), sprintf("%s %s zu schwer fuer %s.\n", capitalize(src->name(WER, 1)), (iPluralMessage ? "sind" : "ist"), dest->name(WEN, 1)));
      break;
    }
    case ME_TOO_BULKY:
      tell_object(this_object(), sprintf("%s passt nicht mehr auf %s.\n", capitalize(src->name(WER, 1)), dest->name(WEN, 1)));
      break;
    case ME_CANT_BE_INSERTED:
      tell_object(this_object(), sprintf("Ihr koennt %s nicht auf %s legen.\n", src->name(WEN, 1), dest->name(WEN, 1)));
  }

  return 0;
}

string *ValidPutOfArguments(string str)
{
  string *complex_list;
  int i, j;

  notify_fail("Was wollt Ihr worauf legen?\n");
  if (!str || str == "") return 0;

  j = sizeof(complex_list = efun::explode(str, " ")-({""})) - 1;
  i = member_array("auf", complex_list);

  if ((i == -1) || (i == j))
  {
    notify_fail("Worauf wollt Ihr das legen?\n");
    return 0;
  }

  if (!i)
  {
    notify_fail("Was wollt Ihr darauf legen?\n");
    return 0;
  }

  return complex_list;
}

int IsTray(object ob) { return ob->QueryProp(P_TRAY); }

object *ValidTrays(string *dest_list)
{
  object *dest_obs;

  // Ist ueberhaupt ein Tray da, auf den etwas gelegt werden kann?
  dest_obs = select_objects(implode(dest_list, " "), 1, 3);
  dest_obs = filter_array(dest_obs, "IsTray");
  if (!dest_obs || !sizeof(dest_obs))
  {
    tell_object(this_object(), "Nichts gefunden, wo Ihr etwas drauflegen koenntet.\n");
    return 0;
  }

  return dest_obs;
}

int put_things_of(string str)
{
  int i, j;
  string *complex_list, *src_list, *dest_list;
  object *src_obs, *dest_obs, *o;

  complex_list = ValidPutOfArguments(str);
  if (!(complex_list) || !(sizeof(complex_list))) return 0;

  i = member_array("auf", complex_list);
  src_list = complex_list[0..i-1];
  dest_list = complex_list[i+1..];

  src_obs = select_objects(implode(src_list, " "), 1, 2);
  if (!src_obs || !sizeof(src_obs)) return 1;

  if (!(dest_obs = ValidTrays(dest_list))) return 1;

  o = ({});
  for (i = sizeof(src_obs); i;)
  {
    if (put_of(src_obs[--i], dest_obs[0]) == MOVE_OK)
    {
      o += ({ src_obs[i] });
    }
  }

  if (sizeof(o))
  {
    tell_object(this_object(), break_string(sprintf("Ihr legt %s auf %s.\n", output_string(o, NAME_DEF), dest_obs[0]->name(WEN, 1)), BS_STDLEN));
    tell_room(environment(this_object()), break_string(sprintf("%s legt %s auf %s.\n", capitalize(this_object()->name(WER)), output_string(o, NAME_INDEF), dest_obs[0]->name(WEN)), BS_STDLEN), ({ this_object() }) );
  }

  return 1;
}

/*
 ******************************
 * drop handling
 ******************************
 */

int drop_things(string str)
{
  string verb, arg, dummy;

  notify_fail("Was wollt Ihr denn weglegen?\n");
  if (!stringp(str) || str == "") return 0;

  if (this_object()->QueryProp(P_GHOST))
  {
    notify_fail("Als Geist koennt Ihr nichts weglegen.\n");
    return 0;
  }

  verb = query_verb();
  if (verb[0..2] == "leg")
  {
    if (sscanf(str, "%s auf %s", arg, dummy) == 2) return put_things_of(str);
    if (sscanf(str, "%s in %s", arg, dummy) == 2) return put_things_into(str);
    if (sscanf(str, "%s ab", arg) == 1) return main_drop(arg, "legst", "legt", "ab");
    if (sscanf(str, "%s weg", arg) == 1) return main_drop(arg, "legst", "legt", "weg");
    notify_fail("Lege etwas ab, oder was meint Ihr?\n");
    return 0;
  }

  if (verb[0..3] == "lass")
  {
    if (sscanf(str, "%s fallen", arg) == 1) return main_drop(arg, "laesst", "laesst", "fallen");
    notify_fail("Lass etwas fallen, oder was meint Ihr?\n");
    return 0;
  }

  if (verb == "wirf" || verb[0..3] == "werf")
  {
    if (sscanf(str, "%s weg", arg) == 1) return main_drop(arg, "wirfst", "wirft", "weg");
    notify_fail("Wirf etwas weg, oder was meint Ihr?\n");
    return 0;
  }

  if (verb[0..4] == "stell")
  {
    if (sscanf(str, "%s ab", arg) == 1) return main_drop(arg, "stellst", "stellt", "ab");
    if (sscanf(str, "%s weg", arg) == 1) return main_drop(arg, "stellst", "stellt", "weg");
    notify_fail("Stelle etwas ab, oder was meint Ihr?\n");
    return 0;
  }

  return 0;
}

// ACHTUNG!! nur return 1; wenn moven geglueckt ist!!
int give_obj(object was, object wem)
{
  int ret;
  string str;
  object env;
  int is_unit;
  mapping data;

  if (!was || was == this_object() || was == wem)
  {
    tell_object(this_object(), "Das geht so nicht!\n");
    return 0;
  }

  if (environment(was) != this_object())
  {
    tell_object(this_object(), sprintf("%s befindet sich nicht in Eurem Inventar.\n", capitalize(was->name(WER, 1))));
    return 0;
  }

  if (environment(wem) != environment(this_object())) return 0;

  data=EVENTD->send(ET_GIVE, ([ E_MOVE_OBJ:was, E_MOVE_DEST:wem]),
    ({all_environment(this_object())[<1]}) );
  ret = (mappingp(data)?data[E_HANDLED]:0);

  switch (ret)
  {
    case ME_TOO_BULKY:
      printf("%s kann nichts mehr tragen.\n", capitalize(wem->name(WER, 1)));
      return 0;
    case ME_TOO_HEAVY:
    {
      int iPluralMessage;

      iPluralMessage = (was->IsUnit() && (was->QueryProp(U_REQ) > 1));
      printf("%s %s zu schwer fuer %s.\n", capitalize(was->name(WER, 1)), (iPluralMessage ? "sind" : "ist"),
        wem->name(WEN,1));
      return 0;
    }
    case ME_CANT_BE_DROPPED:
      if ((str = was->QueryProp(P_NODROP)) && stringp(str))
        tell_object(this_object(), break_string(str, BS_STDLEN, 0, 1));
      else
        tell_object(this_object(), sprintf("Ihr koennt %s nicht weggeben!\n", was->name(WEN, 1)));
      return 0;
  }

  return ret;
}

int old_give_things(string *was, string *wem)
{
  object *src_obs, *ziel, *was_obj, *o;
  int j;
  string verb1, verb2;

  if (query_verb()[0..2]=="sch")
  {
    verb1 = "schenkt";
    verb2 = "schenkt";
  }
  else
  {
    verb1 = "gebt";
    verb2 = "gibt";
  }

  while ((j = member_array("aus", was)) > 0) was[j] = "in";
  while ((j = member_array("von", was)) > 0) was[j] = "auf";

  src_obs = select_objects(implode(was, " "), 1, 1);
  if (!src_obs || !sizeof(src_obs))
  {
    tell_object(this_object(), sprintf("%s? So etwas besitzt Ihr nicht.\n", capitalize(was[0])));
    return 1;
  }

  ziel = select_objects(implode(wem, " "), 1, 0);
  for (j = sizeof(ziel); j;)
    if (!living(ziel[--j]))
      ziel = ziel[0..j-1]+ziel[j+1..<1];

  if (!ziel || !sizeof(ziel))
  {
    notify_fail("Empfaenger nicht gefunden.\n");
    return 0;
  }

  if (ziel[0] == this_object())
  {
    if (sizeof(ziel) == 1)
    {
      notify_fail("Euch selbst koennt Ihr nichts geben.\n");
      return 0;
    }
    ziel[0] = ziel[1];
  }

  if (query_once_interactive(ziel[0]) && !interactive(ziel[0]))
  {
    notify_fail(ziel->Name()+" ist zu abwesend, um etwas entgegenzunehmen.\n");
    return 0;
  }

  o = ({});
  was_obj = ({});
  for (j = sizeof(src_obs); j;)
  {
    switch (give_obj(src_obs[--j], ziel[0]))
    {
      case MOVE_OK:
        o += ({ src_obs[j] });
        // no break !!
      case MOVE_OK_SILENT:
        was_obj += ({ src_obs[j] });
    }
  }

  if (sizeof(o))
  {
    tell_object(this_object(), break_string(sprintf("Ihr %s %s %s.\n", verb1, ziel[0]->name(WEM, 1), output_string(o, NAME_DEF)), BS_STDLEN));
    tell_object(ziel[0], break_string(sprintf("%s %s Euch %s.\n", capitalize(this_object()->name(WER, 1)), verb2, output_string(o, NAME_INDEF)), BS_STDLEN));
    tell_room(environment(this_object()), break_string(sprintf("%s %s %s %s.\n", capitalize(this_object()->name(WER, 1)), verb2, ziel[0]->name(WEM, 1), output_string(o, NAME_INDEF)), BS_STDLEN), ({ this_object(), ziel[0] }) );
  }

  if (!query_once_interactive(ziel[0]))
    for (j = 0; j < sizeof(was_obj); j++)
      ziel[0]->give_notify(was_obj[j]);

  return 1;
}

int give_things(string str)
{
  string *words;
  int i, j;

  notify_fail("Wem wollt Ihr was geben?\n");
  if (!str || str == "") return 0;

  if (this_player()->QueryProp(P_GHOST))
  {
    notify_fail("Als Geist koennt Ihr nichts weggeben.\n");
    return 0;
  }

  words = efun::explode(str, " ")-({""});

  if (!(j = sizeof(words)-1))
  {
    notify_fail("Wem wollt Ihr etwas geben?\n");
    return 0;
  }

  if ((i = member_array("an", words)) > -1)
  {
    if (!i)
    {
      notify_fail("Was wollt Ihr denn weggeben?\n");
      return 0;
    }
    if (i == j)
    {
      notify_fail("Wem wollt Ihr etwas geben?\n");
      return 0;
    }
    return old_give_things(words[0..i-1], words[i+1..]);
  }

  return old_give_things(words[1..], words[0..0]);
}
