/*******************
** Eldarea MUDLib **
********************
**
** std/living/sense.c - living senses
**
** CVS DATA
** $Date: 2001/02/01 09:24:07 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: senses.c,v $
** Revision 1.2  2001/02/01 09:24:07  elatar
** default vision implemented
**
** Revision 1.1  2000/12/04 15:20:46  elatar
** initial release
**
**
**
*/

#define NEED_PROTOTYPES

#include <thing/properties.h>

#undef NEED_PROTOTYPES

#include <properties.h>
#include <living/senses.h>

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

void create()
{
  Set(P_BLIND, SAVE, F_MODE);
  Set(P_DEAF, SAVE, F_MODE);
  Set(P_BLAND, SAVE, F_MODE);
  Set(P_VISION, ([-2:0,-1:0,0:0,1:1,2:2,3:2,4:2,5:2,6:2,7:2]));
  Set(P_VISION, SAVE|SECURED, F_MODE);
}

varargs int CanSee(int silent)
{
  object env;
  mapping vision;
  string is_blind;
  int light;

  if(is_blind = this_object()->QueryProp(P_BLIND))
  {
    if (!silent)
    {
      if (stringp(is_blind)) 
        write(is_blind);
      else write("Ihr seid blind!\n");
    }
    return 0;
  }
  env=environment();
  vision=this_object()->QueryProp(P_VISION);
  if ( env && mappingp(vision))
  {
    switch(vision[env->QueryInternalLight()])
    {
      case -1:
        if (!silent)
          write("Ihr seid geblendet!\n");
        return 0;
      case 0:
        if (!silent)
          write("Es ist zu dunkel!\n");
        return 0;
      case 1:
        return 1;
      case 2:
        return 2;
    }
  }
  write(break_string(
    "Bug in der Sichtberechnung. Bitte ein Mitglied des grossen Rats "
    "benachrichtigen"));
  return 1;
}

varargs int CanHear(int silent)
{
  string is_deaf;
  
  if(is_deaf = this_object()->QueryProp( P_DEAF ))
  {
    if (!silent)
    {
      if (stringp(is_deaf)) 
        write(is_deaf);
      else write( "Ihr seid taub!\n" );
    }
    return 0;
  }
  return 1;
}

varargs int CanSmell(int silent)
{
  string is_bland;
  
  if(is_bland = this_object()->QueryProp(P_BLAND))
  {
    if (!silent)
    {
      if (stringp(is_bland)) 
        write(is_bland);
      else write( "Ihr koennt nichts riechen!\n" );
    }
    return 0;
  }
  return 1;
}
