/*******************
** Eldarea MUDLib **
********************
**
** std/living/skills - living skill handling
**
** CVS DATA
** $Date: 2000/12/04 11:02:40 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: skills.c,v $
** Revision 1.2  2000/12/04 11:02:40  elatar
** completely rewritten from scratch
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <properties.h>
#include <defines.h>
#include <combat.h>
#include <wizlevels.h>
#include <daemon/pmaster.h>
#include <rpgsys.h>

#define NEED_PROTOTYPES

#include <living/skills.h>
#include <thing/properties.h>

#pragma strict_types

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

// skills sind nun save variable
// Format siehe skills.h
mapping skills;

void create()
{
  if (!mappingp(skills))
    skills=ALL_SKILLS;
  Set(P_SKILLS,#'_query_skills,F_QUERY_METHOD);
  Set(P_SKILLS,NOSETMETHOD,F_MODE_AS);
  Set(P_SKILLS,PROTECTED,F_MODE_AS);
  SetProp(P_SKILL_MOD,([]));
  Set(P_ACTIVE_SKILLS,([]));
  Set(P_ACTIVE_SKILLS,PROTECTED,F_MODE_AS);
  Set(P_DP,SAVE|SECURED|PROTECTED,F_MODE_AS);
}


static void heart_beat()
{
  int i;
  string * ind;
  mixed * expire_callback;
  mapping active_skills;
 
  // active skills expiren    
  active_skills=QueryProp(P_ACTIVE_SKILLS);
  if (!mappingp(active_skills))
    active_skills=([]);
  ind=m_indices(active_skills);
  
  for (i=sizeof(ind);i-->0;)
  {	
    if (active_skills[ind[i],ASI_EXPIRE]<time() && active_skills[ind[i],ASI_EXPIRE]!=-1)
    {
      if (pointerp(active_skills[ind[i],ASI_CALLBACK]))
        expire_callback=active_skills[ind[i],ASI_CALLBACK]+({active_skills[ind[i],ASI_EXTRA]});
      m_delete(active_skills,ind[i]);  
      SetProp(P_ACTIVE_SKILLS,active_skills);
      if ( pointerp(expire_callback)
        && sizeof(expire_callback)>2 )
      {
        call_other(expire_callback[0],expire_callback[1],expire_callback[2]);
      }
    }
  }
}

/** Skill Methoden, zur allgemeinen Verwendung */

int UseSkillRanks(string skill)
{
  if (!member(skills,skill))
    return 0;

  OneSkillUse(skill);
  
  return skills[skill,SI_RANKS];    
}

int QuerySkillRank(string skill)
{
  if (!member(skills,skill))
    return 0;
  
  return skills[skill,SI_RANKS];    
}

int UseAttackSkill(string wt)
{   
  switch (wt)
  {
    case WT_KNIFE:
      wt=SK_STING;
      break;
    case WT_FENCING:
    case WT_SWORD:
      wt=SK_SWORD;
      break;
    case WT_AXE:
      wt=SK_AXE;
      break;
    case WT_CLUB:
      wt=SK_CLUB;
      break;
    case WT_SPEAR:
    case WT_POLE:
      wt=SK_POLE;
      break;
    case WT_FLAIL:
      wt=SK_FLAIL;
      break;
    case WT_THROW:
      wt=SK_THROWING;
      break;
    case WT_SHOOT:
    case WT_AMMU:
      wt=SK_ARCHERY;
      break;
    case WT_HANDS:
      wt=SK_MARTIAL_ARTS;
      break;
  }
  return UseSkill(wt);
}

// activate one active skill
// results:
//  0 - no success
// -1 - skill was activated and expires later
//  1 - success
varargs int ActivateSkill(string skill, int success, int expire, mixed extra, mixed * expire_callback)
{
  mapping active_skills;  
    
  if (!member(skills,skill) || !intp(expire))
    return 0;
    
  active_skills=QueryProp(P_ACTIVE_SKILLS);
  if (member(active_skills,skill) && expire<active_skills[skill,ASI_EXPIRE])
    return -1;
  
  active_skills+=([skill:success;expire;extra;expire_callback]);
  
  SetProp(P_ACTIVE_SKILLS,active_skills);
  return 1;  
}

void DeactivateSkill(string skill)
{
  mapping active_skills;
  mixed * expire_callback;
  
  active_skills=QueryProp(P_ACTIVE_SKILLS);
  if (!member(active_skills,skill))
    return;
  
  if (pointerp(active_skills[skill,ASI_CALLBACK]))
    expire_callback=active_skills[skill,ASI_CALLBACK]+({active_skills[skill,ASI_EXTRA]});
  m_delete(active_skills,skill);  
  SetProp(P_ACTIVE_SKILLS,active_skills);
  if (active_skills[skill,ASI_CALLBACK]
    && sizeof(expire_callback)>2 )
  {
    call_other(expire_callback[0],expire_callback[1],expire_callback[2]);
  }
}

int QueryActiveSkill(string skill)
{
  return QueryProp(P_ACTIVE_SKILLS)[skill];    
}

varargs int UseActiveSkill(string skill,int stop)
{
  mapping active_skills;
  int ret;
  
  active_skills=QueryProp(P_ACTIVE_SKILLS);
  if (!member(active_skills,skill))
    return 0;
  
  ret=active_skills[skill,ASI_SUCCESS];
  
  if (stop)
  {
    m_delete(active_skills,skill);
    SetProp(P_ACTIVE_SKILLS,active_skills);
  }
  return ret;
}

int UseSkill(string skill)
{  
  int mod,i;

  if (!member(skills,skill))
    return 0;
    
  if (sizeof(skills[skill,SI_ATTR]))
  {
    for (i=sizeof(skills[skill,SI_ATTR]);i-->0;)
      mod+=(int)ME->UseAttBon(skills[skill,SI_ATTR][i]);
  
    mod/=sizeof(skills[skill,SI_ATTR]);
  }
  
  OneSkillUse(skill);
  
  return skills[skill,SI_BONUS]+mod+QueryProp(P_SKILL_MOD)[skill];
}

varargs int SkillCheck(string skill, int difficulty)
{
  int mod,i;

  if (sizeof(skills[skill,SI_ATTR]))
  {
    for (i=sizeof(skills[skill,SI_ATTR]);i-->0;)
      mod+=(int)ME->UseAttBon(skills[skill,SI_ATTR][i]);
  
    mod/=sizeof(skills[skill,SI_ATTR]);
  }
  
  OneSkillUse(skill);
  
  return skills[skill,SI_BONUS]+mod+QueryProp(P_SKILL_MOD)[skill]
         +difficulty+d100()+QueryProp(P_GLOBAL_MOD);
}

/** OneSkillUse(SK_SWORD,({filename, cmd})) */
static varargs void OneSkillUse(string skill,string * use)
{
      
  skills[skill,SI_USES]++;
  // lastuses heb ich mal fuer spaeter auf...
  //skills[skill,SI_LASTU]+=({});
}

int skill_cost(string skill)
{
  if (!skills[skill,SI_LEARNED])
    return skills[skill,SI_COST];
  else
    switch(skills[skill,SI_COST])
    {
      case 1:
        return 2;
        break;  
      case 2:
        return 3;
        break;  
      case 3:
        return 5;
        break;  
      case 4:
        return 7;
        break;  
      case 5:
        return 9;
        break;  
      default:
        return 2*skills[skill,SI_COST];
        break;  
    } 
}

varargs int AddSkillRank(string skill, int skillrank)
{
  if (!member(skills,skill))
    return 0;
  if (!skillrank)
    skillrank=1;
    
  skills[skill,SI_RANKS]+=skillrank;
  // neuer bonus muss immer berechnet werden
  skills[skill,SI_BONUS]=calcBonus(skill,"",skills[skill,SI_RANKS]);

  // nicht grad besonders schoen, muss aber sein
  if (skill==SK_BODY_DEVELOPMENT)
    ME->UpdatePoints();
  return skills[skill,SI_RANKS];	
}

varargs void RaiseSkills(int dp)
{
  mapping skillinfo;
  mixed * work_array;
  string * ind;
  int i,j,lvl;
  
  if (!dp)
    dp=QueryProp(P_DP);
    
  skillinfo=(mapping)PMASTER->QuerySkills(QueryProp(P_PROFESSION),QueryProp(P_FIRST_WEAPON_SKILLS));
  
  work_array=({({}),({}),({}),({}),({}),({}),({}),({}),({}),({}),({})});
  ind=m_indices(skillinfo);

  // nach prioritaet sortieren
  ind=sort_array(ind
    ,lambda(({'x,'y}),
      ({#'<
       ,({#'[,skillinfo,'x,1})
       ,({#'[,skillinfo,'y,1})})));
  
  lvl=QueryProp(P_LEVEL);
  // first run over all skills
  for (i=0;i<sizeof(ind)&&dp;i++)
  {
    if ( skills[ind[i],SI_RANKS]<to_int(skillinfo[ind[i],2]*lvl)+1 
      && dp>=skill_cost(ind[i])
      && skills[ind[i],SI_LEARNED]<2)
    {
      AddSkillRank(ind[i],1);
      dp-=skill_cost(ind[i]);
      skills[ind[i],SI_LEARNED]++;
      if (skillinfo[ind[i],3])
      {
        if ( skills[ind[i],SI_RANKS]<to_int(skillinfo[ind[i],2]*lvl)+1
          && dp>=skill_cost(ind[i])
          && skills[ind[i],SI_LEARNED]<2)
        {
          AddSkillRank(ind[i],1);
          dp-=skill_cost(ind[i]);
          skills[ind[i],SI_LEARNED]++;
          ind[i]=0;
        }
      }
      else
      {
        ind[i]=0; 
      }
    }
  }
  ind-=({0});

  // second one, all needs were already fit *shrug*
  for (i=0;i<sizeof(ind)&&dp;i++)
  {
    if ( dp>=skill_cost(ind[i])
      && skills[ind[i],SI_LEARNED]<2)
    {
      AddSkillRank(ind[i],1);
      dp-=skill_cost(ind[i]);
      skills[ind[i],SI_LEARNED]++;
      if ( dp>=skill_cost(ind[i])
        && skills[ind[i],SI_LEARNED]<2)
      {
        AddSkillRank(ind[i],1);
        dp-=skill_cost(ind[i]);
        skills[ind[i],SI_LEARNED]++;
      }
    }
  }
  SetProp(P_DP,dp);  
}

/** Ab hier folgen die internen Funktionen */

varargs static int calcBonus(string skill, string descr, int ranks, int bonus, int cost, int uses, string * lastu, string * attr)
{
  // kleine Tabelle zu den skillrank-bonus beziehungen
  //
  // Ranks    Bonus
  //   0        -25
  //   1          5
  //   2         10
  //   .         ..
  //  10         50
  //  11         54
  //  12         58
  //  ..         ..
  //  20         90
  //  21         93
  //  22         96
  //  ..        ...
  //  30        120
  //  31        122
  //  32        124
  //  ..        ...
  //  40        140
  //  41        141
  //  42        142
  //  ..        ...
  //  50        150
  //  51        150
  //  52        151
  //  53        151
  //  54        152
  //  ..        ...
  //  60        155
  //  70        160
  //  80        165
  //  90        170
  // 100        175
  // ...        ...
  
  if (ranks<1)
    bonus=-25;
  else if (ranks<10)
    bonus=ranks*5;
  else if (ranks<20)
    bonus=50+(ranks-10)*4;
  else if (ranks<30)
    bonus=90+(ranks-20)*3;
  else if (ranks<40)
    bonus=120+(ranks-30)*2;
  else if (ranks<50)
    bonus=140+(ranks-40)*1;
  else
    bonus=150+to_int((ranks-10)*0.5);
  
  return bonus;
}

int SetSkill(string skill, int val)
{
  if ( previous_object() 
    && previous_object()!=ME 
    && !IS_ARCH(getuid(previous_object())) )
    return 0;
  if (!member(skills,skill))
    return 0;

  skills[skill,SI_RANKS]=val;
  skills[skill,SI_BONUS]=calcBonus(skill,"",skills[skill,SI_RANKS]);
  
  return skills[skill,SI_RANKS];	
}

varargs mapping SetSkills(mapping nskills)
{
 
  if ( previous_object() 
    && previous_object()!=ME 
    && !IS_ARCH(getuid(previous_object())) 
    && explode(file_name(previous_object()),"#")[0]!="/secure/login")
    return 0;
  if (!mappingp(nskills))
    nskills=ALL_SKILLS;
  
  walk_mapping(nskills, "calcBonus");  
  PMASTER->SetSkillcosts(nskills,QueryProp(P_PROFESSION),QueryProp(P_FIRST_WEAPON_SKILLS));
  
  return skills=nskills;
}

static void sumBoni(string skill, string descr, int ranks, int bonus, int cost, int uses, string * lastu, string * attr)
{ 
  if (sizeof(attr))
  {
   int mod,i;

    for (i=sizeof(attr);i-->0;)
      mod+=(int)ME->UseAttBon(attr[i]);
    
    mod/=sizeof(attr);
    
    mod+=QueryProp(P_SKILL_MOD)[skill];
    
    bonus+=mod;
  }
}

static mapping _query_skills()
{
  mapping retval;
  
  retval=copy_mapping(skills);
  
  walk_mapping(retval,"sumBoni");
  
  return retval;
}

void ExpireQuickfight(int flag)
{
  if (flag<0)
  {
    tell_object(ME,
      "Die Erschoepfung durch Euren letzten Schnellkampf beginnt nachzulassen.\n");
    ActivateSkill(SK_QUICKFIGHT,0,time()+20,0,({ME,"ExpireQuickfight"}));
  }	
  else if (flag>0)
  {
    tell_object(ME,
      "Eure Konzentration laesst nach und Ihr werdet wieder langsamer.\n");
    tell_room(environment(ME),
      ME->Name(WESSEN)+" Bewegungen werden wieder langsamer",({ME}));
    ActivateSkill(SK_QUICKFIGHT,-100,time()+10,-1,({ME,"ExpireQuickfight"}));
  }
  else
  {
    tell_object(ME,
      "Die Erschoepfung durch Euren letzten Schnellkampf laesst ganz nach.\n");
  }
}

int cmd_quickfight(string str)
{
  int res;
	
  if (QueryActiveSkill(SK_QUICKFIGHT))
  {
    if (UseActiveSkill(SK_QUICKFIGHT)>0)
      tell_object(ME,"Ihr kaempft doch schon schnell.\n");
    else
      tell_object(ME,"Ihr seid noch zu erschoepft vom letzten Versuch.\n");
    return 1;
  }
  
  res=SkillCheck(SK_QUICKFIGHT);
  if (!EvalCheck(res))
  {
    tell_object(ME,break_string(
      "Ihr versenkt Euch in Euren Koerper und versucht Euch zu beschleunigen, "
      "doch Ihr seid nicht konzentriert genug und es misslingt Euch."));
    ActivateSkill(SK_QUICKFIGHT,0,time()+8-(res/25),0,({ME,"ExpireQuickfight"}));
  }
  else
  {
    tell_object(ME,break_string(
      "Ihr versenkt Euch in Euren Koerper und zwingt ihn dazu, sich schneller "
      "zu bewegen."));
    tell_room(environment(ME),
      ME->Name()+" bewegt sich ploetzlich unglaublich schnell.\n",({ME}));
    ActivateSkill(SK_QUICKFIGHT,100,time()+(res/25),1,({ME,"ExpireQuickfight"}));
  }
  return 1;
}

int cmd_fury(string str)
{
  if (QueryActiveSkill(SK_FURY))
    tell_object(ME,
      "Ihr seid schon in Raserei verfallen!\n");
  else
  {
    if (!this_player()->InFight())
    {
      tell_object(ME,"Das koennt Ihr nur im Kampf.\n");
    }
    else
    {
      tell_object(ME,"Ihr verfallt in Raserei.\n");
      ActivateSkill(SK_FURY,SkillCheck(SK_FURY),time()+60+random(30));
    }
  }
  return 1;
}

int cmd_hide(string str)
{
  int res;
  
  if (str && strlen(str) && str!="mich")
  {
    notify_fail("Was moechtet Ihr verstecken?\n");
    return 0;  
  }
  if (QueryActiveSkill(SK_STEALTH))
  {
    notify_fail("Ihr habt Euch doch bereits versteckt.\n");
    return 0;
  }
  
  res = SkillCheck(SK_STEALTH, (int)environment()->QueryProp(P_STEALTH_MOD));
  ActivateSkill(SK_STEALTH, res-CHRT_SUCCESS_THRESHOLD, -1);
  
  switch(res-10+random(21)-CHRT_SUCCESS_THRESHOLD)
  {
    case -1000..CHD_ABSURD:
      tell_object(ME, break_string(
        "Aeusserst geschickt versteckt Ihr Euch und seid Euch sicher, dass "
        "Euch hier niemals jemand finden wird."));
      break;
    case CHD_ABSURD+1..CHD_SHEER_FOLLY:
      tell_object(ME, break_string(
        "Auesserst geschickt versteckt Ihr Euch und seid Euch sicher, dass "
        "Euch hier kaum jemals jemand finden wird."));
      break;
    case CHD_SHEER_FOLLY+1..CHD_EXTREMELY_HARD:
      tell_object(ME, break_string(
        "Geschickt versteckt Ihr Euch und seid Euch sicher, dass Euch hier "
        "kaum jemand finden wird."));
      break;
    case CHD_EXTREMELY_HARD+1..CHD_VERY_HARD:
      tell_object(ME, break_string(
        "Geschickt versteckt Ihr Euch und seid Euch recht sicher, dass Euch "
        "hier niemand finden wird."));
      break;
    case CHD_VERY_HARD+1..CHD_HARD:
      tell_object(ME, break_string(
        "Geschickt versteckt Ihr Euch und schaetzt, dass Euch hier nicht so "
        "leicht jemand finden wird."));
      break;
    case CHD_HARD+1..CHD_MEDIUM:
      tell_object(ME, break_string(
        "Ihr versteckt Euch, doch Euch wird bewusst, dass Euer Versteck "
        "nicht besonders gut ist."));
      break;
    case CHD_MEDIUM+1..CHD_LIGHT:
      tell_object(ME, break_string(
        "Ihr versteckt Euch, doch Ihr denkt, dass man Euch hier recht leicht "
        "finden wird."));
      break;
    case CHD_LIGHT+1..CHD_EASY:
      tell_object(ME, break_string(
        "Ihr versteckt Euch, doch Ihr seid Euch sicher, dass Ihr hier "
        "schnell auffallt."));
      break;
    case CHD_EASY+1..1000:
      tell_object(ME, break_string(
        "Ihr versteckt Euch, doch Ihr seid Euch sicher, dass man Euch hier "
        "sofort entdecken wird."));
      break;
  }
  return 1;
}

static int cmd_raise_skill(string str)
{
  string which, * ind;
  int i,dp;
  
  notify_fail("Was moechtet Ihr erhoehen?\n");
  if (!str || str=="")
    return 0;  
  
  if (str=="alle fertigkeiten automatisch")
  {
    RaiseSkills();
    if (!dp=QueryProp(P_DP))
      write(break_string(
        "Eure Fertigkeiten wurden erhoeht, alle Entwicklungspunkte "
        "wurden verbraucht."));
    else if (dp==1)
      write(break_string(
        "Eure Fertigkeitn wurden erhoeht, Ihr habt noch einen "
        "Entwicklungspunkt uebrig."));
    else
      printf(break_string(
        "Eure Fertigkeiten wurden erhoeht, Ihr habt noch %d "
        "Entwicklungspunkte uebrig."),dp);
    return 1;
  }
  
  if (sscanf(str,"fertigkeit %s",which)!=1)
    return 0;
    
  if (!dp=QueryProp(P_DP))
  {
    write("Ihr habt keine Entwicklungspunkte mehr.\n");
    return 1;
  }
    
  which=lower_case(which);
  
  for (i=sizeof(ind=m_indices(skills));i-->0;)
  {
    if (lower_case(to_string(skills[ind[i],SI_NAME]))==which)
    {
      if (skills[ind[i],SI_LEARNED]==2)
      {
        printf("Die Fertigkeit %s habt Ihr diese Stufe bereits zwei mal "
               "gelernt.\n",skills[ind[i],SI_NAME]);  
        return 1;
      }
      else if (skill_cost(ind[i])>dp)
      {
        printf("Ihr habt nicht mehr genug Entwicklungspunkte, um %s zu "
               "lernen.\n",skills[ind[i],SI_NAME]);  
        return 1;
      }
      else
      {
        SetProp(P_DP,dp-=skill_cost(ind[i]));
        AddSkillRank(ind[i],1);
        printf(break_string(
          "Ihr erhoeht die Fertigkeit %s fuer %d Entwicklungspunkte um "
          "einen Wert auf %d. Damit habt Ihr noch %d Entwicklungspunkte "
          "uebrig."),
          skills[ind[i],SI_NAME],
          skill_cost(ind[i]),
          skills[ind[i],SI_RANKS],
          dp);
        skills[ind[i],SI_LEARNED]++;
        return 1;
      }
    }  
  }
  write("Diese Fertigkeit gibt es nicht.\n");
  return 1;
}

static string *_query_localcmds() {
  return ({
    ({"schnellkampf",   "cmd_quickfight",   0, 0}),
    ({"raserei",        "cmd_fury",         0, 0}),
    ({"entwaffne",      "cmd_disarm",       0, 0}),
    ({"taeusche",       "cmd_feint",        0, 0}),
    ({"taeusch",        "cmd_feint",        0, 0}),
    ({"annaehern",      "cmd_closing",      0, 0}),
    ({"entfernen",      "cmd_closing",      0, 0}),
    ({"kraftakt",       "cmd_use_strength", 0, 0}),
    ({"meditiere",      "cmd_meditate",     0, 0}),
    ({"meditier",       "cmd_meditate",     0, 0}),
    ({"zaubere",        "cmd_cast",         0, 0}),
    ({"zauber",         "cmd_cast",         0, 0}),
    ({"z",              "cmd_cast",         0, 0}),
    ({"erspuere",       "cmd_detect_magic", 0, 0}),
    ({"erspuer",        "cmd_detect_magic", 0, 0}),
    ({"uebertrage",     "cmd_channel",      0, 0}),
    ({"uebertrag",      "cmd_channel",      0, 0}),
    ({"behandle",       "cmd_heal",         0, 0}), // first aid und arzt
    ({"behandel",       "cmd_heal",         0, 0}), // first aid und arzt
    ({"verstecken",     "cmd_hide",         0, 0}),
    ({"verstecke",      "cmd_hide",         0, 0}),
    ({"versteck",       "cmd_hide",         0, 0}),
    ({"stehle",         "cmd_steal",        0, 0}),
    ({"stehl",          "cmd_steal",        0, 0}),
    ({"stiehl",         "cmd_steal",        0, 0}),
  });
}

// Ich sag mal einfach alles ist obsolet

#define LOGFILE "ABILITIES"
#define FAILFILE "AB_VERBS_FAIL"
/*
#pragma strong_types
*/
// Speedup der Skillauswertung. Enthaelt als Keys die Verben, die moeglich
// sind und als Wert den Skill, der damit aufgerufen wird. Wird von
// create_liste() generiert.
static mapping verbliste;

void AddSkillAction() {/*
  mapping myskills;
  mixed index;
  int i;

  if((myskills=ME->QueryProp(P_SKILLS))) {
    index = m_indices(myskills);
    for(i=0; i<sizeof(index); i++) {
      // Ist der Skill nicht angemeldet -> entfernen
      if((SM->Valid(index[i]))<0) 
      {
        ME->GiveAbility(index[i], -2);
        continue;
      }

      // Entwicklungsformat korrigieren! *argl* (2-3 Wochen)
      if(sizeof(myskills[index[i]])>2 && stringp(myskills[index[i]][2]))
        myskills[index[i]]=
          myskills[index[i]][S_PROM..S_TIME]+({({}), ({}), 
          ((sizeof(myskills[index[i]])>3 && pointerp(myskills[index[i]][3]))?
            myskills[index[i]][3]:({})) });
      else

      // Altes Format korrigieren (DO NEVER REMOVE!)
      if(sizeof(myskills[index[i]])<5)
        myskills[index[i]]=
          myskills[index[i]][S_PROM..S_TIME]+({({}),({}), 
          (sizeof(myskills[index[i]])>2?myskills[index[i]][2]:({})) });
    }
  }
  else
    ME->SetProp(P_SKILLS, ([]));

  add_action("_cast_","",1);       // fuer alls Skills/Spells
  create_liste();                  // Verbliste aufbauen
  SetActiveSkill();                // Combat-Skills initialisieren
  ME->SetProp(P_MAX_SKILLS, 1);    // default
  ME->SetProp(P_LAST_SKILL, ({})); // nix
  return;*/
}

void SetActiveSkill() {/*
  int i, k, idx, typ, combat;
  mixed active, armours, ruestung, att_def_skill, att_def_items;
  object *items;
  mapping myskills;
  string *index;

  if(!mappingp(myskills=ME->QueryProp(P_SKILLS)) || !sizeof(myskills)) {
    ME->SetProp(P_SKILLS, ([]));
    ME->SetProp(P_COMBAT_SKILLS, 0);
    ME->SetProp(P_ACTIVE_SKILLS, ({ ([]), ([]) }));
    return;
  }
  
  for(combat=0, i=sizeof(index=m_indices(myskills)); i--;) {
    typ=SM->Valid(index[i]);
    if(typ==SM_ATTACK)
      combat |= 1;              // Attackskill
    if(typ==SM_DEFEND)
      combat |= 2;              // Defendskill
  }
  ME->SetProp(P_COMBAT_SKILLS, combat);

  if(!combat) {
    ME->SetProp(P_ACTIVE_SKILLS, ({ ([]), ([]) }));
    return ;
  }

  att_def_skill = filter_array(m_indices(ME->QueryProp(P_SKILLS)), #'IsCombatSkill);
  att_def_items = map_array(att_def_skill, "QueryProp", SM, P_SM_ITEM);

  active = ({ ([]), ([]) });

  if(combat & 1) {
    while((i=member_array("", att_def_items))>-1) {   // 'itemlose' Attack-Skills
      active[CS_ATTACK] += ([ att_def_skill[i] : ({
        SM->QueryProp(att_def_skill[i], P_SM_STAT),
        SM->QueryProp(att_def_skill[i], P_SM_FACTOR),
        SM->QueryProp(att_def_skill[i], P_SM_MAGIC) }) ]);
      att_def_items[i]=0;
    }
    if(sizeof(items = ME->QueryProp(P_WEAPONS)))
      for(k=sizeof(items);k--;) {                    // Attack-Skills mit Item
        while((i=member_array(items[k]->QueryProp(P_WEAPON_TYPE), att_def_items))>-1) {
          active[CS_ATTACK] += ([ att_def_skill[i] : ({
            SM->QueryProp(att_def_skill[i], P_SM_STAT),
            SM->QueryProp(att_def_skill[i], P_SM_FACTOR), 
            SM->QueryProp(att_def_skill[i], P_SM_MAGIC) }) ]);
          att_def_items[i]=0;
        }
      }
  }
  if(combat & 2) { // Defend-Skills
    ruestung = map_array(armours = ME->QueryProp(P_ARMOURS), #'GetArmourType);
    for(i=sizeof(att_def_skill);i--;)
      if(stringp(att_def_items[i]) &&
        (!strlen(att_def_items[i]) || att_def_items[i]==AT_MISC))
          active[CS_DEFEND] += ([ att_def_skill[i] : ({
            ME->QueryAttribute(SM->QueryProp(att_def_skill[i], P_SM_STAT)),
            SM->QueryProp(att_def_skill[i], P_SM_FACTOR),
            SM->QueryProp(att_def_skill[i], P_SM_MAGIC) }) ]);
      else 
        if((idx=member_array(att_def_items[i], ruestung))>-1)
          active[CS_DEFEND] += ([ att_def_skill[i] : ({ 
            armours[idx]->QueryProp(P_AC),
            SM->QueryProp(att_def_skill[i], P_SM_FACTOR), 
            SM->QueryProp(att_def_skill[i], P_SM_MAGIC) }) ]);
  }

  ME->SetProp(P_ACTIVE_SKILLS, active); */
}

// Hilfsfunc 
static int IsCombatSkill(string SkillName) {/*
  if (SM->QueryProp(SkillName, P_SM_TYPE)>=SM_ATTACK) return 1;
  return 0;*/
}

// Hilfsfunc 
static mixed GetArmourType(object obj) {/*
  return obj->QueryProp(P_ARMOUR_TYPE);*/
}


int GetProbability(string ability) {/*
  mapping my_map;
  if(!mappingp(my_map=ME->QueryProp(P_SKILLS)) || !my_map[ability])
    return -1;
  return my_map[ability][S_PROM];
}

int GiveAbility(string skillname, int wert) {
  mapping myskills;
  string *verbs, *tmp, gid;
  int typ, k, test;
  
  // myskills initialisieren
  if(!(myskills = ME->QueryProp(P_SKILLS)) || !mappingp(myskills))
    myskills = ([]);
  
  if(!mappingp(verbliste))
    verbliste=([]);
   
  if(previous_object()!=this_object())
    gid=previous_object()->QueryProp(P_SKILLS_ID);
  gid=(stringp(gid)?gid:"");

  if(wert>=0) {   // geben oder aendern?
    if((SM->Valid(skillname))<0)
      return -2; // Skill ist nicht angemeldet

    // Living hat den Skill noch nicht
    if(!myskills[skillname]) {
      myskills+=([ skillname: ({wert, 0, ({gid})-({""}), ({}), ({}) }) ]);
      // Verben?
      if(SM->QueryProp(skillname, P_SM_TYPE)<SM_ATTACK)
        verbs=({})+SM->QueryProp(skillname,P_SM_VERBS);
      if(pointerp(verbs) && sizeof(verbs))
        SetSkillVerbs(skillname, verbs);

      log_file(LOGFILE , dtime(time())+" -> " + file_name(ME)+":\n"+
        "    Vergeben : '" + skillname + "'\n"+
        "    Lernwert : " + (string)wert + "\n"+
        (pointerp(verbs)?"    Verben   : " + implode(verbs,", ") +"\n":"")+
        "    PrevObj. : " + file_name(previous_object())+ "\n"+
        "    Giver-ID : " + gid + ".\n");
    }
    else {
      if(strlen(gid) && member_array(gid, (tmp=QuerySkillIDs(skillname)))<0) {
        tmp+=({gid});
        myskills[skillname][S_GIDS]=tmp;
        log_file(LOGFILE, dtime(time())+" -> "+file_name(ME)+":\n"+
          "    Vergeben : '" + skillname +"' -> ID: "+gid+"\n"+
          "    PrevObj. : " + file_name(previous_object()) + ".\n");
      }
      myskills[skillname][S_PROM]=wert;
    }
    ME->SetProp(P_SKILLS, myskills);
    SetActiveSkill();       // Kampfskills neu initialisieren
    create_liste();         // Neue Verbliste erstellen
    return wert;
  }

  // 'hart' wegnehmen?
  if(wert<-1) {
    if(myskills[skillname]) {
      log_file(LOGFILE, dtime(time())+" -> "+file_name(ME)+":\n"+
        "    Entfernt : '" + skillname +"' (hart)\n"+
        "    Lernwert : " + myskills[skillname][S_PROM] +"\n"+
        "    Zeitvar. : " + myskills[skillname][S_TIME] +"\n"+
        "    PrevObj. : " + file_name(previous_object()) + ".\n");
      myskills = m_delete(myskills, skillname);
      ME->SetProp(P_SKILLS, myskills);
      // Kampfskills neu initialisieren
      SetActiveSkill();
      create_liste();       // Neue Verbliste erstellen
      return -1;
    }
    else return -2;
  }
  // sonst 'soft' wegnehmen
  else {
    if(myskills[skillname]) {
      tmp=QuerySkillIDs(skillname)-({gid});
      if(sizeof(tmp)>0) {
        log_file(LOGFILE, dtime(time())+" -> "+file_name(ME)+":\n"+
          "    Entfernt : '" + skillname +"' -> ID: "+gid+"\n"+
          "    PrevObj. : " + file_name(previous_object()) + ".\n");
        myskills[skillname][S_GIDS]=tmp;
        return myskills[skillname][S_PROM];
      }
      log_file(LOGFILE, dtime(time())+" -> "+file_name(ME)+":\n"+
        "    Entfernt : '" + skillname +"' (soft)\n"+
        "    Lernwert : " + myskills[skillname][S_PROM] +"\n"+
        "    Zeitvar. : " + myskills[skillname][S_TIME] +"\n"+
        "    PrevObj. : " + file_name(previous_object()) + ".\n");
      myskills = m_delete(myskills, skillname);
      ME->SetProp(P_SKILLS, myskills);
      // Kampfskills neu initialisieren
      SetActiveSkill();
      create_liste();       // Neue Verbliste erstellen
      return -1;
    }
    else return -2;
  }*/
}

int SetDelayTime(string ability, int del) {/*
  mapping myabil;
  int value;
  if(!(myabil=ME->QueryProp(P_SKILLS))) 
    return 0;
  if(!myabil[ability])
    return 0;
  value=del+time();
  myabil[ability][S_TIME] = value;
  ME->SetProp(P_SKILLS, myabil);
  ME->SetProp(P_LAST_SKILL, ({ ability, time()}));
  return value;
}

int QueryDelay(string ability) {
  mapping myabil;
  if(!mappingp(myabil=ME->QueryProp(P_SKILLS)) || 
     !myabil[ability] ||
     myabil[ability][S_TIME]<time())
    return 0;
  return 1;
}

int _cast_(string argument) {
  string ability, verb;
  mixed arguments;
  mapping my_map;
  int res;

  verb = query_verb();
  if(!mappingp(my_map=ME->QueryProp(P_SKILLS)) || !sizeof(verbliste)) 
    return 0;
  if(!(ability=verbliste[verb]) || sizeof(my_map[ability][S_DIDS]))
    return 0;
  if(argument && strlen(argument)) 
    arguments = efun::explode(argument, " ")-({""});
  else 
    arguments = ({});
  res=call_other(SM, "Execute", ability, ME, arguments);
  if(!res)
    tell_object(ME,"Ups. Da gibt es ein Problem mit '"+ability+"'.\n"
      "Wende Dich bitte an einen Magier!");
  return 1;*/
}


mixed QuerySkillIDs(string ability) {/*
  mapping all;

  if(!stringp(ability) || !(all=ME->QueryProp(P_SKILLS)) || !all[ability])
    return ({});
  return ({})+all[ability][S_GIDS];*/
}

mixed QueryDisablerIDs(string ability) {/*
  mapping all;

  if(!stringp(ability) || !(all=ME->QueryProp(P_SKILLS)) || !all[ability])
    return ({});
  return ({})+all[ability][S_DIDS];*/
}


int DisableAbility(string ability) {/*
  string *tmp, did;
  mapping all;
  if(!stringp(ability) || !(all=ME->QueryProp(P_SKILLS)) || !all[ability])
    return 0;
  did=previous_object()->QueryProp(P_SKILLS_ID);
  did=(stringp(did)?did:DEFAULT_ID);
  tmp=all[ability][S_DIDS]-({did});
  all[ability][S_DIDS]=tmp+({did});
  return 1;*/
}

int EnableAbility(string ability){/*
  string *tmp, did;
  mapping all;
  if(!stringp(ability) || !(all=ME->QueryProp(P_SKILLS)) || !all[ability])
    return 0;
  did=previous_object()->QueryProp(P_SKILLS_ID);
  did=(stringp(did)?did:DEFAULT_ID);
  all[ability][S_DIDS]-=({did});
  return 1;*/
}


int SetSkillVerbs(string skillname, mixed verbs) {/*
  int art, i;
  mapping myskills;
  
  if(!stringp(skillname))
    return 0;
  if(!(myskills=ME->QueryProp(P_SKILLS)))
    return 0;
  if(!myskills[skillname])
    return 0;
  if(!pointerp(verbs) && !stringp(verbs))
    return 0;
  if(stringp(verbs))
    verbs=({verbs});
  verbs=filter_array(verbs, #'stringp)-({""});
  if((art=SM->QueryProp(skillname, P_SM_TYPE))<SM_ATTACK) {
    myskills[skillname][S_VERB]=verbs;
    ME->SetProp(P_SKILLS, myskills);
    create_liste();
    return verbs;
  }
  return 0;*/
}

mixed QuerySkillVerbs(string skillname) {/*
  mapping myskills;
  mixed tmp;
  
  if(!stringp(skillname))
    return 0;
  if(!(myskills=ME->QueryProp(P_SKILLS)))
    return 0;
  if(!(tmp=myskills[skillname]))
    return 0;
  return ({})+tmp[S_VERB];
  if((SM->QueryProp(skillname, P_SM_TYPE))<SM_ATTACK)
    return ({skillname});
  return 0;*/
}

//
// create_liste():
//   Erstellen der Verbliste. Aufgerufen von GiveAbility() und 
//   AddSkillAction()
//   Skills ohne zusaetzliche Verben gehen denen mit Verben vor. d.h.
//   ein Skill 'kratze' ohne zusaetzliche Verben kann mit 'kratze'
//   ausgefuehrt werden. Hat der Spieler noch einen zweiten Skill,
//   der das Verb 'kratze' benutzt, tritt dieses dahinter zurueck. Es
//   kann nicht benutzt werden und wird mitgeloggt (FAILFILE)
//
static void create_liste() {/*
  mapping myskills;
  int i, Art, k, x;
  string *index, *idx;

  verbliste=([]);
  
  if(!(myskills=ME->QueryProp(P_SKILLS)) || 
    !(sizeof(index=m_indices(myskills)))) return;

  // 1. Durchlauf (verblose Skills)
  for(i=sizeof(index);i--;) {
    if((Art=SM->QueryProp(index[i], P_SM_TYPE))<0 || Art>=SM_ATTACK)
        continue;
    if(!pointerp(myskills[index[i]][S_VERB]) || 
      !sizeof(myskills[index[i]][S_VERB]))
	  verbliste+=([ index[i] : index[i] ]);  // Skillname : Skillname
  }
  // 2. Durchlauf (Skills mit Verben)
  for(i=sizeof(index);i--;) {
    if((Art=SM->QueryProp(index[i], P_SM_TYPE))<0 || Art>=SM_ATTACK)
        continue;
    if(pointerp(myskills[index[i]][S_VERB]) &&
      (k=sizeof(idx=myskills[index[i]][S_VERB]))) {
        for(x=0, k; k--; ) {
          if(!member(verbliste, idx[k])) {
            verbliste+=([ idx[k] : index[i] ]);  // Verb : Skillname
            x++;
          }
        }
	if(!x)
          log_file(FAILFILE, dtime(time())[5..16]+" -> "+file_name(ME)+
            ": '"+index[i]+"' verwaist! <living/skills.c>\n");
    }
  }*/
}

