/*******************
** Eldarea MUDLib **
********************
**
** std/mnpc.c - moving npc
**
** CVS DATA
** $Date: 2000/12/04 11:10:33 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: mnpc.c,v $
** Revision 1.2  2000/12/04 11:10:33  elatar
** new default moving messages
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/npc";
inherit "std/npc/sequencer";

#include <moving.h>
#include <defines.h>
#include <properties.h>
#include <mnpc.h>

#pragma strong_types

#define IS_ROOM(ob) function_exists("int_short",ob)

static string creating_room;
static object* last_rooms=({});
static int move_on_init;

int filter_exits(string room,mapping map);
mixed *remove_element(mixed *array,mixed *element);
int equal_array(mixed *first,mixed *second);

void create() {
  object ob;
  ::create();
  seteuid(getuid(this_object()));
  Set(P_MNPC_MASTER,0,F_SET_METHOD);
  Set(P_MNPC_FLAGS,0,F_SET_METHOD);
  Set(P_MNPC_DELAY,0,F_SET_METHOD);
  Set(P_MNPC_ENTER,0,F_SET_METHOD);
  Set(P_MNPC_LEAVE,0,F_SET_METHOD);
  Set(P_MNPC_AREA,0,F_SET_METHOD);
  if (!IS_ROOM((ob=previous_object())))
    creating_room=(string)0;
  else
    creating_room=load_name(ob);
  SetProp(P_MNPC_MASTER,"/secure/callmaster");
  SetProp(P_MNPC,1);
  SetProp(P_MNPC_DELAY,MNPC_DFLT_DELAY);
  SetProp(P_MNPC_HOME,MNPC_DFLT_HOME);
  SetProp(P_MNPC_AREA,({}));
  SetProp(P_MNPC_OLD_ENV,0);
  SetProp(P_MNPC_SPECIAL_EXITS,0);
  SetProp(P_MNPC_LOAD_ROOMS,0);
  SetProp(P_MNPC_LASTREV,time());
  SetProp(P_NAME,"Wesen");
  SetProp(P_PLURAL,"Wesen");
  SetProp(P_GENDER,NEUTER);
  SetProp(P_LONG,"Ein laufendes Wesen");	
  SetProp(P_MMSGIN,"&Name erscheint in einem hellen Leuchten");
  SetProp(P_MMSGOUT,"&Name verschwindet in einem hellen Leuchten");
  SetProp(P_MNPC_SKILL, 6);
  move_on_init=0;
}

void give_notify(object ob) {
  sequencer::give_notify(ob);
}

int remove(int silent) {
  if(clonep() && (QueryProp(P_MNPC_FLAGS) & MNPC_WALK))
    call_other(QueryProp(P_MNPC_MASTER),"check_out",this_object());
  return ::remove(silent);
}

void kill_inventory(int silent) {
  object *inv;
  inv=deep_inventory(this_object());
  map_objects(inv, "remove",1);
  inv-=({0});
  map_array(inv, #'destruct);
}

int valid_room(string room) {
  string *area,s;
  if(QueryProp(P_MNPC_LOAD_ROOMS)) {
    if(file_size(room+".c") < 1) return 0;
    catch(call_other(room, "???"));
  }
  if(!find_object(room))
    return 0;
  if(!sizeof((area=QueryProp(P_MNPC_AREA))))
    return 1;
  for(;sizeof(area);area=area[1..])
    if(sscanf(room,area[0]+"%s",s))
      return 1;
  return 0;
}

string* be_smart(string* exits, mapping p_exits) {
  object env;
  object* rooms,* tmp;
  int i,j,k, smart;
  env=environment();
  smart=QueryProp(P_MNPC_SKILL);
  if(!smart || !env)
    return exits;
  last_rooms-=({env});
  last_rooms+=({env});
  last_rooms=last_rooms[<smart..];
  if(!sizeof(exits) || !sizeof(p_exits))
    return exits;
  rooms=map_array(exits, lambda( ({ 'x, 'y }),
    ({#'find_object, ({#'[<, ({#'efun::explode, 
          ({#'[, 'y, 'x}), "#"}), 1})})), p_exits);
  tmp=filter_array(rooms, lambda(({'x,'y}),
    ({#'>, 0, ({#'member_array, 'x, 'y})})), last_rooms);
  if(!sizeof(tmp)) { // mist, ich kenne schon alle raeume hier...
    k=sizeof(last_rooms);
    for(i=0; i<k; i++)
      if((j=member_array(last_rooms[i], rooms))!=-1)
        return ({exits[j]});
    return exits; // *runzel*
  }
  return map_array(tmp, lambda(({'x,'y,'z}),
    ({#'?, ({#'<, -1, ({#'=, 'i, ({#'member_array, 'x, 'y})})}),
    ({#'[, 'z, 'i}), ""}) ), rooms, exits);
}

void Walk() {
  string *exits,wo;
  object env;
  mapping map;
  mixed prop;
  int tport_method;

  tport_method = QueryProp(P_MNPC_FLAGS) & MNPC_NO_TPORT ? M_GO : M_TPORT ;

  // Kein Environment? -> remove
  if (!(env=environment())) {
      kill_inventory(1);
      remove(1);
      return;
  }

  //Im Kampf -> Weiterlaufen?
  if (InFight() && !(QueryProp(P_MNPC_FLAGS) & MNPC_WALK_FIGHTING))
    return;

  // Kein Spielerkontakt -> anhalten bis erneuter Spielerkontakt
  if ((time()-QueryProp(P_MNPC_LASTREV))>3600) {
    if(load_name(env)!=(wo=(creating_room?creating_room:QueryProp(P_MNPC_HOME)))) {
      move(wo,tport_method);
      SetProp(P_MNPC_OLD_ENV,env);
    }
    move_on_init=(QueryProp(P_MNPC_FLAGS)&MNPC_WALK)&&
      !sizeof(filter_array(all_inventory(environment()), #'interactive));
    // move_on_init ist gesetzt wenn der NPC gehen soll und sich im
    // Heimatraum kein Spieler befindet
    if (move_on_init)
      call_other(QueryProp(P_MNPC_MASTER),"check_out",this_object());
    return;
  }

  // Finden von passierbaren Ausgaengen
  exits=m_indices(filter_mapping(map=env->QueryProp(P_EXITS),
    "filter_exits", this_object(), map));
  exits=be_smart(exits, map);
  if (QueryProp(P_MNPC_SPECIAL_EXITS))
    exits+=m_indices(env->QueryProp(P_SPECIAL_EXITS));
  if (function_exists("MNPCExits",env))
    exits=env->MNPCExits(exits);

  if (prop=QueryProp(P_MNPC_LEAVE)) funcall(prop);

  // Bewegen
  if (((env==QueryProp(P_MNPC_OLD_ENV)) && (env==QueryProp(P_MNPC_OLDER_ENV)))
     || !sizeof(exits)) {
    // Auf der Stelle getreten oder keinen Ausgang gefunden
    if (creating_room || QueryProp(P_MNPC_HOME)==MNPC_DFLT_HOME) {
      env=find_object( creating_room || "" );
      if(env)
        move(env, tport_method);
      else {
	move(MNPC_DFLT_HOME, tport_method);
	remove(1);
      }
    }
    else
      move(QueryProp(P_MNPC_HOME),tport_method);
  }
  else {
      command(exits[random(sizeof(exits))]);
      if (!environment() || !valid_room(load_name(environment())))
	move(QueryProp(P_MNPC_HOME),tport_method);
  }
  SetProp(P_MNPC_OLDER_ENV, QueryProp(P_MNPC_OLD_ENV));
  SetProp(P_MNPC_OLD_ENV, env);

  if (prop=QueryProp(P_MNPC_ENTER)) funcall(prop);
}

int filter_exits(string room,mapping map) {
  return valid_room(efun::explode(map[room],"#")[<1]);
}

int Defend(int dam, mixed dam_type, int spell, object enemy) {
  if(!enemy && !(enemy=QueryEnemy()))
    enemy = this_player();
  if(!enemy)
    return 0;
  if(QueryProp(P_MNPC_FLAGS) & MNPC_INVINCIBLE) {
      tell_object(enemy,
        "Du kannst "+this_object()->name(WER,2)+" nicht angreifen!\n");
      StopHuntFor(enemy,1);
      enemy->StopHuntFor(this_object(),1);
      return 0;
    }
  return ::Defend(dam, dam_type, spell, enemy);	
}

void init() {
  ::init();
  if(interactive(this_player())) {
    SetProp(P_MNPC_LASTREV,time());
    if (move_on_init) {
      if (QueryProp(P_MNPC_FLAGS)&MNPC_WALK) // sicherheitshalber nochmal
        call_other(QueryProp(P_MNPC_MASTER), "check_in",
	  this_object(), QueryProp(P_MNPC_DELAY), "Walk");
      move_on_init=0;
    }
  }
}

void catch_tell(string str) {
  string wer,wohin;
  object who;
  
  sequencer::catch_tell(str);
  if (str && (QueryProp(P_MNPC_FLAGS) & MNPC_FOLLOW_PLAYER))
    if (sscanf(str,"%s geht nach %s.\n",wer,wohin)==2)
      command_me(lower_case(wohin));
  return;
}

string *_set_mnpc_area(string *s) {
  if(!s) return Set(P_MNPC_AREA,({}));
  if(!pointerp(s)) return 0;
  return Set(P_MNPC_AREA,s);
}

string *_query_mnpc_area() {
  string *s;
  if(!(s=Query(P_MNPC_AREA))) return Set(P_MNPC_AREA,({}));
  return s;
}

int _set_mnpc_master(string s) {
  string m;
  if (s[<2..<1]==".c") s=s[0..<3];
  if (file_size(s+".c")<=0)
    return QueryProp(P_MNPC_MASTER);
  if((m=QueryProp(P_MNPC_MASTER)) && stringp(m) && file_size(m+".c")>-1)
    call_other(m,"check_out",this_object());
  if(QueryProp(P_MNPC_FLAGS) & MNPC_WALK)
    call_other(s,"check_in",this_object(),QueryProp(P_MNPC_DELAY),"Walk");
  return Set(P_MNPC_MASTER,s);
}

int _set_mnpc_flags(int i) {
  string m;
  call_other((m=QueryProp(P_MNPC_MASTER)),"check_out",this_object());
  if (i & MNPC_WALK)
    call_other(m,"check_in",this_object(),QueryProp(P_MNPC_DELAY),"Walk");
  return Set(P_MNPC_FLAGS,i & MNPC_ALL_FLAGS);
}

mixed _set_mnpc_delay(mixed i) {
  mixed val;
  
  if(!closurep(i) && !intp(i)) return -1;
  if(closurep(i))
    val = Set(P_MNPC_DELAY,i);
  else
    val=Set(P_MNPC_DELAY,(i<5 ? 5 : i));
  SetProp(P_MNPC_FLAGS,QueryProp(P_MNPC_FLAGS)); // Um neuen Wert wirksam zu machen
  return val;
}

mixed _set_mnpc_enter(mixed fun) {
  if (stringp(fun))
    fun=symbol_function(fun,this_object());
  if(!closurep(fun)) return -1;
  return Set(P_MNPC_ENTER,fun);
}

mixed _set_mnpc_leave(mixed fun) {
  if(stringp(fun))
    fun=symbol_function(fun,this_object());
  if (!closurep(fun)) return -1;
  return Set(P_MNPC_LEAVE,fun);
}
