/*******************
** Eldarea MUDLib **
********************
**
** std/more.c - more files
**
** CVS DATA
** $Date: 2001/03/12 11:05:14 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: more.c,v $
** Revision 1.4  2001/03/12 11:05:14  eldarea
** fixed nasty bug caused by More() without access rights
**
** Revision 1.3  2000/12/12 09:10:50  elatar
** more status line reformatted and extended
**
** Revision 1.2  2000/12/04 11:11:04  elatar
** implemented screensize for /secure/login
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types
#include <properties.h>
#include <ansi.h>
#include <config.h>

static mixed givectrl(int val);
static int showlines(string str);
static int* matchstr(string expr);
varargs mixed More(string str, int fflag, string returnto);

static mixed ctrlto;
static mixed input;
static int startline, fromfile, forcemore;
static int* expr;
static int SCREENSIZE;
static int linenumber;
static string filename;
static int dumbterm;

static mixed givectrl(int val)
{
  expr = 0;
  input = 0;
  if (!ctrlto) return val;
  return closurep(ctrlto) ? funcall(ctrlto) : call_other(this_object(), ctrlto);
}

#define SEARCH_BUF_SIZE 200

static int *matchstr(string expr)
{
  int i, j, k, sz1, sz2;
  int *tmp;
  string *lines, *found, line;

  tmp = ({});

  if (fromfile)
  {
    i = 1;
    while (line = read_file(input, i, SEARCH_BUF_SIZE))
    {
      lines = explode(line, "\n");
      if (sz2 = sizeof(found = regexp(lines, expr)))
      {
        sz1 = sizeof(lines); j = 0;
        for (k = 0; k < sz2; k++)
          for (; j < sz1; j++)
            if (found[k] == lines[j])
            {
              tmp += ({ j+i });
              break;
            }
      }
      i += SEARCH_BUF_SIZE;
    }
  }
  else
  {
    for (i = 0; i < sizeof(input); i++)
      if (sizeof(regexp(({ input[i] }), expr)))
        tmp += ({ i+1 });
  }
  return tmp;
}

static int showlines(string str)
{
  int i, prozent;
  string statuszeile;

  statuszeile = "";
  forcemore = 0;

  write("\n");
  switch(str[0])
  {
    case 'b':
    case 'B':
      if ((startline -= SCREENSIZE) < 1)
        startline = 1;
      break;
    case 'u':
    case 'U':
      if ((startline -= SCREENSIZE / 2) < 1)
        startline = 1;
      break;
    case 'd':
    case 'D':
      startline += SCREENSIZE / 2;
      break;
    case '/':
      expr = matchstr(str[1..]);
      return showlines("n");
    case 'n':
    case 'N':
      if (!pointerp(expr))
      {
        statuszeile = "No previous regular expression";
        break;
      }
      if (!sizeof(expr))
      {
        statuszeile = "No match";
        break;
      }
      i = 0;
      while (i < sizeof(expr) && expr[i] <= startline)  i++;
      if (i == sizeof(expr))
      {
        statuszeile = "Wrapped";
        i = 0;
      }
      startline = expr[i];
      forcemore = 1;
      break;
    case 'q':
    case 'Q':
    case 'x':
    case 'X':
      return givectrl(1);
    default:
      startline += SCREENSIZE;
  }

  if (fromfile)
  {
    if ((cat(input, startline, SCREENSIZE) != SCREENSIZE) && !forcemore)
      return givectrl(1);
  }
  else
  {
    for (i = startline; i < startline + SCREENSIZE; i++)
      if (i <= sizeof(input))
        printf("%s\n", input[i-1]);
      else
        if (!forcemore)
          return givectrl(1);
  }

  if (startline + SCREENSIZE <= linenumber)
  {
    prozent = 100 * (startline + SCREENSIZE - 1) / linenumber;
    printf("%sMore %s%d/%d (%d%%) %s** q,x,d,u,b,/<regexp>,n%s ",
      dumbterm?"** ":ANSI_INVERS,filename?filename+" ":"",
      startline+SCREENSIZE, linenumber, prozent,
      statuszeile!=""?"** "+statuszeile+" ":"",dumbterm?" **":ANSI_NORMAL);
    input_to("showlines");
  }
  else
    return givectrl(1);

  return 1;
}

varargs mixed More(string str, int fflag, mixed returnto)
{
  ctrlto = returnto;
  fromfile = fflag;

  if (file_name(this_object())[0..12]=="/secure/login")
  {
    SCREENSIZE = 20;
    dumbterm = 1;
  }
  else if (this_interactive())
  {
    SCREENSIZE = this_interactive()->QueryProp(P_SCREENSIZE);
    if (this_interactive()->QueryProp(P_TTY) == "dumb")
      dumbterm = 1;
  }
  else
  {
    if (interactive(this_player()))
    {
      SCREENSIZE = this_player()->QueryProp(P_SCREENSIZE);
    if (this_player()->QueryProp(P_TTY) == "dumb")
      dumbterm = 1;
    }
    else
    {
      dumbterm = 1;
      SCREENSIZE = 20;
    }
  }
  
  startline = 1;
  linenumber = 0;

  if (!str || str=="")
    return givectrl(0);

  if (!SCREENSIZE)
  {
    if (fromfile)
    {
      if (!MASTER->valid_read(str,getuid(this_player()),0,0))
      {
        return givectrl(0);
      }
      if (file_size(str) < 0)
        return givectrl(0);
      cat(str, 1, 9999);
      printf("\n");
      return givectrl(1);
    }
    printf("%s\n", str);
    return givectrl(1);
  }

  if (fromfile)
  {
    string tmp;
    int itemp, lines_per_read;

    if (!MASTER->valid_read(str,getuid(this_player()),0,0))
    {
      return givectrl(0);
    }
    filename=str;
    if (file_size(str) < 1)
      return givectrl(0);

    linenumber = 0;
    input = str;
    itemp = 0;

    lines_per_read = 500;

    do
    {
      tmp = read_file(filename, linenumber, lines_per_read);
      itemp = sizeof(efun::explode(tmp, "\n"));
      linenumber += (itemp >= lines_per_read ? lines_per_read : itemp-1);
    }
    while (itemp >= lines_per_read);
  }
  else
  {
    filename = 0;
    input = efun::explode(str, "\n");
    linenumber = sizeof(efun::explode(str, "\n"));
  }

  return showlines("b");
}
