/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: netti.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// STD/NETTI.C --  Ein freundlicher NPC
//
//      Er versucht so gut wie moeglich nett zu den Spielern zu sein, und
//      auch mit ihnen wie ein richtiger Charakter zu interagieren.
//      Rumstehende, dumme NPCs sind mir ein Greul.
//
//      6/95 Fiona
//
// Author: Fiona@Wunderland
//
// $Revision: 1.1.1.1 $
//
// $Log: netti.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.16  1999/05/19 16:41:00  Fiona
// blueprint createt nun auch
//
// Revision 1.15  1999/05/12 21:08:28  Holger
// is_clone() -> clonep() und Kopf veraendert
//
// Revision 1.14  1999/01/15 22:37:32  Holger
// P_PLURAL rausgeschmissen, weil sonst alle Nettis sind
//
// Revision 1.13  1999/01/15 16:16:00  Fiona
// SHORT->PLURAL
//
// Revision 1.12  1998/12/03 13:03:25  Fiona
// Tjaja, wieder mal ein +1 Fehler ;o)
//
// Revision 1.11  1998/12/03 04:07:51  Elric
// vorlaeufiger bugfix ... irgendwas stimmt da noch nich :(
//
// Revision 1.10  1998/12/02 12:08:08  Fiona
// Reaktionen brechen ab, wenn pl- oder vic-Object destructet werden

inherit "std/npc";
inherit "std/player/soul";

#include <properties.h>
#include <netti.h>

#pragma strong_types

static mapping reactions; /* Die gespeicherten Reaktionen */

private static mixed* test_cmd(mixed cmd);
private static mixed* check_action(mixed* action);
static void ReactPlayerSoul(string verb, object pl, object vict, string adverb);
public varargs int DoCommand(string kommando, mixed opfer, string str);
void do_react(string verb, int j, int k, object pl, mixed vic, string adverb);
public void AddReaction(string verb, int modus, mixed action);

void create() {
	npc::create();
	SetProp(P_NAME, "Netti");
	SetProp(P_GENDER, MALE);
	add_soul_commands();
	AddReaction("antworte", R_ME, ({
		1, "sag Ich hab Dich doch gar nichts gefragt &Name.",
		"50%schmunzle" }));
	AddReaction("argl", R_ALL, ({
		1, "sag Och &Name...", 3, "80%knuddel &name aufmunternd",
		"%umarme &name" }));
	AddReaction("betaste", R_ME, "sag Finger weg!");
	AddReaction("danke", R_ME, ({ 1, "frag &name wofuer denn?" }));
	AddReaction("druecke", R_ME, ({
		2, "50%knuddel &name", "30%drueck &name", "%blicke &name fragend" }));
	AddReaction("grinse", R_ME, ({ 1, "grins &name" }));
	AddReaction("grinse", R_NOONE, ({ 3, "5%kicher &name" }));
	AddReaction("verneige", R_ME, "nicke &name");
	AddReaction("knickse", R_ME, "nicke &name");
	AddReaction("kitzle", R_ME, ({
		"50%<emote macht: Huuuuhaaaahiii", 3, "schmunzel" }));
	AddReaction("kuesse", R_ME, ({ 1, "erroete" }));
	AddReaction("kuesse", R_OTHER, ({ 2, "blicke woanders hin" }));
	AddReaction("liebe", R_OTHER, ({ 2, "40%erroete","60%frag Koennt Ihr nicht an einen Stillen Ort gehen?" }));  
	AddReaction("knutsche", R_OTHER, ({ 1, "70%blicke verschaemt zu Boden","30%sag Ich moechte auch knutschen."}));
	AddReaction("knuddle", R_ME, ({ 1, "kicher", 2, "knuddel &name" }));
	AddReaction("kuschle", R_ME, ({ 1, "laechle &name", 2, "knuddel &name" }));
	AddReaction("schmiege", R_ME, ({ 1, "laechle &name", 2, "knuddel &name" }));
	AddReaction("lache", R_ME, ({ 1, "50%laechle &name", "50%lache &name" }));
	AddReaction("lache", R_NOONE|R_OTHER, ({ 2, "kicher" }));
	AddReaction("laechle", R_ME, "grinse &name vergnuegt" );
	AddReaction("nicke", R_ME, ({
		1, "nicke &name bedeutungsvoll", 6, "lache" }));
	AddReaction("schuettle", R_ME, ({
		1, "schuettle &name fest", 1, "sag Hallo &Name!" }));
	AddReaction("trete", R_ME, ({ "runzle boese", 2, "sag Lass das "
		"gefaelligst!", "tritt &name" }));
	AddReaction("trete", R_OTHER, ({ 2, "sag Hmmmm", 1,
		"frag &name Wieso trittst Du denn &Opfer" }));
	AddReaction("strecke", R_ME, ({ 1, "strecke &name zunge raus", 1,
		"emote macht: Blllbllllbll", 5, "grins vergnuegt" }));
	AddReaction("umarme", R_ME, ({ 1, "umarme &name fest", 4,
		"sag Ach &Name, Du bist heute wieder so nett..." }));
	AddReaction("weine", R_ME|R_NOONE, ({ 2, "streichel &name zaertlich",
		2, "umarme &name", 4, "sag Es wird schon alles wieder gut &Name.",
		1, "nicke &name aufbauend" }));
}

public void AddReaction(string verb, int modus, mixed action) {
	mixed* oldcmds;
	int oldallmod;
	if (!mappingp(reactions)) reactions=([]);
	if (!modus) modus=R_ALL;
	if (!action) return;
	if (!stringp(verb)) return;
	action=check_action(action);
	if (!action) raise_error("Fehler in Reaktiondef von \'"+verb+"\'.");
	if (!sizeof(reactions) ||
		!mapping_contains(&oldcmds, &oldallmod, reactions, verb)) {
		reactions+=([ verb: ({ ({ modus, action }) }); modus ]);
		return;
	}
	if (oldallmod&modus)
		raise_error("Ueberschneidung im Modus von Reaktionsdef \'"+verb+"\'.");
	reactions[verb, 0]=oldcmds+({ ({ modus, action }) });
	reactions[verb, 1]=oldallmod|modus;
}

public varargs void RemoveReaction(string verb, int modus) {
	mixed* oldcmds;
	int oldallmod, num, i;
	if (!mappingp(reactions) || !sizeof(reactions)) return;
	if (!modus) modus=R_ALL;
	if (!mapping_contains(&oldcmds, &oldallmod, reactions, verb)) return;
	if (!(oldallmod&modus)) return;
	num=sizeof(oldcmds);
	for (i=0; i<num; i++) {
		if (oldcmds[i][0]&modus) {
			oldcmds[i][0]&=~modus;
			if (!oldcmds[i][0]) {
				oldcmds=oldcmds[0..i-1]+oldcmds[i+1..];
				num--;
			}
		}
	}
	if (!sizeof(oldcmds)) reactions=m_delete(reactions, verb);
	else {
		reactions[verb, 0]=oldcmds;
		reactions[verb, 1]=oldallmod&~modus;
	}
}

private static mixed* check_action(mixed* action) {
	/* pruefen ob action korrekte befehle enthaelt */
	mixed newcmd;
	int pers, num, i;
	if (!pointerp(action)) {
		newcmd=test_cmd(action);
		if (!newcmd) return 0;
		if (newcmd[2]==3) return ({ newcmd[1] });
		return ({ action });
	}
	pers=0;
	num=sizeof(action);
	for (i=0; i<num; i++) {
		newcmd=test_cmd(action[i]);
		if (!newcmd) return 0;
		if (newcmd[0]<=100) pers+=newcmd[0];
		if (pers>100) raise_error("Reaktionsdef mit ueber 100%.");
		if (newcmd[2]) pers=0;
		if (newcmd[2]==3) action[i]=newcmd[1]; // funcall -> closure
	}
	return action;
}

private static mixed* test_cmd(mixed cmd) {
	/* Parse ein Kommando
	   ret==0 -> Fehler
	   ret=({ Prozent, Cmd, Endflag })
	   Endflag: 0-nein 1-prozent-ende 2-commando-ende 3-funcall */
	string str;
	int per, flag;
	if (intp(cmd)) return ({ 0, cmd, 1 });
	if (!stringp(cmd)) {
		if (!closurep(cmd)) return 0;
		else return ({ 0, cmd, 1 });
	}
	if (strlen(cmd)==0) return ({ 0, cmd, 1});
	if (sscanf(cmd, "%d%%%s", per, str)==2) {
		flag=0;
		if (str[0]=='<') flag=1;
		if (str[0]=='|') flag=2;
		if (flag) cmd=str[1..];
		else cmd=str;
		if (sscanf(cmd, "#fun %s", str)==1) {
			if (!function_exists(str))
				raise_error("Funktion fuer Reaktionsdef undefiniert.");
			cmd=symbol_function(str, this_object());
		}
		return ({ per, cmd, flag });
	}
	if (sscanf(cmd, "%%%s", str)==1) {
		flag=1;
		if (str[0]=='|') {
			flag=2;
			cmd=str[1..];
		} else cmd=str;
		if (sscanf(cmd, "#fun %s", str)==1) {
			if (!function_exists(str))
				raise_error("Funktion fuer Reaktionsdef undefiniert.");
			cmd=symbol_function(str, this_object());
		}
		return ({ 101, cmd, flag });
	}
	if (sscanf(cmd, "#fun %s", str)==1) {
		if (!function_exists(str))
			raise_error("Funktion fuer Reaktionsdef undefiniert.");
		return ({ 0, symbol_function(str, this_object()), 3 });
	}
	return ({ 0, cmd, 1 });
}

static mapping _query_reactions() {
	return copy_mapping(reactions);
}

static mapping _set_reactions(mixed x) {
	if (!mappingp(x)) return 0;
	return reactions=copy_mapping(x);
}

void catch_msg(mixed* msg) {
	/* ({ "soul", playerobj, victobj, verb, adverb })
	** victobj==1 fuer 'alle'
	** victobj wird hier -1 gesetzt wenn keins, um von vict-destructet
	** unterscheiden zu koennen */
	int modus, mod, arrnum, num;
	mixed* cmds;
	if (!pointerp(msg) || sizeof(msg)!=5 || msg[0]!="soul" ||
		QueryProp(P_INVIS)) return;
	if (!sizeof(reactions) || !mapping_contains(&cmds, &mod, reactions, msg[3]))
		return;
	if (!msg[2]) modus=R_NOONE;
	else if (msg[2]==this_object() || msg[2]==1) modus=R_ME;
	else modus=R_OTHER;
	if (!modus&mod) return;
	if (!(QueryProp(P_REACT_FLAGS)&RF_INVIS) && msg[1]->QueryProp(P_INVIS))
		return;
	num=sizeof(cmds);
	for (arrnum=0; arrnum<num; arrnum++)
		if (cmds[arrnum][0]&modus) break;
	if (arrnum>=num) return;
	if (msg[2]==0) msg[2]=-1;
	do_react(msg[3], cmds[arrnum][1], 0, msg[1], msg[2], msg[4]);
	/* Uebergebe cmds als Pointer auf Array, spart erneuten Zugriff aufs
	** Mapping. Array wird nicht kopiert (call by reference) */
}

void do_react(string verb, mixed* cmds, int k, object pl, mixed vic, string adverb) {
	mixed newcmd;
	int num, pers;
	string cmd, s1, s2;
	if (pl==0 || vic==0) return; // Abbruch
	if (find_call_out("do_react")>-1 && (QueryProp(P_REACT_FLAGS) & 
		RF_STRAIGHT)) return;
	else while(remove_call_out("do_react")!=-1); // Alle vorherigen Cmd abbr.
	if (environment(pl)!=environment()) return;
	num=sizeof(cmds);
	pers=0;
	for (; k<num; k++) {
		if (intp(cmds[k])) {
			if (cmds[k]<=0) continue; // ignore
			call_out("do_react", cmds[k], verb, cmds, k+1, pl, vic, adverb);
			return;
		}
		newcmd=test_cmd(cmds[k]);
		if (!newcmd) raise_error("Fehler in Reaktiondef von \'"+verb+"\'.");
		if (newcmd[0]) {
			if (!pers) pers=random(100)+1;
		} else pers=0;
		if (pers<=newcmd[0]) { // doit
			if (closurep(newcmd[1])) {
				if (!funcall(newcmd[1], pl, ((intp(vic)&&(vic==-1))?0:vic),
					verb, adverb)) return; // Block
			} else {
				cmd=newcmd[1];
				// mal was effizienteres als implode(explode()) :)
				while (sscanf(cmd, "%s&name%s", s1, s2)==2)
					cmd=s1+getuid(pl)+s2;
				while (sscanf(cmd, "%s&Name%s", s1, s2)==2)
					cmd=s1+pl->name(WER)+s2;
				while (sscanf(cmd, "%s&opfer%s", s1, s2)==2) {
					if (!objectp(vic)) cmd=s1+s2;
					else {
						if (vic->QueryProp(P_NPC)) cmd=s1+
							vic->QueryProp(P_IDS)[<1]+s2;
						else cmd=s1+getuid(vic)+s2;
					}
				}
				while (sscanf(cmd, "%s&Opfer%s", s1, s2)==2)
					if (!objectp(vic)) cmd=s1+s2;
					else cmd=s1+vic->name(WER)+s2;
				while (sscanf(cmd, "%s&adverb%s", s1, s2)==2)
					if (!adverb) cmd=s1+s2;
					else cmd=s1+adverb+s2;
				while (sscanf(cmd, "%s&verb%s", s1, s2)==2)
					cmd=s1+verb+s2;
				command_me(cmd);
			}
			if (newcmd[0] && !newcmd[2]) {
				// Vorspulen bis Ende des Prozentblocks
				while (++k<num) {
					newcmd=test_cmd(cmds[k]);
					if (!newcmd) raise_error("Fehler in Reaktiondef von \'"+verb+"\'.");
					if (newcmd[2]) break;
				}
				if (!newcmd[0]) k--;
				pers=0;
			}
		} else {
			pers-=newcmd[0];
			if (!newcmd[2]) continue;
			pers=0;
			if (newcmd[2]==2) return; // Block
		}
	}
}

// to support old P_REACT_INVIS propertie! Use P_REACT_FLAGS instead!
static int _query_react_invis() {
        if( QueryProp(P_REACT_FLAGS)&RF_INVIS ) return 1;
        return 0;
}

static int _set_react_invis(mixed x) {
        SetProp(P_REACT_FLAGS, QueryProp(P_REACT_FLAGS)|RF_INVIS );
        return 1;
}
