/*******************
** Eldarea MUDLib **
********************
**
** std/npc.c - non player characters
**
** CVS DATA
** $Date: 2000/12/04 11:11:42 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: npc.c,v $
** Revision 1.2  2000/12/04 11:11:42  elatar
** new default moving messages
** skills::heart_beat() activated
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

inherit "std/thing/properties";
inherit "std/living/description";
inherit "std/living/life";
inherit "std/living/attributes";
inherit "std/living/moving";
inherit "std/living/skills";
inherit "std/thing/hooks";

inherit "std/npc/combat";
inherit "std/npc/chat";
inherit "std/npc/comm";
inherit "std/container/restrictions";
inherit "std/thing/commands";
inherit "std/thing/language";
inherit "std/npc/info";
inherit "std/npc/put_and_get";
inherit "std/npc/moneyhandler";
inherit "std/npc/channel";

#include <config.h>
#include <properties.h>
#include <ansi.h>
#include <wizlevels.h>
#include <living.h>
#include <language.h>
#include <attributes.h>
#include <defines.h>
#include <health.h>

ENVCHECKPROC

static int _set_level(int arg);

void create()
{ 
  seteuid(getuid());
  ENVCHECK
  restrictions::create();
  properties::create();
  description::create();
  commands::create();
  attributes::create();
  life::create();
  enable_commands();
  comm::create();
  combat::create();
  info::create();
  put_and_get::add_put_and_get_commands();
  moneyhandler::create();
  skills::create();

  SetProp(P_NAME, "Niemand");
  SetProp(P_PLURAL, "Niemande");
  SetProp(P_MMSGIN, "&Name erscheint in einem hellen Leuchten");
  SetProp(P_MMSGOUT, "&Name verschwindet in einem hellen Leuchten");
  SetProp(P_ALIGN, 0);
  SetProp(P_GENDER, NEUTER );
  SetProp(P_WEIGHT, 75000);
  SetProp(P_MAX_WEIGHT, 50000);
  SetProp(P_RACE, "Npc");
  SetProp(P_MAX_HP, 100);
  SetProp(P_MAX_SP, 100);
  SetProp(P_HP,50);
  SetProp(P_SP,50);
  SetProp(P_ALCOHOL_DELAY, ALCOHOL_DELAY);
  SetProp(P_FOOD_DELAY, FOOD_DELAY);
  SetProp(P_DRINK_DELAY, DRINK_DELAY);
  SetProp(P_HEAL_DELAY, HEAL_DELAY);
  SetProp(P_POISON_DELAY, POISON_DELAY);
  SetProp(P_MAX_FOOD, MAX_FOOD);
  SetProp(P_MAX_DRINK, MAX_DRINK);
  SetProp(P_MAX_ALCOHOL, MAX_ALCOHOL);
  SetProp(P_DRINK, 0);
  SetProp(P_FOOD, 0);
  SetProp(P_ALCOHOL, 0);
  SetProp(P_HANDS, ({ "", 30 }) );
  SetProp(P_MAX_HANDS, 2);
  SetProp(P_UNDEAD, ({UNDEAD_NONE,0}) );
  SetProp(P_NPC, 1);
  AddId("wesen","wesen");
  AddSkillAction();
  set_heart_beat(1);
  heartbeat = 1;
}

void reset(){}

static int _set_level(int arg)
{
  Set(P_LEVEL, arg);
  SetAttr(A_CON, arg);
  SetAttr(A_DEX, arg);
  SetAttr(A_INT, arg);
  SetAttr(A_STR, arg);
}

void create_default_npc(int level)
{ 
  if(level < 1) return;
  SetProp(P_LEVEL, level);
  SetProp(P_MAX_HP, 42 + level*8);
  SetProp(P_MAX_SP, 42 + level*8);
  SetProp(P_HANDS, ({" mit blossen Haenden", level*10 }) );
  SetProp(P_BODY, level*20/3);
  SetProp(P_XP, (level*100)*(42 + level*8) / 2);
} 

void heart_beat()
{
  life::heart_beat();
  if (ME) combat::heart_beat();
  if (ME) chat::heart_beat();
  if (ME) skills::heart_beat();
}

void give_notify(object ob)
{
  put_and_get::give_notify(ob);
}

// Force the monster to do a command.
int command_me(string cmd) { return command(cmd); }

void init()
{
  combat::init();
  info::init();
  commands::init();
}

void catch_tell(string str)
{}
