/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: chat.c,v $
** Revision 1.2  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD MUDlib
//
// /STD/NPC/CHAT.C -- Idle- und Kampfchats der NPCs
//
// $Log: chat.c,v $
// Revision 1.2  2001/01/31 13:42:20  elatar
// process_string() replaced by funcall()
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//

#pragma strong_types

#include <properties.h>
#include <defines.h>

#define NEED_PROTOTYPES

#include <living/combat.h>
#include <thing/properties.h>

void SetChats(mixed chance, string *strs)
{
	if (!pointerp(strs)) return;
	if (!intp(chance) && !closurep(chance)) return;

	SetProp(P_CHAT_CHANCE, chance);
	SetProp(P_CHATS, strs);
}

void SetAttackChats(mixed chance, string *strs)
{
	if (!pointerp(strs)) return;
	if (!intp(chance) && !closurep(chance)) return;

	SetProp(P_ACHAT_CHANCE, chance);
	SetProp(P_ACHATS, strs);
}

private string parse_mess_for_obj(string str)
{
	str = regreplace(str, "&!",          "\\&\\&", 1);
	str = regreplace(str, "!&",          "\\&\\&", 1);
	str = regreplace(str, "&&WER&&",     "Du",     1);
	str = regreplace(str, "&&WESSEN&&",  "Dein",   1);
	str = regreplace(str, "&&WEN&&",     "Dich",   1);
	str = regreplace(str, "&&WEM&&",     "Dir",    1);
	str = regreplace(str, "&&",          "Du",     1);
	str = regreplace(str, "&%WER%&",     "Dein",   1);
	str = regreplace(str, "&%WESSEN%&",  "Deines", 1);
	str = regreplace(str, "&%WEN%&",     "Deinen", 1);
	str = regreplace(str, "&%WEM%&",     "Deinem", 1);
	str = regreplace(str, "&%FWER%&",    "Deine",  1);
	str = regreplace(str, "&%FWESSEN%&", "Deiner", 1);
	str = regreplace(str, "&%FWEN%&",    "Deine",  1);
	str = regreplace(str, "&%FWEM%&",    "Deiner", 1);
	str = regreplace(str, "&%NWER%&",    "Dein",   1);
	str = regreplace(str, "&%NWESSEN%&", "Deines", 1);
	str = regreplace(str, "&%NWEN%&",    "Dein",   1);
	str = regreplace(str, "&%NWEM%&",    "Deinem", 1);
	str = regreplace(str, "&%",          "Dein",   1);

	return capitalize(str);
}

private string* get_strings(string str, object enemy)
{
	mixed result;
	string s0, s1, s2, s3;

	result = ({"", ""});
	str    = funcall(str);

	if (!stringp(str)) return result;

	while (sscanf(str, "%s$(%s,%s)%s", s0, s1, s2, s3) >= 3)
	{
		result[0] += s0 + s1;
		result[1] += s0 + s2;
		str        = s3;
	}

	result[0] = parse_mess_for_obj(result[0] + str);
	result[1] = capitalize(parse_mess(result[1] + str, enemy));

	return result;
}

void DoAttackChat(object enemy)
{
	string *c, *x;
	object *leute;

	if (!ME || !environment() || !enemy) return;

	if (random(100) < funcall(QueryProp(P_ACHAT_CHANCE)))
	{
		c     = QueryProp(P_ACHATS);
		x     = get_strings(funcall(c[random(sizeof(c))]), enemy);
		leute = filter_array(all_inventory(environment()),
				lambda(({'x}), ({#'call_other, 'x, "QueryProp", P_NO_FIGHT_TEXT})));

		if (member(leute, enemy) == -1)
			tell_object(enemy, break_string(x[0]));
		tell_room(environment(), break_string(x[1]),
			leute + ({enemy, ME}));
	}
}

void DoChat()
{
	string *c;

	if (!ME || !environment()) return;

	if (random(100) < funcall(QueryProp(P_CHAT_CHANCE)))
	{
		c = QueryProp(P_CHATS);

		tell_room(environment(ME), break_string(
			funcall(c[random(sizeof(c))])));
	}
}

void heart_beat()
{
	if (InFight())
	{
		if (!ME->QueryProp(P_DISABLE_ATTACK) && sizeof(QueryProp(P_ACHATS)))
			DoAttackChat(ME->QueryEnemy());
	}
	else	if (sizeof(QueryProp(P_CHATS))) DoChat();
}
