/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/02/01 14:29:20 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: combat.c,v $
** Revision 1.2  2001/02/01 14:29:20  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
//
// basierend auf Wunderland Mudlib
//
// STD/NPC/COMBAT.C --- NPC combat-functions
//
// $Revision: 1.2 $
//
// $Log: combat.c,v $
// Revision 1.2  2001/02/01 14:29:20  elatar
// applied strong_types requirements
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/09/01 17:03:38  Largo
// Initial revision
//

inherit "std/living/combat";

#include <combat.h>
#include <language.h>
#include <properties.h>
#include <wizlevels.h>
#include <health.h>
#include <living/skills.h>
#include <npc/skills.h>

#define HB_CHECK 7

static int heartbeat, keep_beating, aggressive, beatcount;
static int max_SP, max_HP, beat_off_num, total_rate;
static mixed invincible;

void create() {
  ::create();
  beatcount = 1;
  heartbeat = 1;
  invincible = 0;
  beat_off_num = 0;
  total_rate = 0;
}

/*
 * AddSpell()
 *   traegt Spells bei NPC ein
 */
int AddSpell(int rate, int damage, string TextForEnemy, 
    string TextForOthers, mixed dam_type, int costs, mixed fun) {
  mixed myspells;

  if(rate<=0 || damage<=0 || !stringp(TextForEnemy) || !stringp(TextForOthers))
    return 0;
  if(!dam_type)
    dam_type=({DT_MAGIC});
  if(!pointerp(dam_type))
    dam_type=({dam_type});
  if(!pointerp(myspells=this_object()->Query(P_SPELLS)))
    myspells=({});
  if (!closurep(fun) && !stringp(fun))
    fun = 0;
  total_rate+=rate;
  myspells+=({ ({ total_rate, damage, TextForEnemy, TextForOthers, 
                  dam_type, costs, fun}) });
  this_object()->Set(P_SPELLS, myspells);
  return 1;
}

// Abfrage, unter welchen Umstaenden ein Player nicht wahrgenommen wird.
// Edited 18.4.96 by Indiana
static int cannot_attack(object player) {
  return
    (!query_once_interactive(player) ||
    (player->QueryProp(P_INVIS) && QueryProp(P_CANNOT_SEE_INVIS)) ||
    (player->QueryProp(P_LEVEL) < aggressive) ||
    (random(50) + QueryProp(P_SENSE) <= player->QueryProp(P_HIDE)) ||
    (IS_LEARNER(player) && (player->QueryProp(P_INVIS) || 
     IS_LEARNING(player))));
}

void heart_beat() 
{
  int r, i, dam;
  string spell_mess;
  object enemy;
  mixed env, tmp;
  mapping spells;

  // Heartbeat Kram
  beatcount--;
  if (!beatcount && !keep_beating) {
    if (!environment()) {
      set_heart_beat(0);
      return;
    }
    // nicht vergiftet und kein Spieler hier -> heartbeat ausschalten
    if(!QueryProp(P_POISON) &&
       !sizeof(filter_array(all_inventory(environment()),
         #'query_once_interactive))) {
      set_heart_beat(0);
      heartbeat = 0;
      beatcount = HB_CHECK;
      beat_off_num = absolute_hb_count();
      return;
    }
  }

  // Living Combat-Beat ausfuehren (echte Combat-Skills etc.)
  ::heart_beat();

  // Den ersten Feind nehmen
  enemy = QueryEnemy();

  // Auto-Attack Kram
  if (aggressive && (!enemy || environment() != environment(enemy)) && !beatcount) {
    env = filter_array(all_inventory(environment()), #'living);
    // wen davon kann man nicht angreifen?
    tmp = filter_array( env, #'cannot_attack );
    beatcount = HB_CHECK;
    if (!sizeof( env-=tmp ))
      return;
    // irgendeinen greifen wir an
    i = random(sizeof(env));
    Kill(env[i]);
  }
  
  // Und wieder Wartezeit setzen
  if(!beatcount)
    beatcount = HB_CHECK;

  // Spells Kram
  spells = Query(P_SPELLS);
  if(!enemy
    || !pointerp(spells)
    || !sizeof(spells)
    || environment(enemy)!=environment()
    || QueryProp(P_DISABLE_ATTACK)
    || random(100) > Query(P_SPELLRATE)
    || (r=random(100)) < environment()->QueryProp(P_NOMAGIC)
    || r < enemy->QueryProp(P_NOMAGIC))
    return;
  r=random(total_rate);
  i=0; while(i<sizeof(spells) && spells[i][0] < r) i++;
  if(spells[i][5]>QueryProp(P_SP)) 
    return;
  tell_object(enemy, spells[i][2]);
  spell_mess=regreplace(spells[i][3],"@WER",enemy->name(WER,1),1);
  spell_mess=regreplace(spell_mess,"@WESSEN",enemy->name(WESSEN,1),1);
  spell_mess=regreplace(spell_mess,"@WEM",enemy->name(WEM,1),1);
  spell_mess=regreplace(spell_mess,"@WEN",enemy->name(WEN,1),1);
  say(spell_mess, ({ enemy, this_object() }) );
  dam = random(spells[i][1]/2) + spells[i][1]/2 + 1;

  if (stringp(spells[i][6]))
    call_out(spells[i][6], 0, enemy, dam, spells[i][4]);

  if (closurep(spells[i][6]))
    funcall(spells[i][6], enemy, dam, spells[i][4]);

  enemy->Defend(dam, spells[i][4], 1, this_object());
  restore_spell_points(-(spells[i][5]));
}

// Hier wird nachgeholt beat_off_num und heartbeat auf
// den neusten Stand zu bringen
int InsertEnemy(object ob) {
  int ret;
  ret=::InsertEnemy(ob); // schaltet HB ein
  if (!heartbeat && ret) {
    beat_off_num = 0;
    heartbeat = 1;
  }
  return ret;
}

void init() 
{
  int hp, sp, alc, beat_diff, nofight;
  if(!heartbeat) {
    beat_diff = absolute_hb_count() - beat_off_num;
    if(beat_off_num && beat_diff) {  // Nicht ausgefuehrtes HEILEN nachholen
      hp = QueryProp(P_HP);
      sp = QueryProp(P_SP);
      alc = QueryProp(P_ALCOHOL);
      hp += beat_diff/HEAL_DELAY + alc/ALCOHOL_DELAY;
      sp += beat_diff/HEAL_DELAY + alc/ALCOHOL_DELAY;
      alc -= beat_diff/ALCOHOL_DELAY;
      SetProp(P_HP, hp);
      SetProp(P_SP, sp);
      SetProp(P_ALCOHOL, alc);
      beat_off_num = absolute_hb_count();
    }
  }
  if(!aggressive || cannot_attack(this_player())) nofight=1;
  if(!heartbeat && (!nofight || interactive(this_player()))) {
    beat_off_num = 0;
    heartbeat = 1;
    set_heart_beat(1);
  }
  if(nofight || EnemyPresent()) return;
  Kill(this_player());
}

int _set_max_hp(int i) 
{
  max_HP=i;
  return SetProp(P_HP,i);
}

int _set_max_sp(int i) 
{
  max_SP=i;
  return SetProp(P_SP,i);
}

int _query_max_sp() 
{
  return max_SP;
}

int _query_max_hp() {
  return max_HP;
}

int _set_hb(int i) 
{
  return (keep_beating=i);
}

int _query_hb() 
{
  return keep_beating;
}

int SetAggressive(int i) 
{
  return (aggressive=i);
}

int _set_aggressive(int i) 
{
  return (aggressive=i);
}

int _query_aggressive() 
{
  return aggressive;
}

mixed _set_invincible(mixed i) 
{
  if(i) SetProp(P_XP, 0);
  invincible = i;
  return invincible;
}

mixed _query_invincible() 
{
  return invincible;
}
