/*******************
** Eldarea MUDLib **
********************
**
** std/npc/comm.c - NPC Communication
**
** CVS DATA
** $Date: 2000/12/04 11:16:12 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: comm.c,v $
** Revision 1.2  2000/12/04 11:16:12  elatar
** header changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <language.h>
#include <defines.h>

inherit "std/living/description";

void create() {
  add_action( "sage", "sag", 1 );
  add_action( "echo", "echo" );
  add_action( "emote", "emote" );
  add_action( "gemote", "gemote" );
}

int echo( string str ) {
  say( str + "\n" );
  return 1;
}

int sage(string str) {
  string adverb, txt, indent;
  if(sscanf(str, "%s:: %s", adverb, txt)!=2) {
    txt = str;
    indent = capitalize(name(WER, 2))+" sagt: ";
  }
  else
    indent = capitalize(name(WER, 2))+" sagt "+adverb+": ";
  say(break_string(txt, 0, indent, BS_FOR_COMM));
  return 1;
}

/* Folgende Verbesserung des normalen Emote ist mit Einverstaendnis
** von freaky@unitopia nach der Hilfeseite dort nachprogrammiert.
** Dabei hab ich es ein bisschen veraendert.
** Vielen Dank an das Unitopia fuer die prima Idee!
** (Der Verweis ans Uni hat hier stehenzubleiben.)
** Fiona
*/
private mixed emote_help(string str) {
  string* parts, *tmp;
  int i, j, k, m, num, fall, gross, me_starts;
  object vic,* vics;
  string* txt;
  if (member(str, '$')==-1) return 0;
  parts = efun::explode(str, "$");
  num = sizeof(parts);
  txt = ({ parts[0] });
  vics = ({ 0 });
  me_starts = 0;
  for (i = 1; i<num; i++) {
    if (parts[i][0] == '(' && (j = member(parts[i], ')'))>=0) {
      // nicht auswerten, wenn in klammer ein $ steht
      tmp=efun::explode(parts[i][1..j-1], ",");
      if (sizeof(tmp) == 2) { // nur auswerten, wenn eindeutig
        if (vic) k = member(vics, vic);
        else k = -1;
        for (m = sizeof(txt); m--;) {
          if (m == k) txt[m] += tmp[1]+parts[i][j+1..];
          else txt[m] += tmp[0]+parts[i][j+1..];
        }
        continue;
      }
    }
    if (strlen(parts[i])>4) { // min Laenge fuer Namenersetzung
      if (parts[i][3] == '(' && (j = member(parts[i][4..], ')')) >= 0) {
        switch (parts[i][0..2]) {
          case "der": fall = WER;    gross = 0; break;
          case "des": fall = WESSEN; gross = 0; break;
          case "dem": fall = WEM;    gross = 0; break;
          case "den": fall = WEN;    gross = 0; break;
          case "Der": fall = WER;    gross = 3; break;
          case "Des": fall = WESSEN; gross = 3; break;
          case "Dem": fall = WEM;    gross = 3; break;
          case "Den": fall = WEN;    gross = 3; break;
          case "deR": fall = WER;    gross = 1; break;
          case "deS": fall = WESSEN; gross = 1; break;
          case "deM": fall = WEM;    gross = 1; break;
          case "deN": fall = WEN;    gross = 1; break;
          default:    fall = -1;
        }
        if (fall > -1) {
          vic = present(parts[i][4..j+3], environment());
          m = sizeof(txt);
          if (living(vic)) {
            // puh, endlich gueltig...
            if (i == 1 && vic == this_object() && parts[0] == "") 
              me_starts=1;
            tmp=({ ({"du","dein","dir","dich"})[fall], vic->name(fall, 2) });
            if (gross&1) tmp[0] = capitalize(tmp[0]);
            if (gross&2) tmp[1] = capitalize(tmp[1]);
            k=member(vics, vic);
            if (k == -1) {
              txt += ({ txt[0]+tmp[0]+parts[i][j+5..] });
              vics += ({ vic });
            }
          } else {
            tmp = ({ 0, capitalize(parts[i][4..j+3]) });
            k = -1;
          }
          for (; m--;) {
            if (m == k) txt[m] += tmp[0]+parts[i][j+5..];
            else txt[m] += tmp[1]+parts[i][j+5..];
          }
          continue;
        }
      }
    }
    for (m = sizeof(txt); m--;) txt[m] += "$"+parts[i];
  }
  return ({ vics, txt, me_starts });
}

varargs int emote(string str, int flag) {
  // flag gesetzt fuer gemote
  string verb, myname;
  mixed* x;
  int i, j;
  object* objs;
  if (str == 0) str = "";
  if (flag) flag=WESSEN;
  if (!str || !strlen(str)) return 0;
  myname = capitalize(call_other(this_object(),"name",flag,2))+" ";
  x = emote_help(str);
  if (x) {
	// pruefen ob durch Beginnen mit $der(myname) Name am Anfang schon steht
	if (x[2]) myname="";
    objs = ({});
    for (i = sizeof(x[0]); --i;) {
      tell_object(x[0][i], break_string(myname+x[1][i]));
      objs += ({x[0][i]});
    }
    tell_room(environment(), break_string(myname+x[1][0]), objs);
    return 1;
  }
  say(break_string(myname+str));
  return 1;
}

int gemote(string str) {
  // gemote ist nur noch Spezialfall von emote(), wozu alles doppelt.
  return emote(str, 1);
}

static string _comm_hook(string txt, int meth) {
  return txt;
}
