/*******************
** Eldarea MUDLib **
********************
**
** std/npc/info.c - npc informations
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: info.c,v $
** Revision 1.3  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.2  2000/12/04 11:16:35  elatar
** header changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#define DEBUG(x) if (find_living("largo")) tell_object(find_living("largo"), x) 
#pragma strong_types

#include <properties.h>
#include <defines.h>
#include <netti.h>
#define NEED_PROTOTYPES
#include <thing/properties.h>

mixed* infos;

void log_info(string wer, string str);

void create() {
  if (function_exists("AddReaction")) {
    ME->RemoveReaction("frage", R_ME);
    ME->AddReaction("frage", R_ME, "#fun _frag");
    infos=({({"\ndefault", ({"zucke", 2, "blicke &name /fragend"}), 0})});
  }
  else infos = ({ ({ "\ndefault", "schaut Dich fragend an.", 0 }) });
}

void init() {
}

/*********** Setzen und Loeschen von Infos ***********/

/*  void AddInfo(string|string* key, string info, string indent)
**  void AddInfo(string regeln, string info, string indent)
**  void AddInfo(string regeln, mixed* actions)
**  Letzte Form funktioniert nur bei Nettis. Das Array actions wird
**  in Konkurrenz zu normalen Nettireaktionen abgearbeitet. Es muss immer
**  ein Array sein, auch wenn es nur ein Element enthaelt.
**  info und indent darf jeweils auch statt String eine Closure sein.
*/
varargs void AddInfo(string regeln, mixed info, string indent) {
  int i;

  if (pointerp(info)) {
	if (!function_exists("do_react"))
      raise_error("AddInfo mit Kommando-Array nur bei Nettis moeglich.");
	indent=0; // Unsinnig bei Kommando-Arrays
  }
  i=member(transpose_array(infos)[0], regeln);
  if (i>=0) infos=infos[0..i-1]+infos[i+1..]; // Alte Antwort loeschen
  infos+=({ ({ regeln, info, indent }) });
}

void RemoveInfo(mixed key) {
  int i;
  if (!pointerp(key)) key=({ key });
  for (; sizeof(key); key=key[1..]) {
    for (i=sizeof(infos); i--;) {
      if (infos[i][0]==key[0]) {
        infos=infos[0..i-1]+infos[i+1..];
        break;
      }
    }
  }
}

mixed* QueryInfos() {
  return infos;
}

static int _set_default_info(mixed info) {
  if (!pointerp(info)) info=({ info, 0 });
  if (!sizeof(info)) return -1;
  if (sizeof(info)<2) info += ({ 0 });
  AddInfo("\ndefault", info[0], info[1]);
  return 1;
}

/*********** Auswerten von gestellten Fragen ***********/

static mixed* get_answer(string str) {
  string *worte, *gruppen, *keys;
  int i, j, k, l, hit, best, besthits, def;
  if (!str || str=="") return 0;
  str=lower_case(str);
  for (i=strlen(str); i--;) // Kommata, Sonderzeichen etc entfernen
    if ((str[i]<'a' || str[i]>'z') && (str[i]<'0' || str[i]>'9')) str[i]=' ';
  worte=explode(str, " ")-({""});
  best=-1; // Beste Antwort
  def=-1;
  for (i=sizeof(infos); i--;) { // Alle Infos durchsuchen
    if (infos[i][0]=="\ndefault") {
      def=i;
      continue;
    }
    gruppen=efun::explode(infos[i][0],"&");
    l=j=sizeof(gruppen);
    hit=0;
    if (j>besthits) { // Info koennte besser sein, als vorher gefundene
      for (; j--;) { // Alle Gruppen des Infos durchgehen
        hit=0;
        keys=efun::explode(gruppen[j],"|");
        for (k=sizeof(keys); k--;) { // Alle Alternativen probieren
          if (member_array(keys[k], worte)!=-1) {
            hit=1;
            break;
          }
        }
        if (!hit) break; // Raushier, und dann ...
      }
    }
    if (!hit) continue; // ... weiter mit naechstem Info
    // Hier sind alle Regeln erfuellt
    besthits=l;
    best=i;
  }
  if (best>=0) return ({ infos[best][1], infos[best][2] });
  // Nichts gefunden
  if (def>=0) { // Default ausgeben
    if (QueryProp(P_LOG_INFO)) log_info(getuid(this_player()), str);
    return ({ infos[def][1], infos[def][2] });
  }
  return 0; // Nichtmal Default gesetzt
}

void _frag(object pl, object vict, string verb, string txt) {
  mixed* antwort;
  antwort=get_answer(txt);
  if (!antwort) return;
  if (pointerp(antwort[0])) // Kommandoarray -> Uebergabe an Netti-Fun
    return ME->do_react(verb, antwort[0], 0, pl, vict, txt);
  if (stringp(antwort[0]) && antwort[0][0]==' ')
    antwort[0]=antwort[0][1..]; // Fuer ganz alte Files
  if (closurep(antwort[0])) antwort[0] = funcall(antwort[0], txt);
  if (closurep(antwort[1])) antwort[1] = funcall(antwort[1], txt);
  if (antwort[1])
    say(break_string(funcall(antwort[0]), 0, capitalize(
      ME->name(WER,2))+" "+funcall(antwort[1])+" ", BS_FOR_COMM));
  else
    say(break_string(capitalize(this_object()->name(WER,2))+" "+
      funcall(antwort[0])));
}

/*********** Log-Info Krams ***********/

int dir_ok(string file) {
  string *s;

  s = explode(file, "/");
  s -= ({ s[sizeof(s)-1] });
  return (file_size("/"+implode(s, "/")) == -2);
}

void log_info(string wer, string str) {
  string file, *s, f;
  mixed info;

  if (!str || str == "") return;
  info = this_object()->QueryProp(P_LOG_INFO);
  if (stringp(info) && ((file = info) != "") && dir_ok(file));
  else {
    s = explode(file_name(this_object()), "/");
    switch (s[0]) {
      case "players": file = "/log/report/" + s[1] + ".rep"; break;
      case "d": if (file_size(f = "/save/"+s[2][0..0]+"/"+s[2]+".o") > -1)
                  file = "/log/report/" + s[2] + ".rep";
                else file = "/log/report/" + s[1] + ".rep";
                break;
      default: file = "/log/report/STD.rep";
    }
  }
  write_log(file, "INFO von " + capitalize(wer) + " am " + ctime(time()) + " in "
    +explode(file_name(this_object()), "#")[0] + ": " + str + "\n");
}

// Nur fuer alte NPCs - simuliert das AddReaction
// wird bei Nettis ueberladen
void catch_msg(mixed* msg) {
  if (!pointerp(msg) || sizeof(msg)!=5 || msg[0]!="soul" ||
    msg[2]!=ME || msg[3]!="frage" || QueryProp(P_INVIS)) return;
  _frag(msg[1], msg[2], msg[3], msg[4]);
}
