/*******************
** Eldarea MUDLib **
********************
**
** /std/npc/moneyhandler - NPC money functions
**
** CVS DATA
** $Date: 2000/12/04 11:16:49 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: moneyhandler.c,v $
** Revision 1.2  2000/12/04 11:16:49  elatar
** header changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#include <properties.h>
#include <moving.h>

void create()
{
  seteuid(getuid(this_object()));
}

int AddCoins(string path, int amount)
{
  object money;

  if (!amount) return 1;
  if (!(money=clone_object(path))) return 1;
  money->SetProp(P_AMOUNT,amount);
  return money->move(this_object(),M_PUT|M_MOVE_ALL);
}

int AddMoney(int amount)
{
  return AddCoins("/obj/money",amount);
}

int CMAddMoney(mixed ob, int amount, int silent)
{
  object cm;
  mixed *cash;
  if(objectp(ob)) cm=ob;
  else
    if(stringp(ob))
    {
      call_other((string)ob,"???");
      if(!(cm=find_object((string)ob))) return 0;
    }
    else
      return 0;
  if(!amount) return 0;
  if(amount>0)
  {
    cm->GiveCoins(cm->ExchangeValue(amount),this_object());
    return 1;
  }
  if(!(cash=cm->PayCash(this_object(),-amount))) return 0;
  cm->DoPurchase(cash,this_object());
  return 1;
}

int QueryCoins(string path)
{
  object money;
  if(path[<2..]==".c") path=path[0..<3];
  money=first_inventory(this_object());
  while (money && explode(file_name(money),"#")[0]!=path)
    money=next_inventory(money);
  if (!money) return 0;
  return money->QueryProp(P_AMOUNT);
}

int QueryMoney()
{
  return QueryCoins("/obj/money");
}

int CMQueryMoney(mixed ob)
{
  object cm;
  if(objectp(ob)) cm=ob;
  else
    if(stringp(ob))
    {
      call_other((string)ob,"???");
      if(!(cm=find_object((string)ob))) return 0;
    }
    else
      return 0;
  return cm->QueryMoney(this_object());
}
