/*******************
** Eldarea MUDLib **
********************
**
** std/player/base - basic player object
**
** CVS DATA
** $Date: 2001/01/24 21:43:33 $
** $Revision: 1.4 $
**
** CVS History
**
** $Log: base.c,v $
** Revision 1.4  2001/01/24 21:43:33  elatar
** moved avatar commands from player/base to shells/avatar
**
** Revision 1.3  2000/12/18 14:23:17  elatar
** mbanish now displays mbanish list
**
** Revision 1.2  2000/12/01 16:14:57  elatar
** implemented new properties
** new level handling and level raising
** development points ans skill raising system implemented
** messages changed
** help format changed
** command_me() restricted and logging enabled
** old attribute handling removed
** new color handling adapted
** player deleting command implemented (ARCH only and a inserting a cause is forced and logged)
** guild handling removed
** mbanish command implemented (LORD only)
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

#pragma strong_types

inherit "/std/player/restrictions";
inherit "/std/living/attributes";
inherit "/std/living/combat";
inherit "/std/living/put_and_get";
inherit "/std/living/skills";
inherit "/std/living/senses";
inherit "/std/thing/properties";
inherit "/std/thing/util";
inherit "/std/thing/language";
inherit "/std/thing/hooks";

inherit "/std/player/description";
inherit "/std/player/settings";
inherit "/std/player/moving";
inherit "/std/player/life";
inherit "/std/player/comm";
inherit "/std/player/viewcmd";
inherit "/std/player/moneyhandler";
inherit "/std/player/command";
inherit "/std/player/quests";
inherit "/std/player/potion";
inherit "/std/player/shadowhandler";
inherit "/std/player/soul";
inherit "/std/player/explore";
inherit "/std/player/connect";
inherit "/std/player/color";
inherit "/std/player/info";
inherit "/std/player/imud3";
inherit "/std/more";
inherit "/mail/nedit";

#include <properties.h>
#include <udp.h>
#include <config.h>
#include <wizlevels.h>
#include <mud.h>
#include <living.h>
#include <attributes.h>
#include <language.h>
#include <units.h>
#include <moving.h>
#include <defines.h>
#include <guilds.h>
#include <guildmaster.h>
#include <homes.h>
#include <service.h>
#include <player/channel.h>
#include <color.h>
#include <userupdate.h>

#define NEED_PROTOTYPES
#include <player/base.h>
#include <player/stat.h>

#include <clock.h>

static string default_home; /* Where to move us if we dont have a home set */
static mixed misc;         // Kann jeder beliebig benutzen. Nach Gebrauch auf 0 setzen!
static object* hb_obs;
static string pray_room;

static int _set_level(int i);
static int _set_guild_level(int i);
static int _query_guild_level(int i);
static int _set_invis(int a);
static mixed SetMaxStats(mixed stats);
int SetPatchLevel(int l);

void create() 
{
  if(QueryProp(P_LEVEL)) 
    return; // darf nur EINMAL gemacht werden

  connect::create();
  command::create(); 
  properties::create();
  description::create();
  attributes::create();
  combat::create();
  life::create();
  comm::create();
  senses::create();
  viewcmd::create();
  quests::create();
  restrictions::create();
  moving::create();
  shadowhandler::create();
  explore::create();
  color::create();
  settings::create();
  imud3::create();
  skills::create();

  Set(P_LEVEL, -1);
  Set(P_LEVEL, #'_set_level, F_SET_METHOD);
  Set(P_LEVEL, SAVE, F_MODE);
  Set(P_LEVEL, SECURED, F_MODE);
  Set(P_GUILD_LEVEL, ([]));
  Set(P_GUILD_LEVEL, #'_set_guild_level, F_SET_METHOD);
  Set(P_GUILD_LEVEL, #'_query_guild_level, F_QUERY_METHOD);
  Set(P_GUILD_LEVEL, SAVE, F_MODE);
  Set(P_GUILD_LEVEL, SECURED, F_MODE);
  Set(P_GHOST, SAVE, F_MODE);
  Set(P_REMOTECMDS, SAVE, F_MODE);
  SetProp(P_WEIGHT_PERCENT,100);
  SetProp(P_ALIGN, 0);
  SetProp(P_GENDER, NEUTER);
  Set(P_GENDER, SAVE, F_MODE);
  SetProp(P_WEIGHT, 75000);
  SetProp(P_SIZE, 175);
  SetProp(P_MAX_HP,50);
  SetProp(P_MAX_SP,50);
  SetProp(P_MAX_POISON,10);
  SetProp(P_DRINK, 0);
  SetProp(P_FOOD, 0);
  SetProp(P_ALCOHOL, 0);
  SetProp(P_MAX_HANDS, 2);
  SetProp(P_COINMASTER,"/obj/coinmaster_WL");
  SetProp(P_SHOW_EXITS, 1);
  SetProp(P_BOUGHT_STATS, ({0,0,0,0,0}));
  Set(P_BOUGHT_STATS, SAVE, F_MODE);
  SetProp(P_LOST_STATS, ({0,0,0,0,0}));
  Set(P_LOST_STATS, SAVE, F_MODE);
  Set(P_NAME, SAVE, F_MODE);
  Set(P_CHARACTER, SAVE, F_MODE);
  Set(P_MARRIED, SAVE, F_MODE);
  Set(P_SHOW_EXITS, SAVE, F_MODE);
  Set(P_WANTS_TO_LEARN, SAVE, F_MODE);
  Set(P_TESTPLAYER, SAVE, F_MODE);
  Set(P_INVIS, SAVE, F_MODE);
  Set(P_START_HOME, SAVE, F_MODE);
  Set(P_CARRIED_VALUE, SAVE, F_MODE);
  Set(P_PROMPT, "> ");
  Set(P_PROMPT, SAVE, F_MODE);
  Set(P_CALLED_FROM_IP, SAVE, F_MODE);
  Set(P_INFORMME,SAVE,F_MODE);
  Set(P_INFORMME,PROTECTED,F_MODE);  
  Set(P_WAITFOR,SAVE,F_MODE);
  Set(P_WAITFOR,PROTECTED,F_MODE);
  Set(P_MAX_STATS, SAVE, F_MODE);
  Set(P_GUILD, SAVE, F_MODE);
  Set(P_COMBAT_SKILLS, SAVE, F_MODE);
  Set(P_ACTIVE_SKILLS, SAVE, F_MODE);  
  Set(P_DEATH, SAVE, F_MODE);
  SetProp(P_ARTICLE,ART_NONE);
  Set(P_NOTIFY_MSG, SAVE, F_MODE);
  Set(P_EYE_COLOR,SAVE,F_MODE);
  Set(P_SKIN_COLOR,SAVE,F_MODE);
  Set(P_HAIR_COLOR,SAVE,F_MODE);
  Set(P_HAIR_DESC,SAVE,F_MODE);
  Set(P_HAIR_LENGTH,SAVE,F_MODE);
  Set(P_HAIR_TEXTURE,SAVE,F_MODE);
  Set(P_SPECIAL_DESC,SAVE,F_MODE);
  Set(P_VOLUME_MULTIPLIER,SAVE,F_MODE);
  Set(P_SPECIFIC_WEIGHT,SAVE,F_MODE);
}

void restored_create() {
  potion::create();
  UpdateAttributes();
  if (!pointerp(QueryProp(P_CHANNELS)))
    SetProp(P_CHANNELS,DEFAULT_CHANNELS);
}

void command_initialize() { command::initialize(); }

varargs int remove(mixed arg) {
  return (int)moving::remove(arg);
}

varargs static void stop_heart_beats(mixed obs) {
  int i;

  if (!obs)
    {
      hb_obs=({});
      obs=deep_inventory(ME);
    }
  for (i=sizeof(obs)-1;i>=0;i--)
    if (pointerp(obs[i]))
      stop_heart_beats(obs[i]);
    else
      if (set_object_heart_beat(obs[i],0))
	hb_obs+=({obs[i]});
}

static void restart_heart_beats() {
  int i;
  
  if (pointerp(hb_obs))
    {
      for (i=sizeof(hb_obs)-1;i>=0;i--)
	set_object_heart_beat(hb_obs[i],1);
      hb_obs=0;
    }
}

void heart_beat() {
//  mixed en;
//  if (IS_LEARNING(ME) && (!(en=QueryEnemies())||!sizeof(en[0]))) {
//    // Magier Spar-Beat
//    comm::heart_beat();
//    return;
//  }
  if (!this_object()) return;
  connect::heart_beat();
  if (!this_object()) return;
  comm::heart_beat();
  life::heart_beat();
  combat::heart_beat();
  skills::heart_beat();
}

/*
** Funktionen zum Stufenanstieg
**
**
*/

varargs int needed_experience(int lvl)
{
  return needed_xp(lvl);  
}

varargs int needed_xp(int lvl)
{
  int xp, i;
  
  if (!lvl)
    lvl=QueryProp(P_LEVEL)+1;
   
  for (i=0;i<lvl;i++)
    xp+=i*5000;  
    
  return xp;
}

static int RaiseLevel(string str)
{
  int newlvl,i,dp;
  string * raisedattr;
  
  if (cmd_raise_skill(str))
    return 1;
    
  notify_fail("Was moechtet Ihr erhoehen?\n");
  if (str!="stufe" && str!="level")
    return 0;  
    
  if (QueryProp(P_XP)<needed_xp())
  {
    printf("Euch fehlen noch %d Erfahrungspunkte fuer die naechste Stufe.\n"
           ,needed_xp()-QueryProp(P_XP));
    return 1;
  }
  if (dp=QueryProp(P_DP)>3)
  {
    printf(break_string(
      "Ihr duerft nicht mehr als 3 Entwicklungspunkte haben, wenn Ihr die "
      "Stufe erhoehen wollt."));
    return 1;
  }
  
  SetProp(P_DP,dp+=DP_PER_LEVEL);
  SetProp(P_LEVEL,newlvl=QueryProp(P_LEVEL)+1);
  
  raisedattr=({});
  walk_mapping(skills,
    lambda(({'s,'a,'b,'c,'d,'e,'f,'g,'h})
      ,({#'=,'h,0})));
  switch(newlvl)
  {
    case  2..25:
      raisedattr+=({ATTR_DESC[ME->RaiseAtt()]});
    case 26..55:
      raisedattr+=({ATTR_DESC[ME->RaiseAtt()]});
    case 56..80:
      raisedattr+=({ATTR_DESC[ME->RaiseAtt()]});
    case 81..110:
      raisedattr+=({ATTR_DESC[ME->RaiseAtt()]});
      break;
    case 111..130:
      if (!(newlvl)%2)
        raisedattr+=({ATTR_DESC[ME->RaiseAtt()]});
      break;
    default:
      if (!(newlvl)%3)
        raisedattr+=({ATTR_DESC[ME->RaiseAtt()]});
      break;
  }  
  printf(
    "Ihr habt Stufe %d erreicht!\n"
    "Folgende%s Attribut%s ha%s sich um einen Punkt erhoeht:\n"
    "%s.\n"
    "Ihr habt jetzt %d Entwicklungspunkte, mit denen Ihr Fertigkeiten "
    "lernen\n"
    "koennt.\n"
    "%s"
    ,newlvl
    ,sizeof(raisedattr)==1?"s":""
    ,sizeof(raisedattr)==1?"":"e"
    ,sizeof(raisedattr)==1?"t":"ben"
    ,list_words(raisedattr)
    ,dp
    ,needed_xp()-QueryProp(P_XP)>0?sprintf(
      "Fuer die naechste Stufe braucht Ihr %d Erfahrungspunkte.\n"
      "Davon fehlen Euch noch %d.\n"
      ,needed_xp(),needed_xp()-QueryProp(P_XP)):
      "Ihr schon genug Erfahrungspunkte fuer die naechste Stufe\n");
    
  return 1;
}

/*
 *-----------------------------------------------------------------
 * Rueckmeldungen von Spielern an Magier
 *-----------------------------------------------------------------
 */

static int bug(string str) {
  object ob;
  if (!str || str == "")
    {
      write("Wie sieht der Fehler denn aus?\n"
        "** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine Hilfeseite\n" );
      nedit("smart_log", 0, "BUG");
      return 1;
    }
  if (strstr(str," ",0)==-1) {
    if (!(ob=present(str)) && !(ob=present(str, environment()))) {
      write("Es gibt hier kein "+capitalize(str)+".\n");
      return 1;
    }
    write("Was fuer einen Fehler habt Ihr denn an "+ob->name(WEM,1)+
	  " entdeckt?\n** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine "
	  "Hilfeseite\n" );
    nedit("smart_log", 0, ({ "BUG", ob }));
    return 1;
  }
  smart_log(str,"BUG");
  return 1;
}

static int typo(string str) {
  object ob;
  if (!str || str == "")
    {
      write( "Wo steckt denn der Schreibfehler?\n"
        "** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine Hilfeseite\n" );
      nedit("smart_log", 0, "TYPO");
      return 1;
    }
  if (strstr(str," ",0)==-1) {
    if (!(ob=present(str)) && !(ob=present(str, environment()))) {
      write("Es gibt hier kein "+capitalize(str)+".\n");
      return 1;
    }
    write("Was fuer einen Schreibfehler habt Ihr denn an "+ob->name(WEM,1)+
	  " entdeckt?\n** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine "
	  "Hilfeseite\n" );
    nedit("smart_log", 0, ({ "TYPO", ob }));
    return 1;
  }
  smart_log(str, "TYPO" );
  return 1;
}

static int idea(string str) {
  object ob;
  if (!str || str == "") {
      write( "Was fuer eine Idee habt Ihr denn?\n"
        "** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine Hilfeseite\n" );
      nedit("smart_log", 0, "IDEE");
      return 1;
  }
  if (strstr(str," ",0)==-1) {
    if (!(ob=present(str)) && !(ob=present(str, environment()))) {
      write("Es gibt hier kein "+capitalize(str)+".\n");
      return 1;
    }
    write("Was fuer eine Idee habt Ihr denn fuer "+ob->name(WEN,1)+"?\n"
      "** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine Hilfeseite\n" );
    nedit("smart_log", 0, ({ "IDEE", ob }) );
    return 1;
  }
  smart_log(str, "IDEE" );
  return 1;
}

// str  - der Text, den der Spieler eingegeben hat
// args - entweder ein String ("BUG", "TYPO", "IDEE")
//        oder ein Array aus dem String und einem Objectpointer
static void smart_log(string str, mixed args) {
    string creat, date, filext, *parts, magname, special, myname, *tmp;
    mixed quest;
    int wegen, i;
    object env;
    
    if (!str || str == "") {
      write("Aktion abgebrochen...\n");
      return;
    }
    
    if(pointerp(args) && sizeof(args)) {
        if(stringp(args[0]))
          myname=args[0];
        if(sizeof(args)>1 && objectp(args[1]))
          env=args[1];
    }
    else {
      if(stringp(args) && strlen(args))
        myname=args;
      else
        myname="BUG";
    }

    write("Vielen Dank fuer die Hilfe.\n");
    
    date = dtime(time())[5..16]+" ("+(UHR->IsNight()?"Nacht":"Tag")+")";
    if(!env) 
        env=environment(this_interactive());
    else 
        wegen=1;
    if(env) 
        creat = file_name(env);
    else 
        creat = "";
    // Repfile-Umleitungen?
    parts = efun::explode(creat,"/")-({""," "});
    if(sizeof(parts)) {
        for(i=sizeof(parts),special=to_string(0);i--;) { // .report file?
            creat="/"+implode(parts[0..i],"/")+"/.report";
            special=read_file(creat, 0, 1);
            if(stringp(special)) {
                special=regreplace(special,"\n","",1);
                special=regreplace(special," ","",1);
                if(strlen(special)) break;
            }
        }
        if(stringp(special) && strlen(special)) {
            creat="report/"+special+".rep";
            magname=special;
        }
        else {
            for(i=sizeof(parts),special=to_string(0);i--;) { // .quest file?
                creat="/"+implode(parts[0..i],"/")+"/.quest";
                special=read_file(creat, 0, 1);
                if(stringp(special)) {
                    special=regreplace(special,"\n","",1);
                    if(strlen(special)) break;
                }
            }
            if(stringp(special) && strlen(special) && 
              (quest=QM->QueryQuest(special)) &&
              sizeof(quest)>=8 && (magname=quest[7])) {
                creat = "report/quests/"+magname;
                if(!sizeof(get_dir("/log/"+creat)))
                    if (!mkdir("/log/"+creat)) 
                    {  
                        write("Es ist ein Fehler beim Anlegen eines Verzeichnisses "
                            "aufgetreten.\nSagt bitte einem Avatar Bescheid.\n");
                        log_file("MUDLIB.ERROR",
                          sprintf("[%s] #%s\n",ctime()[4..<1],"24002"));
                        return;
                    }
                creat = creat+"/"+parts[i]+".rep";
            }
        }
        if(!stringp(special) || !strlen(special)) creat="";
    }
    else creat="";

    if(creat=="") {
        creat = MASTER->creator_file(env);
        if(creat == ROOTID)
            creat = "ROOT";
        else if( !creat || creat[0]==' ' )
            creat="STD";
        if(sizeof(tmp=explode(creat ,":"))>=2)
            creat=tmp[1];
        switch(myname) {
            case "DETAIL":
                filext = ".det";
                break;
            default:
                filext = ".rep";
                break;
        }
        magname=creat;
        creat = "report/" + creat + filext;
    }
    if (str[<1]!='\n') str+="\n";
    if (wegen) log_file(creat, sprintf("%s von %s wegen %O am %s:\n"
        "  Aufenthalt: %O\n", myname, capitalize(getuid(this_interactive())),
	env, date, environment())+sprintf("  %=-76s", str));
    else log_file(creat, sprintf("%s von %s in %O am %s:\n",
        myname, capitalize(getuid(this_interactive())), env, date)+
	sprintf("  %=-76s", str));
    write("Meldung abgesandt an "+capitalize(magname)+".\n");
    return;
}

// do not use! use: 'info::_score()'
static int score(string arg) {
  return ME->_score();
}

static int help(string str)
{
  string verb, rest, text;
  mixed found;
  
  found=0;
  text = "";
  if (str)
  {
    str = implode( explode(str, ".." ), "");
    if ( sscanf( str, "%s %s",verb,rest )==2 ) str = verb;
    
    if ( IS_LEARNER(this_player()) )
    {
      if (text=read_file("/doc/help_w/" + str))
        More(sprintf(
             "+--- Hilfe: %'-':62-s---+"
             "\n\n"
             "%s"
             "\n"
             "+---------------------------------------------------- Eldarea Magierhilfe ---+"
             "\n"
             ,str+" ",text));
    }    
    if (!text)
    {
      if (text=read_file("/doc/help_p/" + str))
        More(sprintf(
             "+--- Hilfe: %'-':62-s---+"
             "\n\n"
             "%s"
             "\n"
             "+--------------------------------------------------- Eldarea Spielerhilfe ---+"
             "\n"
             ,str+" ",text));
    }      
    if (!text)
    {
      // hier sollten die aliases ausgewertet werden
    }
    if (!text)
      write("Dazu ist keine Hilfe verfuegbar.\n");
      
    return 1;
  }
  if (IS_LEARNER(this_player()))
    text = "+--- Eldarea Magierhilfe ----------------------------------------------------+"
           "\n\n"
           +read_file("/doc/magier_hilfe")+
           "\n";

  More(text + 
       "+--- Eldarea Hilfeseiten ----------------------------------------------------+"
       "\n\n"
       + read_file("/doc/spieler_hilfe") +
       "\n"
       "+--- Themen -----------------------------------------------------------------+"
       "\n", 0);
  return 1;
}

static int kill(string str)
{
  object eob;
  int i;
  
  if (QueryProp(P_GHOST))
    {
      write("Das koennt Ihr in diesem immateriellen Zustand nicht.\n");
      return 1;
    }
  if (QueryGuest())
    {
      write("Ihr seid doch nur Gast hier.\n");
      return 1;
    }
  if (!str || str == "")
    {
      write("Wen wollt Ihr toeten?\n");
      return 1;
    }
  eob = present(lower_case(str),environment(this_player()));
  if (!eob || !living(eob)) {
      if (str=="alle") {
	  object *lvs;
	  lvs=filter_array(all_inventory(environment(this_player())),
			   lambda(({'x}),({#'?,
			     ({#'query_once_interactive, 'x}), ({#'return, 0}),
			     ({#'living, 'x}), ({#'return, 1}),
			     ({#'return, 0})})));
	  if (i=sizeof(lvs))
	    {
	      for (i--;i>=0;i--)
		Kill(lvs[i]);
	      return 1;
	    }
	}
      write("Ihr seht kein solches Wesen hier.\n");
      return 1;
    }
  if (eob == this_player()) {
      write("Ihr koennt Euch nicht selbst toeten.\n");
      return 1;
    }
  /* Kill him */
  if (query_once_interactive(eob) && !(IS_LEARNER(ME) && IS_LEARNER(eob))) {
    did_pk(ME, eob);
    return 1;
  }
  Kill(eob);
  return 1;
}

static int stop(string str)
{
  if (!str)
    {
      StopHuntingMode();
      write("Ok.\n");
      return 1;
    }
  if (!StopHuntFor(str)) write("So jemanden verfolgt Ihr nicht.\n");
  return 1;
}

nomask mixed query_real_name()
{
  /* ACHTUNG !! DIESE LFUN DARF NICHT ENTFERNT WERDEN !!! */
  /* Sie wird vom Gamedriver (zB bei F_ED) aufgerufen !! */
  return getuid();
}

static int toggle_whimpy(string str)
{
  int i;

  if(!str || str=="" || (sscanf(str,"%d",i)<0))
    {
      write("vorsicht <hp>, 0<=hp<"+QueryProp(P_MAX_HP)+"\n");
      return 1;
    }
  if(SetProp(P_WIMPY, i) >= ME->QueryProp(P_MAX_HP))
    {
      write("Der Wert ist nicht erlaubt.\n");
      return 1;
    }
  write("Vorsichts-Modus ("+i+")\n");
  return 1;
}

static int where(object ob) 
{
  string ipname;
  ipname = query_ip_name(ob);
  return (int)(country(lower_case(ipname)));
}

nomask int query_prevent_shadow(object obj)
{
  string what;
  int    dummy;
  
  if (obj)
    {
      what=file_name(obj);
      if (what && what != "" && 
	  sscanf(what,"/std/player/shadows/%s#%d",what,dummy)==2)
	return 0;
    }
  return 1;
}

/*
 * Force the player to do a command.
 *
 */

int command_me(string cmd)
{
  if ( IS_LEARNER(this_object()) )
  {
    if (!this_interactive() || !previous_object())
	    return 0;
    if ( geteuid(this_object())!=geteuid(this_interactive())
	    || geteuid(this_object())!=geteuid(previous_object()) )
	  {
	    if(query_wiz_level(this_object())<
	       query_wiz_level(previous_object()) )
	      tell_object(this_object(),
			    previous_object()->Name()+" zwingt Euch zu: "
			    + cmd + ".\n");
	    else
	    {
	      tell_object(this_object(),previous_object()->Name() 
			  + " versucht, Euch zu " + cmd + " zu zwingen.\n" );
	      return 0;
	    }
	  }
  }
  else if ( previous_object() 
         && this_interactive() 
         && IS_WIZARD(this_interactive())
         && this_interactive() != this_object() )
  {
	      tell_object(this_object(),
			    this_interactive()->Name()+" zwingt Euch zu: "
			    + cmd + ".\n");
  }
  return command(cmd);
}

string SetDefaultHome(string str) {
  return default_home=str;
}

string QueryDefaultHome() {
  return default_home;
}

string SetPrayRoom(string str) {
  pray_room=str;
}

string QueryPrayRoom() {
  if (pray_room) return pray_room;
  else return default_home;
}

void _restart_beat()
{
  tell_object(ME, 
	      "GAMEDRIVER: Herzschlag ein.\n");
  log_file("MUDLIB.ERROR",
    sprintf("[%s] #%s\n",ctime()[4..<1],"24001"));
  set_heart_beat(1);
}

int QueryGuest()
{
  string dummy;
  return sscanf(getuid(),"gast%d",dummy);
}

string charstr(string char, int wid)
{
  string ret;
  if(!char || !stringp(char) || !strlen(char)) return "";
  for(ret="";wid>0;wid--) ret += char[0..0];
  return ret;
}

int more(string str) 
{
  if(!str) 
    {
      notify_fail("Usage: more <file>\n");
      return 0;
    }
  if (file_size(str) <= 0)
    {
      notify_fail(str+": No such file\n");
      return 0;
    }
  More(str, 1);
  return 1;
}

static int inform(string str)
{
  switch (str)
    {
    case "on":
    case "ein":
    case "an":
      if (Query(P_INFORMME))
	write("Das hattet Ihr schon so eingestellt.\n");
      else
	{
	  write("Kuenftig werdet Ihr informiert, wenn jemand "+
		MUDNAME" verlaesst/betritt.\n");
	  Set(P_INFORMME,1);
	}
      return 1;
    case "aus":
    case "off":
      if (!Query(P_INFORMME))
	write("Das hattet Ihr schon so eingestellt.\n");
      else
	{
	  write("Ok.\n");
	  Set(P_INFORMME,0);
	}
      return 1;
    case 0:
      write("Inform-Mode ist "+(Query(P_INFORMME)?"an":"aus")+"geschaltet.\n");
      return 1;
    }
  write("Syntax: inform an/inform aus.\n");
  return 1;
}

void delayed_write(mixed *what)
{
  if (!pointerp(what)||!sizeof(what)||!pointerp(what[0]))
    return;
  efun::tell_object(this_object(),what[0][0]);
  if (sizeof(what)>1&&sizeof(what[0])>1)
    call_out("delayed_write",what[0][1],what[1..]);
}

varargs void notify_player_change(string who, int rein, string adverb) {
  string *list;

  list=Query(P_WAITFOR);
  if (!pointerp(list)) list=0;
  if (!stringp(adverb)) adverb="";
  else adverb+=" ";
  if (list && member(list, lower_case(who))!=-1) {
    delayed_write( ({ ({colorize(
      sprintf("%c%s   I S T   J E T Z T   %sD A !!!\n",7,
      who,(rein?"":"N I C H T   M E H R   ")),CG_AWAIT),0})
    }));
    return;
  }
  if (Query(P_INFORMME)) { // Wenn der Kobold aktiv ist, Ausgabe durch ihn...
    switch(rein)
    {
      case 1:
        if (QueryProp(P_BUFFER)&1 && (query_editing(ME) ||
          query_input_pending(ME))) {
          if (!enterer) enterer=({ ({ who }), ({}) });
          else {
            enterer[0]+=({ who });
            enterer[1]-=({ who });
          }
        } else tell_object(this_object(), colorize(
          who+" hat gerade "+adverb+MUDNAME" betreten.\n", CG_INFORM));
        break;
      default:
        if (QueryProp(P_BUFFER)&1 && (query_editing(ME) ||
          query_input_pending(ME))) {
          if (!enterer) enterer=({ ({}), ({who}) });
          else {
            enterer[0]-=({ who });
            enterer[1]+=({ who });
          }
        } else tell_object(this_object(), colorize((rein == 2) ?
          (who+" hat sich gerade "+adverb+"selbst geloescht.\n") :
          (who+" hat gerade "+adverb+MUDNAME" verlassen.\n"),CG_INFORM));
    }
  }
}

static int erwarte(string str) {
  int i, j;
  string *list, *parts, text;

  list = QueryProp(P_WAITFOR);

  if (!pointerp(list))
    list = ({});

  if (str) {
    str = lower_case(str);
    parts = regexplode(str, "[ ,:;.-]");

    for (j=sizeof(parts),i=0;i<j;i+=2)
      if (parts[i]!="und" && parts[i]!="" && parts[i]!=" ") { 
        if(member(list,parts[i])!=-1) {
          list -= ({ parts[i] });
          printf("%s aus der Liste entfernt.\n",capitalize(parts[i]));
        } else {
          if (sizeof(list) > 500) {
            printf("Ihr koennt niemanden mehr erwarten. Es sind nur 500 Eintraege zulaessig.\n");
            return 1;
          }
          if (strlen(parts[i])>20) {
            printf("%s ist zu lang fuer einen Spielernamen.\n", parts[i]);
            continue;
          }
          list += ({ parts[i] });
          printf("%s an die Liste angehaengt.\n",capitalize(parts[i]));
        }
      }
    Set(P_WAITFOR, list);
    }
    if (!(j=sizeof(list)))
      text = "Ihr erwartet jetzt niemanden mehr.";
    else {
      list = sort_array(list, #'>);
      text = capitalize(list[0]);
      if (j>1) {
        for (i=1;i<j-1;i++)
          text += ", "+capitalize(list[i]);
        text += " und "+capitalize(list[j-1]);
      }
      text = sprintf("Ihr erwartet jetzt %s.",text);
    }
    write(break_string(text));
    return 1;
}


int markiere(string str)
{
  int i, j, anz;
  string text, beschr, was;
  object obj, *objekte;

  if (str)
  {
    if (str=="alles")
      objekte = deep_inventory(ME);
    else if (sscanf(str,"alle %s",was)==1 ||
             sscanf(str,"allen %s",was)==1 ||
             sscanf(str,"alles %s",was)==1)
    {
      if (!sizeof(objekte = filter_objects(all_inventory(ME), "id", was)))
        objekte = filter_objects(all_inventory(ME), "id", was[0..<2]);
    }
    else if ((obj=present(str,ME)))
      objekte = ({obj});
    else
    {
      notify_fail("So etwas habt Ihr doch gar nicht bei Euch.\n");
      return 0;
    }

    for (j=sizeof(objekte),i=0;i<j;i++)
    {
     if((objekte[i]->short() || objekte[i]->QueryProp(P_PLURAL)) && 
        !objekte[i]->QueryProp(P_INVIS)) {
      if (objekte[i]->QueryProp(P_NODROP)) {
        if (!objekte[i]->IsMoney() && objekte[i]->name()) {
          write(break_string(capitalize(objekte[i]->name(WER,1))+(objekte[i]->QueryProp(P_AMOUNT)>1?" sind":" ist")+
                           " unverkaeuflich, Ihr braucht "+
                           objekte[i]->QueryPronoun(WEN)+" nicht zu markieren."));
        }
      }
      else {
       if (!objekte[i]->IsMoney()) {
        if (objekte[i]->QueryProp(P_UNSELLABLE)==geteuid(ME))
        {
           write(break_string(sprintf("In Ordnung, %s ist nun wieder verkaeuflich.\n",objekte[i]->name(WER,2))));
           objekte[i]->SetProp(P_UNSELLABLE,0);
        }
        else
        {
          write(break_string(sprintf("In Ordnung, %s ist nun unverkaeuflich.\n",objekte[i]->name(WER,2))));
          objekte[i]->SetProp(P_UNSELLABLE,geteuid(ME));
        }
       }
      }
     }
    }
    return 1;
  }

  objekte = all_inventory(ME);

  if (!sizeof(objekte))
  {
    write("Ihr habt nichts markiert.\n");
    return 1;
  }

  text  = "Ihr habt folgende Gegenstaende markiert:\n";
  text += "----------------------------------------\n";
  
  anz = 0;

  for (j=sizeof(objekte),i=0;i<j;i++)
    if (objekte[i]->QueryProp(P_UNSELLABLE)==geteuid(ME))
    {
      if (beschr=objekte[i]->short())
        text += beschr; 
      else if (beschr=objekte[i]->name())
        text += beschr + "\n";
      else
        text += "Nichts besonderes.\n";

      anz++;
    }

  if (!anz)
  {
    write("Ihr habt nichts markiert.\n");
    return 1;
  }

  text += "---------------------------------------\n";

  More(text);
  return 1;
}

int metzeltext(string arg) {
  int i;
  if (!arg) i=!(QueryProp(P_NO_FIGHT_TEXT)%2); // toggle
  else {
    i=member(({"an","aus","kurz","ein"}), lower_case(arg));
    if (i==3) i=0;
  }
  if (QueryProp(P_NO_FIGHT_TEXT)==i) {
    write("Der Metzeltext ist doch schon "+arg+".\n");
    return 1;
  }
  switch (i) {
    case -1:
      write("'"+arg+"' ist kein gueltiges Argument. (hilfe metzeltext)\n");
      return 1;
    case  0:
      write("Ihr seht jetzt wieder den vollen Metzeltext.\n");
      break;
    case  1:
      write("Ihr blendet den Metzeltext aus.\n");
      break;
    case  2:
      write("Ihr seht jetzt den kurzen Metzeltext.\n");
      break;
  }
  SetProp(P_NO_FIGHT_TEXT, i);
  return 1;
}

int fehlermeldung(string arg)
{
  string text;

  text = QueryProp(P_NOTIFY_MSG);

  if (!stringp(arg) && !strlen(arg))
  {
    write(break_string(sprintf(
      "Eure aktuelle Fehlermeldung lautet: \"%s\"",
      strlen(text) ? text : "Wie bitte?")));
    return 1;
  }

  SetProp(P_NOTIFY_MSG, arg);

  write(break_string(sprintf(
    "Eure aktuelle Fehlermeldung lautet nun: \"%s\"", arg)));
  return 1;
}

int SetPatchLevel(int l)
{
  if (load_name(previous_object())!=USERUPDATE)
    return -1;
  return SetProp(P_PATCHLEVEL, l);
}

// **** lokale Propertie Methoden ****

static int _set_level(int i) 
{
  if (!intp(i)) 
    return -1;
  return Set(P_LEVEL, i);
}

static int _set_invis(int a) {
  if (!intp(a)) a=!QueryProp(P_INVIS);
  if (a && !QueryProp(P_INVIS)) SetProp(P_NETDEAD_TIME, time());
  return Set(P_INVIS, a);
}

static string *_query_localcmds() {
  return ({
           ({"erhoehe",       "RaiseLevel",     0,  0         }),
           ({"toete",         "kill",           0,  0         }),
           ({"hilfe",         "help",           1,  0         }),
           ({"idee",          "idea",           0,  0         }),
           ({"typo",          "typo",           0,  0         }),
           ({"bug",           "bug",            0,  0         }),
           ({"fehler",        "bug",            0,  0         }),
           ({"vorsicht",      "toggle_whimpy",  0,  0         }),
           ({"stop",          "stop",           0,  0         }),
           ({"inform",        "inform",         0,  0         }),
           ({"erwarte",       "erwarte",        0,  0         }),
           ({"markiere",      "markiere",       0,  0         }),
           ({"metzeltext",    "metzeltext",     0,  0         }),
           ({"fehlermeldung", "fehlermeldung",  1,  0         })
         })+
         command::_query_localcmds()+
         viewcmd::_query_localcmds()+
         color::_query_localcmds()+
         connect::_query_localcmds()+
         info::_query_localcmds()+
         settings::_query_localcmds()+
         comm::_query_localcmds()+
         skills::_query_localcmds()+
         imud3::_query_localcmds();
}


