/*******************
** Eldarea MUDLib **
********************
**
** channel.c - player channel client
**
** CVS DATA
** $Date: 2001/08/21 10:25:23 $
** $Revision: 1.5 $
**
** CVS History
**
** $Log: channel.c,v $
** Revision 1.5  2001/08/21 10:25:23  eldarea
** preliminary changes to channel handling (invite only channels, non-functional)
** removed double define NEED_PROTOTYPES
**
** Revision 1.4  2000/12/01 16:15:59  elatar
** channel message format changed
**
** Revision 1.3  1999/11/19 10:37:21  elatar
** some adaptions to new channeld
**
** Revision 1.2  1999/11/18 11:48:03  elatar
** New due to VOICEMASTER adaption
**
**
*/

#pragma strong_types

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),"DEBUG "+x) 

#include <wizlevels.h>
#include <defines.h>
#include <properties.h>
#include "/std/sys_debug.h"

#define NEED_PROTOTYPES
#include <thing/properties.h>
#include <daemon.h>
#include "/sys/player/channel.h"

#define CHANNELCMDS      "[#@%$&()<>a-zA-Z0-9\\-]"

private static mapping shortcut;
private static int c_status;

void create()
{
  Set(P_CHANNELS, SAVE, F_MODE);
  Set(P_CHANNELS, DEFAULT_CHANNELS);
  Set(P_SWAP_CHANNELS, SAVE, F_MODE);
  Set(P_STD_CHANNEL, "Allgemein");
  Set(P_STD_CHANNEL, SAVE, F_MODE);
  Set(P_CHANNEL_SHORT, SAVE, F_MODE);
}

int check(string ch, object pl, string cmd, string txt, string * invited)
{
  // non-invite-channel    
  if(!pointerp(invited))   
    return 1;

  // invite-channel only for invited users
  if(-1 == member(invited, getuid(pl))) 
    return 0;

  return 1;
}

static string *_query_localcmds()
{
  return ({({"-","ChannelParser", 1, 0}),
           ({"ebene", "ChannelAdmin", 0, 0}),
           ({"ebenen", "ChannelAdmin", 1, 0}),
         });
}

mixed RegisterChannels()
{
  mixed err;
  int invis;

  if(extern_call() &&  
     previous_object() != find_object(VOICEMASTER)) return;
  c_status = 0;
  call_other(VOICEMASTER, "???");
  if (!mappingp(shortcut = Query(P_CHANNEL_SHORT)))
    shortcut = Set(P_CHANNEL_SHORT, DEFAULT_SHORTCUTS);
  SetProp(P_CHANNELS, map_array(QueryProp(P_CHANNELS), #'lower_case/*'*/));
  err = filter_array(QueryProp(P_CHANNELS),
         symbol_function("join", find_object(VOICEMASTER)),
         this_object());
  if(QueryProp(P_LEVEL) < 5) return err;
  while(sizeof(err)) {
    VOICEMASTER->new(err[0], this_object());
    err[0..0] = ({});
  }
/*
  VOICEMASTER->send("<MasteR>", this_object(), sprintf(
                    "%s%s%s auf %s angemeldet.",
                    (invis = QueryProp(P_INVIS)) ? "(" : "",
                    capitalize(getuid(this_object())), invis ? ")" : "",
                    (string) "/std/player/soul"->CountUp(
                      map_array(sort_array(QueryProp(P_CHANNELS), #'>),
                                #'capitalize))));
*/
  return err;
}

mixed RemoveChannels()
{
  mixed err;
  int invis;

  if(extern_call() &&
     previous_object() != find_object(VOICEMASTER)) return;
  if(!c_status) c_status = 1;
  else return ({});
  call_other(VOICEMASTER, "???");
  err = filter_array(QueryProp(P_CHANNELS),
         symbol_function("leave", find_object(VOICEMASTER)),
         this_object());
  SetProp(P_CHANNELS, QueryProp(P_CHANNELS) - err);
/*
  VOICEMASTER->send("<MasteR>", this_object(), sprintf(
                    "%s%s%s von %s entfernt.",
                    (invis = QueryProp(P_INVIS)) ? "(" : "",
                    capitalize(getuid(this_object())), invis ? ")" : "",
                    (string) "/std/player/soul"->CountUp(
                      map_array(sort_array(QueryProp(P_CHANNELS), #'>),
                                #'capitalize))));
*/
  return err;
}

varargs private string getName(mixed x, int fall)
{
  mixed o; string n;
  o = closurep(x) ? query_closure_object(x) : x;
  if(stringp(o) && x = find_object(o)) o = x;
  if(objectp(o))
  {
    if(file_name(o) == VOICEMASTER) return "<MasteR>";
    if(o->QueryProp(P_INVIS) && IS_LEARNER(this_object()))
      return "("+capitalize(getuid(o))+")";
    if(o->QueryProp(P_FROG))
      return "Frosch "+capitalize(getuid(o));
    return capitalize(o->name(fall)||"<Unbekannt>");
  }
  else
    if(stringp(o) && strlen(o))
      if(o[0] == '/')
      {
        int p;
        return ((p = strstr((string)o, "$")) != -1
                ? query_wiz_level(this_object()) > 1
                  ? ((string)o)[1..p-1] : ((string)o)[p+1..]
                  : (string)o);
      }
      else
        return (fall == WESSEN ? ((string)o)+"s" : (string)o);
  return "<Unbekannt>";
}

mixed ChannelMessage(mixed msg, int nonint)
{
  string m, n, ind;
  mixed * channel;

  if(previous_object() != find_object(VOICEMASTER));
    // no cheating?
  n = getName(msg[1], msg[3] == MSG_GEMOTE ? WESSEN : WER);
  switch(msg[3])
  {
  case MSG_EMPTY:
    m = msg[2]+"\n";
    break;
  case MSG_GEMOTE:
  case MSG_EMOTE:
    m = break_string(sprintf("[%s:%s %s]", msg[0], n, msg[2]), 0, strlen(msg[0])+2);
    break;
  case MSG_SAY:
  default:
    m = break_string(sprintf("[%s:%s] %s ", msg[0], n, msg[2]), 0, strlen(msg[0]+n)+4);
    break;
  }
  if(nonint) return m;
  this_object()->Message(m, "ebenen");
  
  if ( msg[3]!=MSG_SAY
    || !channel = VOICEMASTER->list(this_object())[lower_case(msg[0])]
    || !channel[I_INVITED]
    || channel[I_MASTER]!=this_object())
    return;

  if (sscanf(msg[2],"invite %s",n) == 1)
    VOICEMASTER->invite(lower_case(msg[0]), this_object(), msg[1], n);
  if (sscanf(msg[2],"uninvite %s",n) == 1)
    VOICEMASTER->uninvite(lower_case(msg[0]), this_object() ,msg[1] ,n);

  return 1;  
}

private void createList(string n, mixed a, mixed m, mixed l)
{
  int pos; string sh;
  if((pos = member(map_array(m_values(shortcut), #'lower_case/*'*/), n)) != -1)
    sh = m_indices(shortcut)[pos];
  else sh = "";
  l += ({ sprintf("%-12.12'.'s %c[%-1.1s] %|12.12' 's (%-|3' 'd) %-42.42s\n",
                  a[I_NAME], (member(m, n) != -1 ? '*' : ' '), sh,
                  a[I_MASTER] ?
                  getName(a[I_MASTER]) : getName(a[I_ACCESS]),
                  sizeof(a[I_MEMBER]),
                  intp(query_closure_object(a[I_INFO]))
                  ? (stringp(a[I_INFO]) ? a[I_INFO] : "- Keine Beschreibung -")
                  : funcall(a[I_INFO]) || "- Keine Beschreibung -") });
}

private string getChannel(string ch)
{
  mixed ff;
  if(!strlen(ch)) ch = QueryProp(P_STD_CHANNEL);
  if(shortcut && shortcut[ch]) ch = shortcut[ch];
  return VOICEMASTER->find(ch, this_object());
}

int ChannelParser(string args)
{
  mixed ch, cmd, tmp, hist, _list;
  int pos, type, err, errj, amount, c;
  string txt, n;
  object o;
  mapping l;

  _list = ({});
  cmd = query_verb();
  notify_fail("Benutzung: -<Ebene>[ ]['|:|;]<Text>\n"
              "           -<Ebene>[+|-|?|!|*]\n"
              "           -?\n");
  if(!cmd && !args) return 0;
  if(!args) args = "";
  cmd = cmd[1..];

  if(sizeof(cmd = regexplode(cmd,
                             "^" CHANNELCMDS "*"
                             "([+-]|\\!|\\?|\\*)*")) > 1)
  {
    if(strlen(cmd[1]) > 1 &&
       strstr("+-?!*", cmd[1][<1..<1]) > -1)
      tmp = cmd[1][0..<2];
    else
      tmp = cmd[1];
    if(cmd[1] != "?" && cmd[1] != "!")
      if(pointerp(ch = getChannel(tmp)))
      {
        notify_fail("Diese Angabe war nicht eindeutig. "
                    "Folgende Ebenen passen:\n"
                    +implode(ch, ", ")+"\n");
        return 0;
      }
      else if(!ch) return notify_fail("Die Ebene '"+tmp
                                       +"' gibt es nicht.\n");
    switch(cmd[1][<1])
    {
    case '+':
      switch(VOICEMASTER->join(ch, this_object()))
      {
      case E_ACCESS_DENIED:
        return notify_fail("Ihr duerft die Ebene '"+ch+"' nicht betreten.\n");
      case E_ALREADY_JOINED:
        return notify_fail("Ihr habt diese Ebene schon betreten.\n");
      default: break;
      }
      write("Ihr betretet die Ebene '"+ch+"'.\n");
      if(member(QueryProp(P_CHANNELS), ch = lower_case(ch)) == -1)
        SetProp(P_CHANNELS, QueryProp(P_CHANNELS) + ({ ch }));
      return 1;
    case '-':
      switch(VOICEMASTER->leave(ch, this_object()))
      {
      case E_ACCESS_DENIED:
        write("Ihr koennt die Ebene '"+ch+"' nicht verlassen.\n");
        break;
      case E_NOT_MEMBER:
        write("Ihr habt diese Ebene noch gar nicht betreten.\n");
        break;
      default:
        write("Ihr verlasst die Ebene '"+ch+"'.\n");
        SetProp(P_CHANNELS, QueryProp(P_CHANNELS) - ({ lower_case(ch), ch }));
        break;
      }
      return 1;
    case '!':
    case '?':
    {
      if(mappingp(l = VOICEMASTER->list(this_object())))
        if(stringp(ch) && strlen(ch) && pointerp(l[ch = lower_case(ch)]))
        {
          write(l[ch][I_NAME]+", "+funcall(l[ch][I_INFO])+".\n");
          write("Ihr sehst "+((c = sizeof(l[ch][I_MEMBER])) > 0
                              ? (c == 1 ? "ein Gesicht" : c+" Gesichter")
                              : "niemanden")+" auf der Ebene '"
                                +l[ch][I_NAME]+"':\n");
          write(break_string(implode(sort_array(map_array(l[ch][I_MEMBER],
                                                         #'getName/*'*/, WER),
                                                #'>/*'*/),
                                     ", ")));
          write((l[ch][I_MASTER] ?
                 getName(l[ch][I_MASTER]) : getName(l[ch][I_ACCESS], WER))
                +" hat das Sagen auf dieser Ebene.\n");
        }
        else
        {
          if(cmd[1][<1] == '!')
            l -= mkmapping(m_indices(l) - QueryProp(P_CHANNELS));
          walk_mapping(l, #'createList/*'*/, QueryProp(P_CHANNELS), &_list);
          _list = sort_array(_list, #'>/*'*/);
          txt = sprintf("%-12.12' 's  [A] %|12' 's (%-3' 's) %-42.42s\n",
                        "Name", "Eigner", "Sp", "Beschreibung")
              + "-------------------------------------------------------"
              + "-----------------------\n"
              + implode(_list, "");
          this_object()->More(txt);
        }
      return 1;
    }
    case '*':
    {
      if(!(hist = VOICEMASTER->history(ch, this_object())) || !sizeof(hist))
      {
        write("Es ist keine Geschichte fuer '"+ch+"' verfuegbar.\n");
        return 1;
      }
      if(sizeof(cmd) > 2) amount = to_int(cmd[2]);
      if (!amount || (amount > sizeof(hist))) amount = sizeof(hist);
      txt = sprintf("Folgendes ist auf '%s' passiert: (%d von %d Meldung%s)\n",
                    ch, amount, sizeof(hist), sizeof(hist) != 1 ? "en" : "")
          + implode(map_array(hist[<amount..], #'ChannelMessage/*'*/, 1), "");
      this_object()->More(txt);
      return 1;
    }
    default:
      break;
    }
  }
  if(strlen(cmd = implode(cmd[2..], "")))
     args = cmd + (strlen(args) ? " " : "") + args;

  if(!strlen(args)) return 0;

  switch(args[0])
  {
  case ':' :
    type = MSG_EMOTE;
    args = args[1..];
    break;
  case ';' :
    type = MSG_GEMOTE;
    args = args[1..];
    break;
  case '\'':
    args = args[1..];
  default  : type = MSG_SAY; break;
  }
  if(!ch || !strlen(ch)) ch = QueryProp(P_STD_CHANNEL);

  if((err = VOICEMASTER->send(ch, this_object(), args, type)) < 0)
    if(!(errj = VOICEMASTER->join(ch, this_object())))
    {
      if(member(QueryProp(P_CHANNELS), ch = lower_case(ch)) == -1)
        SetProp(P_CHANNELS, QueryProp(P_CHANNELS) + ({ ch }));
      err = VOICEMASTER->send(ch, this_object(), args, type);
    }

  switch(err || errj)
  {
  case E_ACCESS_DENIED:
    return notify_fail("Auf der Ebene '"+ch+"' duerft Ihr nichts sagen.\n");
  case E_NOT_MEMBER:
    return notify_fail("Ihr habt die Ebene '"+ch+"' nicht betreten.\n");
  }
  return 1;
}

int ChannelAdmin(string args)
{
  string n, descr, sh, cn;
  mixed pa, x, tmp;
  mapping sc;

  notify_fail("Benutzung: ebene <Abkuerzung>=<Ebene>\n"
              "           ebene <Abkuerzung>=\n"
              "           ebene abkuerzungen [standard]\n"
              "           ebene standard <Ebene>\n"
              "           ebene an|aus\n"
              +(this_object()->QueryProp(P_LEVEL) >= 5 ?
                "           ebene neu <Name> <Bezeichnung>\n"
    "           ebene beschreibung <Name> <Beschreibung>\n" : "")
        +(IS_ARCH(this_object()) ?
          "           ebene kill <Name>\n" : ""));
  if(!args || !strlen(args)) return 0;
  if(sscanf(args, "kill %s", n) && IS_ARCH(this_object()))
  {
    if(!(cn = VOICEMASTER->find(n, this_object()))) cn = n;
    switch(VOICEMASTER->remove(cn, this_object()))
    {
    case E_ACCESS_DENIED:
     return notify_fail("Die Ebene '"+cn+"' liess sich nicht entfernen.\n");
    }
    write("Ihr entfernt die Ebene '"+cn+"'.\n");
    return 1;
  }
  if(sscanf(args, "neu %s %s", n, descr) == 2)
  {
    if(this_object()->QueryProp(P_LEVEL) < 5)
      return notify_fail("Neue Ebenen zu erstellen ist Euch verwehrt.\n");
    if(!sizeof(regexp(({ n }), "^" CHANNELCMDS CHANNELCMDS "*")))
      return notify_fail("Der Name '"+n+"' ist nicht konform.\n");
    switch(x = VOICEMASTER->new(n, this_object(), descr))
    {
    case E_ACCESS_DENIED:
      notify_fail("Diese Ebene duerft Ihr nicht erschaffen.\n"); break;
    default:
      write("Ihr erschafft die Ebene '"+n+"'.\n");
      SetProp(P_CHANNELS, QueryProp(P_CHANNELS) + ({ lower_case(n) }));
      return 1;
    }
  }
  if(sscanf(args, "beschreibung %s %s", n, descr) == 2)
  {
    mixed ch;
    cn = VOICEMASTER->find(n, this_object());
    if(!cn || pointerp(cn))
      return notify_fail("Die Ebene '"+n+"' existiert nicht oder die Angabe "
        "war nicht eindeutig.\n");
    ch = VOICEMASTER->list(this_object());
    if(ch[lower_case(cn)][I_MASTER] != this_object())
      return notify_fail("Ihr seid nicht berechtigt die Beschreibung der Ebene"
        " '"+cn+"' zu aendern.\n");
    ch[lower_case(cn)][I_INFO] = descr;
    write("Die Ebene '"+cn+"' hat ab sofort die Beschreibung:\n"+descr+"\n");
    return 1;
  }
  if(sscanf(args, "%s=%s", sh, n) == 2 && strlen(n))
  {
    if(pointerp(tmp = VOICEMASTER->find(n, this_object())) || !tmp)
      return notify_fail("Benutzung: ebene <Abkuerzung>=<Ebene>\n"
                          +(pointerp(tmp) ? implode(tmp, ", ") + "\n" :
                            "Ebene '"+n+"' nicht gefunden.\n"));
    if (strlen(tmp)>3)
      return notify_fail("Benutzung: ebene <Abkuerzung>=<Ebene>\n"
                         "Abkuerzungen duerfen nicht laenger als 3 "
                         "Buchstaben sein.\n");
    sc = QueryProp(P_CHANNEL_SHORT);
    if(!sc) sc = ([]);
    sc[sh] = tmp;
    SetProp(P_CHANNEL_SHORT, sc);
    shortcut = QueryProp(P_CHANNEL_SHORT);
    write("'"+sh+"' wird jetzt als Abkuerzung fuer '"+tmp+"' anerkannt.\n");
    return 1;
  }
  if(sscanf(args, "%s=", sh))
  {
    SetProp(P_CHANNEL_SHORT, m_delete(QueryProp(P_CHANNEL_SHORT) || ([]), sh));
    shortcut = QueryProp(P_CHANNEL_SHORT);
    write("Ihr loescht die Abkuerzung '"+sh+"'.\n");
    return 1;
  }
  if(args == "an")
  {
    mixed excl;
    if(pointerp(QueryProp(P_SWAP_CHANNELS)))
      SetProp(P_CHANNELS, QueryProp(P_SWAP_CHANNELS));
    else
      SetProp(P_CHANNELS, m_indices(VOICEMASTER->list(this_object())));
    excl = RegisterChannels();
    write("Ihr schaltet folgende Ebenen ein:\n"
          +break_string(implode(QueryProp(P_CHANNELS) - excl, ", ")));
    SetProp(P_SWAP_CHANNELS, 0);
    return 1;
  }
  if(args == "aus")
  {
    SetProp(P_SWAP_CHANNELS, QueryProp(P_CHANNELS));
    RemoveChannels();
    SetProp(P_CHANNELS, ({}));
    write("Ihr stellt die Ebenen ab.\n");
    return 1;
  }
  pa = explode(args, " ");
  if(!strstr("abkuerzungen", pa[0]))
  {
    string txt; txt = "";
    if(sizeof(pa) > 1 && !strstr("standard", pa[1]))
    {
      write("Die Standard Abkuerzungen werden gesetzt.\n");
      SetProp(P_CHANNEL_SHORT, DEFAULT_SHORTCUTS);
    }
    walk_mapping(QueryProp(P_CHANNEL_SHORT),
                 lambda(({'i/*'*/, 'c, 'r}),
                        ({#'+=, 'r/*'*/,
                          ({#'sprintf/*'*/, "%5.5s = %s\n", 'i, 'c})})),
                 &txt);
    txt = sprintf("Folgende Abkuerzungen sind definiert:\n%-78#s\n",
                  implode(sort_array(explode(txt, "\n"), #'>/*'*/), "\n"));
    this_object()->More(txt);
    return 1;
  }
  if(!strstr("standard", pa[0]))
    if(sizeof(pa) < 2)
      return notify_fail("Benutzung: ebene standard <Ebene>\n"
                          +(QueryProp(P_STD_CHANNEL)
                            ? "Momentan ist '"+QueryProp(P_STD_CHANNEL)
                            +"' eingestellt.\n"
                            : "Es ist keine Standardebene eingestellt.\n"));
    else
      if(pointerp(tmp = VOICEMASTER->find(pa[1], this_object())))
        return notify_fail("Das war keine eindeutige Angabe. "
                            "Folgende Ebenen passen:\n"
                            +break_string(implode(tmp, ", ")));
      else
        if(!tmp) return notify_fail("Ebene '"+pa[1]+"' nicht gefunden.\n");
        else
        {
          write("'"+tmp+"' ist jetzt die Standardebene.\n");
          SetProp(P_STD_CHANNEL, tmp);
          return 1;
        }
}
