/*******************
** Eldarea MUDLib **
********************
**
** std/player/color.c - Farbunterstuetzung
**
** CVS DATA
** $Date: 2000/12/01 16:15:39 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: color.c,v $
** Revision 1.2  2000/12/01 16:15:39  elatar
** color handling nearly completely rewritten
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#define NEED_PROTOTYPES
#include <ansi.h>
#include <properties.h>
#include <wizlevels.h>
#include <thing/properties.h>
#pragma strong_types

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

varargs string in_color(string cmd, string str);
varargs private string convert(string str, int flag);

mapping init_colors(int flag)
{
  mapping ret;

  ret = ([ "teile-mit":10, "ausgaenge":11, "inform":9, "erwarte":1, "ebenen":12,
           "kalender-ueberschriften":15, "kalender-heute":10, "kalender-tage":16,
           "geburtstagsmeldung":15, "kalender-sonntage":15,
           "finger":15, "illusion": 11, "lebewesen": 11,
           "info-text":15, "info-ok":10, "info-warn":11, "info-gefahr":9,
           "skat-trumpf":9, "skat-zugeben":12,
  ]);

  if (IS_LEARNER(this_player()))  //Magier bekommen mehr
  ret += ([ "pfade": 8 , "details": 16 ]);
  if (flag)
  ret += ([ "farbe": 1 ]);  //Farben sollen eingeschaltet werden

  return ret;
}

static void reset_colors(int bg_white)
{
  Set(P_COLORS,([ 0:ANSI_NORMAL;          "normal",
                  1:ANSI_BLACK;           "schwarz",
                  2:ANSI_RED;             "rot",
                  3:ANSI_GREEN;           "gruen",
                  4:ANSI_YELLOW;          "gelb",
                  5:ANSI_BLUE;            "blau",
                  6:ANSI_PURPLE;          "violett",
                  7:ANSI_CYAN;            "cyan",
                  8:ANSI_WHITE;           "weiss",
                  9:ANSI_BLACK+ANSI_BOLD; "schwarz und fett",
                 10:ANSI_RED+ANSI_BOLD;   "rot und fett",
                 11:ANSI_GREEN+ANSI_BOLD; "gruen und fett",
                 12:ANSI_YELLOW+ANSI_BOLD;"gelb und fett",
                 13:ANSI_BLUE+ANSI_BOLD;  "blau und fett",
                 14:ANSI_PURPLE+ANSI_BOLD;"violett und fett",
                 15:ANSI_CYAN+ANSI_BOLD;  "cyan und fett",
                 16:ANSI_WHITE+ANSI_BOLD; "weiss und fett",
                 ]));
  if (!bg_white)
  {
    Set(P_COLOR_GROUPS,([CG_COLOR:     1,
                         CG_TELL:      6,
                         CG_EXITS:     3,
                         CG_INFORM:    2,
                         CG_AWAIT:     2,
/*                         CG_CHANNEL1:  ,
                         CG_CHANNEL2:  ,
                         CG_CHANNEL3:  ,
                         CG_CHANNEL4:  ,
                         CG_CHANNEL5:  ,
                         CG_CHANNEL6:  ,
                         CG_CHANNEL7:  ,
                         CG_CHANNEL8:  ,
                         CG_FINGER:    ,*/
                         CG_LIVING:    4,
                         CG_INFO_NAME: 5,
                         CG_INFO_VAL:  6,
                         CG_INFO_BONUS:2,
                         CG_PATH:      13,
                         CG_DETAILS:   11,
                         CG_LS_DIR:    16,
                         CG_LS_LOADED: 6,
                         CG_LS_C:      5,
                         CG_LS_H:      5,
/*                         CG_WHO_AWAIT: ,
                         CG_WHO_WIZARD:*/
                         ]));  
  }
  else
  {
    Set(P_COLOR_GROUPS,([CG_COLOR:     1,
                         CG_TELL:      6,
                         CG_EXITS:     5,
                         CG_INFORM:    2,
                         CG_AWAIT:     2,
/*                         CG_CHANNEL1:  ,
                         CG_CHANNEL2:  ,
                         CG_CHANNEL3:  ,
                         CG_CHANNEL4:  ,
                         CG_CHANNEL5:  ,
                         CG_CHANNEL6:  ,
                         CG_CHANNEL7:  ,
                         CG_CHANNEL8:  ,
                         CG_FINGER:    ,*/
                         CG_LIVING:    5,
                         CG_INFO_NAME: 5,
                         CG_INFO_VAL:  6,
                         CG_INFO_BONUS:2,
                         CG_PATH:      13,
                         CG_DETAILS:   5,
                         CG_LS_DIR:    16,
                         CG_LS_LOADED: 6,
                         CG_LS_C:      5,
                         CG_LS_H:      5,
/*                         CG_WHO_AWAIT: ,
                         CG_WHO_WIZARD:*/
                         ]));  
  }
}

void create()
{
  reset_colors(0);
  Set(P_COLORS, SAVE, F_MODE);
  Set(P_COLOR_GROUPS, SAVE, F_MODE);
}

mapping col_group_names()
{
  return COL_GROUP_NAMES;  
}

int string2color(string str)
{
  int * ind, i;
  mapping colors;
  
  str=lower_case(str);
  colors=QueryProp(P_COLORS);
  ind=m_indices(colors);
  for (i=sizeof(ind);i-->0;)
  {
   if (str==colors[ind[i],1])
     return ind[i];
  }
  return -1;
}

/* Verwandelt str in einen farbigen. Die Farbe bestimmt das Ereignis cmd.
** Wird kein String uebergeben, so wird die Farbe direkt umgestellt.
** Wird kein Ereignis uebergeben, so wird auf ANSI_NORMAL umgestellt,
** oder auf den entsprechenden selbstdifinierten String (extra0). */
varargs string in_color(string cmd, string str) {
	mapping cols;
	int i;
	string normal;
	cols = QueryProp(P_COLORS);
	if (QueryProp(P_TTY)!="ansi" || !cols || !member(cols, cmd) ||
		!cols["farbe"]) return str;
	if (member(cols, "0")) normal=cols["0"];
	else normal=ANSI_NORMAL;
	if (!stringp(cmd)) {
		if (!stringp(str)) printf(normal);
		return str;
	}
	i=cols[cmd];
	if (!str) str="", cmd=0;
	if (i>7 && i<16) { // hell = bold
		str=ANSI_BOLD+str;
		i-=8;
	}
	if (i<8) str=({ANSI_BLACK, ANSI_RED, ANSI_GREEN, ANSI_YELLOW,
		ANSI_BLUE, ANSI_PURPLE, ANSI_CYAN, ANSI_WHITE})[i]+str;
	else if (i==16) ;  /* Nichts tun */
	else {
		i-=16;
		if (member(cols, to_string(i)))
			str=cols[to_string(i)]+str;
	}
	if (!cmd) {
		write(str);
		return 0;
	}
	if (str[<1]=='\n') str=str[0..<2]+normal+"\n";
	else if (i!=16) str+=normal;
	return str;
}

/* Wandelt Steuerzeichen in Klartext, oder bei gesetztem Flag andersrum */
varargs private string convert(string str, int flag) {
	string ret;
	int i, j, k;
	ret="";
	i=strlen(str);
	if (!flag) { // Steuerzeichen -> Klartext
		for (j=0; j<i; j++) {
			if (str[j]>' ' && str[j]<128) ret+=str[j..j];
			else if (str[j]>127) ret+=sprintf("\\%03o",str[j]);
			else switch(str[j]) {
				case  7: ret+="\\a"; break;
				case  8: ret+="\\b"; break;
				case  9: ret+="\\t"; break;
				case 10: ret+="\\n"; break;
				case 12: ret+="\\f"; break;
				case 13: ret+="\\r"; break;
				case 27: ret+="\\E"; break;
				default: ret+=sprintf("^%c", str[j]+64);
			}
		}
		return ret;
	}
	/* Klartext -> Steuerzeichen
	** \a   ->  7    \b   ->  8    \t   ->  9    \n   -> 10
	** \f   -> 12    \r   -> 13    \E   -> 27    ^x   -> x-64
	** \nnn -> oktal */
	for (j=0; j<i; j++) {
		if (str[j]=='^') {
			j++;
			if (str[j]=='^') ret+="^";
			else ret+=sprintf("%c", str[j]-64);
		} else if (str[j]=='\\') {
			j++;
			if (str[j]=='\\') ret+="\\";
			else if (str[j]>='0' && str[j]<='7') { // oktal
				k=0;
				while(str[j]>='0' && str[j]<='7') {
					k*=8;
					k+=str[j]-'0';
					j++;
				}
				j--;
				ret+=sprintf("%c", k);
			} else switch (str[j]) {
				case 'a': ret+="\a"; break;
				case 'b': ret+="\b"; break;
				case 't': ret+="\t"; break;
				case 'n': ret+="\n"; break;
				case 'f': ret+="\f"; break;
				case 'r': ret+="\r"; break;
				case 'E': ret+=sprintf("%c",27); break;
				default : ret+=str[j..j];
			}
		} else ret+=str[j..j];
	}
	return ret;
}

string colorize(string str, int color)
{
  mapping colgrp, colors;
  
  colgrp=QueryProp(P_COLOR_GROUPS);
  colors=QueryProp(P_COLORS);
    
  if ( !colors[colgrp[color]] 
    || QueryProp(P_TTY)!="ansi" 
    || !colgrp[CG_COLOR])
	  return str;
	
	if (str[<1]=='\n') 
	  return colors[colgrp[color]]+str[0..<2]+colors[0]+"\n";
	
	return colors[colgrp[color]]+str+colors[0];
}

int cmd_color_def(string str)
{
  mapping colors, colgrp;
  string col, coldef;
  int * ind, i;
  
	col=query_verb();
	if (col!="farbdef" && col!="farbdefinition")
	  return 0;
	  
  colors=QueryProp(P_COLORS);
  
  if (!str||str==""||str=="liste")
  {
    if (!sizeof(ind=sort_array(m_indices(colors),#'>)))
    {
      reset_colors(0);
      write(break_string(
        "Ein Fehler ist aufgetreten, Eure Farben mussten auf die "
        "Standardeinstellungen zurueckgesetzt werden.")+"\n");
    }
    colors=QueryProp(P_COLORS);
    col="+-----------------------------------+------------------------------+\n"
        "| Farbe                             | Definition                   |\n"
        "+-----------------------------------+------------------------------+\n";
    for(i=0;i<sizeof(ind);i++)
    {
      if (QueryProp(P_COLOR_GROUPS)[CG_COLOR])
      {
        col+=sprintf("| %:33-s | %:*-s |\n",
          colors[ind[i],1],
          28+strlen(colors[ind[i]]+convert(colors[ind[i]])+colors[0])
            -strlen(convert(colors[ind[i]])),
          colors[ind[i]]+convert(colors[ind[i]])+colors[0]);
      }
      else
      {
        col+=sprintf("| %:33-s | %:28-s |\n",
          colors[ind[i],1],
          convert(colors[ind[i]]));
      }
    }
    col+="+-----------------------------------+------------------------------+\n";
    write(col);
  }
  else if (sscanf(str,"%s loeschen",col)==1)
  {
    col=lower_case(col);
    colors=QueryProp(P_COLORS);
    if (col=="normal")
    {
      write("Die Farbe 'normal' darf nicht geloescht werden.\n");  
    }
    else if (-1==(i=string2color(col)))
    {
      write("Die Farbe '"+col+"' habt Ihr nicht definiert.\n");
    }
    else
    {
      colgrp=QueryProp(P_COLOR_GROUPS);
      m_delete(colors,i);
      for (i=0;i<sizeof(ind=m_indices(colgrp));i++)
      {
        if (colgrp[ind[i]]==i)
          colgrp[ind[i]]=0;
      }
      write("Die Farbe '"+col+"' wurde geloscht.\n");
    }
  }
  else if (sscanf(str,"%s=%s",col,coldef)==2)
  {
    if (-1==(i=string2color(col)))
    {
      for (i=0;member(colors,i);i++);
      colors+=([i:convert(coldef,1);col]);
    }
    else
    {
      colors[i]=convert(coldef,1);
    }
    write("Die Farbe '"+col+"' ist jetzt als '"+coldef+"' definiert.\n");
  }
  else
  {
    write("Verwendung: farbdef [liste|<farbe>=<farbdefinition>|<farbe> loeschen]\n");
  }
  return 1;
  return 1;
}

int cmd_color(string str)
{
  mapping colgrp, color;
  string grp, col;
  int * ind, i, done, ncol;
  
	grp=query_verb();
	if (grp!="farbe" && grp!="farben")
	  return 0;
	
  colgrp=QueryProp(P_COLOR_GROUPS);
  
  if (!str||str==""||str=="liste")
  {
    ind=sort_array(m_indices(colgrp),#'>);
    color=QueryProp(P_COLORS);
    grp="+--------------------+------------------------------+\n"
        "| Farbgruppe         | Farbe                        |\n"
        "+--------------------+------------------------------+\n";
    for(i=0; i<sizeof(ind) 
          && ind[i]<(IS_LEARNER(this_object())?CG_MAX_WIZ:CG_MAX_PL);i++)
    {
      if (ind[i]!=CG_COLOR)
      {
        grp+=sprintf("| %:18-s | %:*-s |\n",
          capitalize(col_group_names()[ind[i]]),
          28+strlen(colorize(color[colgrp[ind[i]],1],ind[i]))
            -strlen(color[colgrp[ind[i]],1]),
          colorize(color[colgrp[ind[i]],1],ind[i]));
      }  
    }
    grp+="+--------------------+------------------------------+\n";
    write(grp);
  }
  else if (str=="an")
  {
    if (colgrp[CG_COLOR])
    {
      write("Die Farben sind bereits eingeschaltet.\n");
    }
    else
    {
      colgrp[CG_COLOR]=1;
      write("Farben eingeschaltet.\n");
    }
  }
  else if (str=="aus")
  {
    if (!colgrp[CG_COLOR])
    {
      write("Die Farben sind bereits ausgeschaltet.\n");
    }
    else
    {
      colgrp[CG_COLOR]=0;
      write("Farben ausgeschaltet.\n");
    }
  }
  else if (str=="reset" || str=="standard" || str=="normal")
  {
    reset_colors(0);
    write(break_string(
      "Die Farben wurden auf die Standardfarben fuer "
      "schwarzen Hintergrund gesetzt.\n"));
  }
  else if (str=="reset weiss" || str=="standard weiss" || str=="normal weiss")
  {
    reset_colors(1);
    write(break_string(
      "Die Farben wurden auf die Standardfarben fuer "
      "weissen Hintergrund gesetzt.\n"));
  }
  else if (sscanf(str,"%s %s",grp,col)==2)
  {
    col=lower_case(col);
    ncol=string2color(col);
    if (-1==ncol)
    {
      write("Die Farbe '"+col+"' habt Ihr nicht definiert.\n");
    }
    else
    {
      grp=lower_case(grp);
      ind=m_indices(col_group_names());
      for (i=0;i<(IS_LEARNER(this_object())?CG_MAX_WIZ:CG_MAX_PL) && !done;i++)
      {
        if (col_group_names()[i]==grp)
        {
          done=1;
          colgrp[i]=ncol;
          write(break_string(
            "Die Farbgruppe '"+capitalize(grp)+"' wird jetzt in der Farbe '"
            +colorize(col,i)+"' angezeigt."));
        }
      }
      if (!done)
        write("Die Farbgruppe '"+capitalize(grp)+"' gibt es nicht.\n");
    }
  }
  else
  {
    write("Verwendung: farbe [an|aus|reset|liste|<ereignis> <farbe>]\n");
  }
  return 1;
}

static string* _query_localcmds() {
	return ({({"farbe", "cmd_color", 1, 0}),
	         ({"farbdef", "cmd_color_def", 1, 0})});
}
