/*******************
** Eldarea MUDLib **
********************
**
** std/player/comm.c - player communication
**
** CVS DATA
** $Date: 2000/12/01 16:16:37 $
** $Revision: 1.3 $
**
** longdesc
**
** CVS History
**
** $Log: comm.c,v $
** Revision 1.3  2000/12/01 16:16:37  elatar
** new color handling adapted
** mud sound protocol implemented
**
** Revision 1.2  2000/08/04 10:56:18  eldarea
** mud sound protocol settings added
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

inherit "/std/player/channel";
inherit "/std/player/forum";
inherit "/std/living/comm.c";

#define NEED_PROTOTYPES
#define NEED_COMM_METHODS

#include "/sys/thing/properties.h"
#include "/sys/player/comm.h"
#include "/sys/player/forum.h"
#include <player/channel.h>

#include <properties.h>
#include <config.h>
#include <ansi.h>
#include <wizlevels.h>
#include <language.h>
#include <udp.h>
#include <defines.h>
#include <daemon.h>
#include <sound.h>
#include <color.h>

#define SHOUT_COST 25
#define ECHO_COST 0
#define KOBOLD_BUFFER_SIZE 20
#define MAX_HIST 10

varargs string name(int casus, int demonst);

//local property prototypes
static int _set_earmuffs(int level);
static int _query_intermud();

private static string *buffer = ({});
private static int i_buf, i_kob;
static mixed* enterer; // ({ Reinkommer, Rausgeher })

private static string *last_name = ({});
private static string last_echo;

// Quervererbte Methode von soul.c
varargs string slurr(string str, int alc);

#define DEBUG(x) if(find_player("largo")) tell_object(find_player("largo"), sprintf("%O\n", x))

void create() 
{
  forum::create();
  Set(P_EARMUFFS, 0);
  Set(P_EARMUFFS, SAVE, F_MODE);
  Set(P_EARMUFFS, SECURED, F_MODE);
  Set(P_CAN_EMOTE, SAVE, F_MODE);
  Set(P_CANECHO, SAVE, F_MODE);
  Set(P_CHANNELS, SAVE, F_MODE);
  Set(P_STD_CHANNEL, "a");
  Set(P_STD_CHANNEL, SAVE, F_MODE);
  Set(P_IGNORE, ({}), F_MODE);
  Set(P_IGNORE, SAVE, F_MODE);
  Set(P_BUFFER, SAVE, F_MODE);
  buffer = allocate(KOBOLD_BUFFER_SIZE);
  i_buf = 0;
  i_kob = -1; // Flag fuer leer
}

varargs static void send_sound(string file, int repeats, int priority, int volume)
{
  mapping sndset;
  
  if (!QueryProp(P_MUD_SOUND_PROTOCOL))
    return;
    
  sndset=QueryProp(P_MSP_SETTINGS);
  // volume berechnung
  volume=to_int((sndset[SND_VOLUME]/100.0)*(sndset[SND_SOUND]/100.0)*(volume/100.0));
    
  tell_object(this_object(),
    sprintf(
      "!!SOUND(%s V=%d L=%d P=%d%s)\n",
      file,repeats,priority,volume,SOUNDSERV->QuerySendStats(file)));
}

varargs static void send_music(string file, int repeats, int volume)
{
  mapping sndset;
  
  if (!QueryProp(P_MUD_SOUND_PROTOCOL))
    return;
    
  sndset=QueryProp(P_MSP_SETTINGS);
  // volume berechnung
  volume=to_int((sndset[SND_VOLUME]/100.0)*(sndset[SND_MUSIC]/100.0)*(volume/100.0));
    
  tell_object(this_object(),
    sprintf(
      "!!MUSIC(%s V=%d L=%d C=1%s)\n",
      file,repeats,volume,SOUNDSERV->QuerySendStats(file)));
}

varargs void sound(string file, int repeats, int priority, int volume)
{
  if (!file=SOUNDSERV->valid_sound(file))
    return;
    
  if ((repeats<1 || repeats > 100) && repeats!=-1)
    repeats=1;
    
  if (priority<1 || priority>100)
    priority=50;
    
  if (volume<1 || volume>100)
    volume=50;
  
  send_sound(file,repeats,priority,volume);

  SetProp(P_ACTUAL_SOUND,({file,repeats,priority,volume}));
}

varargs void music(string file, int repeats, int volume)
{
  if (!file=SOUNDSERV->valid_sound(file))
    return;
      
  if ((repeats<1 || repeats > 100) && repeats!=-1)
    repeats=1;
        
  if (volume<1 || volume>100)
    volume=50;
  
  send_music(file,repeats,volume);
  
  SetProp(P_ACTUAL_MUSIC,({file,repeats,volume}));
}

void stopsound()
{
  tell_object(this_object(),"!!SOUND(Off)\n");
}

void stopmusic()
{
  tell_object(this_object(),"!!MUSIC(Off)\n");  
}

void startmusic()
{
  mixed * music;
  
  music=QueryProp(P_ACTUAL_MUSIC);
  if (!pointerp(music) || sizeof(music)!=3)
    return;
    
  send_music(music[0],music[1],music[2]);
}

private int _send(object ob, string message) {
  mixed res;

  if(!call_resolved(&res, ob, "Message", message))
    tell_object(ob, message);
  return res;
}

// Flag 0 fuer komplette History
// Flag 1 fuer Kobold
private string _get_cache(int flag) {
  string ret;
  int i;
  ret="";
  if (flag) {
    if (i_kob==-1) return 0; // leer
    i=i_kob;                 // Anzeige i_kob bis i_buf-1
  } else i=i_buf;            // Anzeige i_buf bis i_buf-1
  do {
    ret+=buffer[i]||"";
    i=(i+1)%KOBOLD_BUFFER_SIZE;
  } while (i!=i_buf);
  i_kob=-1;
  if (!strlen(ret)) ret=0;
  return ret;
}

varargs static int _flush_cache(string arg) {
  int flag; // Bit 0 hat Hist  Bit 1 Fehler  Bit 2 Ausg Hist
  int i;
  if (IS_SEER(ME) || QueryProp(P_BUFFER)&2) flag=1;
  if (query_verb()=="thist") arg = "hist";

  switch(arg) {
    case "historie":
    case "hist":
      if (flag&1) flag|=4;
      else flag|=2;
      break;
    case "\n": // Nixtun
      break;
    case "an":
    case "ein":
      SetProp(P_BUFFER, QueryProp(P_BUFFER)|1); 
      printf("Der Kobold merkt sich jetzt alles!\n"); break;
    case "aus":
      SetProp(P_BUFFER, QueryProp(P_BUFFER)&(~1)); 
      printf("Der Kobold wird Dich nicht stoeren!\n"); break;
    default:
      if (arg) flag|=2;
      else {
        if (flag&1) flag|=4;
        else flag|=2;
      }
  }
  if (flag&2) {
    notify_fail("Kobold [ein|aus"+(flag&1?"|hist":"")+"]\n");
    return 0;
  }
  if ((arg=_get_cache(!(flag&4))) || enterer) {
    if (enterer) {
      if (!arg) arg="";
      if (i=sizeof(enterer[1])) {
        enterer[1]=sort_array(enterer[1], #'>);
        arg="Das "+MUDNAME+" verliess"+
        (i>1?"en "+implode(enterer[1][0..<2],", ")+" und ":" ")+
        enterer[1][<1]+".\n"+arg;
      }
      if (i=sizeof(enterer[0])) {
        enterer[0]=sort_array(enterer[0], #'>);
        arg="Ins "+MUDNAME+" kam"+
        (i>1?"en "+implode(enterer[0][0..<2],", ")+" und ":" ")+
        enterer[0][<1]+".\n"+arg;
      }
      enterer=0;
    }
    tell_object(this_object(), "Ein kleiner Kobold teilt Dir folgendes "
      "mit:\n"+arg+"---\n");
  }     
  else tell_object(this_object(), "Der Kobold sagt: Ich habe mir bis jetzt "
    "nichts gemerkt.\n");
  return 1;
}

void heart_beat() {
  if (i_kob==-1 && !enterer) return;
  if (!(QueryProp(P_BUFFER)&1) || query_editing(ME) ||
    query_input_pending(ME)) return;
  write("\n");
  _flush_cache("\n");
}

private int check_ignore(mixed ignore, string verb, mixed ob) {
  return (ob && ob->id(ignore)) || (ignore==verb) || 
    ((sizeof(ignore = explode(ignore, ".")) > 1) &&
     (ob && ob->id(ignore[0]) && member(ignore[1..], verb)>-1));
}

varargs int Message(string msg, string myverb) {
  object me, ti, tp;
  string verb, reply, tiname, *ignore, *ign;
  int em, ig, te, ec, eb, im, i;

  ti = this_interactive();
  verb = myverb || query_verb();
  if(!stringp(verb)) verb="";

  if(verb=="illusion" || verb[0]=='.' || verb=="echo") {
    ec=1;
    verb="illusion";
  }

  im = file_name(previous_object())=="/secure/udp/tell";
  te = verb[0..3]=="teil" || verb[0..6]=="erzaehl";
  eb = verb[0..4]=="ebene";
  
  tp=PL;
  if(eb && tp && previous_object(2) && previous_object(3)) {
    if(file_name(previous_object(2))=="/std/npc")
      tp=previous_object(3);
  }

  ignore = (pointerp(ignore=QueryProp(P_IGNORE)) ? ignore : ({}));

  if(ti &&
     ((ig = sizeof(filter_array(ignore, #'check_ignore, "", ti))) ||
     (em = (ti->QueryProp(P_LEVEL)+100*query_wiz_level(ti))
      <= QueryProp(P_EARMUFFS)))) {
    if(te || verb[0..6]=="antwort" || verb[0..7]=="fluester") tell_object(ti,
      capitalize(name(WER,2))+" hoert gar nicht zu, was Du sagst.\n");
    if(ig || (em && (te || (stringp(verb) && verb[0..2] == "ruf"))))
      return -1;
  }

  
  if((tp||ti) && strlen(verb)) {
    if(sizeof(filter_array(ignore, #'check_ignore, verb, (tp?tp:ti)))) {
      if(ec || eb || verb[0..2]=="ruf") return -1;
      if(tp==previous_object() || ti==previous_object())
        tell_object((tp?tp:ti), 
          capitalize(ME->name(WER,2))+" wehrt \""+verb+"\" ab.\n");
      return -1;
    }
  }
  else
    if(sizeof(filter_array(ignore, #'check_ignore, verb)))
      return -1;

  i=(QueryProp(P_BUFFER)&1) && (query_editing(me = this_object()) ||
    query_input_pending(me));
  if (te||im) {
    if (i && i_kob==-1) i_kob=i_buf; // Erste Meldung im Koboldbuffer
    else if (i_buf==i_kob) { // Kobold voll
      if (i) { // Im Koboldmode?
        reply=capitalize(ME->name())+(im?"@"+MUDNAME:"")+
          " moechte gerade nicht gestoert werden.\nDie Mitteilung "
          "ging verloren, denn der Kobold kann sich nichts mehr merken!\n";
        if (ti) tell_object(ti, reply);
        else if (im) previous_object()->write(reply); // Intermud-daemon
        return 0;
      } else i_kob=(i_kob+1)%KOBOLD_BUFFER_SIZE; // Sonst Kobold wegschneiden
    }
    buffer[i_buf]=msg;
    i_buf=(i_buf+1)%KOBOLD_BUFFER_SIZE;
    if (i) {
      reply=capitalize(ME->name())+(im?"@"+MUDNAME:"")+
        " moechte gerade nicht gestoert werden.\nDie Mitteilung wurde von "
        "einem kleinen Kobold in Empfang genommen.\n";
      if (ti) tell_object(ti, reply);
      else if (im) previous_object()->write(reply); // Intermud-daemon
      return 0;
    }
  } else if (i) return 0;

  if(ec) {
    last_echo="Die letzte Illusion wurde von "+(previous_object()==ME?"Dir":
      previous_object()->name(WEM,2))+" erzeugt:\n"+msg+"\n";
    msg=in_color("illusion", msg);
  }
  else if (te) msg=colorize(msg, CG_TELL);
  else if (eb) msg=colorize(msg,CG_CHANNEL1);
  tell_object(this_object(), msg);
  return 1;
}

static int check_deaf(object ob) {
  return (ob && interactive(ob) && ob->QueryProp(P_DEAF));
}

static int ignoriere(string str) {
  mixed ignore;
  int i;
  string verb;
  
  if (verb && verb!="ignorier" && verb!="ignoriere")
    return 0;
  if(!(ignore = Query(P_IGNORE))) ignore = ({});
  
  if (!str || str=="" || str==" ")
    if (!sizeof(ignore))
    {
      notify_fail("Im Augenblick ignorierst Du nichts und niemanden.\n");
      return 0;
    }
    else
    {
      ignore = sort_array(ignore, #'>);
      write(break_string("/std/player/soul"->CountUp(ignore)+".",0,"Du ignorierst: "));
      return 1;
    }
  if (member_array(lower_case(str), ignore)!=-1)
    {
      Set(P_IGNORE, ignore -= ({ lower_case(str) }));
      printf("Du ignorierst %s nicht mehr.\n", capitalize(str));
      return 1;
    }
  if (sizeof(ignore) > 100)
  {
    printf("Du kannst niemanden mehr ignorieren. Es sind nur 100 Eintraege zulaessig!\n");
    return 1;
  }
  Set(P_IGNORE, ignore += ({ lower_case(str) }));
  printf("Du ignorierst jetzt folgende weitere Mitteilungen: %s.\n", str);
  return 1;
}

int earmuffs(string s) {
  int x;
  
  if (!s || s == "")
    {
      write("Ok, Oropax aus.\n");
      SetProp(P_EARMUFFS, 0);
      return 1;
    }
  if (sscanf(s, "%d", x) == 0 || x < 0)
    {
      write("Verwendung: oropax <level>\n");
      return 1;
    }
  if (SetProp(P_EARMUFFS, x) == x)
    printf("Ok, Oropaxlevel ist jetzt %d.\n", x);
  else
    printf("So hoch geht es nicht. Oropaxlevel ist jetzt %d.\n",
	   QueryProp(P_EARMUFFS));
  return 1;
}

static int _communicate(mixed str, int silent) {
  string verb;
  string myname;
  string adverb, txt, str2;
  int i;
  object *deaf;
  
  verb = query_verb();
  if(!str) str = "";
  if(stringp(verb) && verb[0] == "'"[0]) str = verb[1..] + " " + str;
  if (str==""||str==" ") {
    write("Was willst Du sagen?\n");
    return 1;
  }
  if (sscanf(str, "%s:: %s", adverb, txt)!=2) {
    txt=str;
    adverb="";
  } else adverb=" "+adverb;
  if (QueryProp(P_INVIS) || this_object()->QueryShadow())
    myname = ME->name();
  else
    myname = QueryProp(P_PRESAY) + ME->name();
  if (myname && strlen(myname)) myname=capitalize(myname);
  if (!deaf=filter_array(all_inventory(environment(ME))&users(),"check_deaf"))
    deaf=({});
  str2=_comm_hook(txt, COMM_SAGE);
  if (!silent) {
    if (str2[0]=='\t') {
      write(break_string(str2[1..]));
      return 1;
    }
    write(break_string(txt,0,"Du sagst"+adverb+": ", BS_FOR_COMM));
  } else if (str2[0]=='\t') return 1; // falls silent
  i=(ME->QueryProp(P_ALCOHOL)*100)/ME->QueryProp(P_MAX_ALCOHOL);
  txt=slurr(str2, i);
  if (i>=60) say(break_string(txt,0,myname+" lallt"+adverb+": ", BS_FOR_COMM),
      deaf+({ME}));
  else say(break_string(txt, 0, myname+" sagt"+adverb+": ", BS_FOR_COMM),
    deaf+({ME}));
  say( ({"soul", ME, 0, "sage", str}) );
  return 1;
}

static int _shout_to_all(mixed str) {
  string myname, verb;
  string adverb, txt;
  mixed *frog;
  
  if(!IS_SEER(ME))
    {
      if (QueryProp(P_SP) < SHOUT_COST)
	{
	  write("Du must erst wieder magische Kraefte sammeln.\n");
	  return 1;
	}
      SetProp(P_SP, QueryProp(P_SP) - SHOUT_COST);
    }
  if (!str||!strlen(str))
    {
      write("Was willst Du rufen?\n");
      return 1;
    }
  if (sscanf(str, "%s:: %s", adverb, txt)!=2) {
    adverb="";
    txt=str;
  } else adverb=" "+adverb;
  if(QueryProp(P_INVIS) ||
     this_object()->QueryShadow())
    myname = ME->name();
  else
    myname = QueryProp(P_PRESAY) + ME->name();
  if (myname && strlen(myname)) myname=capitalize(myname);

  str=_comm_hook(txt, COMM_RUFE);
  if (str[0]=='\t') {
    write(break_string(str[1..]));
    return 1;
  }
  write(break_string(txt, 0, "Du rufst"+adverb+": ", BS_FOR_COMM));
  txt=slurr(str);
  verb = " ruft"+adverb+": ";
  if(frog=this_object()->QueryProp(P_FROG))
    if(stringp(frog[FROG_SHOUT]))
      txt = frog[FROG_SHOUT];
    else if(pointerp(frog[FROG_SHOUT]))
      {
	verb = " "+frog[FROG_SHOUT][0]+adverb+": ";
	txt = frog[FROG_SHOUT][1];
      }

  map_array(filter_array(users() - ({ this_object() }), 
                         lambda(({'o}), ({#'!, ({#'check_deaf, 'o})}))),
            #'_send, break_string(txt, 0, myname+verb, BS_FOR_COMM));
  return 1;
}

static varargs int _tell(mixed str, int silent) {
  object ob;
  string who,myname,away,ret;
  string adverb, txt;
  mixed msg,it,ignore,*xname;
  int i,visflag,points, size;

  if(!str || str=="") {
    notify_fail("Wem willst Du was erzaehlen?\n");
    return 0;
  }
  else if(str=="?") {
    printf("Dein%s letzte%s Gespraechspartner %s.\n",
      ((size = sizeof(last_name)) == 1) ? "" : "e",
      (size == 1) ? "r" : "n",
      (!size ? "sind Dir nicht mehr bekannt":
      ((size == 1) ? "war " : "waren ")+
      ("std/player/soul"->CountUp(map_array(last_name, 
        #'capitalize)))));
    return 1;
  }
  else if(sscanf(str, "%s %s", who, msg) != 2 || !who || who=="") {
    if (strlen(str)) notify_fail("Was willst Du "+capitalize(str)+
      " mitteilen oder erzaehlen?\n");
    else notify_fail("Wem willst Du was mitteilen oder erzaehlen?\n");
    return 0;
  }

  if ((points = to_int(who)) ||
      (points = strlen(regreplace(who,"[^\\.]","",1))))
  {
    if (sizeof(last_name) < points)
    {
      notify_fail("Wem willst Du was mitteilen oder erzaehlen?\n");
      return 0;
    }
    else
    {
      who = last_name[points-1];
      last_name -= ({who});
      last_name = ({who}) + last_name;
    }
  }
  else
  {
    last_name -= ({who});
    last_name = ({who}) + ((sizeof(last_name) == MAX_HIST) ? 
                            last_name[0..<2] : last_name);
  }

  xname = explode(who, "@");
  if (sizeof(xname) == 2) {
      if (ret=(string)INETD->send_udp(xname[1],([ REQUEST:   "tell",
					       RECIPIENT: xname[0],
					       SENDER:	   getuid(ME),
					       DATA:	   msg ]), 1))
        write(ret);
      else
        if (!silent)
          write("Nachricht abgeschickt.\n");
      return 1;
  }

  if (!ob=find_player(it = lower_case(who))) {
      it = match_living(it, 1);
      if (!stringp(it) || !(ob=find_player(it)) || ob->QueryProp(P_INVIS))
        it = match_living(it=lower_case(who), 0);
      if (!stringp(it))
	switch (it) {
	  case -1:
	    notify_fail("Das war nicht eindeutig!\n");
	    return 0;
	  case -2:
	    notify_fail("Kein solcher Spieler!\n");
	    return 0;
        }
      ob = find_player(it);
      if (!ob) ob = find_living(it);
  }
  visflag = (!ob->QueryProp(P_INVIS)) || IS_LEARNER(ME);
  if (!visflag && IS_LEARNER(ob)) {
    if (query_once_interactive(ME)) write("Kein solcher Spieler!\n");
    else ME->write("\n");
    visflag=-1;
  }
  
  if(QueryProp(P_INVIS) || this_object()->QueryShadow()) {
    myname = ME->name();
    if (IS_LEARNER(ob)) myname+=sprintf(" (%s)", capitalize(getuid()));
  } else {
    myname = QueryProp(P_PRESAY) + ME->name();
  }
  if (myname && strlen(myname)) myname=capitalize(myname);


  if (sscanf(msg, "%s:: %s", adverb, txt)!=2) {
    txt=msg;
    adverb="";
  } else adverb=" "+adverb;

  str=_comm_hook(txt, COMM_TEILEMIT);
  if (str[0]=='\t') {
    write(break_string(str[1..]));
    return 1;
  }
  if(ob==ME)
      _send(ob, break_string(txt, 0, "Du teilst Dir selbst"+adverb+" mit: ",
          BS_FOR_COMM));
  else
    _send(ob, break_string(slurr(str),
        0, myname+" teilt Dir"+adverb+" mit: ", BS_FOR_COMM));

  if (visflag>0 && ob!=ME && !silent) {
    if (!query_once_interactive(ME)) { // Intermud-tell-query
      ME->write(break_string(txt, 0, "Du teilst "+ob->name(WEM)+
        "@"+MUDNAME+adverb+" mit: ", BS_FOR_COMM));
      if (away=ob->QueryProp(P_AWAY)) ME->write(break_string(away, 0,
        capitalize(ob->name(WER))+"@"MUDNAME" ist gerade nicht da: "));
      return 1;
    } else {
      write(break_string(txt+(ME->QueryProp(P_AWAY)?" (weg)":""),
        0, "Du teilst "+ob->name(WEM)+adverb+" mit: ", BS_FOR_COMM));
    }
  }
  if ((!visflag&&interactive(ob)) ||
      (query_once_interactive(ob) && !interactive(ob)))
    write(sprintf("%s ist netztot oder unsichtbar.\n",capitalize(it)));
  else if ((away=(string)ob->QueryProp(P_AWAY)) && !silent && visflag>0)
    write(break_string(away, 0,
      sprintf("%s ist gerade nicht da: ",capitalize(it))));
  return 1;
}

static int _teile(string str)
{
  string who, message;
  string adverb, txt;

  if (!str) return 0;
  if (str=="?" || str=="? mit") return _tell("?");
  notify_fail("Wem willst Du was mitteilen?\n");
  if (sscanf(str, "%s mit %s", who, message) == 2) {
    if (sscanf(who, "%s %s", txt, adverb)==2) {
      who=txt;
      adverb=adverb+":: ";
    }
    else adverb="";
    return _tell(who+" "+adverb+message);
  } else if (sscanf(str, "%s mit", who)==1) notify_fail("Was willst Du "+
    capitalize(who)+" mitteilen?\n");
  return 0;
}

static int _whisper(string str) {
  object ob,*deaf;
  string who,msg,myname,it,*wie;
  string adverb, txt;
  int i;
  
  if (!str || (sscanf(str, "zu %s %s", who, msg) != 2 &&
               sscanf(str, "%s zu %s", who, msg) != 2))
    {
      notify_fail("Was willst Du wem zufluestern?\n");
      return 0;
    }
  if (sscanf(who, "%s %s", txt, adverb)==2) {
    who=txt;
    adverb=" "+adverb;
  }
  else adverb="";
  ob = find_living(it = lower_case(who));
  if (!ob || !present(it, environment(ME)))
    {
      notify_fail("Kein solcher Spieler in diesem Raum.\n");
      return 0;
    }
  if (ob==this_object()) {
    write(break_string(msg, 0,
      "Du fluesterst Dir selbst"+adverb+" zu: ", BS_FOR_COMM));
    return 1;
  }
  if(QueryProp(P_INVIS) ||
     this_object()->QueryShadow())
    myname = ME->name();
  else
    myname = QueryProp(P_PRESAY) + ME->name();
  if (myname && strlen(myname)) myname=capitalize(myname);
  str=_comm_hook(msg, COMM_FLUESTERE);
  if (str[0]=='\t') {
    write(break_string(str[1..]));
    return 1;
  }
  write(break_string(msg, 0, "Du fluesterst "+ob->name(WEM,1)+adverb+" zu: ",
    BS_FOR_COMM));
  i=(ME->QueryProp(P_ALCOHOL)*100)/ME->QueryProp(P_MAX_ALCOHOL);
  msg=slurr(str, i);
  if (i>=60) wie=({" lallt ", adverb+" ins Ohr"});
  else wie=({" fluestert ", adverb+" zu"});
  if(!ob->QueryProp(P_DEAF))
    _send(ob, break_string(msg,0,myname + wie[0]+"Dir"+wie[1]+": ", BS_FOR_COMM));
  if(!deaf=filter_array((all_inventory(environment())&users())-
      ({ME,ob}),"check_deaf"))
    deaf=({});
  say(myname + wie[0] + ob->name(WEM, 1) + " etwas"+wie[1]+".\n", deaf+({ME,ob}));
  say( ({"soul", ME, ob, "fluestere", msg}) );
  return 1;
}

static int _converse(string who) {
  object ob;
  notify_fail("Syntax: 'gespraech' oder 'gespraech mit <spieler>'\n");

  if(who && sscanf(who, "mit %s", who)==1) {
    if(strstr(who," ")!=-1)
      return 0;
    else {
      if(!(ob=find_living(lower_case(who)))) {
        write("Keinen Gespraechspartner gefunden.\n");
        return 1;
      }
      if(ob==ME) {
        write("Selbstgespraeche sind doch sinnlos.\n");
        return 1;
      }
      write("Mit '**' oder '.' wird das Gespraech beendet.\n");
      write("]");
      input_to("_converse_more_to_object",0,who);
      return 1;
    }
  }
  else if(who)
    return 0;

  write("Mit '**' oder '.' wird das Gespraech beendet.\n");
  write("]");
  input_to("_converse_more");
  return 1;
}

static int _converse_more(mixed str) {
  string cmd;
  int i;
  
  if(str=="**" || str==".") {
      write("Ok.\n");
      return 0;
  }
  if(str != "") _communicate(str, 1); 
  write("]");
  input_to("_converse_more");
}

static int _converse_more_to_object(mixed str, string who) {
  string cmd;
  int i;

  if(str=="**" || str==".") {
    write("Ok.\n");
    return 0;
  }
  if(str!="") _tell(who+" "+str, 1);
  write("]");
  input_to("_converse_more_to_object",0,who);
}


private int is_learner(object o) {
  return IS_LEARNER(o);
}

static int _shout_to_wizards(mixed str) {
  int i, j;
  string myname;
  object *u;
  
  if(!str||!strlen(str)) {
      write("Was willst Du den Magiern zurufen?\n");
      return 1;
    }
  myname = capitalize(getuid(this_object()));
  if (!IS_LEARNER(this_object())) write("Ok.\n");
  map_array(filter_array(users(), #'is_learner),
    #'_send, break_string(str, 0, myname+" an alle Magier: ", BS_FOR_COMM));
  return 1;
}

/* Folgende Verbesserung des normalen Emote ist mit Einverstaendnis
** von freaky@unitopia nach der Hilfeseite dort nachprogrammiert.
** Dabei hab ich es ein bisschen veraendert.
** Vielen Dank an das Unitopia fuer die prima Idee!
** (Der Verweis ans Uni hat hier stehenzubleiben.)
** Fiona
*/
private mixed emote_help(string str, int echoflag) {
  string* parts, *tmp;
  int i, j, k, m, num, fall, gross, me_starts;
  object vic,* vics;
  string* txt;
  if (member(str, '$')==-1) return 0;
  parts=efun::explode(str, "$");
  num=sizeof(parts);
  txt=({ parts[0] });
  vics=({ 0 });
  me_starts=0;
  for (i=1; i<num; i++) {
    if (parts[i][0]=='(' && (j=member(parts[i], ')'))>=0) {
      // nicht auswerten, wenn in klammer ein $ steht
      tmp=efun::explode(parts[i][1..j-1], ",");
      if (sizeof(tmp)==2) { // nur auswerten, wenn eindeutig
        if (vic) k=member(vics, vic);
        else k=-1;
        for (m=sizeof(txt); m--;) {
          if (m==k) txt[m]+=tmp[1]+parts[i][j+1..];
          else txt[m]+=tmp[0]+parts[i][j+1..];
        }
        continue;
      }
    }
    if (strlen(parts[i])>4) { // min Laenge fuer Namenersetzung
      if (parts[i][3]=='(' && (j=member(parts[i][4..], ')'))>=0) {
        switch (parts[i][0..2]) {
          case "der": fall=WER;    gross=0; break;
          case "des": fall=WESSEN; gross=0; break;
          case "dem": fall=WEM;    gross=0; break;
          case "den": fall=WEN;    gross=0; break;
          case "Der": fall=WER;    gross=3; break;
          case "Des": fall=WESSEN; gross=3; break;
          case "Dem": fall=WEM;    gross=3; break;
          case "Den": fall=WEN;    gross=3; break;
          case "deR": fall=WER;    gross=1; break;
          case "deS": fall=WESSEN; gross=1; break;
          case "deM": fall=WEM;    gross=1; break;
          case "deN": fall=WEN;    gross=1; break;
          default:    fall=-1;
        }
        if (fall>-1) {
          vic=present(parts[i][4..j+3], environment());
          m=sizeof(txt);
          if (living(vic)) {
            // puh, endlich gueltig...
            if (i==1 && vic==this_object() && parts[0]=="") me_starts=1;
            tmp=({ ({"du","dein","dir","dich"})[fall], vic->name(fall, 2) });
            if (gross&1) tmp[0]=capitalize(tmp[0]);
            if (gross&2) tmp[1]=capitalize(tmp[1]);
            k=member(vics, vic);
            if (k==-1) {
              txt+=({ txt[0]+tmp[0]+parts[i][j+5..] });
              vics+=({ vic });
            }
          } else {
            tmp=({ 0, capitalize(parts[i][4..j+3]) });
            k=-1;
          }
          for (; m--;) {
            if (m==k) txt[m]+=tmp[0]+parts[i][j+5..];
            else txt[m]+=tmp[1]+parts[i][j+5..];
          }
          continue;
        }
      }
    }
    for (m=sizeof(txt); m--;) txt[m]+="$"+parts[i];
  }
  str=_comm_hook(txt[0], echoflag?COMM_ECHO:COMM_EMOTE);
  if (str!=txt[0]) {
    if (str[0]=='\t') return str[1..];
    i=member(vics, this_object());
    if (i==-1) { // Anlegen einer speziellen Ausgabe fuer TP
      vics+=({ this_object() });
      txt+=({ txt[0] });
      txt[0]=str;
    } else txt[0]=str;
  }
  for (i=sizeof(vics); --i;) {
    if (vics[i]==this_object()) continue;
    txt[i]=_comm_hook(txt[i], echoflag?COMM_ECHO:COMM_EMOTE);
    if (txt[i][0]=='\t') return txt[i][1..];
  }
  return ({ vics, txt, me_starts });
}

static int _emote(string str) {
  int flag; // flag gesetzt fuer gemote
  string verb, myname, str2;
  mixed* x;
  int i, j;
  object* objs;
  if (!IS_SEER(ME) && !Query(P_CAN_EMOTE))
    return 0;
  verb = query_verb();
  if (verb=="gemote" || verb[0]==';') flag=1;
  if (str == 0) str = "";
  if (flag) { //gemote
	flag=WESSEN;
	if (verb[0]==';') str=verb[1..<1]+" "+str;
  } else if (verb[0]==':') str=verb[1..<1]+" "+str;
  if (!str||!strlen(str)) {
    write("Was willst du `"+(flag?"g":"")+"emoten`?\n");
    return 1;
  }
  myname=capitalize(call_other(this_object(),"name",flag))+" ";
  x=emote_help(str, 0);
  if (stringp(x)) {
    write(break_string(x));
    return 1;
  }
  if (x) {
    // pruefen ob durch Beginnen mit $der(myname) Name am Anfang schon steht
    if (x[2]) myname="";
    objs=({});
    for (i=sizeof(x[0]); --i;) {
      tell_object(x[0][i], break_string(myname+x[1][i]));
      objs+=({x[0][i]});
    }
    tell_room(environment(), break_string(myname+x[1][0]), objs);
    return 1;
  }
  str2=_comm_hook(str, COMM_EMOTE);
  if (str2[0]=='\t') {
    write(break_string(str2[1..]));
    return 1;
  }
  say(break_string(myname+str2));
  write(break_string(myname+str));
  return 1;
}

private int check_valid_echo(string str) {
  string s1, s2;
  int i;
  object* pls;
  str=lower_case(str);
  // nicht mit Spielernamen beginnen:
  if (sscanf(str,"%s %s", s1, s2)==2) {
    if (s1==getuid()) return 1; // Man selbst ja
    if (living(present(s1, environment())) || ( strstr(s1 ,".")==-1 &&
      file_size("/save/"+s1[0..0]+"/"+s1+".o")>=0)) return 0;
    if (sscanf(s1,"gast%d",i)==1) return 0;
  }
  return 1;
}

static int _echo(string str) {
  string verb, named, *ign, str2;
  object* pls;
  mixed* x;
  int i;
  if (ME->QueryProp(P_CANECHO)<1) return 0;
  verb=query_verb();
  if (strlen(verb)>1 && verb[0]=='.') 
    str=verb[1..]+(str?" "+str:"");
  if (!str || !strlen(str)) {
    notify_fail("Was fuer eine Illusion moechtest Du denn aufbauen?\n");
    return 0;
  }
  if (str=="?") {
    if (!last_echo) write("Bis jetzt konntest Du noch keine Illusion "
      "feststellen.\n");
    else write(last_echo);
    return 1;
  }
  if (str=="+") {
    if (ME->QueryProp(P_CANECHO)==2)
      write("Du siehst bereits, wer eine Illusion erzeugt.\n");
    else {
      write("Du siehst nun, wer eine Illusion erzeugt hat.\n");
      ME->SetProp(P_CANECHO, 2);
    }
    return 1;
  }
  if (str=="-") {
    if (ME->QueryProp(P_CANECHO)==1)
      write("Du siehst doch gar nicht, wer eine Illusion erzeugt.\n");
    else {
      write("Du siehst nun nicht mehr, wer eine Illusion erzeugt hat.\n");
      ME->SetProp(P_CANECHO, 1);
    }
    return 1;
  }
  if ((ign=ME->QueryProp(P_IGNORE)) && member(ign, "illusion")!=-1) {
    notify_fail("Du kannst nur dann eine Illusion aufbauen, wenn Du selbst"
      " auch welche zulaesst.\n");
    return 0;
  }
  if (!check_valid_echo(str)) {
    write("Diese Illusion waere nicht fair.\n");
    return 1;
  }
  str=capitalize(str+"\n");
  x=emote_help(str, 1);
  if (stringp(x)) {
    write(break_string(x));
    return 1;
  }
  pls=filter_array(all_inventory(environment()), #'interactive);
  named="("+capitalize(ME->name(WER,2))+") ";
  if (!x) {
    str2=_comm_hook(str, COMM_ECHO);
    if (str2[0]=='\t') {
      write(break_string(str2[1..]));
      return 1;
    }
    if (str2!=str) // Aufspalten der Ausgabe
      x=({ ({ 0, this_object() }), ({ str2, str }), 0 });
  }
  if (x) {
    for (i=sizeof(x[1]); i--;) {
      if (!check_valid_echo(x[1][i])) {
        write("Diese Illusion waere nicht fair.\n");
        return 1;
      }
    }
    for (i=sizeof(x[0]); --i;) {
      if (x[0][i]->QueryProp(P_CANECHO)==2)
        x[0][i]->Message(break_string(named+x[1][i]));
      else x[0][i]->Message(break_string(x[1][i]));
      pls-=({x[0][i]});
    }
    str=x[1][0];
  }
  for (i=sizeof(pls); i--;) {
    if (pls[i]->QueryProp(P_CANECHO)==2)
      pls[i]->Message(break_string(named+str));
    else pls[i]->Message(break_string(str));
  }
  // log_file("ECHOS", sprintf("%-79s",named+str)); War fuer Testphase
  return 1;
}

public int AddCommHook(object ob, mixed fun, int meth) {
  mapping map;
  if (!objectp(ob)) return 0;
  if (!(meth & COMM_ALL)) return 0;
  if (!stringp(fun)) {
    if (!closurep(fun) || to_object(fun)!=ob) return 0;
  } else {
    fun=symbol_function(fun, ob);
    if (!fun) return 0; // Funktion nicht gefunden
  }
  map=QueryProp(P_COMM_HOOKS);
  if (!map) {
    map=([]);
    SetProp(P_COMM_HOOKS, map);
  }
  map+=([ ob: meth; fun ]);
  return 1;
}

public int RemoveCommHook(object ob) {
  mapping map;
  map=QueryProp(P_COMM_HOOKS);
  // Mappings werden immer als Referenz uebergeben
  if (!map || !member(map, ob)) return 0;
  efun::m_delete(map, ob);
  if (!m_sizeof(map)) SetProp(P_COMM_HOOKS, 0);
  return 1;
}

static string _comm_hook(string txt, int meth) {
  mapping map;
  map=QueryProp(P_COMM_HOOKS);
  if (map) {
    efun::m_delete(map, 0); // Geistereintraege loeschen
    if (!m_sizeof(map)) {
      SetProp(P_COMM_HOOKS, 0); // Mapping loeschen
      return txt;
    }
  } else return txt;
  walk_mapping(map, lambda( ({ 'ob, 'meth, 'fun, 'mymeth, 'txt }), ({
    #'?, ({ #'&&, ({ #'!=, ({ #'[, 'txt, 0 }), '\t' }),
                  ({ #'&, 'meth, 'mymeth })
         }),
         ({ #',, ({ #'=, 'tmp, ({ #'funcall, 'fun, 'txt, 'mymeth }) }),
                 ({ #'?, 'tmp,
                         ({ #'?!, ({ #'stringp, 'tmp }),
                                  ({ #'raise_error, ({ #'sprintf,
                                     "(/std/player/comm.c) falscher Rueckgabe"
                                     "wert von %O", 'fun })
                                  }),
                                  ({ #'=, 'txt, 'tmp })
                         }),
                 })
         })
   }) ), meth, &txt);
/* in etwa: fun(mapkey, mapmeth, mapfun, meth, &txt) {
**            if (txt[0]!='\t' && mapmeth&meth) {
**              tmp=funcall(mapfun, txt, meth);
**              if (tmp) {
**                if (!stringp(tmp)) raise_error(...);
**                else txt=tmp;
**              }
**            }
**          }
*/
  return txt;
}

//****local property methods

static int _set_can_echo(int i) {
  if (Query(P_CANECHO)<0) return -1;
  return Set(P_CANECHO, i);
}

static int _set_earmuffs(int level) {
  int max;
  
  max=this_object()->QueryProp(P_LEVEL);
  if(max>99)
    max=99;
  max=100*query_wiz_level(this_object())+max;
  return Set(P_EARMUFFS, level > max ? max : level);
}

static mixed _set_ignore(mixed arg) {
  if(stringp(arg)) arg = ({ arg });
  if(pointerp(arg)) return Set(P_IGNORE, arg);
}

// static int _query_intermud() {
//   mixed tmp;
//   return member(pointerp(tmp=Query(P_CHANNELS))?tmp:({}), "Intermud") > -1;
// }

static string *_query_localcmds() {
  return ({
    ({"kobold", "_flush_cache",1,0}),
    ({"thist", "_flush_cache",1,0}),
    ({"sag","_communicate",1,0}),
    ({"'","_communicate",1,0}),
    ({"mruf","_shout_to_wizards",1,0}),
    ({"ruf","_shout_to_all",1,0}),
    ({"erzaehl","_tell",1,0}),
    ({"teil","_teile",1,0}),
    ({"fluester","_whisper",1,0}),
    ({"gespraech","_converse",1,0}),
    ({"illusion","_echo",0,0}),
    ({"echo","_echo",0,0}),
    ({".","_echo",1,0}),
    ({"emote","_emote",0,0}),
    ({":","_emote",1,0}),
    ({"gemote","_emote",0,0}),
    ({";","_emote",1,0}),
    ({"oropax","earmuffs",0,WIZARD_LVL}),
    ({"ignorier","ignoriere",1,0}),
  })+channel::_query_localcmds()+forum::_query_localcmds();
}
