/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/01 16:19:50 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: command.c,v $
** Revision 1.2  2000/12/01 16:19:50  elatar
** special character filtering implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// STD/PLAYER/COMMAND.C -- player commands
//
// basierend auf der MorgenGrauen MUDlib
//
// $Revision: 1.2 $
//
// $Log: command.c,v $
// Revision 1.2  2000/12/01 16:19:50  elatar
// special character filtering implemented
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.20  1999/07/09 11:11:39  Fiona
// Alias-Mengen-Sperre nur fuer !Magier. Anzahl auf 100x200 hochgesetzt
//
// Revision 1.19  1999/07/08 15:36:00  Fiona
// Anzahl und Laenge der Alis beschraenkt auf 70x200
//
// Revision 1.18  1999/05/12 09:56:16  Fiona
// Aliabfrage auch mit Joker nun
//
// Revision 1.17  1999/02/03 13:08:28  Holger
// AddAction(), undo, exchange weg. do gebugfixt. Bissl aufgeraeumt.
//
// Revision 1.16  1998/06/27 01:45:50  Gum
// kleine aenderungen am header
// 78 in BS_STDLEN geaendert
//
// Revision 1.15  1998/05/28 17:47:09  Gum
// in modify_command hab ich ein en check des previous_objects eingebaut.
// nur wenn dieses 0 ist, wird das kommando zur history addiert. jetzt ist
// endlich der bug behoben, dass 'cd' zweimal in der history auftaucht
//
// Revision 1.14  1998/05/25 15:56:16  Gum
// in modify_command wird jetzt P_ACTUAL_NOTIFY_FAIL auf 0 gesetzt
// bevor irgendwas anderes gemacht wird
//
// Revision 1.13  1997/12/05 14:22:05  Fiona
// Aliase werden an Snooper extra gemeldet
//
// Revision 1.12  1997/08/25 10:52:34  Fiona
// Verzoegerte Ausgabe von der long abgeschaltet, wenn man einen nicht
// Richtungsbefehl eingegeben hat.
//
// Revision 1.11  1997/06/29 08:27:49  Fiona
// Kleiner Bugfix :_)
//
// Revision 1.10  1997/06/28 22:03:32  Fiona
// Rausfiltern von Zeichen > 127 weil die nicht jeder als das gleiche sieht.
// Aliashandling komplett neu und viiiieeeel schoener ;)
//                            

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <properties.h>
#include <config.h>
#include <defines.h>
#include <wizlevels.h>

#define HIST_SIZE 20

mixed *aliases;
mapping alis;
static string *history;
static int hist_now;
static object last_command_env;
static int last_chg, cmdrate;

private void check_new_alis();
private string do_ali(string cmd);
int __auswerten(string str, string verb);
static int auswerten(mixed cmd, string str);

static void AddHistory(string str) {
  if (!stringp(str) || str=="" || str[0]=='&' || str[0]=='^' || str=="hist"
      || str[0..3]=="ali " || str[0..5]=="unali ")
    return;
  history[ hist_now % HIST_SIZE ] = str;
  hist_now++;
}

void create() {
  history = allocate( HIST_SIZE );
  for (hist_now=0;hist_now<HIST_SIZE;hist_now++) history[hist_now]="\n\n";
  hist_now=0;
  last_chg=0;
  Set(P_LOCALCMDS,({}));
}

static void initialize() {
  if (!pointerp(aliases) || sizeof(aliases)!=2) aliases = ({ ({}), ({}) });
  aliases=order_alist(aliases);
  set_modify_command(this_object());
  add_action("__auswerten","",1);
  check_new_alis();
}

void reconnect() {
  if (!pointerp(aliases) || sizeof(aliases)!=2) aliases = ({ ({}), ({}) });
  aliases=order_alist(aliases);
  set_modify_command(0);
  set_modify_command(this_object());
}

static int show_hist() {
  int i;
  string comm;
  write( "Die History-Liste enthaelt folgende Kommandos:\n" );
  for(i=0; i<HIST_SIZE ; i++ ) {
      comm=history[(hist_now+i) % HIST_SIZE];
      if (comm != "\n\n")
	write(" &"+(hist_now+i-HIST_SIZE)+"/-"+ (HIST_SIZE-i-1)
	      +"\t= " + comm + "\n" );
    }
  return 1;
}

int _query_command_average() {
  int ab;
  ab=absolute_hb_count();
  if (ab-last_chg < 15) return cmdrate;
  last_chg=ab-last_chg;
  if (last_chg > 3000) { // Megaidler
	last_chg=ab;
	cmdrate=0;
  } else {
	for (; last_chg>14; last_chg-=15)
	  cmdrate=(cmdrate*9)/10;
	last_chg=ab-last_chg;
  }
  return cmdrate;
}

mixed modify_command(string str) {
  mixed commLine, input, output;
  string verb, s1, *tmp;
  int nummer, i;
  
  SetProp(P_ACTUAL_NOTIFY_FAIL, 0);
  if (!previous_object()) AddHistory(str);
  (void)_query_command_average();
  cmdrate+=10000;
  last_command_env=environment();
  if (!str) str="";

  // filtering special characters from input
  for (i=strlen(str);i-->0;)
  {
    if(str[i]=='') str[i..i]="Ae";
    else if(str[i]=='') str[i..i]="ae";
    else if(str[i]=='') str[i..i]="Oe";
    else if(str[i]=='') str[i..i]="oe";
    else if(str[i]=='') str[i..i]="Ue";
    else if(str[i]=='') str[i..i]="ue";
    else if(str[i]=='') str[i..i]="ss";
    else if(str[i]=='') str[i..i]="(c)";
    else if(str[i]=='') str[i..i]="(r)";
    else if(str[i]=='') str[i..i]="<<";
    else if(str[i]=='') str[i..i]=">>";
    else if(str[i]=='') str[i..i]="^1";
    else if(str[i]=='') str[i..i]="^2";
    else if(str[i]=='') str[i..i]="^3";
    else if(str[i]=='') str[i..i]="1/4";
    else if(str[i]=='') str[i..i]="1/2";
    else if(str[i]=='') str[i..i]="3/4";
    else if(str[i]<' '||str[i]>127)
      str[i]='?';
  }

  if (str=="\\ESCAPE" && IS_WIZARD(ME))
  {
    __set_environment(ME,"/room/void");
    environment()->init();
    printf("Ihr seid entkommen.\n");
    return "";
  }
  if (str[0..2]=="\\\\\\" && IS_SPECIAL(ME))
  {
    str=do_ali(str);
    tmp=efun::explode(str[3..]," ");
    verb=tmp[0];
    if (verb && verb!="")
    {
      s1=implode(tmp[1..]," ");
      __auswerten(s1,verb);
    } 
    return 1;
  }
  if (str[0]=='\\') 
    return str[1..];
    
  input=0;
  switch (str)
    {
    case "": return 0;
    case "n": input="norden";
              break;
    case "s": input="sueden";
              break;
    case "w": input="westen";
              break;
    case "o": input="osten";
              break;
    case "nw": input="nordwesten";
              break;
    case "sw": input="suedwesten";
              break;
    case "so": input="suedosten";
              break;
    case "no": input="nordosten";
              break;
    case "ob": input="oben";
              break;
    case "u": input="unten";
    }
  if (input || member_array(str, ({"norden","sueden","westen","osten",
      "nordwesten","suedwesten","suedosten","nordosten","oben","unten"}))
      >-1) notify_fail("In diese Richtung koennt Ihr nicht gehen.\n");
  if (input) return input;
  while (remove_call_out("delayed_long")!=-1); // Nicht mehr verzoegert schauen.

  if(str[0]=='&')   /* history auswerten */
    {
      if(sscanf(str, "&-%d", nummer)!=1)
	{
	  if((str == "&&" || str == "&0") && hist_now>0) 
	    /* &&  => letztes Kommando */
	    nummer = 0;
	  else
	    if (sscanf(str, "&%d", nummer)==1)
	      {
		nummer=hist_now-nummer-1;
		if (nummer<-1)
		  {
		    notify_fail("Den Befehl hast Du noch gar nicht eingegeben...\n");
		    return str;
		  }
	      } 
	    else 
	      return str;
	}
      nummer++;
      if( nummer-1 >= HIST_SIZE )
	{
	  notify_fail( "So gross ist die History-Liste doch gar nicht !\n");
	  return str;
	}
      commLine = history[(hist_now+HIST_SIZE-nummer)%HIST_SIZE];
      if (commLine=="\n\n")
	{
	  notify_fail("Dieser Platz in der History-Liste ist noch nicht belegt.\n");
	  return str;
	}
      write( "["+commLine+"]\n" );
      AddHistory(commLine);
      str=commLine;
    }

  /* das caret abfangen */
  if(str[0]=='^') {
      string* oldnew, pre, post;
      oldnew=efun::explode(str, "^")-({""});
      if (sizeof(oldnew)!=2) return str;
      if (sscanf(history[(hist_now-1)%HIST_SIZE], "%s"+oldnew[0]+"%s", pre, post)!=2) return str;
      write("["+pre+oldnew[1]+post+"]\n");
      return modify_command(pre+oldnew[1]+post);
  }
  return do_ali(str);
}

int do_list(string str) {
  string *cmdlist;
  int i;
  if(!this_object()->QueryProp(P_WANTS_TO_LEARN))
    return 0;
  notify_fail("SYNTAX: do <command1>[;<command2>... ]\n");
  if(!str || !strlen(str))
    return 0;
  cmdlist = explode(str,";") - ({ "" });
  for(i=0;i<sizeof(cmdlist);i++) {
      cmdlist[i] = implode( explode(cmdlist[i]," ") - ({}), " " ); 
      write( "["+cmdlist[i]+"]\n" );
      command( cmdlist[i] );
    }
  return 1;
}

object _query_last_command_env() {
  return last_command_env;
}

static int auswerten(mixed cmd, string str) {
  if (closurep(cmd))
    return funcall(cmd,str);
  if (stringp(cmd))
    return call_other(this_object(),cmd,str);
  return 0;
}

static varargs int __auswerten(string str, string verb) 
{
  mixed *cmd, cmds;
  int i,ret,lvl,l,vl;
  
  if(!verb && !verb = query_verb()) 
    return 0;
  lvl=query_wiz_level(ME);
  vl=strlen(verb);
  cmds=QueryProp(P_LOCALCMDS);
  for(i=sizeof(cmds)-1;i>=0;i--)
    {
      cmd=cmds[i];
      l=strlen(cmd[0]);
      if(cmd[0]==verb[0..l-1] && cmd[3]<=lvl && (cmd[2]||vl==l) &&
	 (ret=auswerten(cmd[1],str)))
	return ret;
    }
  return 0;
}

/*
** Alias-Handling
** Aliasse werden in einem Mapping gespeichert:
** alis = ([ aliasname: alias ])
** alias ist dabei genau der String, der als Alias eingegeben wurde.
*/

//falls die aliasliste kaputt ist (Notfun???)
int unalias_all() {
  alis=0;
  return 1;
}

// Diese Fun passt gespeicherte alte Aliasse an neue an.
private void check_new_alis() {
	int i;
	if (!mappingp(alis)) alis=([]);
	if (!pointerp(aliases)) return;
	i=sizeof(aliases[0]);
	if (!i) return;
	for (;i--;) alis+=([ aliases[0][i]: implode(aliases[1][i], " ") ]);
	aliases=0;
	call_out("save_me", 1, 1); // Verzoegert, weil Init noch nicht beendet
}

// Anlegen eines Alis oder Abfragen eines oder aller Alis
static int ali(string str) {
	string str2, *keys, *strs;
	int i;
	if (this_interactive()!=this_object()) return 0;
	if (!str || str=="") { // Anzeigen aller Alis
		keys=m_indices(alis);
		i=sizeof(keys);
		if (i==0) {
			write("Du hast keine Aliases definiert.\n");
			return 1;
		}
		keys=sort_array(keys, #'<);
		str2="";
		for (;i--;)
			str2+=sprintf(" %s\t= %s\n", keys[i], alis[keys[i]]);
		ME->More("Du hast folgende Aliases definiert:\n"+str2);
		return 1;
	}
	keys=explode(str, " ");
	str2=alis[keys[0]];
	if (sizeof(keys)<=1) { // Anschauen eines Alis
		if (!str2) {
			strs=efun::explode(str,"*");
			if (sizeof(strs)>1) { // Wildcard
				if (sizeof(regexplode(str, "[^a-zA-Z0-9*]"))>1) {
					write("Unzulaessiges Zeichen in Suchbegriff.\n");
					return 1;
				}
				str="^"+implode(efun::explode(str,"*"), ".*")+"$";
				keys=regexp(m_indices(alis), str);
				if (!(i=sizeof(keys))) {
					write("Kein passendes Alias gefunden.\n");
					return 1;
				}
				keys=sort_array(keys, #'<);
        		str2="";
        		for (;i--;)
            		str2+=sprintf(" %s\t= %s\n", keys[i], alis[keys[i]]);
        		ME->More("Du hast folgende Aliases definiert:\n"+str2);
        		return 1;
			}
			write("So ein Alias hast Du nicht definiert.\n");
			return 1;
		}
		printf("Das Alias ist folgendermassen definiert:\n%s = %s\n",
			keys[0], str2);
        return 1;
	}
	str=implode(keys[1..], " ");
	if (member_array(keys[0],({"ali","alias","unali","unalias"}))!=-1) {
		write("Solch ein Alias ist zu Deiner Sicherheit verboten.\n");
		return 1;
	}
	i=!IS_LEARNER(ME);
	if (i && strlen(str)>200) {
		write("Das Alias ist zu lang!\n");
		return 1;
	}
	if (str2) { // Aendern eines Alis
		printf("Alias '%s' (%s) wird ueberschrieben:\n", keys[0], str2);
	} else if (i && sizeof(alis)>=100) {
        write("Du hast schon zuviele Aliase definiert.\n");
        return 1;
    }
	printf("Neues Alias: %s = %s\n", keys[0], str);
	alis[keys[0]]=str;
	return 1;
}

// Loechen eines Alis
static int unali(string str) {
	notify_fail("Welches Alias willst Du loeschen?\n");
	if (!str) return 0;
	if (!alis[str]) {
		write( "So ein Alias hast Du nicht definiert.\n" );
		return 1;
	}
	efun::m_delete(alis, str);
	write("Du entfernst das Alias '"+str+"'.\n" );
	return 1;
}

// Das eingegebene cmd wird auf Alis getestet und ggf bearbeitet
private string do_ali(string cmd) {
	string *strs, ali, *stra, *args, ret, x;
	int a, s, i, nr;
	object ob;
	if (!cmd) return 0;
	stra=explode(cmd," ");
	if (!sizeof(stra)) stra=({ cmd });
	ali=alis[stra[0]];
	if (!ali) return implode(stra, " "); // Fuehrende Leerzeichen entfernen
	strs=regexplode(ali, "[&$][0-9]\\*|[&$][0-9*]");
	s=sizeof(stra)-1; // Anzahl Argumente
	a=sizeof(strs); // Anzahl Ersetzungsstellen + 1
	if (a<=1) {
		if (ob=query_snoop(this_object()))
			tell_object(ob, sprintf("%%[Alias: %s]\n", ali));
		return ali;
	}
	ret="";
	for (i=1; i<a; i+=2) {
		nr=strs[i][1]-'0';
		ret+=strs[i-1];
		if (nr>0 && nr<=s) { // Angabe einer Nummer (also nicht &*)
			x=(strs[i][2]=='*' ? implode(stra[nr..], " ") : stra[nr]);
		} else if (nr<=0) { // Also &*
			x=implode(stra[1..], " ");
		} else x="";
		if (x=="") { // Ersetzung mit nichts, hier 'schlau' ersetzen
			if (ret[<1]==' ') ret=ret[0..<2];
		}
		ret+=x;
	}
	ret+=strs[i-1];
	if (ob=query_snoop(this_object()))
		tell_object(ob, sprintf("%%[Alias: %s]\n", ret));
	return ret;
}

static string *_query_localcmds() {
  mixed *l;  
  l=Query(P_LOCALCMDS);
  if(!pointerp(l))
    l=({});
  return ({
    ({"ali","ali",1,0}),
    ({"unali","unali",1,0}),
    ({"hist","show_hist",1,0}),
    ({"do","do_list",0,LEARNER_LVL}),
  })+l;
}
