/*******************
** Eldarea MUDLib **
********************
**
** std/player/connect - Ein- und Ausloggen
**
** CVS DATA
** $Date: 2001/08/21 10:56:33 $
** $Revision: 1.6 $
**
** CVS History
**
** $Log: connect.c,v $
** Revision 1.6  2001/08/21 10:56:33  eldarea
** corrected function prototypes
**
** Revision 1.5  2001/03/12 22:40:36  eldarea
** fixed small bug
**
** Revision 1.4  2000/12/01 16:21:16  elatar
** some new character handling
** obsolet settings removed
** NEWS-messages revised (localhost and wizards special messages, saving of last news message)
** messages rewritten
** login sequence slightly changed
**
** Revision 1.3  2000/01/26 14:49:04  elatar
** info char implemented
**
** Revision 1.2  1999/11/18 11:45:08  elatar
** VOICEMASTER Adaption
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),"DB: "+x+"\n")

inherit "/std/shells/filesys/telnetneg";
inherit "std/living/combat";
inherit "std/player/channel.c";

#include <properties.h>
#include <wizlevels.h>
#include <defines.h>
#include <service.h>
#include <guilds.h>
#include <guildmaster.h>
#include <homes.h>
#include <moving.h>
#include <config.h>
#include <player/forum.h>

#define NEED_PROTOTYPES
#include <thing/properties.h>
#include <thing/description.h>
#include <player/moving.h>
#include <living/attributes.h>
#include <living/skills.h>
#include <living/put_and_get.h>
#include <player/base.h>

mixed *auto_load;   	    /* autoload-array */

static string saved_where;
static int ndead_lasttime;
static object ndead_location;
static string ndead_l_filename;
static int ndead_currently;
static int ndead_next_check;
static mixed env_ndead_info;
static int renewing;

static void ndead_revive();
static void ndead_move_me();
static void show_waitfors();
varargs int quit(string str);
void reconnect(); // player/command
void set_time_to_save(int i); // player/life
void add_soul_commands(); // player/soul

static void load_auto_obj(mixed str);
static void move_player_to_start(string where);

void create() {
  ndead_next_check=NETDEAD_CHECK_TIME;
  ndead_lasttime=0;
  ndead_location=0;
  ndead_l_filename=0;
  ndead_currently=0;
  ndead_next_check=0;
  Set(P_NETDEAD_TIME, SAVE, F_MODE);
  auto_load=({({}),({})});
}

// *** Spielerbefehle ***

// *** Selbstloeschung ***
static int self_delete() {
  write("\nWillst Du das WIRKLICH ? DIESER VORGANG ENTFERNT DICH UNWIDERRUFLICH AUS\n"+
	"DEM MUD; DU MUESSTEST GANZ VON VORN ANFANGEN !\n"+
	"Fallst Du es immer noch willst, gib Dein Password ein.\n\n");
  write("Bitte das Password angeben: ");
  input_to("self_delete2",1);
  return 1;
}

int self_delete2(string str) {
  int ret;
  ret=(int)"secure/master"->delete_player(str, getuid(this_player()));
  if (!ret)
    {
      write("Das hat nicht hingehauen (Gott sei Dank ....)\n");
      return 1;
    }
  write("Adios ! Man sieht sich.\n");
  say(name(WER,1)+" hat sich gerade selbst zerstoert.\n");
  catch(SERVICE->notify_player_remove(getuid(this_player())));
  remove();
  return 1;
}

// *** Ende ***
varargs int quit(string str) {
  int arg;
  if (str) {
    if (!stringp(str) || strlen(str)<2 || str[0]!='/') {
      notify_fail("Es geht nur 'ende' und 'ende /adverb'.\n");
      return 0;
    }
    SetProp("my_inform_text", str[1..]);
  } else SetProp("my_inform_text", 0);

  if (sscanf(getuid(), "gast%d", arg) != 1) {
    if (this_interactive()==ME) {
      save_me(0);
      write("Speichere "+QueryProp(P_NAME)+".\n");
    }
    else save_me(1);
  }
  catch(RemoveChannels());
  if (environment()) catch(environment()->PlayerQuit(ME)); 
  if (catch(ME->remove())) destruct(ME);
  return 1;
}

// *** Speichern ***
int save_character() {
  save_me(1);
  write("Ok.\n");
  return 1;
}

// *** schlaf ein ***
int disconnect(string str)
{
  string verb;
  string adverb, dummy;

  verb=query_verb();
  if (!verb)
    verb="AUTOCALL";
  if (str && (sscanf(str, "ein /%s", adverb)==1 || (sscanf(str, "%s ein%s",
    adverb, dummy)==2 && dummy==""))) {
    str="ein";
    while(adverb[0]==' ') adverb=adverb[1..]; // Fuehrende und folgende ' '
    while(adverb[<1]==' ') adverb=adverb[0..<2]; // wegschneiden (ineffizient)
  } else SetProp("my_inform_text", 0);
  if (verb[0..5]=="schlaf" && str!="ein") {
    notify_fail(break_string(
      "\"schlafe ein\" beendet Deine Verbindung mit "MUDNAME". "
      "Du behaeltst Deine Sachen, aber Vorsicht: Wenn "MUDNAME+
      " abstuerzt, waehrend Du weg bist, verlierst Du "
      "sie doch, genauso, als wenn Du Deine Verbindung mit "
      "\"ende\" beendet haettest (allerdings bekommst Du dann "
      "eine finanzielle Entschaedigung).")+
      "ABER: BENUTZUNG AUF EIGENE GEFAHR!!!\n" );
    return 0;
  }
  if (verb[0..5]=="schlaf" && str=="ein") {
    if (InFight())
    {
      notify_fail("Du kaempfst doch gerade!\n");
      return 0;
    }
    SetProp("my_inform_text", adverb);
    write(break_string(
      "Dieser Befehl beendet Deine Verbindung mit "MUDNAME". "
      "Du behaeltst Deine Sachen, aber Vorsicht: Wenn "MUDNAME+
      " abstuerzt, waehrend Du weg bist, verlierst Du "
      "sie doch, genauso, als wenn Du Deine Verbindung mit "
      "\"ende\" beendet haettest (allerdings bekommst Du dann "
      "eine finanzielle Entschaedigung).")+
      "ABER: BENUTZUNG AUF EIGENE GEFAHR!!!\n" );
    if (member(object_name(environment()), '#')!=-1 &&
        !environment()->QueryProp(P_NETDEAD_INFO))
      write("\n"+break_string(
        "ACHTUNG: Wenn Du hier laenger als ETWA 10 Minuten schlaefst, "
        "kommst Du nicht an diesen Ort zurueck!"));
    say(ME->name(WER)+" hat gerade die Verbindung zu "MUDNAME" gekappt.\n");
    save_me(1);
    remove_interactive(this_object());
    return 1;
  }
}
 
// *** Spielpause ***
static int spielpause(string str) {
  if (str) {
    notify_fail("Nur 'spielpause' bitte. Alles weitere wird dann erfragt.\n");
    return 0;
  }
  write("\nDieser Befehl sperrt Dir den Zugang zum "MUDNAME" fuer "
    "eine von Dir\nfestgelegte Zeit. Damit dieser Befehl nicht missbraucht "
    "wird, musst Du zur\nSicherheit Dein Passwort eingeben.\nGib bitte Dein "
    "Passwort ein: ");
  input_to("spielpause2", 1);
  return 1;
}

static void spielpause2(string str) {
  if (MASTER->update_password(str,str)==0) {
    write("\nFalsches Passwort!\n");
    return;
  }
  write("\nFuer wieviele Tage moechtest Du Deinen Zugang sperren?\n"
    "Gibst Du 0 oder einen negativen Wert ein, wird nicht gesperrt.\n"
    "Anzahl der Sperrtage: ");
  input_to("spielpause3", 1);
}

static void spielpause3(string str) {
  string dummy;
  int num;
  if (!str) str="";
  num=to_int(str);
  if (str!=to_string(num)) {
    write("\nBitte wirklich nur die Tageszahl eingeben.\n");
    return;
  }
  if (num<=0) {
    write("\nOk, keine Sperrung.\n");
    num=0;
  } else write("\nOk. Nach dem Ausloggen kannst Du Dich nun fuer "+num+" Tage "
    "nicht mehr\neinloggen. Hast Du Dich geirrt und willst Die Spielpause "
    "jetzt wieder\naufheben, so benutze den Befehl noch einmal und gib als "
    "Zeitspanne 0 an.\n");
  MASTER->TBanishName(getuid(this_interactive()), num);
}

// Netztoter Spieler wird wieder lebendig
void Reconnect(int silent) {
  int num;
  object *inv;
  string called_from_ip;
  
  startup_telnet_negs();
  enable_commands();
  set_heart_beat(1);
  restart_heart_beats();
  if ((called_from_ip = QueryProp(P_CALLED_FROM_IP)) && 
      query_ip_number() != called_from_ip)
    write("Das letzte Mal kamst Du von " + query_ip_name(called_from_ip) + "\n");
  Set(P_CALLED_FROM_IP, query_ip_number());
  log_file("REENTER", 
	   QueryProp(P_NAME) + ", " + extract(ctime(time()), 4, 15)+ ", "+
           query_ip_name(this_object())+".\n");
  if (QueryProp(P_INVIS)) silent=1;
  if (!silent&&environment()&&file_name(environment())!=NETDEAD_ROOM)
    say(QueryProp(P_NAME)+" weilt wieder unter den Lebenden.\n");
  reconnect(); // in command.c
  catch(SERVICE->notify_player_enter(getuid()));
  show_waitfors();
  this_object()->_set_currentdir(this_object()->_query_currentdir());
  if (num="secure/mailer"->FingerMail(geteuid()))
    write("Ihr habt "+num+" neue"+(num==1 ? " Mail" : " Mails")+".\n");                               
  catch(RegisterChannels());
  if (ndead_currently)
    ndead_revive();
  else if (environment()) ME->_look();
  SetProp("my_inform_text", 0);
  inv=all_inventory(this_object());
  for (num=sizeof(inv)-1;num>=0;num--)
    catch(inv[num]->NetDeadEnvironmentReconnected());
}

// Spieler wird netztot
void NetDead() {
  say("Ploetzlich weicht alles Leben aus "+QueryProp(P_NAME)+".\n");
  if (!ME->QueryProp(P_INVIS)) SetProp(P_NETDEAD_TIME, time());
  catch(RemoveChannels());
  if (environment())
    catch(environment()->BecomesNetDead(ME));
  if (getuid()[0..3]=="gast") quit();
  else HURRIKAP->notify_player_leave(geteuid(ME));
}

// Test ob Spieler nicht mehr/noch lebt bzw eingeloggt ist
void heart_beat() {
  if (!this_object())
    return;
  if (ndead_currently)
    {
      if (interactive(this_object())) ndead_revive();
      else return;
    }
  else
    if (!(ndead_next_check--))
      {
	ndead_next_check=NETDEAD_CHECK_TIME;
	if (!interactive(this_object()))
	  if (ndead_lasttime)
	    {
	      ME->save_me(1);
	      if (IS_LEARNER(this_object()))
		{ 
		  quit();
		  if (this_object())
		    remove();
		  if (this_object())
		    destruct(this_object());
		  return;
		}
	      ndead_move_me();
	    }
	  else
	    ndead_lasttime=1;
      }
  if (this_object() && ndead_lasttime && interactive(this_object()))
    ndead_lasttime=0;
}

// Neueinloggen eines Spielerobjectes. Evt Anlegen eines neuen Savefiles
nomask int start_player(string str, int ren) {
  object shad;
  int newflag;  /* could player be restored? */
  string str1, str2;
  
  startup_telnet_negs();
  modify_prompt();
  str1=explode(file_name(previous_object()),"#")[0];
  if ((str1 != "/secure/login") &&
      (str1 != "/secure/master") &&
      (!geteuid(this_object()) ||
       geteuid(this_object()) != getuid(this_object()) ||
       capitalize(geteuid(this_object())) != str ||
       geteuid(this_object()) != geteuid(previous_object())))
    {
      write("DIESER VERSUCH WAR ILLEGAL !!\n");
      destruct(this_object());
      return 0;
    }
  renewing=ren;
  /* autosave the player after 500 heartbeats */
  set_time_to_save(500);
  /* try to restore player. If it doesn't exist, set the new flag */
  Set(P_WIMPY, 50);
  Set(P_PK_LEVEL,1);
  newflag = !restore_object("/"+SAVEPATH+lower_case(str)[0..0]+"/"
			    +lower_case(str));
  Set(P_WANTS_TO_LEARN,1); // 1 sollte der default sein !!!
  Set(P_WANTS_TO_LEARN,PROTECTED,F_MODE);
  if (Query(P_WANTS_TO_LEARN,F_MODE)&SAVE)
    Set(P_WANTS_TO_LEARN,SAVE,F_MODE); // Dont save any more
  // name und uid koennen nun unterschiedlich sein 
  if (!stringp(str1=Query(P_NAME)) /*|| lower_case(str1)!=lower_case(str)*/)
    Set(P_NAME, str);
  Set(P_NAME, SECURED, F_MODE);
  set_time_to_save(QueryProp(P_AGE)+500);
  restored_create(); /* DO IT HERE AFTER THE RESTORE !! */
  AddId(getuid());
  SetProp(P_AC,0);
  /* Think we dont need this
  // Set some things which wont be set when all is OK 
  SetProp(P_MAX_HP, ((int)QueryAttribute(A_CON))*8+42);

  //Obsolet
  SetProp(P_MAX_SP, ((int)QueryAttribute(A_INT))*8+42);

  //new and good :)
  SetProp(P_MAX_PSP, ((int)QueryAttribute(A_SD))*8+42);
  SetProp(P_MAX_CSP, ((int)QueryAttribute(A_IN))*8+42);
  SetProp(P_MAX_ESP, ((int)QueryAttribute(A_EM))*8+42);
  SetProp(P_MAX_MSP, ((int)QueryAttribute(A_PR))*8+42);*/

  if (!newflag)
  {
    // check for any saved shadow and start it.
    if ( str1=QueryProp(P_AUTOLOAD_SHADOW) 
      && file_size(str1)>-1 
      && shad=clone_object(str1) )
	  shad->StartShadow(this_object());
    auto_load = order_alist( auto_load );
    move_player_to_start(0);
  }
  else
  {
    int arg;
    
    if ( sscanf(getuid(),"gast%d",arg) == 1 ) 
    {
	  SetProp(P_TITLE,"Wanderer zwischen den Welten");
    } 
    else 
    {
      SetProp("my_inform_text","das ERSTE Mal");
    }
    funcall(#'Set, P_LEVEL, -1);
    SetProp(P_CAN_EMOTE, 1);
    SetProp(P_HP, QueryProp(P_MAX_HP));
    if (IS_WIZARD(ME))
	  set_is_wizard(ME,1);
    else
      set_is_wizard(ME,0);
    move_player_to_start(0);
  }
}

static void show_waitfors()
{
  string *waitfors;

  if (!sizeof(QueryProp(P_WAITFOR))) return;

  waitfors = map_array(users()-({0, PL}), lambda(({'x, 'see}),
    ({#'?,
      ({#'||,
        ({#'==, 0, ({#'call_other, 'x, "QueryProp", P_INVIS}) }),
        ({#'==, 1, 'see}) }),
      ({#'getuid, 'x}),
      0
    }) ), IS_LEARNER(ME));

  waitfors = map_array(sort_array(
    (sizeof(QueryProp(P_WAITFOR)) ? QueryProp(P_WAITFOR) : ({})) & waitfors, 
    #'>), #'capitalize);
  if (sizeof(waitfors))
    tell_object(ME, break_string("/std/player/soul"->CountUp(waitfors)+".",
      0, "Anwesende Erwartete: ", BS_FOR_COMM));

}

static int move_player_to_start2(string where) 
{
  int num, *value, dummy;
  string err;
  string called_from_ip;
  string *wert;
  mixed start_place;
  object cmaster;
  mapping m1, m2;
  
  if (QueryProp(P_LEVEL) == -1)
    {
      funcall(#'Set, P_LEVEL, 0);
      if (Query(P_GENDER)==FEMALE)
      {
        if ( sscanf(getuid(),"gast%d",dummy) == 1 )
	  Set(P_TITLE,"Wandererin zwischen den Welten");
        else
          Set(P_TITLE,"");
      }

      funcall(#'Set, P_LEVEL, 1);
    }

  enable_commands();

  set_heart_beat(1);
  command_initialize();
  //AddSkillAction(); Obsolet as obsolet can :)
  add_put_and_get_commands();
  add_soul_commands();
  m1=QueryProp(P_NEWS);
  if (!mappingp(m1))
    m1=([]);
  if ( file_size("/etc/NEWS")
    && m1["/etc/NEWS"]<file_time("/etc/NEWS")
    && (file_time("/etc/NEWS")-time()) < 864000)
  {
    cat("/etc/NEWS");
    m1["/etc/NEWS"]=file_time("/etc/NEWS");
  }
  if ( IS_WIZARD(ME) 
    && file_size("/etc/WIZNEWS")
    && m1["/etc/WIZNEWS"]<file_time("/etc/WIZNEWS")
    && (file_time("/etc/WIZNEWS")-time()) < 864000 )
  {
    cat("/etc/WIZNEWS");
    m1["/etc/WIZNEWS"]=file_time("/etc/WIZNEWS");
  }
  if ( query_ip_number(this_object())==MUD_IP 
    && file_size("/etc/NEWS.localhost")
    && m1["/etc/NEWS.localhost"]<file_time("/etc/NEWS.localhost") 
    && (file_time("/etc/NEWS.localhost")-time()) < 864000)
  {
    cat("/etc/NEWS.localhost");
    m1["/etc/NEWS.localhost"]=file_time("/etc/NEWS.localhost");
  }
  SetProp(P_NEWS,m1);
  if (QueryProp(P_INVIS) && !IS_WIZARD(this_player())) SetProp(P_INVIS,0);
  catch(RegisterChannels());
  if ((called_from_ip = QueryProp(P_CALLED_FROM_IP)) && 
      query_ip_number() != called_from_ip)
    write("Das letzte Mal kamt Ihr von "+query_ip_name(called_from_ip)+"\n");
  funcall(#'Set, P_CALLED_FROM_IP, query_ip_number());
  set_living_name(getuid());
  if (!stringp(QueryPrayRoom()) || QueryPrayRoom()=="") 
    SetDefaultHome(DEFAULT_HOME);
  err=0;
  if (IS_SEER(this_object()) && !IS_LEARNER(this_object()))
    start_place=0; 
  // Da sollte man jetzt den alten Startpunkt setzen
  else
    start_place=0;
  if (!start_place)
    start_place=QueryProp(P_START_HOME);
  if(start_place && 
     (objectp(start_place)||(stringp(start_place)&&start_place!="")))
    {
      if((err=catch(move(start_place ,M_GO|M_SILENT|M_NO_SHOW)))||
	 !environment())
	err=catch(move(QueryPrayRoom(), M_GO|M_SILENT|M_NO_SHOW));
    }
  else 
    err=catch(move(QueryDefaultHome(),M_GO|M_SILENT|M_NO_SHOW));
  if (err) catch(move(DEFAULT_HOME,M_GO|M_SILENT|M_NO_SHOW));
  catch(ME->FinalSetup());
  load_auto_obj(auto_load);
  if (!QueryProp(P_INVIS)) say(name(WER) + " betritt Eldarea.\n");
  else
  {
    if (!IS_LEARNER(this_object())) say("Jemand betritt Eldarea.\n");
    write("IHR SEID UNSICHTBAR!\n\n");
  }
  if (!renewing)
    catch(SERVICE->notify_player_enter(getuid(ME)));
  show_waitfors();

  if (environment())
    write("\n"+environment()->show_long());
  if (num="secure/mailer"->FingerMail(getuid()))
    write("Ihr habt "+num+" neue"+(num==1 ? " Mail" : " Mails")+"\n");
  /* Geld fuer verlorene Sachen...das buggt, und wir brauchen es auch nicht.
  if (QueryProp(P_CARRIED_VALUE)/2 > 0)
  {
    int carried_value;
    carried_value = QueryProp(P_CARRIED_VALUE)/2;
    cmaster = find_object(QueryProp(P_COINMASTER));
    m1 = cmaster->ExchangeValue(carried_value);
    m2 = cmaster->query_coins();
    wert = ({ });
    
    for (value=sort_array((int*)m_indices(m1),#'<);sizeof(value);value=value[1..])
      wert += ({ sprintf("%d %s%s", (num=m1[value[0]][0]), m2[value[0]][(num==1 ? 1 : 2)], (num > 1 ? "n" : "") ) });
    if (sizeof(wert) == 1) wert += ({ "" });
    else wert[0] = sprintf("%s und %s", implode(wert[0..<2], ", "), wert[<1]);
    if ((sizeof(wert) == 2) && (wert[1] == "") && (num == 1)) wert[1] = "den";
    else wert[1] = "die";
    write(break_string(
      "Du findest den Gegenwert von " + wert[0] +", " + wert[1] + " Du beim letzten Mal verloren hast."));
    ME->CMAddMoney(QueryProp(P_COINMASTER),carried_value);
    SetProp(P_CARRIED_VALUE, 0);
  }
  */
  if (IS_WIZARD(getuid(ME)))
    set_is_wizard(ME,1);
  else
    set_is_wizard(ME,0);

}

/*
 * Checks for player terminal:
 */

static void move_player_to_start(string where)
{
  saved_where=where;
  if (QueryProp(P_TTY) == "none")
    {
      write("Waehle einen Terminaltyp (kann spaeter mit <stty> "+
	    "gaendert werden)\n");
      write("vt100, ansi, dumb [dumb] ");
      input_to("gettty", 0);
      move_player_to_start2(saved_where);
      return;
    }
  move_player_to_start2(where);
}

// *** Berechnen des getragenen Wertes ***
static void calculate_value()
{
  int i, carried_value;
  mixed *inv;

  inv=deep_inventory(this_object());
  carried_value=0;
  for (i=0;i<sizeof(inv);i++)
    if (!inv[i]->QueryProp(P_AUTOLOADOBJ))
      carried_value+=inv[i]->QueryProp(P_VALUE);
  SetProp(P_CARRIED_VALUE, carried_value);
}

// *** Speichern des Spielers ***
void save_me(mixed value_items) {
  object *obs;
  mixed val;
  string obnam, dummy;
  int i;
  
  if( getuid()[0..3]=="gast" ) return;
  auto_load = ({ ({}), ({}) });
  obs=deep_inventory(ME);
  for( i=sizeof(obs)-1;i>=0;i--) {
      if( val = obs[i]->QueryProp( P_AUTOLOADOBJ ) )
        auto_load = insert_alist( file_name( obs[i] ), val, auto_load );
  }
  if (value_items) calculate_value();
  else SetProp(P_CARRIED_VALUE, 0);
  save_object("/"+SAVEPATH+getuid()[0..0]+"/" + getuid());
}

// Netztoter wird wieder lebendig
static void ndead_revive()
{
  string fname;
  
  set_heart_beat(1);
  ndead_next_check=NETDEAD_CHECK_TIME;
  ndead_currently=0;
  ndead_lasttime=0;
  if (!objectp(ndead_location))
    if (sizeof(explode(ndead_l_filename,"#"))==1)
      {
	catch(call_other(ndead_l_filename,"???"));
	ndead_location=find_object(ndead_l_filename);
      } 
    else
      {
	ndead_location=find_object(ndead_l_filename);
	if (!ndead_location && env_ndead_info)
	  {
	    fname=explode(ndead_l_filename,"#")[0];
	    call_other(fname,"?");
	    ndead_location=(find_object(fname)->SetProp(P_NETDEAD_INFO,
							env_ndead_info));
	  }
      }		
  if (!ndead_location || catch(move(ndead_location,M_GO|M_SILENT)))
    {
      move(DEFAULT_HOME,M_GO|M_SILENT);
      catch(move(ndead_location,M_GO,"zurueck ins Leben"));
    }
  ndead_location=0;
  ndead_l_filename=0;
  env_ndead_info=0;
}

// Spieler in Netztotraum bewegen
static void ndead_move_me()
{ object *inv;
  int num;

  set_heart_beat(0);
  stop_heart_beats();
  ndead_next_check=NETDEAD_CHECK_TIME;
  ndead_currently=1;
  ndead_lasttime=0;
  ndead_location=environment();
  if (objectp(ndead_location)) {
    ndead_l_filename=file_name(ndead_location);
    if (sizeof(explode(file_name(ndead_location),"#")))
      env_ndead_info=ndead_location->QueryProp(P_NETDEAD_INFO);
    else
      env_ndead_info=0;
  } else env_ndead_info=0;
  disable_commands();
  move(NETDEAD_ROOM, M_GO | M_NO_SHOW | (ndead_location ? 0 : M_SILENT),
    "ins Reich der Netztoten");
  inv = all_inventory(this_object());
  for (num=sizeof(inv)-1;num>=0;num--) 
    catch(inv[num]->EnvironmentBecomesNetDead());  
}

/*
 * autoload objects:
 *
 * autoload objects are stored in an alist, with the info:
 * filename and value
 *
 * if there is not yet an autoload array (auto_load) we use the old
 * mechanism to load any autoload objects.
 */

static void load_auto_obj(mixed str) 
{
  int i;
  mixed *to_load;
  
  /* auto_load may be changed while running */
  /* if one of the object calls SetAutoload */

  if (!str) return;
  if (!pointerp(str[0])) auto_load = ( { ( {} ) , ( {} ) } );
  to_load=( { ( {} ), ( {} ) } );
  for (i=0;i<sizeof(auto_load[0]);i++)
    {
      to_load[0]+=({auto_load[0][i]});
      to_load[1]+=({auto_load[1][i]});
    }
  for (i = 0; i < sizeof(to_load[0]); i++)
    {
      object ob;
      string file;
      string err;
      string gilde;

      file = explode(to_load[0][i],"#")[0]; // alte unique-nummer wegschneiden
      ob = find_object(file);
      if (!ob)
	{
	  if (file_size("/"+file+".c") < 0)
	    continue;
	  err = catch(call_other(file,"dummy"));
	  if (err)
	    continue;
	}
      (void)catch(ob = clone_object(file));

      if(ob && to_load[1][i])
	ob->SetProp( P_AUTOLOADOBJ, to_load[1][i] );

      // Gildenobjekte inaktiver oder fremder Gilden werden gleich 
      // wieder removed (Holger)
      if (ob && (gilde=ob->QueryProp(P_GUILD_OBJECT)) && !IS_LEARNING(ME))
        {
          if (!sizeof(GM->QueryGuild(gilde, GM_TYPE_VALID)) ||
                                        gilde!=ME->QueryProp(P_GUILD))
            {
              ob->remove();
              if (ob) destruct(ob);
              continue;
            }
        }

      catch(ob->move(this_object(),M_NOCHECK));
    }
}

// **** lokale Propertie Methoden ****

static mixed _set_autoload(mixed a) {
  return Set(P_AUTOLOAD, auto_load = a);
}

static string *_query_localcmds() {
  return ({
           ({"quit","quit",0,0}),
           ({"ende","quit",0,0}),
           ({"disconnect","disconnect",0,0}),
           ({"schlaf","disconnect",1,0}),
           ({"spielpause","spielpause",0,0}),
           ({"speichern","save_character",0,0}),
           ({"save","save_character",0,0}),
           ({"selbstloeschung","self_delete",0,0}),
         });
}
