/*******************
** Eldarea MUDLib **
********************
**
** std/player/description.c - player description
**
** CVS DATA
** $Date: 2000/12/01 16:21:33 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.3  2000/12/01 16:21:33  elatar
** some obsolet descriptions removed
**
** Revision 1.2  2000/01/26 14:47:48  elatar
** inherits humanoid/desc. instead of living/desc
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

inherit "/std/humanoid/description";

#define NEED_PROTOTYPES

#include <thing/language.h>
#include <player/description.h>
#include <properties.h>
#include <wizlevels.h>
#include <lightsource.h>
#include <defines.h>
#include <thing/details.h>
#include <combat.h>

#include "/std/sys_debug.h"

static string mein_herzschlag();
static string _set_title(string x);
static string _set_presay(string x);

void create()
{
  ::create();
  Set(P_NAME, -1, F_SET_METHOD);
  Set(P_FULLNAME, -1, F_SET_METHOD);
  Set(P_PLURAL, 0); // benutze alte short()... Bei Gelegenheit umbauen
  Set(P_PRESAY, SAVE, F_MODE_AS);	
  Set(P_TITLE, SAVE, F_MODE_AS);	
//  Set(P_EXTRA_LOOK, SAVE, F_MODE);
  Set(P_TASKS, -1 , F_SET_METHOD);
  Set(P_TASKS, SAVE|SECURED|PROTECTED, F_MODE_AS);
  Set(P_GENDER, SAVE, F_MODE_AS);
  AddSoundDetail(({"herz","herzschlag"}), #'mein_herzschlag);
}

// short() -- get the short description of a player
string short()
{
  string answer;
  string titel, pre;
  mixed *f;
  
  if(QueryProp(P_INVIS)) 
    if (this_interactive() && IS_LEARNING(this_interactive()))
      return "("+this_object()->QueryProp(P_NAME)+") \n";
    else
    {
      if (IS_LEARNER(this_object()))
        return (string)0;
      else
       return "Jemand.\n";
    }

  if(QueryProp(P_GHOST))
    {
      if (QueryProp(P_FROG))
	return "Der Geist eines kleinen Frosches namens "+
	  capitalize(getuid(ME))+
	  ".\n";
      else
	return "Der Geist von "+ME->QueryProp(P_NAME)+".\n";
    }

  pre=QueryProp(P_PRESAY);
  titel=QueryProp(P_TITLE);

  if (QueryProp(P_FROG))
    {
      if (pre) answer = name(WER,1);
      else answer = capitalize(name(WER,0));
      answer += (" namens "+Query(P_NAME));
    }
  else
    answer = ME->QueryProp(P_NAME);

  if (stringp(titel) && strlen(titel)) {
    titel=implode(efun::explode(titel,"\b"), "");
    while(titel[0]==' ') titel=titel[1..];
    if (titel[0]!=',') titel=" "+titel;
  } else titel="";
  if (!interactive(ME)) titel+=" (netztot)";
  if (stringp(pre) && strlen(pre)) {
    pre=implode(efun::explode(pre,"\b"), "");
    while(pre[<1]==' ') pre=pre[0..<2];
    pre+=" ";
  } else pre="";
  return pre+answer+titel+".\n";
}

static string mein_herzschlag() {
  int x;
  string ret;
  x=ME->_query_command_average();
  ret=(ME->QueryProp(P_GENDER)==FEMALE?"Ihr":"Sein")+" Herz ";
  switch (x/1000) {
  case 0..4:
    ret+="schlaegt auffaellig langsam.\n";
    break;
  case 5..9:
    ret+="schlaegt ganz ruhig.\n";
    break;
  case 10..250:
    ret+="schlaegt ruhig und gleichmaessig.\n";
    break;
  case 251..500:
    ret+="schlaegt gleichmaessig.\n";
    break;
  case 501..1000:
    ret+="schlaegt leicht beschleunigt.\n";
    break;
  case 1001..2000:
    ret+="schlaegt aufgeregt.\n";
    break;
  case 2001..3500:
    ret+="schlaegt rasend schnell.\n";
    break;
  case 3501..5000:
    ret+="trommelt wie verrueckt.\n";
    break;
  case 5001..7000:
    ret+="scheint gleich aus der Brust zu springen.\n";
    break;
  default:
    ret+="ist nahe am Infarkt.\n";
    break;
  }
  return ret;
}

private void select(object o, mixed weapon, mixed armour, mixed tools, mixed rest )
{
  if (member(ME->QueryProp(P_ARMOURS), o) != -1) {
    if (member(AT_IS_CLOTHING, o->QueryProp(P_ARMOUR_TYPE))!=-1)
      armour += ({ o });
    else tools += ({ o });
  }
  else if (member(ME->QueryProp(P_WEAPONS), o) != -1) weapon += ({ o });
  else if(sizeof(all_inventory(o)) || o->QueryProp(P_LIGHT) || o->QueryProp(P_LIGHTED))
    tools += ({ o });
  else rest += ({ o });
}

string long() 
{
  string exl, descr, tmp; 
  object ob, *w, *a, *t, *r;
  mixed trans;
  int i;
  
  //trans = ME->QueryProp(P_TRANSPARENT);
  //ME->SetProp(P_TRANSPARENT, 0); 
  descr = ::long();
  //ME->SetProp(P_TRANSPARENT, trans);
  /*
  if (!stringp(descr)||descr=="") 
    descr="Das ist "+capitalize(ME->QueryProp(P_NAME))+".\n";
 
  // extra_looks einsammeln und ggf in die desc einbauen 
  if(stringp(tmp = ME->QueryProp(P_EXTRA_LOOK)))
    descr += break_string(tmp);
  for(ob = first_inventory(ME); ob; ob = next_inventory(ob))
    if(exl = ob->QueryProp(P_EXTRA_LOOK)) descr += exl;
    else if(exl = ob->extra_look()) descr += exl; // TO BE REMOVED
  w = ({}); a = ({}); r = ({}); t = ({});
  map_array(all_inventory(ME), #'select, &w, &a, &t, &r);
  return descr + 
         (ME->QueryProp(P_TRANSPARENT) ?
          break_string(capitalize(ME->name(WER, 1))+" hat "
                      +(sizeof(a)?andlist(a):"keine Kleidung")+" an"
                      +(sizeof(t)?", ":" und ")
                      +(sizeof(w)?andlist(w):"keine Waffe")+" gezueckt"
		      +(sizeof(t)?" und traegt "+andlist(t):"")+
		      "."): "");
  */
  return descr;
}

// Identify ourself - special temp handling for ghosts and i
varargs int id(string str, int lvl) {
  mixed *frog;
  if (::id(str)) return 1;
  if (this_player()==ME && member(({"ich","mich","mir","mein"}), str)!=-1)
    return 1;
  if (Query(P_INVIS) && lvl<QueryProp(P_LEVEL)) 
    return 0;
  if (QueryProp(P_GHOST) && str=="geist von "+getuid()) 
    return 1;
  if ((frog=QueryProp(P_FROG)) && member_array(str, frog[FROG_IDS])>-1) 
    return 1;
}

// alignment value into a string
static string al_to_title(int a) {
  string s;
  if (IS_LEARNER(ME) && QueryProp(P_WANTS_TO_LEARN))
    if(s=(string)QueryProp(P_CHARACTER)) return s;
    else return "magisch";
  if (a > 924) return "heilig";
  if (a > 749) return "gut";
  if (a > 449) return "nett";
  if (a > 124) return "freundlich";
  if (a > - 125) return "neutral";
  if (a > - 450) return "mies";
  if (a > - 750) return "teuflisch";
  if (a > - 925) return "daemonisch";
  return "satanisch";
}

// **** local property methods
static string _query_title()
{
  mixed *f;
  string title;
  if(f=QueryProp(P_FROG))
    {
      if((title=f[FROG_TITLE]) && (title!="")) return title;
      return 0;
    }
  title=Query(P_TITLE);
  if (stringp(title) && strlen(title)) {
    f=efun::explode(title, "\b");
    if (f[0]=="") title="\b"+implode(f,"");
    else title=implode(f,"");
  } else title="";
  return title;
}

static string _query_presay()
{
  mixed *f;
  string presay;
  if(f=QueryProp(P_FROG))
     {
       if((presay=f[FROG_PRESAY]) && (presay!="")) return presay+" ";
       return "";
     }
  presay=Query(P_PRESAY);
  if (stringp(presay)) {
    f=efun::explode(presay, "\b");
    presay=implode(f,"");
    if (presay!="") presay+=" ";
  } else presay="";
  return presay;
}

static string _query_name()
{
  string str;
  str=Query(P_NAME);
  if (str) return capitalize(str);
  return 0;
}

static string _query_sound() {
  mixed x;
  string ret;
  x=ME->Query(P_SOUND);
  if (x) return x;
  return mein_herzschlag();
}

static string _query_fullname()
{
  string p,n,t;
  
  n=Query(P_NAME);
  if (n)
    return _query_presay()+n+" "+_query_title();
  return 0; 
}
