/*******************
** Eldarea MUDLib **
********************
**
** std/player/explore.c - exploration module
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** CVS History
**
** $Log: explore.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>

#include <properties.h>
#include <defines.h>
#include <wizlevels.h>
#include <player/explore.h>

// Der nullte Character von P_EXPLORED wird als Indikator fuer die
// neue Speichermethode mit Bitfields benutzt und ist dort _statisch_
// auf '&'. Um trotzdem unkompliziert programmieren zu koennen hier
// 'korrigierte' Defines, die das Vorhandensein ignorieren.
#define SETBIT(x, y)       set_bit(x, ((y)+6))
#define CLEARBIT(x, y)     clear_bit(x, ((y)+6))
#define TESTBIT(x, y)      test_bit(x, ((y)+6))

private static void old_2_new();

void create() {
  Set(P_EXPLORED, "");
  Set(P_EXPLORED, SAVE, F_MODE);
  Set(P_EXPLORED, PROTECTED|NOSETMETHOD, F_MODE);

  call_out("check_seer_ep",2);
}

void check_seer_ep() {
  int seer_ep;
  old_2_new();
  if ((seer_ep=QueryProp(P_EP_FOR_SEER))<=0 || seer_ep>EXPLOREMASTER->QuerySeerEP())
    Set(P_EP_FOR_SEER, EXPLOREMASTER->QuerySeerEP());
  Set(P_EP_FOR_SEER, PROTECTED|SECURED|NOSETMETHOD, F_MODE);
}

// Funktion auskommentiert, da nie aufgerufen
// void remove() {
//   while(remove_call_out("check_seer_ep")==-1);
// }

/**************************************************************************/
/* Funktion: int GiveEP()                                                 */
/*                                                                        */
/* Diese Funktion wird in den angemeldeten Objekten aufgerufen. Daraufhin */
/* werden die angemeldeten EP vergeben oder auch nicht.                   */
/*                                                                        */
/* Returnwerte:                                                           */
/*   0 --> Verteilung nicht erfolgt                                       */
/*   1 --> Verteilung erfolg                                              */
/**************************************************************************/
int GiveEP() {
  mixed *values, epobjects;
  if(QueryProp(P_TESTPLAYER)) return 0;
  if (!(values=EXPLOREMASTER->QueryEPObject(explode(file_name(previous_object()),"#")[0]))) return 0;
  if (!values[ACTIVE]) return 0;
  CheckEP();
  if (TESTBIT(epobjects=ME->QueryProp(P_EXPLORED), values[NUMBER])) return 0;
  epobjects=SETBIT(epobjects, values[NUMBER]);
  Set(P_EXPLORED,epobjects);
  return 1;
}

/*********************************************************************/
/* Funktion: int SetEP(int)                                          */
/*                                                                   */
/* Diese Funktion ist identisch mit GiveEP(), nur dass sie von einem */
/* Erzmagier oder hoeher aufgerufen werden darf. Hierzu ist kein     */
/* angemeldetes Objekt notwendig.                                    */ 
/*                                                                   */
/* Returnwerte:                                                      */
/*   0 --> Setzen des EP nicht erfolgreich                           */
/*   1 --> Setzen des EP erfolgreich                                 */
/*********************************************************************/
int SetEP(int number) {
  mixed epobjects;
  if (!IS_ARCH(this_interactive())) return 0;
  if (!intp(number)) return 0;
  if (number<0 || number>=EXPLOREMASTER->QueryQuantity()) return 0;
  CheckEP();
  epobjects=ME->QueryProp(P_EXPLORED);
  if (TESTBIT(epobjects, number)) return 0;
  epobjects=SETBIT(epobjects, number);
  Set(P_EXPLORED,epobjects);
  return 1;
}

/********************************************************************/
/* Funktion: int TakeEP(int)                                        */
/*                                                                  */
/* Mit dieser Funktion kann ein Erzmagier oder hoeher einem Spieler */
/* einen gefundenen EP zuruecksetzen.                               */
/*                                                                  */
/* Returnwerte:                                                     */
/*   0 --> Entnahme des EP nicht erfolgreich                        */
/*   1 --> Entnahme des EP erfolgreich                              */
/********************************************************************/
int TakeEP(int number) {
  mixed epobjects;
  if (!IS_ARCH(this_interactive())) return 0;
  if (!intp(number)) return 0;
  if (!(epobjects=ME->QueryProp(P_EXPLORED)) || (epobjects=="")) return 0;
  if (number<0 || number>=EXPLOREMASTER->QueryQuantity()) return 0;
  CheckEP();
  if (!TESTBIT(epobjects, number)) return 0;
  epobjects=CLEARBIT(epobjects, number);
  Set(P_EXPLORED,epobjects);
  return 1;
}

/***********************************************************/
/* Funktion: int QuerySumEP()                              */
/*                                                         */
/* Diese Funktion gibt die Summe der bereits erhaltenen EP */
/* des Spielers zurueck.                                   */
/*                                                         */
/* Returnwert:                                             */
/*   ep --> Anzahl der gesammelten EP                      */
/***********************************************************/
int QuerySumEP() {
  int ep, i;
  mixed *values, epobjects;
  CheckEP();
  if (!(epobjects=ME->QueryProp(P_EXPLORED)) || (epobjects=="")) return 0;
  ep=0;
  for (i=6*(strlen(epobjects)-1); i--;) {
    if (TESTBIT(epobjects, i) && sizeof(values=EXPLOREMASTER->QueryEPNumber(i))
      && values[ACTIVE])
      ep+=values[POINTS];
  }
  return ep;
}

/****************************************************************************/
/* Funktion: void CheckEP()                                                 */
/*                                                                          */
/* In dieser Funktion wird der Bitstring in der Property P_EXPLORED des     */
/* Spielers aufbereitet. Er muss immer genau die richtige Laenge haben.     */
/* Ist er zu kurz, werden Nullen angehaengt (da nur neue Objekte angemeldet */
/* werden koennen und diese dann an die Liste angehaengt werden), ist       */
/* er zu lang, wird er hinten abgeschnitten (sollte sich etwas verschieben, */
/* steht hinten ueberfluessiger Muell).                                     */
/****************************************************************************/
void CheckEP() {
// Nur noch Ueberschuessiges abschneiden
  int i, quantity;
  mixed epobjects;
  old_2_new(); // Besser ist besser ;o)
  quantity=EXPLOREMASTER->QueryQuantity();
  epobjects=ME->QueryProp(P_EXPLORED);
  if (!stringp(epobjects)) epobjects="&";
  if (strlen(epobjects)-1 > quantity/6+1) epobjects=epobjects[0..quantity/6+1];
  for (i=(quantity/6+1)*6; i>quantity; i--)
    epobjects=CLEARBIT(epobjects, i);
  Set(P_EXPLORED,epobjects);
}
  
/***********************************************************************/
/* Funktion: int QueryProcentEP()                                      */
/*                                                                     */
/* Diese Funktion berechnet den prozentualen Anteil der Spieler-EP an  */
/* allen angemeldeten EP.                                              */
/*                                                                     */
/* Returnwerte:                                                        */
/*   procent --> Prozentualer Anteil                                   */
/***********************************************************************/
int QueryProcentEP() {
  int ep, max_ep, procent;
  if (!(max_ep=EXPLOREMASTER->QueryMaxEP())) return 100;
  if (!(ep=QuerySumEP())) return 0;
  procent=(int)(ep*100/max_ep);
  return procent;
}

/***********************************************************************/
/* Funktion: int QueryProcentForSeerEP()                               */
/*                                                                     */
/* Diese Funktion berechnet den prozentualen Anteil der Spieler-EP an  */
/* den benoetigten Prozenten in P_EP_FOR_SEER                          */
/* Aufgerufen wird diese Funktion vor allem in /std/guild.c um ein     */
/* Erhoehen der Stufe zu pruefen.                                      */
/*                                                                     */
/* Returnwerte:                                                        */
/*   procent --> Prozentualer Anteil                                   */
/***********************************************************************/
int QueryProcentForSeerEP() {
  int procent, seer_ep;

  if(!(seer_ep=QueryProp(P_EP_FOR_SEER))) return 100;
  procent = (int)(QuerySumEP() * 100 / seer_ep);
  return procent;
}

// Wandelt altes Speicherverfahren mit '0' und '1' in Bitfields
private static void old_2_new() {
  string old;
  int i;
  old=Query(P_EXPLORED);
  if (stringp(old) && old[0]!='&') { // Kann nie sein bei altem
    string new;
    new="&";
    for (i=strlen(old); i--;) if (old[i]=='1') new=SETBIT(new, i);
    Set(P_EXPLORED, new);
  }
}
