/*******************
** Eldarea MUDLib **
********************
**
** std/player/forum.c - basic forum handling
**
** CVS DATA
** $Date: 2000/12/04 15:24:15 $
** $Revision: 1.1 $
**
** The forums replace the old news system of other muds.
**
** CVS History
**
** $Log: forum.c,v $
** Revision 1.1  2000/12/04 15:24:15  elatar
** initial release
**
**
**
*/

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")
#define SAVE_OPEN(x) "/open/news/"+getuid(x)+".news"
#define NEED_FORUM_PROTOTYPES

#include "/sys/player/forum.h"

#include <properties.h>
#include <ansi.h>
#include <news.h>
#include <wizlevels.h>
#include "/mail/post.h"
#include <defines.h>

#pragma strong_types

inherit NEDIT;

static string active_group,lasttitle,last_group;
static mixed message,last_num;
mixed reference;

void create()
{
  ME->Set(P_NEWS,([]));
  ME->Set(P_NEWS,SAVE,F_MODE_AS);
  ME->Set(P_MAILALIAS,SAVE,F_MODE_AS);
  active_group=STD_GROUP;
}

static int cmd_mail(string str) 
{
  object mailer;
  if (this_interactive()!=this_player()) return 0;
  mailer=clone_object(MAILER);
  mailer->SetOfficeName("Eldarea Emaildienst");
  mailer->do_mail(str);
  return 1;
}

static int cmd_mailalias(string str) 
{
  string mali;
  
  if (!str || str=="")
  {
    if (mali=ME->QueryProp(P_MAILALIAS))
      write("Eure Mails werden an '"+mali+"' weitergeleitet.\n");
    else
      write("Ihr habt kein Mailalias eingerichtet.\n");
  }
  else if (str=="aus" || str=="off" || str=="none")
  {
    if (mali=ME->QueryProp(P_MAILALIAS))
    {
      write("Euer Mailalias '"+mali+"' wurde entfernt.\n");
      ME->SetProp(P_MAILALIAS,0);
    }  
    else
      write("Ihr habt kein Mailalias eingerichtet.\n");
  }
  else
  {
    if (mali=ME->QueryProp(P_MAILALIAS))
    {
      write("Euer bisheriges Mailalias war '"+mali+"'\n"
            "Ab sofort werden Eure Mails an '"+str+"' weitergeleitet.\n");
    }
    else
      write("Ab sofort werden Eure Mails an '"+str+"' weitergeleitet.\n");
    ME->SetProp(P_MAILALIAS,str);
  }
  return 1;
}

static int PostNote(string text)
{
  string sig;

  if (!text)
  {
    write("Abbruch! Nachricht wurde verworfen.\n");
    reference = ({});
    return 1;
  }

  message[M_MESSAGE] = text;
  if (sig = read_file("/players/"+geteuid(this_interactive())+"/.signature")) message[M_MESSAGE] += sig;
  if (!CatchForumError(NEWSSERVER->WriteNote(message), "Dieses Forum hat sich wohl mittlerweile gefuellt. \nDie Nachricht wurde verworfen.\n"))
    return 0;

  write("Die Nachricht wurde veroeffentlicht.\n");
  message = 0; /* Platz sparen! */
  reference = ({});                /* naechste Referenz erst beim naechsten Antworten! */ 
  inform_players(active_group);

  return 1;
}

static int cmdRead(string str)
{
  string s1, orig_group, other_group;

  if (!stringp(str)) 
  {
    write("Welche Nachricht (in welchem Forum) lesen?\n");
    return 1;
  }
  if ((sscanf(str, "nachricht %s in forum %s", s1, other_group) == 2)
   || (sscanf(str, "nachricht %s in %s", s1, other_group) == 2)
   || (sscanf(str, "nr %s in %s", s1, other_group) == 2)
   || (sscanf(str, "%s in %s", s1, other_group) == 2))
  {
    int ret;
    orig_group = active_group;
    if (!(other_group = GetGroupName(other_group)))
      return 1;

    active_group = other_group;
    ret = read(s1);
    active_group = orig_group;
    return ret;
  }
  if (sscanf(str, "forum %s", s1))
    return cmdGroup(s1);
  if (sscanf(str, "nachricht %s", s1)
   || sscanf(str, "nr %s", s1)
   || sscanf(str, "%s", s1))
    return read(s1);
 
  write("Welche Nachricht (in welchem Forum) lesen?\n");
  return 1;
}

static int cmdWrite(string str)
{
  string *tmp, r_name;  

  if (!this_interactive() || (str && !stringp(str))) 
    return 0;
  if (!CatchForumError(NEWSSERVER->AskAllowedWrite(active_group), "Das Forum ist bereits voll."))
    return 1;

  if (str && (sizeof(tmp = efun::explode(str, " ")) > 1) &&
      stringp(r_name = GetGroupName(tmp[0], 0, 1)))
  {
    active_group = r_name;
    str = efun::implode(tmp[1..], " ");
  }

  write("Neue Nachricht in Forum " + active_group+".\n");
  write_title(str);

  return 1;

}

static int cmdForum(string str)
{
  return read(str);        
}

static int read(string str)
{
  int num;
  mixed *messages;

  if (!stringp(str) || (sscanf(str, "%d", num) != 1) || (num < 1))
  {
    notify_fail("Welche Nachricht moechtet Ihr lesen?\n");
    return 0;
  }

  --num;
  messages = (NEWSSERVER->GetNotes(active_group));
  if (!pointerp(messages) || (sizeof(messages) <= num))
  {
    notify_fail("So viele Nachrichten sind nicht da.\n");
    return 0;
  }

  lasttitle = messages[num][M_TITLE];
  last_num = num;      /* merke die Nummer des letztgelesenen Artikels */
  last_group = active_group;  /* merke letzte Gruppe, in der gelesen wurde */
  this_player()->More(Message2string(messages[num], sizeof(messages)));

  return 1;
}

static string Message2string(mixed msg, int anzahl)
{
  string str,moves;
  string * ref;
  int num,i;

  str=sprintf(
    "+----------------------------------------------------------------------------+\n"
    "| %:74-s |\n"
    "+----------------------------------------------------------------------------+\n"
    "| %:74-s |\n"
    "| %:74-s |\n"
    ,sprintf("Forum %s (Nachricht %d von %d)",msg[0],last_num+1,anzahl)
    ,sprintf("Thema: %s",msg[M_TITLE])
    ,sprintf("Autor: %s  Datum %s",msg[M_WRITER],dtime(msg[M_TIME])) );
  if (sizeof(msg)>M_REFERENCE && msg[M_REFERENCE]!=0 && msg[M_REFERENCE]!="")
  {
    if (stringp(msg[M_REFERENCE]))
    {
      ref=explode(msg[M_REFERENCE],":");
      if (sizeof(ref)==3)
      {
        num=NEWSSERVER->GetNumber((int)ref[1], ref[2], ref[0]);
        str+=sprintf("| %:74-s |\n",sprintf("(Bezug: Nachricht %s in '%s' von %s)"
                     ,(num ? (string)num : "(geloescht?)"),ref[2],ref[0]));
      }
    }
    else if (pointerp(msg[M_REFERENCE]) && sizeof(msg[M_REFERENCE]))
    {
      moves="";
      for (i=0;i<sizeof(msg[M_REFERENCE]);i++)
      {
        if (msg[M_REFERENCE][i][M_REF_ID]==1) //reply
        {
          num=NEWSSERVER->GetNumber(msg[M_REFERENCE][i][M_REF_TIME]
                                   ,msg[M_REFERENCE][i][M_REF_GROUP]
                                   ,msg[M_REFERENCE][i][M_REF_WRITER]);
          str+=sprintf("| %:74-s |\n",sprintf("Bezug: Nachricht %s in '%s' von %s"
                                    ,(num ? (string)num : "(geloescht?)")
                                    ,msg[M_REFERENCE][i][M_REF_GROUP]
                                    ,msg[M_REFERENCE][i][M_REF_WRITER]));
        }
        else // move
        {
          moves+=sprintf("| %:74-s |\n",sprintf("[Verlegt aus '%s', Autor %s, %s]"
                         ,msg[M_REFERENCE][i][M_REF_GROUP]
                         ,msg[M_REFERENCE][i][M_REF_WRITER]
                         ,dtime(msg[M_REFERENCE][i][M_REF_TIME])));
        }
      }
      str+=moves;
    }
  }
  str+="+----------------------------------------------------------------------------+\n"
       "\n"
       +msg[M_MESSAGE]+"\n"
       "+----------------------------------------------------------------------------+\n";

  return str;
}

static int write_title(string str)
{
  if (str && str == "~q")
  {
    write("Abgebrochen.\n");
    return 1;
  }

  if (!str)
  {
    write("Titel der Nachricht (Abbruch mit ~q): ");
    input_to("write_title");
    return 1;
  }

  message = allocate(7);
  message[M_BOARD] = active_group;
  message[M_TITLE] = str;
  message[M_MESSAGE] = "";
  message[M_REFERENCE] = reference;
  write("Titel ist: " + str + ".\nGebt jetzt Euren Text ein,\n"
    "** oder . wenn Ihr fertig seid, ~q zum Abbrechen, ~h fuer eine Hilfsseite.\n");
  nedit("PostNote");

  return 1;
}

static varargs string GetGroupName(mixed g, mixed groups, int silent)
{
  mixed *tmp, *g_tmp;
  int i, j, num;

  if (!g) return 0;
  if (!groups) groups = NEWSSERVER->GetGroups();

  // hat der Spieler eine Nummer angeben? -> passende Rubrik raussuchen
  if (intp(i = g) || sscanf(g, "%d", i))
  {
    if (i > 0 && i <= sizeof(groups)) return groups[i-1];
    if (!silent)
      write("Ein Forum mit der Nummer " + i + " gibt es leider nicht.\n");
    return 0;
  }

  g=lower_case(g);
  switch(g)
  {
    case "++":
      return groups[<1];
      break;
    case "+":
      return groups[(member(groups,active_group)+1)%sizeof(groups)];
      break;
    case ".":
      return active_group;
      break;
    case "-":
      return groups[(member(groups,active_group)-1+sizeof(groups))%sizeof(groups)];
      break;
    case "--":
      return groups[0];
      break;
  }

  // Gibt es bereits eine Rubrik mit dem gesuchten Namen?
  if (member_array(g, groups) != -1) return g;

  // Gruppen mit gleicher Anzahl von Punkten wie die gewollte Rubrik 
  // rausfinden
  tmp = filter_array(groups, lambda(({'x, 'y}),
          ({#'==, 'y, ({#'sizeof, ({#'efun::explode, 'x, "."}) }) }) ), 
          num = sizeof(g_tmp = efun::explode(g, ".")));

  i = -1;
  // Nach und nach die einzelnen (durch . getrennten) Segmente der 
  // Rubriknamen durchsuchen und auf Gleichheit mit gegebenem String
  // filtern
  while (sizeof(tmp) && (++i < num))
    tmp = filter_array(tmp, lambda(({'x, 'y, 'len, 'i}),
            ({#'==, ({#'[..], ({#'[, ({#'efun::explode, 'x, "."}), 'i}),
                    0, 'len}) , 'y}) ), g_tmp[i], strlen(g_tmp[i])-1, i);

  if (sizeof(tmp) > 1)
  {
    if (!silent)
      write("Es gibt mehrere Foren, auf die dieses Namensmuster "
            "passt.\n");
    return 0;
  }

  if (!sizeof(tmp))
  {
    if (!silent)
      write("Ein Forum '" + g + "' gibt es leider nicht.\n");
    return 0;
  }

  return tmp[0];
}

static int CatchForumError(int err, string txt)
{
  switch (err)
  {
    case 1:
      return 1;
    case -1:
      write("Ihr duerft in diesem Forum nicht schreiben.\n");
      break;
    case -2:
      write("Seltsam, dieses Forum scheint es nicht zu geben.\n");
      break;
    case -3:
      write(txt+"\n");
      break;
    default:
      write("Fehler in den Foren "+err+", bitte benachrichtigt einen Avatar.\n");
  }

  return 0;
}

static int cmdGroup(string str)
{
  int anz;
  mixed *messages;

  if (!str || str == 0)
  {
    if (active_group)
    {
      write("Zur Zeit habt Ihr das Forum '" + active_group + "' aufgeschlagen.\n");
      return 1;
    }
    write("Welches Forum?\n");
    return 1;
  }

  if (!(str = GetGroupName(str))) 
    return 1;
  messages = NEWSSERVER->GetNotes(active_group = str);
  if (pointerp(messages))
    anz = sizeof(messages);
  else
    anz = 0;

  write("Ihr schlagt das Forum '" + active_group + "' mit " + anz + " Nachricht" + (anz == 1 ? "" : "en") + " auf.\n");
  return 1;
}

static int adm_forum(string str)
{
  string arg;

  if (sscanf(str,"info %s",arg)==1)
  {
    mixed info;
 
    if (!(arg=GetGroupName(arg)))   
      return 1;
    info=NEWSSERVER->GetBoardInfo(arg,1);
    if (!pointerp(info))
    {
      switch (info)
      {
        case 0:
          write("USAGE: fadm forum info <forum>");
          break;
        case -1:
          write("Zugriff verweigert.\n");
          break;
        case -2:
          write("Das Forum existiert nicht.\n");
          break;
        default:
          if (!pointerp(info))
          {
            write("Fehler beim Auslesen der Daten.\n");
            return 1;
          }
      }
    }
    else
    {
      printf("Daten des Forums '%s':\n"
             "Eigner:     %s\n"
             "Savefile:   %s\n"
             "Readlevel:  %d\n"
             "Readers:    %s\n"
             "Writelevel: %d\n"
             "Writers:    %s\n"
             "Deletelevel:%d\n"
             "Deleters:   %s\n"
             "Messages    %d\n"
             "MaxMessages:%d\n"
             "Expire:     %d\n"
             ,info[G_NAME]
             ,info[G_OWNER]
             ,info[G_SAVEFILE]
             ,info[G_RLEVEL]
             ,list_words(info[G_READERS])||""
             ,info[G_WLEVEL]
             ,list_words(info[G_WRITERS])||""
             ,info[G_DLEVEL]
             ,list_words(info[G_DELETERS])||""
             ,info[G_MESSAGES]
             ,info[G_MAX_MSG]
             ,info[G_EXPIRE]);    
    }
    return 1;
  }
  if (sscanf(str,"add %s",arg)==1)
  {
    string name,owner;

    if (sscanf(arg,"%s %s",name,owner)!=2)
    {
      write("USAGE: fadm forum add <forum> <eigner>\n");
      return 1;
    }
    switch(NEWSSERVER->AddGroup(name,owner))
    {
      case 1:
        write("Das Forum "+name+" wurde angelegt.\n");
        break;
      case 0:
        write("USAGE: fadm forum add <forum> <eigner>\n");
        break;
      case -1:
        write("Nur Avatare von mindestens 3. Kreis duerfen Foren anlegen.\n");
        break;
      case -2:
        write("Das Forum "+name+" existiert bereits.\n");
        break;
      case -3:
        write("Es wurde kein gueltiger Eigner angegeben.\n");
        break;
      case -4:
        write("Das Savefile existiert bereits.\n");
        break;
    }
    return 1;
  }
  if (sscanf(str,"del %s",arg)==1)
  {
    if (!(arg=GetGroupName(arg)))   
      return 1;
    switch(NEWSSERVER->RemoveGroup(arg))
    {
      case 1:
        write("Das Forum "+arg+" wurde geloescht.\n");
        break;
      case 0:
        write("USAGE: fadm forum del <forum>\n");
        break;
      case -1:
        write("Nur Avatare von mindestens 3. Kreis duerfen Foren loeschen.\n");
        break;
      case -2:
        write("Das Forum "+arg+" existiert nicht.\n");
        break;
    }
    return 1;
  }
  if (sscanf(str,"set %s",arg)==1)
  {
    string name;
    int wlevel,dlevel,rlevel,maxmsg,expire;

    if (sscanf(arg,"%s %d %d %d %d %d %d",
               name,dlevel,wlevel,rlevel,maxmsg,expire)!=6)
    {
      write("USAGE: fadm forum set <forum> <dlvl> <wlvl> <rlvl> <maxmsg> <expire>\n");
      return 1;
    }
    if (!(name=GetGroupName(name)))   
      return 1;
    switch(NEWSSERVER->SetGroup(name,dlevel,wlevel,rlevel,maxmsg,expire))
    {
      case 1:
        write(sprintf("Neue Konfiguration von Forum %s:\n"
                      "Loeschen ab Level:   %d\n"
                      "Schreiben ab Level:  %d\n"
                      "Lesen ab Level:      %d\n"
                      "Maximum Nachrichten: %d\n"
                      "Expire-Zeit:         %d\n",
                      name,dlevel,wlevel,rlevel,maxmsg,expire));
        break;
      case 0:
        write("USAGE: fadm forum set <forum> <dlvl> <wlvl> <rlvl> <maxmsg> <expire>\n");
        break;
      case -1:
        write("Nur der Eigner und Avatare von mindestens 3. Kreis duerfen die Einstellungen aendern.\n");
        break;
      case -2:
        write("Das Forum "+name+" existiert nicht.\n");
        break;
    }
    return 1;
  }
  if (sscanf(str,"user %s",arg)==1)
  {
    string cmd,users,name,opt,user;
    string * names,*r,*w,*d;
    int ret,i;
 
    if (sscanf(arg,"%s %s %s %s",name,cmd,opt,users)==4 && (cmd=="add" || cmd=="del"))
    {
      if (!(name=GetGroupName(name)))   
        return 1;
      names=explode(users,",");
      for (i=sizeof(names);i-->0;)
        sscanf(names[i],"%t%s%t",names[i]);

      if (-1!=strstr(opt,"d"))
        d=names;
      if (-1!=strstr(opt,"r"))
        r=names;
      if (-1!=strstr(opt,"w"))
        w=names;
        
      if (cmd=="del")
        ret=NEWSSERVER->RemoveAllowed(name,d,w,r);
      else
        ret=NEWSSERVER->AddAllowed(name,d,w,r);
      switch(ret)
      {
      case 0:
        write("USAGE: fadm forum user <forum> <add|del> <d|w|r*> <Name[,Name,...]>\n");
        break;
      case 1:
        write("Einstellungen wurden erfolgreich geaendert.\n");
        break;
      case -1:
        write("Nur der Eigner und Avatare von mindestens 3. Kreis duerfen die Einstellungen aendern.\n");
        break;
      case -2:
        write("Das Forum "+name+" existiert nicht.\n");
        break;

      }
    }
    else
      write("USAGE: fadm forum user <forum> <add|del> <d|w|r*> <Name[,Name,...]>\n");
    return 1;
  }
  write("fadm: Unbekannter Befehl. Bitte 'hilfe fadm' beachten.\n");
  return 1;
}

static int cmdAdm(string str)
{
  string args;
  
  if (!IS_LEARNER(ME))
    return 0;

  if (stringp(str) && sscanf(str,"forum %s",args)==1)
    return adm_forum(args);
  if (str=="stat" || str=="statistics" || str=="statistik")
  {
    write(NEWSSERVER->GetStatistics());
    return 1;
  }
  write("USAGE: 'fadm forum ...|stat'\n");
  return 1;
}

static void inform_players(string rub) 
{
  object *pls;
  string *waitfor, cap_name, low_name, rubrik;
  int i;
  
  if (this_player()->QueryProp(P_INVIS)) 
    return;
  pls=users()-({ this_player() });
  rubrik=/*basis2text(*/rub/*)*/;
  low_name=getuid(this_player());
  cap_name=this_player()->name();
  if (lower_case(cap_name)!=low_name)
    cap_name=low_name;
  cap_name=capitalize(cap_name);
  for (i=sizeof(pls); i--;) 
  {
    if (NEWSSERVER->AskAllowedRead(rub,pls[i])>0) 
    {
      waitfor=pls[i]->QueryProp(P_WAITFOR);
      if (pointerp(waitfor) && member(waitfor, "foren")==-1) 
        continue;
      pls[i]->Message(break_string(cap_name+" hat eine Nachricht im " 
                      "Forum '"+rubrik+"' veroeffentlicht.",BS_STDLEN),
                      "foren");
    }
  }
}

static int cmdDelete(string str)
{
  int num;
  
  if (!str || sscanf(str, "nachricht %d", num) != 1 || num <= 0)
  {
    write("Welche Nachricht moechtet Ihr loeschen?\n");
    return 1;
  }
  
  --num;
  switch (NEWSSERVER->RemoveNote(active_group, num))
  {
    case 1:
      write("Forum: " + active_group + ", Nachricht " + (num+1) + " geloescht.\n");
      break;
    case -1:
      write("Das duerft Ihr nicht.\n");
      break;
    case -3:
      write("So viele Nachrichten sind nicht da.\n");
      break;
    default:
      write("Interner Fehler. Bitte Avatar verstaendigen!\n");
  }  

  return 1;
}

static int cmdContent(string str)
{
  int anz, i;
  string *gruppen, s, mode, head;
  mixed msg;

  mode = "";
  if (str && sscanf(str, "%s %s", mode, str) == 2)
  {
    if (mode != "-r")
    {
      write("Die Option '" + mode + "' ist ungueltig.\n");
      return 1;
    }
  }

  if (str == "neu" || str == "neues")
  {
    return cmdNext("liste");
  }

  if (str == "-r")
  {
    mode = "-r";
    str = "";
  }

  if (!str || str == "")
    str = active_group;
  else
    str = GetGroupName(str);

  if (!str) 
  {
    write("Dieses Forum gibt es nicht.\n");
    return 1;
  }

  msg = NEWSSERVER->GetNotes(str);
  head=sprintf("+----------------------------------------------------------------------------+\n"
               "| %:74-s |\n"
               "+----------------------------------------------------------------------------+\n"
               ,"Inhalt des Forums '" + str + "'");
  if (!pointerp(msg) || !(anz = sizeof(msg)))
  {
    write(head+
          "Zur Zeit befinden sich keine Nachrichten in diesem Forum.\n"
          "+----------------------------------------------------------------------------+\n");
    return 1;
  }

  /*head += sprintf("Zur Zeit befinde%c sich %s Artikel in der Rubrik:\n\n", (anz == 1 ? 't' : 'n'), (anz == 1 ? "ein" : to_string(anz)));*/

  s = "";
  for (i = 0; i < anz; ++i)
  {
    if (mode == "")
    {
      s = s + sprintf("%2d. %-50s (%-11s) %s\n", i+1, msg[i][M_TITLE], msg[i][M_WRITER], dtime(msg[i][M_TIME])[4..11]);
    }
    else
    {
      s = sprintf("%2d. %-50s (%-11s) %s\n", i+1, msg[i][M_TITLE], msg[i][M_WRITER], dtime(msg[i][M_TIME])[4..11]) + s;
    }
  }

  s=head+s+"+----------------------------------------------------------------------------+\n";
  this_player()->More(s);

  return 1;
}

static int cmdNext(string str)
{
  string *groups;
  mixed *messages;
  int curgr, curmsg, timeout, start, nrgroups, sog, mode;
  mapping read_until;
        
  groups = NEWSSERVER->GetGroups();
  if (!(nrgroups = sizeof(groups)))
  {
    write("Es gibt keine Foren, die Ihr lesen koenntet.\n");
    return 1;
  }

  if (str && (sscanf(str, "%d", curgr) || (curgr = member_array(str, groups) + 1)))
  {
    --curgr;
    if (curgr < 0 || curgr >= sizeof(groups))
    {
      write("Dieses Forum gibt es leider nicht.\n");
      return 1;
    }

    active_group = groups[curgr];
    start = curgr + 1;
    mode = M_READGR;
    printf("+----------------------------------------------------------------------------+\n"
           "| %:74-s |\n"
           "+----------------------------------------------------------------------------+\n"
           ,sprintf("Forum %d: %s", curgr+1, active_group));
  }
  else
  {
    switch (str)
	{
      case 0:
        mode = M_READNEXT;
        break;
      case "liste":
        mode = M_LISTNEW;
        write("+----------------------------------------------------------------------------+\n"
              "| Liste der ungelesenen Nachrichten:                                         |\n"
              "+----------------------------------------------------------------------------+\n");
        break;
      case "foren":
        return cmdGroups("neu");
      default:
        write("USAGE: f[n[eu]] [liste|foren|<forum nr>]\n");
        return 1;
    }

    curgr = member_array(active_group, groups);
    start = curgr + nrgroups;
  }
  read_until=ME->QueryProp(P_NEWS);
  timeout = read_until[active_group];
  messages = NEWSSERVER->GetNotes(active_group);
  curmsg = 0;
  if (pointerp(messages))
    sog = sizeof(messages);
  else
    sog = 0;

  while (curgr < start)
  {
    ++curmsg;
    if (curmsg > sog)
    {
      ++curgr;
      if (mode != M_READGR)
      {
        active_group = groups[curgr%nrgroups];
        timeout = read_until[active_group];
        if (timeout < 0 || timeout >= NEWSSERVER->GetNewsTime(active_group))
        {
          sog = 0;    /* Ueberlistung: Gruppe hat nix neues oder */
          curmsg = 1; /* ist unsubscribed */
        }
        else
        {
          messages = NEWSSERVER->GetNotes(active_group);
          curmsg = 0;
          if (pointerp(messages))
            sog = sizeof(messages);
          else
            sog = 0;
        }
      }
    }
    else
    {
      if ((timeout >= 0 || mode == M_READGR) && messages[curmsg-1][M_TIME] > abs(timeout))
      {
        if (mode==M_LISTNEW)
        {
          write(sprintf("  %-45s (%-12s) %s\n", messages[curmsg-1][M_TITLE],
                messages[curmsg-1][M_WRITER], dtime(messages[curmsg-1][M_TIME])[4..15]));
        }
        else
        { /* mode == M_READNEXT || mode == M_READGR */
          if (timeout >= 0)
            read_until[active_group] = messages[curmsg-1][M_TIME];
          else
            read_until[active_group] =- messages[curmsg-1][M_TIME];
          ME->SetProp(P_NEWS,read_until);
          return (cmdRead(sprintf("nachricht %d",curmsg)));
        }
     }
     /* sonst mach einfach gar nix. Schleife laeuft weiter. */
    }
  }

  switch (mode)
  {
    case M_READNEXT:
      write("Ihr findet keine neuen Nachrichten.\n");
      break;
    case M_LISTNEW:
      write("+----------------------------------------------------------------------------+\n");
      break;
    case M_READGR:
      write("Es gibt keine neuen Nachrichten in diesem Forum.\n");
      break;
  }

  return 1;
}

static int cmdReply(string str)
{
  int num,refnum;
  string title,refgroup,*oldref;
  mixed *messages;

  if ( str 
    && ( sscanf(lower_case(str),"auf nachricht %d",refnum)==1 
      || sscanf(lower_case(str),"auf nachricht %d in forum %s",
                refnum,refgroup)==2 ) )
  {
    if (refgroup && !(refgroup = GetGroupName(refgroup) ))
      return 1;
    else 
      refgroup=last_group;
    messages = NEWSSERVER->GetNotes(refgroup);
    if (!pointerp(messages) || sizeof(messages)==0)
    {
      write("Das Forum enthaelt keine Nachrichten, auf die Ihr antworten koenntet.\n");
      return 1;    
    }
    if (refnum<1 || refnum>sizeof(messages))
    {
      write("Eine Nachricht mit der Nummer "+refnum+" enthaelt das Forum nicht.\n");
      return 1;    
    }
  }
  else 
  {
    if (str)
      title=str;      
    refnum=last_num;
    refgroup=last_group;
  }

  if (!lasttitle || lasttitle == "")
  {
    write("Ihr habt noch keine Nachricht gelesen, auf die Ihr antworten koenntet.\n");
    return 1;
  }

//  newsgroup = last_group; /* falls der Artikel in der gleichen Rubrik sein soll */

  if(!CatchForumError(NEWSSERVER->AskAllowedWrite(active_group),
     "Dieses Forum ist leider schon voll."))
  return 1;

  DB(sprintf("%O %O",refnum,refgroup));
  oldref = explode(NEWSSERVER->GetReference(refnum, refgroup),":");
  if (sizeof(oldref)==3)
    reference=({({1,oldref[0],oldref[1],oldref[2]})});

  if (title)
    return write_title(title);

  if ((lasttitle[0..3] == "Re: " && (num = 1, title = lasttitle[2..]))
      || sscanf(lasttitle, "Re^%d%s", num, title) == 2)
    return write_title("Re^" + (num+1) + title);

  return write_title("Re: " + lasttitle);        
}

static int cmdSubscribe(string str)
{
  int timeout;
  mapping read_until;
  string group;

  if (!stringp(str)) 
  {
    write("Welches Forum moechtet Ihr (ab-)bestellen?\n");
    return 1;
  }
  if (sscanf(str,"%s ab",group)==1)
    return Unsubscribe(group);
  if (!(str = GetGroupName(str))) 
    return 1;
  read_until=ME->QueryProp(P_NEWS);
  timeout = read_until[str];
  if (timeout >= 0)
  {
    write("Dieses Forum habt Ihr doch schon bestellt.\n");
    return 1;
  }
  read_until[str] = abs(timeout);
  write("Forum " + str + " bestellt.\n");
  ME->SetProp(P_NEWS,read_until);
  
  return 1;
}

static int Unsubscribe(string str)
{
  int timeout;
  mapping read_until;
  
  if (!(str = GetGroupName(str)))
    return 1;
  read_until=ME->QueryProp(P_NEWS);
  timeout = read_until[str];
  if (timeout < 0)
  {
    write("Das Forum habt Ihr gar nicht bestellt.\n");
    return 1;
  }
  read_until[str] = (timeout ? -timeout : -1);
  write("Forum " + str + " abbestellt.\n");
  ME->SetProp(P_NEWS,read_until);

  return 1;
}

static int cmdGroups(string str)
{
  mixed *gruppen, *messages;
  mixed news;
  int anz, i, lasttime, timeout;
  string s;
  mapping read_until;
  
  gruppen = NEWSSERVER->GetGroups();
  anz = sizeof(gruppen);
  if (!anz)
  {
    write("Es gibt zur Zeit keine Foren (wie seltsam ...)\n");
    return 1;
  }

  if (str == "neu")
    s = "Liste der Foren mit neuen Nachrichten:";
  else
    s = sprintf("Es gibt zur Zeit %d For%s",anz,anz==1?"um":"en");
  s = sprintf(
        "+----------------------------------------------------------------------------+\n"
        "| %:74-s |\n"
        "| (* oder x enthaelt neue Nachrichten, x oder - ist abbestellt)              |\n"
        "+----------------------------------------------------------------------------+\n\n"
        ,s);

  read_until=ME->QueryProp(P_NEWS);
  for (i = 0; i < anz; ++i)
  {
    timeout = read_until[gruppen[i]];
    messages = NEWSSERVER->GetNotes(gruppen[i]);
    if (!messages || !sizeof(messages))
      lasttime = 0;
    else
      lasttime = messages[sizeof(messages)-1][M_TIME];

    if (str != "neu" || lasttime > abs(timeout))
    {
      s += sprintf("%:1s %:1s %:3d\. %-35.35s: %3d Nachricht%s (%s)\n",
           ((gruppen[i] == active_group) ? ">" : " "),
           ( lasttime>abs(timeout) ? (timeout<0?"x":"*") :(timeout<0?"-":" ")),
           i+1,
           gruppen[i],
           sizeof(messages),
           ((sizeof(messages) == 1) ? ".  " : "en."),
           (lasttime ? dtime(lasttime)[5..16] : "  - leer -  "));
    }
  }
  s+="\n+----------------------------------------------------------------------------+\n";
  this_player()->More(s);

  return 1;
}

static int cmdMove(string str)
{
  int num;
  mixed msg;
  string gr;

  if (!stringp(str) || sscanf(str, "nachricht %d nach %s", num, gr) != 2)
  {
    write("USAGE: fv[erschiebe|erlege] nachricht <nr> nach <forum>\n");
    return 1;
  }

  if (!(gr = GetGroupName(gr))) 
    return 1;
  if (!(CatchForumError(NEWSSERVER->AskAllowedWrite(gr), "Das Forum ist leider voll.\n")))
    return 1;

  --num;
  msg = (NEWSSERVER->GetNotes(active_group));
  if (!pointerp(msg) || (sizeof(msg) <= num))
  {
    write("So viele Nachrichten sind nicht da.\n");
    return 1;
  }

  msg = msg[num];
  if (geteuid(this_interactive()) != lower_case(msg[M_WRITER]))
  {
    if (!IS_WIZARD(this_interactive()))
    {
      write("Ihr duerft nur Eure eigenen Nachrichten verlegen.\n");
      return 1;
    }
    write("Warnung: Das war nicht Eure eigene Nachricht!\n");
  }
  if (!CatchForumError(NEWSSERVER->RemoveNote(active_group, num), "Dieser Fehler kann eigentlich nicht auftreten"))
    write("Warnung: Nachricht konnte an alter Position nicht geloescht werden!\n");
  else
    write("Nachricht aus Forum " + active_group + " entfernt.\n");

  if (pointerp(msg[M_REFERENCE]))
    msg[M_REFERENCE]+=({({2,msg[M_WRITER],msg[M_TIME],msg[M_BOARD]})});
  //msg[M_MESSAGE] = "[Verlegt aus '" + msg[M_BOARD] + "', Original von " + msg[M_WRITER] + ", " + dtime(msg[M_TIME])[5..26]+"]:\n" + msg[M_MESSAGE];
  msg[M_BOARD] = gr;
  NEWSSERVER->WriteNote(msg);
  write("Nachricht in Forum " + gr + " verlegt.\n");

  return 1;
}

static int cmdSave(string str)
{
  mixed num;
  mixed *messages;

  if (intp(str)) num=str;
  if ((!num && (!str || str == "" || sscanf(str, "nachricht %d", num) != 1)) || num <= 0)
  {
    write("Welche Nachricht moechtet Ihr abspeichern?\n");
    return 1;
  }

  --num;
  messages = (NEWSSERVER->GetNotes(active_group));
  if (!pointerp(messages) || (sizeof(messages) <= num))
  {
    write("So viele Nachrichten sind nicht da.\n");
    return 1;
  }

  if (!IS_LEARNER(this_player()) || file_size("/players/"+getuid(this_player()))!=-2)
  {
    write_file(SAVE_OPEN(this_player()), Message2string(messages[num], sizeof(messages)) + "\n");
    write("Der Inhalt der Nachricht wurde nach " + SAVE_OPEN(this_player()) + " gespeichert.\n"
          "Bitte denkt daran, diese Datei auch wieder zu loeschen.\n");
  }
  else
  {
    if (file_size("/players/"+getuid(this_player())+"/news")!=-2)
    {
      write_file("/players/"+getuid(this_player())+"/news", Message2string(messages[num], sizeof(messages)) + "\n");
      write("Der Inhalt der Nachricht wurde nach ~/news gespeichert.\n");
    }
    else
    {
      write_file("/players/"+getuid(this_player())+"/news/"+messages[num][M_ID],
                 Message2string(messages[num], sizeof(messages)) + "\n");
      write("Der Inhalt der Nachricht wurde nach ~/news/"+messages[num][M_ID]+" gespeichert.\n");
    }
  }

  return 1;
}

static int cmdRepeat(string str)
{
  
}

static int cmdExpire(string str)
{  
  if (str=="alles")
  {
    
  }
}

static string _set_mailalias(string mali)
{
  return ME->Set(P_MAILALIAS,
    call_other("/secure/mailer","add_user_alias",mali));  
}

static string *_query_localcmds() 
{
  return ({
    ({"fschreibe",      "cmdWrite",0,0}),
    ({"fschreib",       "cmdWrite",0,0}),
    ({"fs",             "cmdWrite",0,0}),

    ({"flies",          "cmdRead",0,0}),
    ({"flese",          "cmdRead",0,0}),
    ({"fles",           "cmdRead",0,0}),
    ({"fl",             "cmdRead",0,0}),

    ({"fforum",         "cmdGroup",0,0}),
    ({"ff",             "cmdGroup",0,0}),

    ({"floesche",       "cmdDelete",0,0}),
    ({"floesch",        "cmdDelete",0,0}),
    ({"fentferne",      "cmdDelete",0,0}),
    ({"fentfern",       "cmdDelete",0,0}),
    ({"fe",             "cmdDelete",0,0}),

    ({"finhalt",        "cmdContent",0,0}),
    ({"fi",             "cmdContent",0,0}),

    ({"fforen",         "cmdGroups",0,0}),
    ({"ffe",            "cmdGroups",0,0}),

    ({"fneue",          "cmdNext",0,0}),
    ({"fneu",           "cmdNext",0,0}),
    ({"fn",             "cmdNext",0,0}),
    ({"f",              "cmdNext",0,0}),

    ({"fantworte",      "cmdReply",0,0}),
    ({"fantwort",       "cmdReply",0,0}),
    ({"fa",             "cmdReply",0,0}),

    ({"fbestelle",      "cmdSubscribe",0,0}),
    ({"fbestell",       "cmdSubscribe",0,0}),
    ({"fb",             "cmdSubscribe",0,0}),

    ({"fhilfe",         "cmdHelp",0,0}),
    ({"fh",             "cmdHelp",0,0}),

    ({"fverlege",       "cmdMove",0,0}),
    ({"fverleg",        "cmdMove",0,0}),
    ({"fverschiebe",    "cmdMove",0,0}),
    ({"fverschieb",     "cmdMove",0,0}),
    ({"fv",             "cmdMove",0,0}),

    ({"fspeichere",     "cmdSave",0,0}),
    ({"fspeicher",      "cmdSave",0,0}),
    ({"fp",             "cmdSave",0,0}),

    ({"fwiederhole",    "cmdRepeat",0,0}),
    ({"fwiederhol",     "cmdRepeat",0,0}),
    ({"fw",             "cmdRepeat",0,0}),

    ({"fuebergehe",     "cmdExpire",0,0}),
    ({"fu",             "cmdExpire",0,0}),

    ({"fadm",           "cmdAdm",0,0}),
    ({"fadmi",          "cmdAdm",0,0}),
    ({"fadmin",         "cmdAdm",0,0}),

    ({"mail",           "cmd_mail",0,0}),
    ({"mailalias",      "cmd_mailalias",0,0}),
  });
}
