/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: imud3.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// STD/PLAYER/IMUD3.C - Intermud3 Bedienung
//
// $Revision: 1.1.1.1 $
//
// $Log: imud3.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/09/07 11:45:30  Largo
// Initial revision
//

#pragma strong_types

#include <player/imud3.h>
#include <properties.h>
#include <config.h>
#include <wizlevels.h>
#include <daemon/intermud3.h>
#include <defines.h>

#define NEED_PROTOTYPES
#include <thing/properties.h>

void create() {
  Set(P_IMUD3_CHANNELS, SAVE, F_MODE);
}

static int _iremote_(string argl) {
  string it, wer, wo, was;
  mixed teile;
  notify_fail("iremote wer <mudname>.\n"
              "iremote finger <name>@<mudname>\n"
              "iremote muds\n"
              "iremote tell <name>@<mudname> <text>\n");
  if(!stringp(argl) || !strlen(argl))
    return 0;
  teile=efun::explode(argl," ")-({""});
  if(!sizeof(teile)) return 0;
  switch(teile[0]) {
    case "wer":
    case "who":
      notify_fail("iremote wer <mudname>.\n");
      if(sizeof(teile)<2) return 0;
      argl = teile[1];
      it = INTERMUD3->get_mud_name(argl);
      if(!it) {
        write("Unbekanntes MUD: " + argl + "\n");
        return 1;
      }
      if(!INTERMUD3->query_mud_info(it)[11]["who"]) {
        write(it + " unterstuetzt das nicht.\n");
        return 1;
      }
      IMUD3_TOOLS"who"->send_who_request(it);
      write("Anfrage abgeschickt.\n");
      return 1;
    case "finger":
      notify_fail("iremote finger <name>@<mudname>\n");
      if(sizeof(teile)<2) return 0;
      if(!sscanf(teile[1], "%s@%s", wer, wo))
        return 0;
      if(!stringp(wo) || !strlen(wo)) wo=lower_case(MUDNAME);
      it = INTERMUD3->get_mud_name(wo);
      if(!it) {
        write("Unbekanntes MUD: " + wo + "\n");
        return 1;  
      }
      if(!INTERMUD3->query_mud_info(it)[11]["finger"]) {
        write(it + " unterstuetzt das nicht.\n");
        return 1;
      }
      IMUD3_TOOLS"finger"->send_finger_request(wer, it);
      write("Anfrage abgeschickt.\n");
      return 1;
    case "tell":
      notify_fail("iremote tell <name>@<mudname> <text>\n");
      if(sscanf(argl, "%s %s@%s %s", wer, wer, wo, was)<4)
        return 0;
      it = INTERMUD3->get_mud_name(wo);
      if(!it) {
        write("Unbekanntes MUD: " + wo + "\n");
        return 1;
      }
      if(!INTERMUD3->query_mud_info(it)[11]["tell"]) {
        write(it + " unterstuetzt das nicht.\n");
        return 1;
      }
      IMUD3_TOOLS"tell"->send_tell(lower_case(wer), it, was);
      tell_object(this_object(), break_string("Du teilst "+
        capitalize(wer)+"@"+it+" mit: "+was+"\n",0,0,
        BS_FOR_COMM));
      return 1;
    case "mudlist":
    case "mudliste":
    case "muds":
      this_object()->More(INTERMUD3->query_mudlist());
      return 1;
  }
  return 0;
}

void receive_channel(mixed chan, string txt) {
  mixed ch;
  if((!stringp(ch=QueryProp(P_IMUD3_CHANNELS)) || ch!="*") &&
     (!pointerp(ch) || member_array(chan, ch)<0))
      return;
  tell_object(this_object(), "I3:"+txt);
}

// Lokale Kommandos

static mixed *_query_localcmds() {
  return ({
    ({"iremote","_iremote_",0,LEARNER_LVL})
  });
}
