/*******************
** Eldarea MUDLib **
********************
**
** std/player/info.c - player info module
**
** CVS DATA
** $Date: 2001/08/21 10:56:44 $
** $Revision: 1.5 $
**
** handles player info output
**
** CVS History
**
** $Log: info.c,v $
** Revision 1.5  2001/08/21 10:56:44  eldarea
** corrected function prototypes
**
** Revision 1.4  2000/12/01 16:22:12  elatar
** nearly completely rewritten
** there are know several different info pages and an interactive info mode
**
** Revision 1.3  2000/02/02 09:46:17  elatar
** appearence adapted to humanoid/description
**
** Revision 1.2  2000/01/26 14:49:04  elatar
** info char implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#define NEED_PROTOTYPES

#include <wizlevels.h>           // Magier-Level-Definitionen
#include <ansi.h>                // ansi  - Modes
#include <terminal.h>            // vt100 - Modes
#include <properties.h>          // immer
#include <thing/properties.h>    // Propertie-Methoden
#include <humanoid/description.h>// Aussehen
#include <defines.h>             // immer
#include <living/life.h>         // show_age()
#include <attributes.h>          // Fuer Attribute
#include <guilds.h>              // Questmaster-define
#include <service.h>             // Finger
#include <udp.h>                 // fuer Intermud Muds-Liste
#include <color.h>               

#pragma strong_types

#define USAGE "info - Ein einfaches 'info' fuehrt in den interaktiven "\
              "Info-Modus. Fuer direkte Infos gibts es folgende "\
              "Argumente: c(harakter), a(ttribute), k(oerperlich), "\
              "fk(oerperliche fert.), fm(agische fert.), fs(oziale "\
              "fert.), e(einstellungen)."

static int _score(string arg);
static int _kscore(string arg);

private string lp_balken();
private string mp_balken();
private string leiden();
private string gift_grad();
string short_age(int i);
string trag_spruch();
string explore_spruch();
private string bulki_spruch();
static mixed _query_age_monthly(); // Aus player/life.c
static void info_character();
static void info_attributes();
static void interactive_info(string str);
static string bonus_to_string(int bonus);

static void info_character()
{
  string married, titel; 

  titel=ME->short();
  if (!titel) titel=ME->QueryProp(P_NAME)+" - (unsichtbar) ";
  else titel=titel[0..<3]+(QueryProp(P_INVIS)?" - (unsichtbar) ":" ");


  if (QueryProp(P_MARRIED))
    married=sprintf("%:11-s %:23-s",
                    (QueryProp(P_GENDER)==2)?"Ehemann":"Ehefrau",
                    QueryProp(P_MARRIED));
  else married="";
  printf(
    "\n"
    "+--- %'-':68-s---+\n"
    "\n"
    "+--- Charakter -----------------------+"
      "--- Aussehen ------------------------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Beruf",CG_INFO_NAME)+"       "+colorize("%:23-s",CG_INFO_VAL)+" |"
      " "+colorize("Volk",CG_INFO_NAME)+"         "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("Stufe",CG_INFO_NAME)+"       "+colorize("%:23-d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "|                                     |"
      " "+colorize("Groesse",CG_INFO_NAME)+"      "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("Aspekt",CG_INFO_NAME)+"      "+colorize("%:23-s",CG_INFO_VAL)+" |"
      " "+colorize("Gewicht",CG_INFO_NAME)+"      "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("Gesinnung",CG_INFO_NAME)+"   "+colorize("%:23-s",CG_INFO_VAL)+" |"
      " "+colorize("Statur",CG_INFO_NAME)+"       "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("Ehre",CG_INFO_NAME)+"        "+colorize("%:23-s",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Kultur",CG_INFO_NAME)+"      "+colorize("%:23-s",CG_INFO_VAL)+" |"
      " "+colorize("Augenfarbe",CG_INFO_NAME)+"   "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "|                                     |"
      " "+colorize("Hautfarbe",CG_INFO_NAME)+"    "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| %:35-s |"
      " "+colorize("Haarfarbe",CG_INFO_NAME)+"    "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "|                                     |"
      " "+colorize("Haarlaenge",CG_INFO_NAME)+"   "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("Alter",CG_INFO_NAME)+"               "+colorize("%:15-s",CG_INFO_VAL)+" |"
      " "+colorize("Frisur",CG_INFO_NAME)+"       "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("Erfahrungpunkte",CG_INFO_NAME)+"     "+colorize("%:15-d",CG_INFO_VAL)+" |"
      "              "+colorize("%:22-s",CG_INFO_VAL)+" |\n"
    "| "+colorize("naechste Stufe bei",CG_INFO_NAME)+"  "+colorize("%:15-d",CG_INFO_VAL)+" |"
      " %:35-s |\n"
    "| "+colorize("Entwicklungspunkte",CG_INFO_NAME)+"  "+colorize("%:15-d",CG_INFO_VAL)+" |"
      " %:35-s |\n"
    "|                                     |"
      "                                     |\n"
    "+-------------------------------------+"
      "-------------------------------------+\n"      
    ,titel
    ,QueryProp(P_PROFESSION)||"<keiner>"   ,QueryProp(P_RACE)||"<keins>"
    ,QueryProp(P_LEVEL)
                                           ,QueryProp(P_SIZE)+" cm"
    ,QueryProp(P_ASPECT)||"keiner"         ,(QueryProp(P_WEIGHT)/1000)+" kg"
    ,ME->al_to_title(QueryProp(P_ALIGN))   ,QueryProp(P_STATUE)
    ,QueryProp(P_HONOR)||"<keine>"
    ,QueryProp(P_CIVILIZATION)||"<keine>"  ,QueryProp(P_EYE_COLOR)||"<keine>"
                                           ,QueryProp(P_SKIN_COLOR)||"<keine>"
    ,married                               ,QueryProp(P_HAIR_COLOR)||"<keine>"
                                           ,ME->length_to_hair()
    ,time2string("%d t %02h:%02m:%02s",QueryProp(P_AGE)*2),HAIR_TEXTURE_DESC[QueryProp(P_HAIR_TEXTURE)]
    ,QueryProp(P_XP)                       ,HAIR_DESC_DESC[QueryProp(P_HAIR_DESC)]
    ,ME->needed_xp()                       ,""
    ,QueryProp(P_DP)                       ,""
    );                                                   
}

static string bonus_to_string(int bonus)
{
  string ret;

  switch(bonus)
  {
    case -1000..-60:
      ret="-----";
      break;
    case -59..-45:
      ret="----";
      break;
     case -44..-30:
      ret="---";
      break;
     case -29..-15:
      ret="--";
      break;
     case -14..-5:
      ret="-";
      break;
     case -4..4:
      ret="";
      break;
     case 5..14:
      ret="+";
      break;
     case 15..29:
      ret="++";
      break;
     case 30..44:
      ret="+++";
      break;
     case 45..59:
      ret="++++";
      break;
     case 60..74:
      ret="+++++";
      break;
     case 75..89:
      ret="++++++";
      break;
     case 90..104:
      ret="+++++++";
      break;
     case 105..119:
      ret="++++++++";
      break;
     case 120..149:
      ret="+++++++++";
      break;
     default:
      ret="++++++++++";
      break;      
  }
  return ret;
}

static void info_attributes()
{
  mapping attr,attr_boni,resist,a_magic,ab_magic,r_magic;

  attr=ME->QueryProp(P_ATTRIBUTES);
  a_magic=ME->QueryProp(P_ATTRIBUTES_MAGIC);
  attr_boni=ME->QueryProp(P_ATTR_BONI);
  ab_magic=ME->QueryProp(P_ATTR_BONI_MAGIC);
  resist=ME->QueryProp(P_RESISTANCES);
  r_magic=ME->QueryProp(P_RESISTANCES_MAGIC);
  
  printf(
    "\n"
    "+--- Attribute -----------------------+"
      "--- Widerstandswerte ----------------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Staerke",CG_INFO_NAME)+"            "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Essenzmagie",CG_INFO_NAME)+"       (MA) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Geschicklichkeit",CG_INFO_NAME)+"   "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Leitmagie",CG_INFO_NAME)+"         (IN) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Reaktion",CG_INFO_NAME)+"           "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Mentalmagie",CG_INFO_NAME)+"       (CH) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Konstitution",CG_INFO_NAME)+"       "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Psionik",CG_INFO_NAME)+"           (SD) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Selbstdisziplin",CG_INFO_NAME)+"    "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Furcht",CG_INFO_NAME)+"            (SD) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Intelligenz",CG_INFO_NAME)+"        "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Gift",CG_INFO_NAME)+"              (KO) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Intuition",CG_INFO_NAME)+"          "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Krankheit",CG_INFO_NAME)+"         (KO) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Mana",CG_INFO_NAME)+"               "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Kraftentzug",CG_INFO_NAME)+"       (SD) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "| "+colorize("Charisma",CG_INFO_NAME)+"           "+colorize("%:3d %1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |"
      " "+colorize("Elemente",CG_INFO_NAME)+"          (KO) "+colorize("%1s",CG_INFO_VAL)+" "+colorize("%:10-s",CG_INFO_BONUS)+" |\n"
    "|                                     |"
      "                                     |\n"
    "+--- Spezielle Faehigkeiten ----------+"
      "-------------------------------------+\n"
    "|                                                                           |\n"
    "| keine                                                                     |\n"
    "|                                                                           |\n"
    "|                                                                           |\n"
    "|                                                                           |\n"
    "+---------------------------------------------------------------------------+\n"
    ,attr[A_ST],(a_magic[A_ST]||ab_magic[A_ST])?"*":" ",bonus_to_string(attr_boni[A_ST]),
     (r_magic[RR_ESSENCE])?"*":" ",bonus_to_string(resist[RR_ESSENCE])
    ,attr[A_AG],(a_magic[A_AG]||ab_magic[A_AG])?"*":" ",bonus_to_string(attr_boni[A_AG]),
     (r_magic[RR_CHANNELING])?"*":" ",bonus_to_string(resist[RR_CHANNELING])
    ,attr[A_QU],(a_magic[A_QU]||ab_magic[A_QU])?"*":" ",bonus_to_string(attr_boni[A_QU]),
     (r_magic[RR_MENTALISM])?"*":" ",bonus_to_string(resist[RR_MENTALISM])
    ,attr[A_CO],(a_magic[A_CO]||ab_magic[A_CO])?"*":" ",bonus_to_string(attr_boni[A_CO]),
     (r_magic[RR_PSIONS])?"*":" ",bonus_to_string(resist[RR_PSIONS])
    ,attr[A_SD],(a_magic[A_SD]||ab_magic[A_SD])?"*":" ",bonus_to_string(attr_boni[A_SD]),
     (r_magic[RR_FEAR])?"*":" ",bonus_to_string(resist[RR_FEAR])
    ,attr[A_RE],(a_magic[A_RE]||ab_magic[A_RE])?"*":" ",bonus_to_string(attr_boni[A_RE]),
     (r_magic[RR_POISON])?"*":" ",bonus_to_string(resist[RR_POISON])
    ,attr[A_IN],(a_magic[A_IN]||ab_magic[A_IN])?"*":" ",bonus_to_string(attr_boni[A_IN]),
     (r_magic[RR_DISEASE])?"*":" ",bonus_to_string(resist[RR_DISEASE])
    ,attr[A_EM],(a_magic[A_EM]||ab_magic[A_EM])?"*":" ",bonus_to_string(attr_boni[A_EM]),
     (r_magic[RR_POWERDRAIN])?"*":" ",bonus_to_string(resist[RR_POWERDRAIN])
    ,attr[A_PR],(a_magic[A_PR]||ab_magic[A_PR])?"*":" ",bonus_to_string(attr_boni[A_PR]),
     (r_magic[RR_ELEMENTAL])?"*":" ",bonus_to_string(resist[RR_ELEMENTAL])
     );
}

string hunger_to_string(int hunger)
{
  switch(hunger)
  {
    default:
      return "sehr uebersaettigt";
      break;  
    case -15..-1:
      return "uebersaettigt";
      break;  
    case 0..35:
      return "satt";
      break;  
    case 36..45:
      return "fast satt";
      break;  
    case 46..55:
      return "sehr wenig hungrig";
      break;  
    case 56..65:
      return "wenig hungrig";
      break;  
    case 66..75:
      return "hungrig";
      break;  
    case 76..85:
      return "sehr hungrig";
      break;  
    case 86..95:
      return "extrem hungrig";
      break;  
    case 96..100:
      return "verhungernd";
      break;  
  }
}

string thirst_to_string(int thirst)
{
  switch(thirst)
  {
    default:
    case -15..-1:
    case 0..35:
      return "nicht durstig";
      break;  
    case 36..45:
      return "fast nicht durstig";
      break;  
    case 46..55:
      return "sehr wenig durstig";
      break;  
    case 56..65:
      return "wenig durstig";
      break;  
    case 66..75:
      return "durstig";
      break;  
    case 76..85:
      return "sehr durstig";
      break;  
    case 86..95:
      return "extrem durstig";
      break;  
    case 96..100:
      return "verdurstend";
      break;  
  }
}

string tiredness_to_string(int tiredness)
{
  switch(tiredness)
  {
    default:
      return "sehr gut ausgeruht";
      break;
    case -15..-1:
      return "gut ausgeruht";
      break;
    case 0..35:
      return "ausgeruht";
      break;  
    case 36..45:
      return "fast ausgeruht";
      break;  
    case 46..55:
      return "sehr wenig muede";
      break;  
    case 56..65:
      return "wenig muede";
      break;  
    case 66..75:
      return "mude";
      break;  
    case 76..85:
      return "sehr muede";
      break;  
    case 86..95:
      return "extrem muede";
      break;  
    case 96..100:
      return "fast einschlafend";
      break;  
  }
}

static void info_points()
{
  // unter traglast kommt noch atemluft etc.

  printf(
    "\n"
    "+--- Koerperliche Werte --------------+"
      "--- Magische Werte ------------------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Lebenspunkte",CG_INFO_NAME)+"           "+colorize("%:4d",CG_INFO_VAL)+" ("+colorize("%:4d",CG_INFO_BONUS)+")  |"
      " "+colorize("Essenzmagiepunkte",CG_INFO_NAME)+"      "+colorize("%:4d",CG_INFO_VAL)+" ("+colorize("%:4d",CG_INFO_BONUS)+")  |\n"
    "| "+colorize("Fluchtschwelle",CG_INFO_NAME)+"         "+colorize("%:4d",CG_INFO_VAL)+"         |"
      " "+colorize("Leitmagiepunkte",CG_INFO_NAME)+"        "+colorize("%:4d",CG_INFO_VAL)+" ("+colorize("%:4d",CG_INFO_BONUS)+")  |\n"
    "|                                     |"
      " "+colorize("Mentalmagiepunkte",CG_INFO_NAME)+"      "+colorize("%:4d",CG_INFO_VAL)+" ("+colorize("%:4d",CG_INFO_BONUS)+")  |\n"
    "| "+colorize("Angriffsschwelle",CG_INFO_NAME)+"        "+colorize("%:3d",CG_INFO_VAL)+"         |"
      "                                     |\n"
    "|                                     |"
      " "+colorize("Psionikpunkte",CG_INFO_NAME)+"          "+colorize("%:4d",CG_INFO_VAL)+" ("+colorize("%:4d",CG_INFO_BONUS)+")  |\n"
    "| "+colorize("Hunger",CG_INFO_NAME)+"           "+colorize("%18-s",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Durst",CG_INFO_NAME)+"            "+colorize("%18-s",CG_INFO_VAL)+" +"
      "--- Koerperliche Schaeden -----------+\n"
    "| "+colorize("Muedigkeit",CG_INFO_NAME)+"       "+colorize("%18-s",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Ausdauer",CG_INFO_NAME)+"         "+colorize("%18-s",CG_INFO_VAL)+" |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Traglast",CG_INFO_NAME)+"               "+colorize("%:3d",CG_INFO_VAL)+" ("+colorize("%:3d",CG_INFO_BONUS)+") kg |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "+-------------------------------------+"
      "-------------------------------------+\n"
    ,ME->QueryProp(P_HP),ME->QueryProp(P_MAX_HP),ME->QueryProp(P_ESP),ME->QueryProp(P_MAX_ESP)
    ,ME->QueryProp(P_WIMPY),ME->QueryProp(P_CSP),ME->QueryProp(P_MAX_CSP)
    ,ME->QueryProp(P_MSP),ME->QueryProp(P_MAX_MSP)
    ,ME->QueryProp(P_PK_LEVEL)
    ,ME->QueryProp(P_PSP),ME->QueryProp(P_MAX_PSP)
    ,hunger_to_string(ME->QueryProp(P_HUNGER))
    ,thirst_to_string(ME->QueryProp(P_THIRST))
    ,tiredness_to_string(ME->QueryProp(P_TIREDNESS))
    ,bonus_to_string(ME->QueryProp(P_EXP)*100/ME->QueryProp(P_MAX_EXP))
    ,(ME->query_weight_contents()+500)/1000,(ME->QueryMaxWeight()+500)/1000
    );
}

string skillcost(mapping skills,string skill)
{
  if (skills[skill,SI_LEARNED]>1)
    return "--";
  else
    return to_string(ME->skill_cost(skill));
}

static void info_skills_fight()
{
  mapping skills;
  
  skills=ME->QueryProp(P_SKILLS);
  
  printf(
    "\n"
    "+--- Kampffertigkeiten ---------------+"
      "--- Athletische Fertigkeiten --------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Schwerter",CG_INFO_NAME)+"            ("+colorize("%:2s",CG_INFO_BONUS)+") ST/GE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Klettern",CG_INFO_NAME)+"             ("+colorize("%:2s",CG_INFO_BONUS)+") GE    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Aexte",CG_INFO_NAME)+"                ("+colorize("%:2s",CG_INFO_BONUS)+") ST/GE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Schwimmen",CG_INFO_NAME)+"            ("+colorize("%:2s",CG_INFO_BONUS)+") GE    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Stichwaffen",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") ST/GE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Schleichen",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+") GE/SD "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Keulen",CG_INFO_NAME)+"               ("+colorize("%:2s",CG_INFO_BONUS)+") ST/GE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Verbergen",CG_INFO_NAME)+"            ("+colorize("%:2s",CG_INFO_BONUS)+") SD/CH "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Stangenwaffen",CG_INFO_NAME)+"        ("+colorize("%:2s",CG_INFO_BONUS)+") ST/GE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Akrobatik",CG_INFO_NAME)+"            ("+colorize("%:2s",CG_INFO_BONUS)+") GE    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Kettenwaffen",CG_INFO_NAME)+"         ("+colorize("%:2s",CG_INFO_BONUS)+") ST/GE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Ausdauer",CG_INFO_NAME)+"             ("+colorize("%:2s",CG_INFO_BONUS)+")   -   "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Waffenloser Kampf",CG_INFO_NAME)+"    ("+colorize("%:2s",CG_INFO_BONUS)+") ST/RE "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "|                                     +"
      "--- Konzentrationsfertigkeiten ------+\n"
    "| "+colorize("Entwaffnen",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+") GE/RE "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Antaeuschen",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") GE/RE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Ausweichen",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+")   -   "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Nahkampf",CG_INFO_NAME)+"             ("+colorize("%:2s",CG_INFO_BONUS)+") GE/RE "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Kraftakt",CG_INFO_NAME)+"             ("+colorize("%:2s",CG_INFO_BONUS)+") SD    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Raserei",CG_INFO_NAME)+"              ("+colorize("%:2s",CG_INFO_BONUS)+") RE/SD "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Schmerzresistenz",CG_INFO_NAME)+"     ("+colorize("%:2s",CG_INFO_BONUS)+") KO/SD "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Kampf zu Pferd",CG_INFO_NAME)+"       ("+colorize("%:2s",CG_INFO_BONUS)+") GE/MA "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Heilungsmeditation",CG_INFO_NAME)+"   ("+colorize("%:2s",CG_INFO_BONUS)+") SD/CH "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Schnellkampf",CG_INFO_NAME)+"         ("+colorize("%:2s",CG_INFO_BONUS)+") RE/SD "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Kraftmeditation",CG_INFO_NAME)+"      ("+colorize("%:2s",CG_INFO_BONUS)+") SD/CH "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Bewegung in Ruestung",CG_INFO_NAME)+" ("+colorize("%:2s",CG_INFO_BONUS)+")   -   "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Ruhemeditation",CG_INFO_NAME)+"       ("+colorize("%:2s",CG_INFO_BONUS)+") SD/CH "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Koerperentwicklung",CG_INFO_NAME)+"   ("+colorize("%:2s",CG_INFO_BONUS)+")   -   "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Transportieren",CG_INFO_NAME)+"       ("+colorize("%:2s",CG_INFO_BONUS)+")   -   "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      "                                     |\n"
    "+-------------------------------------+"
      "-------------------------------------+\n"
    ,skillcost(skills,SK_SWORD)         ,skills[SK_SWORD,SI_RANKS]
        ,skillcost(skills,SK_CLIMBING)      ,skills[SK_CLIMBING,SI_RANKS]
    ,skillcost(skills,SK_AXE)           ,skills[SK_AXE,SI_RANKS]
        ,skillcost(skills,SK_SWIMMING)      ,skills[SK_SWIMMING,SI_RANKS]
    ,skillcost(skills,SK_STING)         ,skills[SK_STING,SI_RANKS]
        ,skillcost(skills,SK_STEALTH)       ,skills[SK_STEALTH,SI_RANKS]
    ,skillcost(skills,SK_CLUB)          ,skills[SK_CLUB,SI_RANKS]
        ,skillcost(skills,SK_STEALTH)       ,skills[SK_STEALTH,SI_RANKS]
    ,skillcost(skills,SK_POLE)          ,skills[SK_POLE,SI_RANKS]
        ,skillcost(skills,SK_ACROBATICS)    ,skills[SK_ACROBATICS,SI_RANKS]
    ,skillcost(skills,SK_FLAIL)         ,skills[SK_FLAIL,SI_RANKS]
        ,skillcost(skills,SK_ENDURANCE)     ,skills[SK_ENDURANCE,SI_RANKS]
    ,skillcost(skills,SK_MARTIAL_ARTS)  ,skills[SK_MARTIAL_ARTS,SI_RANKS]
    ,skillcost(skills,SK_DISARM)        ,skills[SK_DISARM,SI_RANKS]
    ,skillcost(skills,SK_FEINTING)      ,skills[SK_FEINTING,SI_RANKS]
        ,skillcost(skills,SK_EVADE)         ,skills[SK_EVADE,SI_RANKS]
    ,skillcost(skills,SK_CLOSE_COMBAT)  ,skills[SK_CLOSE_COMBAT,SI_RANKS]
        ,skillcost(skills,SK_USE_STRENGTH)  ,skills[SK_USE_STRENGTH,SI_RANKS]
    ,skillcost(skills,SK_FURY)          ,skills[SK_FURY,SI_RANKS]
        ,skillcost(skills,SK_RESIST_PAIN)   ,skills[SK_RESIST_PAIN,SI_RANKS]
    ,skillcost(skills,SK_FIGHT_HORSE)   ,skills[SK_FIGHT_HORSE,SI_RANKS]
        ,skillcost(skills,SK_MEDITATION_HEAL),skills[SK_MEDITATION_HEAL,SI_RANKS]
    ,skillcost(skills,SK_QUICKFIGHT)    ,skills[SK_QUICKFIGHT,SI_RANKS]
        ,skillcost(skills,SK_MEDITATION_SLEEP),skills[SK_MEDITATION_SLEEP,SI_RANKS]
    ,skillcost(skills,SK_ARMOUR)        ,skills[SK_ARMOUR,SI_RANKS]
        ,skillcost(skills,SK_MEDITATION_POWER),skills[SK_MEDITATION_POWER,SI_RANKS]
    ,skillcost(skills,SK_BODY_DEVELOPMENT),skills[SK_BODY_DEVELOPMENT,SI_RANKS]
        ,skillcost(skills,SK_PORTAGING)      ,skills[SK_PORTAGING,SI_RANKS]
    );
}

static void info_skills_magic()
{
  mapping skills;

  skills=ME->QueryProp(P_SKILLS);

  printf(
    "\n"
    "+--- Magische Fertigkeiten -----------+"
      "--- Wissensfertigkeiten -------------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Essenzmagie",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") MA    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Alchemie",CG_INFO_NAME)+"             ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Leitmagie",CG_INFO_NAME)+"            ("+colorize("%:2s",CG_INFO_BONUS)+") IN    "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Mentalmagie",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") CH    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Pflanzenkunde",CG_INFO_NAME)+"        ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Ritualmagie",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") IG/MA "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Metallkunde",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      " "+colorize("Steinkunde",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Psionik",CG_INFO_NAME)+"              ("+colorize("%:2s",CG_INFO_BONUS)+") SD    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Naturmaterialkunde",CG_INFO_NAME)+"   ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      " "+colorize("Elementarkunde",CG_INFO_NAME)+"       ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Magie spueren",CG_INFO_NAME)+"        ("+colorize("%:2s",CG_INFO_BONUS)+") MA    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Kreaturenkunde",CG_INFO_NAME)+"       ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n" 
    "| "+colorize("Magie verbergen",CG_INFO_NAME)+"      ("+colorize("%:2s",CG_INFO_BONUS)+") SD/CH "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Magie intensivieren",CG_INFO_NAME)+"  ("+colorize("%:2s",CG_INFO_BONUS)+") MA    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Waffenkunde",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Magie uebertragen",CG_INFO_NAME)+"    ("+colorize("%:2s",CG_INFO_BONUS)+") IN    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Ruestungskunde",CG_INFO_NAME)+"       ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Zaubern in Ruestung",CG_INFO_NAME)+"  ("+colorize("%:2s",CG_INFO_BONUS)+")       "+colorize("%:3d",CG_INFO_VAL)+" +"
      "--- Medizinische Fertigkeiten -------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Magiekunde",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+") IG    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Erste Hilfe",CG_INFO_NAME)+"          ("+colorize("%:2s",CG_INFO_BONUS)+") SD/MA "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Runenlesen",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+") IG/MA "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Arzt",CG_INFO_NAME)+"                 ("+colorize("%:2s",CG_INFO_BONUS)+") SD/MA "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      "                                     |\n"
    "+-------------------------------------+"
      "-------------------------------------+\n"
    ,skillcost(skills,SK_ESSENCE)         ,skills[SK_ESSENCE,SI_RANKS]
        ,skillcost(skills,SK_ALCHEMY)         ,skills[SK_ALCHEMY,SI_RANKS]
    ,skillcost(skills,SK_CHANNELING)      ,skills[SK_CHANNELING,SI_RANKS]
    ,skillcost(skills,SK_MENTALISM)       ,skills[SK_MENTALISM,SI_RANKS]
        ,skillcost(skills,SK_FLORA_LORE)      ,skills[SK_FLORA_LORE,SI_RANKS]
    ,skillcost(skills,SK_RITUALS)         ,skills[SK_RITUALS,SI_RANKS]
        ,skillcost(skills,SK_METAL_LORE)      ,skills[SK_METAL_LORE,SI_RANKS]
        ,skillcost(skills,SK_STONE_LORE)      ,skills[SK_STONE_LORE,SI_RANKS]
    ,skillcost(skills,SK_PSIONS)          ,skills[SK_PSIONS,SI_RANKS]
        ,skillcost(skills,SK_NATURAL_LORE)    ,skills[SK_NATURAL_LORE,SI_RANKS]
        ,skillcost(skills,SK_ELEMENTAL_LORE)  ,skills[SK_ELEMENTAL_LORE,SI_RANKS]
    ,skillcost(skills,SK_POWER_PERCEPTION),skills[SK_POWER_PERCEPTION,SI_RANKS]
        ,skillcost(skills,SK_CREATURE_LORE)   ,skills[SK_CREATURE_LORE,SI_RANKS]
    ,skillcost(skills,SK_HIDE_SPELLS)      ,skills[SK_HIDE_SPELLS,SI_RANKS]
    ,skillcost(skills,SK_STRENGTHEN_SPELLS),skills[SK_STRENGTHEN_SPELLS,SI_RANKS]
        ,skillcost(skills,SK_WEAPON_LORE)     ,skills[SK_WEAPON_LORE,SI_RANKS]
    ,skillcost(skills,SK_CHANNEL_POWER)   ,skills[SK_CHANNEL_POWER,SI_RANKS]
        ,skillcost(skills,SK_ARMOUR_LORE)     ,skills[SK_ARMOUR_LORE,SI_RANKS]
    ,skillcost(skills,SK_TRANSCENDENCE)   ,skills[SK_TRANSCENDENCE,SI_RANKS]
    ,skillcost(skills,SK_MAGIC_LORE)      ,skills[SK_MAGIC_LORE,SI_RANKS]
        ,skillcost(skills,SK_FIRST_AID)       ,skills[SK_FIRST_AID,SI_RANKS]
    ,skillcost(skills,SK_RUNES)           ,skills[SK_RUNES,SI_RANKS]
        ,skillcost(skills,SK_SURGERY)         ,skills[SK_SURGERY,SI_RANKS]
    );

}

static void info_skills_social()
{
  mapping skills;

  skills=ME->QueryProp(P_SKILLS);

  printf(
    "\n"
    "+--- Soziale Fertikeiten -------------+"
      "--- Wildnisfertigkeiten -------------+\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Diplomatie",CG_INFO_NAME)+"           ("+colorize("%:2s",CG_INFO_BONUS)+") CH    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Reiten",CG_INFO_NAME)+"               ("+colorize("%:2s",CG_INFO_BONUS)+") GE/IN "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "| "+colorize("Handeln",CG_INFO_NAME)+"              ("+colorize("%:2s",CG_INFO_BONUS)+") CH    "+colorize("%:3d",CG_INFO_VAL)+" |"
      " "+colorize("Umgang mit Tieren",CG_INFO_NAME)+"    ("+colorize("%:2s",CG_INFO_BONUS)+") IN/MA "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      " "+colorize("Nahrungssuche",CG_INFO_NAME)+"        ("+colorize("%:2s",CG_INFO_BONUS)+") IG/IN "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "+--- Heimlichkeitsfertigkeiten -------+"
      " "+colorize("Wildnisleben",CG_INFO_NAME)+"         ("+colorize("%:2s",CG_INFO_BONUS)+") SD/IN "+colorize("%:3d",CG_INFO_VAL)+" |\n"
    "|                                     |"
      "                                     |\n"
    "| "+colorize("Schloesser oeffnen",CG_INFO_NAME)+"   ("+colorize("%:2s",CG_INFO_BONUS)+") GE/IN "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Fallen entschaerfen",CG_INFO_NAME)+"  ("+colorize("%:2s",CG_INFO_BONUS)+") GE/IN "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "| "+colorize("Taschendiebstahl",CG_INFO_NAME)+"     ("+colorize("%:2s",CG_INFO_BONUS)+") GE/CH "+colorize("%:3d",CG_INFO_VAL)+" |"
      "                                     |\n"
    "|                                     |"
      "                                     |\n"
    "+-------------------------------------+"
      "-------------------------------------+\n"
    ,skillcost(skills,SK_DIPLOMACY)       ,skills[SK_DIPLOMACY,SI_RANKS]
        ,skillcost(skills,SK_RIDING)          ,skills[SK_RIDING,SI_RANKS]
    ,skillcost(skills,SK_TRADING)         ,skills[SK_TRADING,SI_RANKS]
        ,skillcost(skills,SK_ANIMAL_HANDLING) ,skills[SK_ANIMAL_HANDLING,SI_RANKS]
        ,skillcost(skills,SK_FORAGING)        ,skills[SK_FORAGING,SI_RANKS]
        ,skillcost(skills,SK_WILDERNESS)      ,skills[SK_WILDERNESS,SI_RANKS]
    ,skillcost(skills,SK_LOCKS)           ,skills[SK_LOCKS,SI_RANKS]
    ,skillcost(skills,SK_TRAPS)           ,skills[SK_TRAPS,SI_RANKS]
    ,skillcost(skills,SK_THIEVERY)        ,skills[SK_THIEVERY,SI_RANKS]
    );
}

static void info_settings()
{
  printf(
    "\n"
    "+--- Einstellungen -------------------+-------------------------------------+\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "|                                     |                                     |\n"
    "+-------------------------------------+-------------------------------------+\n"
    );
}

static void interactive_info(string str)
{
  switch(str)
  {
    case "c":
      info_character();
      break;
    case "h":
      printf("\n"
             "+--- Folgende Befehle sind moeglich: ---------------------------------------+\n"
             "%:2s  -  %s\n"
             "%:2s  -  %s\n"
             "%:2s  -  %s\n"
             "%:2s  -  %s\n"
             "%:2s  -  %s\n"
             "%:2s  -  %s\n"
             "%:2s  -  %s\n\n"
             "%:2s  -  %s\n"
             ,"c","Charakter/Aussehen"
             ,"a","Attribute/Wiederstandswerte"
             ,"k","Koerperliche/magische Werte"
             ,"fk","Kampf-/Athletische/Konzentrationsfertigkeiten"
             ,"fm","Magische/Wissens-/Medizinische Fertigkeiten"
             ,"fs","Soziale/Heimlichkeits-/Wildnisfertigkeiten"
             ,"e","Einstellungen"
             ,"q","Beenden"
             );
      break;
    case "a":
      info_attributes();
      break;
    case "k":
      info_points();
      break;
    case "e":
      info_settings();
      break;
    case "fk":
      info_skills_fight();
      break;
    case "fm":
      info_skills_magic();
      break;
    case "fs":
      info_skills_social();
      break;
/*
    case "":
      break;
    case "":
      break;
    case "":
      break;
*/
    case "q":
      printf("\nInfo beendet.\n");
      return;
      break;
    case "":
    case " ":
    case 0:
      printf("\n"
             "+--- Charakterinformation, Hilfe mit 'h' -----------------------------------+\n"); 
      break;
    default:
      printf("\nUnbekannter Befehl, Hilfe mit 'h'\n");
      break;
  }
  printf("Info>");
  input_to("interactive_info");
  return;
}

/********************************************************************
* Funktion:                                                         *
*   score(arg)                                                      *
*                                                                   *
* Argumente:                                                        *
*   arg - Parameter bei 'info'. Derzeit wird nur '-k' ausgewertet,  *
*         um eine 'Kurzinfo' zu liefern.                            *
*                                                                   *
* Aufgabe:                                                          *
*   Hauptfunktion. Liefert eine komplette Informnations-uebersicht  *
*   ueber die wichtigsten Daten des Spielers. Besteht im Prinzip    *
*   nur aus einem recht komplexen write(sprintf(...));              *
*   Die Schrift wird bei ANSI farbig dargestellt. Alle anderen      *
*   Farben werden in den Unterfunktionen erzeugt.                   *
********************************************************************/
static int _score(string arg) {
  string gilde, fricht, *args, titel, *tmpliste,married;
  int i, j, k, m;
  mixed ma;
    
  if (arg)
  {
    args=explode(arg," ");
    if (sizeof(args))
    {
      switch (args[0])
      {
        case "charakter":
        case "aussehen":
        case "char":
        case "aus":
        case "c":
          info_character();
          return 1;
          break;
        case "a":
        case "att":
        case "attribute":
        case "wie":
        case "wiederstand":
        case "wiederstandswerte":
          info_attributes();
          return 1;
          break;
        case "k":
        case "koerperlich":
        case "magisch":
        case "mag":
          info_points();
          return 1;
          break;
        case "e":
        case "einstellungen":
          info_settings();
          return 1;
          break;
        case "fk":
        case "fkampf":
        case "fa":
        case "fathletisch":
          info_skills_fight();
          return 1;
          break;
        case "fm":
        case "fmagisch":
        case "fw":
        case "fwissen":
        case "fmedizinisch":
          info_skills_magic();
          return 1;
          break;
        case "fs":
        case "fsozial":
        case "fh":
        case "fheimlichkeit":
        case "fwildnis":
          info_skills_social();
          return 1;
          break;
        default:
          printf(break_string(USAGE));
          return 1;
          break;
      }
    }
  }
  // Get interactive!
  interactive_info("");

/*
      trag_spruch(),
      bulki_spruch(),
      explore_spruch(),
      ""));
*/
  return 1;
}


/********************************************************************
* Funktion:                                                         *
*   kscore(arg)                                                     *
*                                                                   *
* Argumente:                                                        *
*   arg - Parameter werden derzeit nicht unterstuetzt               *
*                                                                   *
* Aufgabe:                                                          *
*   Funktion fuer 'kinfo'. Ruft score() mit Paramtere '-k' auf.     *
********************************************************************/
static int _kscore(string arg) {
    return _score("-k");
}  

/*
private string leiden() {
    string *leiden, str;
  
    leiden=({});
    if(QueryProp(P_BLIND)) leiden+=({"blind"});
    if(QueryProp(P_DEAF)) leiden+=({"taub"});
    if(QueryProp(P_DISABLE_ATTACK)) leiden+=({"lahm"});
    if(!sizeof(leiden)) return sprintf("%-:22s","keine");
    return ME->in_color(INFO_COL2,sprintf("%-:22s",ME->CountUp(leiden)));
}

private string gift_grad() {
    string str;
    switch(QueryProp(P_POISON)) {
        case 0: return sprintf("%-:22s","keine");
        case 1..2: return ME->in_color(INFO_COL3,sprintf("%-:22s","leicht"));
        case 3..4: return ME->in_color(INFO_COL3,sprintf("%-:22s","mittel"));
        case 5..7: return ME->in_color(INFO_COL2,sprintf("%-:22s","stark"));
        default: return ME->in_color(INFO_COL2,sprintf("%-:22s","Lauf um Dein Leben!"));
    }
}

string short_age(int i) {
    int d, h, m;
    string str;
  
    str="";
    if ((d=i/43200)) {
        i %= 43200;
        str = d + " Tag"+(d==1?", ":"e, ");
    }
    if ((h=i/1800)) i %= 1800;
    m=i/30;
    str += sprintf("%02d:%02d Stunden",h,m);
    return str;
}

string trag_spruch() {
    int last;
    string str;
    
    last=(int)((10*(ME->QueryProp(P_TOTAL_WEIGHT)-ME->QueryProp(P_WEIGHT)))/ME->QueryProp(P_MAX_WEIGHT));
    if (last < 0) last = -1;
    switch (last) { 
        case 10: str="Du bist total ueberladen.";break;
        case 9: str="Ein Lastesel ist nichts gegen Dich.";break;
        case 8: str="Du traegst fast soviel wie ein Lastesel.";break;
        case 7: str="Bei all dem Gewicht waere mal eine Pause recht.";break;
        case 6: str="Buerdest Du Dir mit dieser Last nicht etwas zuviel auf?";break;
        case 5: str="Du fuehlst Dich mit Deiner Last gerade noch wohl.";break;
        case 4: str="Ein bisschen mehr koenntest Du wohl noch tragen.";break;
        case 3: str="Du kannst noch jede Menge tragen.";break;
        case 2: str="Du bemerkst das Gewicht Deiner Sachen kaum."; break;
        case 1: str="Du solltest Dich nach etwas Ballast umsehen.";break;
        case 0: str="Du hast zur Zeit fast nichts dabei.";break;
        case -1: str="Du fuehlst Dich leicht wie ein Voeglein.";break;
        default: str="Irgendwas stimmt mit Deinem Gewicht nicht.";break;
    }
    return ME->in_color(INFO_COL1, sprintf("%-:73s",str));
}

string explore_spruch ()
{
  string str;

  switch (ME->QueryProcentEP())
  {
    case 0..2:    str="Du hast von nix nen Plan ... Schau Dich doch mal etwas um :-).";break;
    case 3..5:    str="Du musst aufpassen, dass Du Dich in den Strassen nicht verlaeufst.";break;
    case 6..8:    str="Du hast nach sehr viel zu entdecken. Strenge Dich an!";break;
    case 9..11:   str="Meinst Du, dass kurz umsehen und dann sofort weiterrennen reicht?";break;
    case 12..14:  str="Du kennst erst sehr wenig vom MD. *troest*";break;
    case 15..17:  str="Du solltest Dich vielleicht noch etwas genauer umsehen.";break;
    case 18..20:  str="Du kennst jetzt schon ein paar Ecken der Stadt.";break;
    case 21..30:  str="In einigen Vierteln hast Du schon kraeftig herumgestoebert.";break;
    case 31..40:  str="Du bist im MD schon viel herumgekommen.";break;
    case 41..50:  str="Du kennst Dich hier bereits ganz gut aus.";break;
    case 51..60:  if (ME->QueryProp(P_GENDER)==FEMALE)
                    str="Du koenntest Fremdenfuehrerin werden.";
                  else
                    str="Du koenntest Fremdenfuehrer werden.";
                  break;
    case 61..70:  str="Du besitzt eine ausserordentliche Ortskenntnis.";break;
    case 71..80:  str="Du koenntest einen eigenen Reisefuehrer herausbringen.";break;
    case 81..90:  str="Du kennst die Winkel der Stadt wie die eigene Westentasche.";break;
    case 91..93:  str="Du kennst das MD besser als einige Gruender.";break;
    case 94..96:  if (ME->QueryProp(P_GENDER)==FEMALE)
                    str="Du bist eine beachtliche Forscherin des MD.";
                  else
                    str="Du bist ein beachtlicher Forscher des MD.";
                  break;
    case 97..98:  str="Du kennst das MD in- und auswendig. Was willst Du mehr?";break;
    case 99..100: str="Du kennst Dich hervorragend aus -> Du scheinst zu betruegen :-).";break;
    default:      str="Melde Dich bitte bei einem Magier! Fehler bei der EP-Berechnung.";break;
  }

  return ME->in_color(INFO_COL1, sprintf("%-:73s",str));
}

private string bulki_spruch() {
    int buhu;
    string str;
    buhu=to_int((to_float(ME->QueryProp(P_BULKINESS_CONTENTS)) /
      to_float(ME->QueryProp(P_MAX_BULKINESS)))* 100.0);
    switch(buhu>100?100:buhu) {
        case 0..10:
            str="Deine Taschen sind noch ziemlich leer.";break;
        case 11..20:
            str="Du koenntest noch jede Menge Dinge einpacken.";break;
        case 21..30:
            str="In Deine Taschen passt noch einiges rein.";break;
        case 31..40:
            str="Da ist noch einiges an Platz in Deinem Gepaeck.";break;
        case 41..50:
            str="Deine Beutel und Taschen sind etwa zur Haelfte gefuellt.";break;
        case 51..60:
            str="Deine Taschen sind recht gut gefuellt.";break;
        case 61..70:
            str="Langsam wird der Platz in Deinen Taschen knapp.";break;
        case 71..80:
            str="Viel passt jetzt aber wirklich nicht mehr in Dein Gepaeck.";break;
        case 81..90:
            str="Deine Taschen gehen kaum noch zu.";break;
        case 91..100:
            str="Deine Taschen drohen wegen Ueberfuellung zu platzen.";break;
        default:
            str="Melde Dich bitte bei einem Magier! Fehler bei der Bulkiness-Berechnung.";break;
    }
    return ME->in_color(INFO_COL1, sprintf("%-:73s",str));
}

/********************************************************************
* Funktion:                                                         *
*    who(string str)                                                *
*                                                                   *
* Argumente:                                                        *
*    str - Argumente fuer /global/service/werliste.c                *
*                                                                   *
* Aufgabe:                                                          *
*   Bringt die Spielerliste (Auch Intermud)                         *
********************************************************************/
static int who(string str) {
  if(query_verb()=="kwer")
    str="short "+(str?str:"");
  ME->More("/global/service/werliste"->QueryListe(IS_LEARNING(ME), 0, str));
  return 1;                                                   
}

/********************************************************************
* Funktion:                                                         *
*   muds()                                                          *
*                                                                   *
* Argumente:                                                        *
*   -k - bringt die Kurzform der Mudsliste                          *
*                                                                       *
*   muds()                                                          *
*                                                                   *
* Argumente:                                                        *
*   -k - bringt die Kurzform der Mudsliste                          *
*                [i..i+3]);
        PL->More(mud_liste);
        break;
      default:
        notify_fail("Diese Option wird nicht unterstuetzt!\n");
        return 0;
    }
    return 1;
  }

  mud_liste = sprintf("%-20s", "Mud-Name") + "  Status        Letzter Zugriff";
  mud_liste += sprintf("\n%*'-'s\n",strlen(mud_liste)+4,"");
  for(i = 0; i < sizeof(muds); i++) {
    mud_liste += sprintf("%-20s", hosts[muds[i]][HOST_NAME]) + "  " +
      (hosts[muds[i]][HOST_STATUS] ?
       hosts[muds[i]][HOST_STATUS] > 0 ?
       "OFFEN         " + dtime(hosts[muds[i]][HOST_STATUS])[5..23] :
       "GESCHLOSSEN   " + dtime(-hosts[muds[i]][HOST_STATUS])[5..23] :
       "UNBEKANNT") +
      "\n";
    }
  ME->More(mud_liste);
  return 1;
}

/********************************************************************
* Funktion:                                                         *
*    finger(string str)                                             *
*                                                                   *
* Argumente:                                                        *
*    str - Name desjenigen, den man fingern will                    *
*                                                                   *
* Aufgabe:                                                          *
*   Bringt die Finger-Info (Auch Intermud)                          *
********************************************************************/
static int finger(string str) {
  int j;
  string *args, options, text, xname;

  notify_fail("Wen willst Du fingern (hilfe finger)?\n");

  if (!str || !stringp(str))
    return 0;

  options = "";
  args = efun::explode(str, " ");

  if((j=sizeof(args))==2) {
    if (args[0][0]!='-')
      return 0;

    options = args[0][1..<1];
    xname = args[1];
  }
  else if (j==1)
    xname = args[0];
  else
    return 0;

  args = efun::explode(xname, "@");

  if((j=sizeof(args))==2) {
    if (!(text=INETD->send_udp(args[1],([ REQUEST: "finger", SENDER: getuid(ME),
                                           DATA: args[0] ]), 1))) {
      write("Anfrage abgeschickt.\n");
      return 1;
    }
  }
  else if (j==1)
    text = FINGEROBJ->finger(args[0], options);
  else
    return 0;

  if(strstr(options,"m")<0)
    write(text);
  else
    ME->More(text);

  return 1;
}

/********************************************************************
* Funktion:                                                         *
*   uhrzeit()                                                       *
*                                                                   *
* Aufgabe:                                                          *
*   Liefert die Uhrzeit im 'deutschen' Format                       *
********************************************************************/
static int uhrzeit() {
  write(dtime(time())+".\n");
  return 1;
}

/********************************************************************
* Funktion:                                                         *
*   _query_localcmds()                                              *
*                                                                   *
* Aufgabe:                                                          *
*   Liefert einen Array zurueck, das in P_LOCALCMDS eingefuegt wird *
*   (nur beim initialisieren von base.c aufgerufen)                 *
********************************************************************/
static string* _query_localcmds() {
  return ({ 
    ({"info", 		"_score", 	0, 0}),
    ({"score", 		"_score", 	0, 0}),
    ({"punkte", 	"_score", 	0, 0}),
    ({"who",		"who",		0, 0}),
    ({"wer",		"who",		0, 0}),
    ({"kwer",		"who",		0, 0}),
    ({"muds", 		"muds", 	0, 0}),
    ({"finger", 	"finger", 	0, 0}),
    ({"zeit",		"uhrzeit",	0, 0}),
    ({"uhrzeit",	"uhrzeit",	0, 0}),
  });
}

