/*******************
** Eldarea MUDLib **
********************
**
** std/player/life - player life handling
**
** CVS DATA
** $Date: 2000/12/15 15:35:00 $
** $Revision: 1.3 $
**
** longdesc
**
** CVS History
**
** $Log: life.c,v $
** Revision 1.3  2000/12/15 15:35:00  elatar
** removed obsolete variable dieing
**
** Revision 1.2  2000/12/01 16:22:55  elatar
** nude messages removed
** slightly different behavior due to pk and no ghost status
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

// Defines some things which are different than in living.c
// One example is the heart_beat().

inherit "std/living/life";

#pragma strong_types

#define NEED_PROTOTYPES

#include "thing/properties.h"
#include "player/base.h"
#include "living/combat.h"

#include <properties.h>
#include <attributes.h>
#include <config.h>
#include <health.h>
#include <wizlevels.h>
#include <language.h>

#include <defines.h>
#include <moving.h>
#include <combat.h>
#include <service.h>

static int _set_playerkills(int val);

static int time_to_save;

mixed* age_m;

void create()
{
  ::create();
  Set(P_KILLS, SAVE, F_MODE);
  Set(P_SIZE, SAVE, F_MODE_AS);
  Set(P_WEIGHT, SAVE, F_MODE_AS);
  Set(P_KILLS, SECURED, F_MODE);
  Set(P_GHOST, SAVE, F_MODE);
  // P_AGE_MONTHLY aus 'save' rausnehmen
  if (Query(P_AGE_MONTHLY, F_MODE)&SAVE) Set(P_AGE_MONTHLY, SAVE, F_MODE);
}

static int CheckForArch()
{
  return (this_interactive() && IS_ARCH(this_interactive()));
}

static int _set_playerkills(int val)
{
  mixed setter;
  int playerkills, is_arch;
  
  setter=RPL;
  if(!setter) setter=PL;
  if(!setter) setter="??"; 
  else setter=getuid(setter);
  log_file("SET_KILLS", setter + ": " + getuid(ME)
	     +" " + (string)val + " "+dtime(time())+ "\n");
  
  is_arch=CheckForArch();
  playerkills = Query(P_KILLS);
  if(intp(val) && val>=0) 
    if(is_arch) playerkills = val;
    else 
      log_file("SET_KILLS", setter + ": " + getuid(ME)
	       +" " + (string)val + " "+dtime(time())+ " illegal!\n");
  else playerkills++;
  return Set(P_KILLS, playerkills);
}

static void heart_beat() 
{
  mixed *x;

  ::heart_beat();

  if (age > time_to_save) 
  {
    save_me(1);
    time_to_save = age + 500;
  }
  if (!pointerp(age_m)) 
    age_m=allocate(3);
  if (age_m[2]==-1) 
  {
    if (age_m[0]) 
      age_m=({ 0, 0, -1 });
  } 
  else if (age_m[0]!=ctime()[4..6]+ctime()[22..]) 
  {
    age_m[0]=ctime()[4..6]+ctime()[22..];
    age_m[1]=age;
  }
}

static void set_time_to_save(int i) { time_to_save=i; }

void force_save() {
  time_to_save=0;
}

nomask int do_damage(int dam, object enemy) 
{
  string tmp,tmp2;
  int hit_point;
  
  hit_point = ME->QueryProp(P_HP);
  
  if(IS_LEARNING(ME) && !QueryProp(P_NPC) && dam>=hit_point) 
  {
    tell_object(this_object(), 
      "Deine magischen Kraefte verhindern Deinen Tod.\n");
    return 0;
  }
  // Ghosts werden wir wohl nicht mehr haben... aber egal
  if(QueryProp(P_GHOST) || dam<=0) 
    return 0;
  hit_point -= dam;
  if(hit_point<0) 
  {
    // netztot -> nicht sterben bitte
    if(query_once_interactive( ME ) && !interactive( ME )) 
    {
      hit_point = 10;
    } 
    // nicht netzttot -> ab gehts
    else 
    {
      hit_point = -1;
      if(enemy && objectp(enemy)) 
      {
        enemy->StopHuntFor(ME,1);
        // PK ist erlaubt...
        /*
        if(interactive(enemy) && enemy!=ME) 
        {
          enemy->did_pk(enemy, ME);
          return dam; // Um Skills vor falscher Meldung zu bewahren
        }*/
        tmp=dtime(time());
        tmp2=explode(file_name(enemy),"#")[0];
        if(strlen(tmp2)>33) tmp2="..."+tmp2[<31..];
        if(!ME->QueryProp(P_TESTPLAYER))
          create_kill_log_entry(tmp2+" ("+getuid(enemy) + ")");
        //catch(LIB_SENSOR->CallDeathObject(ME, enemy));
      }
      map_objects( ME->QueryEnemies()[0], "StopHuntFor", ME, 1 );
      ME->StopHuntingMode(1);
      die();
    }
  } 
  else 
  {
    // PK ist erlaubt...
    /*
    if (query_once_interactive(ME) && enemy && query_once_interactive(enemy))
      enemy->did_pk(enemy, ME);
    else */
      SetProp(P_HP, hit_point);
  }
  return dam;
}

int second_life(object corpse)
{
  mixed bstats, lstats;
  int lost_exp, l;
  if (IS_LEARNING(this_object()) && query_once_interactive(this_object()))
    {
      tell_object(this_object(),
		  "Sei froh, dass Du unsterblich bist, sonst waere es eben Dein Ende gewesen.\n");
      return 1;
    }

/*  
    if ((l=this_object()->QueryProp(P_LEVEL))<20)
    lost_exp = this_object()->QueryProp(P_XP)/3;
  else
    lost_exp = this_object()->QueryProp(P_XP)/(l-17);
  AddExp(-lost_exp);
*/

  /* Abziehen gekaufter Stats */
  bstats = this_object()->QueryProp(P_BOUGHT_STATS);
  lstats=({}); 
  lstats = this_object()->QueryProp(P_LOST_STATS);
  
  if (bstats[STAT_INT])
  {
    this_object()->SetAttribute(A_INT, this_object()->QueryRealStat(A_INT)-1);
    bstats[STAT_INT] = bstats[STAT_INT] - 1;
    lstats[STAT_INT] = lstats[STAT_INT] + 1;
  }
  if (bstats[STAT_STR])
  {
    this_object()->SetAttribute(A_STR, this_object()->QueryRealStat(A_STR)-1);
    bstats[STAT_STR] = bstats[STAT_STR] - 1;
    lstats[STAT_STR] = lstats[STAT_STR] + 1;

  }
  if (bstats[STAT_DEX])
  {
    this_object()->SetAttribute(A_DEX, this_object()->QueryRealStat(A_DEX)-1);
    bstats[STAT_DEX] = bstats[STAT_DEX] - 1;
    lstats[STAT_DEX] = lstats[STAT_DEX] + 1;
  }
  if (bstats[STAT_CON])
  {
    this_object()->SetAttribute(A_CON, this_object()->QueryRealStat(A_CON)-1);
    bstats[STAT_CON] = bstats[STAT_CON] - 1;
    lstats[STAT_CON] = lstats[STAT_CON] + 1;
  }
  if (bstats[STAT_CHA])
  {
    this_object()->SetAttribute(A_CHA, this_object()->QueryRealStat(A_CHA)-1);
    bstats[STAT_CHA] = bstats[STAT_CHA] - 1;
    lstats[STAT_CHA] = lstats[STAT_CHA] + 1;
  }
  this_object()->SetProp(P_BOUGHT_STATS, bstats);
  this_object()->log_stats("die");
  this_object()->SetProp(P_LOST_STATS, lstats);

  /* Auf Abfrage >1 wurde verzichtet, da es (eigentlich) nicht vorkommen kann,
   * dass P_BOUGHT_STATS > 0 und A_??? <= P_BOUGHT_STATS
   */

  SetProp(P_GHOST,1);
  if (!(ME->QueryProp(P_DEATH)))
    ME->SetProp(P_DEATH, 1);
  else
    ME->SetProp(P_DEATH, ME->QueryProp(P_DEATH)+1);
  clone_object("room/death/death_mark")->move(ME, M_NOCHECK);
  return 1;
}

int AddHpHook(object ob)
{
  object *hooks;
  
  if (!ob || !objectp(ob) || environment(ob)!=ME)
    return 0;
  hooks=Query(P_HP_HOOKS);
  if (!pointerp(hooks))
    {
      Set(P_HP_HOOKS,({ob}));
      return 1;
    }
  if (member(hooks,ob)>=0)
    return 0;
  Set(P_HP_HOOKS,hooks+({ob}));
  return 1;
}

int RemoveHpHook(object ob)
{
  object *hooks;
  
  if (!pointerp(hooks=Query(P_HP_HOOKS)))
    return 0;
  Set(P_HP_HOOKS,hooks-({ob}));
  return 1;
}

static int _set_hp(int hp)
{
  object *hooks;
  int ret,i,old;
  
  old=Query(P_HP);
  if (old==hp)
    return old;
  ret=life::_set_hp(hp);
  if (ret==old || !pointerp(hooks=Query(P_HP_HOOKS)))
    return hp;
  i=0;
  while (i<sizeof(hooks))
    if (!objectp(hooks[i]))
      hooks=hooks[0..i-1]+hooks[i+1..];
    else
      {
	hooks[i]->NotifyHpChange();
	i++;
      }
  Set(P_HP_HOOKS,hooks);
  return ret;
}


int AddSpHook(object ob)
{
  object *hooks;
 
  if (!ob || !objectp(ob) || environment(ob)!=ME)
    return 0;
  hooks=Query(P_SP_HOOKS);
  if (!pointerp(hooks))
    {
      Set(P_SP_HOOKS,({ob}));
      return 1;
    }
  if (member(hooks,ob)>=0)
    return 0;
  Set(P_SP_HOOKS,hooks+({ob}));
  return 1;
}


int RemoveSpHook(object ob)
{
  object *hooks;
 
  if (!pointerp(hooks=Query(P_SP_HOOKS)))
    return 0;
  Set(P_SP_HOOKS,hooks-({ob}));
  return 1;
}


static int _set_sp(int sp)
{
  object *hooks;
  int ret,i,old;
 
  old=Query(P_SP);
  if (old==sp)
    return old;
  ret=life::_set_sp(sp);
  if (ret==old || !pointerp(hooks=Query(P_SP_HOOKS)))
    return sp;
  i=0;
  while (i<sizeof(hooks))
    if (!objectp(hooks[i]))
      hooks=hooks[0..i-1]+hooks[i+1..];
    else
      {
        hooks[i]->NotifySpChange();
        i++;
      }
  Set(P_SP_HOOKS,hooks);
  return ret;
}

// Muss staendig ueberprueft werden, da sich die Stats durch einen
// Modifikator geaendert haben koennen
// obsolet, da in living/life geloest
/*
static int _query_max_hp() {
  return QueryAttribute(A_CON)*8+42;
}
*/
static int _query_max_sp() {
  return QueryAttribute(A_INT)*8+42;
}

static int _query_hp() {
  int x, y;
  x=Query(P_HP);
  if (x>(y=QueryProp(P_MAX_HP))) return Set(P_HP, y);
  return x;
}

static int _query_sp() {
  int x, y;
  x=Query(P_SP);
  if (x>(y=QueryProp(P_MAX_SP))) return Set(P_SP, y);
  return x;
}

static mixed _query_age_monthly() {
  if (!extern_call()) return age_m;
  if (!pointerp(age_m) || sizeof(age_m)!=3) return 0;
  if (age_m[2]) return ({ 0, 0, age_m[2] });
  return copy(age_m);
}

static mixed _set_age_monthly(mixed x) {
  if (!pointerp(x) || sizeof(x)!=3) return 0;
  age_m=copy(x);
  return x;
}
