/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: moneyhandler.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// M.D. MUDlib
// basierend auf der Wunderland MUDlib
//
// PLAYER/MONEYHANDLER.C -- money handler for players
//
/*
 * $Date: 1999/11/05 12:30:47 $
 * $Revision: 1.1.1.1 $
 * $Log: moneyhandler.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/08/02 10:52:00  Largo
 * Initial revision
 *
 */                    

#pragma strong_types

#include <properties.h>
#include <moving.h>
#include <defines.h>

int AddCoins(string path, int amount)
{
  object money;
  
  if (!amount) return 1;
  if (file_size((path[<2..]==".c" ? path : path+".c"))<0 || 
      !(money=clone_object(path))) return 0;
  money->SetProp(P_AMOUNT,amount);
  return money->move(this_object(),M_PUT|M_MOVE_ALL);
}

string spec_cost_str(mapping vals,object cm)
{
  int *mind;
  string *ret;
  mapping currency;
  ret = ({});
  currency = cm->query_coins();
  mind=(int*)m_indices(currency);
  for(mind=(int*)sort_array(mind, #'<);sizeof(mind);mind=mind[1..])
    if(vals[mind[0]]) 
      ret += ({ vals[mind[0]][0]+" "+
		  (vals[mind[0]][0]>1 ? 
		   currency[mind[0]][2] : 
		   currency[mind[0]][1]) });
  return ME->CountUp(ret);
}

int CMAddMoney(mixed ob, int amount, int silent)
{
  object cm;
  mixed *cash;
  if(objectp(ob)) cm=ob;
  else
    if(stringp(ob))
      {
	if(ob[<2..]!=".c") ob += ".c";
	if(file_size(ob)<0) return 0;
	call_other((string)ob,"???");
	if(!(cm=find_object((string)ob))) return 0;
      }
    else
      return 0;
  if(!amount) return 0;
  if(amount>0)
    {
      cm->GiveCoins(cm->ExchangeValue(amount),ME);
      return 1;
    }
  if(!(cash=cm->PayCash(ME,-amount))) return 0;
  cm->DoPurchase(cash,ME);
  if(!silent)
    if(!cash[1] || !mappingp(cash[1]) || !m_sizeof((mapping)cash[1]))
      tell_object(ME,break_string(
		  "Du bezahlst "+spec_cost_str(cash[0],cm)+"."));
    else
      tell_object(ME,break_string(
		  "Du bezahlst "+spec_cost_str(cash[0],cm)+" und bekommst "+
		  spec_cost_str(cash[1],cm)+" zurueck."));
  return 1;
}

int QueryCoins(string path)
{
  object money;
  if(path[<2..]==".c") path=path[0..<3];
  money=first_inventory(ME);
  while (money && load_name(money)!=path)
    money=next_inventory(money);
  if (!money) return 0;
  return money->QueryProp(P_AMOUNT);
}

int CMQueryMoney(mixed ob)
{
  object cm;
  if(objectp(ob)) cm=ob;
  else
    if(stringp(ob))
      {
	if(ob[<2..]!=".c") ob += ".c";
	if(file_size(ob)<0) return 0;
	call_other((string)ob,"???");
	if(!(cm=find_object((string)ob))) return 0;
      }
    else
      return 0;
  return cm->QueryMoney(this_object());
}
