/*******************
** Eldarea MUDLib **
********************
**
** std/player/moving.c - player moving
**
** CVS DATA
** $Date: 2001/08/18 12:05:51 $
** $Revision: 1.5 $
**
** CVS History
**
** $Log: moving.c,v $
** Revision 1.5  2001/08/18 12:05:51  eldarea
** moving default messages changed
**
** Revision 1.4  2001/05/03 21:17:54  elatar
** log paths changed
**
** Revision 1.3  2000/12/01 16:23:14  elatar
** senseless #define removed
**
** Revision 1.2  2000/01/26 14:49:04  elatar
** info char implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/             

inherit "std/living/moving";

private static int  newinv;         // Neue Invliste muss erstellt werden?
private static int* inum_buf;       // Buffer fuer die Inv-Nummern

#pragma stong_types

#define DB(x) if (find_player("elatar") ) tell_object(find_player("elatar"),x+"\n")

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <properties.h>
#include <language.h>
#include <defines.h>
#include <wizlevels.h>

void create()
{
  SetProp(P_MMSGIN,  "&Name tritt aus einer Schwefelwolke");
  SetProp(P_MMSGOUT, "&Name verschwindet mit Knall und Schwefelduft");
  Set(P_MMSGIN,  SAVE, F_MODE);
  Set(P_MMSGOUT, SAVE, F_MODE);
  newinv=1;
}

// autoload and nodrop object may not fall into the environment
varargs int remove()
{
  mixed dest_obj, err;

  if (!query_once_interactive(ME)) return ::remove();
  if (interactive(ME)) catch(HURRIKAP->notify_player_leave(getuid(ME)));
  for(dest_obj=deep_inventory(ME);sizeof(dest_obj);dest_obj=dest_obj[1..])
    if(dest_obj[0]->QueryProp(P_AUTOLOADOBJ) ||
       dest_obj[0]->QueryProp(P_NODROP))
      {
        if(err=catch(dest_obj[0]->remove()))  // soft
          if(dest_obj[0]) log_file("obj/remove.err", file_name(dest_obj[0])+
            " error on remove: "+err+"\n");
        if(dest_obj[0]) destruct(dest_obj[0]);  // hard
      }
  
  // self destruction
  if(!QueryProp(P_INVIS))
    catch(say(capitalize(ME->name(WER,1)) + " verlaesst diese Welt.\n", ME));
  else
    if (!IS_LEARNER(ME)) catch(say("Jemand verlaesst diese Welt.\n", ME));
  
  if(ME) tell_object(ME, "Bis bald!\n");
  if((PL && getuid(ME) != getuid(PL)))
    log_file("user/remove",dtime(time())+" "+geteuid(ME)
	     +" vern. von "+geteuid(PL)+"\n");
  return (int)::remove();
}

// Flag setzen, die inum_buf zu erneuern, wenn ein Move in uns rein
nomask void ContentChanged() {
  newinv=1;
}

// Nummer fuer die 'i<num>'-Syntax herausfinden. Evt neue Liste mit den
// Nummern erstellen
public int my_inv_nr(object whom) {
  object *inv;
  int i, j, k, size;
  string* ids;
  i=member(inv=all_inventory(), whom);
  if (i==-1) return 0;
  if (!newinv) return inum_buf[i];
  // Neu erstellen
  size=sizeof(inv);
  inum_buf=allocate(size);
  for (k=0; k<size; k++) {
    // Nummern werden nur an Objekte vergeben, die short() oder P_PLURAL
    // haben, kein IsMoney() sind, und mindestens eine P_ID haben, die
    // nicht mit \n beginnt
    if ((inv[k]->short() || inv[k]->QueryProp(P_PLURAL)) &&
          !inv[k]->IsMoney() && pointerp(ids=inv[k]->QueryProp(P_IDS)) &&
          sizeof(map_array(ids, #'[, 0)-({'\n'}))) {
      inum_buf[k]=++j;
    } else {
      inum_buf[k]=0;
    }
  }
  newinv=0;
  return inum_buf[i];
}
