/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: objects.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// M.D. MUDlib
// basierend auf Wunderland MUDlib
//
// PLAYER/OBJECTS.C -- object handling for player
//
/*
 * $Date: 1999/11/05 12:30:47 $
 * $Revision: 1.1.1.1 $       
 * $Log: objects.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/08/02 10:17:13  Largo
 * Initial revision
 *
 */                            

#pragma strong_types

#define NEED_PROTOTYPES
#include "/sys/player/filesys.h"

#include <config.h>
#include <properties.h>
#include <language.h>
#include <moving.h>
#include <wizlevels.h>
#include <defines.h>

static int update_object(string str)
{
  object ob;
  string upd_file;

  if(!str)
    {
      notify_fail("Usage: Update <object_path>\n");
      return 0;
    }
  upd_file = find_file(str,".c");
  if(!upd_file) upd_file=find_file(str);
  if(!upd_file)
    {
      notify_fail(str+": No such file.\n");
      return 0;
    }
  if(!ob=find_object(upd_file))
    {
      notify_fail(upd_file+": No such object.\n");
      return 0;
    }
  destruct(ob);
  write(upd_file + ": will be reloaded at next reference.\n");
  return 1;
}

/*
 * "soft" means that the object is given the chance to self-destruct, thus
 * allowing it to do necessary cleanup like subtracting from the carried
 * weight of the environment(). We call remove() in the object to be
 * destructed.
 */

static int soft_update_object(string str) 
{
  object ob;
  string upd_file;
  
  if(!str)
    {
      notify_fail("Usage: update <object_path>\n");
      return 0;
    }
  upd_file = find_file(str,".c");
  if(!upd_file) upd_file=find_file(str);
  if(!upd_file)
    {
      notify_fail(str+": No such file.\n");
      return 0;
    }
  if(!ob=find_object(upd_file))
    {
      notify_fail(upd_file+": No such object.\n");
      return 0;
    }
  if(ob->remove() == 0)
    {
      notify_fail(upd_file+": doesn't want to be destructed!\n");
      return 0;
    }
  write(upd_file + ": will be reloaded at next reference.\n");
  return 1;
}

int clone(string str) 
{
  object ob;
  string clone_file;

  if(!str)
    {
      notify_fail("Usage: clone <object_path>\n");
      return 0;
    }
  clone_file = find_file(str,".c");
  if(!clone_file) clone_file=find_file(str);
  if(!clone_file)
    {
      notify_fail(str+": No such file.\n");
      return 0;
    }
  ob = clone_object(clone_file);

  /* try to move the object to my environment */
  if((ob && ob->move(ME,M_GET)>0) ||
     (ob && ob->move(environment(),M_NOCHECK)>0))
    {
      write("Cloned "+file_name(ob)+".\n");
      // erweitert um P_CLONEMSG Fiona 28.10.
      str=ME->QueryProp(P_CLONEMSG);
      if (!stringp(str)) say(capitalize(this_player()->name(WER,1))+" zieht etwas aus "+
	  this_player()->QueryPossPronoun(MALE,WEM)+" Hut.\n",ME);
      else say(capitalize(this_player()->name(WER,1))+" "+str+"\n", ME);
      return 1;
    }
  str=ME->QueryProp(P_CLONEFMSG);
  if (!stringp(str)) say(capitalize(ME->name(WER,1))+
      " schuettelt "+ME->QueryPossPronoun(MALE,WEN)+
      " Hut, aber nichts kommt raus ...\n",ME);
  else say(capitalize(ME->name(WER,1))+" "+str+"\n", ME);
  if (ob) destruct(ob);
  write(clone_file+": failed to move\n");
  return 1;
}

/*
 * "soft" means that the object is given the chance to self-destruct, thus
 * allowing it to do necessary cleanup like subtracting from the carried
 * weight of the environment(). We call remove() in the object to be
 * destructed.
 */

static int soft_destruct_object(string str)
{ 
  object ob;
  object *obs;
  string strWER,strWEN;

  if(!str)
    {
      notify_fail("Usage: destruct <objectname>\n");
      return 0;
    }
  strWER = lower_case(str);
  obs = this_player()->select_objects(strWER, 0, 2);
  if(!obs || !sizeof(obs))
    {
      notify_fail("Kein \"" + str + "\" gefunden.\n");
      return 0;
    }
  ob=obs[0];
  strWER=ob->name(WER);
  strWEN=ob->name(WEN);
  if(!strWER)
    if(living(ob))
      strWER="jemand";
    else
      strWER="etwas";
  if(!strWEN)
    if(living(ob))
      strWER="jemanden";
    else
      strWER="etwas";

  if(ob->remove() == 0)
    {
      notify_fail(strWER+" will nicht 'destructed' werden!\n");
      str=ME->QueryProp(P_DESTFMSG);
      if (!stringp(str)) say(capitalize(ME->name(WER,1))+" versucht vergeblich, "+
	  strWEN+" auszuschalten.\n");
      else say(capitalize(strWER)+" "+str+"\n");
      return 0;
    }
  str=ME->QueryProp(P_DESTMSG);
  if (!stringp(str)) say(capitalize(strWER)+" wird von "+ME->name(WEM,1)
      +" ausgeschaltet.\n",ME);
  else say(capitalize(strWER)+" "+str+"\n");
  write(capitalize(strWER)+" wird von Dir ausgeknipst.\n");
  return 1;
}

static int destruct_object(string str)
{ 
  object ob;
  object *obs;
  string strWER,strWEN;
  
  if(!str)
    {
      notify_fail("Usage: Destruct <objectname>\n");
      return 0;
    }
  obs=ME->select_objects(lower_case(str), 0, 2);
  if(!obs || !sizeof(obs))
    {
      notify_fail("Kein \"" + str + "\" gefunden.\n");
      return 0;
    }
  ob=obs[0];
  strWER=ob->name(WER);
  strWEN=ob->name(WEN);
  if(!strWER)
    if(living(ob))
      strWER="jemand";
    else
      strWER="etwas";
  if(!strWEN)
    if(living(ob))
      strWER="jemanden";
    else
      strWER="etwas";

  str=ME->QueryProp(P_DESTMSG);
  if (!stringp(str)) say(capitalize(strWER)+" wird von "+ME->name(WEM,1)
      +" abgeschossen.\n",ME);
  else say(capitalize(strWER)+" "+str+"\n");
  destruct(ob);
  write(capitalize(strWER)+" wird von Dir gewaltsam entfernt.\n");
  return 1;
}

/*
 * load object. If it cant be loaded errormsg is returned, else
 * 0 is returned.
 * We just call a non existing function in the object, and that way
 * force it to be loaded.
 */

string load_object(string file)
{
  return catch(call_other(file,"???"));
}

static int load(string str)
{ 
  object env;
  string file;
  string err;

  if(!str)
    {
      notify_fail("Usage: load <object_path>\n");
      return 0;
    }
  file = find_file(str,".c");
  if(!file) file=find_file(str);
  if(!file)
    {
      notify_fail(str+": No such file.\n");
      return 0;
    }
  if (err=load_object(file)) write("cannot load "+file+",\nerr = "+err+"\n");
  else write(file+"\n");
  return 1;
}

static int exec_playerob(string name)
{
  object ob, *inv;
  int i;
  
  if(!IS_LORD(ME)) return 0;
  if(PL != this_interactive()) return 0;
  if(PL != ME) return 0;
  if(!name) return 0;
  name="secure/master"->_get_path(name,getuid(this_object()));
  if(catch(call_other(name,"????"))) 
    { 
      write("BUG in "+name+"\n");
      return 1;
    }
  if(!ob=clone_object(name)) return 0;
  if(getuid(ob) != getuid(ME))
    {
      write("UID conflict.\n");
      destruct(ob);
      return 1;
    }
  log_file("EXEC", getuid(ME)+" "+name+" "+dtime(time()));
  disable_commands();
  exec(ob,ME);
  if(interactive(ME) || !interactive(ob))
    {
      enable_commands();
      write("Fehler in exec\n");
      return 1;
    }
  inv=all_inventory(ME);
  ob->start_player(capitalize(getuid(ME)));
  this_object()->remove();
  return 1;
}

static string *_query_localcmds()
{
  return ({
    ({"clone","clone",0,LEARNER_LVL}),
    ({"destruct","soft_destruct_object",0,LEARNER_LVL}),
    ({"Destruct","destruct_object",0,LEARNER_LVL}),
    ({"load","load",0,LEARNER_LVL}),
    ({"update","soft_update_object",0,LEARNER_LVL}),
    ({"Update","update_object",0,LEARNER_LVL}),
    ({"exec","exec_playerob",0,LORD_LVL})
    });
}
