/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: potion.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD MUDlib
//
// PLAYER/POTION.C -- potion handling for player
//
// basierend auf Wunderland MUDlib
//
// $Log: potion.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/09/07 11:43:08  Largo
// Initial revision
//

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/thing/properties.h"
#include "/sys/player/potion.h"
#include "/sys/player/stat.h"
#include "/sys/player/base.h"

#include <properties.h>
#include <attributes.h>
#include <defines.h>
#include <wizlevels.h>
#include <guilds.h>
#include "/std/sys_debug.h"

#define POTIONMASTER "secure/potionmaster"

static mixed *list;
static mixed roomsave;

mixed *potionrooms;

static mixed _query_potionrooms();
static void remove_potion();

void create() 
{ 
  if (!potionrooms) potionrooms=POTIONMASTER->InitialList();
  Set(P_POTIONROOMS, -1, F_SET_METHOD);	     // no tampering by methods
  Set(P_POTIONROOMS, SECURED, F_MODE);       // no tampering with list
  Set(A_MAX_CON, 50);
  Set(A_MAX_CON, -1, F_SET_METHOD);
  Set(A_MAX_CON, PROTECTED, F_MODE);
  Set(A_MAX_DEX, 50);
  Set(A_MAX_DEX, -1, F_SET_METHOD);
  Set(A_MAX_DEX, PROTECTED, F_MODE);
  Set(A_MAX_STR, 50);
  Set(A_MAX_STR, -1, F_SET_METHOD);
  Set(A_MAX_STR, PROTECTED, F_MODE);
  Set(A_MAX_INT, 50);
  Set(A_MAX_INT, -1, F_SET_METHOD);
  Set(A_MAX_INT, PROTECTED, F_MODE);
}

static int SelectWhich();
static int ask_question();
static int get_answer(string erg);
static int raise(string what);
static int tausch_answer(string erg);
static int tauschen();
static int tausch(string what);

varargs static int ReportPotion(string s)
{
  if(s) write(break_string(s));
  else write("Du findest einen Zaubertrank, den Du sofort trinkst.\n");
  SelectWhich();
  return 1;
}

varargs int FindPotion(string s)
{
  int flag;
  if(ME->QueryProp(P_TRANK_FINDEN) && IS_WIZARD(this_object()))
    return ReportPotion(s);
  if(!potionrooms || potionrooms==({})) return 0;
  if(!(POTIONMASTER->InList(previous_object(), potionrooms)))
    return 0;
  roomsave = previous_object();
  return ReportPotion(s);
}

static int SelectWhich()
{
  int i;
  mixed max;

  list=({"Intelligenz","Kraft","Geschicklichkeit","Ausdauer"});

  if (ME->QueryRealStat(A_INT) >= ME->QueryProp(P_MAX_STATS)[STAT_INT])
    list-=({"Intelligenz"});
  if (ME->QueryRealStat(A_STR) >= ME->QueryProp(P_MAX_STATS)[STAT_STR])
    list-=({"Kraft"});
  if (ME->QueryRealStat(A_DEX) >= ME->QueryProp(P_MAX_STATS)[STAT_DEX])
    list-=({"Geschicklichkeit"});
  if (ME->QueryRealStat(A_CON) >= ME->QueryProp(P_MAX_STATS)[STAT_CON])
    list-=({"Ausdauer"});

  if (!sizeof(list))
  {
	list=({"Intelligenz","Kraft","Geschicklichkeit","Ausdauer"});

	if (!ME->QueryProp(P_BOUGHT_STATS)[STAT_INT]) list -= ({"Intelligenz"});
	if (!ME->QueryProp(P_BOUGHT_STATS)[STAT_STR]) list -= ({"Kraft"});
	if (!ME->QueryProp(P_BOUGHT_STATS)[STAT_DEX]) list -= ({"Geschicklichkeit"});
	if (!ME->QueryProp(P_BOUGHT_STATS)[STAT_CON]) list -= ({"Ausdauer"});

	if (!sizeof(list))
	{
		ME->heal_self(10000000);
		write("Der Trank hat Dich geheilt.\n");
		remove_potion();
		roomsave = 0;
		return 1;
	}

	if (sizeof(list) == 1) return tausch(list[0]);

	tauschen();

	return 1;
  }

  if (sizeof(list)==1) return raise(list[0]);

  ask_question();
  return 1;
}

static int tauschen()
{
	int i;

	tell_object(ME, break_string("Du hast bereits die maximal moeglichen Statwerte erreicht."
		" Daher kannst Du jetzt einen Deiner gekauften Statpunkte durch diesen Zaubertrank"
		" ersetzen. Deine Attribute sehen so aus:"));

	tell_object(ME, sprintf("Intelligenz     : %2d (%d gekauft)",
		ME->QueryRealStat(A_INT), ME->QueryProp(P_BOUGHT_STATS)[STAT_INT]) + "\n");
	tell_object(ME, sprintf("Kraft           : %2d (%d gekauft)",
		ME->QueryRealStat(A_STR), ME->QueryProp(P_BOUGHT_STATS)[STAT_STR]) + "\n");
	tell_object(ME, sprintf("Geschicklichkeit: %2d (%d gekauft)",
		ME->QueryRealStat(A_DEX), ME->QueryProp(P_BOUGHT_STATS)[STAT_DEX]) + "\n");
	tell_object(ME, sprintf("Ausdauer        : %2d (%d gekauft)",
		ME->QueryRealStat(A_CON), ME->QueryProp(P_BOUGHT_STATS)[STAT_CON]));

	tell_object(ME, "\n\nWo moechtest Du ersetzen? Du hast folgende Moeglichkeiten:\n");

	for(i = 0;i < sizeof(list); i++)
		tell_object(ME, sprintf("%d) %s\n", i + 1,list[i]));

	tell_object(ME, sprintf("\nBitte gib jetzt eine Zahl (1-%d) an: ", i));

	input_to("tausch_answer");

	return 1;
}

static int ask_question()
{
  int i;
  
  write("Deine Attribute sehen so aus:\n");
  write("\nIntelligenz     : "+ME->QueryRealStat(A_INT));
  write("\nKraft           : "+ME->QueryRealStat(A_STR));
  write("\nGeschicklichkeit: "+ME->QueryRealStat(A_DEX));
  write("\nAusdauer        : "+ME->QueryRealStat(A_CON));
  write("\n\nWas moechtest Du erhoehen ? Du hast folgende Moeglichkeiten:\n");
  for(i=0;i<sizeof(list);i++)
    printf("%d) %s\n", i+1,list[i]);
  printf("\nBitte gib jetzt eine Zahl (1-%d) an: ", i);
  input_to("get_answer");
  return 1;
}

static int get_answer(string erg)
{
  int num;

  if(erg && stringp(erg))
  {
    if((num=to_int(erg))<1) num=0;
    if(num>0 && num<=sizeof(list))
      return raise(list[num-1]);
  }
  write("Deine Wahl war ungueltig. Bitte versuchs nochmal !\n\n");
  return ask_question();
}

static int tausch_answer(string erg)
{
  int num;

  if(erg && stringp(erg))
  {
    if((num=to_int(erg))<1) num=0;
    if(num>0 && num<=sizeof(list))
      return tausch(list[num-1]);
  }
  write("Deine Wahl war ungueltig. Bitte versuchs nochmal !\n\n");
  return tauschen();
}

static int raise(string what)
{
	string attr;
	int yet, index;

	switch(what) 
	{
		case "Geschicklichkeit": 
			attr  = A_DEX;
			index = STAT_DEX;
			break;
		case "Intelligenz": 
			attr  = A_INT; 
			index = STAT_INT;
			break;
		case "Kraft":
			attr  = A_STR;
			index = STAT_STR;
			break;
		case "Ausdauer":
			attr  = A_CON;
			index = STAT_CON;
			break;
		case "Charisma":
			attr  = A_CHA;
			index = STAT_CHA;
			break;
		default:
			return 0;
	}

	yet = ME->QueryRealStat(attr);

	ME->SetAttribute(attr, yet + 1);

	printf("Deine %s hat sich von %d auf %d erhoeht.\n", what, yet, yet + 1);

	remove_potion();

	roomsave = 0;

	log_stats("potion");

	ME->save_me(1);

	return 1;
}

static int tausch(string what)
{
	int index, *bought;

	switch(what) 
	{
		case "Geschicklichkeit":
			what = "Geschicklichkeits";
			index = STAT_DEX;
			break;
		case "Intelligenz":
			index = STAT_INT;
			break;
		case "Kraft":
			index = STAT_STR;
			break;
		case "Ausdauer":
			index = STAT_CON;
			break;
		default:
			return 0;
	}

	bought = ME->QueryProp(P_BOUGHT_STATS);
	bought[index] -= 1;

	ME->SetProp(P_BOUGHT_STATS, bought);

	printf("Du hast einen gekauften %s-Punkt umgewandelt.\n", what);

	remove_potion();

	roomsave = 0;

	log_stats("potion");

	ME->save_me(1);

	return 1;
}

static mixed _query_potionrooms()
{
  return Set(P_POTIONROOMS, potionrooms);
}


static void remove_potion()
{
  if (roomsave)
  {
    POTIONMASTER->log_potion(dtime(time()) + "  " +capitalize(getuid()) + " in " +
             file_name(roomsave) + "\n");
    potionrooms=POTIONMASTER->RemoveList(roomsave, potionrooms);
  }
}
