/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: quests.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland MUDlib
// basierend auf MorgenGrauen MUDlib
//
// PLAYER/QUESTS.C -- quest handler
//
/*
 * $Date: 1999/11/05 12:30:47 $                      
 * $Revision: 1.1.1.1 $       
 * $Log: quests.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.7  1998/07/24 12:42:10  Holger
 * Auch nichtexistente Quests koennen nun geloescht werden
 *
 * Revision 1.6  1998/06/27 03:17:05  Gum
 * kleine aenderungen im header
 * 78 in BS_STDLEN geaendert
 *
 * Revision 1.5  1997/04/26 16:19:28  Gum
 * bei der meldung ueber eine geloeste quest wird der real_name ausgegeben
 *
 * Revision 1.4  1994/12/01  09:19:03  Troy
 * reindented
 * Added ME-> to function calls to allow shadowing
 *
 * Revision 1.4  1994/11/30  13:51:55  Troy
 * reindented
 *
 * Revision 1.3  1994/10/26  18:05:34  Arachna
 * Neue MG-Release
 *
 */                            

// Dieses Modul enhaelt die Quest-spezifischen Teile der Playerobjekte.

#pragma strong_types

#define NEED_PROTOTYPES

#include <player/quest.h>
#include <thing/properties.h>
#include <questmaster.h>
#include <wizlevels.h>
#include <daemon.h>
#include <language.h>

#define FILE(x)	(explode(file_name(x),"#")[0])

mixed quests;

int QueryQuest(string questname);

// local properties prototype
static mixed _query_quests();
static int _set_questpoints(int qp);
static int _query_questpoints();

void create() {
  Set(P_QUESTS, -1, F_SET_METHOD);
  Set(P_QUESTS, quests = ({}));
  Set(P_QUESTS, SECURED, F_MODE);
  Set(P_QP, SAVE, F_MODE);
  Set(P_QP, SECURED, F_MODE);
}

varargs int GiveQuest(string questname, string message) {
  mixed *quest;

  // Quest schon gesetzt
  if(QueryQuest(questname))
    return -1;
  // Quest nicht angemeldet
  if(!(quest=QM->QueryQuest(questname)) || !pointerp(quest)|| quest==({})) 
    return -2;
  // Unbefugter Zugriff auf deaktivierte Quest
  if(!quest[6]&&!IS_ARCH(this_interactive())) 
    return -4;
  // Unbefugter Zugriff
  if(member_array(FILE(previous_object()),quest[2])==-1 &&
     !IS_ARCH(this_interactive()))
    return -3;
  Set(P_QP, QueryProp(P_QP)+quest[0]);
  this_object()->AddExp(quest[1]);
  if(quests)
    quests+=({({questname,quest[0]})});
  else
    quests=({({questname,quest[0]})});
  this_object()->force_save();
  if(message && message!="")
    if(message!="__silent__")
      message=implode(efun::explode(message,"@@name@@"),
        this_object()->name(WER));
    else
      message="";
  else
    message=capitalize(this_object()->query_real_name())+
      " hat gerade ein Abenteuer bestanden: "+questname+"\n";
  if(message!="")
    catch("/secure/questmaster"->Channel(message));
  return 1;
}

int DeleteQuest(string questname) {
  mixed *quest;
  int i;
  
  // Quest ist nicht gesetzt
  if(!QueryQuest(questname)) 
    return -1;
  // Quest nicht angemeldet
  if((!(quest=QM->QueryQuest(questname)) || !pointerp(quest) || !sizeof(quest)) && 
    !QueryQuest(questname))
      return -2;
  // Unbefugter Zugriff
  if(!IS_ARCH(this_interactive())) 
    return -3;
  for(i=sizeof(quests)-1;i>=0;i--)
    if(quests[i][0]==questname)
      break;
  if(pointerp(quest) && sizeof(quest)) {       // angemeldete
    Set(P_QP, QueryProp(P_QP)-quest[0]);
    this_object()->AddExp(-quest[1]);
  }
  else {
    Set(P_QP, QueryProp(P_QP)-quests[i][1]);  // andere
  }
  quests=quests[0..i-1]+quests[i+1..];
  this_object()->force_save();
  return 1;
}

int QueryQuest(string questname) {
  int i,dummy;
  
  if(sscanf(getuid(), "gast%d", dummy)==1)
    return 2;
  if(!questname || !stringp(questname) || questname == "")
    return 0;
  for(i = sizeof(quests)-1; i >= 0; i--)
    if(questname==quests[i][0])
      return 1;
  return 0;
}

// **** local property methods

static int _query_questpoints() {
  mixed *quest;
  string qname;
  int i;
  int questpoints;
  
  if(!pointerp(quests)||sizeof(quests)==0) {
    SetProp(P_QP, 0);
    if(this_interactive()==this_object()) this_object()->save_me(1);
    return 0;
  }
  questpoints = Query(P_QP);
  quests-=({({})});
  for(i=0;i<sizeof(quests);i++) {
    if(pointerp(quests[i]) && sizeof(quests[i]))
      qname=quests[i][0];
    else
      qname=quests[i];
    if(pointerp((quest==QM->QueryQuest(qname)))) {
      if(pointerp(quests[i])) {
        questpoints-=quests[i][1];
        questpoints+=quest[0];
        quests[i][1]=quest[0];
      }
      else 
        quests[i]=({quests[i],quest[0]});
    }
  }
  if(this_interactive()==this_object()) 
    this_object()->save_me(1);
  return Set(P_QP, questpoints);
}

static int _set_questpoints(int qp) {
  if(!IS_ARCH(this_interactive())) 
    return -1;
  return Set(P_QP, qp);
}

static mixed _query_quests() {
  return quests[0..];
}
