/*******************
** Eldarea MUDLib **
********************
**
** std/player/restrictions.c - container aspect of players
**
** CVS DATA
** $Date: 2000/12/01 16:23:38 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: restrictions.c,v $
** Revision 1.2  2000/12/01 16:23:38  elatar
** inheritance changed: from std/container to std/humanoid
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "/std/humanoid/restrictions";

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/thing/properties.h"
#include <properties.h>
#include <wizlevels.h>
#include <container.h>
#include <attributes.h>
#include <defines.h>

// local properties prototypes
static int QueryMaxWeight();
static int QueryMaxBulkiness();

void create()
{
  ::create();
  Set(P_MAX_WEIGHT, #'QueryMaxWeight, F_QUERY_METHOD);
  Set(P_MAX_WEIGHT, SECURED, F_MODE);
  Set(P_MAX_BULKINESS, #'QueryMaxBulkiness, F_QUERY_METHOD);
  Set(P_MAX_BULKINESS, SECURED, F_MODE);
  SetProp(P_BULKINESS, 900);
}

static int QueryMaxBulkiness()
{
  switch(ME->QueryProp(P_SIZE))
  {
    case   0..50  : return 800;
    case  51..100 : return 900;
    case 101..150 : return 1000;
    case 151..200 : return 1100;
    default       : return 1200;
  }
}

static int QueryMaxWeight()
{
  if(ME->QueryProp(P_GHOST) && !IS_WIZARD(ME))
    return 0;
  return 10000 + ((ME->QueryAttribute(A_STR) + 
          (2 * ME->QueryAttribute(A_CON))) * 333);
}

object *InsertHooks=({});

int PreventInsert(object ob)
{
  int i;
  i=0;
  while(i<sizeof(InsertHooks))
    if(!objectp(InsertHooks[i]))
      InsertHooks=InsertHooks[0..i-1]+InsertHooks[i+1..];
    else
      {
	InsertHooks[i]->InsertNotify(ob);
	i++;
      }
  return 0;
}

void AddInsertHook(object ob)
{
  if(member(InsertHooks,ob)!=-1 || environment(ob)!=this_object())
    return;
  InsertHooks+=({ob});
}

void RemoveInsertHook(object ob)
{
  InsertHooks-=({ob});
}

object *QueryInsertHooks()
{
  return InsertHooks;
}
