/*******************
** Eldarea MUDLib **
********************
**
** std/player/settings.c - player settings
**
** CVS DATA
** $Date: 2000/12/01 16:24:13 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: settings.c,v $
** Revision 1.3  2000/12/01 16:24:13  elatar
** hands, msgin, msgout settings removed
** messages changed
** mud sound settings debugged
**
** Revision 1.2  2000/08/04 10:53:52  eldarea
** mud sound protocol settings added
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#include <properties.h>
#include <defines.h>
#include <wizlevels.h>
#include <terminal.h>
#include <ansi.h>
#include <homes.h>
#include <player/base.h>

#define NEED_PROTOTYPES
#include <thing/properties.h>
#include <thing/description.h>
#include <language.h>
#include <sound.h>

static varargs int nedit(string exitfunc, string pretext, mixed args);
static void gettty(string ttystr);
varargs mixed More(string str, int flag, string returnto);

private static string passw;        /* temporarily for password change */
private static string passwold;     /* temporarily for password change */
private static object sec;          /* temporarily for setsecond       */

void create() {
  Set(P_SCREENSIZE, SAVE,F_MODE);
  Set(P_SCREENSIZE, 20);
  SetProp(P_LONG, "" );
  SetProp(P_TITLE, "");
  SetProp(P_TTY, "vt100"); 
  Set(P_TTY, SAVE, F_MODE);
  SetProp(P_HANDS, ({" mit blossen Haenden", 30})); 
  Set(P_HANDS, SAVE, F_MODE);
  Set(P_EXTRA_LOOK, SAVE, F_MODE);
  Set(P_SECOND, SAVE, F_MODE);
  Set(P_MAILADDR, SAVE, F_MODE);
  Set(P_HOMEPAGE, SAVE, F_MODE);
  Set(P_MUD_SOUND_PROTOCOL, 0);
  Set(P_MUD_SOUND_PROTOCOL, SAVE, F_MODE);
  Set(P_MSP_SETTINGS, ([SND_VOLUME:100,SND_MUSIC:100,SND_SOUND:100]));
  Set(P_MSP_SETTINGS, SAVE, F_MODE);
}

// *** Aendern der Email-Adresse ***
static int set_email(string str) {
  if (!str) {
    write("Eure offizielle Email-Adresse lautet: " + QueryProp(P_MAILADDR) +"\n");
    return 1;
  }
  write("Eure offizielle Email-Adresse wurde geaendert.\n");
  return SetProp(P_MAILADDR, str);
  return 1;
}

// *** Aendern des Homepage URL ***
static int set_homepage(string str) {
  mixed homepage;

  if (!str) {
    homepage = QueryProp(P_HOMEPAGE);
    if (!homepage)
      write("Ihr habt noch keine offizielle Homepage-Adresse angegeben.\n");
    else
      write("Eure offizielle Homepage-Adresse lautet:\n \" " + homepage +" \"\n");
    return 1;
  }
  write("Eure offizielle Homepage-Adresse wurde geaendert.\n");
  return SetProp(P_HOMEPAGE, str);
  return 1;
}

// *** set player moving messages ***

static int setmmin(string str) 
{
  if (-1==strstr(str,"&Name") && -1==strstr(str,"&name"))
  {
    write("Euer Name muss schon in der Meldung enthalten sein.\n");
    return 1;  
  }
  SetProp(P_MMSGIN, str);
  write("Ok.\n");
  return 1;
}

static int setmmout(string str) 
{
  if (-1==strstr(str,"&Name") && -1==strstr(str,"&name"))
  {
    write("Euer Name muss schon in der Meldung enthalten sein.\n");
    return 1;  
  }
  SetProp(P_MMSGOUT, str);
  write("Ok.\n");
  return 1;
}

// *** Aendern von Titel, Vortitel und Extralook ***
static int set_title(string str) {
  string bonus;
  
  bonus = "";
  if(!str) str="";
  else if(str[0]==',') {
    bonus = "\b"; // ein backspace fuer ein komma ist ok! :-)
  }
  SetProp(P_TITLE, bonus+str);
  write("Ok.\n");
  return 1;
}

int vortitel(string str) {
  notify_fail("Wie soll Eure Vortitel lauten?\n");

  if (!str)
    if (!QueryProp(P_PRESAY) || QueryProp(P_PRESAY)=="")
      return 0;
    else {
      SetProp(P_PRESAY,0);
      write("OK.\n");
      return 1;
    }
 
  if (!stringp(str)) return 0;

  if (strlen(str)>30) {
    write("Der Vortitel ist zu lang. Es sind maximal 30 Zeichen erlaubt.\n");
    return 1;
  }

  SetProp(P_PRESAY, str);
  write("OK.\n");
  return 1;
}

static int extralook(mixed str) {
  if( str=="?" ) {
    if (!QueryProp(P_EXTRA_LOOK)) {
      write("Ihr hast keinen Extralook gesetzt.\n");
      return 1;
    }
    write( "Euer Extralook ist : \n"+break_string(QueryProp(P_EXTRA_LOOK)) );
    return 1;
  }
  if( !stringp(str) || str=="" ) {
    write("Wie soll Euer Extralook denn aussehen? (Nur . zum Loeschen.)\n"
      "** oder . wenn fertig. ~q fuer Abbruch, ~h fuer eine Hilfeseite\n" );
    nedit("extralook2", 0);
    return 1;
  }
  str=implode(explode(str, "\\n"), "\n"); // Erlaubt \n anzugeben
  SetProp(P_EXTRA_LOOK, str);
  write("Ok.\n");
  return 1;
}

static void extralook2(string str) {
  if (!str) write("Abbruch.\n");
  else if (str=="") {
    write("Extralook wird geloescht.\n");
    SetProp(P_EXTRA_LOOK, 0);
  } else extralook(str);
}

// *** Setzen der Wegmeldung ***
static int weg(string str) 
{
  if (!str) 
  {
    printf("Ihr seid nicht%s als abwesend gekennzeichnet.\n", 
	     QueryProp(P_AWAY) ? " mehr" : "");
    SetProp(P_AWAY, 0);
    return 1;
  }
  else if (strlen(str)>50)
  {
    printf("Die Abwesenheitsmeldung sollte nicht laenger als 50 Zeichen "
           "sein.\n%s",QueryProp(P_AWAY)?
             "Ihr seid als abwesend gekennzeichnet.\n":
             "Ihr seid nicht als abwesend gekennzeichnet.\n");
    return 1;
  }
  write("Ihr seid jetzt als abwesend gekennzeichnet.\n");
  SetProp(P_AWAY, str);
  return 1;
}

// *** Setzen der Bildschirmgroesse ***
static int set_screensize(string str) {
  int size;

  if (!str || str=="" || !sscanf(str,"%d",size) || size<0 || size>100) {
    printf(break_string("zeilen <groesse> stellt ein, wieviele Zeilen "
	  "bei mehrseitigen Texten auf einmal ausgegeben "
	  "werden und muss zwischen 0 und 100 liegen. Bei "
	  "der Groesse 0 wird einfach alles ausgegeben "
	  "(ohne Pause). Die Voreinstellung ist 20 Zeilen. "
	  "Eure Schirmgroesse steht derzeit auf %d."),
	  QueryProp(P_SCREENSIZE));
    return 1;
  }
  SetProp(P_SCREENSIZE,size);

  printf("Eure Zeilenzahl steht nun auf %d.\n",size);
  return 1;
}

// *** Aendern des Passwortes ***
static int change_password() {
  string verb;
  verb=query_verb();
  if (verb!="passwd"&&verb!="password"&&verb!="passwort")
    return 0;
  write("Bitte das ALTE Password angeben: ");
  input_to("change_password2",1);
  return 1;
}

static int change_password2(string str) {
  write("\n");
  if (!str) str == "";
  if (MASTER->update_password(str,str) == 0) {
    write("Falsches Password!\n");
    return 1;
  }
  passwold = str;
  write("Bitte das NEUE Password eingeben: ");
  input_to("change_password3",1);
  return 1;
}

static int change_password3(string str) {
  write("\n");
  if ((!str) || str == "") {
    write("Abgebrochen !\n");
    return 1;
  }
  if (strlen(str) < 6) {
    write("Das neue Password muss mindestens 6 Zeichen lang sein !\n");
    write("Bitte das NEUE Password eingeben: ");
    input_to("change_password3",1);
    return 1;
  }
  passw = str;
  write("Nochmal: ");
  input_to("change_password4",1);
  return 1;
}

static int change_password4(string str) {
  write("\n");
  if (!str || str != passw) {
    write("Das war verschieden! Password NICHT geaendert.\n");
    return 1;
  }
  if (MASTER->update_password(passwold,passw))
    write("Password geaendert.\n");
  return 1;
}

// *** Einstellen des Terminal-Typen ***
int stty(string was) {
  if (stringp(was) && strlen(was) && (member(({"vt100","ansi","dumb"}), was) != -1)) {
    gettty(was);
    return 1;
  }
  write("Waehlt einen der folgenden Terminaltypen. Moeglich sind\n"+
        "vt100, ansi, dumb [dumb]: ");
  input_to("gettty",0);
  return 1;
}

static void gettty(string ttystr) {
  if (!ttystr || ttystr == "") ttystr = "dumb";
  switch ((ttystr = lower_case(ttystr))) {
    case "vt100":
      write("Dies sollte "+ANSI_BOLD+"fett"+ANSI_NORMAL+" sein.\n");
      break;
    case "ansi":
      write("Dies sollte "+ANSI_RED+"rot"+ANSI_NORMAL+" sein.\n");
      break;
    case "dumb":
      write("Ok.\n");
      break;
    default:
      write("Dieser Terminaltyp wird nicht unterstuetzt, bitte waehlt.\n"+
	    "einen der folgenden:\n"+
	    "vt100, ansi oder dumb (default ist dumb): ");
      input_to("gettty");
      return;
    }
  SetProp(P_TTY, ttystr);
  return;
}

// *** the wizard command review: show player moving messages ***
static int review() {
  string text;
  mixed *zap, msg;

  text = "Eure Bewegungen werden wie folgt gemeldet:\n"+
         "-------------------------------------------\n"+
         break_string(QueryProp(P_MMSGOUT)+".",0,"mmout:     ")+
         break_string(QueryProp(P_MMSGIN)+".",0,"mmin:      ");

  if (IS_LEARNER(ME)) {
    zap = QueryProp(P_ZAP_MSG);

    if(!pointerp(zap) || sizeof(zap)!=3)
      text += break_string("Du zappst <wesen>.",0,"zap1:      ")+
              break_string(name(WER)+" beschwoert einen Blitz vom Himmel.",0,"zap2:      ");
    else
      text += break_string(zap[0],0,"zap1:      ")+
              break_string(zap[2],0,"zap2:      ")+
              break_string(zap[1],0,"zap3:      ");

    if (!stringp((msg=QueryProp(P_CLONEMSG))))
      text += break_string(name(WER)+" zieht etwas aus "+QueryPossPronoun(MALE,WEM)+" Hut.",0,
                "clonemsg:  ");
    else
      text += break_string(name(WER)+" "+msg,0,"clonemsg:  ");

    if (!stringp((msg=QueryProp(P_CLONEFMSG))))
      text += break_string(name(WER)+" schuettelt "+QueryPossPronoun(MALE,WEN)+" Hut, "+
              "aber nichts kommt raus ...",0,"clonefmsg: ");
    else
      text += break_string(name(WER)+" "+msg,0,"clonefmsg: ");

    if (!stringp((msg=QueryProp(P_DESTMSG))))
      text += break_string("<ding> wird von "+name(WEM)+" ausgeschaltet.",0,"destmsg:   ");
    else
      text += break_string("<ding> "+msg,0,"destmsg:   ");

    if (!stringp((msg=QueryProp(P_DESTFMSG))))
      text += break_string(name(WER)+" versucht vergeblich, <ding> auszuschalten.",0,"destfmsg:  ");
    else
      text += break_string("<ding> "+msg,0,"destfmsg:  ");
  }

  More(text);

  return 1;
}

static int setname(string str) 
{
  if (!str) 
  {
    notify_fail("Wie soll Euer Name denn nun geschrieben werden?\n");
    return 0;
  }
  if (lower_case(str)!=getuid()) 
  {
    notify_fail("Ihr duerft nur die Gross-/Kleinschreibung aendern.\n");
    return 0;
  }
  Set(P_NAME, capitalize(str));
  write("Ok, ab jetzt heisst Ihr '"+QueryProp(P_NAME)+"'.\n");
  return 1;
}

public int setsecond(string str) 
{
  object first, ob;
  first=previous_object();
  if (first && first!=ME) {
    sec=first;
    return 1;
  }
  if (str=="zustimmen") 
  {
    if (!sec) 
    {
      write("Bislang hat noch kein Erstie das Setzen 'beantragt'.\n");
      return 1;
    }
    SetProp(P_SECOND, capitalize(sec->Query(P_NAME)));
    write("Ihr bist nun als Zweitie von "+QueryProp(P_SECOND)+" markiert.\n");
    tell_object(sec, capitalize(name(WER))+" ist nun Euer Zweitie.\n");
    return 1;
  }
  if (sec) 
  {
    write(break_string(capitalize(sec->Query(P_NAME))+" moechte, dass Ihr "+
      sec->QueryPossPronoun(MALE, WER)+" Zweitie werdet. Dazu muesst Ihr nur "
      "'zweitie zustimmen' eingeben."));
    return 1;
  }
  if (QueryProp(P_SECOND)) 
  {
    write("Als Zweitie koennt Ihr keine 'Unterzweities' haben.\n");
    return 1;
  }
  if (!str) 
  {
    notify_fail("Wer soll denn Euer Zweitie sein?\n");
    return 0;
  }
  ob=find_player(str=lower_case(str));
  if (!ob || !present(ob, environment()) || ob->QueryProp(P_INVIS)) 
  {
    write("Solch einen Spieler ist nicht hier anwesend.\n");
    return 1;
  }
  if (ob==ME) {
    write("Das seid Ihr doch selber.\n");
    return 1;
  }
  ob->setsecond(); // Eintragung 'beantragen'
  write(break_string(capitalize(ob->name(WER))+" muss dem Setzen jetzt noch "
    "zustimmen. Dazu muss "+ob->QueryPronoun(WER)+" 'zweitie zustimmen' "
    "eingeben."));
  return 1;
}

static int setsound(string str)
{
  mapping sndset;
  int snd,vol;
  
  snd=QueryProp(P_MUD_SOUND_PROTOCOL);
  sndset=QueryProp(P_MSP_SETTINGS);
  if (!mappingp(sndset))
    sndset=([SND_VOLUME:100,SND_SOUND:100,SND_MUSIC:100]);
    
  if (!str || str=="")
  {
    write(sprintf(
      "Momentane Einstellungen des Sounds:\n"
      "Sound %s.\n"
      "Lautstaerke:      %:3d%%\n"
      "Musiklautstaerke: %:3d%%\n"
      "Soundlautstaerke: %:3d%%\n",
      snd?"aktiviert":"deaktiviert",
      sndset[SND_VOLUME],
      sndset[SND_MUSIC],
      sndset[SND_SOUND]));
    return 1;  
  }
  
  if (str=="an" || str=="on" || str=="aktivieren")
  {
    if (snd)
    {
      write("Der Sound ist bereits aktiviert.\n");
      return 1;  
    }  
    else
    {
      ME->startmusic();
      write("Sound aktiviert.\n");
      snd=1;
    }
  }
  else if (str=="aus" || str=="off" || str=="deaktivieren")
  {
    if (!snd)
    {
      write("Der Sound ist bereits deaktiviert.\n");
      return 1;  
    }  
    else
    {
      ME->stopsound();
      ME->stopmusic();
      write("Sound deaktiviert.\n");
      snd=0;
    }      
  }
  else if (str=="umschalten" || str=="toggle")
  {
    if (snd)
    {
      ME->stopsound();
      ME->stopmusic();
      write("Sound deaktiviert.\n");
      snd=0;
    }  
    else
    {
      ME->startmusic();
      write("Sound aktiviert.\n");
      snd=1;
    }            
  }
  else if (sscanf(str,"lautstaerke %d",vol)==1)
  {
    if (vol<0 || vol>100)
    {
      write("Die Lautstaerke muss zwischen 0 und 100 Prozent liegen.\n");
      return 1;  
    }
    write(sprintf("Die Lautstaerke ist jetzt %d%%.\n",vol));
    sndset[SND_VOLUME]=vol;
  }
  else if (sscanf(str,"sound %d",vol)==1)
  {
    if (vol<0 || vol>100)
    {
      write("Die Soundlautstaerke muss zwischen 0 und 100 Prozent liegen.\n");
      return 1;  
    }
    write(sprintf("Die Soundlautstaerke ist jetzt %d%%.\n",vol));
    sndset[SND_SOUND]=vol;
  }
  else if (sscanf(str,"musik %d",vol)==1)
  {
    if (vol<0 || vol>100)
    {
      write("Die Musiklautstaerke muss zwischen 0 und 100 Prozent liegen.\n");
      return 1;  
    }
    write(sprintf("Die Musiklautstaerke ist jetzt %d%%.\n",vol));
    sndset[SND_MUSIC]=vol;
  }
  else
  {
    write("Syntax: sound [an|aus|lautstaerke <%>|sound <%>|musik <%>]\n");  
    return 1;
  }
  
  SetProp(P_MUD_SOUND_PROTOCOL,snd);
  SetProp(P_MSP_SETTINGS,sndset);
  return 1;
}

// *** local propertie-methods ***

static int _set_second(mixed a) {
  log_file("SECOND", sprintf("%s set to '%s' OB:[%s] on %s\n",
    getuid(ME),to_string(a),
    file_name((this_interactive()?this_interactive():previous_object())),
    dtime(time())));
  return Set(P_SECOND, a);
}

/* note: support vt100 (b/w), ansi (color), dumb (none) */
static string _set_tty(string str) {
  if(str != "dumb" && str != "vt100" && str != "ansi") 
    return Query(P_TTY);
  return Set(P_TTY, str);
}

static string *_query_localcmds() {
  return ({({"zeilen","set_screensize",0,0}),
           ({"email","set_email",0,0}),
           ({"homepage","set_homepage",0,0}),
           ({"passw","change_password",1,0}),
           ({"weg","weg",0,0}),
           ({"titel","set_title",0,SEER_LVL}),
           ({"review","review",0,SEER_LVL}),
           ({"setmmin","setmmin",0,SEER_LVL}),
           ({"setmmout","setmmout",0,SEER_LVL}),
           ({"extralook","extralook",0,SEER_LVL}),
           ({"vortitel","vortitel",0,SEER_LVL}),
           ({"stty","stty",0,0}),
           ({"terminal","stty",0,0}),
           ({"zweitie","setsecond",0,0}),
           ({"sound","setsound",0,0}),
           ({"schreibweise","setname",0,0}),
         });
}
