/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: shadowhandler.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// Wunderland MUDlib
// basierend auf MorgenGrauen MUDlib
//
// PLAYER/SHADOWHANDLER.C
//
/*
 * $Date: 1999/11/05 12:30:47 $
 * $Revision: 1.1.1.1 $
 * $Log: shadowhandler.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.2  1998/06/27 03:17:05  Gum
 * kleine aenderungen im header
 * 78 in BS_STDLEN geaendert
 *
 */

#pragma strong_types

#define NEED_PROTOTYPES

#include <thing/properties.h>
#include <properties.h>
#include <defines.h>
#include <wizlevels.h>

nomask static int _set_autoload_shadow(mixed arg);

static void create()
{
  Set(P_AUTOLOAD_SHADOW,SAVE,F_MODE);
  Set(P_AUTOLOAD_SHADOW,#'_set_autoload_shadow,F_SET_METHOD);
}

/**********************************************************************
 * To prevent tampering with the shadow property, only this_object(), *
 * some Archwiz or any shadow is allowed to set it. shadows are       *
 * restricted to only set themselves.                                 *
 **********************************************************************/

// THE FUNCTIONS BELOW THIS LINE MUST REMAIN nomask!!!

nomask varargs static int change_secure(object ob)
{
  int cid;
  string n;

  return (!extern_call() ||
	  (interactive(previous_object()) && IS_ARCH(previous_object())) ||
	  (sscanf(file_name(previous_object()),
		  "/std/player/shadows/%s#%d")==2 &&
	   (ob && objectp(ob) ? ob==previous_object() : 1)));
}

nomask static string check_shadow_file_name(string str)
{
  int cid;
  string n;
  if(!str || !stringp(str)) return 0;
  if(sscanf(str,"/std/player/shadows/%s#%d",n,cid)==2)
    if(file_size((str="/std/player/shadows/"+n+".c"))>-1)
      return str;
    else
      return 0;
  if(sscanf(str,"/std/player/shadows/%s",n)==1)
    {
      str=n;
      if(sscanf(str,"%s.c",n)!=1)
	str+=".c";
      if(file_size((str="/std/player/shadows/"+str))>-1)
	return str;
      return 0;
    }
  return 0;
}

nomask static int _set_autoload_shadow(mixed arg)
{
  if(intp(arg) && !arg)
    if(change_secure())
      return Set(P_AUTOLOAD_SHADOW,0);
    else
      return -1;
  if(stringp(arg))
    if(extern_call())
      return -2;
    else
      {
	Set(P_AUTOLOAD_SHADOW,(arg=check_shadow_file_name(arg)));
	return 1;
      }
  if(!objectp(arg) || !change_secure(arg))
    return -3;
  Set(P_AUTOLOAD_SHADOW,check_shadow_file_name(file_name(arg)));
  return 1;
}
