/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: kapuze.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
/*
** Ein Shadow um 'unsichtbare' Spieler etwas sichtbarer zu machen.
** Dabei koennen Titel, Extralook, der Gender und moegliche Ids
** festgelegt werden.
**
** Fiona 4/97
*/

// 16.02.99 Fiona  name() an Plural angepasst

#pragma strong_types
#include <properties.h>
#include <moving.h>
#include <wizlevels.h>
#include <attributes.h>

static object pl;
static int gend;
static string extra, title, *ids;

// Debughilfe
#if 0
void prev_ob() {
  int i;
  mixed ob;
  tell_object(find_player("fiona"), "Prev.Obj: ");
  ob=1;
  for (i=1;ob;i++)
	tell_object(find_player("fiona"),
	  sprintf("(%d) %O, ",i,ob=previous_object(i)));
  tell_object(find_player("fiona"), "\n");
}
#endif

object StartShadow(object who, int g, string e, string t, string* i) {
  pl=shadow(who, 1);
  gend=g;
  extra=e;
  title=t;
  ids=i;
  return pl;
}

int id(string str) {
  int i, j;
  if (member_array(lower_case(str), ids)!=-1) return 1;
  j=pl->QueryProp(P_INVIS);
  pl->SetProp(P_INVIS, 1);
  i=pl->id(str);
  pl->SetProp(P_INVIS, j);
  return i;
}

// Titel an Unsichtbaren anhaengen
string short() {
  string sh;
  object prev;
  int j;
  prev=previous_object();
  // Ausnahme fuer Werliste
  if (prev && file_name(prev)[0..4]=="/obj/")
	return pl->short();
  j=pl->QueryProp(P_INVIS);
  pl->SetProp(P_INVIS, 1);
  sh=pl->short();
  pl->SetProp(P_INVIS, j);
  if (!sh) sh="Jemand"; // Magier nicht unsichtbar mit Kapuze
  else sh=sh[0..<3];
  sh+=" "+title+".\n";
  return sh;
}

string long() {
  string lo;
  int j;
  j=pl->QueryProp(P_INVIS);
  pl->SetProp(P_INVIS, 1);
  lo=pl->long();
  pl->SetProp(P_INVIS, j);
  return lo;
}

varargs string name(int i, int j) {
  string na;
  object prev;
  int k;
  prev=previous_object();
  // Ausnahme fuer Channeldaemon
  if (pl->QueryProp(P_INVIS))
    j&=~(NAME_INDEF|NAME_AUTO); // Setzen von NAME_DEF
  if (!prev || file_name(prev)[0..2]!="/p/")
    pl->SetProp(P_INVIS, 1);
  na=pl->name(i, k);
  pl->SetProp(P_INVIS, k);
  return na;
}

// Kapuze weg beim Tod
varargs void die(int poisondeath) {
  object player;
  player=pl; // nur noch lokale Variablen vorhanden nach destruct
  destruct(this_object());
  player->die(poisondeath);
}

int _query_gender() {
  return gend;
}

string _query_extra_look() {
  return extra;
}

mixed QueryProp(string was) {
  switch(was) {
    case P_EXTRA_LOOK:
      return _query_extra_look();
    case P_GENDER:
      return _query_gender();
  }
  return pl->QueryProp(was);
}

// Damit comm.c erkennt, dass Spieler nen Shadow hat
int QueryShadow() {
  return 1;
}

int remove() {
  destruct(this_object());
  return 1;
}
