/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/01 16:24:30 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: soul.c,v $
** Revision 1.2  2000/12/01 16:24:30  elatar
** some #define changed
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// MD MUDlib
// basierend auf Wunderland MUDlib
//
// player/soul.c -- Verben zum Ausdruecken von Gefuehlen von Spielern und NPCs
//
// Poietix  Mai 1992 Vers.: 0.4 fuer JRMud
// Highlander 1993-1994
// Bongo, Red, Fiona 1996
//
// $Log: soul.c,v $
// Revision 1.2  2000/12/01 16:24:30  elatar
// some #define changed
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.5  1999/09/09 07:23:59  Largo
// "zeig[e]" eingebaut
//
// Revision 1.4  1999/09/07 18:49:49  Largo
// 'betaste' geht nun nicht mehr normal, wenn man
// es an sich selbst anwendet :)
//
// Revision 1.3  1999/09/07 11:46:43  Largo
// hatte noch drei '77' vergessen
//
// Revision 1.2  1999/09/07 11:37:44  Largo
// BS_STDLEN 77 usw. entfernt
//
// Revision 1.1  1999/08/17 03:49:02  Largo
// Initial revision
//

#pragma strong_types

#define SOULHELP "/std/player/soulhelp"
#define KEYWORD "soul"
#define NEED_VIC  1
#define NO_VIC    2
#define NOREMOTE  4
#define ALLOW_ALL 8
#ifdef QPP
#undef QPP
#define QPP ME->QueryPossPronoun
#endif
#define RETURN(x) return (/*QueryProp(P_ACTUAL_NOTIFY_FAIL) ? 0 : */notify_fail(x), 0)
#define GHOST(sel,oth,vic) { out_sel=sel; out_vic=vic; out_oth=oth; \
                             return FeelIt(); }

#define NEED_PROTOTYPES
#define NEED_COMM_METHODS

#include <properties.h>
#include <player/comm.h>
#include <thing/properties.h>
#include <language.h>
#include <defines.h>
#include <moving.h>
#include <wizlevels.h>

// Variablen
static object who, ofoo;
static int for_all, verb_found, ifoo, r_find;
mapping plr_adverbs;
static string out_sel, out_vic, out_oth, adverb, *verb_out, verb;
static mixed r_vic;

// Prototypen
string CountUp(string *foo);
varargs string slurr(string str, int alc);
varargs string convert_string(string foo, int is_wiz);
void More(string foo);
varargs int FeelIt(string xarg);
private int MixedOut(int casus);
private void ParseAdverb(string *words);
private varargs int ParseRest(string arg, int flag, mixed extra);
private int CheckLife(string not_self_text, string not_dead_text);
private int zeige_adverbs(int mine);
private int ghost();
private mapping QueryStdAdverbs();
private mapping QueryAdverbs();
string bubble(string str, string pre);

void add_soul_commands() {
	if (!plr_adverbs)
		plr_adverbs=([]);
	add_action("OnlyFunctionForHate", "", 1);
}

// Dies ist die Hauptfunktion. Alle Kommandos laufen hier durch und
// es wird geschaut, ob sie ein hier bekanntes Verb enthalten.
// _verb wird intern fuer die Remote-Kommandos verwendet und hat
// Vorrang vor einem eingegebenen Kommando
static varargs int OnlyFunctionForHate(string str, string _verb) {
	int t_g, t_n, flag;
	string str1, str2, str3, *taenze, *parts;
	mixed *frog;
	object obj;

	out_sel=0;
	out_vic=0;
	out_oth=0;
	who=0;
	r_find=0;
	adverb=0;

	if (_verb) verb=_verb;
	else {
		verb=query_verb();
		r_vic=0; // Echtes Kommando. Zur Sicherheit remote auf 0 setzen.
	}
	if (!verb) return 0;
	verb_found=1; // Wird am Schluss auf 0 gesetzt, wenn kein Verb passte

	switch (verb) {

	// Fuer Soulbastler:
	// verb sollte auf eine einheitliche Form des Kommandos gesetzt werden
	// Eine mit 'e' endende sollte bevorzugt werden

	/****************** Freu *****************/
	case "freu" : verb="freue";
	case "freue":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="tierisch";
		out_sel="Du freust Dich@@adverb@@.";
		out_oth="@@Name@@ freut sich@@adverb@@.";
		return FeelIt();

	/****************** schaem *****************/
	case "schaem" : verb="schaeme";
	case "schaeme":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="in Grund und Boden";
		out_sel="Du schaemst Dich@@adverb@@.";
		out_oth="@@Name@@ schaemt sich@@adverb@@.";
		return FeelIt();

	/****************** Pruste ******************/
	case "prust": verb="pruste";
	case "pruste":
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du prustest @@alle@@@@adverb@@ an.";
			out_vic="@@Name@@ prustet @@alle@@@@adverb@@ an.";
			return MixedOut(WEN);
        }
		if (CheckLife("Wieso willst Du Dich denn selbst anprusten?",
			"Das kannst Du nicht anprusten.")) return 1;
		out_sel="Du prustest"+(who?" @@wen@@@@adverb@@ an.":"@@adverb@@ los.");
		if (who) out_vic="@@Name@@ prustet Dich@@adverb@@ an.";
		out_oth="@@Name@@ prustet"+(who?" @@wen@@@@adverb@@ an.":
			"@@adverb@@ los.");
		return FeelIt();

	/****************** Kneifen *****************/
	case "kneif": verb="kneife";
	case "kneife":
		if (ghost()) RETURN("Dazu bist Du nicht real genug.\n");
		if (!ParseRest(str, NEED_VIC)) RETURN("Wen willst Du kneifen?\n");
        if (who==ME) {
			out_sel="Du kneifst Dich@@adverb@@.";
			out_oth="@@Name@@ kneift sich selbst@@adverb@@.";
        } else {
			if (CheckLife(0, "Das wuerde es wohl nicht so bringen..."))
				return 1;
			out_sel="Du kneifst @@wen@@@@adverb@@.";
			out_vic="@@Name@@ kneift Dich@@adverb@@.";
			out_oth="@@Name@@ kneift @@wen@@@@adverb@@.";
        }
		return FeelIt();

	/****************** Stupsen *****************/
	case "stups": verb="stupse";
	case "stupse":
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("Wen willst Du stupsen?\n");
		str1=0;
		if (adverb=="um") {
			str1=adverb;
			adverb=0;
		}
		else if (adverb && sscanf(adverb, "%s um", str1)==1) adverb=str1;
		if (for_all) {
			out_sel="Du stupst @@alle@@@@adverb@@ "+(str1?"um.":"an.");
			out_vic="@@Name@@ stubst @@alle@@@@adverb@@ "+(str1?"um.":"an.");
			return MixedOut(WEN);
		}
		if (CheckLife("Das macht Dir sowieso nicht so richtig Spass.",
			"Das macht doch keinen Spass")) return 1;
		out_sel="Du stupst @@wen@@@@adverb@@ "+(str1?"um.":"an.");
		out_vic="@@Name@@ stupst Dich@@adverb@@ "+(str1?"um.":"an.");
		out_oth="@@Name@@ stupst @@wen@@@@adverb@@ "+(str1?"um.":"an.");
		return FeelIt();

	/**************** Jammern ***************/
	case "jammer": verb="jammere";
	case "jammere":
		if (ghost()) GHOST("Du jammerst ueber Dein Schicksal als Geist.",
			"@@Name@@ jammert ueber "+QPP(NEUTER, WEN)+
			" Schicksal als Geist.", 0);
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="in Selbstmitleid zerfliessend";
		out_sel="Du jammerst@@adverb@@.";
		out_oth="@@Name@@ jammert@@adverb@@.";
		return FeelIt();

	/****************** Schneuz *****************/
	case "schneuz" : verb="schneuze";
	case "schneuze":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="traurig";
		out_sel="Du schneuzt@@adverb@@ in Dein Taschentuch.";
		out_oth="@@Name@@ schneuzt@@adverb@@ in "+
			QPP(NEUTER, WEN)+" Taschentuch.";
		return FeelIt();
	
	/****************** Schnaub *****************/
	case "schnaub" : verb="schnaube";
	case "schnaube":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="wuetend";
		out_sel="Du schnaubst@@adverb@@.";
		out_oth="@@Name@@ schnaubt@@adverb@@.";
		return FeelIt();
	
	/****************** Huestel *****************/
	case "huestel" : verb="huestle";
	case "huestle":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="verlegen";
		out_sel="Du huestelst@@adverb@@.";
		out_oth="@@Name@@ huestelt@@adverb@@.";
		return FeelIt();    

	/**************** Schulterklopfen ***************/
	case "klopf": verb="klopfe";
	case "klopfe":
		if (!ParseRest(str, NEED_VIC))
			RETURN("Wem willst Du denn auf die Schulter klopfen?\n");
		if (CheckLife("Das geht doch nicht.",
			"Nein, das macht keinen Spass. Lebt ja nicht mal.")) return 1;
		out_sel="Du klopfst @@wem@@@@adverb@@ auf die Schulter.";
		out_vic="@@Name@@ klopft Dir@@adverb@@ auf der Schulter herum.";
		out_oth="@@Name@@ klopft @@wem@@@@adverb@@ auf die Schulter.";
		return FeelIt();

	/****************** Gruebeln *****************/
	case "gruebel" : verb="grueble";
	case "grueble":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="verzweifelt";
		out_sel="Du gruebelst@@adverb@@.";
		out_oth="@@Name@@ gruebelt@@adverb@@ ueber ein Problem.";
		return FeelIt();
	
	/**************** Achselzucken ***************/
	case "zuck" : verb="zucke";
	case "zucke":
		ParseRest(str, NO_VIC, ({"achseln","mit achseln"}));
		if (!adverb) adverb="ratlos";
		out_sel="Du zuckst@@adverb@@ mit den Schultern.";
		out_oth="@@Name@@ zuckt@@adverb@@ mit den Schultern.";
		return FeelIt();

	/**************** Zupfen *********************/
	case "zupf" : verb="zupfe";
	case "zupfe":
                if (ghost()) RETURN("Wie willst Du ohne Hand zupfen?\n");
                if (!ParseRest(str, NEED_VIC))
			RETURN("An wem willst Du herumzupfen?\n");
		if (who==ME) {
                        out_sel="Du zupfst@@adverb@@ an Dir herum.";
                        out_oth="@@Name@@ zupft@@adverb@@ an sich herum.";
		} else {
                        if (CheckLife(0, "Hmm... wie soll das gehen?"))
                                return 1;
                        out_sel="Du zupfst@@adverb@@ an @@wessen@@ "
				"Aermel herum.";
                        out_vic="@@Name@@ zupft@@adverb@@ an Deinem "
				"Aermel herum.";
                        out_oth="@@Name@@ zupft@@adverb@@ an "
				"@@wessen@@ Aermel herum.";   
        }
                return FeelIt();

	/**************** Anschmiegen ***************/
	case "schmieg": verb="schmiege";
	case "schmiege":
		if (!ParseRest(str, NEED_VIC))
			RETURN("An wen willst Du Dich anschmiegen?\n");
		if (CheckLife("Das geht doch nicht.",
			"Nein, das macht keinen Spass. Lebt ja nicht mal.")) return 1;
		out_sel="Du schmiegst Dich@@adverb@@ an@@ wen@@ an.";
		out_vic="@@Name@@ schmiegt sich@@adverb@@ an Dich.";
		out_oth="@@Name@@ schmiegt sich@@adverb@@ an@@ wen@@ an.";
		return FeelIt();

	/**************** Antworten ***************/
	case "antwort": verb="antworte";
	case "antworte":
		if (!str) RETURN("Antworte [WEM] WAS?\n");
		ParseRest(str, NOREMOTE);
		str1=0;
		if (r_vic) return 0;
		if (!who);
		else if (sscanf(str,"%s %s",str2,str1)!=2)
				RETURN("Antworte was?\n");
		if (!str1) str1=str;
		if (sscanf(str1,"%s:: %s", str2, str3)!=2) str3=str1,adverb=0;
		else adverb=str2;
		str3=capitalize(str3);
		if (member(".!,:;()[]?", str3[<1])==-1) str3+=".";
		out_sel=break_string(convert_string(
			"Du antwortest@@ wem@@@@adverb@@: "+str3), 0, 0,
			BS_FOR_COMM)[0..<2];
		str3=_comm_hook(str3, COMM_ANTWORTE);
		if (str3[0]=='\t') RETURN(break_string(str3[1..]));
		str1=slurr(str3);
		if (who) out_vic=break_string(convert_string(
			"@@Name@@ antwortet Dir@@adverb@@: "+str1),
			0, 0, BS_FOR_COMM)[0..<2];
		out_oth=break_string(convert_string(
			"@@Name@@ antwortet@@ wem@@@@adverb@@: "+str1),
			0, 0, BS_FOR_COMM)[0..<2];
		if (member(".!,:;()[]?", str1[<1])==-1) return FeelIt(str1);
		return FeelIt(str1[0..<2]);
	  
	/**************** Applaudieren ***************/
	case "applaudiere":
		if (ghost())
			GHOST("Deine Haende fahren durcheinander durch - war wohl nix.",
				"@@Name@@ will applaudieren, aber "+QPP(FEMALE,WER,PLURAL)
				+" Haende sausen\ndurcheinander durch.", 0);
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du applaudierst @@alle@@@@adverb@@.";
			out_vic="@@Name@@ applaudiert @@alle@@@@adverb@@.";
			return MixedOut(WEM);
		}
		if (!adverb) adverb="von ganzem Herzen";
		if (CheckLife( "Nein, das gehoert sich nicht.",
			"Sachen wird hier nicht applaudiert, OK?")) return 1;
		out_sel="Du applaudierst@@ wem@@@@adverb@@.";
		if (who) out_vic="@@Name@@ applaudiert Dir@@adverb@@.";
		out_oth="@@Name@@ applaudiert@@ wem@@@@adverb@@.";
		return FeelIt();

	/**************** Betasten ***************/
	case "betaste":
		if (!ParseRest(str, NEED_VIC)) RETURN("Begrabsche wen?\n");
		if (CheckLife("Erfahre Deinen Koerper bitte woanders. :)",
			"Das fuehlt sich nicht sonderlich lebendig an."))
			return 1;
		out_sel="Du grabbelst@@adverb@@ an "+who->name(WEM)+" herum.";
		out_vic="@@Name@@ grabbelt@@adverb@@ an Dir herum.";
		out_oth="@@Name@@ grabbelt@@adverb@@ an @@wem@@ herum.";
		return FeelIt();

	/**************** Blicken ***************/
	case "blick": verb="blicke";
	case "blicke":
		ParseRest(str);
		if (!str) adverb="vertraeumt";
		else if (!adverb) adverb="forschend";
		if (CheckLife("Wie willst Du Dich selbst anblicken? "+
			"(Spiegel gelten nicht...)",0)) return 1;
		out_sel="Du blickst"+(who ? "@@ wen@@" : "")+"@@adverb@@"+
			(who ? " an." : ".");
		if (who) out_vic="@@Name@@ blickt Dich@@adverb@@ an.";
		out_oth="@@Name@@ blickt"+(who ? "@@ wen@@" : "")+"@@adverb@@"+
			(who ? " an." : ".");
		return FeelIt();

	/**************** cls ***************/
	case "cls":
		if (r_vic) return 0;
		write("[2J[H");
		return 1;

	/**************** Daeumchendrehen ***************/
	case "dreh": verb="drehe";
	case "drehe":
		if (!str) RETURN("Drehe was?\n");
		if (sscanf(str,"daumen %s", str1)!=1 &&
			sscanf(str,"%s daumen", str1)!=1 &&
			sscanf(str,"daeumchen %s", str1)!=1 &&
			sscanf(str,"%s daeumchen", str1)!=1 && str1="" &&
			member(({"daumen","daeumchen"}), str)==-1)
				RETURN("Drehe was?\n");
		ParseRest(str1, NO_VIC);
		out_sel="Du drehst@@adverb@@ Daeumchen.";
		out_oth="@@Name@@ dreht@@adverb@@ Daeumchen.";
		return FeelIt();
	  
	/**************** Danken ***************/
	case "danke":
		if (!ParseRest(str, NEED_VIC))
			RETURN("Bei wem willst Du Dich bedanken?\n");
		if (CheckLife( "Leidest Du jetzt schon an Persoenlickeitsspaltung? "+
			"Ne, ne...", "Keine Reaktion. Ist wohl befriedigender, sich bei "+
			"Lebewesen zu bedanken.")) return 1;
		out_sel="Du bedankst Dich@@adverb@@ bei@@ wem@@.";
		out_vic="@@Name@@ bedankt sich@@adverb@@ bei Dir.";
		out_oth="@@Name@@ bedankt sich@@adverb@@ bei@@ wem@@.";
		return FeelIt();

	/**************** Druecken ***************/
	case "drueck": verb="druecke";
	case "druecke":
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("Wen willst Du denn druecken?\n");
		if (for_all) {
			out_sel="Du drueckst @@alle@@"+
				(adverb ? "@@adverb@@" : " zaertlich")+" an Dich.";
			out_vic="@@Name@@ drueckt @@alle@@"+
				(adverb ? "@@adverb@@" : " zaertlich")+" an sich.";
			return MixedOut(WEN);
		}
		if (CheckLife( "Das macht doch keinen Spass.",
			"Ich druecke nur jemanden, nicht etwas.")) return 1;
		if (ghost()) GHOST("Du willst "+who->name(WEN)+
			" an Dich druecken - nur hast Du schon wieder nicht\ndaran "+
			" gedacht, dass so was als Geist nicht geht.",
			"@@Name@@ will "+who->name(WEN)+" an sich druecken - hat aber\n"+
			"mal wieder nicht an die Nachteile des "+
			"Geisterdaseins gedacht.",
			"@@Name@@ will Dich an sich druecken - hat aber mal wieder\n"+
			"nicht an die Nachteile des Geisterdaseins gedacht.");
		if (!adverb) adverb="zaertlich";
		out_sel="Du drueckst@@ wen@@@@adverb@@ an Dich.";
		out_vic="@@Name@@ drueckt Dich@@adverb@@ an sich.";
		out_oth="@@Name@@ drueckt@@ wen@@@@adverb@@ an sich.";
		return FeelIt();

	/**************** Erroeten ***************/
	case "erroete":
		if (ghost())
			GHOST("Du schaffst es nur bis zu einem blassen Rosa, "
				"aber immerhin.", "Die Wangen des Geistes von "+ME->name(WEM)+
				" werden leicht rosa.", 0);
		ParseRest(str, NO_VIC);
		out_sel="Deine Wangen gluehen@@adverb@@.";
		out_oth="@@Name@@ erroetet@@adverb@@.";
		return FeelIt();

	/**************** Flippen ***************/
	case "flipp": verb="flippe";
	case "flippe":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="total";
		out_sel="Du flippst@@adverb@@ aus.";
		out_oth="@@Name@@ flippt@@adverb@@ aus.";
		return FeelIt();

	/**************** Fragen ***************/
	case "frag": verb="frage";
	case "frage":
		if (!str) RETURN("Frage wen was?\n");
		ParseRest(str, NOREMOTE);
		adverb=0;
		if (who==ME && lower_case(str)!=getuid()) who=0;
		if (who && CheckLife(
			"Du faengst zu gruebeln an...",
			"Frage jemand, der lebt."))
			return 1;
		if (who) sscanf(str,"%s %s", str1,str1);
		else str1=str;
		if (!str1) RETURN("Frage "+who->name(WEN)+" WAS?\n");
		if (sscanf(str1,"%s:: %s", adverb, str3)!=2) {
			adverb=0;
			str3=str1;
		}
		if (lower_case(str3[0..4])=="nach ") {
			str1=str3[5..];
			if (adverb) adverb+=" nach ";
			else adverb="nach ";
			str2="";
			if (member("()?.:!,;", str1[<1])==-1) str1+=".";
		} else {
			str2=": ";
			str1=capitalize(str3);
			if (member("()?.:!,;", str1[<1])==-1) str1+="?";
		}
		out_sel=break_string(convert_string(
			"Du fragst@@ wen@@@@adverb@@"+str2+str1), 0, 0,
			BS_FOR_COMM)[0..<2];
		str1=_comm_hook(str1, COMM_FRAGE);
		if (str1[0]=='\t') RETURN(break_string(str1[1..]));
		str1=slurr(str1);
		if (ghost()) str3="Der Geist von ";
		else str3="";
		if (QueryProp(P_PRESAY) && !QueryProp(P_INVIS))
			str3+=QueryProp(P_PRESAY);
		if (str3=="") str3=capitalize(ME->name(WER,1));
		else str3+=ME->name(WER, 1);
		if (who) out_vic=break_string(convert_string(
			str3+" fragt Dich@@adverb@@"+str2+str1), 0, 0,
			BS_FOR_COMM)[0..<2];
		out_oth=break_string(convert_string(str3+
			" fragt@@ wen@@@@adverb@@"+str2+str1), 0, 0,
			BS_FOR_COMM)[0..<2];
		if (member("?.:!,;", str1[<1])==-1) return FeelIt(str1);
		return FeelIt(str1[0..<2]);
	  
	/**************** Furzen ***************/
	case "furz": verb="furze";
	case "furze":
		if (ghost())
			GHOST("Du laesst einen fahren - aber er riecht nach gar nix.",
				"@@Name@@ laesst einen fahren. Man riecht aber nix.", 0);
		ParseRest(str, NO_VIC);
		out_sel="Du furzt@@adverb@@.";
		out_oth="@@Name@@ laesst@@adverb@@ einen Stinkefurz fahren.";
		FeelIt();
		if (!r_vic) {
			ofoo=clone_object("/obj/furz");
			ofoo->set_furzer(ME);
			ofoo->move(environment(ME));
		}
		return 1;

	/**************** Gaehnen ***************/
	case "gaehn": verb="gaehne";
	case "gaehne":
		if (ghost())
			RETURN("Als Geist wirst Du nicht muede - also nicht gaehnen.\n");
		ParseRest(str, NO_VIC);
		if (!adverb) out_sel="Kannst Du aber Dein(en) Mund/Maul/Schnabel "
			"weit aufreissen!";
		else out_sel="Du gaehnst@@adverb@@.";
		out_oth="@@Name@@ gaehnt@@adverb@@.";
		return FeelIt();
	  
	/**************** Glucksen ***************/
	case "glucks": verb="gluckse";
	case "gluckse":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="wie ein Huhn";
		if (str && !adverb) RETURN("Gluckse wie?\n");
		out_sel="Du gluckst@@adverb@@.";
		out_oth="@@Name@@ gluckst@@adverb@@.";
		return FeelIt();
	  
	/**************** Gratulieren ***************/
	case "beglueckwuensche": verb="gratuliere";
	case "gratuliere":
		if (!ParseRest(str, NEED_VIC))
			RETURN("Wem willst Du gratulieren?\n");
		if (CheckLife(
			"Na, meinst Du nicht, dass Eigenlob stinkt?",
			"Soll ich dem Ding vielleicht zum "+
			"Totsein gratulieren? Nee nee."))
			return 1;
		out_sel="Du gratulierst @@wem@@@@adverb@@.";
		out_vic="@@Name@@ gratuliert Dir@@adverb@@.";
		out_oth="@@Name@@ gratuliert @@wem@@@@adverb@@.";
		return FeelIt();

	/**************** Grinsen ***************/
	case "grins": verb="grinse";
	case "grinse":
		if (ghost()) GHOST("Als Du grinst, sieht Du regelrecht, "+
			"wie die anderen eine Gaensehaut bekommen.",
			"Du bekommst eine Gaensehaut, als der Geist von "+
			ME->name(WEM)+" zu grinsen anfaengt.", 0);
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du grinst @@alle@@@@adverb@@ an.";
			out_vic="@@Name@@ grinst @@alle@@@@adverb@@ an.";
			return MixedOut(WEN);
		}
		if (who && CheckLife(
			"Du grinst Dir was, aber so, dass es kein anderer sieht.",
			"Nicht mal einen Spiegel darf man hier angrinsen, "+
			"nur Lebewesen!"))
			return 1;
		out_sel="Du grinst@@ wen@@@@adverb@@"+(who?" an.":".");
		if (who) out_vic="@@Name@@ grinst Dich@@adverb@@ an.";
		out_oth="@@Name@@ grinst@@ wen@@@@adverb@@"+(who?" an.":".");
		return FeelIt();
	  
	/**************** Grummeln ***************/
	case "grummel": verb="grummle";
	case "grummle":
		ParseRest(str);
		out_sel="Du grummelst@@ wen@@@@adverb@@"+(who?" an.":".");
		out_oth="@@Name@@ grummelt@@ wen@@@@adverb@@"+(who?" an.":".");
		if (who) out_vic="@@Name@@ grummelt Dich@@adverb@@ an.";
		return FeelIt();
	  
	/**************** Gucken ***************/
	case "guck": verb="gucke";
	case "gucke":
		ParseRest(str, NO_VIC);
		if (!adverb) RETURN("Gucke wie aus der Waesche?\n");
		out_sel="Du guckst@@adverb@@ aus der Waesche.";
		out_oth="@@Name@@ guckt@@adverb@@ aus der Waesche.";
		return FeelIt();
	  
	/**************** Haetscheln ***************/
	case "haetschel":
	case "haetschele": verb="haetschle";
	case "haetschle":
		if (ghost()) GHOST("Du ueberlegst es Dir anders - "+
			"mit Deinen durchlaessigen Haenden...",
			"@@Name@@ will anscheinend jemand haetscheln, ueberlegt\n"
			+"es sich nach einem kurzen Blick auf seine Haende anders.", 0);
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("Wen willst Du haetscheln?\n");
		if (for_all) {
			out_sel="Du haetschelst @@alle@@@@adverb@@.";
			out_vic="@@Name@@ haetschelt @@alle@@@@adverb@@.";
			return MixedOut(WEN);
		}
		if (CheckLife( "Das sieht viel zu albern aus - Du laesst es bleiben.",
			"Ist da ueberhaupt was zu haetscheln? Nein, da lebt doch nix."))
			return 1;
		out_sel="Du haetschelst@@ wen@@@@adverb@@.";
		out_vic="@@Name@@ haetschelt Dich@@adverb@@.";
		out_oth="@@Name@@ haetschelt@@ wen@@@@adverb@@.";
		return FeelIt();

	/**************** Hauen *****************/
	case "hau": verb="haue";
	case "haue":
		if (ghost())
			GHOST("Du hast keinen Koerper, mit dem Du um Dich schlagen "
				"koenntest.","",0);
		if (!ParseRest(str, NEED_VIC))
			RETURN("Wen willst Du hauen?\n");
		if (CheckLife( "Bist Du irgendwie masochistisch veranlagt?",
			"Du haust dem Ding voll auf die Nase. Zumindest glaubst\n"+
			"Du, dass es eine Nase war."))
			return 1;
		out_sel="Du haust @@wen@@@@adverb@@.";
		out_vic="@@Name@@ haut Dich@@adverb@@.";
		out_oth="@@Name@@ haut @@wen@@@@adverb@@.";
		return FeelIt();
		  
	/**************** Hicksen ***************/
	case "hicks": verb="hickse";
	case "hickse":
		if (ghost())
			GHOST("Hoppla! Dieser Hickser zieht Dich ganz schoen zusammen!\n",
			"@@Name@@ hat anscheinend Schluckauf. Und was fuer einen! Fuer "
			"einen Moment zieht es "+QueryPronoun(WEN)+" ziemlich zusammen.",
			0);
		if (!str) {
			out_sel="Hicks@@adverb@@!";
			out_oth="@@Name@@ muss@@adverb@@ hicksen. Zuviel getrunken oder "+
				"zu schnell gegessen?";
		} else {
			ParseRest(str, NO_VIC);
			if (!adverb) RETURN("Hickse wie?\n");
			out_sel="Du hickst@@adverb@@.";
			out_oth="@@Name@@ hickst@@adverb@@.";
		}
		return FeelIt();
	  
	/**************** Huepfen ***************/
	case "huepf": verb="huepfe";
	case "huepfe":
		if (ghost()) GHOST("Du schwebst durch die Gegend.\n",
			"@@Name@@ schwebt durch die Gegend.\n", 0);
		if (!str) {
			out_sel="B O I N G !! Du huepfst@@adverb@@ in der Gegend herum.";
			out_oth="@@Name@@ huepft@@adverb@@ in der Gegend herum.";
		} else {
			ParseRest(str);
			out_sel="Du huepfst@@adverb@@"+(who ? " um@@ wen@@" : "")+" herum.";
			if (who) out_vic="@@Name@@ huepft@@adverb@@ um Dich herum.";
			out_oth="@@Name@@ huepft@@adverb@@"+
				(who ? " um@@ wen@@" : "")+" herum.";
		}
		return FeelIt();

	/**************** Husten ***************/
	case "hust": verb="huste";
	case "huste":
		if (ghost()) GHOST("Du verstreust ein paar Geisterbazillen im Raum.",
			"@@Name@@ macht ufff, ufff und verteilt ein paar Geister-\n"+
			"bazillen im Raum.", 0);
		if (!str) {
			out_sel="Hust! Keuch! Halt Dir doch wenigstens@@adverb@@ "+
				"die Hand vor den Mund!";
			out_oth="@@Name@@ hustet sich@@adverb@@ fast die Seele aus dem Leib.";
		} else {
			ParseRest(str, NO_VIC);
			if (CheckLife("Dir selber koennen nur andere was husten.",
				"Bitte huste nur Lebewesen was."))
				return 1;
			out_sel="Du hustest@@ wem@@@@adverb@@"+(who? " was." : ".");
			if (who) out_vic="@@Name@@ hustet Dir@@adverb@@was.";
			out_oth="@@Name@@ hustet@@ wem@@@@adverb@@"+(who? " was." : ".");
		}
		return FeelIt();

	/**************** Jubeln ***************/
	case "jubel": verb="juble";
	case "juble":
		ParseRest(str);
		if (who) {
			out_sel="Du jubelst @@wem@@@@adverb@@ zu.";
			out_vic="@@Name@@ jubelt Dir@@adverb@@ zu.";
			out_oth="@@Name@@ jubelt @@wem@@@@adverb@@ zu.";
		} else {
			out_sel="Du jubelst@@adverb@@.";
			out_oth="@@Name@@ jubelt@@adverb@@.";
		}
		return FeelIt();
	  
	/**************** Keuchen ***************/
	case "keuch": verb="keuche";
	case "keuche":
		if (ghost()) RETURN("Als Geist strengt Dich nix an - "+
			"also wird auch nicht gekeucht.\n");
		ParseRest(str, NO_VIC);
		if (!adverb) adverb="vor Anstrengung";
		out_sel="Du keuchst@@adverb@@.";
		out_oth="@@Name@@ keucht@@adverb@@.";
		return FeelIt();

	/**************** Kichern ***************/
	case "kicher": verb="kichere";
	case "kichere":
		ParseRest(str);
		if (!adverb) adverb="albern";
		if (CheckLife("In diesem Fall nimm bitte nur kicher.",
			"Musst schon etwas Lebendes angeben, nichts Totes.")) return 1;
		out_sel="Du kicherst@@adverb@@"+
			(who ? " hinter "+who->name(WESSEN)+" Ruecken." : ".");
		if (who) out_vic="Jemand kichert@@adverb@@ hinter Deinem Ruecken.";
		out_oth="@@Name@@ kichert@@adverb@@"+
			(who ? " hinter "+who->name(WESSEN)+" Ruecken." : ".");
		return FeelIt();

	/**************** Klatschen ***************/
	case "klatsch": verb="klatsche";
	case "klatsche":
		if (ghost()) GHOST("Deine Haende sausen durcheinander durch.",
			"@@Name@@ will in die Haende klatschen - aber sie\n"
			+"sausen durcheinander durch.", 0);
		ParseRest(str, NO_VIC);
		if (!adverb && str) RETURN("Klatsche wie?\n");
		out_sel="Du klatschst@@adverb@@ in die Haende.";
		out_oth="@@Name@@ klatscht@@adverb@@ in die Haende.";
		return FeelIt();
	  
	/**************** Knabbern ***************/
	case "knabber": verb="knabbere";
	case "knabbere":
		if (ghost()) RETURN("Sorry, aber dafuer fehlt Dir im Moment der "+
			"noetige \"Biss\"...\n");
		if (!ParseRest(str, NEED_VIC))
			RETURN("Knabbere wen an?\n");
		if (CheckLife("Du kommst nicht an Dein eigenes Ohr ran...",
			"Noe, noe, das schmeckt bestimmt nicht gut.")) return 1;
		out_sel="Du knabberst@@adverb@@ an "+who->name(WESSEN)+" Ohr.";
		out_vic="@@Name@@ knabbert@@adverb@@ an Deinem Ohr.";
		out_oth="@@Name@@ knabbert@@adverb@@ an "+who->name(WESSEN)+" Ohr.";
		return FeelIt();
	  
	/**************** Knicksen ***************/
	case "knicks": verb="knickse";
	case "knickse":
		if (ghost()) GHOST("Du knickst in der Mitte ab, kriegst Dich aber "+
			"schnell wieder zusammen.",
			"@@Name@@ knick(s)t in der Mitte ab, kriegt sich aber\n"
			+"zum Glueck schnell wieder zusammen.", 0);
		if (!str) {
			out_sel="Du machst einen anmutigen Knicks@@adverb@@.";
			out_oth="@@Name@@ macht einen anmutigen Knicks@@adverb@@.";
		} else {
			ParseRest(str, ALLOW_ALL, "vor");
			if(for_all) {
				out_sel="Du knickst@@adverb@@ vor @@alle@@.";
				out_vic="@@Name@@ knickst@@adverb@@ vor @@alle@@.";
				return MixedOut(WEM);
			}
			if (CheckLife( "Wie willst Du das denn schaffen?",
				"Vor Sachen wird hier nicht geknickst!")) return 1;
			out_sel="Du knickst@@adverb@@"+(who ? " vor" : "")+"@@ wem@@.";
			if (who) out_vic="@@Name@@ knickst@@adverb@@ vor Dir.";
			out_oth="@@Name@@ knickst@@adverb@@"+(who ? " vor" : "")+"@@ wem@@.";
		}
		return FeelIt();

	/**************** Knirschen ***************/
	case "knirsch": verb="knirsche";
	case "knirsche":
		if (ghost()) RETURN("Du kannst mit nichts knirschen, so als Geist. "+
			"Versuche doch dafuer\nmal, zu rasseln...\n");
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Knirsche wie?\n");
		switch (QueryProp(P_RACE)) {
		case "erzgreif":
		case "greif":
			str1="dem Schnabel.";
			break;
		case "drache":
			str1="den Fangzaehnen.";
			break;
		default:
			str1="den Zaehnen.";
			break;
		}
		out_sel="Du knirschst@@adverb@@ mit "+str1;
		out_oth="@@Name@@ knirscht@@adverb@@ mit "+str1;
		return FeelIt();

	/**************** Knurren ***************/
	case "knurr": verb="knurre";
	case "knurre":
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du knurrst @@alle@@@@adverb@@ an.";
			out_vic="@@Name@@ knurrt @@alle@@@@adverb@@ an.";
			return MixedOut(WEN);
		}
		if (CheckLife("Du knurrst in Dich hinein.",
			"Reagiert nicht. Solltest wohl besser Lebwesen anknurren."))
			return 1;
		out_sel="Du knurrst@@ wen@@@@adverb@@"+(who ? " an." : ".");
		if (who) out_vic="@@Name@@ knurrt Dich@@adverb@@ an.";
		out_oth="@@Name@@ knurrt@@ wen@@@@adverb@@"+(who ? " an." : ".");
		return FeelIt();

	/****************  Knutschen ***************/
	case "knutsch": verb="knutsche";
	case "knutsche":
		if (ghost()) RETURN("Das kannst Du als Geist leider nicht. "+
			"Irgendwie fehlt Dir dazu das Herz.\n");
		if (!ParseRest(str, NEED_VIC))
			RETURN("Knutsche wen ab?\n");
		if (CheckLife("Das geht nicht.", "Igitt! Lieber nicht!"))
			return 1;
		out_sel="Du gibst@@ wem@@@@adverb@@ einen RICHTIGEN Kuss.";
		out_vic="@@Name@@ gibt Dir@@adverb@@ einen tiefen und "+
			"hingebungsvollen Kuss.\nDu schwebst im 7. Himmel.";
		out_oth="@@Name@@ gibt@@ wem@@@@adverb@@ einen "+
			"tiefen und hingebungsvollen Kuss.";
		return FeelIt();

	/**************** Kotzen ***************/
	case "kotz": verb="kotze";
	case "kotze":
		if (ghost()) RETURN("Ne, das ist eins von den Sachen, "+
			"die als Geist nicht gehen.\n");
		ParseRest(str);
		if (CheckLife("Igitt, nein danke.",0)) return 1;
		if (!str) {
			out_sel="Du kotzt@@adverb@@ ueber Deine Schuhe.";
			out_oth="@@Name@@ verdreht@@adverb@@ die Augen und kotzt.";
		} else {
			out_sel="Du kotzt@@adverb@@"+(who ? " auf@@ wen@@." : ".");
			if (who) out_vic="@@Name@@ kotzt@@adverb@@ auf Dich.";
			out_oth="@@Name@@ kotzt@@adverb@@"+(who ? " auf@@ wen@@." : ".");
		}
		return FeelIt();

	/**************** Kuessen ***************/
	case "kuess": verb="kuesse";
	case "kuesse":
		if (ghost()) RETURN("Als Geist kannst Du leider niemanden kuessen.\n");
		if (!ParseRest(str, NEED_VIC))
			RETURN("Wen willst Du kuessen?\n");
		if (CheckLife( "Da hast Du aber Schwierigkeiten... Du gibt es "+
			"schliesslich auf.", "Nix. Absolut nix. Kuesse lieber Lebewesen "
			"- die reagieren\nwenigstens (und sei es, dass sie Dich "+
			"fressen...).")) return 1;
		out_sel="Du kuesst@@ wen@@@@adverb@@.";
		out_vic="@@Name@@ kuesst Dich@@adverb@@.";
		out_oth="@@Name@@ kuesst@@ wen@@@@adverb@@.";
		flag=FeelIt();
		if (!r_vic && flag && !QueryProp(P_FROG) &&
			(frog=who->QueryProp(P_FROG)) &&
			QueryProp(P_LEVEL)>who->QueryProp(P_LEVEL)) {
			who->SetProp(P_FROG,0);
			SetProp(P_FROG,frog);
			tell_room(environment(ME),"PLOPP!\n");
			write(break_string(
				"Huch! Irgendwie gelangst Du zu der Ueberzeugung, dass "+
				"jetzt auf einmal nichts mehr so ist wie vorher."));
			tell_object(who,break_string(
				"Auf einmal wird die Welt um Dich wieder so "+
				"normal, wie sie frueher mal war - und vor Dir "+
				"sitzt ein"+({" "," ","e "})[frog[FROG_GENDER]]+
				frog[FROG_NAME][WER]+"."));
			say(break_string(
				who->name(WER)+" steht auf einmal da und schaut dumm aus der "+
				"Waesche. Dafuer fehlt jetzt seltsamerweise "+ME->name()+
				". Die Gesamtmenge "+frog[FROG_NAME][WER]+" im Raum hat sich "+
				"jedoch nicht geaendert..."),({who,ME}));
		 }
		 return flag;
	  
	/**************** Lachen ***************/
	case "lach": verb="lache";
	case "lache":
		if (ghost()) GHOST("Du lachst mit hohler Stimme. Den Umstehenden "+
			"(sind doch welche da, oder?)\n"+
			"laeuft es kalt den Ruecken runter.",
			"@@Name@@ lacht mit hohler Stimme.\n"+
			"Dir laeuft es eiskalt den Ruecken runter.", 0);
		if (!str) {
			out_sel="Du brichst@@adverb@@ vor Lachen zusammen.";
			out_oth="@@Name@@ bricht@@adverb@@ vor Lachen zusammen.";
		} else {
			ParseRest(str, ALLOW_ALL);
			if (for_all) {
				out_sel="Du lachst @@alle@@@@adverb@@ an.";
				out_vic="@@Name@@ lacht @@alle@@@@adverb@@ an.";
				return MixedOut(WEN);
			}
			if(CheckLife("Lach Dich doch nicht selber aus - "+
				"das machen schon andere...",
				"Lache doch lieber ein nettes Lebewesen an.")) return 1;
			out_sel="Du lachst"+(who?"@@ wen@@@@adverb@@ an.":"@@adverb@@.");
			if (who) out_vic="@@Name@@ lacht Dich@@adverb@@ an.";
			out_oth="@@Name@@ lacht"+
				(who?"@@ wen@@@@adverb@@ an.":"@@adverb@@.");
		}
		return FeelIt();

	/**************** Laecheln ***************/
	case "laechel": verb="laechle";
	case "laechle":
		if (ghost()) {
			write("Du laechelst innerlich.\n");
			return 1;
		}
		if (!str) {
			out_sel="Du laechelst@@adverb@@.";
			out_oth="@@Name@@ laechelt@@adverb@@.";
		} else {
			ParseRest(str, ALLOW_ALL);
			if (for_all) {
				out_sel="Du laechelst @@alle@@@@adverb@@ an.";
				out_vic="@@Name@@ laechelt @@alle@@@@adverb@@ an.";
				return MixedOut(WEN);
			}
			if (CheckLife("Musst schon jemand anders anlaecheln.",
				"Bitte ein Lebewesen anlaecheln.")) return 1;
			out_sel="Du laechelst@@ wen@@@@adverb@@"+(who ? " an." : ".");
			if (who) out_vic="@@Name@@ laechelt Dich@@adverb@@ an.";
			out_oth="@@Name@@ laechelt@@ wen@@@@adverb@@"+(who ? " an." : ".");
		}
		return FeelIt();
	  
	/**************** Liebe ***************/
	/* These lines appear Courtesy of     */
	/* Angus@MorgenGrauen. So long, and   */
	/* thanks for all the fish, errr,     */
	/*          text, Angus               */
	/**************************************/
	case "lieb": verb="liebe";
	case "liebe":
		if (!ParseRest(str, NEED_VIC|NOREMOTE))
			RETURN("Wen hast Du lieb?\n");
		if (CheckLife( "Ja, ich weiss, Du magst Dich, aber das musst "+
			"Du nicht zur Schau stellen.",
			"Du entwickelst seltsame Neigungen, finde ich.")) return 1;
		str1=(who->QueryProp(P_GENDER)==FEMALE ? "ihr" : "ihm");
		out_sel="Du schliesst die Augen, schmiegst Dich eng an @@wen@@ und "
			"gibst\n"+str1+" einen zaertlichen und leidenschaftlichen "
			"Kuss@@adverb@@.\nUm Dich herum versinkt die Welt und Du "
			"glaubst, auf Wolken zu schweben.";
		out_vic="@@Name@@ drueckt Dich zaertlich an sich und gibt Dir\n"
			"einen zaertlichen und leidenschaftlichen Kuss@@adverb@@. Du "
			"schliesst die\nAugen und traeumst ein wenig......Du schwebst "
			"auf Wolken direkt\nin den siebten Himmel.";
		out_oth="Du schaust dezent weg, als sich "+ME->name(WER,2)+" und "+
			who->name(WER,2)+" verliebt in die Arme\nsinken.";
		return FeelIt();
	  
	/**************** Nicken ***************/
	case "nick": verb="nicke";
	case "nicke":
	case "ja":
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du nickst @@alle@@@@adverb@@ zu.";
			out_vic="@@Name@@ nickt @@alle@@@@adverb@@ zu.";
			return MixedOut(WEM);
		}
		if (CheckLife( "Du willst Dir selber zunicken? Nein, lieber nicht, "+
			"das sieht so albern aus.", "Hm. Nix passiert. Von Lebewesen "
			"bekommt man im allgemeinen mehr Feedback.")) return 1;
		if (!adverb && !who) adverb="zustimmend";
		out_sel="Du nickst@@ wem@@@@adverb@@"+(who ? " zu." : ".");
		if (who) out_vic="@@Name@@ nickt Dir@@adverb@@ zu.";
		out_oth="@@Name@@ nickt@@ wem@@@@adverb@@"+(who ? " zu." : ".");
		return FeelIt();

	/**************** Niesen ***************/
	case "nies": verb="niese";
	case "niese":
		if (ghost())
			RETURN("Du hast keine Nase mehr, in der es Dich jucken koennte...\n");
		ParseRest(str, NO_VIC);
		out_sel="Haaaaaa-tschi! Gesundheit!"+
			(adverb ? " Du niest@@adverb@@." : "");
		out_oth="Haaaaaa-tschi! @@Name@@ niest@@adverb@@.";
		return FeelIt();
	  
	/**************** Ohrfeigen ***************/
	case "gib":
	verb="ohrfeige";
		if (!str || sscanf(str,"%s ohrfeige",str1)==0) return 0;
		if (!ParseRest(str1, NEED_VIC|ALLOW_ALL))
			RETURN("Gib wem eine Ohrfeige?\n");
		if (for_all) {
			out_sel="Du verpasst @@alle@@@@adverb@@ eine Ohrfeige.";
			out_vic="@@Name@@ verpasst @@alle@@@@adverb@@ eine Ohrfeige.";
			return MixedOut(WEM);
		}
		if (CheckLife( "Dazu sind Dir Deine Backen doch zu schade.",
			"Du wirst doch nichts schlagen, was sich nicht wehren kann?"))
			return 1;
		if (ghost())
			GHOST("Deine Hand saust mit voller Wucht durch Dein Opfer durch!",
				"@@Name@@ will "+who->name(WEM)+" eine Ohrfeige geben - "
				"aber die Hand\nsaust mit voller Wucht durch das Opfer "
				"durch!", 0);
		out_sel="Du verpasst @@wem@@@@adverb@@ eine schallende Ohrfeige.";
		out_vic="@@Name@@ verpasst Dir@@adverb@@ eine Watschn, "+
			"dass Dir Hoeren und Sehen vergeht.";
		out_oth="@@Name@@ verpasst @@wem@@@@adverb@@ eine schallende Ohrfeige.";
		return FeelIt();

	/**************** Pfeifen ***************/
	case "pfeif": verb="pfeife";
	case "pfeife":
		if (ghost()) GHOST("Es kommt leider nur (nicht mal heisse) Luft, "+
			"aber kein Pfiff.",
			"@@Name@@ spitzt den Mund und pustet angestrengt. "+
			"Nichts passiert.", 0);
		ParseRest(str);
		if (CheckLife( "Was willst Du denn damit ausdruecken? "+
			"Das gibt fuer mich keinen Sinn.", "Ich habe keine Lust dazu."))
			return 1;
		if (!adverb) {
			if (!who) adverb="unschuldig";
			else adverb="anerkennend";
		}
		out_sel="Du pfeifst@@ wem@@@@adverb@@"+(who ? " nach." : ".");
		if (who) out_vic="@@Name@@ pfeift Dir@@adverb@@ nach.";
		out_oth="@@Name@@ pfeift@@ wem@@@@adverb@@"+(who ? " nach." : ".");
		return FeelIt();

	/**************** Quieken *****************/
	case "quiek": verb="quieke";
	case "quieke":
		ParseRest(str, NO_VIC);
		if (!adverb) adverb = "wie ein rosa Schweinchen";
		out_sel="Du quiekst@@adverb@@.";
		out_oth="@@Name@@ quiekt@@adverb@@.";
		return FeelIt();

	/**************** Raeuspern ***************/
	case "raeusper": verb="raeuspere";
	case "raeuspere":
		ParseRest(str, NO_VIC);
		out_sel="Du raeusperst Dich@@adverb@@.";
		out_oth="@@Name@@ raeuspert sich@@adverb@@.";
		return FeelIt();
	  
	/**************** Ruelpsen ***************/
	case "ruelps": verb="ruelpse";
	case "ruelpse":
		if (ghost())
			GHOST("Ein leichter Windhauch entfaehrt Deinem Mund, mehr nicht.",
				"Dem Mund des Geistes von "+ME->name(WEM)+
				" entfaehrt ein leichtes Lueftchen.", 0);
		if (!str) {
			out_sel="BOOOOEEERRRRPP!  Entschuldige Dich gefaelligst!";
			out_oth="@@Name@@ ruelpst@@adverb@@ unanstaendig.";
		} else {
			ParseRest(str, NO_VIC);
			out_sel="Du ruelpst@@adverb@@. Schaem Dich!";
			out_oth="@@Name@@ ruelpst@@adverb@@ und wird nicht mal rot dabei.";
		}
		return FeelIt();

	}
	// Frag mich keiner wieso das in 2 Stuecke gespalten ist...
	switch (verb) {

	  /**************** Runzeln ***************/
	case "runzel":
	case "runzele": verb="runzle";
	case "runzle":
		if (ghost()) RETURN("DAS geht als Geist nun wirklich nicht.\n");
		ParseRest(str, NO_VIC, "stirn");
		out_sel="Du runzelst@@adverb@@ die Stirn.";
		out_oth="@@Name@@ runzelt@@adverb@@ die Stirn.";
		return FeelIt();
	  
	/**************** Schmollen ***************/
	case "schmoll": verb="schmolle";
	case "schmolle":
		if (ghost()) GHOST("Du schwebst beleidigt in die Ecke.\n",
			"@@Name@@ schwebt beleidigt in die Ecke und schmollt.\n", 0);
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Schmolle wie?\n");
		out_sel="Du schmollst@@adverb@@.";
		out_oth="@@Name@@ geht in die Ecke und schmollt@@adverb@@.";
		return FeelIt();
	  
	/**************** Schmunzeln ***************/
	case "schmunzel":
	case "schmunzele": verb="schmunzle";
	case "schmunzle":
		ParseRest(str, NO_VIC);
		out_sel="Du schmunzelst@@adverb@@.";
		out_oth="@@Name@@ schmunzelt@@adverb@@.";
		return FeelIt();
	  
	/**************** Schnippen ***************/
	case "schnipps":
	case "schnippse":
	case "schnipp": verb="schnippe";
	case "schnippe":
		if (ghost()) GHOST("Du schaffst es nicht, weil die Finger "+
			"durcheinander durch gehen.",
			"@@Name@@ versagt beim Schnippen - die Finger\n"+
			"gehen durcheinander durch.", 0);
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Schnippe wie?\n");
		out_sel="Du schnippst@@adverb@@ mit Deinen Fingern.";
		out_oth="@@Name@@ schnippt@@adverb@@ mit den Fingern.";
		return FeelIt();
	  
	/**************** Schnarchen ***************/
	case "schnarch": verb="schnarche";
	case "schnarche":
		if (ghost()) RETURN("Ich glaube, da fehlen Dir irgendwie die "+
			"physischen Voraussetzungen dazu.\n");
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Schnarche wie?\n");
		if (!adverb) adverb="laut";
		out_sel="Du schnarchst@@adverb@@.";
		out_oth="@@Name@@ schnarcht@@adverb@@.";
		return FeelIt();

	/**************** Schnurren ***************/
	case "schnurr": verb="schnurre";
	case "schnurre":
		ParseRest(str);
		if (!adverb) {
			if (who) adverb="verliebt";
			else adverb="zufrieden";
		}
		if (!who) out_sel="MMMMIIIIIAAAAAAUUUUUUUU! Du schnurrst@@adverb@@.";
		else {
			out_sel="Du schnurrst @@wen@@@@adverb@@ an.";
			out_vic="@@Name@@ schnurrt Dich@@adverb@@ an.";
		}
		out_oth="@@Name@@ schnurrt@@ wen@@@@adverb@@.";
		return FeelIt();
	  
	/**************** Schreien ***************/
	case "schrei": verb="schreie";
	case "schreie":
		if (ghost()) GHOST("AAAAIIIIIIIIIIIEEEEEEEEEEEEEEEEEEEEEEEEEE! Ja, "
			"nur Geister koennen so schreien!", "@@Name@@ schreit - das Blut "
			"gefriert fast in Deinen Adern!", 0);
		if (!str) {
			out_sel="AUUUAAAHHHHHH!!!!";
			out_oth="@@Name@@ schreit@@adverb@@ laut!";
		} else {
			ParseRest(str);
			out_sel="Du schreist@@ wen@@@@adverb@@"+(who ? " an" : "")+".";
			if (who) out_vic="@@Name@@ schreit Dich@@adverb@@ an.";
			out_oth="@@Name@@ schreit@@ wen@@@@adverb@@"+(who? " an" : "")+".";
		}
		return FeelIt();

	/**************** Schuetteln ***************/
	case "schuettel":
	case "schutettele": verb="schuettle";
	case "schuettle":
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du schuettelst @@alle@@@@adverb@@ die Haende.";
			out_vic="@@Name@@ schuettelt @@alle@@@@adverb@@ die Haende.";
			return MixedOut(WEM);
		}
		if (!who) {
			out_sel="Du schuettelst Dich@@adverb@@.";
			out_oth="@@Name@@ schuettelt sich@@adverb@@.";
		} else {
			if (CheckLife( 0, "Noe, das mach ich nur mit Lebewesen."))
				return 1;
			if (who == ME) {
				if (!adverb) adverb="triumphierend";
				out_sel="Du hebst@@adverb@@"
					" Deine Haende ueber den Kopf und schuettelst sie.";
				out_oth="@@Name@@ hebt@@adverb@@"
					" die Haende ueber den Kopf\nund schuettelt sie.";
			} else {
				if (frog=who->PlayerShakes(ME)) {
					if (frog>0) return 1;
					write(capitalize(who->name(WER,1))+" hat keine Haende, "
						"die Du schuetteln koenntest.\n");
					return 1;
				}
				out_sel="Du schuettelst@@ wem@@@@adverb@@ die Haende.";
				if (ghost()) out_sel+="\nNaja, Du versuchst es wenigstens - "+
					"immer diese durchlaessigen Haende...";
				out_vic="@@Name@@ schuettelt Dir@@adverb@@ die Haende.";
				if (ghost()) out_vic+="\nNaja, versucht es wenigstens - "+
					"immer diese durchlaessigen Haende...";
				out_oth="@@Name@@ schuettelt@@ wem@@@@adverb@@ die Haende.";
				if (ghost()) out_oth+="\nNaja, versucht es wenigstens - "+
					"immer diese durchlaessigen Haende...";
			}
		}
		return FeelIt();
	  
	/**************** Seufzen ***************/
	case "seufz": verb="seufze";
	case "seufze":
		if (ghost()) GHOST("Du seufzt geisterhaft.",
			"@@Name@@ seufzt geisterhaft. Naja, wie denn sonst?", 0);
		ParseRest(str, NO_VIC);
		if (!adverb && str) RETURN("Seufze wie?\n");
		out_sel="Du seufzst@@adverb@@.";
		out_oth="@@Name@@ seufzt@@adverb@@.";
		return FeelIt();
	  
	/**************** Singen ***************/
	case "sing": verb="singe";
	case "singe":
		if(!str) {
			out_sel="Oh sole mio!";
			out_oth="@@Name@@ singt irgendwas italienisches.";
		} else {
			ParseRest("", NO_VIC);
			out_sel="Du singst@@adverb@@"+
				(adverb ? "." : " '"+capitalize(str)+"'.");
			str=_comm_hook(str, COMM_FRAGE);
			if (str[0]=='\t') RETURN(break_string(str[1..]));
			str=slurr(str);
			out_oth="@@Name@@ singt@@adverb@@"+
				(adverb ? "." : " '"+capitalize(str)+"'.");
		}
		return FeelIt();

	/**************** Schniefen ***************/
	case "snief":
	case "sniefe":
	case "schnief": verb="schniefe";
	case "schniefe":
		if (ghost()) GHOST("Du schniefst ganz leise.",
			"@@Name@@ schnieft ganz leise.", 0);
		ParseRest(str, NO_VIC);
		out_sel="Du schniefst@@adverb@@.";
		out_oth="@@Name@@ schnieft@@adverb@@.";
		return FeelIt();
	  
	/**************** Spucken ***************/
	case "spuck": verb="spucke";
	case "spucke":
		if (ghost()) GHOST("Du bringst nicht genug Spucke zusammen.",
			"@@Name@@ stellt gerade fest, dass man ohne Spucke nicht\n"+
			"spucken kann.", 0);
		ParseRest(str);
		if (CheckLife( "Hast Du Dich so schlecht benommen? "+
			"Lass es lieber bleiben.",0)) return 1;
		out_sel="Du spuckst@@ wen@@@@adverb@@ "+(who ? "an." : "auf den Boden.");
		if (who) out_vic="@@Name@@ spuckt Dich@@adverb@@ an.";
		out_oth="@@Name@@ spuckt@@ wen@@@@adverb@@ "+
			(who ? "an." : "auf den Boden.");
		return FeelIt();
	  
	/**************** Starren ***************/
	case "starr": verb="starre";
	case "starre":
		ParseRest(str);
		if (!adverb) adverb="vertraeumt";
		if (CheckLife( "Wie willst Du in Deine eigenen Augen starren? "+
			"(Spiegel gelten nicht...)",0)) return 1;
		out_sel="Du starrst"+(!str ? "@@adverb@@ ins Leere." : 
			(who ? "@@ wen@@" : "")+"@@adverb@@"+(who ? " an." : "."));
		if (who) out_vic="@@Name@@ starrt@@adverb@@ in Deine Augen.";
		out_oth="@@Name@@ starrt"+(!str ? "@@adverb@@ ins Leere." : 
			(who ? "@@ wen@@" : "")+"@@adverb@@"+(who ? " an." : "."));
		return FeelIt();

	/**************** Staunen ***************/
	case "staun": verb="staune";
	case "staune":
		if (!str) {
			out_sel="Du bist@@adverb@@ erstaunt.";
			out_oth="@@Name@@ ist@@adverb@@ erstaunt.";
		} else {
			ParseRest(str, 0, "ueber");
			if (!who && !adverb) RETURN("Bla schwall. Wenn Du nach staune "
				"noch was tippst, sollte das ein\nLebewesen sein.\n");
			if (who == ME) {
				out_sel="Du staunst@@adverb@@ ueber Dich selber.";
				out_oth="@@Name@@ staunt@@adverb@@ ueber sich selber.";
			} else {
				out_sel="Du staunst@@adverb@@"+(who ? " ueber@@ wen@@." : ".");
				if (who) out_vic="@@Name@@ staunt@@adverb@@ ueber Dich.";
				out_oth="@@Name@@ staunt@@adverb@@"+(who ? " ueber@@ wen@@." : ".");
			}
		}
		return FeelIt();

	/**************** Stieren ***************/
	case "stier": verb="stiere";
	case "stiere":
		if (ghost()) GHOST("Du stierst mit hohlem Blick in die Gegend.",
			"@@Name@@ stiert mit hohlem Blick in die Gegend.", 0);
		ParseRest(str);
		if (CheckLife( "Du kannst Dich nicht selber anstieren.",
			"Bitte nur Lebewesen anstieren.")) return 1;
		out_sel="Du stierst@@ wen@@@@adverb@@"+
			(who ? " an." : " in der Gegend herum.");
		if (who) out_vic="@@Name@@ stiert Dich@@adverb@@ an.";
		out_oth="@@Name@@ stiert@@ wen@@@@adverb@@"+
			(who ? " an." : " in der Gegend herum.");
		return FeelIt();

	/**************** Stohenen ***************/
	case "stoehn": verb="stoehne";
	case "stoehne":
		if (ghost()) GHOST("Du stoehnst schauderlich.",
			"@@Name@@ stoehnt schauderlich. Zum Glueck\n"+
			"hast Du ziemlich gute Nerven.", 0);
		ParseRest(str, NO_VIC);
		if (!adverb && str) RETURN("Wie willst Du stoehnen?\n");
		out_sel="Du stoehnst@@adverb@@.";
		out_oth="@@Name@@ stoehnt@@adverb@@.";
		return FeelIt();
	  
	/**************** Stossen ***************/
	case "stoss": verb="stosse";
	case "stosse":
		if (!ParseRest(str, NEED_VIC)) RETURN("Stosse wen?\n");
		if (CheckLife( "Was soll der Unsinn? Lass das!",
			"Das gibt nur bei Lebewesen Sinn.")) return 1;
		if (ghost()) GHOST("Dein Ellenbogen versinkt in "+who->name(WEM)+".",
			"@@Name@@ will "+who->name(WEM)+" in die Rippen stossen, aber "+
			QPP(MALE,WER,PLURAL)+
			"\nEllenbogen verteilen keinen Stoss, sondern versinken.",
			"@@Name@@ will Dich in die Rippen stossen, aber "+
			QPP(MALE,WER,PLURAL)+
			" Ellenbogen versinken.");
		out_sel="Du stoesst@@ wem@@@@adverb@@ in die Rippen.";
		out_vic="@@Name@@ stoesst Dir@@adverb@@ in die Rippen.";
		out_oth="@@Name@@ stoesst@@ wem@@@@adverb@@ in die Rippen.";
		return FeelIt();
	  
	/**************** Streicheln ***************/
	case "streichel":
	case "streichele": verb="streichle";
	case "streichle":
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL)) RETURN("Streichle wen?\n");
		if (for_all) {
			out_sel="Du streichelst @@alle@@@@adverb@@.";
			out_vic="@@Name@@ streichelt @@alle@@@@adverb@@.";
			return MixedOut(WEN);
		}
		if (CheckLife( "Lass Dich von anderen streicheln.",
			"Ich streichle nur Lebewesen.")) return 1;
		if (ghost()) GHOST("Du willst "+who->name(WEN,2)+
			" streicheln, aber Deine Haende koennen\nnichts beruehren.",
			"@@Name@@ will "+who->name(WEN,2)+" streicheln, aber diese\n"
			+"Geisterhaende koennen halt nix beruehren...",
			"@@Name@@ will Dich streicheln, scheitert aber wie so oft an\n"
			+"diesen dummen durchlaessigen Geisterhaenden.");
		out_sel="Du streichelst @@wen@@@@adverb@@.";
		out_vic="@@Name@@ streichelt Dich@@adverb@@.";
		out_oth="@@Name@@ streichelt @@wen@@@@adverb@@.";
		return FeelIt();
	  
	/**************** Tanzen ***************/
	case "tanz": verb="tanze";
	case "tanze":
		if (ghost()) GHOST("Du tanzt den klassischen GeisterTanz (tm).",
			"@@Name@@ tanzt den klassischen GeisterTanz (tm).", 0);
		if (!str) {
			out_sel="Kommst Du Dir nicht irgendwie bloed vor? "+
				"Du tanzt@@adverb@@ den Ententanz.";
			out_oth="@@Name@@ tanzt@@adverb@@ den Ententanz.";
		} else {
			taenze=({"Walzer","Polka","Rumba","Tango","Cha cha cha","Foxtrott",
				"Mambo","Salsa","Slowfox","Breakdance","Pogo","Merengue",
				"Rock'n'Roll","Ballett","Regentanz","Hexentanz"});
			if (!ParseRest(str, NEED_VIC, "mit"))
				RETURN("Mit wem willst Du tanzen?\n");
			if (CheckLife("Mit Dir selber kannst Du nicht tanzen.",
				"Keine Reaktion - will wahrscheinlich nicht tanzen."))
				return 1;
			ifoo=random(sizeof(taenze));
			out_sel="Du tanzt@@adverb@@ mit @@wem@@ eine Runde "+
				taenze[ifoo]+".";
			out_vic="@@Name@@ reisst Dich an sich und tanzt@@adverb@@ "+
				"eine Runde "+taenze[ifoo]+" mit Dir.";
			out_oth="@@Name@@ schnappt sich @@wen@@ und die beiden "+
				"tanzen@@adverb@@ eine Runde "+taenze[ifoo]+".";
		}
		return FeelIt();

	/**************** Treten ***************/
	case "tritt":
	case "tret": verb="trete";
	case "trete":
		if (!str) {
			if (ghost())
				GHOST("Dein Fuss faehrt durch die beruehmte langvergessene "+
				"unsichtbare Schildkroete\nhindurch.",
				"@@Name@@ will die beruehmte langvergessene unsichtbare\n"+
				"Schildkroete treten, aber "+QPP(MALE,WER)+
				" Fuss faehrt durch sie hindurch.", 0);
			out_sel="Du trittst die beruehmte langvergessene unsichtbare "+
				"Schildkroete@@adverb@@.";
			out_oth="@@Name@@ tritt die beruehmte langvergessene unsichtbare "+
				"Schildkroete@@adverb@@.";
		} else {
			ParseRest(str, NEED_VIC|ALLOW_ALL);
			if (for_all) {
				out_sel="Du trittst @@alle@@@@adverb@@. "+
					"Solltest Du nicht langsam an Flucht denken?";
				out_vic="@@Name@@ tritt @@alle@@@@adverb@@. "+
					"Traut sich ganz schoen was!";
				return MixedOut(WEN);
			}
			if (CheckLife( "Du schaffst es nicht, Dir selber in den "+
				"Hintern zu treten.", "Tote Sachen tritt man nicht auch noch!"))
				return 1;
			if (who) {
				out_sel="Du trittst@@ wen@@@@adverb@@.";
				if (who) out_vic="@@Name@@ tritt Dich@@adverb@@.";
				out_oth="@@Name@@ tritt@@ wen@@@@adverb@@.";
			} else {
				out_sel="Du trittst die beruehmte langvergessene "+
					"unsichtbare Schildkroete@@adverb@@.";
				out_oth="@@Name@@ tritt die beruehmte langvergessene "+
					"unsichtbare Schildkroete\n@@adverb@@.";
			}
		}
		return FeelIt();

	/**************** Troesten ***************/
	case "troest": verb="troeste";
	case "troeste":
		if (!ParseRest(str, NEED_VIC)) RETURN("Wen willst Du troesten?\n");
		if (CheckLife( "Trost musst Du bei jemand anders suchen.",
			"Das Teil musst Du nicht troesten, das fuehlt nix.")) return 1;
		out_sel="Du troestest@@ wen@@@@adverb@@.";
		out_vic="@@Name@@ troestet Dich@@adverb@@.";
		out_oth="@@Name@@ troestet@@ wen@@@@adverb@@.";
		return FeelIt();
	  
	/**************** Umarmen ***************/
	case "umarm": verb="umarme";
	case "umarme":
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("Wen willst Du umarmen?\n");
		if (CheckLife(0,"Bitte umarme nur Lebewesen.")) return 1;
		if (ghost() && CheckLife(
		   "Du kannst Dich als Geist nicht selber waermen.",0))
		   return 1;
		if (who) {
			str1=who->name(WEN, 2);
			str2=who->QueryPronoun(WEN);
		}
		if (ghost()) GHOST("Du willst "+str1+" umarmen, aber Deine Arme gehen "
			"durch "+str2+" durch.", "@@Name@@ will "+str1+" umarmen, aber "+
			QPP(MALE,WER,PLURAL)+" Arme gehen\ndurch "+str2+" hindurch.",
			"@@Name@@ will Dich umarmen, aber "+QPP(MALE,WER,PLURAL)
			+" Arme gehen durch Dich hindurch.");
		if (for_all) {
			out_sel="Du umarmst @@alle@@@@adverb@@.";
			out_vic="@@Name@@ umarmt @@alle@@@@adverb@@.";
			return MixedOut(WEN);
		}
		if (who==ME) {
			out_sel="Du legst Deine Arme um Dich und waermst Dich ein "+
				"bisschen selber@@adverb@@.";
			out_oth="@@Name@@ legt "+QPP(MALE,WER,PLURAL)+
				" Arme um sich und waermt sich ein bisschen selber@@adverb@@.";
		} else {
			out_sel="Du umarmst@@ wen@@@@adverb@@.";
			out_vic="@@Name@@ umarmt Dich@@adverb@@.";
			out_oth="@@Name@@ umarmt@@ wen@@@@adverb@@.";
		}
		return FeelIt();

	/**************** Verneigen / Verbeugen ***************/
	case "verbeug":
	case "verbeuge":
	case "verneig": verb="verneige";
	case "verneige":
		if (ghost()) GHOST("Du verneigst Dich ein bisschen heftig - "+
			"Dein Kopf taucht kurz in den Boden.",
			"@@Name@@ verneigt sich ein bisschen heftig - "+
			QPP(MALE,WER)+" Kopf\ntaucht kurz in den Boden ein.", 0);
		if ((!str) || (str == "dich")) {
			out_sel="Du verneigst Dich@@adverb@@ vor den Anwesenden.";
			out_oth="@@Name@@ verneigt sich anmutig@@adverb@@.";
		} else {
			ParseRest(str, ALLOW_ALL);
			if (for_all) {
				out_sel="Du verneigst Dich@@adverb@@ vor @@alle@@.";
				out_vic="@@Name@@ verneigt sich@@adverb@@ vor @@alle@@.";
				return MixedOut(WEM);
			}
			if (CheckLife("Wie willst Du das denn schaffen?",
				"Vor Sachen wird hier nicht verneigt, klar?\n")) return 1;
			out_sel="Du verneigst Dich@@adverb@@"+
				(who ? " vor" : "")+"@@ wem@@.";
			if (who) out_vic="@@Name@@ verneigt sich@@adverb@@ vor Dir.";
			out_oth="@@Name@@ verneigt sich@@adverb@@"+
				(who ? " vor" : "")+"@@ wem@@.";
		}
		return FeelIt();

	/**************** Wackeln ***************/
	case "wackel":
	case "wackele": verb="wackle";
	case "wackle":
		if (ghost())
			RETURN("Da gibt es nichts mehr, womit Du wackeln kannst.\n");
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Wackle wie?\n");
		out_sel="Du wackelst@@adverb@@ mit dem Hintern.";
		out_oth="@@Name@@ wackelt@@adverb@@ mit "+QPP(MALE,WEM)+" Hintern.";
		return FeelIt();

	/**************** Waelzen ***************/
	case "waelz": verb="waelze";
	case "waelze":
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Waelze Dich wie auf dem Boden?\n");
		if (!adverb) adverb="vor Lachen";
		out_sel="Du waelzt Dich@@adverb@@ auf dem Boden.";
		out_oth="@@Name@@ waelzt sich@@adverb@@"+
			(ghost() ? " im" : " auf dem")+" Boden.";
		return FeelIt();
	  
	/**************** Weinen ***************/
	case "wein": verb="weine";
	case "weine":
		if (ghost()) GHOST("Es reicht leider nur fuer ein paar winzige "
			"Nebelwoelkchen, nicht fuer Traenen.",
			"@@Name@@ verzieht das Gesicht und ein paar winzige Nebel-\n"+
			"woelkchen entfernen sich von "+QPP(FEMALE, WEM, PLURAL)+
			" \"Augen\".\n", 0);
		if (!str) {
			out_sel="Waaaaah! Du weinst bitterlich@@adverb@@.";
			out_oth="@@Name@@ bricht in Traenen aus und weint bitterlich@@adverb@@.";
		} else {
			ParseRest(str);
			if (CheckLife("Bei sich selber kann man sich so schlecht "
				"ausweinen.", "Bei wem willst Du Dich ausweinen???"))
				return 1;
			if (who) {
				out_sel="Du weinst Dich@@adverb@@ bei@@ wem@@ aus.";
				out_vic="@@Name@@ weint sich@@adverb@@ bei Dir aus.";
				out_oth="@@Name@@ weint sich@@adverb@@ bei@@ wem@@ aus.";
			} else {
				out_sel="Du brichst in Traenen aus und weinst@@adverb@@.";
				out_oth="@@Name@@ bricht in Traenen aus und weint@@adverb@@.";
			}
		}
		return FeelIt();

	/**************** Winken ***************/
	case "wink": verb="winke";
	case "winke":
		ParseRest(str, ALLOW_ALL);
		if (for_all) {
			out_sel="Du winkst @@alle@@@@adverb@@ zu.";
			out_vic="@@Name@@ winkt @@alle@@@@adverb@@ zu.";
			return MixedOut(WEM);
		}
		if (CheckLife("Wink Dir nicht selber zu.",
			"Du musst schon einem Lebewesen zuwinken.")) return 1;
		out_sel="Du winkst@@ wem@@@@adverb@@"+(who ? " zu" : "")+".";
		if (who) out_vic="@@Name@@ winkt Dir@@adverb@@ zu.";
		out_oth="@@Name@@ winkt@@ wem@@@@adverb@@"+(who ? " zu" : "")+".";
		return FeelIt();
	  
	/**************** Wuergen ***************/
	case "wuerg": verb="wuerge";
	case "wuerge":
		ParseRest(str);
		if (!who) {
			out_sel="Du faengst@@adverb@@ an zu wuergen.";
			out_oth="@@Name@@ faengt@@adverb@@ an zu wuergen.";
		} else if (who!=ME) {
			out_sel="Du springst @@wen@@ an und faengst an, "+
				who->QueryPronoun(WEN) +"@@adverb@@ zu wuergen.";
			out_vic="@@Name@@ springt Dich auf einmal an und wuergt "+
				"Dich@@adverb@@.";
			out_oth="@@Name@@ springt auf einmal @@wen@@ an und wuergt "
				+who->QueryPronoun(WEN)+"@@adverb@@.";
		} else {
			out_oth="@@Name@@ verdreht die Augen und faengt an, "
				"sich selbst@@adverb@@ zu wuergen.";
			out_sel="Du verdrehst deine Augen und faengst an, "
				"Dich selbst@@adverb@@ zu wuergen.";
			who=0;
		}
		return FeelIt();
	  
	/**************** Zittern ***************/
	case "zitter": verb="zittere";
	case "zittere":
		if (!str) {
			out_sel="Brrrrrr!!!";
			out_oth="@@Name@@ zittert@@adverb@@ vor Angst.";
		} else {
			ParseRest(str, NO_VIC);
			if (!adverb) RETURN("Zittere wie?\n");
			out_sel="Du zitterst@@adverb@@.";
			out_oth="@@Name@@ zittert@@adverb@@.";
		}
		return FeelIt();
	  
	/**************** Zwinkern ***************/
	case "zwinker": verb="zwinkere";
	case "zwinkere":
		if (ghost()) RETURN("Vergiss es - das ist als Geist viel zu unauffael"
			"lig, als dass\nes andere Leute sehen wuerden.\n");
		ParseRest(str);
		if (CheckLife( "Du kannst Dir nicht selber zuzwinkern.",
			"Wieso reagiert das Ding da nicht auf Dein Zwinkern? "+
			"Ist es etwa tot?")) return 1;
		out_sel="Du zwinkerst@@ wem@@@@adverb@@"+(who ? " zu." : ".");
		if (who) out_vic="@@Name@@ zwinkert Dir@@adverb@@ zu.";
		out_oth="@@Name@@ zwinkert@@ wem@@@@adverb@@"+(who ? " zu." : ".");
		return FeelIt();

	// Achtung, ab jetzt sind das Highlander-Verben :)

	/**************** Aechzen ***************/
	case "aechz": verb="aechze";
	case "aechze":
		ParseRest(str, NO_VIC);
		out_sel="Du aechzt@@adverb@@.";
		out_oth="@@Name@@ aechzt@@adverb@@.";
		return FeelIt();

	/**************** Argln ***************/
	case "argl":
		ParseRest(str, NO_VIC);
		out_sel="Du arglst"+(adverb ? "@@adverb@@." : 
			" ein wenig@@adverb@@ vor Dich hin.");
		out_oth="@@Name@@ arglt"+(adverb ? "@@adverb@@." : 
			" ein wenig@@adverb@@ vor sich hin.");
		return FeelIt();
	  
	/**************** Aufatmen ***************/
	case "atme":
		if (!str || sscanf(str,"%sauf",str1)!=1) RETURN("Atme wie auf?\n");
		ParseRest(str1, NO_VIC);
		if (!adverb) adverb="erleichtert";
		out_sel="Du atmest@@adverb@@ auf.";
		out_oth="@@Name@@ atmet@@adverb@@ auf.";
		return FeelIt();
	  
	/**************** Bewundern ***************/
	case "bewunder": verb="bewundere";
	case "bewundere":
		if (!ParseRest(str, NEED_VIC)) RETURN("Bewundere wen?\n");
		out_sel="Du bewunderst @@wen@@@@adverb@@.";
		out_vic="@@Name@@ bewundert Dich@@adverb@@.";
		out_oth="@@Name@@ bewundert @@wen@@@@adverb@@.";
		return FeelIt();
	  
	/**************** Erbleichen ***************/
	case "erbleich": verb="erbleiche";
	case "erbleiche":
		if (ghost()) GHOST("Ich weiss zwar nicht, wie Du das schaffst, "+
			"aber Du wirst noch bleicher.",
			"Wie unwahrscheinlich das auch ist, aber @@name@@"
			" schafft\nes tatsaechlich, noch bleicher zu werden.", 0);
		ParseRest(str, NO_VIC);
		out_sel="Du erbleichst@@adverb@@.";
		out_oth="@@Name@@ erbleicht@@adverb@@.";
		return FeelIt();
	  
	/**************** Fluchen ***************/
	case "fluch": verb="fluche";
	case "fluche":
		if (ghost())
			GHOST("Du faengst mangels Resonanzkoerper leise an zu fluchen.",
			"@@Name@@ faengt leise an zu fluchen. Laut kann er nicht,\n"+
			"mangels Luft und Resonanzkoerper.", 0);
		if (!str) {
			out_sel="Du fluchst lautstark@@adverb@@.";
			out_oth="@@Name@@ faengt@@adverb@@ fuerchterlich an zu fluchen.";
		} else {
			ParseRest(str, NO_VIC);
			out_sel="Du fluchst@@adverb@@.";
			out_oth="@@Name@@ flucht auf einmal@@adverb@@.";
		}
		return FeelIt();

	/**************** Grunzen ***************/
	case "grunz": verb="grunze";
	case "grunze":
		ParseRest(str, NO_VIC);
		out_sel="Du grunzt@@adverb@@.";
		out_oth="@@Name@@ grunzt@@adverb@@.";
		return FeelIt();
	
	/**************** Begruessen ************/
	case "hi": verb = "hallo";
	case "hallo":
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("WEN willst Du begruessen?\n");
                if (for_all) {
                        out_sel="Du begruesst @@alle@@@@adverb@@.";
                        out_vic="@@Name@@ begruesst @@alle@@@@adverb@@.";
                        return MixedOut(WEN);
                }
                if (CheckLife("Findest Du das nicht etwas albern?",
                        "Du musst schon ein Lebewesen begruessen.")) 
				return 1;
                out_sel="Du begruesst@@ wen@@@@adverb@@.";
                if (who) out_vic="@@Name@@ begruesst Dich@@adverb@@.";
                out_oth="@@Name@@ begruesst@@ wen@@@@adverb@@.";
                return FeelIt();
  
	/**************** Kuscheln ***************/
	case "kuschel": verb="kuschle";
	case "kuschle":
		if (ghost())
			GHOST("Dazu bist Du als Geist viel zu kalt und gar schroecklich "+
			"anzusehen.",
			"@@Name@@ scheint Anwandlungen zu haben, sich an jemand "+
			"ankuscheln zu wollen."+
			"Entsetzt springen alle zurueck, weil dazu ist er doch zu "+
			"kalt und schroecklich\nanzusehen.", 0);
		if (!ParseRest(str, NEED_VIC))
			RETURN("An wen willst Du Dich ankuscheln?\n");
		out_sel="Du kuschelst Dich@@adverb@@ an @@wen@@ an.";
		out_vic="@@Name@@ kuschelt sich@@adverb@@ an Dich an.";
		out_oth="@@Name@@ kuschelt sich@@adverb@@ an @@wen@@ an.";
		return FeelIt();
	  
	/**************** Rotfln ***************/
	case "rotfl":
		ParseRest(str, NO_VIC);
		out_sel="Du rotflst@@adverb@@.";
		out_oth="@@Name@@ rotflt@@adverb@@.";
		return FeelIt();

	/**************** Verfluchen ***************/
	case "verfluche":
		if (!str) RETURN("Wen oder was willst Du denn verfluchen?\n");
		ParseRest(str);
		if (!who) {
			out_sel="Du verfluchst@@adverb@@.";
			out_oth="@@Name@@ verflucht@@adverb@@.";
		} else {
			if (who==ME) RETURN("Sich selber verflucht man besser nicht...\n");
			out_sel="Du verfluchst@@ wen@@@@adverb@@.";
			out_vic="@@Name@@ verflucht Dich@@adverb@@.";
			out_oth="@@Name@@ verflucht@@ wen@@@@adverb@@.";
		}
		return FeelIt();

	/**************** Kitzeln ***************/
	case "kitzel":
	case "kitzele": verb="kitzle";
	case "kitzle": 
		if (ghost())
			GHOST("Mit Deinen immateriellen Fingern schaffst Du das nicht.",
			"@@Name@@ muss gerade feststellen, dass man mit\n"
			+"immateriellen Fingern nicht kitzeln kann.", 0);
		if (!ParseRest(str, NEED_VIC))
			RETURN("Wen willst Du kitzeln?\n");
		if (CheckLife("Du bist doch kein Masochist! Du laesst es bleiben.",
			"Dinge sind so selten kitzlig. Lass es bleiben.")) return 1;
		if (frog=who->PlayerTickles(ME)) {
			if (!pointerp(frog)) return 1;
			str1=frog[0];
			str2=frog[1];
			t_g=frog[2];
			t_n=frog[3];
		} else if (who->QueryProp(P_RACE))
			switch (lower_case(who->QueryProp(P_RACE))) {
			case "drache": 
				str1="unter";
				str2="Schuppen"; 
				t_g=FEMALE; 
				t_n=PLURAL; 
				break;
			case "erzgreif":
			case "greif":
				str1="unter";
				str2="Federn";
				t_g=FEMALE;
				t_n=PLURAL;
				break;
			default:
				str1="an";
				str2="Kinn";
				t_g=NEUTER;
				t_n=SINGULAR;
				break;
			}
		else {
			str1="an";
			str2="Kinn";
			t_g=NEUTER;
			t_n=SINGULAR;
		}
		out_sel="Du kitzelst@@ wen@@@@adverb@@ "+str1+" "+
			who->QPP(t_g,WEM,t_n)+" "+str2+
			".\n@@wer@@ versucht, sich zu beherrschen, muss aber doch lachen.";
		out_vic="@@Name@@ kitzelt Dich@@adverb@@ "+str1+" Deine"+
			(t_n ? "n" : (t_g==FEMALE ? "r" : "m"))+" "+str2+
			".\nDu versuchst, Dich zu beherrschen, musst aber doch lachen.";
		out_oth="@@Name@@ kitzelt@@ wen@@@@adverb@@ "+str1+" "+
			who->QPP(t_g,WEM,t_n)+" "+str2+
			".\n@@wer@@ versucht, sich zu beherrschen, muss aber doch lachen.";
		return FeelIt();

	/**************** Verneinen ***************/
	case "noe": verb="nein";
	case "nein":
		if (ghost()) GHOST("Du schuettelst Deinen Kopf so heftig, "+
			"dass er kurz davonschwebt.",
			"@@Name@@ schuettelt heftig den Kopf -\n"
			+"so heftig, dass dieser kurz davonschwebt und wieder "+
			"eingefangen werden muss.", 0);
		ParseRest(str, NO_VIC);
		out_sel="Du schuettelst@@adverb@@ den Kopf.";
		out_oth="@@Name@@ schuettelt@@adverb@@ den Kopf.";
		return FeelIt();
	  
	/**************** Zeigen ***************/
	case "zeig": verb = "zeige";
	case "zeige":
		if (ghost())
			GHOST("Du hast nichts, was Du jemandem zeigen "
				"koenntest.", "", 0);
		if (!str) RETURN("Wem willst Du wie was zeigen?\n");
		str = lower_case(str);
		if (sizeof(parts = efun::explode(str, " ")) <= 1)
			RETURN("Wem willst Du wie was zeigen?\n");

		if (!objectp(obj = present(parts[sizeof(parts)-1])))
			RETURN("Sowas hast Du nicht.\n");

		ParseRest(efun::implode(parts[0..<2], " "), ALLOW_ALL);
		if (CheckLife("Du kennst Deine Sachen doch gut genug.",
			"Hm. Bei Spielern wirst Du damit wohl mehr "
			"Eindruck schinden.")) return 1;

		str1 = obj->name(WEN, NAME_DEF|NAME_DESCR);
		str2 = obj->name(WEN, NAME_INDEF|NAME_DESCR);
		if (for_all) {
                        out_sel="Du zeigst @@alle@@@@adverb@@ "+str1+".";
                        out_vic="@@Name@@ zeigt @@alle@@@@adverb@@ "+str2+".";
                        return MixedOut(WEM);
                }

		if (!adverb) adverb = "stolz";

                out_sel="Du zeigst@@ wem@@@@adverb@@ "+str1+".";
                if (who) out_vic="@@Name@@ zeigt Dir@@adverb@@ "+str2+".";
                out_oth="@@Name@@ zeigt@@ wem@@@@adverb@@ "+str2+".";
                return FeelIt();

        /**************** Deuten ***************/

	case "deut": verb="deute";
	case "deute":
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL,"auf"))
			RETURN("Auf wen oder was willst Du deuten?\n");
		if (for_all) {
			out_sel="Du deutest@@adverb@@ auf @@alle@@.";
			out_vic="@@Name@@ deutet@@adverb@@ auf @@alle@@.";
			return MixedOut(WEN);
		}
		out_sel="Du deutest@@adverb@@ auf"+
			(who==this_object()?" Dich." : "@@ wen@@.");
		if (who != this_object()) out_vic="@@Name@@ deutet@@adverb@@ auf Dich.";
		out_oth="@@Name@@ deutet@@adverb@@ auf"+
			(who==this_object() ? " sich selber.": "@@ wen@@.");
		return FeelIt();

	/**************** Denken ***************/
	case "denk": verb="denke";
	case "denke":
		ParseRest(str, NO_VIC);
		if (ghost()) RETURN("Womit willst Du denn denken? Du hast keinen Kopf...\n");
		if (str) {
			if (sscanf(str,"%s:: %s", str1, str2)!=2) str2=str,adverb=0;
			else adverb=str1;
			str1=convert_string("Du denkst@@adverb@@ .o");
			out_sel=bubble(str2, str1);
			str2=_comm_hook(str2, COMM_DENKE);
			if (str2[0]=='\t') RETURN(break_string(str2[1..]));
			str2=slurr(str2);
			str1=convert_string("@@Name@@ denkt@@adverb@@ .o");
			out_oth=bubble(str2, str1);
			// Bei grosser Blase Leerzeile einfuegen
			if (member(out_oth, '\n')!=-1) out_oth="\n"+out_oth;
			if (out_sel==0 || out_oth==0) RETURN("Das Adverb ist zu lang.\n");
			return FeelIt();
		}
		out_sel="Du faengst@@adverb@@ an zu denken.\n"+
			"Kleine Rauchwoelkchen steigen auf...";
		out_oth="@@Name@@ faengt@@adverb@@ an zu denken.\n"+
			"Kleine Rauchwoelkchen steigen auf...";
		return FeelIt();

	/**************** Knuddeln ***************/
	case "knuddel":
	case "knuddele": verb="knuddle";
	case "knuddle":
		if (ghost()) RETURN("Sorry, nicht als Geist.\n");
		if (!ParseRest(str,NEED_VIC|ALLOW_ALL))
			RETURN("Knuddle wen?\n");
		if (for_all) {
			out_sel="Du knuddelst @@alle@@@@adverb@@.";
			out_vic="@@Name@@ knuddelt @@alle@@@@adverb@@.";
			return MixedOut(WEN);
		}
		if (CheckLife( "Das bringt doch nix, lass es halt.",
			"Du kannst soviel ich weiss ausser Lebewesen nur Teddys knuddeln."))
			return 1;
		out_sel="Du knuddelst@@ wen@@@@adverb@@.";
		out_vic="@@Name@@ knuddelt Dich@@adverb@@.";
		out_oth="@@Name@@ knuddelt@@ wen@@@@adverb@@.";
		return FeelIt();
	  
	/**************** Kratzen ***************/
	case "kratz": verb="kratze";
	case "kratze":
		ParseRest(str);
		if (who && (who!=ME))
			RETURN("Das mach mal schoen nur mit Dir selber.\n");
		if (str && !adverb) RETURN("Wie willst Du Dich kratzen?\n");
		out_sel="Du kratzt Dich@@adverb@@ am Kopp.";
		out_oth="@@Name@@ kratzt sich@@adverb@@ am Kopp.";
		return FeelIt();
	  
	/**************** Zunge rausstrecken ***************/
	case "streck":
	case "strecke":
		verb="zungeraus";
		if (ghost()) GHOST("Sorry, Du hast keine Zunge zum Rausstrecken.","",0);
		if (!str) RETURN("Strecke was wie wem wo wann wieso?\n");
		str=lower_case(str);
		if (sscanf(str, "%s die zunge raus", str1)!=1 &&
			sscanf(str, "%s zunge raus", str1)!=1)
			RETURN("Strecke was wie wem wo wann wieso?\n");
		ParseRest(str1, ALLOW_ALL);
		if (CheckLife("Das waer wohl etwas schwer...",0)) return 1;
		if (for_all) {
			out_sel="Du streckst @@alle@@@@adverb@@ die Zunge raus.";
			out_vic="@@Name@@ streckt @@alle@@@@adverb@@ die Zunge raus.";
			return MixedOut(WEM);
		}
		out_sel="Du streckst@@ wem@@@@adverb@@ die Zunge raus.";
		if (who) out_vic="@@Name@@ streckt Dir@@adverb@@ die Zunge raus.";
		out_oth="@@Name@@ streckt@@ wem@@@@adverb@@ die Zunge raus.";
		return FeelIt();
	  
	/**************** Taetscheln ***************/
	case "taetschel":
	case "taetschele": verb="taetschle";
	case "taetschle":
		if (!ParseRest(str, NEED_VIC)) RETURN("Taetschle wen?\n");
		if (CheckLife( "Das sieht zu doof aus, das mache ich nicht.",
			"Ich taetschle nur Lebewesen.")) return 1;
		if (ghost()) GHOST("Du willst "+who->name(WEN)+" taetscheln - aber "
			"Deine Haende gehen\nglatt durch den Kopf durch.",
			"@@Name@@ will "+who->name(WEN)+" den Kopf taetscheln, aber "
			"die Geister-\nhaende gehen glatt durch den Kopf durch.",
			"@@Name@@ will Deinen Kopf taetscheln, aber diese "+
			"Geisterhaende gehen\nglatt durch Deinen Kopf durch - Du "
			"hast ein seltsames Gefuehl dabei.");
		out_sel="Du taetschelst @@wem@@@@adverb@@ den Kopf.";
		out_vic="@@Name@@ taetschelt Dir@@adverb@@ den Kopf.";
		out_oth="@@Name@@ taetschelt @@wem@@@@adverb@@ den Kopf.";
		return FeelIt();
	  
	/**************** Wuscheln ***************/
	case "wuschel":
	case "wuschele": verb="wuschle";
	case "wuschle":
		if (!ParseRest(str, NEED_VIC))
			RETURN("Wen willst Du denn wuscheln?\n");
		if (CheckLife(0, "Hmm, sehr tot. Ne, lieber nicht.")) return 1;
		if (frog=who->QueryProp(P_FROG)) {
			write(break_string(
				"Du verwuschelst...  aeh... hm. Gibts denn bei eine"+
				({"m ","m ","r "})[frog[FROG_GENDER]]+frog[FROG_NAME][WER]+
				" ueberhaupt was zu verwuscheln?"));
			return 1;
		}
		if (frog=who->PlayerTousles(ME)) {
			if (!pointerp(frog)) return 1;
			str1=frog[0];
			t_n=frog[1];
		} else if(who->QueryProp(P_RACE))
			switch(lower_case(who->QueryProp(P_RACE))) {
			case "drache":
				str1="Schuppen";
				t_n=PLURAL;
				break;
			case "erzgreif":
			case "greif":
				str1="Federn";
				t_n=PLURAL;
				break;
			case "steinbeisser":
			case "knuddeleisbaer":
				str1="Fell";
				t_n=SINGULAR;
				break;
			default:
				str1="Haare";
				t_n=PLURAL;
				break;
		} else {
			str1="Haare";
			t_n=PLURAL;
		}
		if (who!=ME) {
			out_sel="Du verwuschelst@@adverb@@ @@wessen@@ "+str1+".";
			out_vic="@@Name@@ verwuschelt@@adverb@@ Dein"+
				(t_n==SINGULAR ? " " : "e ")+str1+".";
			out_oth="@@Name@@ verwuschelt@@adverb@@ @@wessen@@ "+str1+".";
		} else {
			out_sel="Du verwuschelst@@adverb@@ Dein"+
				(t_n==SINGULAR ? " " : "e ")+str1+".";
			out_oth="@@Name@@ verwuschelt@@adverb@@ "+
				(ME->QueryProp(P_GENDER)==FEMALE ? "ihr" : "sein")+
				(t_n==SINGULAR ? " " : "e ")+str1+".";
			who=0;
		}
		return FeelIt();

	// Spezialsachen - Geisterverben und Magierverben

	/**************** Rasseln ***************/
	case "rassel":
	case "rassele": verb="rassle";
	case "rassle":
		if (!ghost())
			RETURN("Das ist nicht Dein Fachgebiet - Du bist doch kein Geist!\n");
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Rassel wie?\n");
		if (!adverb) adverb="gar fuerchterlich";
		out_sel="Du rasselst@@adverb@@ mit einer rostigen Rasselkette,\n"
			+"die Du auf einmal fuer einen Moment in der Hand haeltst.";
		out_oth="@@Name@@ holt auf einmal eine rostige Rasselkette aus\n"
			+"dem Nichts und faengt an,@@adverb@@ damit zu rasseln.\n"+
			"Danach ist die Kette ploetzlich wieder verschwunden.";
		return FeelIt();

	/**************** Heulen ***************/
	case "heul": verb="heule";
	case "heule":
		if (!ghost()) RETURN("Lass das mal den Fachleuten (also den Geistern).\n");
		ParseRest(str, NO_VIC);
		if (str && !adverb) RETURN("Heule wie?\n");
		if (!adverb) adverb="schauerlich";
		out_sel="Du heulst@@adverb@@.";
		out_oth="@@Name@@ heult@@adverb@@.";
		return FeelIt();
	  
	/**************** Nassspritzen ***************/
	case "splash":
		if (!IS_WIZARD(ME)) return 0;
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("Wen willst Du denn nassmachen?\n");
		if (for_all) {
			out_sel="Du ziehst Deine Wasserpistole und spritzt "+
				"@@alle@@@@adverb@@ patschnass.";
			out_vic="@@Name@@ zieht "+QPP(FEMALE,WEN)+
				" Wasserpistole und spritzt\n"
				+"@@alle@@@@adverb@@ patschnass.";
			return MixedOut(WEN);
		}
		if (who == ME) {
			out_sel="Sag mal, kommst Du Dir nicht ein bisschen doof vor?\n"
				+"Du ziehst Deine Wasserpistole und spritzt Dich@@adverb@@\n"
				+"selber patschnass.";
			out_oth="@@Name@@ zieht "+QPP(FEMALE,WEN)+
				" Wasserpistole und spritzt sich@@adverb@@\n"
				+"aus unerfindlichen Gruenden selbst patschnass.";
		} else {
			out_sel="Du ziehst Deine Wasserpistole und spritzt "+
				"@@wen@@@@adverb@@ patschnass.";
			out_vic="@@Name@@ zieht "+QPP(FEMALE,WEN)+
				" Wasserpistole und spritzt\n" +"Dich@@adverb@@ patschnass.";
			out_oth="@@Name@@ zieht "+QPP(FEMALE,WEN)+
				" Wasserpistole und spritzt\n" +"@@wen@@@@adverb@@ patschnass.";
		}
		return FeelIt();

	/**************** Anflammen ***************/
	case "flame":
		if (!IS_WIZARD(ME)) return 0;
		if (ghost()) RETURN("Du hast leider grade Deinen Flammenwerfer nicht dabei.\n");
		if (!ParseRest(str, NEED_VIC|ALLOW_ALL))
			RETURN("Wen willst Du denn ankokeln?\n");
		ifoo=!random(7);
		if (for_all) {
			out_sel="Du holst aus Deinen tiefsten Taschen "+
				"(oder was weiss denn ich woher) Deinen "+
				"Wunderland-handgearbeiteten Mini-Flammenwerfer (tm), "+
				"richtest ihn aus und...\n"+
				(ifoo ? "schaust leicht frustriert auf das Streichholz, "+
				"in das er sich verwandelt hat." :
				"feuerst@@adverb@@ einen riesigen Feuerball auf @@alle@@ ab.\n"+
				"Es riecht auf einmal so verbrannt hier...");
			out_vic="@@Name@@ holt auf einmal irgendwoher einen Wunderland "+
				"handgearbeiteten\nMini-Flammenwerfer (tm), richtet ihn aus "+
				"und...\n"+(ifoo ? "schaut ziemlich frustriert auf das Streichholz, "+
				"in das sich das Ding verwandelt hat." :
				"feuert@@adverb@@ einen riesigen Feuerball auf @@alle@@ "+
				"ab.\nDir wird so warm um's Herz...");
			return MixedOut(WEN);
		}
		out_sel="Du holst aus Deinen tiefsten Taschen (oder was weiss denn "+
			"ich woher) Deinen\nWunderland handgearbeiteten Mini-Flammenwerfer "+
			"(tm), richtest ihn aus und...\n"+
			(ifoo ? "schaust leicht frustriert auf das Streichholz, "+
			"in das er sich verwandelt hat." :
			"feuerst@@adverb@@ einen riesigen Feuerball auf @@wen@@ ab.\n"+
			"Es riecht auf einmal so verbrannt hier...");
		out_vic="@@Name@@ holt auf einmal irgendwoher einen Wunderland "+
			"handgearbeiteten\n"+
			"Mini-Flammenwerfer (tm), richtet ihn auf Dich aus und...\n"+
			(ifoo ? "schaut ziemlich frustriert auf das Streichholz, "+
			"in das sich das Ding\nverwandelt hat." :
			"feuert@@adverb@@ einen riesigen Feuerball auf Dich ab.\n"+
			"Dir wird so warm ums Herz...");
		out_oth="@@Name@@ holt auf einmal irgendwoher einen Wunderland "+
			"handgearbeiteten\n"+
			"Mini-Flammenwerfer (tm), richtet ihn auf@@ wen@@ aus und...\n"+
			(ifoo ? "schaut ziemlich frustriert auf das Streichholz, "+
			"in das sich das Ding\nverwandelt hat." :
			"feuert@@adverb@@ einen riesigen Feuerball auf@@ wen@@ ab.\n"+
			"Es riecht irgendwie verbrannt hier auf einmal...");
		return FeelIt();

	/**************** Verbenliste ***************/
	case "verb":
	case "verben":
		if (r_vic) return 0;
		verb=0; // unsichtbar im umgebenden raum
		More(SOULHELP->Help());
		return 1;

	/**************** Adverbienverwaltung ***************/
	case "adverb":
	case "adverbs":
	case "adverben":
	case "adverbien": /* Das ist die richtige Form, aber wer weiss das? */
		{
		string f1,f2;
		if (r_vic) return 0;
		verb=0; // unsichtbar im umgebenden raum
		if (!str || str=="#" || str=="$")
			return zeige_adverbs((str=="#" ? 1 : (str=="$" ? 2 : 0)));
		if (sscanf(str, "%s %s", f1,f2)==2) {
			if (f1=="")
				RETURN("Hm, da muss wohl ein Leerzeichen zu viel gewesen "+
				"sein. Bitte nochmal,\naber ohne zuviele Leerzeichen.\n");
			if (f1=="?") {
				string match;
				match=QueryStdAdverbs()[f2] || plr_adverbs[f2];
				if (match)
					write("Die Abkuerzung "+f2+" gehoert zu dem Adverb:\n"+
						match+"\n");
				else
					write("Diese Abkuerzung ist bisher nicht definiert.\n");
				return 1;
			}
			if (QueryStdAdverbs()[f1])
				RETURN("Die Standardabkuerzungen koennen nicht neu "+
				"definiert werden.\n");
			if (plr_adverbs[f1]) {
				plr_adverbs[f1]=f2;
				write("OK, Adverb mit der Abkuerzung \""+f1+"\" auf \""+f2+
					"\" gesetzt.\n");
			} else {
				if (strlen(f1) > 6)
					RETURN("Die Abkuerzung ist zu lang, bitte nicht mehr "+
					"als 6 Zeichen.\n");
				plr_adverbs[f1]=f2;
				write("OK, neues Adverb \""+f2+"\" mit der Abkuerzung \""+
					f1+"\".\n");
			}
		} else {
			if (QueryStdAdverbs()[str])
				RETURN("Die Standardadverben koennen nicht geloescht werden.\n");
			else if (!plr_adverbs[str])
				RETURN("Du hast kein Adverb mit dieser Abkuerzung.\n"+
				"Syntax:\n"+
				"  adverb, um die Adverbien anzuzeigen,\n"+
				"  adverb #, um nur Deine Adverbien anzuzeigen,\n"+
				"  adverb $, um nur die Standardadverbien anzuzeigen,\n"
				"  adverb ? <Abkuerzung>, um nachzusehen, ob "+
				"<Abkuerzung> definiert ist,\n"
				"  adverb <Abkuerzung> <Adverb>, um der <Abkuerzung> "+
				"das <Adverb> zuzuordnen,\n"
				"  adverb <Abkuerzung>, um das Adverb mit der "+
				"<Abkuerzung> zu loeschen,\n");
			else {
				write("OK, Adverb \""+plr_adverbs[str]+"\" geloescht.\n");
				plr_adverbs=m_delete(plr_adverbs, str);
			}
		}
	return 1;
	}
	} /* end switch */

	/**************** Remote-Verben Verwaltung ***************/

	if (!r_vic && !ghost() && strlen(verb)>1 && verb[0]=='r') {
		mixed tmp;
		object ob;
		if (!str) { r_vic=1; str1=0; tmp=-3;} // Fuer vernuenftige Fehlermeldung
		else if (strstr(str, " ")==-1) { r_vic=str; str1=0; }
		else { sscanf(str, "%s %s", r_vic, str1); str=str1; }
		if (stringp(r_vic)) r_vic=lower_case(r_vic);
		if (r_vic==getuid()) r_vic=0;
		else if (stringp(r_vic)) {
			tmp=match_living(r_vic, 1);
			if (stringp(tmp) && (ob=find_living(tmp)) &&
				(ob->QueryProp(P_INVIS) && !IS_LEARNING(ME))) tmp=-2;
				// Keine Unsichtbaren es sei denn wir sind 'learning'
			if (!stringp(tmp)) {
				if (r_vic=="alle" || r_vic=="allen") tmp=-4;
				r_vic=1;
			} else {
				r_vic=tmp;
				tmp=0;
			}
		}
		if (OnlyFunctionForHate(str1, verb[1..])) return 1;
		if (verb_found) {
			if (intp(r_vic)) {
				r_vic=0;
				switch (tmp) {
				// ( -2) Kein Opfer gefunden
				// ( -3) Kein Opfer angegeben
				// ( -4) Kommando mit 'alle'
				// (str) Opfernamen-Abkuerzung konnte nicht zugeordnet werden
				case  0:
				case -2: RETURN("Niemand gefunden.\n");
				case -3: RETURN("An wen soll das Kommando denn gehen?\n");
				case -4: RETURN("Das geht nicht.\n");
				default: RETURN("Das war nicht eindeutig.\n");
				}
			}
		}
		r_vic=0;
	}
	verb_found=0;
	return 0;
}

private int ghost() {
	return QueryProp(P_GHOST);
}

static int verben_liste() {
	More(SOULHELP->Help());
	return 1;
}

// Diese Funktion parsed die nach einem Verb angegebenen Argumente (arg).
// (Im wesentlichen wird ein Opfer gesucht ;)
// Im String oder Array extra koennen Worte stehen, die noch mit
// zum Verb gehoeren (zucke mit achseln)..
// flag ist eins aus: NEED_VIC, NOREMOTE, NO_VIC, ALLOW_ALL
// Returned 0 wenn Flag nicht erfuellt werden konnte, sonst 1
varargs int ParseRest(string arg, int flag, mixed extra) {
	mixed wer, wer2;
	string wie, *words;
	int num, takeremote;
	string* x;

	who=0;
	for_all=0;
	adverb=0;

	x=QueryProp(P_REMOTECMDS);
	if (!pointerp(x) || (member(x, verb)==-1 && member(x, "alle")==-1)) {
		flag|=NOREMOTE;
	}
	if (r_vic && flag&NOREMOTE) { // Verb darf nicht Remote benutzt werden
		verb_found=0;
		return 0;
	}
	if (!arg) arg="";
	else if (extra) {
		if (!pointerp(extra)) {
			if (sscanf(arg+" ", extra+" %s", wie)==1) arg=wie;
		}
		else for(num=0; num<sizeof(extra); num++)
			if (sscanf(arg+" ", extra[num]+" %s", wie)==1) arg=wie;
	}
	words=explode(arg, " ");

	if (r_vic) { // Remotevictim da und Opfer benoetigt...
		if (flag&NEED_VIC) {
			who=find_living(r_vic);
			if (!who || (who->QueryProp(P_INVIS) && !IS_LEARNING(ME))) who=0;
			else if (environment(who)==environment()) r_vic=r_find=0;
			else r_find=1;
		}
	} else if (!(flag&NO_VIC) && flag&ALLOW_ALL &&
		(words[0]=="alle" || words[0]=="allen")) {
		for_all=1;
		words=words[1..];
	}
	if (!who && !for_all && !r_vic && !(flag&NO_VIC)) { // noch kein Opfer
		wer=match_living(lower_case(words[0]), 1);
		if (stringp(wer)) { // Suche nach Interactive im Raum
			who=present(wer, environment(ME));
			if (who && who->QueryProp(P_INVIS) && !IS_LEARNING(ME)) {
				who=0;
				wer=-1;
			}
		}
		if (!who) {
			wer2=match_living(lower_case(words[0]));
			if (stringp(wer2)) { // Suche nach Living im Raum
				who=present(wer2, environment(ME));
				if (who && who->QueryProp(P_INVIS) && !IS_LEARNING(ME)) {
					who=0;
					wer2=-1;
				}
			}
		}
		if (!who && !(flag&NOREMOTE)) { // Suche nach Spieler irgendwo
			who=find_living(wer);
			if (who) {
				r_vic=wer;
				r_find=1;
			}
		}
		if (!who) who=present(words[0], environment(ME)); // Suche Obj im Raum
		if (who && who->QueryProp(P_INVIS) && !IS_LEARNING(ME))
			who=r_vic=r_find=0; // keine Invis!
		if (who) words=words[1..]; // Opfer gefunden - wenn's eines gibt
	}
	if (sizeof(words)) ParseAdverb(words);
	if (flag&NEED_VIC) return !!who||for_all||(r_vic==1&&who=ME);
	// Return 1 wenn Opfer gefunden, wenn ein an-alle Kommando oder
	// wenns ein r-Kommando ist, zu dem das Opfer _fehlt_. Letztes
    // ist erforderlich, damit nicht die Standardmeldung zum fehlenden
	// Opfer kommt, sondern wir eine Chance haben in FeelIt zu pruefen,
	// ob der Spieler das CMD ueberhaupt besitzt.

	return 1;
}

// Diese Funktion fuellt aus dem Array of Strings words die globale
// Variable adverb
private void ParseAdverb(string *words) {
	int num, i, komma;
	string qadv, *adv, tmp;
  
	adv=({});
	qadv=0;
	words-=({ "" });
  
	// So, wir versuchen jetzt immer abwechselnd ein Adverb-Kuerzel
	// und "und" zu erkennen. Wenn das fehlschlaegt ist ab der Stelle
	// automatisch ein '/', also quoted adverb.
	for (num=sizeof(words), i=0; i<num; i++) {
		if (words[i][0]=='/') {
			words[i]=words[i][1..];
			qadv=implode(words[i..], " ");
			break;
		}
		if (words[i][<1]==',') {
			komma=1;
			words[i]=words[i][0..<2];
		}
		tmp=plr_adverbs[words[i]] || QueryStdAdverbs()[words[i]];
		if (tmp) { // Adverbkuerzel erkannt
			if (i==num-1 || komma) { // letztes wort oder komma
				adv+=({ tmp });
				continue;
			} else if (words[i+1]=="und" || words[i+1]==",") {
				adv+=({ tmp });
				i++; // 'und' uebergehen;
				continue;
			}
		}
		// Wort nicht als Kuerzel erkannt: quoten
		qadv=implode(words[i..], " ");
		break;
	}
	if (qadv) adv+=({ qadv });
	adverb=CountUp(adv);
	if (adverb=="") adverb=0;
}

// Diese Funktion wandelt ein Array of Strings in einen String um,
// wo die Elemente mit Kommata und das letzte mit 'und' voneinander
// getrennt sind. Diese Funktion nicht private, da sie oft von
// aussen 'missbraucht' wird.
string CountUp(string *foo) {  // Diese Idee abgekupfert von Marcus@TAPP
	switch (sizeof(foo)) {
	case 0: 
		return 0;
	case 1:
		return foo[0];
	}
	return implode(foo[0..<2], ", ")+" und "+foo[<1];
}

// Diese Funktion verwaltet die Ausgabe, wenn man an alle Lebewesen im
// Raum etwas macht (niemals remote)
private int MixedOut(int casus) {
	object *envs, *vics;
	string *names, *rnames, out, aufz;
	int count, i;
	for_all=0;
	vics=({});
	names=({});
	envs=all_inventory(environment())-({ME});
	if (!sizeof(envs))
		RETURN("Nichts und niemand da. Schau Dich naechstes Mal besser um.\n");
	for (count=0; count<sizeof(envs); count++)
		if (living(envs[count]) && (!envs[count]->QueryProp(P_INVIS) ||
			IS_LEARNING(ME))) {
			vics+=({envs[count]});
			names+=({envs[count]->name(casus, 2)});
		}
	if (!sizeof(vics))
		RETURN("Keiner da. Schau Dich naechstes Mal besser um.\n");
	aufz=CountUp(names-({0}));
	for (count=0; count<sizeof(vics); count++) {
		for (rnames=({}),i=0;i<sizeof(names);i++)
			if (i!=count) rnames+=({names[i]});
			else rnames+=({capitalize(vics[count]->QueryDu(casus))});

		out=implode(explode(out_vic, "@@alle@@"),CountUp(rnames-({0})));
		tell_object(vics[count], break_string(convert_string(out+"\n")));
	}
	write(break_string(convert_string(implode(explode(out_sel, "@@alle@@"),
		aufz)+"\n")));
	if (verb) say( ({ KEYWORD, ME, 1, verb, adverb }) );
	return 1;
}

// Diese Funktion ist fuer Routinetests...
private int CheckLife(string not_self_text, string not_dead_text) {
	if (!who) return 0;
	if (not_self_text && who==ME) {
		write(not_self_text+"\n");
		return 1;
	}
	if (not_dead_text && !living(who)) {
		write(not_dead_text+"\n");
		return 2;
	}
	return 0;
}

// Ich bin unschuldig, ich hatte das viel einfacher und schoener :)
// Rumata wollte das so ;)  -HrT
varargs string convert_string(string str, int is_wiz) {
        string iname;
        if(QueryProp(P_INVIS) && is_wiz)
          iname=" ("+capitalize(getuid())+")";
	str = implode(efun::explode(str, "@@Name@@"), 
		  ME->QueryProp(P_GHOST)?"Der Geist von "+ME->name(WER,2):
		  capitalize(ME->name(WER,2))+(iname?iname:""));
	str = implode(efun::explode(str, "@@name@@"), 
		  ME->name(WER,2)+(iname?iname:""));
	str = implode(efun::explode(str, "@@wer@@"),
		  (who?capitalize(who->name(WER,2)):""));
	str = implode(efun::explode(str, "@@ wen@@"),
		  (who?" "+who->name(WEN,2):""));
	str = implode(efun::explode(str, "@@ wem@@"),
		  (who?" "+who->name(WEM,2):""));
	str = implode(efun::explode(str, "@@wen@@"),
		  (who?who->name(WEN,2):""));
	str = implode(efun::explode(str, "@@wem@@"),
		  (who?who->name(WEM,2):""));
	str = implode(efun::explode(str, "@@wessen@@"),
		  (who?who->name(WESSEN,2):""));
	str = implode(efun::explode(str, "@@adverb@@"),
		  (adverb?" "+adverb:"")+
		  (r_find?" aus der Ferne":(r_vic?" in der Ferne":"")));
	str = implode(efun::explode(str, "@@fern@@"),
		  (r_vic?" aus der Ferne":""));
	return str;
}

// Hier wird bei Bedarf eine grosse Denkblase erzeugt
string bubble(string text, string pre) {
	int max, i, j, k, p;
	string* strs;
	p=strlen(pre);
	if (p>40) return 0;
	max=BS_STDLEN-(p+4);
	if (strlen(text)<=max) return sprintf("%s( %s )", pre, text);
	strs=efun::explode(sprintf("%=-*s", max, text), "\n");
	max=0; // breiteste Stelle suchen...
	for (i=j=sizeof(strs);i--;) if ((k=strlen(strs[i]))>max) max=k;
	for (i=j--; i--;) {
		if (i==j) { // unterste Zeile
			strs[i]=sprintf("%s( %-*s )", pre, max, strs[i]);
		} else {
			strs[i]=sprintf("%*s( %-*s )", p, "", max, strs[i]);
		}
	}
	return implode(strs, "\n");
}

// Diese Funktion gibt die Gefuehle an die entsprechenden Objecte aus
// xarg wird statt adverb an Netti gegeben, wenn gesetzt (fuer frag etc)
varargs int FeelIt(string xarg) {
	int npc;
	object r_obj;
	if (r_vic) {
		mapping x;
		x=QueryProp(P_REMOTECMDS);
		if (!pointerp(x) || (member(x, verb)==-1 && member(x, "alle")==-1)) {
			verb_found=0; // Spieler besitzt Fernverb nicht
			return 0;
		}
		if (r_vic==1) return 0; // Kein Opfer gefunden
		r_obj=find_living(r_vic);
		if (!r_obj ||
			(query_once_interactive(r_obj) && !interactive(r_obj)))
			RETURN(capitalize(r_vic)+" nicht gefunden.\n");
		if (present(r_obj, environment())) r_obj=r_vic=0;
	}
	npc=QueryProp(P_NPC);

	// Meldung an Opfer (wenn vorhanden)
	if (objectp(who) && stringp(out_vic)) {
		if (r_obj && r_obj!=who) return 0; // RUNZEL
		if (query_once_interactive(who) && !npc) {
			if(who->Message(convert_string(out_vic,IS_LEARNER(who))+"\n", verb)==-1) {
				write(capitalize(who->name(WER,1))+
					" ignoriert Dich oder diesen Befehl.\n");
				return 1;
			}
		} else { // NPCs koennen nicht ignoriert werden
			tell_object(who, convert_string(out_vic)+"\n");
		}
	}

	// Meldung an Umstehende oder entfernten Zuschauer
	if (stringp(out_oth)) {
		if (!r_obj) say(convert_string(out_oth)+"\n", ({who,ME}));
		else if (!who && r_obj->Message(convert_string(out_oth)+"\n", verb)==-1) {
			write(capitalize(r_obj->name(WER,1))+
				" ignoriert Dich oder diesen Befehl.\n");
			return 1;
		}
	}

	// Meldung an einen selbst
	if (!npc) write(convert_string(out_sel)+"\n");

	if (stringp(xarg)) adverb=xarg;
	if (!npc && !r_obj) say( ({ KEYWORD, ME, who, verb, adverb }) );
	out_sel=0;
	out_vic=0;
	out_oth=0;
	return 1;
}

/* Die Routine zeige_adverbs ist im ersten Teil abgekupfert aus der exsoul aus
   TAPPMud, d.h. ist wahrscheinlich von Ereborn (ereborn@opal.cs.tu-berlin.de),
   von dem die urspruengliche exsoul stammt.
   Hm, Korrektur: So, wie sie da steht, stammt einiges von Marcus@TAPP.
   Das neu zu programmieren hatte ich wirklich keine Lust. Wieso sollte
   ich auch das Rad neu erfinden, die Routine ist gut.      -Highlander
   */
private int zeige_adverbs(int mine) {
	int s,i;
	mixed *sort_arr,*ix;
	string *out;
	mapping m;
	if (mine==1)
		ix=m_indices(m=plr_adverbs);
	else if (mine==2)
		ix=m_indices(m=QueryStdAdverbs());
	else
		ix=m_indices(m=QueryStdAdverbs()+plr_adverbs);
	sort_arr=({ ({}), ({}) });
	for (i=sizeof(m)-1; i>=0; i--) {
		string tmp1,tmp2;
		sort_arr[0]+=({ ix[i][2]+ix[i][1]*256+ix[i][0]*65536 });
		sort_arr[1]+=({ ix[i] });
	}
	sort_arr = order_alist(sort_arr);
	sort_arr = sort_arr[1];
	out=allocate(sizeof(sort_arr)+1);
	out[0]="Abk.   Adverb\n";
	for (i=0;i<sizeof(sort_arr);i++) {
		out[i+1]=
			extract(sort_arr[i]+"_________________",0,6)+
			(m[sort_arr[i]]+
			"                                                                            ")[0..70]+"\n";
	}
	verb_out=out;
	write(break_string(
		"Mehrere Adverbien koennen mit 'und' oder Kommata aneinandergereiht werden.\n"
		"Bsp: grinse froe, frec und jofi\n"
		"Ausserdem kann man irgendwann einen / setzen. Alles, was danach "
		"kommt, wird wie ein Adverb angehaengt (sofern das Verb Adverbien "
		"unterstuetzt).\n"
		"Bsp: grins /wie zwei Voegel im Wind\n"
		"Frage mich jetzt keiner, was das heissen soll :>     Have fun,\n"
		"                                             Highlander ryn Tahar\n"
		"                              (--RETURN--)\n"));
	input_to("zeige_adverbs_2");
	return 1;
}

int zeige_adverbs_2(string foo) {
	More(implode(verb_out,""));
	verb_out=0;
	return 1;
}

// Diese Funktion verlallt einen String. Sie wird auch von anderen Moduln
// des Spielers aufgerufen.
varargs string slurr(string str, int alc) {
	// Funktion lallt. alc ist Alkoholgehalt in % (optional)
	// 60-69%  abschleifen, ein paar doppelungen
	// 70-79%  mehr doppelungen
	// 80-89%  wortersetzungen
	// 90%-    wortauslassungen
	string ret, sub, *worte;
	int i, len, x, old, h, hh;
	ret="";
	if (alc<=0) alc=(ME->QueryProp(P_ALCOHOL)*100)/ME->QueryProp(P_MAX_ALCOHOL);
	if (alc<60) return str;
	if (alc>=70) h=1; // mehr verdoppelungen
	if (alc>=80) { // wortbearbeitung
		if (alc>=90) hh=1; // auslassungen
		worte=regexplode(str, "[^a-z^A-Z]");
		len=sizeof(worte);
		for (i=0; i<len; i++) {
			sub=0;
			switch (lower_case(worte[i])) {
			case "du":
				sub="duuu";
				break;
			case "und":
				if (hh) sub="";
				else sub="unn";
				break;
			case "mir":
				sub="mich";
				break;
			case "dir":
				sub="dich";
				break;
			case "mal":
				sub="sofort";
				break;
			case "irgendwann":
				sub="jetzt";
				break;
			case "dein":
			case "deine":
			case "deines":
				sub="mein";
				break;
			case ",":
			case ".":
			case "der":
			case "die":
			case "das":
			case "ein":
			case "eine":
			case "einen":
			case "ja":
				if (hh) sub="";
				break;
			case "mag":
			case "lieb":
			case "liebe":
				sub="will";
				break;
			case "mach":
			case "macht":
			case "mache":
			case "machst":
				sub="tuh";
				break;
			case "ist":
			case "sind":
				if (hh) sub="";
				else sub="ist";
				break;
			case "zur":
				sub="zum";
				break;
			case "find":
			case "finde":
			case "findest":
			case "findet":
				sub="n";
				break;
			case "hab":
			case "habe":
			case "hast":
			case "hat":
				sub="will";
				break;
			case "bei":
				sub="an";
				break;
			}
			if (sub) {
				if (sub=="") {
					worte[i]="";
					if (i+1<len) worte[i+1]="";
				} else {
					if (!(worte[i][0]&~32)) // gross
						sub[0]|=32; // auch gross
					worte[i]=sub;
				}
			}
		}
		worte-=({""});
		if (sizeof(worte)==0) worte=({"grmm"});
		str=implode(worte, "");
	}
	len=strlen(str);
	for (i=0; i<len; i++) {
		sub="";
		switch ((old=str[i])|32) {
		case 's':
			x=str[i+1]|32;
			if (x=='t') { // st -> ss(s)
				sub="ss";
				if (h && !random(2)) sub+="s";
				i++;
			} else if (x==' ' || x==0) { // s -> sch
				sub="sch";
			} else { // ss -> sss(s)
				if (x=='s') {
					sub="s";
					i++;
				}
				sub+="ss";
				if (h && !random(2)) sub+="s";
			}
			break;
		case 't':
			if ((x=str[i+1])==' ' || x==0) {
				sub=" ";
				i++;
			} else sub="d"; // t -> d
			break;
		case 'w':
			if (h) sub="ww"; // w -> ww
			break;
		case 'c':
			x=str[i+1]|32;
			if (x=='k') { // ck -> ch
				sub="ch";
				i++;
			} else if (x=='h') { // ch -> chs
				sub="chs";
				i++;
			}
			break;
		case 'u': // u -> u(h) oder uuh
		case 'a':
		case 'i':
		case 'e':
		case 'o':
			if (h && !random(2)) {
				sub=sprintf("%c%c", old|32, old|32);
				if (((x=str[i+1])==' ' || x==0) && random(3)) sub+="h";
			} else if (((x=str[i+1])==' ' || x==0) && !random(2)) {
				sub=sprintf("%ch", old|32);
			}
			break;
		case 'p': // p -> ff
			if (h && random(4)) sub="ff";
			break;
		case 'k': // k -> g(h)
			if (random(3)) sub="g";
			if (h && random(3)) sub+="gh";
			break;
		case 'l': // l -> ll(ll)
			if (!h) break;
			if (random(3)) sub="ll";
			if (!random(3)) sub+="l";
			if (!random(3)) sub+="l";
			if (str[i+1]=='l' && sub!="") i++;
			break;
		case 'm': // m -> mh
		case 'n':
			if (h && !random(3)) sub="mh";
			break;
		case 'q': // q -> g
			sub="g";
			break;
		case 'r': // r -> rr(rr)
			if (random(3)) sub="rr";
			if (!h) break;
			if (!random(3)) sub+="r";
			if (!random(3)) sub+="r";
			break;
		case 'v': // v -> ff(f)
		case 'f':
			if (!h) break;
			sub="ff";
			if (!random(3)) sub+="f";
			break;
		case 'x': // x -> chs
			sub="chs";
			break;
		case 'y': // y -> i
			sub="i";
			break;
		case 'z': // z -> sss
			sub="sss";
			break;
		case '!': // ! -> !!
			if (h) sub="!!";
			break;
		} 
		if (sub!="") {
			if (!(old&32)) sub[0]=~32&sub[0];
			// Alter Buchstabe gross -> neuer auch gross
			ret+=sub;
		} else {
			ret+=sprintf("%c", str[i]);
		}
	}
	if (!random(3)) { // hickser einbauen
		worte=efun::explode(ret, " ");
		if ((len=sizeof(worte))>1) {
			i=random(len);
			worte=worte[0..i]+({"hicks"})+worte[i+1..];
			ret=implode(worte, " ");
		}
	}
	return ret;
}

private mapping QueryStdAdverbs() {
	return ([ 
		"unve" : "unverschaemt",
		"gutg" : "gutgelaunt",
		"gutm" : "gutmuetig",
		"froh" : "froh",
		"glue" : "gluecklich",
		"wuet" : "wuetend",
		"frec" : "frech",
		"daem" : "daemonisch",
		"boes" : "boese",
		"ungl" : "ungluecklich",
		"lang" : "langsam",
		"schn" : "schnell",
		"jamm" : "jammernd",
		"freu" : "freundlich",
		"shue" : "schuechtern",
		"amue" : "amuesiert",
		"aerg" : "aergerlich",
		"aner" : "anerkennend",
		"erst" : "erstaunt",
		"bitt" : "bitter",
		"brei" : "breit",
		"vors" : "vorsichtig",
		"char" : "charmant",
		"kalt" : "kalt",
		"verf" : "verfuehrerisch",
		"zufr" : "zufrieden",
		"tief" : "tief",
		"verz" : "verzweifelt",
		"drec" : "dreckig",
		"vert" : "vertraeumt",
		"uebe" : "ueberzeugt",
		"frus" : "frustriert",
		"stra" : "strahlend",
		"hoff" : "hoffnungsvoll",
		"unge" : "ungeduldig",
		"unsi" : "unsinnigerweise",
		"unsc" : "unschuldig",
		"unwi" : "unwissend",
		"iron" : "ironisch",
		"wiss" : "wissend",
		"gema" : "gemaechlich",
		"sehn" : "sehnsuechtig",
		"laut" : "laut",
		"lieb" : "liebevoll",
		"froe" : "froehlich",
		"dank" : "dankbar",
		"natu" : "natuerlich",
		"gedu" : "geduldig",
		"perf" : "perfekt",
		"vers" : "verspielt",
		"hoef" : "hoeflich",
		"stol" : "stolz",
		"frag" : "fragend",
		"rupp" : "ruppig",
		"trau" : "traurig",
		"vera" : "veraechtlich",
		"scha" : "schamlos",
		"erns" : "ernst",
		"schu" : "schuechtern",
		"zaer" : "zaertlich",
		"sanf" : "sanft",
		"entg" : "entgeistert",
		"heim" : "heimtueckisch",
		"gela" : "gelangweilt",
		"wild" : "wild",
		"jofi" : "wie Jof, wenn er mal nicht idlet",
		]);
}

private mapping QueryAdverbs() {
  return copy_mapping(plr_adverbs);
}

