/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: soulhelp.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// MD MUDlib
// basierend auf Wunderland MUDlib
//
// /STD/PLAYER/SOULHELP.C --- helpfunctions for playersoul
//
/*
 * $Date: 1999/11/05 12:30:47 $
 * $Revision: 1.1.1.1 $
 * $Log: soulhelp.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:13  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/09/06 20:12:30  Largo
 * Initial revision
 *
 */

#include <wizlevels.h>
#include <defines.h>

string *wizcmds, *plrcmds, *ghostcmds;

static mixed *SortIt(string *arr);

void create()
{
  plrcmds=({
    "zuck", "schmieg", "antworte", "applaudiere",
    "betaste", "cls", "drehe (daeumchen)", "danke",
    "druecke", "erroete", "flippe", "frage",
    "furze", "gaehne", "gluckse", "grinse",
    "guck", "haetschel", "hickse", "huepfe",
    "huste", "keuche", "kichere", "klatsche",
    "knabbere", "knickse", "knirsche", "knurre",
    "knutsche", "kotze", "kuesse", "lache",
    "laechle", "liebe", "nicke", "niese",
    "gib", "pfeife", "ruelpse", "runzle",
    "schmolle", "schmunzle", "schnippe", "schnarche",
    "schnurre", "schreie", "schuettle", "seufze",
    "singe", "sniefe/schniefe", "spucke", "starre",
    "staune", "stiere", "stoehne", "stosse",
    "streichle", "tanze", "tritt", "troeste",
    "umarme", "verneige", "wackle", "waelze",
    "weine", "winke", "zwinkere", "verben",
    "aechze", "erbleiche", "fluche", "verfluche",
    "kitzle", "nein", "deute", "zeige",
    "denke", "knuddle", "taetschel", "wuschel",
    "strecke ... [die] zunge raus", "kratz",
    "grummel", "juble / juble ... [zu]", "wuerg",
    "gratuliere / beglueckwuensche", "raeusper",
    "argl", "rotfl", "grunz", "kuschel", "atme ... auf",
    "gruebel","klopfe (jemandem auf die Schulter)",
    "huestel","schnaube","schneuze","schaeme",
    "kneife","jammer","stupse","pruste"
  });
  wizcmds=({
    "splash", "flame",
  });
  ghostcmds=({
    "rassel/rassle", "heule",
  });
}

string Help()
{
  string out;
  out="";
  out+=break_string("Standardverben:\n"+implode(SortIt(plrcmds), ", ")+".");
  if(IS_WIZARD(this_player()))
    out+="\n"+break_string("Magierverben:\n"+implode(SortIt(wizcmds), ", ")+
			   ".");
  if(this_player()->ghost())
    out+="\n"+break_string("Geisterverben:\n"+implode(SortIt(ghostcmds), 
						      ", ")+".");
  return out+"\n"+break_string(
    "Einige Befehle reagieren auch auf leicht unterschiedliche "
    "Schreibweise. Diese Befehlsliste ist dynamisch und passt sich "
    "Deinem Status an.");
}

static mixed *SortIt(string *arr)
{
  int i;
  mixed *sort_arr;
  string *ix;
  sort_arr=({ ({}), ({}) });
  ix=arr;
  for(i=sizeof(ix)-1; i>=0; i--)
    {
      sort_arr[0]+=({ ix[i][2]+ix[i][1]*256+ix[i][0]*65536 });
      sort_arr[1]+=({ ix[i] });
    }
  sort_arr = order_alist(sort_arr);
  sort_arr = sort_arr[1];
  return sort_arr;
}
